/**
 * Framework7 8.3.3
 * Full featured mobile HTML framework for building iOS & Android apps
 * https://framework7.io/
 *
 * Copyright 2014-2024 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: March 25, 2024
 */

!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).Framework7=t()}(this,(function(){"use strict";function e(e){return null!==e&&"object"==typeof e&&"constructor"in e&&e.constructor===Object}function t(a,r){void 0===a&&(a={}),void 0===r&&(r={}),Object.keys(r).forEach((s=>{void 0===a[s]?a[s]=r[s]:e(r[s])&&e(a[s])&&Object.keys(r[s]).length>0&&t(a[s],r[s])}))}const a={body:{},addEventListener(){},removeEventListener(){},activeElement:{blur(){},nodeName:""},querySelector:()=>null,querySelectorAll:()=>[],getElementById:()=>null,createEvent:()=>({initEvent(){}}),createElement:()=>({children:[],childNodes:[],style:{},setAttribute(){},getElementsByTagName:()=>[]}),createElementNS:()=>({}),importNode:()=>null,location:{hash:"",host:"",hostname:"",href:"",origin:"",pathname:"",protocol:"",search:""}};function r(){const e="undefined"!=typeof document?document:{};return t(e,a),e}const s={document:a,navigator:{userAgent:""},location:{hash:"",host:"",hostname:"",href:"",origin:"",pathname:"",protocol:"",search:""},history:{replaceState(){},pushState(){},go(){},back(){}},CustomEvent:function(){return this},addEventListener(){},removeEventListener(){},getComputedStyle:()=>({getPropertyValue:()=>""}),Image(){},Date(){},screen:{},setTimeout(){},clearTimeout(){},matchMedia:()=>({}),requestAnimationFrame:e=>"undefined"==typeof setTimeout?(e(),null):setTimeout(e,0),cancelAnimationFrame(e){"undefined"!=typeof setTimeout&&clearTimeout(e)}};function o(){const e="undefined"!=typeof window?window:{};return t(e,s),e}class n extends Array{constructor(e){"number"==typeof e?super(e):(super(...e||[]),function(e){const t=e.__proto__;Object.defineProperty(e,"__proto__",{get:()=>t,set(e){t.__proto__=e}})}(this))}}function i(e){void 0===e&&(e=[]);const t=[];return e.forEach((e=>{Array.isArray(e)?t.push(...i(e)):t.push(e)})),t}function l(e,t){return Array.prototype.filter.call(e,t)}function c(e,t){const a=o(),s=r();let i=[];if(!t&&e instanceof n)return e;if(!e)return new n(i);if("string"==typeof e){const a=e.trim();if(a.indexOf("<")>=0&&a.indexOf(">")>=0){let e="div";0===a.indexOf("<li")&&(e="ul"),0===a.indexOf("<tr")&&(e="tbody"),0!==a.indexOf("<td")&&0!==a.indexOf("<th")||(e="tr"),0===a.indexOf("<tbody")&&(e="table"),0===a.indexOf("<option")&&(e="select");const t=s.createElement(e);t.innerHTML=a;for(let e=0;e<t.childNodes.length;e+=1)i.push(t.childNodes[e])}else i=function(e,t){if("string"!=typeof e)return[e];const a=[],r=t.querySelectorAll(e);for(let e=0;e<r.length;e+=1)a.push(r[e]);return a}(e.trim(),t||s)}else if(e.nodeType||e===a||e===s)i.push(e);else if(Array.isArray(e)){if(e instanceof n)return e;i=e}return new n(function(e){const t=[];for(let a=0;a<e.length;a+=1)-1===t.indexOf(e[a])&&t.push(e[a]);return t}(i))}c.fn=n.prototype;const p="resize scroll".split(" ");function d(e){return function(){for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];if(void 0===a[0]){for(let t=0;t<this.length;t+=1)p.indexOf(e)<0&&(e in this[t]?this[t][e]():c(this[t]).trigger(e));return this}return this.on(e,...a)}}const u=d("click"),h=d("blur"),m=d("focus"),f=d("focusin"),g=d("focusout"),v=d("keyup"),b=d("keydown"),w=d("keypress"),y=d("submit"),C=d("change"),E=d("mousedown"),k=d("mousemove"),$=d("mouseup"),x=d("mouseenter"),T=d("mouseleave"),S=d("mouseout"),P=d("mouseover"),M=d("touchstart"),O=d("touchend"),I=d("touchmove"),B=d("resize"),L=d("scroll");var D=Object.freeze({__proto__:null,$:c,add:function(){const e=this;let t,a;for(var r=arguments.length,s=new Array(r),o=0;o<r;o++)s[o]=arguments[o];for(t=0;t<s.length;t+=1){const r=c(s[t]);for(a=0;a<r.length;a+=1)e.push(r[a])}return e},addClass:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];const r=i(t.map((e=>e.split(" "))));return this.forEach((e=>{e.classList.add(...r)})),this},animate:function(e,t){const a=o(),r=this,s={props:Object.assign({},e),params:Object.assign({duration:300,easing:"swing"},t),elements:r,animating:!1,que:[],easingProgress:(e,t)=>"swing"===e?.5-Math.cos(t*Math.PI)/2:"function"==typeof e?e(t):t,stop(){s.frameId&&a.cancelAnimationFrame(s.frameId),s.animating=!1,s.elements.each((e=>{delete e.dom7AnimateInstance})),s.que=[]},done(e){if(s.animating=!1,s.elements.each((e=>{delete e.dom7AnimateInstance})),e&&e(r),s.que.length>0){const e=s.que.shift();s.animate(e[0],e[1])}},animate(e,t){if(s.animating)return s.que.push([e,t]),s;const o=[];s.elements.each(((t,r)=>{let n,i,l,c,p;t.dom7AnimateInstance||(s.elements[r].dom7AnimateInstance=s),o[r]={container:t},Object.keys(e).forEach((s=>{n=a.getComputedStyle(t,null).getPropertyValue(s).replace(",","."),i=parseFloat(n),l=n.replace(i,""),c=parseFloat(e[s]),p=e[s]+l,o[r][s]={initialFullValue:n,initialValue:i,unit:l,finalValue:c,finalFullValue:p,currentValue:i}}))}));let n,i,l=null,c=0,p=0,d=!1;return s.animating=!0,s.frameId=a.requestAnimationFrame((function u(){let h,m;n=(new Date).getTime(),d||(d=!0,t.begin&&t.begin(r)),null===l&&(l=n),t.progress&&t.progress(r,Math.max(Math.min((n-l)/t.duration,1),0),l+t.duration-n<0?0:l+t.duration-n,l),o.forEach((a=>{const r=a;i||r.done||Object.keys(e).forEach((a=>{if(i||r.done)return;h=Math.max(Math.min((n-l)/t.duration,1),0),m=s.easingProgress(t.easing,h);const{initialValue:d,finalValue:u,unit:f}=r[a];r[a].currentValue=d+m*(u-d);const g=r[a].currentValue;(u>d&&g>=u||u<d&&g<=u)&&(r.container.style[a]=u+f,p+=1,p===Object.keys(e).length&&(r.done=!0,c+=1),c===o.length&&(i=!0)),i?s.done(t.complete):r.container.style[a]=g+f}))})),i||(s.frameId=a.requestAnimationFrame(u))})),s}};if(0===s.elements.length)return r;let n;for(let e=0;e<s.elements.length;e+=1)s.elements[e].dom7AnimateInstance?n=s.elements[e].dom7AnimateInstance:s.elements[e].dom7AnimateInstance=s;return n||(n=s),"stop"===e?n.stop():n.animate(s.props,s.params),r},animationEnd:function(e){const t=this;return e&&t.on("animationend",(function a(r){r.target===this&&(e.call(this,r),t.off("animationend",a))})),this},append:function(){let e;const t=r();for(let a=0;a<arguments.length;a+=1){e=a<0||arguments.length<=a?void 0:arguments[a];for(let a=0;a<this.length;a+=1)if("string"==typeof e){const r=t.createElement("div");for(r.innerHTML=e;r.firstChild;)this[a].appendChild(r.firstChild)}else if(e instanceof n)for(let t=0;t<e.length;t+=1)this[a].appendChild(e[t]);else this[a].appendChild(e)}return this},appendTo:function(e){return c(e).append(this),this},attr:function(e,t){if(1===arguments.length&&"string"==typeof e)return this[0]?this[0].getAttribute(e):void 0;for(let a=0;a<this.length;a+=1)if(2===arguments.length)this[a].setAttribute(e,t);else for(const t in e)this[a][t]=e[t],this[a].setAttribute(t,e[t]);return this},blur:h,change:C,children:function(e){const t=[];for(let a=0;a<this.length;a+=1){const r=this[a].children;for(let a=0;a<r.length;a+=1)e&&!c(r[a]).is(e)||t.push(r[a])}return c(t)},click:u,closest:function(e){let t=this;return void 0===e?c([]):(t.is(e)||(t=t.parents(e).eq(0)),t)},css:function(e,t){const a=o();let r;if(1===arguments.length){if("string"!=typeof e){for(r=0;r<this.length;r+=1)for(const t in e)this[r].style[t]=e[t];return this}if(this[0])return a.getComputedStyle(this[0],null).getPropertyValue(e)}if(2===arguments.length&&"string"==typeof e){for(r=0;r<this.length;r+=1)this[r].style[e]=t;return this}return this},data:function(e,t){let a;if(void 0===t){if(a=this[0],!a)return;if(a.dom7ElementDataStorage&&e in a.dom7ElementDataStorage)return a.dom7ElementDataStorage[e];const t=a.getAttribute(`data-${e}`);return t||void 0}for(let r=0;r<this.length;r+=1)a=this[r],a.dom7ElementDataStorage||(a.dom7ElementDataStorage={}),a.dom7ElementDataStorage[e]=t;return this},dataset:function(){const e=this[0];if(!e)return;const t={};if(e.dataset)for(const a in e.dataset)t[a]=e.dataset[a];else for(let r=0;r<e.attributes.length;r+=1){const s=e.attributes[r];s.name.indexOf("data-")>=0&&(t[(a=s.name.split("data-")[1],a.toLowerCase().replace(/-(.)/g,((e,t)=>t.toUpperCase())))]=s.value)}var a;for(const e in t)"false"===t[e]?t[e]=!1:"true"===t[e]?t[e]=!0:parseFloat(t[e])===1*t[e]&&(t[e]*=1);return t},default:c,detach:function(){return this.remove()},each:function(e){return e?(this.forEach(((t,a)=>{e.apply(t,[t,a])})),this):this},empty:function(){for(let e=0;e<this.length;e+=1){const t=this[e];if(1===t.nodeType){for(let e=0;e<t.childNodes.length;e+=1)t.childNodes[e].parentNode&&t.childNodes[e].parentNode.removeChild(t.childNodes[e]);t.textContent=""}}return this},eq:function(e){if(void 0===e)return this;const t=this.length;if(e>t-1)return c([]);if(e<0){const a=t+e;return c(a<0?[]:[this[a]])}return c([this[e]])},filter:function(e){return c(l(this,e))},find:function(e){const t=[];for(let a=0;a<this.length;a+=1){const r=this[a].querySelectorAll(e);for(let e=0;e<r.length;e+=1)t.push(r[e])}return c(t)},focus:m,focusin:f,focusout:g,hasClass:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];const r=i(t.map((e=>e.split(" "))));return l(this,(e=>r.filter((t=>e.classList.contains(t))).length>0)).length>0},height:function(){const e=o();return this[0]===e?e.innerHeight:this.length>0?parseFloat(this.css("height")):null},hide:function(){for(let e=0;e<this.length;e+=1)this[e].style.display="none";return this},html:function(e){if(void 0===e)return this[0]?this[0].innerHTML:null;for(let t=0;t<this.length;t+=1)this[t].innerHTML=e;return this},index:function(){let e,t=this[0];if(t){for(e=0;null!==(t=t.previousSibling);)1===t.nodeType&&(e+=1);return e}},insertAfter:function(e){const t=c(e);for(let e=0;e<this.length;e+=1)if(1===t.length)t[0].parentNode.insertBefore(this[e],t[0].nextSibling);else if(t.length>1)for(let a=0;a<t.length;a+=1)t[a].parentNode.insertBefore(this[e].cloneNode(!0),t[a].nextSibling)},insertBefore:function(e){const t=c(e);for(let e=0;e<this.length;e+=1)if(1===t.length)t[0].parentNode.insertBefore(this[e],t[0]);else if(t.length>1)for(let a=0;a<t.length;a+=1)t[a].parentNode.insertBefore(this[e].cloneNode(!0),t[a])},is:function(e){const t=o(),a=r(),s=this[0];let i,l;if(!s||void 0===e)return!1;if("string"==typeof e){if(s.matches)return s.matches(e);if(s.webkitMatchesSelector)return s.webkitMatchesSelector(e);if(s.msMatchesSelector)return s.msMatchesSelector(e);for(i=c(e),l=0;l<i.length;l+=1)if(i[l]===s)return!0;return!1}if(e===a)return s===a;if(e===t)return s===t;if(e.nodeType||e instanceof n){for(i=e.nodeType?[e]:e,l=0;l<i.length;l+=1)if(i[l]===s)return!0;return!1}return!1},keydown:b,keypress:w,keyup:v,mousedown:E,mouseenter:x,mouseleave:T,mousemove:k,mouseout:S,mouseover:P,mouseup:$,next:function(e){return this.length>0?e?this[0].nextElementSibling&&c(this[0].nextElementSibling).is(e)?c([this[0].nextElementSibling]):c([]):this[0].nextElementSibling?c([this[0].nextElementSibling]):c([]):c([])},nextAll:function(e){const t=[];let a=this[0];if(!a)return c([]);for(;a.nextElementSibling;){const r=a.nextElementSibling;e?c(r).is(e)&&t.push(r):t.push(r),a=r}return c(t)},off:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];let[r,s,o,n]=t;"function"==typeof t[1]&&([r,o,n]=t,s=void 0),n||(n=!1);const i=r.split(" ");for(let e=0;e<i.length;e+=1){const t=i[e];for(let e=0;e<this.length;e+=1){const a=this[e];let r;if(!s&&a.dom7Listeners?r=a.dom7Listeners[t]:s&&a.dom7LiveListeners&&(r=a.dom7LiveListeners[t]),r&&r.length)for(let e=r.length-1;e>=0;e-=1){const s=r[e];o&&s.listener===o||o&&s.listener&&s.listener.dom7proxy&&s.listener.dom7proxy===o?(a.removeEventListener(t,s.proxyListener,n),r.splice(e,1)):o||(a.removeEventListener(t,s.proxyListener,n),r.splice(e,1))}}}return this},offset:function(){if(this.length>0){const e=o(),t=r(),a=this[0],s=a.getBoundingClientRect(),n=t.body,i=a.clientTop||n.clientTop||0,l=a.clientLeft||n.clientLeft||0,c=a===e?e.scrollY:a.scrollTop,p=a===e?e.scrollX:a.scrollLeft;return{top:s.top+c-i,left:s.left+p-l}}return null},on:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];let[r,s,o,n]=t;function i(e){const t=e.target;if(!t)return;const a=e.target.dom7EventData||[];if(a.indexOf(e)<0&&a.unshift(e),c(t).is(s))o.apply(t,a);else{const e=c(t).parents();for(let t=0;t<e.length;t+=1)c(e[t]).is(s)&&o.apply(e[t],a)}}function l(e){const t=e&&e.target&&e.target.dom7EventData||[];t.indexOf(e)<0&&t.unshift(e),o.apply(this,t)}"function"==typeof t[1]&&([r,o,n]=t,s=void 0),n||(n=!1);const p=r.split(" ");let d;for(let e=0;e<this.length;e+=1){const t=this[e];if(s)for(d=0;d<p.length;d+=1){const e=p[d];t.dom7LiveListeners||(t.dom7LiveListeners={}),t.dom7LiveListeners[e]||(t.dom7LiveListeners[e]=[]),t.dom7LiveListeners[e].push({listener:o,proxyListener:i}),t.addEventListener(e,i,n)}else for(d=0;d<p.length;d+=1){const e=p[d];t.dom7Listeners||(t.dom7Listeners={}),t.dom7Listeners[e]||(t.dom7Listeners[e]=[]),t.dom7Listeners[e].push({listener:o,proxyListener:l}),t.addEventListener(e,l,n)}}return this},once:function(){const e=this;for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];let[s,o,n,i]=a;function l(){for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];n.apply(this,a),e.off(s,o,l,i),l.dom7proxy&&delete l.dom7proxy}return"function"==typeof a[1]&&([s,n,i]=a,o=void 0),l.dom7proxy=n,e.on(s,o,l,i)},outerHeight:function(e){if(this.length>0){if(e){const e=this.styles();return this[0].offsetHeight+parseFloat(e.getPropertyValue("margin-top"))+parseFloat(e.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null},outerWidth:function(e){if(this.length>0){if(e){const e=this.styles();return this[0].offsetWidth+parseFloat(e.getPropertyValue("margin-right"))+parseFloat(e.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null},parent:function(e){const t=[];for(let a=0;a<this.length;a+=1)null!==this[a].parentNode&&(e?c(this[a].parentNode).is(e)&&t.push(this[a].parentNode):t.push(this[a].parentNode));return c(t)},parents:function(e){const t=[];for(let a=0;a<this.length;a+=1){let r=this[a].parentNode;for(;r;)e?c(r).is(e)&&t.push(r):t.push(r),r=r.parentNode}return c(t)},prepend:function(e){const t=r();let a,s;for(a=0;a<this.length;a+=1)if("string"==typeof e){const r=t.createElement("div");for(r.innerHTML=e,s=r.childNodes.length-1;s>=0;s-=1)this[a].insertBefore(r.childNodes[s],this[a].childNodes[0])}else if(e instanceof n)for(s=0;s<e.length;s+=1)this[a].insertBefore(e[s],this[a].childNodes[0]);else this[a].insertBefore(e,this[a].childNodes[0]);return this},prependTo:function(e){return c(e).prepend(this),this},prev:function(e){if(this.length>0){const t=this[0];return e?t.previousElementSibling&&c(t.previousElementSibling).is(e)?c([t.previousElementSibling]):c([]):t.previousElementSibling?c([t.previousElementSibling]):c([])}return c([])},prevAll:function(e){const t=[];let a=this[0];if(!a)return c([]);for(;a.previousElementSibling;){const r=a.previousElementSibling;e?c(r).is(e)&&t.push(r):t.push(r),a=r}return c(t)},prop:function(e,t){if(1!==arguments.length||"string"!=typeof e){for(let a=0;a<this.length;a+=1)if(2===arguments.length)this[a][e]=t;else for(const t in e)this[a][t]=e[t];return this}return this[0]?this[0][e]:this},remove:function(){for(let e=0;e<this.length;e+=1)this[e].parentNode&&this[e].parentNode.removeChild(this[e]);return this},removeAttr:function(e){for(let t=0;t<this.length;t+=1)this[t].removeAttribute(e);return this},removeClass:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];const r=i(t.map((e=>e.split(" "))));return this.forEach((e=>{e.classList.remove(...r)})),this},removeData:function(e){for(let t=0;t<this.length;t+=1){const a=this[t];a.dom7ElementDataStorage&&a.dom7ElementDataStorage[e]&&(a.dom7ElementDataStorage[e]=null,delete a.dom7ElementDataStorage[e])}},resize:B,scroll:L,scrollLeft:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];let[r,s,o,n]=t;3===t.length&&"function"==typeof o&&([r,s,n,o]=t);const i=this;return void 0===r?i.length>0?i[0].scrollLeft:null:i.scrollTo(r,void 0,s,o,n)},scrollTo:function(){const e=o();for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];let[s,n,i,l,c]=a;return 4===a.length&&"function"==typeof l&&(c=l,[s,n,i,c,l]=a),void 0===l&&(l="swing"),this.each((function(){const t=this;let a,r,o,p,d,u,h,m,f=n>0||0===n,g=s>0||0===s;if(void 0===l&&(l="swing"),f&&(a=t.scrollTop,i||(t.scrollTop=n)),g&&(r=t.scrollLeft,i||(t.scrollLeft=s)),!i)return;f&&(o=t.scrollHeight-t.offsetHeight,d=Math.max(Math.min(n,o),0)),g&&(p=t.scrollWidth-t.offsetWidth,u=Math.max(Math.min(s,p),0));let v=null;f&&d===a&&(f=!1),g&&u===r&&(g=!1),e.requestAnimationFrame((function s(o){void 0===o&&(o=(new Date).getTime()),null===v&&(v=o);const n=Math.max(Math.min((o-v)/i,1),0),p="linear"===l?n:.5-Math.cos(n*Math.PI)/2;let b;f&&(h=a+p*(d-a)),g&&(m=r+p*(u-r)),f&&d>a&&h>=d&&(t.scrollTop=d,b=!0),f&&d<a&&h<=d&&(t.scrollTop=d,b=!0),g&&u>r&&m>=u&&(t.scrollLeft=u,b=!0),g&&u<r&&m<=u&&(t.scrollLeft=u,b=!0),b?c&&c():(f&&(t.scrollTop=h),g&&(t.scrollLeft=m),e.requestAnimationFrame(s))}))}))},scrollTop:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];let[r,s,o,n]=t;3===t.length&&"function"==typeof o&&([r,s,n,o]=t);const i=this;return void 0===r?i.length>0?i[0].scrollTop:null:i.scrollTo(void 0,r,s,o,n)},show:function(){const e=o();for(let t=0;t<this.length;t+=1){const a=this[t];"none"===a.style.display&&(a.style.display=""),"none"===e.getComputedStyle(a,null).getPropertyValue("display")&&(a.style.display="block")}return this},siblings:function(e){return this.nextAll(e).add(this.prevAll(e))},stop:function(){const e=this;for(let t=0;t<e.length;t+=1)e[t].dom7AnimateInstance&&e[t].dom7AnimateInstance.stop()},styles:function(){const e=o();return this[0]?e.getComputedStyle(this[0],null):{}},submit:y,text:function(e){if(void 0===e)return this[0]?this[0].textContent.trim():null;for(let t=0;t<this.length;t+=1)this[t].textContent=e;return this},toggleClass:function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];const r=i(t.map((e=>e.split(" "))));this.forEach((e=>{r.forEach((t=>{e.classList.toggle(t)}))}))},touchend:O,touchmove:I,touchstart:M,transform:function(e){for(let t=0;t<this.length;t+=1)this[t].style.transform=e;return this},transition:function(e){for(let t=0;t<this.length;t+=1)this[t].style.transitionDuration="string"!=typeof e?`${e}ms`:e;return this},transitionEnd:function(e){const t=this;return e&&t.on("transitionend",(function a(r){r.target===this&&(e.call(this,r),t.off("transitionend",a))})),this},transitionStart:function(e){const t=this;return e&&t.on("transitionstart",(function a(r){r.target===this&&(e.call(this,r),t.off("transitionstart",a))})),this},trigger:function(){const e=o();for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];const s=a[0].split(" "),n=a[1];for(let t=0;t<s.length;t+=1){const r=s[t];for(let t=0;t<this.length;t+=1){const s=this[t];if(e.CustomEvent){const t=new e.CustomEvent(r,{detail:n,bubbles:!0,cancelable:!0});s.dom7EventData=a.filter(((e,t)=>t>0)),s.dispatchEvent(t),s.dom7EventData=[],delete s.dom7EventData}}}return this},val:function(e){if(void 0===e){const e=this[0];if(!e)return;if(e.multiple&&"select"===e.nodeName.toLowerCase()){const t=[];for(let a=0;a<e.selectedOptions.length;a+=1)t.push(e.selectedOptions[a].value);return t}return e.value}for(let t=0;t<this.length;t+=1){const a=this[t];if(Array.isArray(e)&&a.multiple&&"select"===a.nodeName.toLowerCase())for(let t=0;t<a.options.length;t+=1)a.options[t].selected=e.indexOf(a.options[t].value)>=0;else a.value=e}return this},value:function(e){return this.val(e)},width:function(){const e=o();return this[0]===e?e.innerWidth:this.length>0?parseFloat(this.css("width")):null}});Object.keys(D).forEach((e=>{"$"!==e&&(c.fn[e]=D[e])}));var A=c;function R(e){return e<0?-1:0===e?0:1}function H(e,t,a){return(1-a)*e+a*t}function z(e,t,a){return a<e?e:a>t?t:a}function N(e){return(e%=360)<0&&(e+=360),e}function V(e,t){return[e[0]*t[0][0]+e[1]*t[0][1]+e[2]*t[0][2],e[0]*t[1][0]+e[1]*t[1][1]+e[2]*t[1][2],e[0]*t[2][0]+e[1]*t[2][1]+e[2]*t[2][2]]}const F=[[.41233895,.35762064,.18051042],[.2126,.7152,.0722],[.01932141,.11916382,.95034478]],_=[[3.2413774792388685,-1.5376652402851851,-.49885366846268053],[-.9691452513005321,1.8758853451067872,.04156585616912061],[.05562093689691305,-.20395524564742123,1.0571799111220335]],q=[95.047,100,108.883];function j(e,t,a){return(255<<24|(255&e)<<16|(255&t)<<8|255&a)>>>0}function Y(e){return j(Z(e[0]),Z(e[1]),Z(e[2]))}function W(e){return e>>16&255}function X(e){return e>>8&255}function U(e){return 255&e}function G(e){return 116*ee(function(e){return V([J(W(e)),J(X(e)),J(U(e))],F)}(e)[1]/100)-16}function K(e){return 100*function(e){const t=e*e*e;return t>216/24389?t:(116*e-16)/903.2962962962963}((e+16)/116)}function Q(e){return 116*ee(e/100)-16}function J(e){const t=e/255;return t<=.040449936?t/12.92*100:100*Math.pow((t+.055)/1.055,2.4)}function Z(e){const t=e/100;let a=0;return a=t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055,r=0,s=255,(o=Math.round(255*a))<r?r:o>s?s:o;var r,s,o}function ee(e){return e>216/24389?Math.pow(e,1/3):(903.2962962962963*e+16)/116}class te{static make(e,t,a,r,s){void 0===e&&(e=q),void 0===t&&(t=200/Math.PI*K(50)/100),void 0===a&&(a=50),void 0===r&&(r=2),void 0===s&&(s=!1);const o=e,n=.401288*o[0]+.650173*o[1]+-.051461*o[2],i=-.250268*o[0]+1.204414*o[1]+.045854*o[2],l=-.002079*o[0]+.048952*o[1]+.953127*o[2],c=.8+r/10,p=c>=.9?H(.59,.69,10*(c-.9)):H(.525,.59,10*(c-.8));let d=s?1:c*(1-1/3.6*Math.exp((-t-42)/92));d=d>1?1:d<0?0:d;const u=c,h=[d*(100/n)+1-d,d*(100/i)+1-d,d*(100/l)+1-d],m=1/(5*t+1),f=m*m*m*m,g=1-f,v=f*t+.1*g*g*Math.cbrt(5*t),b=K(a)/e[1],w=1.48+Math.sqrt(b),y=.725/Math.pow(b,.2),C=y,E=[Math.pow(v*h[0]*n/100,.42),Math.pow(v*h[1]*i/100,.42),Math.pow(v*h[2]*l/100,.42)],k=[400*E[0]/(E[0]+27.13),400*E[1]/(E[1]+27.13),400*E[2]/(E[2]+27.13)];return new te(b,(2*k[0]+k[1]+.05*k[2])*y,y,C,p,u,h,v,Math.pow(v,.25),w)}constructor(e,t,a,r,s,o,n,i,l,c){this.n=e,this.aw=t,this.nbb=a,this.ncb=r,this.c=s,this.nc=o,this.rgbD=n,this.fl=i,this.fLRoot=l,this.z=c}}te.DEFAULT=te.make();class ae{constructor(e,t,a,r,s,o,n,i,l){this.hue=e,this.chroma=t,this.j=a,this.q=r,this.m=s,this.s=o,this.jstar=n,this.astar=i,this.bstar=l}distance(e){const t=this.jstar-e.jstar,a=this.astar-e.astar,r=this.bstar-e.bstar,s=Math.sqrt(t*t+a*a+r*r);return 1.41*Math.pow(s,.63)}static fromInt(e){return ae.fromIntInViewingConditions(e,te.DEFAULT)}static fromIntInViewingConditions(e,t){const a=(65280&e)>>8,r=255&e,s=J((16711680&e)>>16),o=J(a),n=J(r),i=.41233895*s+.35762064*o+.18051042*n,l=.2126*s+.7152*o+.0722*n,c=.01932141*s+.11916382*o+.95034478*n,p=.401288*i+.650173*l-.051461*c,d=-.250268*i+1.204414*l+.045854*c,u=-.002079*i+.048952*l+.953127*c,h=t.rgbD[0]*p,m=t.rgbD[1]*d,f=t.rgbD[2]*u,g=Math.pow(t.fl*Math.abs(h)/100,.42),v=Math.pow(t.fl*Math.abs(m)/100,.42),b=Math.pow(t.fl*Math.abs(f)/100,.42),w=400*R(h)*g/(g+27.13),y=400*R(m)*v/(v+27.13),C=400*R(f)*b/(b+27.13),E=(11*w+-12*y+C)/11,k=(w+y-2*C)/9,$=(20*w+20*y+21*C)/20,x=(40*w+20*y+C)/20,T=180*Math.atan2(k,E)/Math.PI,S=T<0?T+360:T>=360?T-360:T,P=S*Math.PI/180,M=x*t.nbb,O=100*Math.pow(M/t.aw,t.c*t.z),I=4/t.c*Math.sqrt(O/100)*(t.aw+4)*t.fLRoot,B=S<20.14?S+360:S,L=5e4/13*(.25*(Math.cos(B*Math.PI/180+2)+3.8))*t.nc*t.ncb*Math.sqrt(E*E+k*k)/($+.305),D=Math.pow(L,.9)*Math.pow(1.64-Math.pow(.29,t.n),.73),A=D*Math.sqrt(O/100),H=A*t.fLRoot,z=50*Math.sqrt(D*t.c/(t.aw+4)),N=(1+100*.007)*O/(1+.007*O),V=1/.0228*Math.log(1+.0228*H),F=V*Math.cos(P),_=V*Math.sin(P);return new ae(S,A,O,I,H,z,N,F,_)}static fromJch(e,t,a){return ae.fromJchInViewingConditions(e,t,a,te.DEFAULT)}static fromJchInViewingConditions(e,t,a,r){const s=4/r.c*Math.sqrt(e/100)*(r.aw+4)*r.fLRoot,o=t*r.fLRoot,n=t/Math.sqrt(e/100),i=50*Math.sqrt(n*r.c/(r.aw+4)),l=a*Math.PI/180,c=(1+100*.007)*e/(1+.007*e),p=1/.0228*Math.log(1+.0228*o),d=p*Math.cos(l),u=p*Math.sin(l);return new ae(a,t,e,s,o,i,c,d,u)}static fromUcs(e,t,a){return ae.fromUcsInViewingConditions(e,t,a,te.DEFAULT)}static fromUcsInViewingConditions(e,t,a,r){const s=t,o=a,n=Math.sqrt(s*s+o*o),i=(Math.exp(.0228*n)-1)/.0228/r.fLRoot;let l=Math.atan2(o,s)*(180/Math.PI);l<0&&(l+=360);const c=e/(1-.007*(e-100));return ae.fromJchInViewingConditions(c,i,l,r)}toInt(){return this.viewed(te.DEFAULT)}viewed(e){const t=0===this.chroma||0===this.j?0:this.chroma/Math.sqrt(this.j/100),a=Math.pow(t/Math.pow(1.64-Math.pow(.29,e.n),.73),1/.9),r=this.hue*Math.PI/180,s=.25*(Math.cos(r+2)+3.8),o=e.aw*Math.pow(this.j/100,1/e.c/e.z),n=s*(5e4/13)*e.nc*e.ncb,i=o/e.nbb,l=Math.sin(r),c=Math.cos(r),p=23*(i+.305)*a/(23*n+11*a*c+108*a*l),d=p*c,u=p*l,h=(460*i+451*d+288*u)/1403,m=(460*i-891*d-261*u)/1403,f=(460*i-220*d-6300*u)/1403,g=Math.max(0,27.13*Math.abs(h)/(400-Math.abs(h))),v=R(h)*(100/e.fl)*Math.pow(g,1/.42),b=Math.max(0,27.13*Math.abs(m)/(400-Math.abs(m))),w=R(m)*(100/e.fl)*Math.pow(b,1/.42),y=Math.max(0,27.13*Math.abs(f)/(400-Math.abs(f))),C=R(f)*(100/e.fl)*Math.pow(y,1/.42),E=v/e.rgbD[0],k=w/e.rgbD[1],$=C/e.rgbD[2];return function(e,t,a){const r=_,s=r[0][0]*e+r[0][1]*t+r[0][2]*a,o=r[1][0]*e+r[1][1]*t+r[1][2]*a,n=r[2][0]*e+r[2][1]*t+r[2][2]*a;return j(Z(s),Z(o),Z(n))}(1.86206786*E-1.01125463*k+.14918677*$,.38752654*E+.62144744*k-.00897398*$,-.0158415*E-.03412294*k+1.04996444*$)}static fromXyzInViewingConditions(e,t,a,r){const s=.401288*e+.650173*t-.051461*a,o=-.250268*e+1.204414*t+.045854*a,n=-.002079*e+.048952*t+.953127*a,i=r.rgbD[0]*s,l=r.rgbD[1]*o,c=r.rgbD[2]*n,p=Math.pow(r.fl*Math.abs(i)/100,.42),d=Math.pow(r.fl*Math.abs(l)/100,.42),u=Math.pow(r.fl*Math.abs(c)/100,.42),h=400*R(i)*p/(p+27.13),m=400*R(l)*d/(d+27.13),f=400*R(c)*u/(u+27.13),g=(11*h+-12*m+f)/11,v=(h+m-2*f)/9,b=(20*h+20*m+21*f)/20,w=(40*h+20*m+f)/20,y=180*Math.atan2(v,g)/Math.PI,C=y<0?y+360:y>=360?y-360:y,E=C*Math.PI/180,k=w*r.nbb,$=100*Math.pow(k/r.aw,r.c*r.z),x=4/r.c*Math.sqrt($/100)*(r.aw+4)*r.fLRoot,T=C<20.14?C+360:C,S=5e4/13*(1/4*(Math.cos(T*Math.PI/180+2)+3.8))*r.nc*r.ncb*Math.sqrt(g*g+v*v)/(b+.305),P=Math.pow(S,.9)*Math.pow(1.64-Math.pow(.29,r.n),.73),M=P*Math.sqrt($/100),O=M*r.fLRoot,I=50*Math.sqrt(P*r.c/(r.aw+4)),B=(1+100*.007)*$/(1+.007*$),L=Math.log(1+.0228*O)/.0228,D=L*Math.cos(E),A=L*Math.sin(E);return new ae(C,M,$,x,O,I,B,D,A)}xyzInViewingConditions(e){const t=0===this.chroma||0===this.j?0:this.chroma/Math.sqrt(this.j/100),a=Math.pow(t/Math.pow(1.64-Math.pow(.29,e.n),.73),1/.9),r=this.hue*Math.PI/180,s=.25*(Math.cos(r+2)+3.8),o=e.aw*Math.pow(this.j/100,1/e.c/e.z),n=s*(5e4/13)*e.nc*e.ncb,i=o/e.nbb,l=Math.sin(r),c=Math.cos(r),p=23*(i+.305)*a/(23*n+11*a*c+108*a*l),d=p*c,u=p*l,h=(460*i+451*d+288*u)/1403,m=(460*i-891*d-261*u)/1403,f=(460*i-220*d-6300*u)/1403,g=Math.max(0,27.13*Math.abs(h)/(400-Math.abs(h))),v=R(h)*(100/e.fl)*Math.pow(g,1/.42),b=Math.max(0,27.13*Math.abs(m)/(400-Math.abs(m))),w=R(m)*(100/e.fl)*Math.pow(b,1/.42),y=Math.max(0,27.13*Math.abs(f)/(400-Math.abs(f))),C=R(f)*(100/e.fl)*Math.pow(y,1/.42),E=v/e.rgbD[0],k=w/e.rgbD[1],$=C/e.rgbD[2];return[1.86206786*E-1.01125463*k+.14918677*$,.38752654*E+.62144744*k-.00897398*$,-.0158415*E-.03412294*k+1.04996444*$]}}class re{static sanitizeRadians(e){return(e+8*Math.PI)%(2*Math.PI)}static trueDelinearized(e){const t=e/100;let a=0;return a=t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055,255*a}static chromaticAdaptation(e){const t=Math.pow(Math.abs(e),.42);return 400*R(e)*t/(t+27.13)}static hueOf(e){const t=V(e,re.SCALED_DISCOUNT_FROM_LINRGB),a=re.chromaticAdaptation(t[0]),r=re.chromaticAdaptation(t[1]),s=re.chromaticAdaptation(t[2]),o=(11*a+-12*r+s)/11,n=(a+r-2*s)/9;return Math.atan2(n,o)}static areInCyclicOrder(e,t,a){return re.sanitizeRadians(t-e)<re.sanitizeRadians(a-e)}static intercept(e,t,a){return(t-e)/(a-e)}static lerpPoint(e,t,a){return[e[0]+(a[0]-e[0])*t,e[1]+(a[1]-e[1])*t,e[2]+(a[2]-e[2])*t]}static setCoordinate(e,t,a,r){const s=re.intercept(e[r],t,a[r]);return re.lerpPoint(e,s,a)}static isBounded(e){return 0<=e&&e<=100}static nthVertex(e,t){const a=re.Y_FROM_LINRGB[0],r=re.Y_FROM_LINRGB[1],s=re.Y_FROM_LINRGB[2],o=t%4<=1?0:100,n=t%2==0?0:100;if(t<4){const t=o,i=n,l=(e-t*r-i*s)/a;return re.isBounded(l)?[l,t,i]:[-1,-1,-1]}if(t<8){const t=o,i=n,l=(e-i*a-t*s)/r;return re.isBounded(l)?[i,l,t]:[-1,-1,-1]}{const t=o,i=n,l=(e-t*a-i*r)/s;return re.isBounded(l)?[t,i,l]:[-1,-1,-1]}}static bisectToSegment(e,t){let a=[-1,-1,-1],r=a,s=0,o=0,n=!1,i=!0;for(let l=0;l<12;l++){const c=re.nthVertex(e,l);if(c[0]<0)continue;const p=re.hueOf(c);n?(i||re.areInCyclicOrder(s,p,o))&&(i=!1,re.areInCyclicOrder(s,t,p)?(r=c,o=p):(a=c,s=p)):(a=c,r=c,s=p,o=p,n=!0)}return[a,r]}static midpoint(e,t){return[(e[0]+t[0])/2,(e[1]+t[1])/2,(e[2]+t[2])/2]}static criticalPlaneBelow(e){return Math.floor(e-.5)}static criticalPlaneAbove(e){return Math.ceil(e-.5)}static bisectToLimit(e,t){const a=re.bisectToSegment(e,t);let r=a[0],s=re.hueOf(r),o=a[1];for(let e=0;e<3;e++)if(r[e]!==o[e]){let a=-1,n=255;r[e]<o[e]?(a=re.criticalPlaneBelow(re.trueDelinearized(r[e])),n=re.criticalPlaneAbove(re.trueDelinearized(o[e]))):(a=re.criticalPlaneAbove(re.trueDelinearized(r[e])),n=re.criticalPlaneBelow(re.trueDelinearized(o[e])));for(let i=0;i<8&&!(Math.abs(n-a)<=1);i++){const i=Math.floor((a+n)/2),l=re.CRITICAL_PLANES[i],c=re.setCoordinate(r,l,o,e),p=re.hueOf(c);re.areInCyclicOrder(s,t,p)?(o=c,n=i):(r=c,s=p,a=i)}}return re.midpoint(r,o)}static inverseChromaticAdaptation(e){const t=Math.abs(e),a=Math.max(0,27.13*t/(400-t));return R(e)*Math.pow(a,1/.42)}static findResultByJ(e,t,a){let r=11*Math.sqrt(a);const s=te.DEFAULT,o=1/Math.pow(1.64-Math.pow(.29,s.n),.73),n=.25*(Math.cos(e+2)+3.8)*(5e4/13)*s.nc*s.ncb,i=Math.sin(e),l=Math.cos(e);for(let e=0;e<5;e++){const c=r/100,p=0===t||0===r?0:t/Math.sqrt(c),d=Math.pow(p*o,1/.9),u=s.aw*Math.pow(c,1/s.c/s.z)/s.nbb,h=23*(u+.305)*d/(23*n+11*d*l+108*d*i),m=h*l,f=h*i,g=(460*u+451*m+288*f)/1403,v=(460*u-891*m-261*f)/1403,b=(460*u-220*m-6300*f)/1403,w=V([re.inverseChromaticAdaptation(g),re.inverseChromaticAdaptation(v),re.inverseChromaticAdaptation(b)],re.LINRGB_FROM_SCALED_DISCOUNT);if(w[0]<0||w[1]<0||w[2]<0)return 0;const y=re.Y_FROM_LINRGB[0],C=re.Y_FROM_LINRGB[1],E=re.Y_FROM_LINRGB[2],k=y*w[0]+C*w[1]+E*w[2];if(k<=0)return 0;if(4===e||Math.abs(k-a)<.002)return w[0]>100.01||w[1]>100.01||w[2]>100.01?0:Y(w);r-=(k-a)*r/(2*k)}return 0}static solveToInt(e,t,a){if(t<1e-4||a<1e-4||a>99.9999)return function(e){const t=Z(K(e));return j(t,t,t)}(a);const r=(e=N(e))/180*Math.PI,s=K(a),o=re.findResultByJ(r,t,s);return 0!==o?o:Y(re.bisectToLimit(s,r))}static solveToCam(e,t,a){return ae.fromInt(re.solveToInt(e,t,a))}}re.SCALED_DISCOUNT_FROM_LINRGB=[[.001200833568784504,.002389694492170889,.0002795742885861124],[.0005891086651375999,.0029785502573438758,.0003270666104008398],[.00010146692491640572,.0005364214359186694,.0032979401770712076]],re.LINRGB_FROM_SCALED_DISCOUNT=[[1373.2198709594231,-1100.4251190754821,-7.278681089101213],[-271.815969077903,559.6580465940733,-32.46047482791194],[1.9622899599665666,-57.173814538844006,308.7233197812385]],re.Y_FROM_LINRGB=[.2126,.7152,.0722],re.CRITICAL_PLANES=[.015176349177441876,.045529047532325624,.07588174588720938,.10623444424209313,.13658714259697685,.16693984095186062,.19729253930674434,.2276452376616281,.2579979360165119,.28835063437139563,.3188300904430532,.350925934958123,.3848314933096426,.42057480301049466,.458183274052838,.4976837250274023,.5391024159806381,.5824650784040898,.6277969426914107,.6751227633498623,.7244668422128921,.775853049866786,.829304845476233,.8848452951698498,.942497089126609,1.0022825574869039,1.0642236851973577,1.1283421258858297,1.1946592148522128,1.2631959812511864,1.3339731595349034,1.407011200216447,1.4823302800086415,1.5599503113873272,1.6398909516233677,1.7221716113234105,1.8068114625156377,1.8938294463134073,1.9832442801866852,2.075074464868551,2.1693382909216234,2.2660538449872063,2.36523901573795,2.4669114995532007,2.5710888059345764,2.6777882626779785,2.7870270208169257,2.898822059350997,3.0131901897720907,3.1301480604002863,3.2497121605402226,3.3718988244681087,3.4967242352587946,3.624204428461639,3.754355295633311,3.887192587735158,4.022731918402185,4.160988767090289,4.301978482107941,4.445716283538092,4.592217266055746,4.741496401646282,4.893568542229298,5.048448422192488,5.20615066083972,5.3666897647573375,5.5300801301023865,5.696336044816294,5.865471690767354,6.037501145825082,6.212438385869475,6.390297286737924,6.571091626112461,6.7548350853498045,6.941541251256611,7.131223617812143,7.323895587840543,7.5195704746346665,7.7182615035334345,7.919981813454504,8.124744458384042,8.332562408825165,8.543448553206703,8.757415699253682,8.974476575321063,9.194643831691977,9.417930041841839,9.644347703669503,9.873909240696694,10.106627003236781,10.342513269534024,10.58158024687427,10.8238400726681,11.069304815507364,11.317986476196008,11.569896988756009,11.825048221409341,12.083451977536606,12.345119996613247,12.610063955123938,12.878295467455942,13.149826086772048,13.42466730586372,13.702830557985108,13.984327217668513,14.269168601521828,14.55736596900856,14.848930523210871,15.143873411576273,15.44220572664832,15.743938506781891,16.04908273684337,16.35764934889634,16.66964922287304,16.985093187232053,17.30399201960269,17.62635644741625,17.95219714852476,18.281524751807332,18.614349837764564,18.95068293910138,19.290534541298456,19.633915083172692,19.98083495742689,20.331304511189067,20.685334046541502,21.042933821039977,21.404114048223256,21.76888489811322,22.137256497705877,22.50923893145328,22.884842241736916,23.264076429332462,23.6469514538663,24.033477234264016,24.42366364919083,24.817520537484558,25.21505769858089,25.61628489293138,26.021211842414342,26.429848230738664,26.842203703840827,27.258287870275353,27.678110301598522,28.10168053274597,28.529008062403893,28.96010235337422,29.39497283293396,29.83362889318845,30.276079891419332,30.722335150426627,31.172403958865512,31.62629557157785,32.08401920991837,32.54558406207592,33.010999283389665,33.4802739966603,33.953417292456834,34.430438229418264,34.911345834551085,35.39614910352207,35.88485700094671,36.37747846067349,36.87402238606382,37.37449765026789,37.87891309649659,38.38727753828926,38.89959975977785,39.41588851594697,39.93615253289054,40.460400508064545,40.98864111053629,41.520882981230194,42.05713473317016,42.597404951718396,43.141702194811224,43.6900349931913,44.24241185063697,44.798841244188324,45.35933162437017,45.92389141541209,46.49252901546552,47.065252796817916,47.64207110610409,48.22299226451468,48.808024568002054,49.3971762874833,49.9904556690408,50.587870934119984,51.189430279724725,51.79514187861014,52.40501387947288,53.0190544071392,53.637271562750364,54.259673423945976,54.88626804504493,55.517063457223934,56.15206766869424,56.79128866487574,57.43473440856916,58.08241284012621,58.734331877617365,59.39049941699807,60.05092333227251,60.715611475655585,61.38457167773311,62.057811747619894,62.7353394731159,63.417162620860914,64.10328893648692,64.79372614476921,65.48848194977529,66.18756403501224,66.89098006357258,67.59873767827808,68.31084450182222,69.02730813691093,69.74813616640164,70.47333615344107,71.20291564160104,71.93688215501312,72.67524319850172,73.41800625771542,74.16517879925733,74.9167682708136,75.67278210128072,76.43322770089146,77.1981124613393,77.96744375590167,78.74122893956174,79.51947534912904,80.30219030335869,81.08938110306934,81.88105503125999,82.67721935322541,83.4778813166706,84.28304815182372,85.09272707154808,85.90692527145302,86.72564993000343,87.54890820862819,88.3767072518277,89.2090541872801,90.04595612594655,90.88742016217518,91.73345337380438,92.58406282226491,93.43925555268066,94.29903859396902,95.16341895893969,96.03240364439274,96.9059996312159,97.78421388448044,98.6670533535366,99.55452497210776];class se{static from(e,t,a){return new se(re.solveToInt(e,t,a))}static fromInt(e){return new se(e)}toInt(){return this.argb}get hue(){return this.internalHue}set hue(e){this.setInternalState(re.solveToInt(e,this.internalChroma,this.internalTone))}get chroma(){return this.internalChroma}set chroma(e){this.setInternalState(re.solveToInt(this.internalHue,e,this.internalTone))}get tone(){return this.internalTone}set tone(e){this.setInternalState(re.solveToInt(this.internalHue,this.internalChroma,e))}constructor(e){this.argb=e;const t=ae.fromInt(e);this.internalHue=t.hue,this.internalChroma=t.chroma,this.internalTone=G(e),this.argb=e}setInternalState(e){const t=ae.fromInt(e);this.internalHue=t.hue,this.internalChroma=t.chroma,this.internalTone=G(e),this.argb=e}inViewingConditions(e){const t=ae.fromInt(this.toInt()).xyzInViewingConditions(e),a=ae.fromXyzInViewingConditions(t[0],t[1],t[2],te.make());return se.from(a.hue,a.chroma,Q(t[1]))}}class oe{static harmonize(e,t){const a=se.fromInt(e),r=se.fromInt(t),s=(l=a.hue,c=r.hue,180-Math.abs(Math.abs(l-c)-180)),o=Math.min(.5*s,15),n=N(a.hue+o*(i=a.hue,N(r.hue-i)<=180?1:-1));var i,l,c;return se.from(n,a.chroma,a.tone).toInt()}static hctHue(e,t,a){const r=oe.cam16Ucs(e,t,a),s=ae.fromInt(r),o=ae.fromInt(e);return se.from(s.hue,o.chroma,G(e)).toInt()}static cam16Ucs(e,t,a){const r=ae.fromInt(e),s=ae.fromInt(t),o=r.jstar,n=r.astar,i=r.bstar,l=o+(s.jstar-o)*a,c=n+(s.astar-n)*a,p=i+(s.bstar-i)*a;return ae.fromUcs(l,c,p).toInt()}}class ne{static ratioOfTones(e,t){return e=z(0,100,e),t=z(0,100,t),ne.ratioOfYs(K(e),K(t))}static ratioOfYs(e,t){const a=e>t?e:t;return(a+5)/((a===t?e:t)+5)}static lighter(e,t){if(e<0||e>100)return-1;const a=K(e),r=t*(a+5)-5,s=ne.ratioOfYs(r,a),o=Math.abs(s-t);if(s<t&&o>.04)return-1;const n=Q(r)+.4;return n<0||n>100?-1:n}static darker(e,t){if(e<0||e>100)return-1;const a=K(e),r=(a+5)/t-5,s=ne.ratioOfYs(a,r),o=Math.abs(s-t);if(s<t&&o>.04)return-1;const n=Q(r)-.4;return n<0||n>100?-1:n}static lighterUnsafe(e,t){const a=ne.lighter(e,t);return a<0?100:a}static darkerUnsafe(e,t){const a=ne.darker(e,t);return a<0?0:a}}class ie{static isDisliked(e){const t=Math.round(e.hue)>=90&&Math.round(e.hue)<=111,a=Math.round(e.chroma)>16,r=Math.round(e.tone)<65;return t&&a&&r}static fixIfDisliked(e){return ie.isDisliked(e)?se.from(e.hue,e.chroma,70):e}}class le{static fromPalette(e){return new le(e.name??"",e.palette,e.tone,e.isBackground??!1,e.background,e.secondBackground,e.contrastCurve,e.toneDeltaPair)}constructor(e,t,a,r,s,o,n,i){if(this.name=e,this.palette=t,this.tone=a,this.isBackground=r,this.background=s,this.secondBackground=o,this.contrastCurve=n,this.toneDeltaPair=i,this.hctCache=new Map,!s&&o)throw new Error(`Color ${e} has secondBackgrounddefined, but background is not defined.`);if(!s&&n)throw new Error(`Color ${e} has contrastCurvedefined, but background is not defined.`);if(s&&!n)throw new Error(`Color ${e} has backgrounddefined, but contrastCurve is not defined.`)}getArgb(e){return this.getHct(e).toInt()}getHct(e){const t=this.hctCache.get(e);if(null!=t)return t;const a=this.getTone(e),r=this.palette(e).getHct(a);return this.hctCache.size>4&&this.hctCache.clear(),this.hctCache.set(e,r),r}getTone(e){const t=e.contrastLevel<0;if(this.toneDeltaPair){const a=this.toneDeltaPair(e),r=a.roleA,s=a.roleB,o=a.delta,n=a.polarity,i=a.stayTogether,l=this.background(e).getTone(e),c="nearer"===n||"lighter"===n&&!e.isDark||"darker"===n&&e.isDark,p=c?r:s,d=c?s:r,u=this.name===p.name,h=e.isDark?1:-1,m=p.contrastCurve.getContrast(e.contrastLevel),f=d.contrastCurve.getContrast(e.contrastLevel),g=p.tone(e);let v=ne.ratioOfTones(l,g)>=m?g:le.foregroundTone(l,m);const b=d.tone(e);let w=ne.ratioOfTones(l,b)>=f?b:le.foregroundTone(l,f);return t&&(v=le.foregroundTone(l,m),w=le.foregroundTone(l,f)),(w-v)*h>=o||(w=z(0,100,v+o*h),(w-v)*h>=o||(v=z(0,100,w-o*h))),50<=v&&v<60?h>0?(v=60,w=Math.max(w,v+o*h)):(v=49,w=Math.min(w,v+o*h)):50<=w&&w<60&&(i?h>0?(v=60,w=Math.max(w,v+o*h)):(v=49,w=Math.min(w,v+o*h)):w=h>0?60:49),u?v:w}{let a=this.tone(e);if(null==this.background)return a;const r=this.background(e).getTone(e),s=this.contrastCurve.getContrast(e.contrastLevel);if(ne.ratioOfTones(r,a)>=s||(a=le.foregroundTone(r,s)),t&&(a=le.foregroundTone(r,s)),this.isBackground&&50<=a&&a<60&&(a=ne.ratioOfTones(49,r)>=s?49:60),this.secondBackground){const[t,r]=[this.background,this.secondBackground],[o,n]=[t(e).getTone(e),r(e).getTone(e)],[i,l]=[Math.max(o,n),Math.min(o,n)];if(ne.ratioOfTones(i,a)>=s&&ne.ratioOfTones(l,a)>=s)return a;const c=ne.lighter(i,s),p=ne.darker(l,s),d=[];return-1!==c&&d.push(c),-1!==p&&d.push(p),le.tonePrefersLightForeground(o)||le.tonePrefersLightForeground(n)?c<0?100:c:1===d.length?d[0]:p<0?0:p}return a}}static foregroundTone(e,t){const a=ne.lighterUnsafe(e,t),r=ne.darkerUnsafe(e,t),s=ne.ratioOfTones(a,e),o=ne.ratioOfTones(r,e);if(le.tonePrefersLightForeground(e)){const e=Math.abs(s-o)<.1&&s<t&&o<t;return s>=t||s>=o||e?a:r}return o>=t||o>=s?r:a}static tonePrefersLightForeground(e){return Math.round(e)<60}static toneAllowsLightForeground(e){return Math.round(e)<=49}static enableLightForeground(e){return le.tonePrefersLightForeground(e)&&!le.toneAllowsLightForeground(e)?49:e}}var ce;!function(e){e[e.MONOCHROME=0]="MONOCHROME",e[e.NEUTRAL=1]="NEUTRAL",e[e.TONAL_SPOT=2]="TONAL_SPOT",e[e.VIBRANT=3]="VIBRANT",e[e.EXPRESSIVE=4]="EXPRESSIVE",e[e.FIDELITY=5]="FIDELITY",e[e.CONTENT=6]="CONTENT",e[e.RAINBOW=7]="RAINBOW",e[e.FRUIT_SALAD=8]="FRUIT_SALAD"}(ce||(ce={}));class pe{constructor(e,t,a,r){this.low=e,this.normal=t,this.medium=a,this.high=r}getContrast(e){return e<=-1?this.low:e<0?H(this.low,this.normal,(e- -1)/1):e<.5?H(this.normal,this.medium,(e-0)/.5):e<1?H(this.medium,this.high,(e-.5)/.5):this.high}}class de{constructor(e,t,a,r,s){this.roleA=e,this.roleB=t,this.delta=a,this.polarity=r,this.stayTogether=s}}function ue(e){return e.variant===ce.FIDELITY||e.variant===ce.CONTENT}function he(e){return e.variant===ce.MONOCHROME}function me(e,t){const a=e.inViewingConditions(function(e){return te.make(void 0,void 0,e.isDark?30:80,void 0,void 0)}(t));return le.tonePrefersLightForeground(e.tone)&&!le.toneAllowsLightForeground(a.tone)?le.enableLightForeground(e.tone):le.enableLightForeground(a.tone)}class fe{static highestSurface(e){return e.isDark?fe.surfaceBright:fe.surfaceDim}}fe.contentAccentToneDelta=15,fe.primaryPaletteKeyColor=le.fromPalette({name:"primary_palette_key_color",palette:e=>e.primaryPalette,tone:e=>e.primaryPalette.keyColor.tone}),fe.secondaryPaletteKeyColor=le.fromPalette({name:"secondary_palette_key_color",palette:e=>e.secondaryPalette,tone:e=>e.secondaryPalette.keyColor.tone}),fe.tertiaryPaletteKeyColor=le.fromPalette({name:"tertiary_palette_key_color",palette:e=>e.tertiaryPalette,tone:e=>e.tertiaryPalette.keyColor.tone}),fe.neutralPaletteKeyColor=le.fromPalette({name:"neutral_palette_key_color",palette:e=>e.neutralPalette,tone:e=>e.neutralPalette.keyColor.tone}),fe.neutralVariantPaletteKeyColor=le.fromPalette({name:"neutral_variant_palette_key_color",palette:e=>e.neutralVariantPalette,tone:e=>e.neutralVariantPalette.keyColor.tone}),fe.background=le.fromPalette({name:"background",palette:e=>e.neutralPalette,tone:e=>e.isDark?6:98,isBackground:!0}),fe.onBackground=le.fromPalette({name:"on_background",palette:e=>e.neutralPalette,tone:e=>e.isDark?90:10,background:e=>fe.background,contrastCurve:new pe(3,3,4.5,7)}),fe.surface=le.fromPalette({name:"surface",palette:e=>e.neutralPalette,tone:e=>e.isDark?6:98,isBackground:!0}),fe.surfaceDim=le.fromPalette({name:"surface_dim",palette:e=>e.neutralPalette,tone:e=>e.isDark?6:87,isBackground:!0}),fe.surfaceBright=le.fromPalette({name:"surface_bright",palette:e=>e.neutralPalette,tone:e=>e.isDark?24:98,isBackground:!0}),fe.surfaceContainerLowest=le.fromPalette({name:"surface_container_lowest",palette:e=>e.neutralPalette,tone:e=>e.isDark?4:100,isBackground:!0}),fe.surfaceContainerLow=le.fromPalette({name:"surface_container_low",palette:e=>e.neutralPalette,tone:e=>e.isDark?10:96,isBackground:!0}),fe.surfaceContainer=le.fromPalette({name:"surface_container",palette:e=>e.neutralPalette,tone:e=>e.isDark?12:94,isBackground:!0}),fe.surfaceContainerHigh=le.fromPalette({name:"surface_container_high",palette:e=>e.neutralPalette,tone:e=>e.isDark?17:92,isBackground:!0}),fe.surfaceContainerHighest=le.fromPalette({name:"surface_container_highest",palette:e=>e.neutralPalette,tone:e=>e.isDark?22:90,isBackground:!0}),fe.onSurface=le.fromPalette({name:"on_surface",palette:e=>e.neutralPalette,tone:e=>e.isDark?90:10,background:e=>fe.highestSurface(e),contrastCurve:new pe(4.5,7,11,21)}),fe.surfaceVariant=le.fromPalette({name:"surface_variant",palette:e=>e.neutralVariantPalette,tone:e=>e.isDark?30:90,isBackground:!0}),fe.onSurfaceVariant=le.fromPalette({name:"on_surface_variant",palette:e=>e.neutralVariantPalette,tone:e=>e.isDark?80:30,background:e=>fe.highestSurface(e),contrastCurve:new pe(3,4.5,7,11)}),fe.inverseSurface=le.fromPalette({name:"inverse_surface",palette:e=>e.neutralPalette,tone:e=>e.isDark?90:20}),fe.inverseOnSurface=le.fromPalette({name:"inverse_on_surface",palette:e=>e.neutralPalette,tone:e=>e.isDark?20:95,background:e=>fe.inverseSurface,contrastCurve:new pe(4.5,7,11,21)}),fe.outline=le.fromPalette({name:"outline",palette:e=>e.neutralVariantPalette,tone:e=>e.isDark?60:50,background:e=>fe.highestSurface(e),contrastCurve:new pe(1.5,3,4.5,7)}),fe.outlineVariant=le.fromPalette({name:"outline_variant",palette:e=>e.neutralVariantPalette,tone:e=>e.isDark?30:80,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7)}),fe.shadow=le.fromPalette({name:"shadow",palette:e=>e.neutralPalette,tone:e=>0}),fe.scrim=le.fromPalette({name:"scrim",palette:e=>e.neutralPalette,tone:e=>0}),fe.surfaceTint=le.fromPalette({name:"surface_tint",palette:e=>e.primaryPalette,tone:e=>e.isDark?80:40,isBackground:!0}),fe.primary=le.fromPalette({name:"primary",palette:e=>e.primaryPalette,tone:e=>he(e)?e.isDark?100:0:e.isDark?80:40,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(3,4.5,7,11),toneDeltaPair:e=>new de(fe.primaryContainer,fe.primary,15,"nearer",!1)}),fe.onPrimary=le.fromPalette({name:"on_primary",palette:e=>e.primaryPalette,tone:e=>he(e)?e.isDark?10:90:e.isDark?20:100,background:e=>fe.primary,contrastCurve:new pe(4.5,7,11,21)}),fe.primaryContainer=le.fromPalette({name:"primary_container",palette:e=>e.primaryPalette,tone:e=>ue(e)?me(e.sourceColorHct,e):he(e)?e.isDark?85:25:e.isDark?30:90,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.primaryContainer,fe.primary,15,"nearer",!1)}),fe.onPrimaryContainer=le.fromPalette({name:"on_primary_container",palette:e=>e.primaryPalette,tone:e=>ue(e)?le.foregroundTone(fe.primaryContainer.tone(e),4.5):he(e)?e.isDark?0:100:e.isDark?90:10,background:e=>fe.primaryContainer,contrastCurve:new pe(4.5,7,11,21)}),fe.inversePrimary=le.fromPalette({name:"inverse_primary",palette:e=>e.primaryPalette,tone:e=>e.isDark?40:80,background:e=>fe.inverseSurface,contrastCurve:new pe(3,4.5,7,11)}),fe.secondary=le.fromPalette({name:"secondary",palette:e=>e.secondaryPalette,tone:e=>e.isDark?80:40,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(3,4.5,7,11),toneDeltaPair:e=>new de(fe.secondaryContainer,fe.secondary,15,"nearer",!1)}),fe.onSecondary=le.fromPalette({name:"on_secondary",palette:e=>e.secondaryPalette,tone:e=>he(e)?e.isDark?10:100:e.isDark?20:100,background:e=>fe.secondary,contrastCurve:new pe(4.5,7,11,21)}),fe.secondaryContainer=le.fromPalette({name:"secondary_container",palette:e=>e.secondaryPalette,tone:e=>{const t=e.isDark?30:90;if(he(e))return e.isDark?30:85;if(!ue(e))return t;let a=function(e,t,a,r){let s=a,o=se.from(e,t,a);if(o.chroma<t){let a=o.chroma;for(;o.chroma<t;){s+=r?-1:1;const n=se.from(e,t,s);if(a>n.chroma)break;if(Math.abs(n.chroma-t)<.4)break;Math.abs(n.chroma-t)<Math.abs(o.chroma-t)&&(o=n),a=Math.max(a,n.chroma)}}return s}(e.secondaryPalette.hue,e.secondaryPalette.chroma,t,!e.isDark);return a=me(e.secondaryPalette.getHct(a),e),a},isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.secondaryContainer,fe.secondary,15,"nearer",!1)}),fe.onSecondaryContainer=le.fromPalette({name:"on_secondary_container",palette:e=>e.secondaryPalette,tone:e=>ue(e)?le.foregroundTone(fe.secondaryContainer.tone(e),4.5):e.isDark?90:10,background:e=>fe.secondaryContainer,contrastCurve:new pe(4.5,7,11,21)}),fe.tertiary=le.fromPalette({name:"tertiary",palette:e=>e.tertiaryPalette,tone:e=>he(e)?e.isDark?90:25:e.isDark?80:40,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(3,4.5,7,11),toneDeltaPair:e=>new de(fe.tertiaryContainer,fe.tertiary,15,"nearer",!1)}),fe.onTertiary=le.fromPalette({name:"on_tertiary",palette:e=>e.tertiaryPalette,tone:e=>he(e)?e.isDark?10:90:e.isDark?20:100,background:e=>fe.tertiary,contrastCurve:new pe(4.5,7,11,21)}),fe.tertiaryContainer=le.fromPalette({name:"tertiary_container",palette:e=>e.tertiaryPalette,tone:e=>{if(he(e))return e.isDark?60:49;if(!ue(e))return e.isDark?30:90;const t=me(e.tertiaryPalette.getHct(e.sourceColorHct.tone),e),a=e.tertiaryPalette.getHct(t);return ie.fixIfDisliked(a).tone},isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.tertiaryContainer,fe.tertiary,15,"nearer",!1)}),fe.onTertiaryContainer=le.fromPalette({name:"on_tertiary_container",palette:e=>e.tertiaryPalette,tone:e=>he(e)?e.isDark?0:100:ue(e)?le.foregroundTone(fe.tertiaryContainer.tone(e),4.5):e.isDark?90:10,background:e=>fe.tertiaryContainer,contrastCurve:new pe(4.5,7,11,21)}),fe.error=le.fromPalette({name:"error",palette:e=>e.errorPalette,tone:e=>e.isDark?80:40,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(3,4.5,7,11),toneDeltaPair:e=>new de(fe.errorContainer,fe.error,15,"nearer",!1)}),fe.onError=le.fromPalette({name:"on_error",palette:e=>e.errorPalette,tone:e=>e.isDark?20:100,background:e=>fe.error,contrastCurve:new pe(4.5,7,11,21)}),fe.errorContainer=le.fromPalette({name:"error_container",palette:e=>e.errorPalette,tone:e=>e.isDark?30:90,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.errorContainer,fe.error,15,"nearer",!1)}),fe.onErrorContainer=le.fromPalette({name:"on_error_container",palette:e=>e.errorPalette,tone:e=>e.isDark?90:10,background:e=>fe.errorContainer,contrastCurve:new pe(4.5,7,11,21)}),fe.primaryFixed=le.fromPalette({name:"primary_fixed",palette:e=>e.primaryPalette,tone:e=>he(e)?40:90,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.primaryFixed,fe.primaryFixedDim,10,"lighter",!0)}),fe.primaryFixedDim=le.fromPalette({name:"primary_fixed_dim",palette:e=>e.primaryPalette,tone:e=>he(e)?30:80,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.primaryFixed,fe.primaryFixedDim,10,"lighter",!0)}),fe.onPrimaryFixed=le.fromPalette({name:"on_primary_fixed",palette:e=>e.primaryPalette,tone:e=>he(e)?100:10,background:e=>fe.primaryFixedDim,secondBackground:e=>fe.primaryFixed,contrastCurve:new pe(4.5,7,11,21)}),fe.onPrimaryFixedVariant=le.fromPalette({name:"on_primary_fixed_variant",palette:e=>e.primaryPalette,tone:e=>he(e)?90:30,background:e=>fe.primaryFixedDim,secondBackground:e=>fe.primaryFixed,contrastCurve:new pe(3,4.5,7,11)}),fe.secondaryFixed=le.fromPalette({name:"secondary_fixed",palette:e=>e.secondaryPalette,tone:e=>he(e)?80:90,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.secondaryFixed,fe.secondaryFixedDim,10,"lighter",!0)}),fe.secondaryFixedDim=le.fromPalette({name:"secondary_fixed_dim",palette:e=>e.secondaryPalette,tone:e=>he(e)?70:80,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.secondaryFixed,fe.secondaryFixedDim,10,"lighter",!0)}),fe.onSecondaryFixed=le.fromPalette({name:"on_secondary_fixed",palette:e=>e.secondaryPalette,tone:e=>10,background:e=>fe.secondaryFixedDim,secondBackground:e=>fe.secondaryFixed,contrastCurve:new pe(4.5,7,11,21)}),fe.onSecondaryFixedVariant=le.fromPalette({name:"on_secondary_fixed_variant",palette:e=>e.secondaryPalette,tone:e=>he(e)?25:30,background:e=>fe.secondaryFixedDim,secondBackground:e=>fe.secondaryFixed,contrastCurve:new pe(3,4.5,7,11)}),fe.tertiaryFixed=le.fromPalette({name:"tertiary_fixed",palette:e=>e.tertiaryPalette,tone:e=>he(e)?40:90,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.tertiaryFixed,fe.tertiaryFixedDim,10,"lighter",!0)}),fe.tertiaryFixedDim=le.fromPalette({name:"tertiary_fixed_dim",palette:e=>e.tertiaryPalette,tone:e=>he(e)?30:80,isBackground:!0,background:e=>fe.highestSurface(e),contrastCurve:new pe(1,1,3,7),toneDeltaPair:e=>new de(fe.tertiaryFixed,fe.tertiaryFixedDim,10,"lighter",!0)}),fe.onTertiaryFixed=le.fromPalette({name:"on_tertiary_fixed",palette:e=>e.tertiaryPalette,tone:e=>he(e)?100:10,background:e=>fe.tertiaryFixedDim,secondBackground:e=>fe.tertiaryFixed,contrastCurve:new pe(4.5,7,11,21)}),fe.onTertiaryFixedVariant=le.fromPalette({name:"on_tertiary_fixed_variant",palette:e=>e.tertiaryPalette,tone:e=>he(e)?90:30,background:e=>fe.tertiaryFixedDim,secondBackground:e=>fe.tertiaryFixed,contrastCurve:new pe(3,4.5,7,11)});class ge{static fromInt(e){const t=se.fromInt(e);return ge.fromHct(t)}static fromHct(e){return new ge(e.hue,e.chroma,e)}static fromHueAndChroma(e,t){return new ge(e,t,ge.createKeyColor(e,t))}constructor(e,t,a){this.hue=e,this.chroma=t,this.keyColor=a,this.cache=new Map}static createKeyColor(e,t){let a=se.from(e,t,50),r=Math.abs(a.chroma-t);for(let s=1;s<50;s+=1){if(Math.round(t)===Math.round(a.chroma))return a;const o=se.from(e,t,50+s),n=Math.abs(o.chroma-t);n<r&&(r=n,a=o);const i=se.from(e,t,50-s),l=Math.abs(i.chroma-t);l<r&&(r=l,a=i)}return a}tone(e){let t=this.cache.get(e);return void 0===t&&(t=se.from(this.hue,this.chroma,e).toInt(),this.cache.set(e,t)),t}getHct(e){return se.fromInt(this.tone(e))}}class ve{static of(e){return new ve(e,!1)}static contentOf(e){return new ve(e,!0)}static fromColors(e){return ve.createPaletteFromColors(!1,e)}static contentFromColors(e){return ve.createPaletteFromColors(!0,e)}static createPaletteFromColors(e,t){const a=new ve(t.primary,e);if(t.secondary){const r=new ve(t.secondary,e);a.a2=r.a1}if(t.tertiary){const r=new ve(t.tertiary,e);a.a3=r.a1}if(t.error){const r=new ve(t.error,e);a.error=r.a1}if(t.neutral){const r=new ve(t.neutral,e);a.n1=r.n1}if(t.neutralVariant){const r=new ve(t.neutralVariant,e);a.n2=r.n2}return a}constructor(e,t){const a=se.fromInt(e),r=a.hue,s=a.chroma;t?(this.a1=ge.fromHueAndChroma(r,s),this.a2=ge.fromHueAndChroma(r,s/3),this.a3=ge.fromHueAndChroma(r+60,s/2),this.n1=ge.fromHueAndChroma(r,Math.min(s/12,4)),this.n2=ge.fromHueAndChroma(r,Math.min(s/6,8))):(this.a1=ge.fromHueAndChroma(r,Math.max(48,s)),this.a2=ge.fromHueAndChroma(r,16),this.a3=ge.fromHueAndChroma(r+60,24),this.n1=ge.fromHueAndChroma(r,4),this.n2=ge.fromHueAndChroma(r,8)),this.error=ge.fromHueAndChroma(25,84)}}class be{get primary(){return this.props.primary}get onPrimary(){return this.props.onPrimary}get primaryContainer(){return this.props.primaryContainer}get onPrimaryContainer(){return this.props.onPrimaryContainer}get secondary(){return this.props.secondary}get onSecondary(){return this.props.onSecondary}get secondaryContainer(){return this.props.secondaryContainer}get onSecondaryContainer(){return this.props.onSecondaryContainer}get tertiary(){return this.props.tertiary}get onTertiary(){return this.props.onTertiary}get tertiaryContainer(){return this.props.tertiaryContainer}get onTertiaryContainer(){return this.props.onTertiaryContainer}get error(){return this.props.error}get onError(){return this.props.onError}get errorContainer(){return this.props.errorContainer}get onErrorContainer(){return this.props.onErrorContainer}get background(){return this.props.background}get onBackground(){return this.props.onBackground}get surface(){return this.props.surface}get onSurface(){return this.props.onSurface}get surfaceVariant(){return this.props.surfaceVariant}get onSurfaceVariant(){return this.props.onSurfaceVariant}get outline(){return this.props.outline}get outlineVariant(){return this.props.outlineVariant}get shadow(){return this.props.shadow}get scrim(){return this.props.scrim}get inverseSurface(){return this.props.inverseSurface}get inverseOnSurface(){return this.props.inverseOnSurface}get inversePrimary(){return this.props.inversePrimary}static light(e){return be.lightFromCorePalette(ve.of(e))}static dark(e){return be.darkFromCorePalette(ve.of(e))}static lightContent(e){return be.lightFromCorePalette(ve.contentOf(e))}static darkContent(e){return be.darkFromCorePalette(ve.contentOf(e))}static lightFromCorePalette(e){return new be({primary:e.a1.tone(40),onPrimary:e.a1.tone(100),primaryContainer:e.a1.tone(90),onPrimaryContainer:e.a1.tone(10),secondary:e.a2.tone(40),onSecondary:e.a2.tone(100),secondaryContainer:e.a2.tone(90),onSecondaryContainer:e.a2.tone(10),tertiary:e.a3.tone(40),onTertiary:e.a3.tone(100),tertiaryContainer:e.a3.tone(90),onTertiaryContainer:e.a3.tone(10),error:e.error.tone(40),onError:e.error.tone(100),errorContainer:e.error.tone(90),onErrorContainer:e.error.tone(10),background:e.n1.tone(99),onBackground:e.n1.tone(10),surface:e.n1.tone(99),onSurface:e.n1.tone(10),surfaceVariant:e.n2.tone(90),onSurfaceVariant:e.n2.tone(30),outline:e.n2.tone(50),outlineVariant:e.n2.tone(80),shadow:e.n1.tone(0),scrim:e.n1.tone(0),inverseSurface:e.n1.tone(20),inverseOnSurface:e.n1.tone(95),inversePrimary:e.a1.tone(80)})}static darkFromCorePalette(e){return new be({primary:e.a1.tone(80),onPrimary:e.a1.tone(20),primaryContainer:e.a1.tone(30),onPrimaryContainer:e.a1.tone(90),secondary:e.a2.tone(80),onSecondary:e.a2.tone(20),secondaryContainer:e.a2.tone(30),onSecondaryContainer:e.a2.tone(90),tertiary:e.a3.tone(80),onTertiary:e.a3.tone(20),tertiaryContainer:e.a3.tone(30),onTertiaryContainer:e.a3.tone(90),error:e.error.tone(80),onError:e.error.tone(20),errorContainer:e.error.tone(30),onErrorContainer:e.error.tone(80),background:e.n1.tone(10),onBackground:e.n1.tone(90),surface:e.n1.tone(10),onSurface:e.n1.tone(90),surfaceVariant:e.n2.tone(30),onSurfaceVariant:e.n2.tone(80),outline:e.n2.tone(60),outlineVariant:e.n2.tone(30),shadow:e.n1.tone(0),scrim:e.n1.tone(0),inverseSurface:e.n1.tone(90),inverseOnSurface:e.n1.tone(20),inversePrimary:e.a1.tone(40)})}constructor(e){this.props=e}toJSON(){return{...this.props}}}function we(e){const t=W(e),a=X(e),r=U(e),s=[t.toString(16),a.toString(16),r.toString(16)];for(const[e,t]of s.entries())1===t.length&&(s[e]="0"+t);return"#"+s.join("")}function ye(e){const t=3===(e=e.replace("#","")).length,a=6===e.length,r=8===e.length;if(!t&&!a&&!r)throw new Error("unexpected hex "+e);let s=0,o=0,n=0;return t?(s=Ce(e.slice(0,1).repeat(2)),o=Ce(e.slice(1,2).repeat(2)),n=Ce(e.slice(2,3).repeat(2))):a?(s=Ce(e.slice(0,2)),o=Ce(e.slice(2,4)),n=Ce(e.slice(4,6))):r&&(s=Ce(e.slice(2,4)),o=Ce(e.slice(4,6)),n=Ce(e.slice(6,8))),(255<<24|(255&s)<<16|(255&o)<<8|255&n)>>>0}function Ce(e){return parseInt(e,16)}function Ee(e,t){void 0===t&&(t=[]);const a=ve.of(e);return{source:e,schemes:{light:be.light(e),dark:be.dark(e)},palettes:{primary:a.a1,secondary:a.a2,tertiary:a.a3,neutral:a.n1,neutralVariant:a.n2,error:a.error},customColors:t.map((t=>function(e,t){let a=t.value;const r=a,s=e;t.blend&&(a=oe.harmonize(r,s));const o=ve.of(a).a1;return{color:t,value:a,light:{color:o.tone(40),onColor:o.tone(100),colorContainer:o.tone(90),onColorContainer:o.tone(10)},dark:{color:o.tone(80),onColor:o.tone(20),colorContainer:o.tone(30),onColorContainer:o.tone(90)}}}(e,t)))}}function ke(e){const t=Math.round,a=e.length,r={};return"rgb"===e.slice(0,3).toLowerCase()?(e=e.replace(" ","").split(","),r[0]=parseInt(e[0].slice("a"===e[3].toLowerCase()?5:4),10),r[1]=parseInt(e[1],10),r[2]=parseInt(e[2],10),r[3]=e[3]?parseFloat(e[3]):-1):(e=a<6?parseInt(String(e[1])+e[1]+e[2]+e[2]+e[3]+e[3]+(a>4?String(e[4])+e[4]:""),16):parseInt(e.slice(1),16),r[0]=e>>16&255,r[1]=e>>8&255,r[2]=255&e,r[3]=9===a||5===a?t((e>>24&255)/255*1e4)/1e4:-1),r}function $e(e,t,a){void 0===a&&(a=.5);const r=Math.round;e=e.trim(),t=t.trim();a=a<0?-1*a:a;const s=ke(e),o=ke(t);return"r"===t[0]?"rgb"+("a"===t[3]?"a(":"(")+r((o[0]-s[0])*a+s[0])+","+r((o[1]-s[1])*a+s[1])+","+r((o[2]-s[2])*a+s[2])+(s[3]<0&&o[3]<0?"":","+(s[3]>-1&&o[3]>-1?r(1e4*((o[3]-s[3])*a+s[3]))/1e4:o[3]<0?s[3]:o[3]))+")":"#"+(4294967296+16777216*(s[3]>-1&&o[3]>-1?r(255*((o[3]-s[3])*a+s[3])):o[3]>-1?r(255*o[3]):s[3]>-1?r(255*s[3]):255)+65536*r((o[0]-s[0])*a+s[0])+256*r((o[1]-s[1])*a+s[1])+r((o[2]-s[2])*a+s[2])).toString(16).slice(s[3]>-1||o[3]>-1?1:3)}const xe=function(e){void 0===e&&(e="");const t=Ee(ye(`#${e.replace("#","")}`));[.05,.08,.11,.12,.14].forEach(((e,a)=>{t.schemes.light.props[`surface${a+1}`]=ye($e(we(t.schemes.light.props.surface),we(t.schemes.light.props.primary),e)),t.schemes.dark.props[`surface${a+1}`]=ye($e(we(t.schemes.dark.props.surface),we(t.schemes.dark.props.primary),e))}));const a=e=>e.split("").map((e=>e.toUpperCase()===e&&"-"!==e&&"7"!==e?`-${e.toLowerCase()}`:e)).join(""),r=e=>["tertiary","shadow","scrim","error","background"].filter((t=>e.toLowerCase().includes(t))).length>0,s={},o={};return Object.keys(t.schemes.light.props).forEach((e=>{r(e)||(s[a(`--f7-md-${e}`)]=we(t.schemes.light.props[e]))})),Object.keys(t.schemes.dark.props).forEach((e=>{r(e)||(o[a(`--f7-md-${e}`)]=we(t.schemes.dark.props[e]))})),{light:s,dark:o}};let Te=0;function Se(e,t){void 0===e&&(e="xxxxxxxxxx"),void 0===t&&(t="0123456789abcdef");const a=t.length;return e.replace(/x/g,(()=>t[Math.floor(Math.random()*a)]))}const Pe='\n  <span class="preloader-inner">\n    <svg viewBox="0 0 36 36">\n      <circle cx="18" cy="18" r="16"></circle>\n    </svg>\n  </span>\n'.trim(),Me=`\n  <span class="preloader-inner">\n    ${[0,1,2,3,4,5,6,7].map((()=>'<span class="preloader-inner-line"></span>')).join("")}\n  </span>\n`.trim();function Oe(e){let t;return e.split("").map(((e,a)=>e.match(/[A-Z]/)&&0!==a&&!t?(t=!0,`:${e.toLowerCase()}`):e.toLowerCase())).join("")}function Ie(e){const t=e;Object.keys(t).forEach((e=>{try{t[e]=null}catch(e){}try{delete t[e]}catch(e){}}))}function Be(e){return o().requestAnimationFrame(e)}function Le(e,t){return void 0===t&&(t=0),setTimeout(e,t)}function De(e){return Be((()=>{Be(e)}))}function Ae(){return Date.now()}function Re(e){const t=o(),a={};let r,s,n,i,l=e||t.location.href;if("string"==typeof l&&l.length)for(l=l.indexOf("?")>-1?l.replace(/\S*\?/,""):"",s=l.split("&").filter((e=>""!==e)),i=s.length,r=0;r<i;r+=1)n=s[r].replace(/#\S+/g,"").split("="),a[decodeURIComponent(n[0])]=void 0===n[1]?void 0:decodeURIComponent(n.slice(1).join("="))||"";return a}function He(e,t){void 0===t&&(t="x");const a=o();let r,s,n;const i=a.getComputedStyle(e,null);return a.WebKitCSSMatrix?(s=i.transform||i.webkitTransform,s.split(",").length>6&&(s=s.split(", ").map((e=>e.replace(",","."))).join(", ")),n=new a.WebKitCSSMatrix("none"===s?"":s)):(n=i.MozTransform||i.OTransform||i.MsTransform||i.msTransform||i.transform||i.getPropertyValue("transform").replace("translate(","matrix(1, 0, 0, 1,"),r=n.toString().split(",")),"x"===t&&(s=a.WebKitCSSMatrix?n.m41:16===r.length?parseFloat(r[12]):parseFloat(r[4])),"y"===t&&(s=a.WebKitCSSMatrix?n.m42:16===r.length?parseFloat(r[13]):parseFloat(r[5])),s||0}function ze(e,t){if(void 0===t&&(t=[]),"string"==typeof e)return e;const a=[];let r;function s(e){if(t.length>0){let a="";for(let e=0;e<t.length;e+=1)a+=0===e?t[e]:`[${encodeURIComponent(t[e])}]`;return`${a}[${encodeURIComponent(e)}]`}return encodeURIComponent(e)}function o(e){return encodeURIComponent(e)}return Object.keys(e).forEach((n=>{let i;if(Array.isArray(e[n])){i=[];for(let a=0;a<e[n].length;a+=1)Array.isArray(e[n][a])||"object"!=typeof e[n][a]?i.push(`${s(n)}[]=${o(e[n][a])}`):(r=t.slice(),r.push(n),r.push(String(a)),i.push(ze(e[n][a],r)));i.length>0&&a.push(i.join("&"))}else null===e[n]||""===e[n]?a.push(`${s(n)}=`):"object"==typeof e[n]?(r=t.slice(),r.push(n),i=ze(e[n],r),""!==i&&a.push(i)):void 0!==e[n]&&""!==e[n]?a.push(`${s(n)}=${o(e[n])}`):""===e[n]&&a.push(s(n))})),a.join("&")}function Ne(e){return"object"==typeof e&&null!==e&&e.constructor&&e.constructor===Object}function Ve(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];const r=t[0];t.splice(0,1);const s=t;for(let e=0;e<s.length;e+=1){const a=t[e];if(null!=a){const e=Object.keys(Object(a));for(let t=0,s=e.length;t<s;t+=1){const s=e[t],o=Object.getOwnPropertyDescriptor(a,s);void 0!==o&&o.enumerable&&(r[s]=a[s])}}}return r}function Fe(){let e,t,a=!0;for(var r=arguments.length,s=new Array(r),o=0;o<r;o++)s[o]=arguments[o];"boolean"==typeof s[0]?(a=s[0],e=s[1],s.splice(0,2),t=s):(e=s[0],s.splice(0,1),t=s);for(let r=0;r<t.length;r+=1){const t=s[r];if(null!=t){const r=Object.keys(Object(t));for(let s=0,o=r.length;s<o;s+=1){const o=r[s],n=Object.getOwnPropertyDescriptor(t,o);void 0!==n&&n.enumerable&&(a?Ne(e[o])&&Ne(t[o])?Fe(e[o],t[o]):!Ne(e[o])&&Ne(t[o])?(e[o]={},Fe(e[o],t[o])):e[o]=t[o]:e[o]=t[o])}}}return e}function _e(e){const t=e.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,((e,t,a,r)=>t+t+a+a+r+r)),a=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return a?a.slice(1).map((e=>parseInt(e,16))):null}function qe(e,t,a){const r=[e,t,a].map((e=>{const t=e.toString(16);return 1===t.length?`0${t}`:t})).join("");return`#${r}`}function je(e,t,a){e/=255,t/=255,a/=255;const r=Math.max(e,t,a),s=Math.min(e,t,a),o=r-s;let n;0===o?n=0:r===e?n=(t-a)/o%6:r===t?n=(a-e)/o+2:r===a&&(n=(e-t)/o+4);const i=(s+r)/2;return n<0&&(n=6+n),[60*n,0===o?0:o/(1-Math.abs(2*i-1)),i]}function Ye(e,t,a){const r=(1-Math.abs(2*a-1))*t,s=e/60,o=r*(1-Math.abs(s%2-1));let n;Number.isNaN(e)||void 0===e?n=[0,0,0]:s<=1?n=[r,o,0]:s<=2?n=[o,r,0]:s<=3?n=[0,r,o]:s<=4?n=[0,o,r]:s<=5?n=[o,0,r]:s<=6&&(n=[r,0,o]);const i=a-r/2;return n.map((e=>Math.max(0,Math.min(255,Math.round(255*(e+i))))))}function We(e,t,a){const r={h:e,s:0,l:0},s=t,o=a;return r.l=(2-s)*o/2,r.s=r.l&&r.l<1?s*o/(r.l<.5?2*r.l:2-2*r.l):r.s,[r.h,r.s,r.l]}function Xe(e,t,a){const r={h:e,s:0,b:0},s=a,o=t*(s<.5?s:1-s);return r.b=s+o,r.s=s>0?2*o/r.b:r.s,[r.h,r.s,r.b]}const Ue=e=>{const t=je(...e),a=[t[0],t[1],Math.max(0,t[2]-.08)],r=[t[0],t[1],Math.max(0,t[2]+.08)];return{shade:qe(...Ye(...a)),tint:qe(...Ye(...r))}};function Ge(){let e,t;for(var a=arguments.length,r=new Array(a),s=0;s<a;s++)r[s]=arguments[s];if(1===r.length?(e=r[0],t=_e(e)):3===r.length&&(t=r,e=qe(...t)),!t)return{};const{light:o,dark:n}=xe(e),i=Ue(t),l=Ue(_e(o["--f7-md-primary"])),c=Ue(_e(n["--f7-md-primary"]));return Object.keys(o).forEach((e=>{e.includes("surface-")&&(o[`${e}-rgb`]=_e(o[e]))})),Object.keys(n).forEach((e=>{e.includes("surface-")&&(n[`${e}-rgb`]=_e(n[e]))})),{ios:{"--f7-theme-color":"var(--f7-ios-primary)","--f7-theme-color-rgb":"var(--f7-ios-primary-rgb)","--f7-theme-color-shade":"var(--f7-ios-primary-shade)","--f7-theme-color-tint":"var(--f7-ios-primary-tint)"},md:{"--f7-theme-color":"var(--f7-md-primary)","--f7-theme-color-rgb":"var(--f7-md-primary-rgb)","--f7-theme-color-shade":"var(--f7-md-primary-shade)","--f7-theme-color-tint":"var(--f7-md-primary-tint)"},light:{"--f7-ios-primary":e,"--f7-ios-primary-shade":i.shade,"--f7-ios-primary-tint":i.tint,"--f7-ios-primary-rgb":t.join(", "),"--f7-md-primary-shade":l.shade,"--f7-md-primary-tint":l.tint,"--f7-md-primary-rgb":_e(o["--f7-md-primary"]).join(", "),...o},dark:{"--f7-md-primary-shade":c.shade,"--f7-md-primary-tint":c.tint,"--f7-md-primary-rgb":_e(n["--f7-md-primary"]).join(", "),...n}}}function Ke(e,t){Object.keys(t).forEach((a=>{Ne(t[a])&&Object.keys(t[a]).forEach((r=>{"function"==typeof t[a][r]&&(t[a][r]=t[a][r].bind(e))})),e[a]=t[a]}))}function Qe(){const e=[];for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];return a.forEach((t=>{Array.isArray(t)?e.push(...Qe(...t)):e.push(t)})),e}var Je=Object.freeze({__proto__:null,bindMethods:Ke,cancelAnimationFrame:function(e){return o().cancelAnimationFrame(e)},colorHexToRgb:_e,colorHsbToHsl:We,colorHslToHsb:Xe,colorHslToRgb:Ye,colorRgbToHex:qe,colorRgbToHsl:je,colorThemeCSSProperties:Ge,colorThemeCSSStyles:function(e){void 0===e&&(e={});const t=e=>{let t="";return Object.keys(e).forEach((a=>{t+=`${a}:${e[a]};`})),t},a=Ge(e.primary),r=[":root{",t(a.light),"--swiper-theme-color:var(--f7-theme-color);",...Object.keys(e).map((t=>`--f7-color-${t}: ${e[t]};`)),"}",".dark{",t(a.dark),"}",".ios, .ios .dark{",t(a.ios),"}",".md, .md .dark{",t(a.md),"}"].join(""),s={};Object.keys(e).forEach((t=>{const a=e[t];s[t]=Ge(a)}));let o="";return Object.keys(e).forEach((a=>{const{light:r,dark:n,ios:i,md:l}=s[a],c="\n    --f7-ios-primary: #ffffff;\n    --f7-ios-primary-shade: #ebebeb;\n    --f7-ios-primary-tint: #ffffff;\n    --f7-ios-primary-rgb: 255, 255, 255;\n    --f7-md-primary-shade: #eee;\n    --f7-md-primary-tint: #fff;\n    --f7-md-primary-rgb: 255, 255, 255;\n    --f7-md-primary: #fff;\n    --f7-md-on-primary: #000;\n    --f7-md-primary-container: #fff;\n    --f7-md-on-primary-container: #000;\n    --f7-md-secondary: #fff;\n    --f7-md-on-secondary: #000;\n    --f7-md-secondary-container: #555;\n    --f7-md-on-secondary-container: #fff;\n    --f7-md-surface: #fff;\n    --f7-md-on-surface: #000;\n    --f7-md-surface-variant: #333;\n    --f7-md-on-surface-variant: #fff;\n    --f7-md-outline: #fff;\n    --f7-md-outline-variant: #fff;\n    --f7-md-inverse-surface: #000;\n    --f7-md-inverse-on-surface: #fff;\n    --f7-md-inverse-primary: #000;\n    --f7-md-surface-1: #f8f8f8;\n    --f7-md-surface-2: #f1f1f1;\n    --f7-md-surface-3: #e7e7e7;\n    --f7-md-surface-4: #e1e1e1;\n    --f7-md-surface-5: #d7d7d7;\n    --f7-md-surface-variant-rgb: 51, 51, 51;\n    --f7-md-on-surface-variant-rgb: 255, 255, 255;\n    --f7-md-surface-1-rgb: 248, 248, 248;\n    --f7-md-surface-2-rgb: 241, 241, 241;\n    --f7-md-surface-3-rgb: 231, 231, 231;\n    --f7-md-surface-4-rgb: 225, 225, 225;\n    --f7-md-surface-5-rgb: 215, 215, 215;\n    ",p="\n    --f7-ios-primary: #000;\n    --f7-ios-primary-shade: #000;\n    --f7-ios-primary-tint: #232323;\n    --f7-ios-primary-rgb: 0, 0, 0;\n    --f7-md-primary-shade: #000;\n    --f7-md-primary-tint: #232323;\n    --f7-md-primary-rgb: 0, 0, 0;\n    --f7-md-primary: #000;\n    --f7-md-on-primary: #fff;\n    --f7-md-primary-container: #000;\n    --f7-md-on-primary-container: #fff;\n    --f7-md-secondary: #000;\n    --f7-md-on-secondary: #fff;\n    --f7-md-secondary-container: #aaa;\n    --f7-md-on-secondary-container: #000;\n    --f7-md-surface: #000;\n    --f7-md-on-surface: #fff;\n    --f7-md-surface-variant: #ccc;\n    --f7-md-on-surface-variant: #000;\n    --f7-md-outline: #000;\n    --f7-md-outline-variant: #000;\n    --f7-md-inverse-surface: #fff;\n    --f7-md-inverse-on-surface: #000;\n    --f7-md-inverse-primary: #fff;\n    --f7-md-surface-1: #070707;\n    --f7-md-surface-2: #161616;\n    --f7-md-surface-3: #232323;\n    --f7-md-surface-4: #303030;\n    --f7-md-surface-5: #373737;\n    --f7-md-surface-variant-rgb: 204, 204, 204;\n    --f7-md-on-surface-variant-rgb: 0, 0, 0;\n    --f7-md-surface-1-rgb: 7, 7, 7;\n    --f7-md-surface-2-rgb: 22, 22, 22;\n    --f7-md-surface-3-rgb: 35, 35, 35;\n    --f7-md-surface-4-rgb: 48, 48, 48;\n    --f7-md-surface-5-rgb: 55, 55, 55;\n    ",d="white"===a?c:"black"===a?p:t(r),u="white"===a?c:"black"===a?p:t(n);o+=[`.color-${a} {`,d,"--swiper-theme-color: var(--f7-theme-color);","}",`.color-${a}.dark, .color-${a} .dark, .dark .color-${a} {`,u,"--swiper-theme-color: var(--f7-theme-color);","}",`.ios .color-${a}, .ios.color-${a}, .ios .dark .color-${a}, .ios .dark.color-${a} {`,t(i),"}",`.md .color-${a}, .md.color-${a}, .md .dark .color-${a}, .md .dark.color-${a} {`,t(l),"}",`.text-color-${a} {`,`--f7-theme-color-text-color: ${e[a]};`,"}",`.bg-color-${a} {`,`--f7-theme-color-bg-color: ${e[a]};`,"}",`.border-color-${a} {`,`--f7-theme-color-border-color: ${e[a]};`,"}",`.ripple-color-${a} {`,`--f7-theme-color-ripple-color: rgba(${r["--f7-ios-primary-rgb"]}, 0.3);`,"}"].join("")})),`${r}${o}`},deleteProps:Ie,eventNameToColonCase:Oe,extend:Fe,flattenArray:Qe,getTranslate:He,id:Se,iosPreloaderContent:Me,isObject:Ne,mdPreloaderContent:Pe,merge:Ve,nextFrame:De,nextTick:Le,now:Ae,parseUrlQuery:Re,requestAnimationFrame:Be,serializeObject:ze,uniqueNumber:function(){return Te+=1,Te}});let Ze,et;function tt(){return Ze||(Ze=function(){const e=o(),t=r();return{touch:!!("ontouchstart"in e||e.DocumentTouch&&t instanceof e.DocumentTouch),pointerEvents:!!e.PointerEvent&&"maxTouchPoints"in e.navigator&&e.navigator.maxTouchPoints>=0,passiveListener:function(){let t=!1;try{const a=Object.defineProperty({},"passive",{get(){t=!0}});e.addEventListener("testPassiveListener",null,a)}catch(e){}return t}(),intersectionObserver:"IntersectionObserver"in e}}()),Ze}const at=(()=>{const e=r();try{return Boolean(e&&e.body&&e.body.getBoundingClientRect&&e.body.getBoundingClientRect().width>0)}catch(e){return!1}})();function rt(e,t){return void 0===e&&(e={}),void 0===t&&(t=at),et&&!t||(et=function(e){let{userAgent:t}=void 0===e?{}:e;const a=tt(),r=o(),s=r.navigator.platform,n=t||r.navigator.userAgent,i={ios:!1,android:!1,androidChrome:!1,desktop:!1,iphone:!1,ipod:!1,ipad:!1,edge:!1,ie:!1,firefox:!1,macos:!1,windows:!1,cordova:!!r.cordova,electron:!1,capacitor:!!r.Capacitor,nwjs:!1},l=r.screen.width,c=r.screen.height,p=n.match(/(Android);?[\s\/]+([\d.]+)?/);let d=n.match(/(iPad).*OS\s([\d_]+)/);const u=n.match(/(iPod)(.*OS\s([\d_]+))?/),h=!d&&n.match(/(iPhone\sOS|iOS|iPhone;\sCPU\sOS)\s([\d_]+)/),m=n.indexOf("MSIE ")>=0||n.indexOf("Trident/")>=0,f=n.indexOf("Edge/")>=0,g=n.indexOf("Gecko/")>=0&&n.indexOf("Firefox/")>=0,v="Win32"===s,b=n.toLowerCase().indexOf("electron")>=0,w="undefined"!=typeof nw&&"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.nw;let y="MacIntel"===s;return!d&&y&&a.touch&&["1024x1366","1366x1024","834x1194","1194x834","834x1112","1112x834","768x1024","1024x768","820x1180","1180x820","810x1080","1080x810"].indexOf(`${l}x${c}`)>=0&&(d=n.match(/(Version)\/([\d.]+)/),d||(d=[0,1,"13_0_0"]),y=!1),i.ie=m,i.edge=f,i.firefox=g,p&&(i.os="android",i.osVersion=p[2],i.android=!0,i.androidChrome=n.toLowerCase().indexOf("chrome")>=0),(d||h||u)&&(i.os="ios",i.ios=!0),h&&!u&&(i.osVersion=h[2].replace(/_/g,"."),i.iphone=!0),d&&(i.osVersion=d[2].replace(/_/g,"."),i.ipad=!0),u&&(i.osVersion=u[3]?u[3].replace(/_/g,"."):null,i.ipod=!0),i.ios&&i.osVersion&&n.indexOf("Version/")>=0&&"10"===i.osVersion.split(".")[0]&&(i.osVersion=n.toLowerCase().split("version/")[1].split(" ")[0]),i.webView=!(!(h||d||u)||!n.match(/.*AppleWebKit(?!.*Safari)/i)&&!r.navigator.standalone)||r.matchMedia&&r.matchMedia("(display-mode: standalone)").matches,i.webview=i.webView,i.standalone=i.webView,i.desktop=!(i.ios||i.android)||b||w,i.desktop&&(i.electron=b,i.nwjs=w,i.macos=y,i.windows=v,i.macos&&(i.os="macos"),i.windows&&(i.os="windows")),i.pixelRatio=r.devicePixelRatio||1,i.prefersColorScheme=function(){let e;return r.matchMedia&&r.matchMedia("(prefers-color-scheme: light)").matches&&(e="light"),r.matchMedia&&r.matchMedia("(prefers-color-scheme: dark)").matches&&(e="dark"),e},i}(e)),et}class st{constructor(e){void 0===e&&(e=[]);this.eventsParents=e,this.eventsListeners={}}on(e,t,a){const r=this;if("function"!=typeof t)return r;const s=a?"unshift":"push";return e.split(" ").forEach((e=>{r.eventsListeners[e]||(r.eventsListeners[e]=[]),r.eventsListeners[e][s](t)})),r}once(e,t,a){const r=this;if("function"!=typeof t)return r;function s(){r.off(e,s),s.f7proxy&&delete s.f7proxy;for(var a=arguments.length,o=new Array(a),n=0;n<a;n++)o[n]=arguments[n];t.apply(r,o)}return s.f7proxy=t,r.on(e,s,a)}off(e,t){const a=this;return a.eventsListeners?(e.split(" ").forEach((e=>{void 0===t?a.eventsListeners[e]=[]:a.eventsListeners[e]&&a.eventsListeners[e].forEach(((r,s)=>{(r===t||r.f7proxy&&r.f7proxy===t)&&a.eventsListeners[e].splice(s,1)}))})),a):a}emit(){const e=this;if(!e.eventsListeners)return e;let t,a,r,s;for(var o=arguments.length,n=new Array(o),i=0;i<o;i++)n[i]=arguments[i];"string"==typeof n[0]||Array.isArray(n[0])?(t=n[0],a=n.slice(1,n.length),r=e,s=e.eventsParents):(t=n[0].events,a=n[0].data,r=n[0].context||e,s=n[0].local?[]:n[0].parents||e.eventsParents);const l=Array.isArray(t)?t:t.split(" "),c=l.map((e=>e.replace("local::",""))),p=l.filter((e=>e.indexOf("local::")<0));return c.forEach((t=>{if(e.eventsListeners&&e.eventsListeners[t]){const s=[];e.eventsListeners[t].forEach((e=>{s.push(e)})),s.forEach((e=>{e.apply(r,a)}))}})),s&&s.length>0&&s.forEach((e=>{e.emit(p,...a)})),e}}class ot extends st{constructor(e,t){void 0===e&&(e={}),void 0===t&&(t=[]),super(t);const a=this;a.params=e,a.params&&a.params.on&&Object.keys(a.params.on).forEach((e=>{a.on(e,a.params.on[e])}))}useModuleParams(e,t){if(e.params){const a={};Object.keys(e.params).forEach((e=>{void 0!==t[e]&&(a[e]=Fe({},t[e]))})),Fe(t,e.params),Object.keys(a).forEach((e=>{Fe(t[e],a[e])}))}}useModulesParams(e){const t=this;t.modules&&Object.keys(t.modules).forEach((a=>{const r=t.modules[a];r.params&&Fe(e,r.params)}))}useModule(e,t){void 0===e&&(e=""),void 0===t&&(t={});const a=this;if(!a.modules)return;const r="string"==typeof e?a.modules[e]:e;r&&(r.instance&&Object.keys(r.instance).forEach((e=>{const t=r.instance[e];a[e]="function"==typeof t?t.bind(a):t})),r.on&&a.on&&Object.keys(r.on).forEach((e=>{a.on(e,r.on[e])})),r.vnode&&(a.vnodeHooks||(a.vnodeHooks={}),Object.keys(r.vnode).forEach((e=>{Object.keys(r.vnode[e]).forEach((t=>{const s=r.vnode[e][t];a.vnodeHooks[t]||(a.vnodeHooks[t]={}),a.vnodeHooks[t][e]||(a.vnodeHooks[t][e]=[]),a.vnodeHooks[t][e].push(s.bind(a))}))}))),r.create&&r.create.bind(a)(t))}useModules(e){void 0===e&&(e={});const t=this;t.modules&&Object.keys(t.modules).forEach((a=>{const r=e[a]||{};t.useModule(a,r)}))}static set components(e){this.use&&this.use(e)}static installModule(e){const t=this;t.prototype.modules||(t.prototype.modules={});const a=e.name||`${Object.keys(t.prototype.modules).length}_${Ae()}`;if(t.prototype.modules[a]=e,e.proto&&Object.keys(e.proto).forEach((a=>{t.prototype[a]=e.proto[a]})),e.static&&Object.keys(e.static).forEach((a=>{t[a]=e.static[a]})),e.install){for(var r=arguments.length,s=new Array(r>1?r-1:0),o=1;o<r;o++)s[o-1]=arguments[o];e.install.apply(t,s)}return t}static use(e){const t=this;if(Array.isArray(e))return e.forEach((e=>t.installModule(e))),t;for(var a=arguments.length,r=new Array(a>1?a-1:0),s=1;s<a;s++)r[s-1]=arguments[s];return t.installModule(e,...r)}}function nt(e){void 0===e&&(e={});const{defaultSelector:t,constructor:a,domProp:r,app:s,addMethods:o}=e,n={create(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];return s?new a(s,...t):new a(...t)},get(e){if(void 0===e&&(e=t),e instanceof a)return e;const s=A(e);return 0!==s.length?s[0][r]:void 0},destroy(e){const t=n.get(e);if(t&&t.destroy)return t.destroy()}};return o&&Array.isArray(o)&&o.forEach((e=>{n[e]=function(a){void 0===a&&(a=t);const r=n.get(a);for(var s=arguments.length,o=new Array(s>1?s-1:0),i=1;i<s;i++)o[i-1]=arguments[i];if(r&&r[e])return r[e](...o)}})),n}function it(e){void 0===e&&(e={});const{defaultSelector:t,constructor:a,app:r}=e,s=Fe(nt({defaultSelector:t,constructor:a,app:r,domProp:"f7Modal"}),{open(e,t,s){let o=A(e);if(o.length>1&&s){const e=A(s).parents(".page");e.length&&o.each((t=>{const a=A(t);a.parents(e)[0]===e[0]&&(o=a)}))}if(o.length>1&&(o=o.eq(o.length-1)),!o.length)return;let n=o[0].f7Modal;if(!n){const e=o.dataset();n=new a(r,{el:o,...e})}return n.open(t)},close(e,s,o){void 0===e&&(e=t);let n=A(e);if(!n.length)return;if(n.length>1){let e;if(o){const t=A(o);t.length&&(e=t.parents(n))}n=e&&e.length>0?e:n.eq(n.length-1)}let i=n[0].f7Modal;if(!i){const e=n.dataset();i=new a(r,{el:n,...e})}return i.close(s)}});return s}const lt=[];const ct=function(e,t){const a=t||{};for(var r=arguments.length,s=new Array(r>2?r-2:0),o=2;o<r;o++)s[o-2]=arguments[o];const n=s||[],i=Object.keys(a).map((e=>"_"===e[0]?a[e]?e.replace("_",""):"":`${e}="${a[e]}"`)).filter((e=>!!e)).join(" ");if(["path","img","circle","polygon","line","input"].indexOf(e)>=0)return`<${e} ${i} />`.trim();return`<${e} ${i}>${n.filter((e=>!!e)).map((e=>Array.isArray(e)?e.join(""):e)).join("")}</${e}>`.trim()};class pt extends ot{constructor(e){if(void 0===e&&(e={}),super(e),pt.instance&&"undefined"!=typeof window)throw new Error("Framework7 is already initialized and can't be initialized more than once");const t=rt({userAgent:e.userAgent||void 0}),a=tt(),s=Fe({},e),n=this;n.device=t,n.support=a;const i=o(),l=r();pt.instance=n;const c={el:"body",theme:"auto",routes:[],name:"Framework7",lazyModulesPath:null,initOnDeviceReady:!0,init:!0,darkMode:void 0,iosTranslucentBars:!0,iosTranslucentModals:!0,component:void 0,componentUrl:void 0,userAgent:null,url:null,colors:{primary:"#007aff",red:"#ff3b30",green:"#4cd964",blue:"#2196f3",pink:"#ff2d55",yellow:"#ffcc00",orange:"#ff9500",purple:"#9c27b0",deeppurple:"#673ab7",lightblue:"#5ac8fa",teal:"#009688",lime:"#cddc39",deeporange:"#ff6b22",white:"#ffffff",black:"#000000"}};return n.useModulesParams(c),n.params=Fe(c,e),Fe(n,{name:n.params.name,routes:n.params.routes,theme:"auto"===n.params.theme?t.ios?"ios":"md":n.params.theme,passedParams:s,online:i.navigator.onLine,colors:n.params.colors,darkMode:n.params.darkMode}),e.store&&(n.params.store=e.store),n.$el&&n.$el[0]&&(n.$el[0].f7=n),n.useModules(),n.initStore(),n.params.init&&(t.cordova&&n.params.initOnDeviceReady?A(l).on("deviceready",(()=>{n.init()})):n.init()),n}setColorTheme(e){if(!e)return;this.colors.primary=e,this.setColors()}setColors(){const e=this,t=r();e.colorsStyleEl||(e.colorsStyleEl=t.createElement("style"),t.head.prepend(e.colorsStyleEl)),e.colorsStyleEl.textContent=e.utils.colorThemeCSSStyles(e.colors)}mount(e){const t=this,a=o(),s=r(),n=A(e||t.params.el).eq(0);t.$el=n,t.$el&&t.$el[0]&&(t.el=t.$el[0],t.el.f7=t,t.rtl="rtl"===n.css("direction"));const i="(prefers-color-scheme: dark)",l="(prefers-color-scheme: light)";t.mq={},a.matchMedia&&(t.mq.dark=a.matchMedia(i),t.mq.light=a.matchMedia(l)),t.colorSchemeListener=function(e){let{matches:a,media:r}=e;if(!a)return;const o=s.querySelector("html");r===i?(o.classList.add("dark"),t.darkMode=!0,t.emit("darkModeChange",!0)):r===l&&(o.classList.remove("dark"),t.darkMode=!1,t.emit("darkModeChange",!1))},t.emit("mount")}initStore(){const e=this;void 0!==e.params.store&&e.params.store.__store?e.store=e.params.store:e.store=e.createStore(e.params.store)}enableAutoDarkMode(){const e=o(),t=r();if(!e.matchMedia)return;const a=this,s=t.querySelector("html");a.mq.dark&&a.mq.light&&(a.mq.dark.addEventListener("change",a.colorSchemeListener),a.mq.light.addEventListener("change",a.colorSchemeListener)),a.mq.dark&&a.mq.dark.matches?(s.classList.add("dark"),a.darkMode=!0,a.emit("darkModeChange",!0)):a.mq.light&&a.mq.light.matches&&(s.classList.remove("dark"),a.darkMode=!1,a.emit("darkModeChange",!1))}disableAutoDarkMode(){if(!o().matchMedia)return;const e=this;e.mq.dark&&e.mq.dark.removeEventListener("change",e.colorSchemeListener),e.mq.light&&e.mq.light.removeEventListener("change",e.colorSchemeListener)}setDarkMode(e){const t=this;"auto"===e?t.enableAutoDarkMode():(t.disableAutoDarkMode(),A("html")[e?"addClass":"removeClass"]("dark"),t.darkMode=e)}initAppComponent(e){const t=this;t.router.componentLoader(t.params.component,t.params.componentUrl,{componentOptions:{el:t.$el[0]}},(a=>{t.$el=A(a),t.$el[0].f7=t,t.$elComponent=a.f7Component,t.el=t.$el[0],e&&e()}),(()=>{}))}init(e){const t=this;t.setColors(),t.mount(e);const a=()=>{if(t.initialized)return;t.$el.addClass("framework7-initializing"),t.rtl&&A("html").attr("dir","rtl"),void 0===t.params.darkMode?t.darkMode=A("html").hasClass("dark"):t.setDarkMode(t.params.darkMode);const e=o();e.addEventListener("offline",(()=>{t.online=!1,t.emit("offline"),t.emit("connection",!1)})),e.addEventListener("online",(()=>{t.online=!0,t.emit("online"),t.emit("connection",!0)})),t.$el.addClass("framework7-root"),A("html").removeClass("ios md").addClass(t.theme),t.params.iosTranslucentBars&&"ios"===t.theme&&A("html").addClass("ios-translucent-bars"),t.params.iosTranslucentModals&&"ios"===t.theme&&A("html").addClass("ios-translucent-modals"),De((()=>{t.$el.removeClass("framework7-initializing")})),t.initialized=!0,t.emit("init")};return t.params.component||t.params.componentUrl?t.initAppComponent((()=>{a()})):a(),t}loadModule(){return pt.loadModule(...arguments)}loadModules(){return pt.loadModules(...arguments)}getVnodeHooks(e,t){const a=this;return a.vnodeHooks&&a.vnodeHooks[e]&&a.vnodeHooks[e][t]||[]}get $(){return A}static get Dom7(){return A}static get $(){return A}static get device(){return rt()}static get support(){return tt()}static get Class(){return ot}static get Events(){return st}}pt.$jsx=ct,pt.ModalMethods=it,pt.ConstructorMethods=nt,pt.loadModule=function(e){const t=this,a=o(),s=r();return new Promise(((r,o)=>{const n=t.instance;let i,l,c;if(e){if("string"==typeof e){const t=e.match(/([a-z0-9-]*)/i);if(e.indexOf(".")<0&&t&&t[0].length===e.length){if(!n||n&&!n.params.lazyModulesPath)return void o(new Error('Framework7: "lazyModulesPath" app parameter must be specified to fetch module by name'));i=`${n.params.lazyModulesPath}/${e}/${e}.lazy.js`}else i=e}else"function"==typeof e?c=e:l=e;if(c){const e=c(t,!1);if(!e)return void o(new Error("Framework7: Can't find Framework7 component in specified component function"));if(t.prototype.modules&&t.prototype.modules[e.name])return void r();p(e),r()}if(l){const e=l;if(!e)return void o(new Error("Framework7: Can't find Framework7 component in specified component"));if(t.prototype.modules&&t.prototype.modules[e.name])return void r();p(e),r()}if(i){if(lt.indexOf(i)>=0)return void r();lt.push(i);const e=new Promise(((e,r)=>{fetch(i).then((e=>e.text())).then((o=>{const n=`f7_component_loader_callback_${Se()}`,l=s.createElement("script");l.innerHTML=`window.${n} = function (Framework7, Framework7AutoInstallComponent) {return ${o.trim()}}`,A("head").append(l);const c=a[n];delete a[n],A(l).remove();const d=c(t,!1);d?(t.prototype.modules&&t.prototype.modules[d.name]||p(d),e()):r(new Error(`Framework7: Can't find Framework7 component in ${i} file`))})).catch((e=>{r(e)}))})),l=new Promise((e=>{fetch(i.replace(".lazy.js",n.rtl?".rtl.css":".css").replace(".js",n.rtl?".rtl.css":".css")).then((e=>e.text())).then((t=>{const a=s.createElement("style");a.innerHTML=t,A("head").append(a),e()})).catch((()=>{e()}))}));Promise.all([e,l]).then((()=>{r()})).catch((e=>{o(e)}))}}else o(new Error("Framework7: Lazy module must be specified"));function p(e){t.use(e),n&&(n.useModuleParams(e,n.params),n.useModule(e))}}))},pt.loadModules=function(e){return Promise.all(e.map((e=>pt.loadModule(e))))};var dt={name:"device",static:{getDevice:rt},on:{init(){const e=r(),t=rt(),a=[],s=e.querySelector("html"),o=e.querySelector('meta[name="apple-mobile-web-app-status-bar-style"]');s&&(t.standalone&&t.ios&&o&&"black-translucent"===o.content&&a.push("device-full-viewport"),a.push(`device-pixel-ratio-${Math.floor(t.pixelRatio)}`),t.os&&!t.desktop?a.push(`device-${t.os}`):t.desktop&&(a.push("device-desktop"),t.os&&a.push(`device-${t.os}`)),t.cordova&&a.push("device-cordova"),t.capacitor&&a.push("device-capacitor"),a.forEach((e=>{s.classList.add(e)})))}}},ut={name:"support",static:{getSupport:tt}},ht={name:"utils",proto:{utils:Je},static:{utils:Je}},mt={name:"resize",create(){const e=this;e.getSize=()=>{if(!e.el)return{width:0,height:0,left:0,top:0};const t=e.$el.offset(),[a,r,s,o]=[e.el.offsetWidth,e.el.offsetHeight,t.left,t.top];return e.width=a,e.height=r,e.left=s,e.top=o,{width:a,height:r,left:s,top:o}}},on:{init(){const e=this,t=o();e.getSize(),t.addEventListener("resize",(()=>{e.emit("resize")}),!1),t.addEventListener("orientationchange",(()=>{e.emit("orientationchange")}))},orientationchange(){const e=r();rt().ipad&&(e.body.scrollLeft=0,setTimeout((()=>{e.body.scrollLeft=0}),0))},resize(){this.getSize()}}};var ft={name:"touch",params:{touch:{touchClicksDistanceThreshold:5,disableContextMenu:!1,tapHold:!1,tapHoldDelay:750,tapHoldPreventClicks:!0,activeState:!0,activeStateElements:"a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus, .card-expandable, .link, .item-link, .accordion-item-toggle",activeStateOnMouseMove:!1,mdTouchRipple:!0,iosTouchRipple:!1,touchRippleElements:".ripple, .link, .item-link, .list label.item-content, .list-button, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus, .list.accordion-list .accordion-item-toggle",touchRippleInsetElements:".ripple-inset, .icon-only, .searchbar-disable-button, .input-clear-button, .notification-close-button, .md .navbar .link.back"}},create(){const e=tt();Fe(this,{touchEvents:{start:e.touch?"touchstart":e.pointerEvents?"pointerdown":"mousedown",move:e.touch?"touchmove":e.pointerEvents?"pointermove":"mousemove",end:e.touch?"touchend":e.pointerEvents?"pointerup":"mouseup"}})},on:{init:function(){const e=this,t=rt(),a=tt(),s=o(),n=r(),i=e.params.touch,l=i[`${e.theme}TouchRipple`];let c,p,d,u,h,m,f,g,v,b,w,y,C;function E(e){const t=A(e),a=t.parents(i.activeStateElements);if(t.closest(".no-active-state").length)return null;let r;if(t.is(i.activeStateElements)&&(r=t),a.length>0&&(r=r?r.add(a):a),r&&r.length>1){const e=[];let t;for(let a=0;a<r.length;a+=1)t||(e.push(r[a]),(r.eq(a).hasClass("prevent-active-state-propagation")||r.eq(a).hasClass("no-active-state-propagation"))&&(t=!0));r=A(e)}return r||t}function k(e){return e.parents(".page-content").length>0}function $(){g&&g.addClass("active-state")}function x(){g&&(g.removeClass("active-state"),g=null)}function T(t,a,r){t&&(b=e.touchRipple.create(e,t,a,r))}function S(){b&&(b.remove(),b=void 0,w=void 0)}function P(e){if(w=function(e){const t=i.touchRippleElements,a=A(e);if(a.is(t))return!a.hasClass("no-ripple")&&a;if(a.parents(t).length>0){const e=a.parents(t).eq(0);return!e.hasClass("no-ripple")&&e}return!1}(e),!w||0===w.length)return void(w=void 0);k(w)?(clearTimeout(y),y=setTimeout((()=>{S(),T(w,c,p)}),80)):(S(),T(w,c,p))}function M(){clearTimeout(y),S()}function O(){b||!w||u?S():(clearTimeout(y),T(w,c,p),setTimeout(S,0))}function I(){A(".active-state").removeClass("active-state"),l&&O()}t.ios&&t.webView&&s.addEventListener("touchstart",(()=>{}));let B=!1,L=null;const D=".dialog-button, .actions-button";let R=!1,H=null;function z(t,a){e.emit({events:t,data:[a]})}function N(e){z("touchstart touchstart:active",e)}function V(e){z("touchmove touchmove:active",e)}function F(e){z("touchend touchend:active",e)}function _(e){z("touchstart:passive",e)}function q(e){z("touchmove:passive",e)}function j(e){z("touchend:passive",e)}const Y=!!a.passiveListener&&{passive:!0},W=!a.passiveListener||{passive:!0,capture:!0},X=!!a.passiveListener&&{passive:!1},U=!a.passiveListener||{passive:!1,capture:!0};n.addEventListener("click",(function(e){z("click",e)}),!0),a.passiveListener?(n.addEventListener(e.touchEvents.start,N,U),n.addEventListener(e.touchEvents.move,V,X),n.addEventListener(e.touchEvents.end,F,X),n.addEventListener(e.touchEvents.start,_,W),n.addEventListener(e.touchEvents.move,q,Y),n.addEventListener(e.touchEvents.end,j,Y)):(n.addEventListener(e.touchEvents.start,(e=>{N(e),_(e)}),!0),n.addEventListener(e.touchEvents.move,(e=>{V(e),q(e)}),!1),n.addEventListener(e.touchEvents.end,(e=>{F(e),j(e)}),!1)),a.touch?(e.on("click",(function(e){const a=e&&e.detail&&"f7Overswipe"===e.detail,r=e&&e.detail&&"f7Segmented"===e.detail,s=e&&e.detail&&"f7TouchMoveActivable"===e.detail;let o=f;return d&&e.target!==d?o=!(a||r||s):s&&(o=!1),i.tapHold&&i.tapHoldPreventClicks&&h&&(o=!0),o&&(e.stopImmediatePropagation(),e.stopPropagation(),e.preventDefault()),i.tapHold&&(m=setTimeout((()=>{h=!1}),t.ios||t.androidChrome?100:400)),f=!1,d=null,!o})),e.on("touchstart",(function(t){return!t.isTrusted||(u=!1,h=!1,f=!1,C=void 0,t.targetTouches.length>1?(g&&x(),!0):(t.touches.length>1&&g&&x(),i.tapHold&&(m&&clearTimeout(m),m=setTimeout((()=>{t&&t.touches&&t.touches.length>1||(h=!0,t.preventDefault(),f=!0,A(t.target).trigger("taphold",t),e.emit("taphold",t))}),i.tapHoldDelay)),d=t.target,c=t.targetTouches[0].pageX,p=t.targetTouches[0].pageY,B=t.target.closest(".segmented-strong .button-active, .segmented-strong .tab-link-active"),R="ios"===e.theme&&t.target.closest(D),B&&(L=B.closest(".segmented-strong")),i.activeState&&(g=E(d),g&&!k(g)?$():g&&(v=setTimeout($,80))),l&&P(d),!0))})),e.on("touchmove",(function(e){if(!e.isTrusted)return;let t,a,r=!0;"touchmove"===e.type&&(t=e.targetTouches[0],a=i.touchClicksDistanceThreshold);const s=e.targetTouches[0].pageX,o=e.targetTouches[0].pageY;if(void 0===C&&(C=!!(C||Math.abs(o-p)>Math.abs(s-c))),(R||!C&&B&&L)&&e.cancelable&&e.preventDefault(),!C&&B&&L){const t=n.elementFromPoint(e.targetTouches[0].clientX,e.targetTouches[0].clientY).closest(".segmented-strong .button:not(.button-active):not(.tab-link-active)");t&&L.contains(t)&&(A(t).trigger("click","f7Segmented"),d=t)}if(a&&t){const e=t.pageX,r=t.pageY;(Math.abs(e-c)>a||Math.abs(r-p)>a)&&(u=!0)}else u=!0;if(u){if(f=!0,R){const t=n.elementFromPoint(e.targetTouches[0].clientX,e.targetTouches[0].clientY);H=t.closest(D),H&&g&&g[0]===H?r=!1:H&&setTimeout((()=>{g=E(H),$()}))}i.tapHold&&clearTimeout(m),i.activeState&&r&&(clearTimeout(v),x()),l&&M()}})),e.on("touchend",(function(e){return!(e.isTrusted&&(C=void 0,B=!1,L=null,R=!1,clearTimeout(v),clearTimeout(m),H&&(A(H).trigger("click","f7TouchMoveActivable"),H=null),n.activeElement===e.target?(i.activeState&&x(),l&&O(),0):(i.activeState&&($(),setTimeout(x,0)),l&&O(),(i.tapHoldPreventClicks&&h||f)&&(e.cancelable&&e.preventDefault(),f=!0,1))))})),n.addEventListener("touchcancel",(function(){d=null,clearTimeout(v),clearTimeout(m),i.activeState&&x(),l&&O()}),{passive:!0})):i.activeState&&(e.on("touchstart",(function(e){const t=E(e.target);t&&(t.addClass("active-state"),"which"in e&&3===e.which&&setTimeout((()=>{A(".active-state").removeClass("active-state")}),0)),l&&(c=e.pageX,p=e.pageY,P(e.target,e.pageX,e.pageY))})),e.on("touchmove",(function(){i.activeStateOnMouseMove||A(".active-state").removeClass("active-state"),l&&M()})),e.on("touchend",I),n.addEventListener("pointercancel",I,{passive:!0})),n.addEventListener("contextmenu",(e=>{i.disableContextMenu&&(t.ios||t.android||t.cordova||s.Capacitor&&s.Capacitor.isNative)&&e.preventDefault(),l&&(g&&x(),O())}))}}};function gt(e,t){void 0===t&&(t={});for(var a=function(e){for(var t=[],a=0;a<e.length;){var r=e[a];if("*"!==r&&"+"!==r&&"?"!==r)if("\\"!==r)if("{"!==r)if("}"!==r)if(":"!==r)if("("!==r)t.push({type:"CHAR",index:a,value:e[a++]});else{var s=1,o="";if("?"===e[i=a+1])throw new TypeError('Pattern cannot start with "?" at '.concat(i));for(;i<e.length;)if("\\"!==e[i]){if(")"===e[i]){if(0==--s){i++;break}}else if("("===e[i]&&(s++,"?"!==e[i+1]))throw new TypeError("Capturing groups are not allowed at ".concat(i));o+=e[i++]}else o+=e[i++]+e[i++];if(s)throw new TypeError("Unbalanced pattern at ".concat(a));if(!o)throw new TypeError("Missing pattern at ".concat(a));t.push({type:"PATTERN",index:a,value:o}),a=i}else{for(var n="",i=a+1;i<e.length;){var l=e.charCodeAt(i);if(!(l>=48&&l<=57||l>=65&&l<=90||l>=97&&l<=122||95===l))break;n+=e[i++]}if(!n)throw new TypeError("Missing parameter name at ".concat(a));t.push({type:"NAME",index:a,value:n}),a=i}else t.push({type:"CLOSE",index:a,value:e[a++]});else t.push({type:"OPEN",index:a,value:e[a++]});else t.push({type:"ESCAPED_CHAR",index:a++,value:e[a++]});else t.push({type:"MODIFIER",index:a,value:e[a++]})}return t.push({type:"END",index:a,value:""}),t}(e),r=t.prefixes,s=void 0===r?"./":r,o="[^".concat(bt(t.delimiter||"/#?"),"]+?"),n=[],i=0,l=0,c="",p=function(e){if(l<a.length&&a[l].type===e)return a[l++].value},d=function(e){var t=p(e);if(void 0!==t)return t;var r=a[l],s=r.type,o=r.index;throw new TypeError("Unexpected ".concat(s," at ").concat(o,", expected ").concat(e))},u=function(){for(var e,t="";e=p("CHAR")||p("ESCAPED_CHAR");)t+=e;return t};l<a.length;){var h=p("CHAR"),m=p("NAME"),f=p("PATTERN");if(m||f){var g=h||"";-1===s.indexOf(g)&&(c+=g,g=""),c&&(n.push(c),c=""),n.push({name:m||i++,prefix:g,suffix:"",pattern:f||o,modifier:p("MODIFIER")||""})}else{var v=h||p("ESCAPED_CHAR");if(v)c+=v;else if(c&&(n.push(c),c=""),p("OPEN")){g=u();var b=p("NAME")||"",w=p("PATTERN")||"",y=u();d("CLOSE"),n.push({name:b||(w?i++:""),pattern:b&&!w?o:w,prefix:g,suffix:y,modifier:p("MODIFIER")||""})}else d("END")}}return n}function vt(e,t){return function(e,t){void 0===t&&(t={});var a=wt(t),r=t.encode,s=void 0===r?function(e){return e}:r,o=t.validate,n=void 0===o||o,i=e.map((function(e){if("object"==typeof e)return new RegExp("^(?:".concat(e.pattern,")$"),a)}));return function(t){for(var a="",r=0;r<e.length;r++){var o=e[r];if("string"!=typeof o){var l=t?t[o.name]:void 0,c="?"===o.modifier||"*"===o.modifier,p="*"===o.modifier||"+"===o.modifier;if(Array.isArray(l)){if(!p)throw new TypeError('Expected "'.concat(o.name,'" to not repeat, but got an array'));if(0===l.length){if(c)continue;throw new TypeError('Expected "'.concat(o.name,'" to not be empty'))}for(var d=0;d<l.length;d++){var u=s(l[d],o);if(n&&!i[r].test(u))throw new TypeError('Expected all "'.concat(o.name,'" to match "').concat(o.pattern,'", but got "').concat(u,'"'));a+=o.prefix+u+o.suffix}}else if("string"!=typeof l&&"number"!=typeof l){if(!c){var h=p?"an array":"a string";throw new TypeError('Expected "'.concat(o.name,'" to be ').concat(h))}}else{u=s(String(l),o);if(n&&!i[r].test(u))throw new TypeError('Expected "'.concat(o.name,'" to match "').concat(o.pattern,'", but got "').concat(u,'"'));a+=o.prefix+u+o.suffix}}else a+=o}return a}}(gt(e,t),t)}function bt(e){return e.replace(/([.+*?=^!:${}()[\]|/\\])/g,"\\$1")}function wt(e){return e&&e.sensitive?"":"i"}function yt(e,t,a){return function(e,t,a){void 0===a&&(a={});for(var r=a.strict,s=void 0!==r&&r,o=a.start,n=void 0===o||o,i=a.end,l=void 0===i||i,c=a.encode,p=void 0===c?function(e){return e}:c,d=a.delimiter,u=void 0===d?"/#?":d,h=a.endsWith,m="[".concat(bt(void 0===h?"":h),"]|$"),f="[".concat(bt(u),"]"),g=n?"^":"",v=0,b=e;v<b.length;v++){var w=b[v];if("string"==typeof w)g+=bt(p(w));else{var y=bt(p(w.prefix)),C=bt(p(w.suffix));if(w.pattern)if(t&&t.push(w),y||C)if("+"===w.modifier||"*"===w.modifier){var E="*"===w.modifier?"?":"";g+="(?:".concat(y,"((?:").concat(w.pattern,")(?:").concat(C).concat(y,"(?:").concat(w.pattern,"))*)").concat(C,")").concat(E)}else g+="(?:".concat(y,"(").concat(w.pattern,")").concat(C,")").concat(w.modifier);else"+"===w.modifier||"*"===w.modifier?g+="((?:".concat(w.pattern,")").concat(w.modifier,")"):g+="(".concat(w.pattern,")").concat(w.modifier);else g+="(?:".concat(y).concat(C,")").concat(w.modifier)}}if(l)s||(g+="".concat(f,"?")),g+=a.endsWith?"(?=".concat(m,")"):"$";else{var k=e[e.length-1],$="string"==typeof k?f.indexOf(k[k.length-1])>-1:void 0===k;s||(g+="(?:".concat(f,"(?=").concat(m,"))?")),$||(g+="(?=".concat(f,"|").concat(m,")"))}return new RegExp(g,wt(a))}(gt(e,a),t,a)}function Ct(e,t,a){return e instanceof RegExp?function(e,t){if(!t)return e;for(var a=/\((?:\?<(.*?)>)?(?!\?)/g,r=0,s=a.exec(e.source);s;)t.push({name:s[1]||r++,prefix:"",suffix:"",modifier:"",pattern:""}),s=a.exec(e.source);return e}(e,t):Array.isArray(e)?function(e,t,a){var r=e.map((function(e){return Ct(e,t,a).source}));return new RegExp("(?:".concat(r.join("|"),")"),wt(a))}(e,t,a):yt(e,t,a)}const Et={queue:[],clearQueue(){if(0===Et.queue.length)return;Et.queue.shift()()},routerQueue:[],clearRouterQueue(){if(0===Et.routerQueue.length)return;const e=Et.routerQueue.pop(),{router:t,stateUrl:a,action:r}=e;let s=t.params.animate;!1===t.params.browserHistoryAnimate&&(s=!1),"back"===r&&t.back({animate:s,browserHistory:!1}),"load"===r&&t.navigate(a,{animate:s,browserHistory:!1})},handle(e){if(Et.blockPopstate)return;let t=e.state;Et.previousState=Et.state,Et.state=t,Et.allowChange=!0,Et.clearQueue(),t=Et.state,t||(t={}),this.views.forEach((e=>{const a=e.router;let r=t[e.id];if(!r&&e.params.browserHistory&&(r={url:e.router.history[0]}),!r)return;const s=r.url||void 0;let o=a.params.animate;!1===a.params.browserHistoryAnimate&&(o=!1),s!==a.url&&(a.history.indexOf(s)>=0?a.allowPageChange?a.back({animate:o,browserHistory:!1}):Et.routerQueue.push({action:"back",router:a}):a.allowPageChange?a.navigate(s,{animate:o,browserHistory:!1}):Et.routerQueue.unshift({action:"load",stateUrl:s,router:a}))}))},initViewState(e,t){const a=o(),r=Fe({},Et.state||{},{[e]:t});Et.state=r,a.history.replaceState(r,"")},push(e,t,a){const s=o(),n=r();if("#!/"===a.substr(-3)&&""===(a=a.replace("#!/",""))&&(a=n.location.href).includes("#!/")&&(a=n.location.href.split("#!/")[0]),!Et.allowChange)return void Et.queue.push((()=>{Et.push(e,t,a)}));Et.previousState=Et.state;const i=Fe({},Et.previousState||{},{[e]:t});Et.state=i,s.history.pushState(i,"",a)},replace(e,t,a){const r=o();if("#!/"===a.substr(-3)&&(a=a.replace("#!/","")),!Et.allowChange)return void Et.queue.push((()=>{Et.replace(e,t,a)}));Et.previousState=Et.state;const s=Fe({},Et.previousState||{},{[e]:t});Et.state=s,r.history.replaceState(s,"",a)},go(e){const t=o();Et.allowChange=!1,t.history.go(e)},back(){const e=o();Et.allowChange=!1,e.history.back()},allowChange:!0,previousState:{},state:{},blockPopstate:!0,init(e){const t=o(),a=r();Et.state=t.history.state,A(t).on("load",(()=>{setTimeout((()=>{Et.blockPopstate=!1}),0)})),a.readyState&&"complete"===a.readyState&&(Et.blockPopstate=!1),A(t).on("popstate",Et.handle.bind(e))}};function kt(e){const t=e,{$el:a,$navbarsEl:r,app:s,params:o}=t,n=tt(),i=rt();let l=!1,c=!1;const p={};let d,u,h,m,f,g,v,b,w=[],y=[],C=!0,E=[],k=[];const $=o[`${s.theme}SwipeBackAnimateShadow`],x=o[`${s.theme}SwipeBackAnimateOpacity`],T=o[`${s.theme}SwipeBackActiveArea`],S=o[`${s.theme}SwipeBackThreshold`],P=s.rtl?"right center":"left center",M=s.rtl?"calc(100% - var(--f7-navbar-large-title-padding-left) - var(--f7-safe-area-left)) center":"calc(var(--f7-navbar-large-title-padding-left) + var(--f7-safe-area-left)) center";function O(e){let{progress:t,reset:a,transition:r,reflow:s}=void 0===e?{}:e;const o=["overflow","transform","transform-origin","opacity"];if(!0===r||!1===r)for(let e=0;e<b.length;e+=1){const t=b[e];t&&t.el&&(!0===r&&t.el.classList.add("navbar-page-transitioning"),!1===r&&t.el.classList.remove("navbar-page-transitioning"))}s&&b.length&&b[0]&&b[0].el&&(b[0].el._clientLeft=b[0].el.clientLeft);for(let e=0;e<b.length;e+=1){const r=b[e];if(r&&r.el){!r.className||r.classNameSet||a||(r.el.classList.add(r.className),r.classNameSet=!0),r.className&&a&&r.el.classList.remove(r.className);for(let e=0;e<o.length;e+=1){const s=o[e];r[s]&&(a?r.el.style[s]="":"function"==typeof r[s]?r.el.style[s]=r[s](t):r.el.style[s]=r[s])}}}}function I(e){if(!e.isTrusted)return;const a=o[`${s.theme}SwipeBack`];!C||!a||l||s.swipeout&&s.swipeout.el||!t.allowPageChange||A(e.target).closest(".range-slider, .calendar-months").length>0||A(e.target).closest(".page-master, .page-master-detail").length>0&&o.masterDetailBreakpoint>0&&s.width>=o.masterDetailBreakpoint||(c=!1,l=!0,d=void 0,p.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,p.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,m=Ae(),f=t.dynamicNavbar)}function B(e){if(!e.isTrusted)return;if(!l)return;const n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,m="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===d&&(d=!!(d||Math.abs(m-p.y)>Math.abs(n-p.x))||n<p.x&&!s.rtl||n>p.x&&s.rtl),d||e.f7PreventSwipeBack||s.preventSwipeBack)return void(l=!1);if(!c){let t=!1;const n=A(e.target),c=n.closest(".swipeout");c.length>0&&(!s.rtl&&c.find(".swipeout-actions-left").length>0&&(t=!0),s.rtl&&c.find(".swipeout-actions-right").length>0&&(t=!0)),w=n.closest(".page"),(w.hasClass("no-swipeback")||n.closest(".no-swipeback, .card-opened").length>0)&&(t=!0),y=a.find(".page-previous"),y.length>1&&(y=y.eq(y.length-1));let d=p.x-a.offset().left>T;if(u=a.width(),d=s.rtl?p.x<a.offset().left-a[0].scrollLeft+(u-T):p.x-a.offset().left>T,d&&(t=!0),0!==y.length&&0!==w.length||(t=!0),t)return void(l=!1);$&&(g=w.find(".page-shadow-effect"),0===g.length&&(g=A('<div class="page-shadow-effect"></div>'),w.append(g))),x&&(v=y.find(".page-opacity-effect"),0===v.length&&(v=A('<div class="page-opacity-effect"></div>'),y.append(v))),f&&(E=r.find(".navbar-current"),k=r.find(".navbar-previous"),k.length>1&&(k=k.eq(k.length-1)),b=function(){const e=[],t=s.rtl?-1:1,a=E.hasClass("navbar-transparent")&&!E.hasClass("navbar-large")&&!E.hasClass("navbar-transparent-visible"),r=E.hasClass("navbar-large"),n=E.hasClass("navbar-large-collapsed"),l=E.hasClass("navbar-large-transparent")||E.hasClass("navbar-large")&&E.hasClass("navbar-transparent"),c=k.hasClass("navbar-transparent")&&!k.hasClass("navbar-large")&&!k.hasClass("navbar-transparent-visible"),p=k.hasClass("navbar-large"),d=k.hasClass("navbar-large-collapsed"),u=k.hasClass("navbar-large-transparent")||k.hasClass("navbar-large")&&k.hasClass("navbar-transparent"),h=r&&!n,m=p&&!d,f=E.find(".left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg"),g=k.find(".left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg");let v,b;return o.iosAnimateNavbarBackIcon&&(v=E.hasClass("sliding")||E.find(".navbar-inner.sliding").length?E.find(".left").find(".back .icon + span").eq(0):E.find(".left.sliding").find(".back .icon + span").eq(0),b=k.hasClass("sliding")||k.find(".navbar-inner.sliding").length?k.find(".left").find(".back .icon + span").eq(0):k.find(".left.sliding").find(".back .icon + span").eq(0),v.length&&g.each((e=>{A(e).hasClass("title")&&(e.f7NavbarLeftOffset+=v.prev(".icon")[0].offsetWidth)}))),f.each((s=>{const c=A(s),p=c.hasClass("subnavbar"),d=c.hasClass("left"),u=c.hasClass("title"),f=c.hasClass("navbar-bg");if((u||f)&&a)return;if(!h&&c.hasClass(".title-large"))return;const g={el:s};if(h){if(u)return;if(c.hasClass("title-large"))return e.indexOf(g)<0&&e.push(g),g.overflow="visible",void c.find(".title-large-text").each((a=>{e.push({el:a,transform:e=>`translateX(${100*e*t}%)`})}))}if(m&&(h||c.hasClass("title-large")&&(e.indexOf(g)<0&&e.push(g),g.opacity=0),d))return e.indexOf(g)<0&&e.push(g),g.opacity=e=>1-e**.33,void c.find(".back span").each((t=>{e.push({el:t,"transform-origin":P,transform:e=>`translateX(calc(${e} * (var(--f7-navbarTitleLargeOffset) - var(--f7-navbarLeftTextOffset)))) translateY(calc(${e} * (var(--f7-navbar-large-title-height) - var(--f7-navbar-large-title-padding-vertical) / 2))) scale(${1+1*e})`})}));if(f)return e.indexOf(g)<0&&e.push(g),h||m||(n?(l&&(g.className="ios-swipeback-navbar-bg-large"),g.transform=e=>`translateX(${100*e*t}%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))`):g.transform=e=>`translateX(${100*e*t}%)`),!h&&m&&(g.className="ios-swipeback-navbar-bg-large",g.transform=e=>`translateX(${100*e*t}%) translateY(calc(-1 * ${1-e} * var(--f7-navbar-large-title-height)))`),h&&m&&(g.transform=e=>`translateX(${100*e*t}%)`),void(h&&!m&&(g.transform=e=>`translateX(${100*e*t}%) translateY(calc(-${e} * var(--f7-navbar-large-title-height)))`));if(c.hasClass("title-large"))return;const b=c.hasClass("sliding")||c.parents(".navbar-inner.sliding").length;if(e.indexOf(g)<0&&e.push(g),(!p||p&&!b)&&(g.opacity=e=>1-e**.33),b){let t=g;if(d&&v.length&&o.iosAnimateNavbarBackIcon){const a={el:v[0]};t=a,e.push(a)}t.transform=e=>{let a=e*t.el.f7NavbarRightOffset;return 1===i.pixelRatio&&(a=Math.round(a)),p&&r?`translate3d(${a}px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)`:`translate3d(${a}px,0,0)`}}})),g.each((a=>{const r=A(a),s=r.hasClass("subnavbar"),n=r.hasClass("left"),l=r.hasClass("title"),f=r.hasClass("navbar-bg");if((l||f)&&c)return;const g={el:a};if(m){if(l)return;if(e.indexOf(g)<0&&e.push(g),r.hasClass("title-large"))return g.opacity=1,g.overflow="visible",void r.find(".title-large-text").each((t=>{e.push({el:t,"transform-origin":M,opacity:e=>e**3,transform:e=>`translateX(calc(${1-e} * (var(--f7-navbarLeftTextOffset) - var(--f7-navbarTitleLargeOffset)))) translateY(calc(${e-1} * var(--f7-navbar-large-title-height) + ${1-e} * var(--f7-navbar-large-title-padding-vertical))) scale(${.5+.5*e})`})}))}if(f)return e.indexOf(g)<0&&e.push(g),h||m||(d?(u&&(g.className="ios-swipeback-navbar-bg-large"),g.transform=e=>`translateX(${(100*e-100)*t}%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))`):g.transform=e=>`translateX(${(100*e-100)*t}%)`),!h&&m&&(g.transform=e=>`translateX(${(100*e-100)*t}%) translateY(calc(-1 * ${1-e} * var(--f7-navbar-large-title-height)))`),h&&!m&&(g.className="ios-swipeback-navbar-bg-large",g.transform=e=>`translateX(${(100*e-100)*t}%) translateY(calc(-${e} * var(--f7-navbar-large-title-height)))`),void(h&&m&&(g.transform=e=>`translateX(${(100*e-100)*t}%)`));if(r.hasClass("title-large"))return;const v=r.hasClass("sliding")||k.children(".navbar-inner.sliding").length;if(e.indexOf(g)<0&&e.push(g),(!s||s&&!v)&&(g.opacity=e=>e**3),v){let t=g;if(n&&b.length&&o.iosAnimateNavbarBackIcon){const a={el:b[0]};t=a,e.push(a)}t.transform=e=>{let a=t.el.f7NavbarLeftOffset*(1-e);return 1===i.pixelRatio&&(a=Math.round(a)),s&&p?`translate3d(${a}px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)`:`translate3d(${a}px,0,0)`}}})),e}()),A(".sheet.modal-in").length>0&&s.sheet&&s.sheet.close(A(".sheet.modal-in"))}e.f7PreventSwipePanel=!0,c=!0,s.preventSwipePanelBySwipeBack=!0,e.preventDefault();const C=s.rtl?-1:1;h=(n-p.x-S)*C,h<0&&(h=0);const I=Math.min(Math.max(h/u,0),1),B={percentage:I,progress:I,currentPageEl:w[0],previousPageEl:y[0],currentNavbarEl:E[0],previousNavbarEl:k[0]};a.trigger("swipeback:move",B),t.emit("swipebackMove",B);let L=h*C,D=(h/5-u/5)*C;s.rtl?(L=Math.max(L,-u),D=Math.max(D,0)):(L=Math.min(L,u),D=Math.min(D,0)),1===i.pixelRatio&&(L=Math.round(L),D=Math.round(D)),t.swipeBackActive=!0,A([w[0],y[0]]).addClass("page-swipeback-active"),w.transform(`translate3d(${L}px,0,0)`),$&&(g[0].style.opacity=1-1*I),"ios"===s.theme&&y.transform(`translate3d(${D}px,0,0)`),x&&(v[0].style.opacity=1-1*I),f&&O({progress:I})}function L(e){if(!e.isTrusted)return;if(s.preventSwipePanelBySwipeBack=!1,!l||!c)return l=!1,void(c=!1);l=!1,c=!1,t.swipeBackActive=!1;const r=A([w[0],y[0]]);if(r.removeClass("page-swipeback-active"),0===h)return r.transform(""),g&&g.length>0&&g.remove(),v&&v.length>0&&v.remove(),void(f&&O({reset:!0}));const n=Ae()-m;let p=!1;(n<300&&h>10||n>=300&&h>u/2)&&(w.removeClass("page-current").addClass("page-next"+("ios"!==s.theme?" page-next-on-right":"")),y.removeClass("page-previous").addClass("page-current").removeAttr("aria-hidden"),g&&(g[0].style.opacity=""),v&&(v[0].style.opacity=""),f&&(t.setNavbarPosition(E,"next"),t.setNavbarPosition(k,"current",!1)),p=!0),r.addClass("page-transitioning page-transitioning-swipeback"),i.ios&&(w[0]._clientLeft=w[0].clientLeft),r.transform(""),f&&O({progress:p?1:0,transition:!0,reflow:!!i.ios}),C=!1,t.allowPageChange=!1;const d={currentPageEl:w[0],previousPageEl:y[0],currentNavbarEl:E[0],previousNavbarEl:k[0]};p?(t.currentRoute=y[0].f7Page.route,t.currentPage=y[0],t.pageCallback("beforeOut",w,E,"current","next",{route:w[0].f7Page.route,swipeBack:!0}),t.pageCallback("beforeIn",y,k,"previous","current",{route:y[0].f7Page.route,swipeBack:!0},w[0]),a.trigger("swipeback:beforechange",d),t.emit("swipebackBeforeChange",d)):(a.trigger("swipeback:beforereset",d),t.emit("swipebackBeforeReset",d)),w.transitionEnd((()=>{r.removeClass("page-transitioning page-transitioning-swipeback"),f&&O({reset:!0,transition:!1}),C=!0,t.allowPageChange=!0,p?(1===t.history.length&&t.history.unshift(t.url),t.history.pop(),t.saveHistory(),o.browserHistory&&Et.back(),t.pageCallback("afterOut",w,E,"current","next",{route:w[0].f7Page.route,swipeBack:!0}),t.pageCallback("afterIn",y,k,"previous","current",{route:y[0].f7Page.route,swipeBack:!0}),t.pageCallback("beforeRemove",w,E,"next",{swipeBack:!0}),t.removePage(w),f&&t.removeNavbar(E),a.trigger("swipeback:afterchange",d),t.emit("swipebackAfterChange",d),t.emit("routeChanged",t.currentRoute,t.previousRoute,t),o.preloadPreviousPage&&t.back(t.history[t.history.length-2],{preload:!0})):(a.trigger("swipeback:afterreset",d),t.emit("swipebackAfterReset",d)),g&&g.length>0&&g.remove(),v&&v.length>0&&v.remove()}))}!function(){const e=!("touchstart"!==s.touchEvents.start||!n.passiveListener)&&{passive:!0,capture:!1};a.on(s.touchEvents.start,I,e),s.on("touchmove:active",B),s.on("touchend:passive",L)}(),t.on("routerDestroy",(function(){const e=!("touchstart"!==s.touchEvents.start||!n.passiveListener)&&{passive:!0,capture:!1};a.off(s.touchEvents.start,I,e),s.off("touchmove:active",B),s.off("touchend:passive",L)}))}function $t(e,t,a){const r=this,s=t.route.redirect,o="forward"===e?"navigate":"back";if(a.initial&&r.params.browserHistory&&(a.replaceState=!0,a.history=!0),"function"==typeof s){r.allowPageChange=!1;const n=s.call(r,{router:r,to:t,resolve:function(e,t){void 0===t&&(t={}),r.allowPageChange=!0,r[o](e,Fe({},a,t))},reject:function(){r.allowPageChange=!0},direction:e,app:r.app});return n&&"string"==typeof n?(r.allowPageChange=!0,r[o](n,a)):r}return r[o](s,a)}function xt(e,t,a,r,s,o,n,i){const l=[];Array.isArray(a)?l.push(...a):a&&"function"==typeof a&&l.push(a),t&&(Array.isArray(t)?l.push(...t):l.push(t)),function t(){if(0===l.length)return void o();l.shift().call(e,{router:e,to:r,from:s,resolve(){t()},reject(){n()},direction:i,app:e.app})}()}function Tt(e,t,a,r,s){const o=this;function n(){e&&e.route&&(o.params.routesBeforeEnter||e.route.beforeEnter)?(o.allowPageChange=!1,xt(o,o.params.routesBeforeEnter,e.route.beforeEnter,e,t,(()=>{o.allowPageChange=!0,a()}),(()=>{r()}),s)):a()}t&&t.route&&(o.params.routesBeforeLeave||t.route.beforeLeave)?(o.allowPageChange=!1,xt(o,o.params.routesBeforeLeave,t.route.beforeLeave,e,t,(()=>{o.allowPageChange=!0,n()}),(()=>{r()}),s)):n()}function St(e,t){if(!e.view)throw new Error(`Framework7: it is not allowed to use router methods on global app router. Use router methods only on related View, e.g. app.views.main.router.${t}(...)`)}function Pt(e,t,a,r){function s(e){e.then((e=>{a({component:e.default||e._default||e})})).catch((e=>{throw r(),new Error(e,{cause:e})}))}if(t instanceof Promise)return void s(t);const o=t.call(e);o instanceof Promise?s(o):a({component:o})}function Mt(e,t,a){void 0===a&&(a={});const s=r(),o=A(t),n=e.app,i=e.view,l=Fe(!1,{animate:e.params.animate,browserHistory:!0,replaceState:!1,history:!0,reloadCurrent:e.params.reloadPages,reloadPrevious:!1,reloadAll:!1,clearPreviousHistory:!1,reloadDetail:e.params.reloadDetail,on:{}},a),c=e.params.masterDetailBreakpoint>0,p=c&&l.route&&l.route.route&&(!0===l.route.route.master||"function"==typeof l.route.route.master&&l.route.route.master(n,e));let d,u,h,m=0,f=e.currentRoute.modal;if(f||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((t=>{e.currentRoute&&e.currentRoute.route&&e.currentRoute.route[t]&&(f=!0,h=t)})),f){const t=e.currentRoute.modal||e.currentRoute.route.modalInstance||n[h].get(),a=e.history[e.history.length-2];let r=e.findMatchingRoute(a);!r&&a&&(r={url:a,path:a.split("?")[0],query:Re(a),route:{path:a.split("?")[0],url:a}}),e.modalRemove(t)}const g=e.dynamicNavbar,v=e.$el,b=o,w=l.reloadPrevious||l.reloadCurrent||l.reloadAll;let y,C,E,k;if(e.allowPageChange=!1,0===b.length)return e.allowPageChange=!0,e;b.length&&e.removeThemeElements(b),g&&(E=b.children(".navbar"),C=e.$navbarsEl,0===E.length&&b[0]&&b[0].f7Page&&(E=b[0].f7Page.$navbarEl)),l.route&&l.route.route&&l.route.route.keepAlive&&!l.route.route.keepAliveData&&(l.route.route.keepAliveData={pageEl:o[0]});const $=v.children(".page").filter((e=>e!==b[0]));let x,T,S,P;if(g&&(x=C.children(".navbar").filter((e=>e!==E[0]))),l.reloadPrevious&&$.length<2)return e.allowPageChange=!0,e;if(c&&!l.reloadAll){for(let e=0;e<$.length;e+=1)d||!$[e].classList.contains("page-master")||(d=$[e]);if(T=!p&&d,T&&d)for(let e=0;e<$.length;e+=1)$[e].classList.contains("page-master-detail")&&(u=$[e]);S=T&&l.reloadDetail&&n.width>=e.params.masterDetailBreakpoint&&d}T&&(P=!u||S||l.reloadAll||l.reloadCurrent);let M="next";if(l.reloadCurrent||l.reloadAll||S?M="current":l.reloadPrevious&&(M="previous"),b.removeClass("page-previous page-current page-next").addClass(`page-${M}${p?" page-master":""}${T?" page-master-detail":""}${P?" page-master-detail-root":""}`).trigger("page:unstack").trigger("page:position",{position:M}),e.emit("pageUnstack",b[0]),e.emit("pagePosition",b[0],M),(p||T)&&(b.trigger("page:role",{role:p?"master":"detail",root:!!P}),e.emit("pageRole",b[0],{role:p?"master":"detail",detailRoot:!!P})),g&&E.length&&(E.removeClass("navbar-previous navbar-current navbar-next").addClass(`navbar-${M}${p?" navbar-master":""}${T?" navbar-master-detail":""}${P?" navbar-master-detail-root":""}`),E.trigger("navbar:position",{position:M}),e.emit("navbarPosition",E[0],M),(p||T)&&e.emit("navbarRole",E[0],{role:p?"master":"detail",detailRoot:!!P})),l.reloadCurrent||S)S?(y=$.filter((e=>!e.classList.contains("page-master"))),g&&(k=A(y.map((e=>n.navbar.getElByPage(e))))),y.length>1&&d&&(m=y.length-1,A(d).removeClass("page-master-stacked").trigger("page:masterunstack"),e.emit("pageMasterUnstack",d),g&&(A(n.navbar.getElByPage(d)).removeClass("navbar-master-stacked"),e.emit("navbarMasterUnstack",n.navbar.getElByPage(d))))):(y=$.eq($.length-1),g&&(k=A(n.navbar.getElByPage(y))));else if(l.reloadPrevious)y=$.eq($.length-2),g&&(k=A(n.navbar.getElByPage(y)));else if(l.reloadAll)y=$.filter((e=>e!==b[0])),g&&(k=x.filter((e=>e!==E[0])));else{let t=[],a=[];if($.length>1){let r=0;for(r=0;r<$.length-1;r+=1){if(d&&$[r]===d){$.eq(r).addClass("page-master-stacked"),$.eq(r).trigger("page:masterstack"),e.emit("pageMasterStack",$[r]),g&&(A(n.navbar.getElByPage(d)).addClass("navbar-master-stacked"),e.emit("navbarMasterStack",n.navbar.getElByPage(d)));continue}const s=n.navbar.getElByPage($.eq(r));t.push($[r]),e.pageCallback("beforeRemove",$[r],x&&x[r],"previous",void 0,l),e.removePage($[r]),g&&s&&(a.push(s),e.removeNavbar(s))}}y=v.children(".page").filter((e=>e!==b[0]&&t.indexOf(e)<0)),g&&(k=C.children(".navbar").filter((e=>e!==E[0]&&a.indexOf(a)<0))),t=[],a=[]}if(T&&!l.reloadAll&&((y.length>1||S)&&(y=y.filter((e=>!e.classList.contains("page-master")))),k&&(k.length>1||S)&&(k=k.filter((e=>!e.classList.contains("navbar-master"))))),e.params.browserHistory&&(l.browserHistory||l.replaceState)&&!l.reloadPrevious){const t=e.params.browserHistoryRoot||"";Et[l.reloadCurrent||S&&u||l.reloadAll||l.replaceState?"replace":"push"](i.id,{url:l.route.url},t+e.params.browserHistorySeparator+l.route.url)}l.reloadPrevious||(e.currentPageEl=b[0],g&&E.length?e.currentNavbarEl=E[0]:delete e.currentNavbarEl,e.currentRoute=l.route);const O=l.route.url;l.history&&(((l.reloadCurrent||S&&u)&&e.history.length)>0||l.replaceState?(S&&m>0&&(e.history=e.history.slice(0,e.history.length-m),e.propsHistory=e.propsHistory.slice(0,e.propsHistory.length-m)),e.history[e.history.length-(l.reloadPrevious?2:1)]=O,e.propsHistory[e.propsHistory.length-(l.reloadPrevious?2:1)]=l.props||{}):l.reloadPrevious?(e.history[e.history.length-2]=O,e.propsHistory[e.propsHistory.length-2]=l.props||{}):l.reloadAll?(e.history=[O],e.propsHistory=[l.props||{}]):(e.history.push(O),e.propsHistory.push(l.props||{}))),e.saveHistory();const I=b.parents(s).length>0,B=b[0].f7Component;if(l.reloadPrevious?(B&&!I?B.mount((e=>{A(e).insertBefore(y)})):b.insertBefore(y),g&&E.length&&(E.find(".title-large").length&&E.addClass("navbar-large"),k.length?E.insertBefore(k):(e.$navbarsEl.parents(s).length||e.$el.prepend(e.$navbarsEl),C.append(E)))):(y.next(".page")[0]!==b[0]&&(B&&!I?B.mount((e=>{v.append(e)})):v.append(b[0])),g&&E.length&&(E.find(".title-large").length&&E.addClass("navbar-large"),e.$navbarsEl.parents(s).length||e.$el.prepend(e.$navbarsEl),C.append(E[0]))),I?l.route&&l.route.route&&l.route.route.keepAlive&&!b[0].f7PageMounted&&(b[0].f7PageMounted=!0,e.pageCallback("mounted",b,E,M,w?M:"current",l,y)):e.pageCallback("mounted",b,E,M,w?M:"current",l,y),(l.reloadCurrent||S)&&y.length>0?(e.pageCallback("beforeOut",y,k,"current",void 0,l),e.pageCallback("afterOut",y,k,"current",void 0,l),e.pageCallback("beforeRemove",y,k,"current",void 0,l),e.removePage(y),g&&k&&k.length&&e.removeNavbar(k)):l.reloadAll?y.each(((t,a)=>{const r=A(t),s=A(n.navbar.getElByPage(r));r.hasClass("page-current")&&(e.pageCallback("beforeOut",y,k,"current",void 0,l),e.pageCallback("afterOut",y,k,"current",void 0,l)),e.pageCallback("beforeRemove",r,k&&k.eq(a),"previous",void 0,l),e.removePage(r),g&&s.length&&e.removeNavbar(s)})):l.reloadPrevious&&(e.pageCallback("beforeRemove",y,k,"previous",void 0,l),e.removePage(y),g&&k&&k.length&&e.removeNavbar(k)),l.route.route.tab&&e.tabLoad(l.route.route.tab,Fe({},l,{history:!1,browserHistory:!1})),c&&i.checkMasterDetailBreakpoint(),e.pageCallback("init",b,E,M,w?M:"current",l,y),l.reloadCurrent||l.reloadAll||S)return e.allowPageChange=!0,e.pageCallback("beforeIn",b,E,M,"current",l),b.removeAttr("aria-hidden"),g&&E&&E.removeAttr("aria-hidden"),e.pageCallback("afterIn",b,E,M,"current",l),l.reloadCurrent&&l.clearPreviousHistory&&e.clearPreviousHistory(),S&&(e.setPagePosition(A(d),"previous"),d.f7Page&&d.f7Page.navbarEl&&e.setNavbarPosition(A(d.f7Page.navbarEl),"previous")),e;if(l.reloadPrevious)return e.allowPageChange=!0,e;function L(){e.setPagePosition(b,"current",!1),e.setPagePosition(y,"previous",!y.hasClass("page-master")),g&&(e.setNavbarPosition(E,"current",!1),e.setNavbarPosition(k,"previous",!k.hasClass("navbar-master"))),e.allowPageChange=!0,e.pageCallback("afterOut",y,k,"current","previous",l),e.pageCallback("afterIn",b,E,"next","current",l);let t=(e.params.preloadPreviousPage||e.params[`${n.theme}SwipeBack`])&&!p;t||(b.hasClass("smart-select-page")||b.hasClass("photo-browser-page")||b.hasClass("autocomplete-page")||b.hasClass("color-picker-page"))&&(t=!0),t||b.attr("data-name")&&"smart-select-page"===b.attr("data-name")||(e.pageCallback("beforeRemove",y,k,"previous",void 0,l),e.removePage(y),g&&k.length&&e.removeNavbar(k)),l.clearPreviousHistory&&e.clearPreviousHistory(),e.emit("routeChanged",e.currentRoute,e.previousRoute,e),e.params.browserHistory&&Et.clearRouterQueue()}function D(){e.setPagePosition(y,"current",!1),e.setPagePosition(b,"next",!1),g&&(e.setNavbarPosition(k,"current",!1),e.setNavbarPosition(E,"next",!1))}if(e.pageCallback("beforeOut",y,k,"current","previous",l),e.pageCallback("beforeIn",b,E,"next","current",l),!l.animate||p&&n.width>=e.params.masterDetailBreakpoint)L();else{const t=e.params[`${e.app.theme}PageLoadDelay`];let a=e.params.transition;l.transition&&(a=l.transition),!a&&e.currentRoute&&e.currentRoute.route&&(a=e.currentRoute.route.transition),!a&&e.currentRoute&&e.currentRoute.route.options&&(a=e.currentRoute.route.options.transition),a&&(b[0].f7PageTransition=a),t?setTimeout((()=>{D(),e.animate(y,b,k,E,"forward",a,(()=>{L()}))}),t):(D(),e.animate(y,b,k,E,"forward",a,(()=>{L()})))}return e}function Ot(e,t,a,r){if(void 0===t&&(t={}),void 0===a&&(a={}),!e.allowPageChange&&!r)return e;const s=t,o=a,{url:n,content:i,el:l,pageName:c,component:p,componentUrl:d}=s;if(!o.reloadCurrent&&o.route&&o.route.route&&o.route.route.parentPath&&e.currentRoute.route&&e.currentRoute.route.parentPath===o.route.route.parentPath){if(o.route.url===e.url)return e.allowPageChange=!0,!1;let t=Object.keys(o.route.params).length===Object.keys(e.currentRoute.params).length;if(t&&Object.keys(o.route.params).forEach((a=>{a in e.currentRoute.params&&e.currentRoute.params[a]===o.route.params[a]||(t=!1)})),t)return!!o.route.route.tab&&e.tabLoad(o.route.route.tab,o);if(!t&&o.route.route.tab&&e.currentRoute.route.tab&&e.currentRoute.parentPath===o.route.parentPath)return e.tabLoad(o.route.route.tab,o)}if(o.route&&o.route.url&&e.url===o.route.url&&!o.reloadCurrent&&!o.reloadPrevious&&!e.params.allowDuplicateUrls)return e.allowPageChange=!0,!1;if(!o.route&&n&&(o.route=e.parseRouteUrl(n),Fe(o.route,{route:{url:n,path:n}})),(n||d||p)&&(e.allowPageChange=!1),i)Mt(e,e.getPageEl(i),o);else if(l)Mt(e,e.getPageEl(l),o);else if(c)Mt(e,e.$el.children(`.page[data-name="${c}"]`).eq(0),o);else if(p||d)try{e.pageComponentLoader({routerEl:e.el,component:p,componentUrl:d,options:o,resolve:function(t,a){return Mt(e,t,Fe(o,a))},reject:function(){return e.allowPageChange=!0,e}})}catch(t){throw e.allowPageChange=!0,t}else n&&(e.xhrAbortController&&(e.xhrAbortController.abort(),e.xhrAbortController=!1),e.xhrRequest(n,o).then((t=>{Mt(e,e.getPageEl(t),o)})).catch((()=>{e.allowPageChange=!0})));return e}function It(e,t,a){const s=rt(),o=r(),n=A(t),i=e.app,l=e.view,c=Fe(!1,{animate:e.params.animate,browserHistory:!0,replaceState:!1},a),p=e.params.masterDetailBreakpoint>0,d=p&&c.route&&c.route.route&&(!0===c.route.route.master||"function"==typeof c.route.route.master&&c.route.route.master(i,e));let u,h;const m=e.dynamicNavbar,f=n,g=e.$el.children(".page-current"),v=0===g.length&&c.preload,b=p&&g.hasClass("page-master");let w,y,C,E,k,$;if(f.length&&e.removeThemeElements(f),m&&(y=f.children(".navbar"),w=e.$navbarsEl,0===y.length&&f[0]&&f[0].f7Page&&(y=f[0].f7Page.$navbarEl),C=w.find(".navbar-current")),e.allowPageChange=!1,0===f.length||0===g.length&&!c.preload)return e.allowPageChange=!0,e;if(e.removeThemeElements(f),c.route&&c.route.route&&c.route.route.keepAlive&&!c.route.route.keepAliveData&&(c.route.route.keepAliveData={pageEl:n[0]}),p){const t=e.$el.children(".page").filter((e=>e!==f[0]));for(let e=0;e<t.length;e+=1)u||!t[e].classList.contains("page-master")||(u=t[e]);E=!d&&u&&e.history.indexOf(c.route.url)>e.history.indexOf(u.f7Page.route.url),!E&&!d&&u&&u.f7Page&&c.route.route.masterRoute&&(E=c.route.route.masterRoute.path===u.f7Page.route.route.path)}if(E&&u&&u.f7Page&&(k=e.history.indexOf(c.route.url)-e.history.indexOf(u.f7Page.route.url)==1),f.addClass(`page-${v?"current":"previous"}${d?" page-master":""}${E?" page-master-detail":""}${k?" page-master-detail-root":""}`).removeAttr("aria-hidden").trigger("page:unstack").trigger("page:position",{position:v?"current":"previous"}),e.emit("pageUnstack",f[0]),e.emit("pagePosition",f[0],v?"current":"previous"),(d||E)&&(f.trigger("page:role",{role:d?"master":"detail",root:!!k}),e.emit("pageRole",f[0],{role:d?"master":"detail",detailRoot:!!k})),m&&y.length>0&&(y.addClass(`navbar-${v?"current":"previous"}${d?" navbar-master":""}${E?" navbar-master-detail":""}${k?" navbar-master-detail-root":""}`).removeAttr("aria-hidden"),y.trigger("navbar:position",{position:v?"current":"previous"}),e.emit("navbarPosition",y[0],v?"current":"previous"),(d||k)&&e.emit("navbarRole",y[0],{role:d?"master":"detail",detailRoot:!!k})),c.force&&g.prev(".page-previous").length>=0){e.history.indexOf(c.route.url)>=0?($=e.history.length-e.history.indexOf(c.route.url)-1,e.history=e.history.slice(0,e.history.indexOf(c.route.url)+2),e.propsHistory=e.propsHistory.slice(0,e.history.indexOf(c.route.url)+2),l.history=e.history):e.history[[e.history.length-2]]?e.propsHistory[e.propsHistory.length-2]=c.props||{}:(e.history.unshift(e.url),e.propsHistory.unshift(c.props||{}));const t=g.prev(".page-previous");let a;m&&(a=A(i.navbar.getElByPage(t))),t.length>0&&(e.pageCallback("beforeRemove",t,a,"previous",void 0,c),t[0]===u&&(h=!0),e.removePage(t),m&&a.length&&e.removeNavbar(a))}const x=f.parents(o).length>0,T=f[0].f7Component;function S(){v&&(!x&&T?T.mount((t=>{e.$el.append(t)})):e.$el.append(f)),0===f.next(g).length&&(!x&&T?T.mount((e=>{A(e).insertBefore(g)})):f.insertBefore(g)),m&&y.length&&(y.find(".title-large").length&&y.addClass("navbar-large"),y.insertBefore(C),C.length>0?y.insertBefore(C):(e.$navbarsEl.parents(o).length||e.$el.prepend(e.$navbarsEl),w.append(y))),x?c.route&&c.route.route&&c.route.route.keepAlive&&!f[0].f7PageMounted&&(f[0].f7PageMounted=!0,e.pageCallback("mounted",f,y,"previous","current",c,g)):e.pageCallback("mounted",f,y,"previous","current",c,g)}if(c.preload){S(),c.route.route.tab&&e.tabLoad(c.route.route.tab,Fe({},c,{history:!1,browserHistory:!1,preload:!0})),d&&(f.removeClass("page-master-stacked").trigger("page:masterunstack"),e.emit("pageMasterUnstack",f[0]),m&&(A(i.navbar.getElByPage(f)).removeClass("navbar-master-stacked"),e.emit("navbarMasterUnstack",i.navbar.getElByPage(f)))),e.pageCallback("init",f,y,"previous","current",c,g),v&&(e.pageCallback("beforeIn",f,y,"current",void 0,c),e.pageCallback("afterIn",f,y,"current",void 0,c));const t=f.prevAll(".page-previous:not(.page-master)");return t.length>0&&t.each((t=>{const a=A(t);let r;m&&(r=A(i.navbar.getElByPage(a))),e.pageCallback("beforeRemove",a,r,"previous",void 0),e.removePage(a),m&&r.length&&e.removeNavbar(r)})),e.allowPageChange=!0,e}if(!(s.ie||s.edge||s.firefox&&!s.ios)&&e.params.browserHistory&&c.browserHistory)if(c.replaceState){const t=e.params.browserHistoryRoot||"";Et.replace(l.id,{url:c.route.url},t+e.params.browserHistorySeparator+c.route.url)}else $?Et.go(-$):Et.back();if(c.replaceState?(e.history[e.history.length-1]=c.route.url,e.propsHistory[e.propsHistory.length-1]=c.props||{}):(1===e.history.length&&(e.history.unshift(e.url),e.propsHistory.unshift(c.props||{})),e.history.pop(),e.propsHistory.pop()),e.saveHistory(),e.currentPageEl=f[0],m&&y.length?e.currentNavbarEl=y[0]:delete e.currentNavbarEl,e.currentRoute=c.route,(s.ie||s.edge||s.firefox&&!s.ios)&&e.params.browserHistory&&c.browserHistory)if(c.replaceState){const t=e.params.browserHistoryRoot||"";Et.replace(l.id,{url:c.route.url},t+e.params.browserHistorySeparator+c.route.url)}else $?Et.go(-$):Et.back();function P(){e.setPagePosition(f,"current",!1),e.setPagePosition(g,"next",!0),m&&(e.setNavbarPosition(y,"current",!1),e.setNavbarPosition(C,"next",!0)),e.pageCallback("afterOut",g,C,"current","next",c),e.pageCallback("afterIn",f,y,"previous","current",c),e.pageCallback("beforeRemove",g,C,"next",void 0,c),e.removePage(g),m&&C.length&&e.removeNavbar(C),e.allowPageChange=!0,e.emit("routeChanged",e.currentRoute,e.previousRoute,e);(e.params.preloadPreviousPage||e.params[`${i.theme}SwipeBack`])&&e.history[e.history.length-2]&&!d&&e.back(e.history[e.history.length-2],{preload:!0,props:e.propsHistory[e.propsHistory.length-2]||{}}),e.params.browserHistory&&Et.clearRouterQueue()}if(S(),c.route.route.tab&&e.tabLoad(c.route.route.tab,Fe({},c,{history:!1,browserHistory:!1})),p&&(b||h)&&l.checkMasterDetailBreakpoint(!1),e.pageCallback("init",f,y,"previous","current",c,g),e.pageCallback("beforeOut",g,C,"current","next",c),e.pageCallback("beforeIn",f,y,"previous","current",c),!c.animate||b&&i.width>=e.params.masterDetailBreakpoint)P();else{let t=e.params.transition;g[0]&&g[0].f7PageTransition&&(t=g[0].f7PageTransition,delete g[0].f7PageTransition),c.transition&&(t=c.transition),!t&&e.previousRoute&&e.previousRoute.route&&(t=e.previousRoute.route.transition),!t&&e.previousRoute&&e.previousRoute.route&&e.previousRoute.route.options&&(t=e.previousRoute.route.options.transition),e.setPagePosition(g,"current"),e.setPagePosition(f,"previous",!1),m&&(e.setNavbarPosition(C,"current"),e.setNavbarPosition(y,"previous",!1)),e.animate(g,f,C,y,"backward",t,(()=>{P()}))}return e}function Bt(e,t,a,r){if(!e.allowPageChange&&!r)return e;const s=t,o=a,{url:n,content:i,el:l,pageName:c,component:p,componentUrl:d}=s;if(o.route.url&&e.url===o.route.url&&!o.reloadCurrent&&!o.reloadPrevious&&!e.params.allowDuplicateUrls)return e.allowPageChange=!0,!1;if(!o.route&&n&&(o.route=e.parseRouteUrl(n)),(n||d||p)&&(e.allowPageChange=!1),i)It(e,e.getPageEl(i),o);else if(l)It(e,e.getPageEl(l),o);else if(c)It(e,e.$el.children(`.page[data-name="${c}"]`).eq(0),o);else if(p||d)try{e.pageComponentLoader({routerEl:e.el,component:p,componentUrl:d,options:o,resolve:function(t,a){return It(e,t,Fe(o,a))},reject:function(){return e.allowPageChange=!0,e}})}catch(t){throw e.allowPageChange=!0,t}else n&&(e.xhrAbortController&&(e.xhrAbortController.abort(),e.xhrAbortController=!1),e.xhrRequest(n,o).then((t=>{It(e,e.getPageEl(t),o)})).catch((()=>{e.allowPageChange=!0})));return e}class Lt extends ot{constructor(e,t){super({},[void 0===t?e:t]);const a=this;a.isAppRouter=void 0===t,a.isAppRouter?Fe(!1,a,{app:e,params:e.params.view,routes:e.routes||[],cache:e.cache}):Fe(!1,a,{app:e,view:t,viewId:t.id,id:t.params.routerId,params:t.params,routes:t.routes,history:t.history,propsHistory:[],scrollHistory:t.scrollHistory,cache:e.cache,dynamicNavbar:"ios"===e.theme&&t.params.iosDynamicNavbar,initialPages:[],initialNavbars:[]}),a.useModules(),a.allowPageChange=!0;let r={},s={};return Object.defineProperty(a,"currentRoute",{enumerable:!0,configurable:!0,set(e){void 0===e&&(e={}),s=Fe({},r),r=e,r&&(a.url=r.url,a.emit("routeChange",e,s,a))},get:()=>r}),Object.defineProperty(a,"previousRoute",{enumerable:!0,configurable:!0,get:()=>s,set(e){s=e}}),a}mount(){const e=this,t=e.view;Fe(!1,e,{tempDom:r().createElement("div"),$el:t.$el,el:t.el,$navbarsEl:t.$navbarsEl,navbarsEl:t.navbarsEl}),e.emit("local::mount routerMount",e)}animatableNavElements(e,t,a,r,s){const o=this,n=o.dynamicNavbar,i=o.params.iosAnimateNavbarBackIcon;let l,c;function p(e,t){const a=e.hasClass("sliding")||t.hasClass("sliding"),r=e.hasClass("subnavbar"),s=!a||!r,o=e.find(".back .icon");let n;return a&&i&&e.hasClass("left")&&o.length>0&&o.next("span").length&&(e=o.next("span"),n=!0),{$el:e,isIconLabel:n,leftOffset:e[0].f7NavbarLeftOffset,rightOffset:e[0].f7NavbarRightOffset,isSliding:a,isSubnavbar:r,needsOpacityTransition:s}}return n&&(l=[],c=[],e.children(".navbar-inner").children(".left, .right, .title, .subnavbar").each((t=>{const o=A(t);o.hasClass("left")&&r&&"forward"===s||o.hasClass("title")&&a||l.push(p(o,e.children(".navbar-inner")))})),t.hasClass("navbar-master")&&o.params.masterDetailBreakpoint>0&&o.app.width>=o.params.masterDetailBreakpoint||t.children(".navbar-inner").children(".left, .right, .title, .subnavbar").each((e=>{const o=A(e);o.hasClass("left")&&a&&!r&&"forward"===s||o.hasClass("left")&&a&&"backward"===s||o.hasClass("title")&&r||c.push(p(o,t.children(".navbar-inner")))})),[c,l].forEach((e=>{e.forEach((t=>{const a=t,{isSliding:r,$el:s}=t,o=e===c?l:c;r&&s.hasClass("title")&&o&&o.forEach((e=>{if(e.isIconLabel){const t=e.$el[0];a.leftOffset+=t&&t.offsetLeft||0}}))}))}))),{newNavEls:l,oldNavEls:c}}animate(e,t,a,r,s,o,n){const i=this;if(i.params.animateCustom)return void i.params.animateCustom.apply(i,[e,t,a,r,s,n]);const l=i.dynamicNavbar,c="ios"===i.app.theme;if(o){const c=`router-transition-custom router-transition-${o}-${s}`,p=()=>{i.$el.removeClass(c),l&&i.$navbarsEl.length&&(r&&i.$navbarsEl.prepend(r),a&&i.$navbarsEl.prepend(a)),n&&n()};return("forward"===s?t:e).animationEnd(p),l&&(r&&t&&(i.setNavbarPosition(r,""),r.removeClass("navbar-next navbar-previous navbar-current"),t.prepend(r)),a&&e&&(i.setNavbarPosition(a,""),a.removeClass("navbar-next navbar-previous navbar-current"),e.prepend(a))),void i.$el.addClass(c)}const p=`router-transition-${s} router-transition`;let d,u,h,m,f,g,v;if(c&&l){i.params.masterDetailBreakpoint>0&&i.app.width>=i.params.masterDetailBreakpoint&&(a.hasClass("navbar-master")&&r.hasClass("navbar-master-detail")||a.hasClass("navbar-master-detail")&&r.hasClass("navbar-master"))||(g=a&&a.hasClass("navbar-large"),v=r&&r.hasClass("navbar-large"),h=g&&!a.hasClass("navbar-large-collapsed"),m=v&&!r.hasClass("navbar-large-collapsed"),f=h&&!m||m&&!h);const e=i.animatableNavElements(r,a,m,h,s);d=e.newNavEls,u=e.oldNavEls}function b(e){c&&l&&(1===e&&(m&&(r.addClass("router-navbar-transition-to-large"),a.addClass("router-navbar-transition-to-large")),h&&(r.addClass("router-navbar-transition-from-large"),a.addClass("router-navbar-transition-from-large"))),d.forEach((t=>{const a=t.$el,r="forward"===s?t.rightOffset:t.leftOffset;t.isSliding&&(t.isSubnavbar&&v?a[0].style.setProperty("transform",`translate3d(${r*(1-e)}px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)`,"important"):a.transform(`translate3d(${r*(1-e)}px,0,0)`))})),u.forEach((t=>{const a=t.$el,r="forward"===s?t.leftOffset:t.rightOffset;t.isSliding&&(t.isSubnavbar&&g?a.transform(`translate3d(${r*e}px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)`):a.transform(`translate3d(${r*e}px,0,0)`))})))}("forward"===s?t:c?e:t).animationEnd((()=>{i.dynamicNavbar&&(r&&(r.removeClass("router-navbar-transition-to-large router-navbar-transition-from-large"),r.addClass("navbar-no-title-large-transition"),De((()=>{r.removeClass("navbar-no-title-large-transition")}))),a&&a.removeClass("router-navbar-transition-to-large router-navbar-transition-from-large"),r.hasClass("sliding")||r.children(".navbar-inner.sliding").length?r.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):r.find(".sliding").transform(""),a.hasClass("sliding")||a.children(".navbar-inner.sliding").length?a.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):a.find(".sliding").transform("")),i.$el.removeClass(p),n&&n()})),l?(b(0),De((()=>{i.$el.addClass(p),f&&(i.el._clientLeft=i.el.clientLeft),b(1)}))):i.$el.addClass(p)}removeModal(e){this.removeEl(e)}removeTabContent(e){A(e).html("")}removeNavbar(e){this.removeEl(e)}removePage(e){const t=A(e),a=t&&t[0]&&t[0].f7Page;a&&a.route&&a.route.route&&a.route.route.keepAlive?t.remove():this.removeEl(e)}removeEl(e){if(!e)return;const t=this,a=A(e);0!==a.length&&(a.find(".tab").each((e=>{A(e).children().each((e=>{e.f7Component&&(A(e).trigger("tab:beforeremove"),e.f7Component.destroy())}))})),a[0].f7Component&&a[0].f7Component.destroy&&a[0].f7Component.destroy(),t.params.removeElements&&(t.params.removeElementsWithTimeout?setTimeout((()=>{a.remove()}),t.params.removeElementsTimeout):a.remove()))}getPageEl(e){const t=this;if("string"==typeof e)t.tempDom.innerHTML=e;else{if(A(e).hasClass("page"))return e;t.tempDom.innerHTML="",A(t.tempDom).append(e)}return t.findElement(".page",t.tempDom)}findElement(e,t){const a=this,r=a.view,s=a.app,o=A(t),n=e;let i=o.find(n).filter((e=>0===A(e).parents(".popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page").length));return i.length>1&&("string"==typeof r.selector&&(i=o.find(`${r.selector} ${n}`)),i.length>1&&(i=o.find(`.${s.params.viewMainClass} ${n}`))),1===i.length?i:(i=a.findElement(n,o),i&&1===i.length?i:i&&i.length>1?A(i[0]):void 0)}flattenRoutes(e){void 0===e&&(e=this.routes);const t=this;let a=[];return e.forEach((e=>{let r=!1;if("tabs"in e&&e.tabs){const s=e.tabs.map((t=>{const a=Fe({},e,{path:`${e.path}/${t.path}`.replace("///","/").replace("//","/"),parentPath:e.path,tab:t});return delete a.tabs,delete a.routes,a}));r=!0,a=a.concat(t.flattenRoutes(s))}if("detailRoutes"in e){const r=e.detailRoutes.map((t=>{const a=Fe({},t);return a.masterRoute=e,a.masterRoutePath=e.path,a}));a=a.concat(e,t.flattenRoutes(r))}if("routes"in e){const s=e.routes.map((t=>{const a=Fe({},t);return a.path=`${e.path}/${a.path}`.replace("///","/").replace("//","/"),a}));a=r?a.concat(t.flattenRoutes(s)):a.concat(e,t.flattenRoutes(s))}"routes"in e||"tabs"in e&&e.tabs||"detailRoutes"in e||a.push(e)})),a}parseRouteUrl(e){if(!e)return{};const t=Re(e),a=e.split("#")[1],r=e.split("#")[0].split("?")[0];return{query:t,hash:a,params:{},url:e,path:r}}generateUrl(e){if(void 0===e&&(e={}),"string"==typeof e)return e;const{name:t,path:a,params:r,query:s}=e;if(!t&&!a)throw new Error('Framework7: "name" or "path" parameter is required');const o=this,n=t?o.findRouteByKey("name",t):o.findRouteByKey("path",a);if(!n)throw t?new Error(`Framework7: route with name "${t}" not found`):new Error(`Framework7: route with path "${a}" not found`);const i=o.constructRouteUrl(n,{params:r,query:s});if(""===i)return"/";if(!i)throw new Error(`Framework7: can't construct URL for route with name "${t}"`);return i}constructRouteUrl(e,t){let{params:a,query:r}=void 0===t?{}:t;const{path:s}=e,o=vt(s);let n;try{n=o(a||{})}catch(e){throw new Error(`Framework7: error constructing route URL from passed params:\nRoute: ${s}\n${e.toString()}`)}return r&&("string"==typeof r?n+=`?${r}`:Object.keys(r).length&&(n+=`?${ze(r)}`)),n}findTabRouteUrl(e){const t=this,a=A(e),r=t.currentRoute.route.parentPath,s=a.attr("id");let o;return t.flattenRoutes(t.routes).forEach((e=>{e.parentPath===r&&e.tab&&e.tab.id===s&&(o=t.currentRoute.params&&Object.keys(t.currentRoute.params).length>0?t.constructRouteUrl(e,{params:t.currentRoute.params,query:t.currentRoute.query}):e.path)})),o}findRouteByKey(e,t){const a=this.routes;let r;return this.flattenRoutes(a).forEach((a=>{r||a[e]===t&&(r=a)})),r}findMatchingRoute(e){if(!e)return;const t=this,a=t.routes,r=t.flattenRoutes(a),{path:s,query:o,hash:n,params:i}=t.parseRouteUrl(e);let l;return r.forEach((t=>{if(l)return;const a=[],r=[t.path||"/"];let c;if(t.alias&&("string"==typeof t.alias?r.push(t.alias):Array.isArray(t.alias)&&t.alias.forEach((e=>{r.push(e)}))),r.forEach((e=>{c||(c=Ct(e,a).exec(s||"/"))})),c){let r;a.forEach(((e,t)=>{if("number"==typeof e.name)return;const a=c[t+1];i[e.name]=null==a?a:decodeURIComponent(a)})),t.parentPath&&(r=(s||"/").split("/").slice(0,t.parentPath.split("/").length-1).join("/")),l={query:o,hash:n,params:i,url:e,path:s||"/",parentPath:r,route:t,name:t.name}}})),l}replaceRequestUrlParams(e,t){void 0===e&&(e=""),void 0===t&&(t={});let a=e;return"string"==typeof a&&a.indexOf("{{")>=0&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&Object.keys(t.route.params).forEach((e=>{const r=new RegExp(`{{${e}}}`,"g");a=a.replace(r,t.route.params[e]||"")})),a}removeFromXhrCache(e){const t=this.cache.xhr;let a=!1;for(let r=0;r<t.length;r+=1)t[r].url===e&&(a=r);!1!==a&&t.splice(a,1)}xhrRequest(e,t){const a=this,r=a.params,{ignoreCache:s}=t;let o=e,n=o.indexOf("?")>=0;return r.passRouteQueryToRequest&&t&&t.route&&t.route.query&&Object.keys(t.route.query).length&&(o+=`${n?"&":"?"}${ze(t.route.query)}`,n=!0),r.passRouteParamsToRequest&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&(o+=`${n?"&":"?"}${ze(t.route.params)}`,n=!0),o.indexOf("{{")>=0&&(o=a.replaceRequestUrlParams(o,t)),r.xhrCacheIgnoreGetParameters&&o.indexOf("?")>=0&&(o=o.split("?")[0]),new Promise(((e,n)=>{if(r.xhrCache&&!s&&o.indexOf("nocache")<0&&r.xhrCacheIgnore.indexOf(o)<0)for(let t=0;t<a.cache.xhr.length;t+=1){const s=a.cache.xhr[t];if(s.url===o&&Ae()-s.time<r.xhrCacheDuration)return void e(s.content)}let i;a.xhrAbortController=new AbortController,fetch(o,{signal:a.xhrAbortController.signal,method:"GET"}).then((e=>(i=e,e.text()))).then((s=>{const{status:l}=i;a.emit("routerAjaxComplete",i),"error"!==l&&"timeout"!==l&&l>=200&&l<300||0===l?(r.xhrCache&&""!==s&&(a.removeFromXhrCache(o),a.cache.xhr.push({url:o,time:Ae(),content:s})),a.emit("routerAjaxSuccess",i,t),e(s)):(a.emit("routerAjaxError",i,t),n(i))})).catch((e=>{n(e)}))}))}setNavbarPosition(e,t,a){e.removeClass("navbar-previous navbar-current navbar-next"),t&&e.addClass(`navbar-${t}`),!1===a?e.removeAttr("aria-hidden"):!0===a&&e.attr("aria-hidden","true"),e.trigger("navbar:position",{position:t}),this.emit("navbarPosition",e[0],t)}setPagePosition(e,t,a){e.removeClass("page-previous page-current page-next"),e.addClass(`page-${t}`),!1===a?e.removeAttr("aria-hidden"):!0===a&&e.attr("aria-hidden","true"),e.trigger("page:position",{position:t}),this.emit("pagePosition",e[0],t)}removeThemeElements(e){const t=this.app.theme;let a;"ios"===t?a=".md-only, .if-md, .if-not-ios, .not-ios":"md"===t&&(a=".ios-only, .if-ios, .if-not-md, .not-md"),A(e).find(a).remove()}getPageData(e,t,a,r,s,o){void 0===s&&(s={});const n=this,i=A(e).eq(0),l=A(t).eq(0),c=i[0].f7Page||{};let p,d;if(("next"===a&&"current"===r||"current"===a&&"previous"===r)&&(p="forward"),("current"===a&&"next"===r||"previous"===a&&"current"===r)&&(p="backward"),c&&!c.fromPage){const e=A(o);e.length&&(d=e[0].f7Page)}d=c.pageFrom||d,d&&d.pageFrom&&(d.pageFrom=null);const u={app:n.app,view:n.view,router:n,$el:i,el:i[0],$pageEl:i,pageEl:i[0],$navbarEl:l,navbarEl:l[0],name:i.attr("data-name"),position:a,from:a,to:r,direction:p,route:c.route?c.route:s,pageFrom:d};return i[0].f7Page=u,u}pageCallback(e,t,a,r,s,o,n){if(void 0===o&&(o={}),!t)return;const i=this,l=A(t);if(!l.length)return;const c=A(a),{route:p}=o,d=i.params.restoreScrollTopOnBack&&!(i.params.masterDetailBreakpoint>0&&l.hasClass("page-master")&&i.app.width>=i.params.masterDetailBreakpoint),u=l[0].f7Page&&l[0].f7Page.route&&l[0].f7Page.route.route&&l[0].f7Page.route.route.keepAlive;"beforeRemove"===e&&u&&(e="beforeUnmount");const h=`page${e[0].toUpperCase()+e.slice(1,e.length)}`,m=`page:${e.toLowerCase()}`;let f={};f="beforeRemove"===e&&l[0].f7Page?Fe(l[0].f7Page,{from:r,to:s,position:r}):i.getPageData(l[0],c[0],r,s,p,n),f.swipeBack=!!o.swipeBack;const{on:g={},once:v={}}=o.route?o.route.route:{};function b(){l[0].f7RouteEventsAttached||(l[0].f7RouteEventsAttached=!0,g&&Object.keys(g).length>0&&(l[0].f7RouteEventsOn=g,Object.keys(g).forEach((e=>{g[e]=g[e].bind(i),l.on(Oe(e),g[e])}))),v&&Object.keys(v).length>0&&(l[0].f7RouteEventsOnce=v,Object.keys(v).forEach((e=>{v[e]=v[e].bind(i),l.once(Oe(e),v[e])}))))}if(o.on&&Fe(g,o.on),o.once&&Fe(v,o.once),"mounted"===e&&b(),"init"===e){if(d&&("previous"===r||!r)&&"current"===s&&i.scrollHistory[f.route.url]&&!l.hasClass("no-restore-scroll")){let e=l.find(".page-content");e.length>0&&(e=e.filter((e=>0===A(e).parents(".tab:not(.tab-active)").length&&!A(e).is(".tab:not(.tab-active)")))),e.scrollTop(i.scrollHistory[f.route.url])}if(b(),l[0].f7PageInitialized)return l.trigger("page:reinit",f),void i.emit("pageReinit",f);l[0].f7PageInitialized=!0}if(d&&"beforeOut"===e&&"current"===r&&"previous"===s){let e=l.find(".page-content");e.length>0&&(e=e.filter((e=>0===A(e).parents(".tab:not(.tab-active)").length&&!A(e).is(".tab:not(.tab-active)")))),i.scrollHistory[f.route.url]=e.scrollTop()}d&&"beforeOut"===e&&"current"===r&&"next"===s&&delete i.scrollHistory[f.route.url],l.trigger(m,f),i.emit(h,f),"beforeRemove"!==e&&"beforeUnmount"!==e||(l[0].f7RouteEventsAttached&&(l[0].f7RouteEventsOn&&Object.keys(l[0].f7RouteEventsOn).forEach((e=>{l.off(Oe(e),l[0].f7RouteEventsOn[e])})),l[0].f7RouteEventsOnce&&Object.keys(l[0].f7RouteEventsOnce).forEach((e=>{l.off(Oe(e),l[0].f7RouteEventsOnce[e])})),l[0].f7RouteEventsAttached=null,l[0].f7RouteEventsOn=null,l[0].f7RouteEventsOnce=null,delete l[0].f7RouteEventsAttached,delete l[0].f7RouteEventsOn,delete l[0].f7RouteEventsOnce),u||(l[0].f7Page&&l[0].f7Page.navbarEl&&delete l[0].f7Page.navbarEl.f7Page,l[0].f7Page=null))}saveHistory(){const e=this,t=o();e.view.history=e.history,e.params.browserHistory&&e.params.browserHistoryStoreHistory&&t.localStorage&&(t.localStorage[`f7router-${e.view.id}-history`]=JSON.stringify(e.history))}restoreHistory(){const e=this,t=o();e.params.browserHistory&&e.params.browserHistoryStoreHistory&&t.localStorage&&t.localStorage[`f7router-${e.view.id}-history`]&&(e.history=JSON.parse(t.localStorage[`f7router-${e.view.id}-history`]),e.view.history=e.history)}clearHistory(){const e=this;e.history=[],e.view&&(e.view.history=[]),e.saveHistory()}updateCurrentUrl(e){const t=this;St(t,"updateCurrentUrl"),t.history.length?t.history[t.history.length-1]=e:t.history.push(e);const{query:a,hash:r,params:s,url:o,path:n}=t.parseRouteUrl(e);if(t.currentRoute&&Fe(t.currentRoute,{query:a,hash:r,params:s,url:o,path:n}),t.params.browserHistory){const a=t.params.browserHistoryRoot||"";Et.replace(t.view.id,{url:e},a+t.params.browserHistorySeparator+e)}t.saveHistory(),t.emit("routeUrlUpdate",t.currentRoute,t)}getInitialUrl(){const e=this;if(e.initialUrl)return{initialUrl:e.initialUrl,historyRestored:e.historyRestored};const{app:t,view:a}=e,s=r(),n=o(),i=t.params.url&&"string"==typeof t.params.url&&"undefined"!=typeof URL?new URL(t.params.url):s.location;let l,c=e.params.url,p=i.href.split(i.origin)[1];const{browserHistory:d,browserHistoryOnLoad:u,browserHistorySeparator:h}=e.params;let{browserHistoryRoot:m}=e.params;return(n.cordova||n.Capacitor&&n.Capacitor.isNative)&&d&&!h&&!m&&i.pathname.indexOf("index.html")&&(console.warn("Framework7: wrong or not complete browserHistory configuration, trying to guess browserHistoryRoot"),m=i.pathname.split("index.html")[0]),d&&u?(m&&p.indexOf(m)>=0&&(p=p.substring(p.indexOf(m)+m.length),""===p&&(p="/")),c=h.length>0&&p.indexOf(h)>=0?p.substring(p.indexOf(h)+h.length):p,e.restoreHistory(),e.history.indexOf(c)>=0?e.history=e.history.slice(0,e.history.indexOf(c)+1):e.params.url===c?e.history=[c]:Et.state&&Et.state[a.id]&&Et.state[a.id].url===e.history[e.history.length-1]?c=e.history[e.history.length-1]:e.history=[p.split(h)[0]||"/",c],e.history.length>1?l=!0:e.history=[],e.saveHistory()):(c||(c=p),i.search&&c.indexOf("?")<0&&(c+=i.search),i.hash&&c.indexOf("#")<0&&(c+=i.hash)),e.initialUrl=c,e.historyRestored=l,{initialUrl:c,historyRestored:l}}init(){const e=this,{app:t,view:a}=e,s=r();e.mount();const{initialUrl:o,historyRestored:n}=e.getInitialUrl();(a&&e.params.iosSwipeBack&&"ios"===t.theme||a&&e.params.mdSwipeBack&&"md"===t.theme)&&kt(e);const{browserHistory:i,browserHistoryOnLoad:l,browserHistoryAnimateOnLoad:c,browserHistoryInitialMatch:p}=e.params;let d;if(e.history.length>1){const t=p?o:e.history[0];d=e.findMatchingRoute(t),d||(d=Fe(e.parseRouteUrl(t),{route:{url:t,path:t.split("?")[0]}}))}else d=e.findMatchingRoute(o),d||(d=Fe(e.parseRouteUrl(o),{route:{url:o,path:o.split("?")[0]}}));if(0===e.$el.children(".page").length&&o&&e.params.loadInitialPage)e.navigate(o,{initial:!0,reloadCurrent:!0,browserHistory:!1,animate:!1,once:{modalOpen(){if(!n)return;(e.params.preloadPreviousPage||e.params[`${t.theme}SwipeBack`])&&e.history.length>1&&e.back({preload:!0})},pageAfterIn(){if(!n)return;(e.params.preloadPreviousPage||e.params[`${t.theme}SwipeBack`])&&e.history.length>1&&e.back({preload:!0})}}});else if(e.$el.children(".page").length){let r;if(e.currentRoute=d,e.$el.children(".page").each((o=>{const n=A(o);let i;e.setPagePosition(n,"current"),e.dynamicNavbar&&(i=n.children(".navbar"),i.length>0?(e.$navbarsEl.parents(s).length||e.$el.prepend(e.$navbarsEl),e.setNavbarPosition(i,"current"),e.$navbarsEl.append(i),i.children(".title-large").length&&i.addClass("navbar-large"),n.children(".navbar").remove()):(e.$navbarsEl.addClass("navbar-hidden"),i.children(".title-large").length&&e.$navbarsEl.addClass("navbar-hidden navbar-large-hidden"))),e.currentRoute&&e.currentRoute.route&&(!0===e.currentRoute.route.master||"function"==typeof e.currentRoute.route.master&&e.currentRoute.route.master(t,e))&&e.params.masterDetailBreakpoint>0&&(n.addClass("page-master"),n.trigger("page:role",{role:"master"}),i&&i.length&&i.addClass("navbar-master"),a.checkMasterDetailBreakpoint());const l={route:e.currentRoute};e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.options&&Fe(l,e.currentRoute.route.options),e.currentPageEl=n[0],e.dynamicNavbar&&i.length&&(e.currentNavbarEl=i[0]),e.removeThemeElements(n),e.dynamicNavbar&&i.length&&e.removeThemeElements(i),l.route.route.tab&&(r=!0,e.tabLoad(l.route.route.tab,Fe({},l))),e.pageCallback("init",n,i,"current",void 0,l),e.pageCallback("beforeIn",n,i,"current",void 0,l),e.pageCallback("afterIn",n,i,"current",void 0,l)})),n)if(p){(e.params.preloadPreviousPage||e.params[`${t.theme}SwipeBack`])&&e.history.length>1&&e.back({preload:!0})}else e.navigate(o,{initial:!0,browserHistory:!1,history:!1,animate:c,once:{pageAfterIn(){(e.params.preloadPreviousPage||e.params[`${t.theme}SwipeBack`])&&e.history.length>2&&e.back({preload:!0})}}});n||r||(e.history.push(o),e.saveHistory())}!(o&&i&&l)||Et.state&&Et.state[a.id]||Et.initViewState(a.id,{url:o}),e.emit("local::init routerInit",e)}destroy(){let e=this;e.emit("local::destroy routerDestroy",e),Object.keys(e).forEach((t=>{e[t]=null,delete e[t]})),e=null}}Lt.prototype.navigate=function(e,t){void 0===t&&(t={});const a=this;if(a.swipeBackActive)return a;let r,s,o,n,i,l,c;if("string"==typeof e?r=e:(r=e.url,s=e.route,o=e.name,n=e.path,i=e.query,l=e.params),o||n)return r=a.generateUrl({path:n,name:o,params:l,query:i}),r?a.navigate(r,t):a;const p=a.app;if(St(a,"navigate"),"#"===r||""===r)return a;let d=r.replace("./","");if("/"!==d[0]&&0!==d.indexOf("#")){const e=a.currentRoute.parentPath||a.currentRoute.path;d=((e?`${e}/`:"/")+d).replace("///","/").replace("//","/")}if(c=s?Fe(a.parseRouteUrl(d),{route:Fe({},s)}):a.findMatchingRoute(d),!c)return a;if(c.route&&c.route.viewName){const r=c.route.viewName,s=p.views[r];if(!s)throw new Error(`Framework7: There is no View with "${r}" name that was specified in this route`);if(s!==a.view)return s.router.navigate(e,t)}if(c.route.redirect)return $t.call(a,"forward",c,t);const u={};if(c.route.options?Fe(u,c.route.options,t):Fe(u,t),u.openIn&&(!a.params.ignoreOpenIn||a.params.ignoreOpenIn&&a.history.length>0))return a.openIn(a,d,u);function h(){let e=!1;function t(e,t){a.allowPageChange=!1;let r=!1;"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((s=>{if(e[s]){r=!0;const o=Fe({},c,{route:e});a.allowPageChange=!0,a.modalLoad(s,o,Fe(u,t),"forward")}})),r||Ot(a,e,Fe(u,t),!0)}function r(){a.allowPageChange=!0}"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((t=>{c.route[t]&&!e&&(e=!0,a.modalLoad(t,c,u,"forward"))})),c.route.keepAlive&&c.route.keepAliveData&&(Ot(a,{el:c.route.keepAliveData.pageEl},u,!1),e=!0),"url content component pageName el componentUrl".split(" ").forEach((t=>{c.route[t]&&!e&&(e=!0,Ot(a,{[t]:c.route[t]},u,!1))})),e||(c.route.async&&(a.allowPageChange=!1,c.route.async.call(a,{router:a,to:u.route,from:a.currentRoute,resolve:t,reject:r,direction:"forward",app:p})),c.route.asyncComponent&&Pt(a,c.route.asyncComponent,t,r))}function m(){a.allowPageChange=!0}if(u.route=c,a.params.masterDetailBreakpoint>0&&c.route.masterRoute){let r=!0,s=!1;if(a.currentRoute&&a.currentRoute.route&&(!(!0===a.currentRoute.route.master||"function"==typeof a.currentRoute.route.master&&a.currentRoute.route.master(p,a))||a.currentRoute.route!==c.route.masterRoute&&a.currentRoute.route.path!==c.route.masterRoute.path||(r=!1),!a.currentRoute.route.masterRoute||a.currentRoute.route.masterRoute!==c.route.masterRoute&&a.currentRoute.route.masterRoute.path!==c.route.masterRoute.path||(r=!1,s=!0)),r||s&&t.reloadAll)return a.navigate({path:c.route.masterRoute.path,params:c.params||{}},{animate:!1,reloadAll:t.reloadAll,reloadCurrent:t.reloadCurrent,reloadPrevious:t.reloadPrevious,browserHistory:!t.initial,history:!t.initial,once:{pageAfterIn(){a.navigate(e,Fe({},t,{animate:!1,reloadAll:!1,reloadCurrent:!1,reloadPrevious:!1,history:!t.initial,browserHistory:!t.initial}))}}}),a}return Tt.call(a,c,a.currentRoute,(()=>{c.route.modules?p.loadModules(Array.isArray(c.route.modules)?c.route.modules:[c.route.modules]).then((()=>{h()})).catch((()=>{m()})):h()}),(()=>{m()}),"forward"),a},Lt.prototype.refreshPage=function(e){void 0===e&&(e={});const t=this;return St(t,"refreshPage"),t.navigate(t.currentRoute.url,{ignoreCache:!0,reloadCurrent:!0,props:e})},Lt.prototype.tabLoad=function(e,t){void 0===t&&(t={});const a=this,r=Fe({animate:a.params.animate,browserHistory:!0,history:!0,parentPageEl:null,preload:!1,on:{}},t);let s,o;r.route&&(r.preload||r.route===a.currentRoute||(o=a.previousRoute,a.currentRoute=r.route),r.preload?(s=r.route,o=a.currentRoute):(s=a.currentRoute,o||(o=a.previousRoute)),a.params.browserHistory&&r.browserHistory&&!r.reloadPrevious&&Et[a.params.browserHistoryTabs](a.view.id,{url:r.route.url},(a.params.browserHistoryRoot||"")+a.params.browserHistorySeparator+r.route.url),r.history&&(a.history[Math.max(a.history.length-1,0)]=r.route.url,a.saveHistory()));const n=A(r.parentPageEl||a.currentPageEl);let i;i=n.length&&n.find(`#${e.id}`).length?n.find(`#${e.id}`).eq(0):a.view.selector?`${a.view.selector} #${e.id}`:`#${e.id}`;const l=a.app.tab.show({tabEl:i,animate:r.animate,tabRoute:r.route}),{$newTabEl:c,$oldTabEl:p,animated:d,onTabsChanged:u}=l;if(c&&c.parents(".page").length>0&&r.route){const e=c.parents(".page")[0].f7Page;e&&r.route&&(e.route=r.route)}if(c[0].f7RouterTabLoaded)return p&&p.length?(d?u((()=>{a.emit("routeChanged",a.currentRoute,a.previousRoute,a)})):a.emit("routeChanged",a.currentRoute,a.previousRoute,a),a):a;function h(t,r){const{url:s,content:o,el:n,component:i,componentUrl:l}=t;function h(t){a.allowPageChange=!0,t&&("string"==typeof t?c.html(t):(c.html(""),t.f7Component?t.f7Component.mount((e=>{c.append(e)})):c.append(t)),c[0].f7RouterTabLoaded=!0,function(t){a.removeThemeElements(c);let r=c;"string"!=typeof t&&(r=A(t)),r.trigger("tab:init tab:mounted",e),a.emit("tabInit tabMounted",c[0],e),p&&p.length&&(d?u((()=>{a.emit("routeChanged",a.currentRoute,a.previousRoute,a),a.params.unloadTabContent&&a.tabRemove(p,c,e)})):(a.emit("routeChanged",a.currentRoute,a.previousRoute,a),a.params.unloadTabContent&&a.tabRemove(p,c,e)))}(t))}if(o)h(o);else if(n)h(n);else if(i||l)try{a.tabComponentLoader({tabEl:c[0],component:i,componentUrl:l,options:r,resolve:h,reject:function(){return a.allowPageChange=!0,a}})}catch(e){throw a.allowPageChange=!0,e}else s&&(a.xhrAbortController&&(a.xhrAbortController.abort(),a.xhrAbortController=!1),a.xhrRequest(s,r).then((e=>{h(e)})).catch((()=>{a.allowPageChange=!0})))}let m;function f(e,t){h(e,Fe(r,t))}function g(){a.allowPageChange=!0}return"url content component el componentUrl".split(" ").forEach((t=>{e[t]&&(m=!0,h({[t]:e[t]},r))})),e.async?e.async.call(a,{router:a,to:s,from:o,resolve:f,reject:g,app:a.app}):e.asyncComponent?Pt(a,e.asyncComponent,f,g):m||(a.allowPageChange=!0),a},Lt.prototype.tabRemove=function(e,t,a){let r;e[0]&&(e[0].f7RouterTabLoaded=!1,delete e[0].f7RouterTabLoaded),e.children().each((e=>{e.f7Component&&(r=!0,A(e).trigger("tab:beforeremove",a),e.f7Component.destroy())})),r||e.trigger("tab:beforeremove",a),this.emit("tabBeforeRemove",e[0],t[0],a),this.removeTabContent(e[0],a)},Lt.prototype.modalLoad=function(e,t,a,r){void 0===a&&(a={});const s=this,o=s.app,n="panel"===e,i=n?"panel":"modal",l=Fe({animate:s.params.animate,browserHistory:!0,history:!0,on:{},once:{}},a),c=Fe({},t.route[e]),p=t.route,d=(e,t)=>{const{on:a,once:r}=l;let s;"open"===t&&(s=a.modalOpen||r.modalOpen||a.panelOpen||r.panelOpen),"close"===t&&(s=a.modalClose||r.modalClose||a.panelClose||r.panelClose),"closed"===t&&(s=a.modalClosed||r.modalClosed||a.panelClosed||r.panelClosed),s&&s(e)};function u(){const a=o[e].create(c);p.modalInstance=a;const r=a.el;function u(){a.close()}a.on(`${i}Open`,(()=>{r||(s.removeThemeElements(a.el),a.$el.trigger(`${e.toLowerCase()}:init ${e.toLowerCase()}:mounted`,t,a),s.emit(`${n?"":"modalInit"} ${e}Init ${e}Mounted`,a.el,t,a)),s.once("swipeBackMove",u),d(a,"open")})),a.on(`${i}Close`,(()=>{s.off("swipeBackMove",u),a.closeByRouter||s.back(),d(a,"close")})),a.on(`${i}Closed`,(()=>{a.$el.trigger(`${e.toLowerCase()}:beforeremove`,t,a),a.emit(`${n?"":"modalBeforeRemove "}${e}BeforeRemove`,a.el,t,a);const r=a.el.f7Component;d(a,"closed"),r&&r.destroy(),Le((()=>{(r||c.component||c.asyncComponent||c.async)&&s.removeModal(a.el),a.destroy(),delete a.route,delete p.modalInstance}))})),l.route&&(s.params.browserHistory&&l.browserHistory&&Et.push(s.view.id,{url:l.route.url,modal:e},(s.params.browserHistoryRoot||"")+s.params.browserHistorySeparator+l.route.url),l.route!==s.currentRoute&&(a.route=Fe(l.route,{modal:a}),s.currentRoute=a.route),l.history&&!l.reloadCurrent&&(s.history.push(l.route.url),s.saveHistory())),r&&(s.removeThemeElements(a.el),a.$el.trigger(`${e.toLowerCase()}:init ${e.toLowerCase()}:mounted`,t,a),s.emit(`${i}Init ${e}Init ${e}Mounted`,a.el,t,a)),a.open(!1===l.animate||!0===l.animate?l.animate:void 0)}function h(e,t){const{url:a,content:r,component:n,componentUrl:i}=e;function l(e){e&&("string"==typeof e?c.content=e:e.f7Component?e.f7Component.mount((e=>{c.el=e,o.$el.append(e)})):c.el=e,u())}if(r)l(r);else if(n||i)try{s.modalComponentLoader({rootEl:o.el,component:n,componentUrl:i,options:t,resolve:l,reject:function(){return s.allowPageChange=!0,s}})}catch(e){throw s.allowPageChange=!0,e}else a?(s.xhrAbortController&&(s.xhrAbortController.abort(),s.xhrAbortController=!1),s.xhrRequest(a,t).then((e=>{c.content=e,u()})).catch((()=>{s.allowPageChange=!0}))):u()}let m;function f(e,t){h(e,Fe(l,t))}function g(){s.allowPageChange=!0}return"url content component el componentUrl template".split(" ").forEach((e=>{c[e]&&!m&&(m=!0,h({[e]:c[e]},l))})),m||"actions"!==e||u(),c.async&&c.async.call(s,{router:s,to:l.route,from:s.currentRoute,resolve:f,reject:g,direction:r,app:o}),c.asyncComponent&&Pt(s,c.asyncComponent,f,g),s},Lt.prototype.modalRemove=function(e){Fe(e,{closeByRouter:!0}),e.close()},Lt.prototype.back=function(){const e=this,t=rt();if(e.swipeBackActive)return e;let a,r,s,o;"object"==typeof(arguments.length<=0?void 0:arguments[0])?r=(arguments.length<=0?void 0:arguments[0])||{}:(a=arguments.length<=0?void 0:arguments[0],r=(arguments.length<=1?void 0:arguments[1])||{});const{name:n,params:i,query:l}=r;if(n)return a=e.generateUrl({name:n,params:i,query:l}),a?e.back(a,Fe({},r,{name:null,params:null,query:null})):e;const c=e.app;St(e,"back");let p,d=e.currentRoute.modal;if(d||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((t=>{e.currentRoute.route[t]&&(d=!0,p=t)})),d&&!r.preload){const s=e.currentRoute.modal||e.currentRoute.route.modalInstance||c[p].get(),o=e.history[e.history.length-2];let n;if(s&&s.$el){const t=s.$el.prevAll(".modal-in");if(t.length&&t[0].f7Modal){const a=t[0];e.$el.parents(a).length||(n=a.f7Modal.route)}}if(n||(n=e.findMatchingRoute(o)),!n&&o&&(n={url:o,path:o.split("?")[0],query:Re(o),route:{path:o.split("?")[0],url:o}}),!(a&&0!==a.replace(/[# ]/g,"").trim().length||n&&s))return e;const i=r.force&&n&&a;if(n&&s){const o=t.ie||t.edge||t.firefox&&!t.ios,l=e.params.browserHistory&&!1!==r.browserHistory,c=e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.options&&!1===e.currentRoute.route.options.browserHistory;!l||o||c||Et.back(),e.currentRoute=n,e.history.pop(),e.propsHistory.pop(),e.saveHistory(),l&&o&&!c&&Et.back(),e.modalRemove(s),i&&e.navigate(a,{reloadCurrent:!0})}else s&&(e.modalRemove(s),a&&e.navigate(a,{reloadCurrent:!0}));return e}let u,h=e.$el.children(".page-current").prevAll(".page-previous:not(.page-master)").eq(0);if(e.params.masterDetailBreakpoint>0){const t=[];e.$el.children(".page").each((e=>{t.push(e.className)}));const a=e.$el.children(".page-current").prevAll(".page-master").eq(0);if(a.length){const t=e.history[e.history.length-2],s=e.findMatchingRoute(t);s&&a[0].f7Page&&s.route===a[0].f7Page.route.route&&(h=a,r.preload||(u=c.width>=e.params.masterDetailBreakpoint))}}if(!r.force&&h.length&&!u){const t=h[0].f7Page;if(e.params.browserHistory&&t&&e.history[e.history.length-2]!==t.route.url)return e.back(e.history[e.history.length-2],Fe(r,{force:!0,props:e.propsHistory[e.propsHistory.length-2]||{}})),e;if(t){const a=t.route;return Tt.call(e,a,e.currentRoute,(()=>{Bt(e,{el:h},Fe(r,{route:a}))}),(()=>{}),"backward"),e}}if("#"===a&&(a=void 0),a&&"/"!==a[0]&&0!==a.indexOf("#")&&(a=((e.path||"/")+a).replace("//","/")),!a&&e.history.length>1&&(a=e.history[e.history.length-2],s=e.propsHistory[e.propsHistory.length-2]||{}),u&&!r.force&&e.history[e.history.length-3])return e.back(e.history[e.history.length-3],Fe({},r||{},{force:!0,animate:!1,props:e.propsHistory[e.propsHistory.length-3]||{}}));if(u&&!r.force)return e;if(o=e.findMatchingRoute(a),o||a&&(o={url:a,path:a.split("?")[0],query:Re(a),route:{path:a.split("?")[0],url:a}}),!o)return e;if(o.route.redirect)return $t.call(e,"backward",o,r);const m={};function f(){let t=!1;function a(t,a){e.allowPageChange=!1,Bt(e,t,Fe(m,a),!0)}function r(){e.allowPageChange=!0}o.route.keepAlive&&o.route.keepAliveData&&(Bt(e,{el:o.route.keepAliveData.pageEl},m),t=!0),"url content component pageName el componentUrl".split(" ").forEach((a=>{o.route[a]&&!t&&(t=!0,Bt(e,{[a]:o.route[a]},m))})),t||(o.route.async&&(e.allowPageChange=!1,o.route.async.call(e,{router:e,to:o,from:e.currentRoute,resolve:a,reject:r,direction:"backward",app:c})),o.route.asyncComponent&&Pt(e,o.route.asyncComponent,a,r))}function g(){e.allowPageChange=!0}return o.route.options?Fe(m,o.route.options,r,{props:s||{}}):Fe(m,r,{props:s||{}}),m.route=o,m.preload?f():Tt.call(e,o,e.currentRoute,(()=>{o.route.modules?c.loadModules(Array.isArray(o.route.modules)?o.route.modules:[o.route.modules]).then((()=>{f()})).catch((()=>{g()})):f()}),(()=>{g()}),"backward"),e},Lt.prototype.clearPreviousHistory=function(){const e=this;St(e,"clearPreviousHistory");const t=e.history[e.history.length-1];!function(e){St(e,"clearPreviousPages");const t=e.app,a=e.dynamicNavbar;e.$el.children(".page").filter((t=>!(!e.currentRoute||!e.currentRoute.modal&&!e.currentRoute.panel)||t!==e.currentPageEl)).each((r=>{const s=A(r),o=A(t.navbar.getElByPage(s));e.pageCallback("beforeRemove",s,o,"previous",void 0,{}),e.removePage(s),a&&o.length&&e.removeNavbar(o)}))}(e),e.history=[t],e.view.history=[t],e.saveHistory()};var Dt={name:"router",static:{Router:Lt},instance:{cache:{xhr:[],templates:[],components:[]}},create(){const e=this;e.app?e.params.router&&(e.router=new Lt(e.app,e)):e.router=new Lt(e)}};function At(e){const t=e.app,a=tt();if(e.resizableInitialized)return;Fe(e,{resizable:!0,resizableWidth:null,resizableInitialized:!0});const r=A("html"),{$el:s}=e;if(!s)return;let o,n,i;const l={};let c,p,d,u;function h(e){if(!e)return null;if(e.indexOf("%")>=0||e.indexOf("vw")>=0)return parseInt(e,10)/100*t.width;const a=parseInt(e,10);return Number.isNaN(a)?null:a}function m(t){if(!(e.resizable&&s.hasClass("view-resizable")&&s.hasClass("view-master-detail")))return;l.x="touchstart"===t.type?t.targetTouches[0].pageX:t.pageX,l.y="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,i=!1,n=!0;const a=s.children(".page-master");d=h(a.css("min-width")),u=h(a.css("max-width"))}function f(a){if(!n)return;a.f7PreventSwipePanel=!0;const h="touchmove"===a.type?a.targetTouches[0].pageX:a.pageX;i||(p=o[0].offsetLeft+o[0].offsetWidth,s.addClass("view-resizing"),r.css("cursor","col-resize")),i=!0,a.preventDefault(),c=h-l.x;let m=p+c;d&&!Number.isNaN(d)&&(m=Math.max(m,d)),u&&!Number.isNaN(u)&&(m=Math.min(m,u)),m=Math.min(Math.max(m,0),t.width),e.resizableWidth=m,r[0].style.setProperty("--f7-page-master-width",`${m}px`),s.trigger("view:resize",m),e.emit("local::resize viewResize",e,m)}function g(){if(A("html").css("cursor",""),!n||!i)return n=!1,void(i=!1);n=!1,i=!1,r[0].style.setProperty("--f7-page-master-width",`${e.resizableWidth}px`),s.removeClass("view-resizing")}function v(){e.resizableWidth&&(d=h(o.css("min-width")),u=h(o.css("max-width")),d&&!Number.isNaN(d)&&e.resizableWidth<d&&(e.resizableWidth=Math.max(e.resizableWidth,d)),u&&!Number.isNaN(u)&&e.resizableWidth>u&&(e.resizableWidth=Math.min(e.resizableWidth,u)),e.resizableWidth=Math.min(Math.max(e.resizableWidth,0),t.width),r[0].style.setProperty("--f7-page-master-width",`${e.resizableWidth}px`))}o=e.$el.children(".view-resize-handler"),o.length||(e.$el.append('<div class="view-resize-handler"></div>'),o=e.$el.children(".view-resize-handler")),e.$resizeHandlerEl=o,s.addClass("view-resizable");const b=!!a.passiveListener&&{passive:!0};e.$el.on(t.touchEvents.start,".view-resize-handler",m,b),t.on("touchmove:active",f),t.on("touchend:passive",g),t.on("resize",v),e.on("beforeOpen",v),e.once("viewDestroy",(()=>{s.removeClass("view-resizable"),e.$resizeHandlerEl.remove(),e.$el.off(t.touchEvents.start,".view-resize-handler",m,b),t.off("touchmove:active",f),t.off("touchend:passive",g),t.off("resize",v),e.off("beforeOpen",v)}))}let Rt=class extends ot{constructor(e,t,a){void 0===a&&(a={}),super(a,[e]);const r=this;if(!r.params.routerId){if(!A(t).length){let e="Framework7: can't create a View instance because ";throw e+="string"==typeof t?`the selector "${t}" didn't match any element`:"el must be an HTMLElement or Dom7 object",new Error(e)}}let s;return r.params=Fe({el:t},{routes:[],routesAdd:[]},e.params.view,a),r.params.routes.length>0?r.routes=r.params.routes:r.routes=[].concat(e.routes,r.params.routesAdd),Fe(!1,r,{app:e,name:r.params.name,main:r.params.main,history:[],scrollHistory:{}}),r.useModules(),e.views.push(r),r.main&&(e.views.main=r),r.name&&(e.views[r.name]=r),r.index=e.views.indexOf(r),s=r.name?`view_${r.name}`:r.main?"view_main":`view_${r.index}`,r.id=s,r.params.init?(e.initialized?r.init():e.on("init",(()=>{r.init()})),r):r}destroy(){let e=this;const t=e.app;e.$el.trigger("view:beforedestroy"),e.emit("local::beforeDestroy viewBeforeDestroy",e),t.off("resize",e.checkMasterDetailBreakpoint),e.main?(t.views.main=null,delete t.views.main):e.name&&(t.views[e.name]=null,delete t.views[e.name]),e.$el[0].f7View=null,delete e.$el[0].f7View,t.views.splice(t.views.indexOf(e),1),e.params.router&&e.router&&e.router.destroy(),e.emit("local::destroy viewDestroy",e),Object.keys(e).forEach((t=>{e[t]=null,delete e[t]})),e=null}checkMasterDetailBreakpoint(e){const t=this,a=t.app,r=t.$el.hasClass("view-master-detail"),s=a.width>=t.params.masterDetailBreakpoint&&t.$el.children(".page-master").length;void 0===e&&s||!0===e?(t.$el.addClass("view-master-detail"),r||(t.emit("local::masterDetailBreakpoint viewMasterDetailBreakpoint",t),t.$el.trigger("view:masterDetailBreakpoint"))):(t.$el.removeClass("view-master-detail"),r&&(t.emit("local::masterDetailBreakpoint viewMasterDetailBreakpoint",t),t.$el.trigger("view:masterDetailBreakpoint")))}initMasterDetail(){const e=this,t=e.app;e.checkMasterDetailBreakpoint=e.checkMasterDetailBreakpoint.bind(e),e.checkMasterDetailBreakpoint(),e.params.masterDetailResizable&&At(e),t.on("resize",e.checkMasterDetailBreakpoint)}mount(e){const t=this,a=t.app,r=t.params.el||e,s=A(r);let o,n;o="string"==typeof r?r:(s.attr("id")?`#${s.attr("id")}`:"")+(s.attr("class")?`.${s.attr("class").replace(/ /g,".").replace(".active","")}`:""),"ios"===a.theme&&t.params.iosDynamicNavbar&&(n=s.children(".navbars").eq(0),0===n.length&&(n=A('<div class="navbars"></div>'))),Fe(t,{$el:s,el:s[0],main:t.main||s.hasClass("view-main"),$navbarsEl:n,navbarsEl:n?n[0]:void 0,selector:o}),t.main&&(a.views.main=t),s&&s[0]&&(s[0].f7View=t),t.emit("local::mount viewMount",t)}init(e){const t=this;t.mount(e),t.params.router&&(t.params.masterDetailBreakpoint>0&&t.initMasterDetail(),t.params.initRouterOnTabShow&&t.$el.hasClass("tab")&&!t.$el.hasClass("tab-active")?t.$el.once("tab:show",(()=>{t.router.init()})):t.router.init(),t.$el.trigger("view:init"),t.emit("local::init viewInit",t))}};Rt.use(Dt);var Ht={name:"clicks",params:{clicks:{externalLinks:".external"}},on:{init(){!function(e){e.on("click",(function(t){const a=o(),r=A(t.target),s=r.closest("a"),n=s.length>0,i=n&&s.attr("href");if(n&&(s.is(e.params.clicks.externalLinks)||i&&i.indexOf("javascript:")>=0)){const e=s.attr("target");return void(i&&a.cordova&&a.cordova.InAppBrowser&&("_system"===e||"_blank"===e)?(t.preventDefault(),a.cordova.InAppBrowser.open(i,e)):i&&a.Capacitor&&a.Capacitor.Plugins&&a.Capacitor.Plugins.Browser&&("_system"===e||"_blank"===e)&&(t.preventDefault(),a.Capacitor.Plugins.Browser.open({url:i})))}Object.keys(e.modules).forEach((a=>{const s=e.modules[a].clicks;s&&(t.preventF7Router||Object.keys(s).forEach((a=>{const o=r.closest(a).eq(0);o.length>0&&s[a].call(e,o,o.dataset(),t)})))}));let l={};if(n&&(t.preventDefault(),l=s.dataset()),l.clickedEl=s[0],!t.preventF7Router&&!s.hasClass("prevent-router")&&!s.hasClass("router-prevent")&&(i&&i.length>0&&"#"!==i[0]||s.hasClass("back"))){let t;if(l.view&&"current"===l.view?t=e.views.current:l.view?t=A(l.view)[0].f7View:(t=r.parents(".view")[0]&&r.parents(".view")[0].f7View,t&&t.params.linksView&&(!s.hasClass("back")||s.hasClass("back")&&1===t.router.history.length)&&("string"==typeof t.params.linksView?t=A(t.params.linksView)[0].f7View:t.params.linksView instanceof Rt&&(t=t.params.linksView))),t||e.views.main&&(t=e.views.main),!t||!t.router)return;s[0].f7RouteProps&&(l.props=s[0].f7RouteProps),s.hasClass("back")?t.router.back(i,l):t.router.navigate(i,l)}}))}(this)}}},zt={name:"routerComponentLoader",proto:{openIn(e,t,a){const r={url:t,route:{path:t,options:{...a,openIn:void 0}}},s={...a};return"popup"===a.openIn&&(r.route.popup=s),"loginScreen"===a.openIn&&(r.route.loginScreen=s),"sheet"===a.openIn&&(r.route.sheet=s),"popover"===a.openIn&&(s.targetEl=a.clickedEl||a.targetEl,r.route.popover=s),a.openIn.indexOf("panel")>=0&&(s.targetEl=a.clickedEl||a.targetEl,r.route.panel=s),s.component=(r,s)=>{const{$h:o,$onMounted:n,$el:i,$f7:l}=s;return n((()=>{const r=i.value.find(".view");l.view.create(r,{linksView:e.view.selector,ignoreOpenIn:!0,loadInitialPage:!1}).router.navigate(t,{props:a.props,reloadAll:!0})})),()=>{if("popup"===a.openIn)return o`<div class="popup popup-router-open-in" data-url="${t}"><div class="view"></div></div>`;if("loginScreen"===a.openIn)return o`<div class="login-screen login-screen-router-open-in" data-url="${t}"><div class="view"></div></div>`;if("sheet"===a.openIn)return o`<div class="sheet-modal sheet-modal-router-open-in" data-url="${t}"><div class="sheet-modal-inner"><div class="view"></div></div></div>`;if("popover"===a.openIn)return o`<div class="popover popover-router-open-in" data-url="${t}"><div class="popover-inner"><div class="view"></div></div></div>`;if(a.openIn.indexOf("panel")>=0){const e=a.openIn.split(":"),r=e[1]||"left",s=e[2]||"cover";return o`<div class="panel panel-router-open-in panel-${r} panel-${s}" data-url="${t}"><div class="view"></div></div>`}}},e.navigate(r)},componentLoader(e,t,a,r,s){void 0===a&&(a={});const o=this,{app:n}=o,i="string"==typeof e?e:t,l=o.replaceRequestUrlParams(i,a);function c(e){let t=a.context||{};if("function"==typeof t)t=t.call(o);else if("string"==typeof t)try{t=JSON.parse(t)}catch(e){throw s(e),e}const i=Ve({},t,{f7route:a.route,f7router:o}),l=Ve(a.route&&a.route.params||{},a.props||{},a.routeProps||{});let c,p;a.componentOptions&&a.componentOptions.el&&(c=a.componentOptions.el),a.componentOptions&&a.componentOptions.root&&(p=a.componentOptions.root),n.component.create(e,l,{context:i,el:c,root:p}).then((e=>{r(e.el)})).catch((e=>{throw s(e),new Error(e,{cause:e})}))}let p;l&&o.params.componentCache&&o.cache.components.forEach((e=>{e.url===l&&(p=e.component)})),l&&p?c(p):l&&!p?(o.xhrAbortController&&(o.xhrAbortController.abort(),o.xhrAbortController=!1),o.xhrRequest(i,a).then((e=>{const t=n.component.parse(e);o.params.componentCache&&o.cache.components.push({url:l,component:t}),c(t)})).catch((e=>{throw s(),e}))):c(e)},modalComponentLoader(e){let{component:t,componentUrl:a,options:r,resolve:s,reject:o}=void 0===e?{}:e;this.componentLoader(t,a,r,(e=>{s(e)}),o)},tabComponentLoader(e){let{component:t,componentUrl:a,options:r,resolve:s,reject:o}=void 0===e?{}:e;this.componentLoader(t,a,r,(e=>{s(e)}),o)},pageComponentLoader(e){let{component:t,componentUrl:a,options:r,resolve:s,reject:o}=void 0===e?{}:e;this.componentLoader(t,a,r,(function(e,t){void 0===t&&(t={}),s(e,t)}),o)}}},Nt=function(e,t,a,r){var s;t[0]=0;for(var o=1;o<t.length;o++){var n=t[o++],i=t[o]?(t[0]|=n?1:2,a[t[o++]]):t[++o];3===n?r[0]=i:4===n?r[1]=Object.assign(r[1]||{},i):5===n?(r[1]=r[1]||{})[t[++o]]=i:6===n?r[1][t[++o]]+=i+"":n?(s=e.apply(i,Nt(e,i,a,["",null])),r.push(s),i[0]?t[0]|=2:(t[o-2]=0,t[o]=s)):r.push(i)}return r},Vt=new Map;const Ft=[!1,null,"",void 0],_t=function(e){var t=Vt.get(this);return t||(t=new Map,Vt.set(this,t)),(t=Nt(this,t.get(e)||(t.set(e,t=function(e){for(var t,a,r=1,s="",o="",n=[0],i=function(e){1===r&&(e||(s=s.replace(/^\s*\n\s*|\s*\n\s*$/g,"")))?n.push(0,e,s):3===r&&(e||s)?(n.push(3,e,s),r=2):2===r&&"..."===s&&e?n.push(4,e,0):2===r&&s&&!e?n.push(5,0,!0,s):r>=5&&((s||!e&&5===r)&&(n.push(r,0,s,a),r=6),e&&(n.push(r,e,0,a),r=6)),s=""},l=0;l<e.length;l++){l&&(1===r&&i(),i(l));for(var c=0;c<e[l].length;c++)t=e[l][c],1===r?"<"===t?(i(),n=[n],r=3):s+=t:4===r?"--"===s&&">"===t?(r=1,s=""):s=t+s[0]:o?t===o?o="":s+=t:'"'===t||"'"===t?o=t:">"===t?(i(),r=1):r&&("="===t?(r=5,a=s,s=""):"/"===t&&(r<5||">"===e[l][c+1])?(i(),3===r&&(n=n[0]),r=n,(n=n[0]).push(2,0,r),r=0):" "===t||"\t"===t||"\n"===t||"\r"===t?(i(),r=2):s+=t),3===r&&"!--"===s&&(r=4,n=n[0])}return i(),n}(e)),t),arguments,[])).length>1?t:t[0]}.bind((function(e,t){for(var a=arguments.length,r=new Array(a>2?a-2:0),s=2;s<a;s++)r[s-2]=arguments[s];return{type:e,props:t||{},children:Qe(r.filter((e=>Ft.indexOf(e)<0)))}}));function qt(e,t,a,r,s){return{sel:e,data:t,children:a,text:r,elm:s,key:void 0===t?void 0:t.key}}var jt=Array.isArray;function Yt(e){return"string"==typeof e||"number"==typeof e}function Wt(e,t,a){if(e.ns="http://www.w3.org/2000/svg","foreignObject"!==a&&void 0!==t)for(var r=0;r<t.length;++r){var s=t[r].data;void 0!==s&&Wt(s,t[r].children,t[r].sel)}}function Xt(e,t,a){var r,s,o,n={};if(void 0!==a?(n=t,jt(a)?r=a:Yt(a)?s=a:a&&a.sel&&(r=[a])):void 0!==t&&(jt(t)?r=t:Yt(t)?s=t:t&&t.sel?r=[t]:n=t),jt(r))for(o=0;o<r.length;++o)Yt(r[o])&&(r[o]=qt(void 0,void 0,void 0,r[o],void 0));return"s"!==e[0]||"v"!==e[1]||"g"!==e[2]||3!==e.length&&"."!==e[3]&&"#"!==e[3]||Wt(n,r,e),qt(e,n,r,s,void 0)}var Ut={};const Gt="area base br col command embed hr img input keygen link menuitem meta param source track wbr".split(" "),Kt="hidden checked disabled readonly selected autofocus autoplay required multiple value indeterminate routeProps innerHTML".split(" "),Qt="hidden checked disabled readonly selected autofocus autoplay required multiple readOnly indeterminate".split(" "),Jt=e=>"function"==typeof e.type?e.type.name||"CustomComponent":e.type,Zt=function(){const e={};for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];return a.forEach((function(t){void 0===t&&(t={}),Object.keys(t).forEach((a=>{var r;e[(r=a,r.split("-").map(((e,t)=>0===t?e.toLowerCase():e[0].toUpperCase()+e.substr(1))).join(""))]=t[a]}))})),e},ea=e=>"function"==typeof e||e&&e.indexOf("-")>0&&Ut[e];function ta(e,t,a,r,s){const o={},n=[],i=[],l=[],c=[];let p=!1,d=Jt(e);t&&t.attrs&&t.attrs.component&&(d=t.attrs.component,delete t.attrs.component,p=!0);const u=ea(e.type);if(u&&(n.push((r=>{(r.sel===d||p)&&(e=>{let{f7:t,treeNode:a,vnode:r,data:s}=e;const o="function"==typeof a.type?a.type:Ut[a.type];t.component.create(o,Zt(s.attrs||{},s.props||{}),{el:r.elm,children:a.children}).then((e=>{r.data&&r.data.on&&e&&e.$el&&Object.keys(r.data.on).forEach((t=>{e.$el.on(t,r.data.on[t])})),r.elm.__component__=e}))})({f7:a,treeNode:e,vnode:r,data:t})})),i.push((e=>{(e=>{const t=e&&e.elm&&e.elm.__component__;if(t){const{el:a,$el:r}=t;e.data&&e.data.on&&r&&Object.keys(e.data.on).forEach((t=>{r.off(t,e.data.on[t])})),t.destroy&&t.destroy(),a&&a.parentNode&&a.parentNode.removeChild(a),delete e.elm.__component__}})(e)})),l.push(((e,t)=>{(e=>{const t=e&&e.elm&&e.elm.__component__;if(!t)return;const a=Zt(e.data.attrs||{},e.data.props||{});t.children=e.data.treeNode.children,Object.assign(t.props,a),t.update()})(t)}))),!u){if(!t||!t.attrs||!t.attrs.class)return o;t.attrs.class.split(" ").forEach((e=>{r||n.push(...a.getVnodeHooks("insert",e)),i.push(...a.getVnodeHooks("destroy",e)),l.push(...a.getVnodeHooks("update",e)),c.push(...a.getVnodeHooks("postpatch",e))}))}return s&&!r&&c.push(((e,t)=>{const a=t||e;a&&a.data&&a.data.component&&a.data.component.hook("onUpdated")})),0===n.length&&0===i.length&&0===l.length&&0===c.length||(n.length&&(o.insert=e=>{n.forEach((t=>t(e)))}),i.length&&(o.destroy=e=>{i.forEach((t=>t(e)))}),l.length&&(o.update=(e,t)=>{l.forEach((a=>a(e,t)))}),c.length&&(o.postpatch=(e,t)=>{c.forEach((a=>a(e,t)))})),o}const aa=(e,t,a,r)=>{if(e&&e.type&&Gt.indexOf(e.type)>=0)return[];const s=[],o=e.children;for(let e=0;e<o.length;e+=1){const n=o[e],i=ra(n,t,a,r,!1);Array.isArray(i)?s.push(...i):i&&s.push(i)}return s},ra=(e,t,a,r,s)=>{if(!(e=>Ne(e)&&"props"in e&&"type"in e&&"children"in e)(e))return String(e);if("slot"===e.type)return((e,t,a,r)=>{const s=e.props.name||"default",o=(t.children||[]).filter((e=>{let t="default";return e.props&&(t=e.props.slot||"default"),t===s}));return 0===o.length?aa(e,t,a,r):o.map((e=>ra(e,t,a,r)))})(e,t,a,r);const o=((e,t,a,r,s)=>{const o={component:t,treeNode:e},n=Jt(e);Object.keys(e.props).forEach((t=>{const a=e.props[t];if(void 0!==a)if(Kt.indexOf(t)>=0)o.props||(o.props={}),"readonly"===t&&(t="readOnly"),"routeProps"===t&&(t="f7RouteProps"),"option"===n&&"value"===t&&(o.attrs||(o.attrs={}),o.attrs.value=a),Qt.indexOf(t)>=0?o.props[t]=!1!==a:o.props[t]=a;else if("key"===t)o.key=a;else if(0===t.indexOf("@")||0===t.indexOf("on")&&t.length>2){o.on||(o.on={});let e=0===t.indexOf("@")?t.substr(1):Oe(t.substr(2)),r=!1,s=!1,n=!1;e.indexOf(".")>=0&&e.split(".").forEach(((t,a)=>{0===a?e=t:("stop"===t&&(r=!0),"prevent"===t&&(s=!0),"once"===t&&(n=!0))})),o.on[e]=function(e,t){let{stop:a,prevent:r,once:s}=void 0===t?{}:t,o=!1;return function(){const t=arguments.length<=0?void 0:arguments[0];s&&o||(a&&t.stopPropagation(),r&&t.preventDefault(),o=!0,e(...arguments))}}(a,{stop:r,prevent:s,once:n})}else"style"===t?"string"!=typeof a?o.style=a:(o.attrs||(o.attrs={}),o.attrs.style=a):(o.attrs||(o.attrs={}),o.attrs[t]=a,"id"!==t||o.key||s||(o.key=a))}));const i=ta(e,o,a,r,s);return i.prepatch=(e,t)=>{e&&t&&e&&e.data&&e.data.props&&Object.keys(e.data.props).forEach((a=>{Qt.indexOf(a)<0||(t.data||(t.data={}),t.data.props||(t.data.props={}),!0!==e.data.props[a]||a in t.data.props||(t.data.props[a]=!1))}))},o.hook=i,o})(e,t,a,r,s),n=ea(e.type)?[]:aa(e,t,a,r);return Xt(Jt(e),o,n)};function sa(e,t,a){return void 0===e&&(e={}),ra(e,t,t.f7,a,!0)}var oa={createElement:function(e){return document.createElement(e)},createElementNS:function(e,t){return document.createElementNS(e,t)},createTextNode:function(e){return document.createTextNode(e)},createComment:function(e){return document.createComment(e)},insertBefore:function(e,t,a){a&&a.parentNode!==e&&a.__component__&&(a=a.__component__.el),e.insertBefore(t,a)},removeChild:function(e,t){e&&e.removeChild(t)},appendChild:function(e,t){e.appendChild(t)},parentNode:function(e){return e.parentNode},nextSibling:function(e){return e.nextSibling},tagName:function(e){return e.tagName},setTextContent:function(e,t){e.textContent=t},getTextContent:function(e){return e.textContent},isElement:function(e){return 1===e.nodeType},isText:function(e){return 3===e.nodeType},isComment:function(e){return 8===e.nodeType}};function na(e){return void 0===e}function ia(e){return void 0!==e}var la=qt("",{},[],void 0,void 0);function ca(e,t){return e.key===t.key&&e.sel===t.sel}function pa(e,t,a){var r,s,o,n={};for(r=t;r<=a;++r)null!=(o=e[r])&&void 0!==(s=o.key)&&(n[s]=r);return n}var da=["create","update","remove","destroy","pre","post"];function ua(e,t){var a,r=t.elm,s=e.data.attrs,o=t.data.attrs;if((s||o)&&s!==o){for(a in s=s||{},o=o||{}){var n=o[a];s[a]!==n&&(!0===n?r.setAttribute(a,""):!1===n?r.removeAttribute(a):120!==a.charCodeAt(0)?r.setAttribute(a,n):58===a.charCodeAt(3)?r.setAttributeNS("http://www.w3.org/XML/1998/namespace",a,n):58===a.charCodeAt(5)?r.setAttributeNS("http://www.w3.org/1999/xlink",a,n):r.setAttribute(a,n))}for(a in s)a in o||r.removeAttribute(a)}}var ha={create:ua,update:ua};function ma(e,t){var a,r,s=t.elm,o=e.data.props,n=t.data.props;if((o||n)&&o!==n){for(a in n=n||{},o=o||{})n[a]||delete s[a];for(a in n)r=n[a],o[a]===r||"value"===a&&s[a]===r||(s[a]=r)}}var fa={create:ma,update:ma},ga="undefined"!=typeof window&&window.requestAnimationFrame||setTimeout,va=function(e){ga((function(){ga(e)}))};function ba(e,t,a){va((function(){e[t]=a}))}function wa(e,t){var a,r,s=t.elm,o=e.data.style,n=t.data.style;if((o||n)&&o!==n){n=n||{};var i="delayed"in(o=o||{});for(r in o)n[r]||("-"===r[0]&&"-"===r[1]?s.style.removeProperty(r):s.style[r]="");for(r in n)if(a=n[r],"delayed"===r&&n.delayed)for(var l in n.delayed)a=n.delayed[l],i&&a===o.delayed[l]||ba(s.style,l,a);else"remove"!==r&&a!==o[r]&&("-"===r[0]&&"-"===r[1]?s.style.setProperty(r,a):s.style[r]=a)}}var ya={create:wa,update:wa,destroy:function(e){var t,a,r=e.elm,s=e.data.style;if(s&&(t=s.destroy))for(a in t)r.style[a]=t[a]},remove:function(e,t){var a=e.data.style;if(a&&a.remove){var r,s=e.elm,o=0,n=a.remove,i=0,l=[];for(r in n)l.push(r),s.style[r]=n[r];for(var c=getComputedStyle(s)["transition-property"].split(", ");o<c.length;++o)-1!==l.indexOf(c[o])&&i++;s.addEventListener("transitionend",(function(e){e.target===s&&--i,0===i&&t()}))}else t()}};function Ca(e,t){const a=e.data.on,r=e.listener,s=e.elm,o=t&&t.data.on,n=t&&t.elm;if(a!==o&&(a&&r&&(o?Object.keys(a).forEach((e=>{o[e]||A(s).off(e,r)})):Object.keys(a).forEach((e=>{A(s).off(e,r)}))),o)){const r=e.listener||function e(t){for(var a=arguments.length,r=new Array(a>1?a-1:0),s=1;s<a;s++)r[s-1]=arguments[s];!function(e,t,a){const r=e.type,s=a.data.on;s&&s[r]&&function(e,t,a){"function"==typeof e&&e(t,...a)}(s[r],e,t)}(t,r,e.vnode)};t.listener=r,r.vnode=t,a?Object.keys(o).forEach((e=>{a[e]||A(n).on(e,r)})):Object.keys(o).forEach((e=>{A(n).on(e,r)}))}}const Ea=function(e,t){var a,r,s={},o=void 0!==t?t:oa;for(a=0;a<da.length;++a)for(s[da[a]]=[],r=0;r<e.length;++r){var n=e[r][da[a]];void 0!==n&&s[da[a]].push(n)}function i(e){var t=e.id?"#"+e.id:"",a=e.className?"."+e.className.split(" ").join("."):"";return qt(o.tagName(e).toLowerCase()+t+a,{},[],void 0,e)}function l(e,t){return function(){if(0==--t){var a=o.parentNode(e);o.removeChild(a,e)}}}function c(e,t){var a,r=e.data;void 0!==r&&ia(a=r.hook)&&ia(a=a.init)&&(a(e),r=e.data);var n=e.children,i=e.sel;if("!"===i)na(e.text)&&(e.text=""),e.elm=o.createComment(e.text);else if(void 0!==i){var l=i.indexOf("#"),p=i.indexOf(".",l),d=l>0?l:i.length,u=p>0?p:i.length,h=-1!==l||-1!==p?i.slice(0,Math.min(d,u)):i,m=e.elm=ia(r)&&ia(a=r.ns)?o.createElementNS(a,h):o.createElement(h);for(d<u&&m.setAttribute("id",i.slice(d+1,u)),p>0&&m.setAttribute("class",i.slice(u+1).replace(/\./g," ")),a=0;a<s.create.length;++a)s.create[a](la,e);if(jt(n))for(a=0;a<n.length;++a){var f=n[a];null!=f&&o.appendChild(m,c(f,t))}else Yt(e.text)&&o.appendChild(m,o.createTextNode(e.text));ia(a=e.data.hook)&&(a.create&&a.create(la,e),a.insert&&t.push(e))}else e.elm=o.createTextNode(e.text);return e.elm}function p(e,t,a,r,s,n){for(;r<=s;++r){var i=a[r];null!=i&&o.insertBefore(e,c(i,n),t)}}function d(e){var t,a,r=e.data;if(void 0!==r){for(ia(t=r.hook)&&ia(t=t.destroy)&&t(e),t=0;t<s.destroy.length;++t)s.destroy[t](e);if(void 0!==e.children)for(a=0;a<e.children.length;++a)null!=(t=e.children[a])&&"string"!=typeof t&&d(t)}}function u(e,t,a,r){for(;a<=r;++a){var n=void 0,i=void 0,c=void 0,p=t[a];if(null!=p)if(ia(p.sel)){for(d(p),i=s.remove.length+1,c=l(p.elm,i),n=0;n<s.remove.length;++n)s.remove[n](p,c);ia(n=p.data)&&ia(n=n.hook)&&ia(n=n.remove)?n(p,c):c()}else o.removeChild(e,p.elm)}}function h(e,t,a){var r,n;ia(r=t.data)&&ia(n=r.hook)&&ia(r=n.prepatch)&&r(e,t);var i=t.elm=e.elm,l=e.children,d=t.children;if(e!==t){if(void 0!==t.data){for(r=0;r<s.update.length;++r)s.update[r](e,t);ia(r=t.data.hook)&&ia(r=r.update)&&r(e,t)}na(t.text)?ia(l)&&ia(d)?l!==d&&function(e,t,a,r){for(var s,n,i,l=0,d=0,m=t.length-1,f=t[0],g=t[m],v=a.length-1,b=a[0],w=a[v];l<=m&&d<=v;)null==f?f=t[++l]:null==g?g=t[--m]:null==b?b=a[++d]:null==w?w=a[--v]:ca(f,b)?(h(f,b,r),f=t[++l],b=a[++d]):ca(g,w)?(h(g,w,r),g=t[--m],w=a[--v]):ca(f,w)?(h(f,w,r),o.insertBefore(e,f.elm,o.nextSibling(g.elm)),f=t[++l],w=a[--v]):ca(g,b)?(h(g,b,r),o.insertBefore(e,g.elm,f.elm),g=t[--m],b=a[++d]):(void 0===s&&(s=pa(t,l,m)),na(n=s[b.key])?(o.insertBefore(e,c(b,r),f.elm),b=a[++d]):((i=t[n]).sel!==b.sel?o.insertBefore(e,c(b,r),f.elm):(h(i,b,r),t[n]=void 0,o.insertBefore(e,i.elm,f.elm)),b=a[++d]));(l<=m||d<=v)&&(l>m?p(e,null==a[v+1]?null:a[v+1].elm,a,d,v,r):u(e,t,l,m))}(i,l,d,a):ia(d)?(ia(e.text)&&o.setTextContent(i,""),p(i,null,d,0,d.length-1,a)):ia(l)?u(i,l,0,l.length-1):ia(e.text)&&o.setTextContent(i,""):e.text!==t.text&&o.setTextContent(i,t.text),ia(n)&&ia(r=n.postpatch)&&r(e,t)}}return function(e,t){var a,r,n,l=[];for(a=0;a<s.pre.length;++a)s.pre[a]();for(function(e){return void 0!==e.sel}(e)||(e=i(e)),ca(e,t)?h(e,t,l):(r=e.elm,n=o.parentNode(r),c(t,l),null!==n&&(o.insertBefore(n,t.elm,o.nextSibling(r)),u(n,[e],0,0))),a=0;a<l.length;++a)l[a].data.hook.insert(l[a]);for(a=0;a<s.post.length;++a)s.post[a]();return t}}([ha,fa,ya,{create:Ca,update:Ca,destroy:Ca}]),ka=[!1,null,"",void 0],$a=[{name:"array",init:e=>e,type:e=>[e].find(Array.isArray),update:(e,t)=>[t].filter(Array.isArray).find((()=>(e.length=0,e.push(...t)))),insert:function(e,t,a){return void 0===a&&(a=[]),e.splice(Math.max(t,0),0,...[a].flat())},replace:function(e,t,a){return void 0===a&&(a=[]),e.splice(Math.max(t,0),Math.min(++t,1),...[a].flat())},append:function(e,t){return void 0===t&&(t=[]),e.push(...[t].flat())},prepend:function(e,t){return void 0===t&&(t=[]),e.unshift(...[t].flat())},swap:(e,t,a)=>{[e[t],e[a]]=[e[a],e[t]]},fromTo:function(e,t,a){return void 0===a&&(a=t),e.splice(Math.max(a,0),0,...e.splice(Math.max(t,0),1))},remove:function(e,t,a){return void 0===a&&(a=e.map(((e,t)=>t))),[t].flat().filter((e=>a.includes(e))).sort(((e,t)=>t-e)).forEach((t=>e.splice(t,1)))},clear:e=>e.length=0},{name:"object",init:e=>e,type:e=>[e].filter((e=>[null!==e,void 0!==e].every((e=>e)))).find((e=>Object.getPrototypeOf(e)===Object.prototype)),update:(e,t)=>Object.assign(e,t),insert:()=>{},replace:()=>{},append:()=>{},prepend:()=>{},swap:()=>({}),fromTo:()=>({}),remove:(e,t)=>[t].flat().forEach((t=>delete e[t])),clear:e=>Object.keys(e).forEach((t=>delete e[t]))},{name:"atoms",type:()=>!0,init:function(e,t){return void 0===t&&(t={}),Object.defineProperty(t,"value",{get:()=>e,set:t=>{e=t}}),t},update:function(e,t){void 0===t&&(t=e.value),e.value=t},insert:()=>({}),replace:()=>({}),append:()=>({}),prepend:()=>({}),swap:()=>({}),fromTo:()=>({}),remove:()=>({}),clear:e=>{e.value=void 0}}];class xa{constructor(e,t,a,s){void 0===a&&(a={});let{el:o,context:n,children:i}=void 0===s?{}:s;const l=r();Ve(this,{f7:e,props:a||{},context:n||{},id:t.id||Se(),children:i||[],theme:{ios:"ios"===e.theme,md:"md"===e.theme},style:t.style,__updateQueue:[],__eventHandlers:[],__onceEventHandlers:[],__onBeforeMount:[],__onMounted:[],__onBeforeUpdate:[],__onUpdated:[],__onBeforeUnmount:[],__onUnmounted:[]});const c=()=>t(this.props,this.getComponentContext(!0));return new Promise(((e,t)=>{(e=>new Promise(((t,a)=>{"function"==typeof e?t(e):e instanceof Promise?e.then((e=>{t(e)})).catch((e=>{a(e)})):a(new Error('Framework7: Component render function is not a "function" type. Didn\'t you forget to "return $render"?'))})))(c()).then((t=>{this.renderFunction=t;const a=this.render();if(o)return this.vnode=sa(a,this,!0),this.style&&(this.styleEl=l.createElement("style"),this.styleEl.innerHTML=this.style),this.el=o,Ea(this.el,this.vnode),this.el=this.vnode.elm,this.$el=A(this.el),this.attachEvents(),this.el.f7Component=this,this.mount(),void e(this);a&&(this.vnode=sa(a,this,!0),this.el=l.createElement(this.vnode.sel||"div"),Ea(this.el,this.vnode),this.$el=A(this.el)),this.style&&(this.styleEl=l.createElement("style"),this.styleEl.innerHTML=this.style),this.attachEvents(),this.el&&(this.el.f7Component=this),e(this)})).catch((e=>{t(e)}))}))}on(e,t){this.__eventHandlers&&this.__eventHandlers.push({eventName:e,handler:t})}once(e,t){this.__eventHandlers&&this.__onceEventHandlers.push({eventName:e,handler:t})}getComponentRef(){const e=this;return t=>{let a=t;const r={};return Object.defineProperty(r,"value",{get:()=>a,set(t){a=t,e.update()}}),r}}getComponentStore(){const{state:e,_gettersPlain:t,dispatch:a}=this.f7.store,r={state:e,dispatch:a};return r.getters=new Proxy(t,{get:(e,t)=>{const a=e[t];return a.onUpdated((e=>{a.value=e,this.update()})),a}}),r}getUseState(){var e=this;return t=>{const a=[t].reduce((function(t,a,r,s,o){return void 0===o&&(o=t.init(a)),{state:o,update:a=>(t.update(o,a),e.update()),remove:a=>(t.remove(o,a),e.update()),clear:()=>(t.clear(o),e.update()),insert:(a,r)=>(t.insert(o,a,r),e.update()),replace:(a,r)=>(t.replace(o,a,r),e.update()),append:a=>(t.append(o,a),e.update()),prepend:a=>(t.prepend(o,a),e.update()),swap:(a,r)=>(t.swap(o,a,r),e.update()),fromTo:(a,r)=>(t.fromTo(o,a,r),e.update()),method:function(t){return void 0===t&&(t=()=>({})),t(o),e.update()},async:function(t){return void 0===t&&(t=()=>Promise.reject(o)),t(o).then((()=>e.update()))}}}),$a.find((e=>e.type(t))));return a.length=12,a[Symbol.iterator]=function(){const e=Object.values(this);e.splice(e.indexOf(12),1);let t=0;return{next(){if(t<e.length){const a=e[t];return t+=1,{value:a,done:!1}}return{done:!0}}}},a}}getComponentContext(e){const t={$f7route:this.context.f7route,$f7router:this.context.f7router,$h:_t,$:A,$id:this.id,$f7:this.f7,$f7ready:this.f7ready.bind(this),$theme:this.theme,$tick:this.tick.bind(this),$update:this.update.bind(this),$emit:this.emit.bind(this),$store:this.getComponentStore(),$ref:this.getComponentRef(),$el:{},$useState:this.getUseState()};return Object.defineProperty(t.$el,"value",{get:()=>this.$el}),e&&Object.assign(t,{$on:this.on.bind(this),$once:this.once.bind(this),$onBeforeMount:e=>this.__onBeforeMount.push(e),$onMounted:e=>this.__onMounted.push(e),$onBeforeUpdate:e=>this.__onBeforeUpdate.push(e),$onUpdated:e=>this.__onUpdated.push(e),$onBeforeUnmount:e=>this.__onBeforeUnmount.push(e),$onUnmounted:e=>this.__onUnmounted.push(e)}),t}render(){return this.renderFunction(this.getComponentContext())}emit(e,t){this.el&&this.$el.trigger(e,t)}attachEvents(){const{$el:e}=this;this.__eventHandlers&&(this.__eventHandlers.forEach((t=>{let{eventName:a,handler:r}=t;e.on(Oe(a),r)})),this.__onceEventHandlers.forEach((t=>{let{eventName:a,handler:r}=t;e.once(Oe(a),r)})))}detachEvents(){const{$el:e}=this;this.__eventHandlers&&(this.__eventHandlers.forEach((t=>{let{eventName:a,handler:r}=t;e.on(Oe(a),r)})),this.__onceEventHandlers.forEach((t=>{let{eventName:a,handler:r}=t;e.once(Oe(a),r)})))}startUpdateQueue(){const e=o();if(this.__requestAnimationFrameId)return;const t=()=>{this.hook("onBeforeUpdate");const e=this.render();if(e){const t=sa(e,this,!1);this.vnode=Ea(this.vnode,t)}};this.__requestAnimationFrameId=e.requestAnimationFrame((()=>{this.__updateIsPending&&t();let a=[...this.__updateQueue];this.__updateQueue=[],this.__updateIsPending=!1,e.cancelAnimationFrame(this.__requestAnimationFrameId),delete this.__requestAnimationFrameId,delete this.__updateIsPending,a.forEach((e=>e())),a=[]}))}tick(e){return new Promise((t=>{this.__updateQueue.push((function(){t(),e&&e()})),this.startUpdateQueue()}))}update(e){return this.__destroyed?new Promise((()=>{})):new Promise((t=>{this.__updateIsPending=!0,this.__updateQueue.push((()=>{t(),e&&e()})),this.startUpdateQueue()}))}setState(e){return this.update(e)}f7ready(e){this.f7.initialized?e(this.f7):this.f7.once("init",(()=>{e(this.f7)}))}mount(e){this.hook("onBeforeMount",this.$el),this.styleEl&&A("head").append(this.styleEl),e&&e(this.el),this.hook("onMounted",this.$el)}destroy(){if(this.__destroyed)return;const e=o();this.hook("onBeforeUnmount"),this.styleEl&&A(this.styleEl).remove(),this.detachEvents(),this.hook("onUnmounted"),this.el&&this.el.f7Component&&(this.el.f7Component=null,delete this.el.f7Component),this.vnode&&(this.vnode=Ea(this.vnode,{sel:this.vnode.sel,data:{}})),e.cancelAnimationFrame(this.__requestAnimationFrameId),this.__updateQueue=[],this.__eventHandlers=[],this.__onceEventHandlers=[],this.__onBeforeMount=[],this.__onMounted=[],this.__onBeforeUpdate=[],this.__onUpdated=[],this.__onBeforeUnmount=[],this.__onUnmounted=[],Ie(this),this.__destroyed=!0}hook(e){for(var t=arguments.length,a=new Array(t>1?t-1:0),r=1;r<t;r++)a[r-1]=arguments[r];this.__destroyed||this[`__${e}`].forEach((e=>{e(...a)}))}}function Ta(e){const t=o(),a=r(),s=Se(),n=`f7_component_create_callback_${s}`;let i;e.match(/<template([ ]?)([a-z0-9-]*)>/)&&(i=e.split(/<template[ ]?[a-z0-9-]*>/).filter(((e,t)=>t>0)).join("<template>").split("</template>").filter(((e,t,a)=>t<a.length-1)).join("</template>").replace(/{{#raw}}([ \n]*)<template/g,"{{#raw}}<template").replace(/\/template>([ \n]*){{\/raw}}/g,"/template>{{/raw}}").replace(/([ \n])<template/g,"$1{{#raw}}<template").replace(/\/template>([ \n])/g,"/template>{{/raw}}$1"));let l,c=null;if(e.indexOf("<style>")>=0&&(c=e.split("<style>")[1].split("</style>")[0]),e.indexOf("<style scoped>")>=0&&(c=e.split("<style scoped>")[1].split("</style>")[0]),e.indexOf("<script>")>=0){const t=e.split("<script>");l=t[t.length-1].split("<\/script>")[0].trim()}else l="return () => {return $render}";l&&l.trim()||(l="return () => {return $render}"),i&&(l=l.replace("$render",`function ($$ctx) {\n          var $ = $$ctx.$$;\n          var $h = $$ctx.$h;\n          var $root = $$ctx.$root;\n          var $f7 = $$ctx.$f7;\n          var $f7route = $$ctx.$f7route;\n          var $f7router = $$ctx.$f7router;\n          var $theme = $$ctx.$theme;\n          var $update = $$ctx.$update;\n          var $store = $$ctx.$store;\n          var $ref = $$ctx.$ref;\n          var $useState = $$ctx.$useState;\n\n          return $h\`${i}\`\n        }\n        `).replace(/export default/g,"return")),l=`window.${n} = function () {${l}}`;const p=a.createElement("script");p.innerHTML=l,A("head").append(p);const d=t[n]();return A(p).remove(),t[n]=null,delete t[n],c&&(d.style=c),d.id=s,d}function Sa(e,t){Ut[e]=t}function Pa(e){delete Ut[e]}xa.$jsx=function(e,t){for(var a=arguments.length,r=new Array(a>2?a-2:0),s=2;s<a;s++)r[s-2]=arguments[s];const o=Qe((r||[]).filter((e=>ka.indexOf(e)<0)));return"Fragment"===e?o:{type:e,props:t||{},children:o}};var Ma={name:"component",static:{Component:xa,parseComponent:Ta,registerComponent:Sa,unregisterComponent:Pa},create(){const e=this;e.component={registerComponent:Sa,unregisterComponent:Pa,parse:e=>Ta(e),create(t,a,r){let{root:s,el:o,context:n,children:i}=r;return new xa(e,t,a,{root:s,el:o,context:n,children:i})}}}},Oa={name:"history",static:{history:Et},on:{init(){Et.init(this)}}};const Ia={registrations:[],register(e,t){const a=this;return"serviceWorker"in o().navigator&&a.serviceWorker.container?new Promise(((r,s)=>{a.serviceWorker.container.register(e,t?{scope:t}:{}).then((e=>{Ia.registrations.push(e),a.emit("serviceWorkerRegisterSuccess",e),r(e)})).catch((e=>{a.emit("serviceWorkerRegisterError",e),s(e)}))})):new Promise(((e,t)=>{t(new Error("Service worker is not supported"))}))},unregister(e){const t=this;if(!("serviceWorker"in o().navigator)||!t.serviceWorker.container)return new Promise(((e,t)=>{t(new Error("Service worker is not supported"))}));let a;return a=e?Array.isArray(e)?e:[e]:Ia.registrations,Promise.all(a.map((e=>new Promise(((a,r)=>{e.unregister().then((()=>{Ia.registrations.indexOf(e)>=0&&Ia.registrations.splice(Ia.registrations.indexOf(e),1),t.emit("serviceWorkerUnregisterSuccess",e),a()})).catch((a=>{t.emit("serviceWorkerUnregisterError",e,a),r(a)}))})))))}};var Ba={name:"sw",params:{serviceWorker:{path:void 0,scope:void 0}},create(){const e=this,t=o();Fe(e,{serviceWorker:{container:"serviceWorker"in t.navigator?t.navigator.serviceWorker:void 0,registrations:Ia.registrations,register:Ia.register.bind(e),unregister:Ia.unregister.bind(e)}})},on:{init(){const e=o();if(!("serviceWorker"in e.navigator))return;const t=this;if(t.device.cordova||e.Capacitor&&e.Capacitor.isNative)return;if(!t.serviceWorker.container)return;const a=t.params.serviceWorker.path,r=t.params.serviceWorker.scope;if(!a||Array.isArray(a)&&!a.length)return;(Array.isArray(a)?a:[a]).forEach((e=>{t.serviceWorker.register(e,r)}))}}};function La(e){void 0===e&&(e={});const t={__store:!0},a={...e.state||{}},r={...e.actions||{}},s={...e.getters||{}},o=Fe({},a);let n=[];const i={},l={};Object.keys(s).forEach((e=>{i[e]=[],l[e]=[]}));const c=e=>s[e]({state:t.state}),p=(e,t)=>{l[e]||(l[e]=[]),l[e].push(t)};t.__removeCallback=e=>{(e=>{Object.keys(l).forEach((t=>{const a=l[t];a.indexOf(e)>=0&&a.splice(a.indexOf(e),1)}))})(e)};const d=function(e,t){if(void 0===t&&(t=!0),"constructor"===e)return;n=[];const a=c(e);((e,t)=>{i[e]||(i[e]=[]),t.forEach((t=>{i[e].indexOf(t)<0&&i[e].push(t)}))})(e,n);const r={value:a,onUpdated:t=>{p(e,t)}};if(!t)return r;const s=e=>{r.value=e};return r.__callback=s,p(e,s),r};return t.state=new Proxy(o,{set:(e,t,a)=>{var r;return e[t]=a,r=t,Object.keys(i).filter((e=>i[e].indexOf(r)>=0)).forEach((e=>{l[e]&&l[e].length&&l[e].forEach((t=>{t(c(e))}))})),!0},get:(e,t)=>(n.push(t),e[t])}),t.getters=new Proxy(s,{set:()=>!1,get:(e,t)=>{if(e[t])return d(t,!0)}}),t._gettersPlain=new Proxy(s,{set:()=>!1,get:(e,t)=>{if(e[t])return d(t,!1)}}),t.dispatch=(e,a)=>new Promise(((s,o)=>{if(!r[e])throw o(),new Error(`Framework7: Store action "${e}" is not found`);s(r[e]({state:t.state,dispatch:t.dispatch},a))})),t}var Da={name:"store",static:{createStore:La},proto:{createStore:La}};const Aa=()=>{const e=o();return e.Capacitor&&e.Capacitor.isNative&&e.Capacitor.Plugins&&e.Capacitor.Plugins.StatusBar},Ra={hide(){const e=o();rt().cordova&&e.StatusBar&&e.StatusBar.hide(),Aa()&&e.Capacitor.Plugins.StatusBar.hide()},show(){const e=o();rt().cordova&&e.StatusBar&&e.StatusBar.show(),Aa()&&e.Capacitor.Plugins.StatusBar.show()},onClick(){const e=this;let t;t=A(".popup.modal-in").length>0?A(".popup.modal-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):A(".panel.panel-in").length>0?A(".panel.panel-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):A(".views > .view.tab-active").length>0?A(".views > .view.tab-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):A(".views").length>0?A(".views").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):e.$el.children(".view").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"),t&&t.length>0&&(t.hasClass("tab")&&(t=t.parent(".tabs").children(".page-content.tab-active")),t.length>0&&t.scrollTop(0,300))},setTextColor(e){const t=o();rt().cordova&&t.StatusBar&&("white"===e?t.StatusBar.styleLightContent():t.StatusBar.styleDefault()),Aa()&&("white"===e?t.Capacitor.Plugins.StatusBar.setStyle({style:"DARK"}):t.Capacitor.Plugins.StatusBar.setStyle({style:"LIGHT"}))},setBackgroundColor(e){const t=o();rt().cordova&&t.StatusBar&&t.StatusBar.backgroundColorByHexString(e),Aa()&&t.Capacitor.Plugins.StatusBar.setBackgroundColor({color:e})},isVisible(){const e=o(),t=rt();return new Promise((a=>{t.cordova&&e.StatusBar&&a(e.StatusBar.isVisible),Aa()&&e.Capacitor.Plugins.StatusBar.getInfo().then((e=>{a(e.visible)})),a(!1)}))},overlaysWebView(e){void 0===e&&(e=!0);const t=o();rt().cordova&&t.StatusBar&&t.StatusBar.overlaysWebView(e),Aa()&&t.Capacitor.Plugins.StatusBar.setOverlaysWebView({overlay:e})},init(){const e=this,t=o(),a=rt(),r=e.params.statusbar;if(!r.enabled)return;const s=a.cordova&&t.StatusBar,n=Aa();(s||n)&&(r.scrollTopOnClick&&A(t).on("statusTap",Ra.onClick.bind(e)),a.ios&&(r.iosOverlaysWebView?Ra.overlaysWebView(!0):Ra.overlaysWebView(!1),"white"===r.iosTextColor?Ra.setTextColor("white"):Ra.setTextColor("black")),a.android&&(r.androidOverlaysWebView?Ra.overlaysWebView(!0):Ra.overlaysWebView(!1),"white"===r.androidTextColor?Ra.setTextColor("white"):Ra.setTextColor("black"))),r.iosBackgroundColor&&a.ios&&Ra.setBackgroundColor(r.iosBackgroundColor),r.androidBackgroundColor&&a.android&&Ra.setBackgroundColor(r.androidBackgroundColor)}};var Ha={name:"statusbar",params:{statusbar:{enabled:!0,scrollTopOnClick:!0,iosOverlaysWebView:!0,iosTextColor:"black",iosBackgroundColor:null,androidOverlaysWebView:!1,androidTextColor:"black",androidBackgroundColor:null}},create(){Ke(this,{statusbar:Ra})},on:{init(){Ra.init.call(this)}}};var za={name:"view",params:{view:{init:!0,initRouterOnTabShow:!1,name:void 0,main:!1,router:!0,linksView:null,xhrCache:!0,xhrCacheIgnore:[],xhrCacheIgnoreGetParameters:!1,xhrCacheDuration:6e5,componentCache:!0,preloadPreviousPage:!0,allowDuplicateUrls:!1,reloadPages:!1,reloadDetail:!1,masterDetailBreakpoint:0,masterDetailResizable:!1,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0,restoreScrollTopOnBack:!0,unloadTabContent:!0,passRouteQueryToRequest:!0,passRouteParamsToRequest:!1,loadInitialPage:!0,iosSwipeBack:!0,iosSwipeBackAnimateShadow:!0,iosSwipeBackAnimateOpacity:!0,iosSwipeBackActiveArea:30,iosSwipeBackThreshold:0,mdSwipeBack:!1,mdSwipeBackAnimateShadow:!0,mdSwipeBackAnimateOpacity:!1,mdSwipeBackActiveArea:30,mdSwipeBackThreshold:0,browserHistory:!1,browserHistoryRoot:void 0,browserHistoryAnimate:!0,browserHistoryAnimateOnLoad:!1,browserHistorySeparator:"#!",browserHistoryOnLoad:!0,browserHistoryInitialMatch:!1,browserHistoryStoreHistory:!0,browserHistoryTabs:"replace",animate:!0,iosDynamicNavbar:!0,iosAnimateNavbarBackIcon:!0,iosPageLoadDelay:0,mdPageLoadDelay:0,routesBeforeEnter:null,routesBeforeLeave:null}},static:{View:Rt},create(){const e=this;Fe(e,{views:Fe([],{create:(t,a)=>new Rt(e,t,a),get(e){const t=A(e);if(t.length&&t[0].f7View)return t[0].f7View}})}),Object.defineProperty(e.views,"current",{enumerable:!0,configurable:!0,get:()=>function(e){const t=A(".popover.modal-in .view"),a=A(".popup.modal-in .view"),r=A(".panel.panel-in .view");let s=A(".views");0===s.length&&(s=e.$el);let o=s.children(".view");if(0===o.length&&(o=s.children(".tabs").children(".view")),o.length>1&&o.hasClass("tab")&&(o=s.children(".view.tab-active"),0===o.length&&(o=s.children(".tabs").children(".view.tab-active"))),t.length>0&&t[0].f7View)return t[0].f7View;if(a.length>0&&a[0].f7View)return a[0].f7View;if(r.length>0&&r[0].f7View)return r[0].f7View;if(o.length>0){if(1===o.length&&o[0].f7View)return o[0].f7View;if(o.length>1)return e.views.main}}(e)}),e.view=e.views},on:{init(){const e=this;A(".view-init").each((t=>{if(t.f7View)return;const a=A(t).dataset();e.views.create(t,a)}))},"modalOpen panelOpen":function(e){const t=this;e.$el.find(".view-init").each((e=>{if(e.f7View)return;const a=A(e).dataset();t.views.create(e,a)}))},"modalBeforeDestroy panelBeforeDestroy":function(e){e&&e.$el&&e.$el.find(".view-init").each((e=>{const t=e.f7View;t&&t.destroy()}))}},vnode:{"view-init":{insert(e){const t=e.elm;if(t.f7View)return;const a=A(t).dataset();this.views.create(t,a)},destroy(e){const t=e.elm.f7View;t&&t.destroy()}}}};const Na={size(e){const t=this;let a=A(e);if(a.hasClass("navbars"))return void(a=a.children(".navbar").each((e=>{t.navbar.size(e)})));const r=a.children(".navbar-inner");if(!r.length)return;const s=r.hasClass("navbar-inner-centered-title")||t.params.navbar[`${t.theme}CenterTitle`],o="ios"===t.theme&&!t.params.navbar[`${t.theme}CenterTitle`];if(!s&&!o)return;if(a.parents(".tab:not(.tab-active)").length>0||a.parents(".popup:not(.modal-in)").length>0)return;"ios"!==t.theme&&t.params.navbar[`${t.theme}CenterTitle`]&&r.addClass("navbar-inner-centered-title"),"ios"!==t.theme||t.params.navbar.iosCenterTitle||r.addClass("navbar-inner-left-title");const n=a.parents(".view").eq(0),i=t.rtl?r.children(".right"):r.children(".left"),l=t.rtl?r.children(".left"):r.children(".right"),c=r.children(".title"),p=r.children(".subnavbar"),d=0===i.length,u=0===l.length,h=d?0:i.outerWidth(!0),m=u?0:l.outerWidth(!0),f=c.outerWidth(!0),g=r.styles(),v=r[0].offsetWidth-parseInt(g.paddingLeft,10)-parseInt(g.paddingRight,10),b=a.hasClass("navbar-previous"),w=r.hasClass("sliding");let y,C,E,k;n.length>0&&n[0].f7View&&(y=n[0].f7View.router,C=y&&y.dynamicNavbar),u&&(E=v-f),d&&(E=0),d||u||(E=(v-m-f+h)/2);let $=(v-f)/2;v-h-m>f?($<h&&($=h),$+f>v-m&&($=v-m-f),k=$-E):k=0;const x=t.rtl?-1:1;if(C&&"ios"===t.theme){if(c.hasClass("sliding")||c.length>0&&w){let e=-(E+k)*x;const t=(v-E-k-f)*x;if(b&&y&&y.params.iosAnimateNavbarBackIcon){const t=a.parent().find(".navbar-current").children(".left.sliding").find(".back .icon ~ span");t.length>0&&(e+=t[0].offsetLeft)}c[0].f7NavbarLeftOffset=e,c[0].f7NavbarRightOffset=t}if(!d&&(i.hasClass("sliding")||w))if(t.rtl)i[0].f7NavbarLeftOffset=-(v-i[0].offsetWidth)/2*x,i[0].f7NavbarRightOffset=h*x;else if(i[0].f7NavbarLeftOffset=-h,i[0].f7NavbarRightOffset=(v-i[0].offsetWidth)/2,y&&y.params.iosAnimateNavbarBackIcon&&i.find(".back .icon").length>0&&i.find(".back .icon ~ span").length){const e=i[0].f7NavbarLeftOffset,t=i[0].f7NavbarRightOffset;i[0].f7NavbarLeftOffset=0,i[0].f7NavbarRightOffset=0,i.find(".back .icon ~ span")[0].f7NavbarLeftOffset=e,i.find(".back .icon ~ span")[0].f7NavbarRightOffset=t-i.find(".back .icon")[0].offsetWidth}u||!l.hasClass("sliding")&&!w||(t.rtl?(l[0].f7NavbarLeftOffset=-m*x,l[0].f7NavbarRightOffset=(v-l[0].offsetWidth)/2*x):(l[0].f7NavbarLeftOffset=-(v-l[0].offsetWidth)/2,l[0].f7NavbarRightOffset=m)),p.length&&(p.hasClass("sliding")||w)&&(p[0].f7NavbarLeftOffset=t.rtl?p[0].offsetWidth:-p[0].offsetWidth,p[0].f7NavbarRightOffset=-p[0].f7NavbarLeftOffset)}if(s){let e=k;t.rtl&&d&&u&&c.length>0&&(e=-e),c.css({left:`${e}px`})}},hide(e,t,a,r){void 0===t&&(t=!0),void 0===a&&(a=!1),void 0===r&&(r=!1);const s=this;let o=A(e);const n=o.hasClass("navbar")&&o.parent(".navbars").length&&!r;if(n&&(o=o.parents(".navbars")),!o.length)return;if(o.hasClass("navbar-hidden"))return;let i="navbar-hidden"+(t?" navbar-transitioning":"");(n?o.find(".navbar-current .title-large").length:o.find(".title-large").length)&&(i+=" navbar-large-hidden"),a&&(i+=" navbar-hidden-statusbar"),o.transitionEnd((()=>{o.removeClass("navbar-transitioning")})),o.addClass(i),n?o.children(".navbar").each((e=>{A(e).trigger("navbar:hide"),s.emit("navbarHide",e)})):(o.trigger("navbar:hide"),s.emit("navbarHide",o[0]))},show(e,t,a){void 0===e&&(e=".navbar-hidden"),void 0===t&&(t=!0),void 0===a&&(a=!1);const r=this;let s=A(e);const o=s.hasClass("navbar")&&s.parent(".navbars").length&&!a;o&&(s=s.parents(".navbars")),s.length&&s.hasClass("navbar-hidden")&&(t&&(s.addClass("navbar-transitioning"),s.transitionEnd((()=>{s.removeClass("navbar-transitioning")}))),s.removeClass("navbar-hidden navbar-large-hidden navbar-hidden-statusbar"),o?s.children(".navbar").each((e=>{A(e).trigger("navbar:show"),r.emit("navbarShow",e)})):(s.trigger("navbar:show"),r.emit("navbarShow",s[0])))},getElByPage(e){let t,a,r;if(e.$navbarEl||e.$el?(r=e,t=e.$el):(t=A(e),t.length>0&&(r=t[0].f7Page)),r&&r.$navbarEl&&r.$navbarEl.length>0?a=r.$navbarEl:t&&(a=t.children(".navbar")),a&&(!a||0!==a.length))return a[0]},getPageByEl(e){const t=A(e);if(t.parents(".page").length)return t.parents(".page")[0];let a;return t.parents(".view").find(".page").each((e=>{e&&e.f7Page&&e.f7Page.navbarEl&&t[0]===e.f7Page.navbarEl&&(a=e)})),a},collapseLargeTitle(e){const t=this;let a=A(e);if(a.hasClass("navbars")&&(a=a.find(".navbar"),a.length>1&&(a=A(e).find(".navbar-large.navbar-current")),a.length>1||!a.length))return;const r=A(t.navbar.getPageByEl(a));a.addClass("navbar-large-collapsed"),r.eq(0).addClass("page-with-navbar-large-collapsed").trigger("page:navbarlargecollapsed"),t.emit("pageNavbarLargeCollapsed",r[0]),a.trigger("navbar:collapse"),t.emit("navbarCollapse",a[0])},expandLargeTitle(e){const t=this;let a=A(e);if(a.hasClass("navbars")&&(a=a.find(".navbar-large"),a.length>1&&(a=A(e).find(".navbar-large.navbar-current")),a.length>1||!a.length))return;const r=A(t.navbar.getPageByEl(a));a.removeClass("navbar-large-collapsed"),r.eq(0).removeClass("page-with-navbar-large-collapsed").trigger("page:navbarlargeexpanded"),t.emit("pageNavbarLargeExpanded",r[0]),a.trigger("navbar:expand"),t.emit("navbarExpand",a[0])},toggleLargeTitle(e){const t=this;let a=A(e);a.hasClass("navbars")&&(a=a.find(".navbar-large"),a.length>1&&(a=A(e).find(".navbar-large.navbar-current")),a.length>1||!a.length)||(a.hasClass("navbar-large-collapsed")?t.navbar.expandLargeTitle(a):t.navbar.collapseLargeTitle(a))},initNavbarOnScroll(e,t,a,r,s){const o=this,n=tt(),i=A(e),l=A(t),c=l.find(".title-large"),p=c.length||l.hasClass(".navbar-large");let d=44;const u=o.params.navbar.snapPageScrollToLargeTitle,h=o.params.navbar.snapPageScrollToTransparentNavbar;let m,f,g,v,b,w,y,C,E,k,$,x,T,S;(r||a&&p)&&(E=l.css("--f7-navbar-large-title-height"),E&&E.indexOf("px")>=0?(E=parseInt(E,10),Number.isNaN(E)&&c.length?E=c[0].offsetHeight:Number.isNaN(E)&&("ios"===o.theme?E=52:"md"===o.theme&&(E=88))):c.length?E=c[0].offsetHeight:"ios"===o.theme?E=52:"md"===o.theme&&(E=88)),a&&p&&(d+=E);function P(){i.find(".page-content").each((e=>{e.f7ScrollableDistance=e.scrollHeight-e.offsetHeight}))}function M(){l.hasClass("with-searchbar-expandable-enabled")||!x||f<0||(f>=E/2&&f<E?A(x).scrollTop(E,100):f<E&&A(x).scrollTop(0,200))}function O(){l.hasClass("with-searchbar-expandable-enabled")||!x||f<0||(f>=k/2&&f<k?A(x).scrollTop(k,100):f<k&&A(x).scrollTop(0,200))}let I=null,B=null;function L(e){x=this,e&&e.target&&e.target!==x||(f=x.scrollTop,$=f,r?function(e){if(l.hasClass("navbar-hidden")||l.parent(".navbars").hasClass("navbar-hidden"))return;const t=l.hasClass("navbar-large-transparent")||l.hasClass("navbar-large")&&l.hasClass("navbar-transparent");I=B;const a=Math.min(E,e.f7ScrollableDistance||E);B=Math.min(Math.max(f/a,0),1);const r=I>0&&I<1;if(l.hasClass("with-searchbar-expandable-enabled"))return;C=l.hasClass("navbar-large-collapsed");const s=l.find(".navbar-bg");0===B&&C?o.navbar.expandLargeTitle(l[0]):1!==B||C||o.navbar.collapseLargeTitle(l[0]),0===B&&C||0===B&&r||1===B&&!C||1===B&&r?("md"===o.theme&&l.find(".navbar-inner").css("overflow",""),l.find(".title").css("opacity",""),l.find(".title-large-text, .subnavbar").css("transform",""),l.find(".title-large-text").css("opacity",""),t&&s.css("opacity",""),s.css("transform","")):B>0&&B<1&&("md"===o.theme&&l.find(".navbar-inner").css("overflow","visible"),l.find(".title").css("opacity",1.5*B-.5),l.find(".title-large-text, .subnavbar").css("transform",`translate3d(0px, ${-1*B*E}px, 0)`),l.find(".title-large-text").css("opacity",1-2*B),t&&s.css("opacity",B),s.css("transform",`translate3d(0px, ${-1*B*E}px, 0)`)),u&&(n.touch?S&&(clearTimeout(S),S=null,S=setTimeout((()=>{M(),clearTimeout(S),S=null}),70)):(clearTimeout(T),T=setTimeout((()=>{M()}),300)))}(x):s&&function(){const e=l.hasClass("navbar-hidden")||l.parent(".navbars").hasClass("navbar-hidden");if(l.hasClass("with-searchbar-expandable-enabled")||e)return;k||(k=t.offsetHeight);let a=f/k;const r=l.hasClass("navbar-transparent-visible");if(a=Math.max(Math.min(a,1),0),r&&1===a||!r&&0===a)l.find(".navbar-bg, .title").css("opacity","");else{if(r&&0===a)return l.trigger("navbar:transparenthide"),o.emit("navbarTransparentHide",l[0]),l.removeClass("navbar-transparent-visible"),void l.find(".navbar-bg, .title").css("opacity","");if(!r&&1===a)return l.trigger("navbar:transparentshow"),o.emit("navbarTransparentShow",l[0]),l.addClass("navbar-transparent-visible"),void l.find(".navbar-bg, .title").css("opacity","");l.find(".navbar-bg, .title").css("opacity",a),h&&(n.touch?S&&(clearTimeout(S),S=null,S=setTimeout((()=>{O(),clearTimeout(S),S=null}),70)):(clearTimeout(T),T=setTimeout((()=>{O()}),300)))}}(),i.hasClass("page-previous")||a&&(i.hasClass("page-with-card-opened")||(g=x.scrollHeight,v=x.offsetHeight,b=f+v>=g,y=l.hasClass("navbar-hidden")||l.parent(".navbars").hasClass("navbar-hidden"),b?o.params.navbar.showOnPageScrollEnd&&(w="show"):w=m>f?o.params.navbar.showOnPageScrollTop||f<=d?"show":"hide":f>d?"hide":"show","show"===w&&y?(o.navbar.show(l,!0,!0),y=!1):"hide"!==w||y||(o.navbar.hide(l,!0,!1,!0),y=!0),m=f)))}function D(){$=!1}function R(){clearTimeout(S),S=null,S=setTimeout((()=>{!1!==$&&(s&&!r?O():M(),clearTimeout(S),S=null)}),70)}i.on("scroll",".page-content",L,!0),n.touch&&(r&&u||s&&h)&&(o.on("touchstart:passive",D),o.on("touchend:passive",R)),P(),(r||s)&&i.find(".page-content").each((e=>{e.scrollTop>0&&L.call(e)})),o.on("resize",P),i[0].f7DetachNavbarScrollHandlers=function(){o.off("resize",P),delete i[0].f7DetachNavbarScrollHandlers,i.off("scroll",".page-content",L,!0),n.touch&&(r&&u||s&&h)&&(o.off("touchstart:passive",D),o.off("touchend:passive",R))}}};var Va={name:"navbar",create(){Ke(this,{navbar:Na})},params:{navbar:{scrollTopOnTitleClick:!0,iosCenterTitle:!0,mdCenterTitle:!1,hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0,collapseLargeTitleOnScroll:!0,snapPageScrollToLargeTitle:!0,snapPageScrollToTransparentNavbar:!0}},on:{"panelBreakpoint panelCollapsedBreakpoint panelResize viewResize resize viewMasterDetailBreakpoint":function(){const e=this;A(".navbar").each((t=>{e.navbar.size(t)}))},pageBeforeRemove(e){e.$el[0].f7DetachNavbarScrollHandlers&&e.$el[0].f7DetachNavbarScrollHandlers()},pageBeforeIn(e){const t=this;if("ios"!==t.theme)return;let a;const r=e.$el.parents(".view")[0].f7View,s=t.navbar.getElByPage(e);if(a=s?A(s).parents(".navbars"):e.$el.parents(".view").children(".navbars"),e.$el.hasClass("no-navbar")||r.router.dynamicNavbar&&!s){const r=!!(e.pageFrom&&e.router.history.length>0);t.navbar.hide(a,r)}else t.navbar.show(a)},pageReinit(e){const t=A(this.navbar.getElByPage(e));t&&0!==t.length&&this.navbar.size(t)},pageInit(e){const t=this,a=A(t.navbar.getElByPage(e));if(!a||0===a.length)return;let r,s,o;t.navbar.size(a),a.find(".title-large").length>0&&a.addClass("navbar-large"),a.hasClass("navbar-large")&&(t.params.navbar.collapseLargeTitleOnScroll&&(r=!0),e.$el.addClass("page-with-navbar-large")),!r&&a.hasClass("navbar-transparent")&&(s=!0),(t.params.navbar.hideOnPageScroll||e.$el.find(".hide-navbar-on-scroll").length||e.$el.hasClass("hide-navbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll"))&&(o=!(e.$el.find(".keep-navbar-on-scroll").length||e.$el.hasClass("keep-navbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))),(r||o||s)&&t.navbar.initNavbarOnScroll(e.el,a[0],o,r,s)},"panelOpen panelSwipeOpen modalOpen":function(e){const t=this;e.$el.find(".navbar:not(.navbar-previous)").each((e=>{t.navbar.size(e)}))},tabShow(e){const t=this;A(e).find(".navbar:not(.navbar-previous)").each((e=>{t.navbar.size(e)}))}},clicks:{".navbar .title":function(e,t,a){if(!this.params.navbar.scrollTopOnTitleClick)return;if(A(a.target).closest("a, button").length>0)return;let r;const s=e.parents(".navbar"),o=s.parents(".navbars");r=s.parents(".page-content"),0===r.length&&(s.parents(".page").length>0&&(r=s.parents(".page").find(".page-content")),0===r.length&&o.length&&o.nextAll(".page-current").length>0&&(r=o.nextAll(".page-current").find(".page-content")),0===r.length&&s.nextAll(".page-current").length>0&&(r=s.nextAll(".page-current").find(".page-content"))),r&&r.length>0&&(r.hasClass("tab")&&(r=r.parent(".tabs").children(".page-content.tab-active")),r.length>0&&r.scrollTop(0,300))}},vnode:{navbar:{postpatch(e){this.navbar.size(e.elm)}}}};const Fa={setHighlight(e){const t=this,a=A(e);if("ios"===t.theme&&!a.hasClass("tabbar-highlight"))return;if(0===a.length||!a.hasClass("tabbar")&&!a.hasClass("tabbar-icons"))return;let r=a.find(".tab-link-highlight");const s=a.find(".tab-link").length;if(0===s)return void r.remove();0===r.length?(a.children(".toolbar-inner").append('<span class="tab-link-highlight"></span>'),r=a.find(".tab-link-highlight")):r.next().length&&a.children(".toolbar-inner").append(r);const o=a.find(".tab-link-active");let n,i;if(a.hasClass("tabbar-scrollable")&&o&&o[0])n=`${o[0].offsetWidth}px`,i=`${o[0].offsetLeft}px`;else{const e=o.index();n=100/s+"%",i=100*(t.rtl?-e:e)+"%"}De((()=>{r.css("width",n).transform(`translate3d(${i},0,0)`)}))},init(e){this.toolbar.setHighlight(e)},hide(e,t){void 0===t&&(t=!0);const a=A(e);if(a.hasClass("toolbar-hidden"))return;const r="toolbar-hidden"+(t?" toolbar-transitioning":"");a.transitionEnd((()=>{a.removeClass("toolbar-transitioning")})),a.addClass(r),a.trigger("toolbar:hide"),this.emit("toolbarHide",a[0])},show(e,t){void 0===t&&(t=!0);const a=A(e);a.hasClass("toolbar-hidden")&&(t&&(a.addClass("toolbar-transitioning"),a.transitionEnd((()=>{a.removeClass("toolbar-transitioning")}))),a.removeClass("toolbar-hidden"),a.trigger("toolbar:show"),this.emit("toolbarShow",a[0]))},initToolbarOnScroll(e){const t=this,a=A(e);let r,s,o,n,i,l,c,p=a.parents(".view").children(".toolbar");function d(e){if(a.hasClass("page-with-card-opened"))return;if(a.hasClass("page-previous"))return;const d=this;e&&e.target&&e.target!==d||(s=d.scrollTop,o=d.scrollHeight,n=d.offsetHeight,i=s+n>=o,c=p.hasClass("toolbar-hidden"),i?t.params.toolbar.showOnPageScrollEnd&&(l="show"):l=r>s?t.params.toolbar.showOnPageScrollTop||s<=44?"show":"hide":s>44?"hide":"show","show"===l&&c?(t.toolbar.show(p),c=!1):"hide"!==l||c||(t.toolbar.hide(p),c=!0),r=s)}0===p.length&&(p=a.find(".toolbar")),0===p.length&&(p=a.parents(".views").children(".tabbar, .tabbar-icons")),0!==p.length&&(a.on("scroll",".page-content",d,!0),a[0].f7ScrollToolbarHandler=d)}};var _a={name:"toolbar",create(){Ke(this,{toolbar:Fa})},params:{toolbar:{hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{pageBeforeRemove(e){e.$el[0].f7ScrollToolbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollToolbarHandler,!0)},pageBeforeIn(e){const t=this;let a=e.$el.parents(".view").children(".toolbar");0===a.length&&(a=e.$el.parents(".views").children(".tabbar, .tabbar-icons")),0===a.length&&(a=e.$el.find(".toolbar")),0!==a.length&&(e.$el.hasClass("no-toolbar")?t.toolbar.hide(a):t.toolbar.show(a))},pageInit(e){const t=this;if(e.$el.find(".tabbar, .tabbar-icons").each((e=>{t.toolbar.init(e)})),t.params.toolbar.hideOnPageScroll||e.$el.find(".hide-toolbar-on-scroll").length||e.$el.hasClass("hide-toolbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll")){if(e.$el.find(".keep-toolbar-on-scroll").length||e.$el.hasClass("keep-toolbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;t.toolbar.initToolbarOnScroll(e.el)}},init(){const e=this;e.$el.find(".tabbar, .tabbar-icons").each((t=>{e.toolbar.init(t)}))}},vnode:{tabbar:{insert(e){this.toolbar.init(e.elm)}}}},qa={name:"subnavbar",on:{pageInit(e){e.$navbarEl&&e.$navbarEl.length&&e.$navbarEl.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar");e.$el.find(".subnavbar").filter((t=>A(t).parents(".page")[0]===e.$el[0])).length&&e.$el.addClass("page-with-subnavbar")}}};let ja=class{constructor(e,t,a,r){const s=this;if(!t)return;const{left:o,top:n,width:i,height:l}=t[0].getBoundingClientRect(),c=a-o,p=r-n;let d=Math.max((l**2+i**2)**.5,48),u=!1;const h=e.params.touch.touchRippleInsetElements||"";if(h&&t.is(h)&&(u=!0),u&&(d=Math.max(Math.min(i,l),48)),u||"hidden"!==t.css("overflow"))s.rippleTransform=`translate3d(${i/2-c}px, ${l/2-p}px, 0) scale(1)`;else{const e=(d/2+((c-i/2)**2+(p-l/2)**2)**.5)/(d/2);s.rippleTransform=`translate3d(0px, 0px, 0) scale(${2*e})`}return u&&t.addClass("ripple-inset"),s.$rippleWaveEl=A(`<div class="ripple-wave${u?" ripple-wave-inset":""}" style="width: ${d}px; height: ${d}px; margin-top:-${d/2}px; margin-left:-${d/2}px; left:${c}px; top:${p}px; --f7-ripple-transform: ${s.rippleTransform}"></div>`),t.prepend(s.$rippleWaveEl),s.$rippleWaveEl.animationEnd((()=>{s.$rippleWaveEl&&(s.$rippleWaveEl.hasClass("ripple-wave-out")||(s.$rippleWaveEl.addClass("ripple-wave-in"),s.shouldBeRemoved&&s.out()))})),s}destroy(){let e=this;e.$rippleWaveEl&&e.$rippleWaveEl.remove(),Object.keys(e).forEach((t=>{e[t]=null,delete e[t]})),e=null}out(){const e=this,{$rippleWaveEl:t}=this;clearTimeout(e.removeTimeout),t.addClass("ripple-wave-out"),e.removeTimeout=setTimeout((()=>{e.destroy()}),300),t.animationEnd((()=>{clearTimeout(e.removeTimeout),e.destroy()}))}remove(){const e=this;e.shouldBeRemoved||(e.removeTimeout=setTimeout((()=>{e.destroy()}),400),e.shouldBeRemoved=!0,e.$rippleWaveEl.hasClass("ripple-wave-in")&&e.out())}};var Ya={name:"touch-ripple",static:{TouchRipple:ja},create(){this.touchRipple={create(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];return new ja(...t)}}}};const Wa=[],Xa=[];let Ua=class extends ot{constructor(e,t){super(t,[e]);const a=this,r={};a.useModulesParams(r),a.params=Fe(r,t),a.opened=!1;let s=a.params.containerEl?A(a.params.containerEl).eq(0):e.$el;return s.length||(s=e.$el),a.$containerEl=s,a.containerEl=s[0],a.useModules(),this}onOpen(){const e=this;e.opened=!0,Wa.push(e),A("html").addClass(`with-modal-${e.type.toLowerCase()}`),e.$el.trigger(`modal:open ${e.type.toLowerCase()}:open`),e.emit(`local::open modalOpen ${e.type}Open`,e)}onOpened(){const e=this;e.$el.trigger(`modal:opened ${e.type.toLowerCase()}:opened`),e.emit(`local::opened modalOpened ${e.type}Opened`,e)}onClose(){const e=this;e.opened=!1,e.type&&e.$el&&(Wa.splice(Wa.indexOf(e),1),A("html").removeClass(`with-modal-${e.type.toLowerCase()}`),e.$el.trigger(`modal:close ${e.type.toLowerCase()}:close`),e.emit(`local::close modalClose ${e.type}Close`,e))}onClosed(){const e=this;e.type&&e.$el&&(e.$el.removeClass("modal-out"),e.$el.hide(),e.params.backdrop&&(e.params.backdropUnique||e.forceBackdropUnique)&&e.$backdropEl&&e.$backdropEl.remove(),e.$el.trigger(`modal:closed ${e.type.toLowerCase()}:closed`),e.emit(`local::closed modalClosed ${e.type}Closed`,e))}open(e,t){const a=this,s=r(),o=a.app,n=a.$el,i=a.$backdropEl,l=a.type;let c=!0;if(void 0!==e?c=e:void 0!==a.params.animate&&(c=a.params.animate),(!n||n.hasClass("modal-in"))&&(!1===e&&n[0]&&"dialog"!==l&&(n[0].style.display="block"),!t))return a;if("dialog"===l&&o.params.modal.queueDialogs){let e;if(A(".dialog.modal-in").length>0?e=!0:Wa.length>0&&Wa.forEach((t=>{"dialog"===t.type&&(e=!0)})),e)return Xa.push(a),a}const p=n.parent(),d=n.parents(s).length>0;function u(){n.hasClass("modal-out")?a.onClosed():n.hasClass("modal-in")&&a.onOpened()}return p.is(a.$containerEl)||(a.$containerEl.append(n),a.once(`${l}Closed`,(()=>{d?p.append(n):n.remove()}))),n.show(),a.params.backdrop&&(a.params.backdropUnique||a.forceBackdropUnique)&&a.$backdropEl&&a.$backdropEl.insertBefore(n),a._clientLeft=n[0].clientLeft,c?(i&&(i.removeClass("not-animated"),i.addClass("backdrop-in")),n.animationEnd((()=>{u()})),n.transitionEnd((()=>{u()})),n.removeClass("modal-out not-animated").addClass("modal-in"),a.onOpen()):(i&&i.addClass("backdrop-in not-animated"),n.removeClass("modal-out").addClass("modal-in not-animated"),a.onOpen(),a.onOpened()),a}close(e){const t=this,a=t.$el,r=t.$backdropEl;let s=!0;if(void 0!==e?s=e:void 0!==t.params.animate&&(s=t.params.animate),!a||!a.hasClass("modal-in"))return Xa.indexOf(t)>=0&&Xa.splice(Xa.indexOf(t),1),t;if(r){let e=!0;"popup"===t.type&&t.$el.prevAll(".popup.modal-in").add(t.$el.nextAll(".popup.modal-in")).each((a=>{const r=a.f7Modal;r&&r.params.closeByBackdropClick&&r.params.backdrop&&r.backdropEl===t.backdropEl&&(e=!1)})),e&&(r[s?"removeClass":"addClass"]("not-animated"),r.removeClass("backdrop-in"))}function o(){a.hasClass("modal-out")?t.onClosed():a.hasClass("modal-in")&&t.onOpened()}return a[s?"removeClass":"addClass"]("not-animated"),s?(a.animationEnd((()=>{o()})),a.transitionEnd((()=>{o()})),a.removeClass("modal-in").addClass("modal-out"),t.onClose()):(a.addClass("not-animated").removeClass("modal-in").addClass("modal-out"),t.onClose(),t.onClosed()),"dialog"===t.type&&function(){if(0===Xa.length)return;Xa.shift().open()}(),t}destroy(){const e=this;e.destroyed||(e.emit(`local::beforeDestroy modalBeforeDestroy ${e.type}BeforeDestroy`,e),e.$el&&(e.$el.trigger(`modal:beforedestroy ${e.type.toLowerCase()}:beforedestroy`),e.$el.length&&e.$el[0].f7Modal&&delete e.$el[0].f7Modal),Ie(e),e.destroyed=!0)}};class Ga extends Ua{constructor(e,t){const a=Fe({backdrop:!0,closeByBackdropClick:!0,on:{}},t);super(e,a);const r=this;let s,o;if(r.params=a,s=r.params.el?A(r.params.el):A(r.params.content),s&&s.length>0&&s[0].f7Modal)return s[0].f7Modal;if(0===s.length)return r.destroy();function n(e){r&&!r.destroyed&&o&&e.target===o[0]&&r.close()}return r.params.backdrop&&(o=e.$el.children(".custom-modal-backdrop"),0===o.length&&(o=A('<div class="custom-modal-backdrop"></div>'),e.$el.append(o))),r.on("customModalOpened",(()=>{r.params.closeByBackdropClick&&r.params.backdrop&&e.on("click",n)})),r.on("customModalClose",(()=>{r.params.closeByBackdropClick&&r.params.backdrop&&e.off("click",n)})),Fe(r,{app:e,$el:s,el:s[0],$backdropEl:o,backdropEl:o&&o[0],type:"customModal"}),s[0].f7Modal=r,r}}var Ka={name:"modal",static:{Modal:Ua,CustomModal:Ga},create(){const e=this;e.customModal={create:t=>new Ga(e,t)}},params:{modal:{queueDialogs:!0}}};let Qa=class extends Ua{constructor(e,t){const a=Fe({title:e.params.dialog.title,text:void 0,content:"",buttons:[],verticalButtons:!1,onClick:void 0,cssClass:void 0,destroyOnClose:!1,on:{}},t);void 0===a.closeByBackdropClick&&(a.closeByBackdropClick=e.params.dialog.closeByBackdropClick),void 0===a.backdrop&&(a.backdrop=e.params.dialog.backdrop),super(e,a);const s=this,o=rt(),n=r(),{title:i,text:l,content:c,buttons:p,verticalButtons:d,cssClass:u,backdrop:h}=a;let m,f,g;if(s.params=a,s.params.el)m=A(s.params.el);else{const e=["dialog"];0===p.length&&e.push("dialog-no-buttons"),p.length>0&&e.push(`dialog-buttons-${p.length}`),d&&e.push("dialog-buttons-vertical"),u&&e.push(u);let t="";p.length>0&&(t=ct("div",{class:"dialog-buttons"},p.map((e=>ct("span",{class:`dialog-button${e.strong?" dialog-button-strong":""}${e.color?` color-${e.color}`:""}${e.cssClass?` ${e.cssClass}`:""}`},e.text)))));const a=ct("div",{class:e.join(" ")},ct("div",{class:"dialog-inner"},i&&ct("div",{class:"dialog-title"},i),l&&ct("div",{class:"dialog-text"},l),c),t);m=A(a)}if(m&&m.length>0&&m[0].f7Modal)return m[0].f7Modal;if(0===m.length)return s.destroy();function v(e){const t=A(this).index(),a=p[t];a.onClick&&a.onClick(s,e),s.params.onClick&&s.params.onClick(s,t),!1!==a.close&&s.close()}function b(e){const t=e.keyCode;p.forEach(((a,r)=>{a.keyCodes&&a.keyCodes.indexOf(t)>=0&&(n.activeElement&&n.activeElement.blur(),a.onClick&&a.onClick(s,e),s.params.onClick&&s.params.onClick(s,r),!1!==a.close&&s.close())}))}function w(e){const t=e.target;0===A(t).closest(s.el).length&&s.params.closeByBackdropClick&&s.backdropEl&&s.backdropEl===t&&s.close()}return h&&(f=e.$el.children(".dialog-backdrop"),0===f.length&&(f=A('<div class="dialog-backdrop"></div>'),e.$el.append(f))),p&&p.length>0&&(s.on("open",(()=>{m.find(".dialog-button").each(((e,t)=>{p[t].keyCodes&&(g=!0),A(e).on("click",v)})),!g||o.ios||o.android||o.cordova||o.capacitor||A(n).on("keydown",b)})),s.on("close",(()=>{m.find(".dialog-button").each((e=>{A(e).off("click",v)})),!g||o.ios||o.android||o.cordova||o.capacitor||A(n).off("keydown",b),g=!1}))),Fe(s,{app:e,$el:m,el:m[0],$backdropEl:f,backdropEl:f&&f[0],type:"dialog",setProgress:(t,a)=>(e.progressbar.set(m.find(".progressbar"),t,a),s),setText(e){let t=m.find(".dialog-text");return 0===t.length&&(t=A('<div class="dialog-text"></div>'),void 0!==i?t.insertAfter(m.find(".dialog-title")):m.find(".dialog-inner").prepend(t)),t.html(e),s.params.text=e,s},setTitle(e){let t=m.find(".dialog-title");return 0===t.length&&(t=A('<div class="dialog-title"></div>'),m.find(".dialog-inner").prepend(t)),t.html(e),s.params.title=e,s}}),s.on("opened",(()=>{s.params.closeByBackdropClick&&e.on("click",w)})),s.on("close",(()=>{s.params.closeByBackdropClick&&e.off("click",w)})),m[0].f7Modal=s,s.params.destroyOnClose&&s.once("closed",(()=>{setTimeout((()=>{s.destroy()}),0)})),s}};var Ja={name:"dialog",params:{dialog:{title:void 0,buttonOk:"OK",buttonCancel:"Cancel",usernamePlaceholder:"Username",passwordPlaceholder:"Password",preloaderTitle:"Loading... ",progressTitle:"Loading... ",backdrop:!0,closeByBackdropClick:!1,destroyPredefinedDialogs:!0,keyboardActions:!0,autoFocus:!0}},static:{Dialog:Qa},create(){const e=this;function t(){return e.params.dialog.title||e.name}const a=e.params.dialog.destroyPredefinedDialogs,r=e.params.dialog.keyboardActions,s=e.params.dialog.autoFocus?{on:{opened(e){e.$el.find("input").eq(0).focus()}}}:{},o="ios"===e.theme;e.dialog=Fe(it({app:e,constructor:Qa,defaultSelector:".dialog.modal-in"}),{alert(){for(var s=arguments.length,n=new Array(s),i=0;i<s;i++)n[i]=arguments[i];let[l,c,p]=n;return 2===n.length&&"function"==typeof n[1]&&([l,p,c]=n),new Qa(e,{title:void 0===c?t():c,text:l,buttons:[{text:e.params.dialog.buttonOk,strong:o,onClick:p,keyCodes:r?[13,27]:null}],destroyOnClose:a}).open()},prompt(){for(var n=arguments.length,i=new Array(n),l=0;l<n;l++)i[l]=arguments[l];let[c,p,d,u,h]=i;return"function"==typeof i[1]&&([c,d,u,h,p]=i),h=null==h?"":h,new Qa(e,{title:void 0===p?t():p,text:c,content:`<div class="dialog-input-field input"><input type="text" class="dialog-input" value="${h}"></div>`,buttons:[{text:e.params.dialog.buttonCancel,keyCodes:r?[27]:null,color:null},{text:e.params.dialog.buttonOk,strong:o,keyCodes:r?[13]:null}],onClick(e,t){const a=e.$el.find(".dialog-input").val();0===t&&u&&u(a),1===t&&d&&d(a)},destroyOnClose:a,...s}).open()},confirm(){for(var s=arguments.length,n=new Array(s),i=0;i<s;i++)n[i]=arguments[i];let[l,c,p,d]=n;return"function"==typeof n[1]&&([l,p,d,c]=n),new Qa(e,{title:void 0===c?t():c,text:l,buttons:[{text:e.params.dialog.buttonCancel,onClick:d,keyCodes:r?[27]:null,color:null},{text:e.params.dialog.buttonOk,strong:o,onClick:p,keyCodes:r?[13]:null}],destroyOnClose:a}).open()},login(){for(var n=arguments.length,i=new Array(n),l=0;l<n;l++)i[l]=arguments[l];let[c,p,d,u]=i;return"function"==typeof i[1]&&([c,d,u,p]=i),new Qa(e,{title:void 0===p?t():p,text:c,content:`\n              <div class="dialog-input-field dialog-input-double input">\n                <input type="text" name="dialog-username" placeholder="${e.params.dialog.usernamePlaceholder}" class="dialog-input">\n              </div>\n              <div class="dialog-input-field dialog-input-double input">\n                <input type="password" name="dialog-password" placeholder="${e.params.dialog.passwordPlaceholder}" class="dialog-input">\n              </div>`,buttons:[{text:e.params.dialog.buttonCancel,keyCodes:r?[27]:null,color:null},{text:e.params.dialog.buttonOk,strong:o,keyCodes:r?[13]:null}],onClick(e,t){const a=e.$el.find('[name="dialog-username"]').val(),r=e.$el.find('[name="dialog-password"]').val();0===t&&u&&u(a,r),1===t&&d&&d(a,r)},destroyOnClose:a,...s}).open()},password(){for(var n=arguments.length,i=new Array(n),l=0;l<n;l++)i[l]=arguments[l];let[c,p,d,u]=i;return"function"==typeof i[1]&&([c,d,u,p]=i),new Qa(e,{title:void 0===p?t():p,text:c,content:`\n              <div class="dialog-input-field input">\n                <input type="password" name="dialog-password" placeholder="${e.params.dialog.passwordPlaceholder}" class="dialog-input">\n              </div>`,buttons:[{text:e.params.dialog.buttonCancel,keyCodes:r?[27]:null,color:null},{text:e.params.dialog.buttonOk,strong:o,keyCodes:r?[13]:null}],onClick(e,t){const a=e.$el.find('[name="dialog-password"]').val();0===t&&u&&u(a),1===t&&d&&d(a)},destroyOnClose:a,...s}).open()},preloader(t,r){const s={iosPreloaderContent:Me,mdPreloaderContent:Pe}[`${e.theme}PreloaderContent`]||"";return new Qa(e,{title:null==t?e.params.dialog.preloaderTitle:t,content:`<div class="preloader${r?` color-${r}`:""}">${s}</div>`,cssClass:"dialog-preloader",destroyOnClose:a}).open()},progress(){for(var t=arguments.length,r=new Array(t),s=0;s<t;s++)r[s]=arguments[s];let[o,n,i]=r;2===r.length?"number"==typeof r[0]?[n,i,o]=r:"string"==typeof r[0]&&"string"==typeof r[1]&&([o,i,n]=r):1===r.length&&"number"==typeof r[0]&&([n,o,i]=r);const l=void 0===n,c=new Qa(e,{title:void 0===o?e.params.dialog.progressTitle:o,cssClass:"dialog-progress",content:`\n              <div class="progressbar${l?"-infinite":""}${i?` color-${i}`:""}">\n                ${l?"":"<span></span>"}\n              </div>\n            `,destroyOnClose:a});return l||c.setProgress(n),c.open()}})}};let Za=class extends Ua{constructor(e,t){const a=Fe({on:{}},e.params.popup,t);super(e,a);const s=this,n=o(),i=r(),l=tt(),c=rt();let p,d,u,h;if(s.params=a,p=s.params.el?A(s.params.el).eq(0):A(s.params.content).filter((e=>1===e.nodeType)).eq(0),p&&p.length>0&&p[0].f7Modal)return p[0].f7Modal;if(0===p.length)return s.destroy();function m(e){const t=e.target,a=A(t);if(!(!c.desktop&&c.cordova&&(n.Keyboard&&n.Keyboard.isVisible||n.cordova.plugins&&n.cordova.plugins.Keyboard&&n.cordova.plugins.Keyboard.isVisible))&&0===a.closest(s.el).length&&s.params&&s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===t){let e=!0;s.$el.nextAll(".popup.modal-in").each((t=>{const a=t.f7Modal;a&&a.params.closeByBackdropClick&&a.params.backdrop&&a.backdropEl===s.backdropEl&&(e=!1)})),e&&s.close()}}function f(e){27===e.keyCode&&s.params.closeOnEscape&&s.close()}function g(t){return(e.height-2*t)/e.height}s.params.backdrop&&s.params.backdropEl?d=A(s.params.backdropEl):s.params.backdrop&&(s.params.backdropUnique?(d=A('<div class="popup-backdrop popup-backdrop-unique"></div>'),s.$containerEl.append(d)):d=s.$containerEl.children(".popup-backdrop"),0===d.length&&(d=A('<div class="popup-backdrop"></div>'),s.$containerEl.append(d))),Fe(s,{app:e,push:p.hasClass("popup-push")||s.params.push,$el:p,el:p[0],$backdropEl:d,backdropEl:d&&d[0],type:"popup",$htmlEl:A("html")}),s.params.push&&p.addClass("popup-push");let v,b,w,y,C,E,k,$,x,T,S,P=!0,M=!1,O=!1;function I(e){!M&&P&&s.params.swipeToClose&&e.isTrusted&&(s.params.swipeHandler&&0===A(e.target).closest(s.params.swipeHandler).length||A(e.target).closest(".sortable-handler").length>0||(M=!0,O=!1,v={x:"touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,y:"touchstart"===e.type?e.targetTouches[0].pageY:e.pageY},y=Ae(),w=void 0,s.params.swipeHandler||"touchstart"!==e.type||(E=A(e.target).closest(".page-content")[0])))}function B(t){if(!M||!t.isTrusted)return;if(b={x:"touchmove"===t.type?t.targetTouches[0].pageX:t.pageX,y:"touchmove"===t.type?t.targetTouches[0].pageY:t.pageY},void 0===w&&(w=!!(w||Math.abs(b.x-v.x)>Math.abs(b.y-v.y))),w)return M=!1,void(O=!1);C=v.y-b.y,h&&u&&C>0&&(C=0);const a=C<0?"to-bottom":"to-top";if(p.transition(0),"string"==typeof s.params.swipeToClose&&a!==s.params.swipeToClose)return p.transform(""),void p.transition("");if(O)s.emit("local::swipeMove popupSwipeMove",s),s.$el.trigger("popup:swipemove");else{if(h&&u&&(T=p[0].offsetHeight,S=p.prevAll(".popup.modal-in").eq(0),0===S.length&&(S=e.$el.children(".view, .views"))),E&&(k=E.scrollTop,x=E.scrollHeight,$=E.offsetHeight,!(x===$||"to-bottom"===a&&0===k||"to-top"===a&&k===x-$)))return p.transform(""),p.transition(""),M=!1,void(O=!1);O=!0,s.emit("local::swipeStart popupSwipeStart",s),s.$el.trigger("popup:swipestart")}if(t.preventDefault(),h&&u){const e=1-Math.abs(C/T),t=1-(1-g(u))*e;S.hasClass("popup")?S.hasClass("popup-push")?S.transition(0).forEach((a=>{a.style.setProperty("transform",`translate3d(0, calc(-1 * ${e} * (var(--f7-popup-push-offset) + 10px)) , 0px) scale(${t})`,"important")})):S.transition(0).forEach((e=>{e.style.setProperty("transform",`translate3d(0, 0px , 0px) scale(${t})`,"important")})):S.transition(0).forEach((e=>{e.style.setProperty("transform",`translate3d(0,0,0) scale(${t})`,"important")}))}p.transition(0).transform(`translate3d(0,${-C}px,0)`)}function L(e){if(!e.isTrusted)return;if(M=!1,!O)return;s.emit("local::swipeEnd popupSwipeEnd",s),s.$el.trigger("popup:swipeend"),O=!1,P=!1,p.transition(""),h&&u&&S.transition("").transform("");const t=C<=0?"to-bottom":"to-top";if("string"==typeof s.params.swipeToClose&&t!==s.params.swipeToClose)return p.transform(""),void(P=!0);const a=Math.abs(C),r=(new Date).getTime()-y;r<300&&a>20||r>=300&&a>100?Le((()=>{"to-bottom"===t?p.addClass("swipe-close-to-bottom"):p.addClass("swipe-close-to-top"),p.transform(""),s.emit("local::swipeclose popupSwipeClose",s),s.$el.trigger("popup:swipeclose"),s.close(),P=!0})):(P=!0,p.transform(""))}const D=!!l.passiveListener&&{passive:!0};let R;s.params.swipeToClose&&(p.on(e.touchEvents.start,I,D),e.on("touchmove",B),e.on("touchend:passive",L),s.once("popupDestroy",(()=>{p.off(e.touchEvents.start,I,D),e.off("touchmove",B),e.off("touchend:passive",L)})));const H=()=>{const t=h;s.push&&(h=s.push&&(e.width<630||e.height<630||p.hasClass("popup-tablet-fullscreen"))),h&&!t?z():h&&t?s.$htmlEl[0].style.setProperty("--f7-popup-push-scale",g(u)):!h&&t&&(s.$htmlEl.removeClass("with-modal-popup-push"),s.$htmlEl[0].style.removeProperty("--f7-popup-push-scale"))},z=()=>{e.off("resize",H),s.push&&(h=s.push&&(e.width<630||e.height<630||p.hasClass("popup-tablet-fullscreen"))),h&&(u=parseInt(p.css("--f7-popup-push-offset"),10),Number.isNaN(u)&&(u=0),u||(u="ios"===e.theme?44:48),s.$htmlEl[0].style.setProperty("--f7-popup-push-offset",`${u}px`),p.addClass("popup-push"),s.$htmlEl.addClass("with-modal-popup-push"),s.$htmlEl[0].style.setProperty("--f7-popup-push-scale",g(u))),e.on("resize",H)};return s.on("open",(()=>{R=!1,s.params.closeOnEscape&&A(i).on("keydown",f),p.prevAll(".popup.modal-in").addClass("popup-behind"),z()})),s.on("opened",(()=>{p.removeClass("swipe-close-to-bottom swipe-close-to-top"),s.params.closeByBackdropClick&&e.on("click",m)})),s.on("close",(()=>{R=s.$el.prevAll(".popup-push.modal-in").length>0,s.params.closeOnEscape&&A(i).off("keydown",f),s.params.closeByBackdropClick&&e.off("click",m),p.prevAll(".popup.modal-in").eq(0).removeClass("popup-behind"),h&&u&&!R&&(s.$htmlEl.removeClass("with-modal-popup-push"),s.$htmlEl.addClass("with-modal-popup-push-closing")),e.off("resize",H)})),s.on("closed",(()=>{p.removeClass("popup-behind"),h&&u&&!R&&(s.$htmlEl.removeClass("with-modal-popup-push-closing"),s.$htmlEl[0].style.removeProperty("--f7-popup-push-scale"),s.$htmlEl[0].style.removeProperty("--f7-popup-push-offset"))})),p[0].f7Modal=s,s}};var er={name:"popup",params:{popup:{backdrop:!0,backdropEl:void 0,backdropUnique:!1,closeByBackdropClick:!0,closeOnEscape:!1,swipeToClose:!1,swipeHandler:null,push:!1,containerEl:null}},static:{Popup:Za},create(){this.popup=it({app:this,constructor:Za,defaultSelector:".popup.modal-in",parentSelector:".popup"})},clicks:{".popup-open":function(e,t){void 0===t&&(t={});this.popup.open(t.popup,t.animate,e)},".popup-close":function(e,t){void 0===t&&(t={});this.popup.close(t.popup,t.animate,e)}}};let tr=class extends Ua{constructor(e,t){const a=Fe({on:{}},t);super(e,a);const r=this;let s;return r.params=a,s=r.params.el?A(r.params.el).eq(0):A(r.params.content).filter((e=>1===e.nodeType)).eq(0),s&&s.length>0&&s[0].f7Modal?s[0].f7Modal:0===s.length?r.destroy():(Fe(r,{app:e,$el:s,el:s[0],type:"loginScreen"}),s[0].f7Modal=r,r)}};var ar={name:"loginScreen",static:{LoginScreen:tr},create(){this.loginScreen=it({app:this,constructor:tr,defaultSelector:".login-screen.modal-in"})},clicks:{".login-screen-open":function(e,t){void 0===t&&(t={});this.loginScreen.open(t.loginScreen,t.animate,e)},".login-screen-close":function(e,t){void 0===t&&(t={});this.loginScreen.close(t.loginScreen,t.animate,e)}}};let rr=class extends Ua{constructor(e,t){const a=Fe({on:{}},e.params.popover,t);super(e,a);const s=this,n=rt(),i=o(),l=r();let c;if(s.params=a,c=s.params.el?A(s.params.el).eq(0):A(s.params.content).filter((e=>1===e.nodeType)).eq(0),c&&c.length>0&&c[0].f7Modal)return c[0].f7Modal;const p=A(s.params.targetEl).eq(0);if(0===c.length)return s.destroy();let d;const u=s.params.backdrop&&e.$el.find(".popover.modal-in").filter((e=>e!==c[0])).length>0;let h;s.params.backdrop&&s.params.backdropEl?d=A(s.params.backdropEl):s.params.backdrop&&(s.params.backdropUnique||u?(d=A('<div class="popover-backdrop popover-backdrop-unique"></div>'),d[0].f7PopoverRef=s,s.$containerEl.append(d)):d=s.$containerEl.children(".popover-backdrop"),0===d.length&&(d=A('<div class="popover-backdrop"></div>'),s.$containerEl.append(d))),0===c.find(".popover-arrow").length&&s.params.arrow?(h=A('<div class="popover-arrow"></div>'),c.prepend(h)):h=c.find(".popover-arrow");const m=s.open;function f(){s.resize()}Fe(s,{app:e,$el:c,el:c[0],$targetEl:p,targetEl:p[0],$arrowEl:h,arrowEl:h[0],$backdropEl:d,backdropEl:d&&d[0],type:"popover",forceBackdropUnique:u,open(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];let[r,o]=t;return"boolean"==typeof t[0]&&([o,r]=t),r&&(s.$targetEl=A(r),s.targetEl=s.$targetEl[0]),m.call(s,o)}}),s.on("popoverOpen",(()=>{s.resize(),e.on("resize",f),A(i).on("keyboardDidShow keyboardDidHide",f),s.on("popoverClose popoverBeforeDestroy",(()=>{e.off("resize",f),A(i).off("keyboardDidShow keyboardDidHide",f)}))}));let g=null;function v(e){g=e.target}function b(e){const t=e.target,a=A(t);if(!(!n.desktop&&n.cordova&&(i.Keyboard&&i.Keyboard.isVisible||i.cordova.plugins&&i.cordova.plugins.Keyboard&&i.cordova.plugins.Keyboard.isVisible))&&0===a.closest(s.el).length)if(s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===t&&g===t)s.close();else if(s.params.closeByOutsideClick&&g===t){const e=a.hasClass("popover-backdrop-unique")&&t.f7PopoverRef!==s||a.hasClass("popover-backdrop")&&t!==s.backdropEl,r=t.closest(".popover")&&t.closest(".popover")!==s.$el[0];e||r||s.close()}}function w(e){27===e.keyCode&&s.params.closeOnEscape&&s.close()}return s.params.closeOnEscape&&(s.on("popoverOpen",(()=>{A(l).on("keydown",w)})),s.on("popoverClose",(()=>{A(l).off("keydown",w)}))),s.on("popoverOpened",(()=>{(s.params.closeByOutsideClick||s.params.closeByBackdropClick)&&(e.on("touchstart",v),e.on("click",b))})),s.on("popoverClose",(()=>{(s.params.closeByOutsideClick||s.params.closeByBackdropClick)&&(e.off("touchstart",v),e.off("click",b))})),c[0].f7Modal=s,s}resize(){const e=this,{app:t,$el:a,$targetEl:r,$arrowEl:s}=e,{targetX:o,targetY:n,verticalPosition:i}=e.params;a.css({left:"",top:""});const[l,c]=[a.width(),a.height()];let p,d,u=0;const h=s.length>0,m="ios"===t.theme?13:24;let f,g,v,b;h&&(s.removeClass("on-left on-right on-top on-bottom").css({left:"",top:""}),u=s.width()/2),a.removeClass("popover-on-left popover-on-right popover-on-top popover-on-bottom popover-on-middle").css({left:"",top:""});let w=parseInt(A("html").css("--f7-safe-area-top"),10),y=parseInt(A("html").css("--f7-safe-area-left"),10),C=parseInt(A("html").css("--f7-safe-area-right"),10);if(Number.isNaN(w)&&(w=0),Number.isNaN(y)&&(y=0),Number.isNaN(C)&&(C=0),r&&r.length>0){f=r.outerWidth(),g=r.outerHeight();const e=r.offset();v=e.left-t.left,b=e.top-t.top;const a=r.parents(".page");a.length>0&&(b-=a[0].scrollTop)}else void 0!==o&&"undefined"!==n&&(v=o,b=n,f=e.params.targetWidth||0,g=e.params.targetHeight||0);let[E,k,$]=[0,0,0];const x="auto"!==i&&i;let T,S=x||"top";"top"===x||!x&&c+u<b-w?k=b-c-u:"bottom"===x||!x&&c+u<t.height-b-g?(S="bottom",k=b+g+u):(S="middle",k=g/2+b-c/2,$=k,k=Math.max(5,Math.min(k,t.height-c-5)),$-=k),"top"===S||"bottom"===S?(E=f/2+v-l/2,$=E,E=Math.max(5,Math.min(E,t.width-l-5)),y&&(E=Math.max(E,y)),C&&E+l>t.width-5-C&&(E=t.width-5-C-l),$-=E,h&&("top"===S&&s.addClass("on-bottom"),"bottom"===S&&s.addClass("on-top"),p=l/2-u+$,p=Math.max(Math.min(p,l-2*u-m),m),s.css({left:`${p}px`}))):"middle"===S&&(E=v-l-u,h&&s.addClass("on-right"),(E<5||E+l+C>t.width||E<y)&&(E<5&&(E=v+f+u),E+l+C>t.width&&(E=t.width-l-5-C),E<y&&(E=y),h&&s.removeClass("on-right").addClass("on-left")),h&&(d=c/2-u+$,d=Math.max(Math.min(d,c-2*u-m),m),s.css({top:`${d}px`}))),T=v<t.width/2?"right":"left",a.addClass(`popover-on-${S} popover-on-${T}`),a.css({top:`${k}px`,left:`${E}px`})}};var sr={name:"popover",params:{popover:{verticalPosition:"auto",arrow:!0,backdrop:!0,backdropEl:void 0,backdropUnique:!1,closeByBackdropClick:!0,closeByOutsideClick:!0,closeOnEscape:!1,containerEl:null}},static:{Popover:rr},create(){const e=this;e.popover=Fe(it({app:e,constructor:rr,defaultSelector:".popover.modal-in"}),{open(t,a,r){let s=A(t);if(s.length>1){const e=A(a).parents(".page");e.length&&s.each((t=>{const a=A(t);a.parents(e)[0]===e[0]&&(s=a)}))}s.length>1&&(s=s.eq(s.length-1));let o=s[0].f7Modal;const n=s.dataset();return o||(o=new rr(e,Object.assign({el:s,targetEl:a},n))),o.open(a,r)}})},clicks:{".popover-open":function(e,t){void 0===t&&(t={});this.popover.open(t.popover,e,t.animate)},".popover-close":function(e,t){void 0===t&&(t={});this.popover.close(t.popover,t.animate,e)}}};let or=class extends Ua{constructor(e,t){const a=Fe({on:{}},e.params.actions,t);super(e,a);const s=this,n=rt(),i=o(),l=r();let c,p,d;if(s.params=a,s.params.buttons&&(c=s.params.buttons,Array.isArray(c[0])||(c=[c])),s.groups=c,s.params.el?p=A(s.params.el).eq(0):s.params.content?p=A(s.params.content).filter((e=>1===e.nodeType)).eq(0):s.params.buttons&&(s.params.convertToPopover&&(s.popoverHtml=s.renderPopover()),s.actionsHtml=s.render()),p&&p.length>0&&p[0].f7Modal)return p[0].f7Modal;if(p&&0===p.length&&!s.actionsHtml&&!s.popoverHtml)return s.destroy();s.params.backdrop&&s.params.backdropEl?d=A(s.params.backdropEl):s.params.backdrop&&(s.params.backdropUnique?(d=A('<div class="popup-backdrop popup-backdrop-unique"></div>'),s.$containerEl.append(d)):d=s.$containerEl.children(".actions-backdrop"),0===d.length&&(d=A('<div class="actions-backdrop"></div>'),s.$containerEl.append(d)));const u=s.open,h=s.close;let m;function f(e){const t=A(this);let a,r;if(t.hasClass("list-button")||t.hasClass("item-link")?(a=t.parents("li").index(),r=t.parents(".list").index()):(a=t.index(),r=t.parents(".actions-group").index()),void 0!==c){const t=c[r][a];t.onClick&&t.onClick(s,e),s.params.onClick&&s.params.onClick(s,e),!1!==t.close&&s.close()}}function g(e){const t=e.target,a=A(t);!n.desktop&&n.cordova&&(i.Keyboard&&i.Keyboard.isVisible||i.cordova.plugins&&i.cordova.plugins.Keyboard&&i.cordova.plugins.Keyboard.isVisible)||0===a.closest(s.el).length&&(s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===t||s.params.closeByOutsideClick)&&s.close()}function v(e){27===e.keyCode&&s.params.closeOnEscape&&s.close()}return s.open=function(t){let a=!1;const{targetEl:r,targetX:o,targetY:i,targetWidth:l,targetHeight:c}=s.params;return s.params.convertToPopover&&(r||void 0!==o&&void 0!==i)&&(s.params.forceToPopover||n.ios&&n.ipad||e.width>=768||n.desktop)&&(a=!0),a&&s.popoverHtml?(m=e.popover.create({containerEl:s.params.containerEl,content:s.popoverHtml,backdrop:s.params.backdrop,targetEl:r,targetX:o,targetY:i,targetWidth:l,targetHeight:c,on:{open(){s.$el||(s.$el=m.$el),s.$el.trigger(`modal:open ${s.type.toLowerCase()}:open`),s.emit(`local::open modalOpen ${s.type}Open`,s)},opened(){s.$el||(s.$el=m.$el),s.$el.trigger(`modal:opened ${s.type.toLowerCase()}:opened`),s.emit(`local::opened modalOpened ${s.type}Opened`,s)},close(){s.$el||(s.$el=m.$el),s.$el.trigger(`modal:close ${s.type.toLowerCase()}:close`),s.emit(`local::close modalClose ${s.type}Close`,s)},closed(){s.$el||(s.$el=m.$el),s.$el.trigger(`modal:closed ${s.type.toLowerCase()}:closed`),s.emit(`local::closed modalClosed ${s.type}Closed`,s)}}}),m.open(t),m.once("popoverOpened",(()=>{m.$el.find(".list-button, .item-link").each((e=>{A(e).on("click",f)}))})),m.once("popoverClosed",(()=>{m.$el.find(".list-button, .item-link").each((e=>{A(e).off("click",f)})),Le((()=>{m.destroy(),m=void 0}))}))):(s.$el=s.actionsHtml?A(s.actionsHtml):s.$el,s.$el[0].f7Modal=s,s.groups&&(s.$el.find(".actions-button").each((e=>{A(e).on("click",f)})),s.once("actionsClosed",(()=>{s.$el.find(".actions-button").each((e=>{A(e).off("click",f)}))}))),s.el=s.$el[0],u.call(s,t)),s},s.close=function(e){return m?m.close(e):h.call(s,e),s},Fe(s,{app:e,$el:p,el:p?p[0]:void 0,$backdropEl:d,backdropEl:d&&d[0],type:"actions"}),s.params.closeOnEscape&&(s.on("open",(()=>{A(l).on("keydown",v)})),s.on("close",(()=>{A(l).off("keydown",v)}))),s.on("opened",(()=>{(s.params.closeByBackdropClick||s.params.closeByOutsideClick)&&e.on("click",g)})),s.on("close",(()=>{(s.params.closeByBackdropClick||s.params.closeByOutsideClick)&&e.off("click",g)})),p&&(p[0].f7Modal=s),s}render(){const e=this;if(e.params.render)return e.params.render.call(e,e);const{groups:t}=e,a=e.params.cssClass;return ct("div",{class:`actions-modal${e.params.grid?" actions-grid":""} ${a||""}`},t.map((e=>ct("div",{class:"actions-group"},e.map((e=>{const t=["actions-"+(e.label?"label":"button")],{color:a,bg:r,strong:s,disabled:o,label:n,text:i,icon:l}=e;return a&&t.push(`color-${a}`),r&&t.push(`bg-color-${r}`),s&&t.push("actions-button-strong"),o&&t.push("disabled"),n?ct("div",{class:t.join(" ")},i):ct("div",{class:t.join(" ")},l&&ct("div",{class:"actions-button-media"},l),ct("div",{class:"actions-button-text"},i))}))))))}renderPopover(){const e=this;if(e.params.renderPopover)return e.params.renderPopover.call(e,e);const{groups:t}=e,a=e.params.cssClass;return ct("div",{class:`popover popover-from-actions ${a||""}`},ct("div",{class:"popover-inner"},t.map((e=>ct("div",{class:"list"},ct("ul",null,e.map((e=>{const t=[],{color:a,bg:r,strong:s,disabled:o,label:n,text:i,icon:l}=e;return a&&t.push(`color-${a}`),r&&t.push(`bg-color-${r}`),s&&t.push("popover-from-actions-strong"),o&&t.push("disabled"),n?(t.push("popover-from-actions-label"),`<li class="${t.join(" ")}">${i}</li>`):l?(t.push("item-link item-content"),ct("li",null,ct("a",{class:t.join(" ")},ct("div",{class:"item-media"},l),ct("div",{class:"item-inner"},ct("div",{class:"item-title"},i))))):(t.push("list-button"),ct("li",null,ct("a",{class:t.join(" ")},i)))}))))))))}};var nr={name:"actions",params:{actions:{convertToPopover:!0,forceToPopover:!1,backdrop:!0,backdropEl:void 0,backdropUnique:!1,cssClass:null,closeByBackdropClick:!0,closeOnEscape:!1,render:null,renderPopover:null,containerEl:null}},static:{Actions:or},create(){this.actions=it({app:this,constructor:or,defaultSelector:".actions-modal.modal-in"})},clicks:{".actions-open":function(e,t){void 0===t&&(t={});this.actions.open(t.actions,t.animate,e)},".actions-close":function(e,t){void 0===t&&(t={});this.actions.close(t.actions,t.animate,e)}}};let ir=class extends Ua{constructor(e,t){const a=Fe({on:{}},e.params.sheet,t);super(e,a);const s=this,n=o(),i=r(),l=tt(),c=rt();let p,d,u,h;if(s.params=a,void 0===s.params.backdrop&&(s.params.backdrop="ios"!==e.theme),p=s.params.el?A(s.params.el).eq(0):A(s.params.content).filter((e=>1===e.nodeType)).eq(0),p&&p.length>0&&p[0].f7Modal)return p[0].f7Modal;if(0===p.length)return s.destroy();function m(e){const t=e.target,a=A(t);!c.desktop&&c.cordova&&(n.Keyboard&&n.Keyboard.isVisible||n.cordova.plugins&&n.cordova.plugins.Keyboard&&n.cordova.plugins.Keyboard.isVisible)||0===a.closest(s.el).length&&(s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===t||s.params.closeByOutsideClick)&&s.close()}function f(e){27===e.keyCode&&s.params.closeOnEscape&&s.close()}function g(t){return(e.height-2*t)/e.height}s.params.backdrop&&s.params.backdropEl?d=A(s.params.backdropEl):s.params.backdrop&&(s.params.backdropUnique?(d=A('<div class="sheet-backdrop sheet-backdrop-unique"></div>'),s.$containerEl.append(d)):d=s.$containerEl.children(".sheet-backdrop"),0===d.length&&(d=A('<div class="sheet-backdrop"></div>'),s.$containerEl.append(d))),Fe(s,{app:e,push:p.hasClass("sheet-modal-push")||s.params.push,$el:p,el:p[0],$backdropEl:d,backdropEl:d&&d[0],type:"sheet",$htmlEl:A("html")}),s.params.push&&p.addClass("sheet-modal-push");const v=s.params.breakpoints&&s.params.breakpoints.length>0;let b,w,y,C,E,k,$,x,T,S,P,M,O,I,B,L,D,R,H,z=!1,N=!1,V=[],F=!0;function _(e){!z&&(s.params.swipeToClose||s.params.swipeToStep)&&e.isTrusted&&(s.params.swipeHandler&&0===A(e.target).closest(s.params.swipeHandler).length||A(e.target).closest(".sortable-handler").length>0||(z=!0,N=!1,b={x:"touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,y:"touchstart"===e.type?e.targetTouches[0].pageY:e.pageY},C=Ae(),y=void 0,k=p.hasClass("sheet-modal-top"),s.params.swipeHandler||"touchstart"!==e.type||(B=A(e.target).closest(".page-content")[0])))}function q(t){if(!z||!t.isTrusted)return;if(w={x:"touchmove"===t.type?t.targetTouches[0].pageX:t.pageX,y:"touchmove"===t.type?t.targetTouches[0].pageY:t.pageY},void 0===y&&(y=!!(y||Math.abs(w.x-b.x)>Math.abs(w.y-b.y))),y)return z=!1,void(N=!1);E=b.y-w.y;const a=E<0?"to-bottom":"to-top";if(!N){if(B&&!p.hasClass("modal-in-swipe-step")&&(L=B.scrollTop,D=B.scrollHeight,R=B.offsetHeight,!(D===R||"to-bottom"===a&&0===L||"to-top"===a&&L===D-R)))return p.transform(""),z=!1,void(N=!1);s.push&&h&&(O=e.$el.children(".view, .views")),S=p[0].offsetHeight,x=He(p[0],"y"),k?(P=s.params.swipeToClose?-S:-$,M=0):(P=0,M=s.params.swipeToClose?S:v?V[0]:$),N=!0}if(T=x-E,T=Math.min(Math.max(T,P),M),t.preventDefault(),v){let e=k?1+T/S:1-T/S;e=Math.abs(e),e=Math.min(Math.max(e,0),1),W(e),Y(e)}if(s.push&&h&&!v){let e=(T-x)/S;s.params.swipeToStep&&(e=k?T/$:1-($-T)/$),e=Math.abs(e),e=Math.min(Math.max(e,0),1);const t=1-e,a=1-(1-g(h))*t;O.transition(0).forEach((e=>{e.style.setProperty("transform",`translate3d(0,0,0) scale(${a})`,"important")})),s.params.swipeToStep&&O.css("border-radius",I*t+"px")}if(p.transition(0).transform(`translate3d(0,${T}px,0)`),s.params.swipeToStep){let e;e=k?1-T/$:($-T)/$,e=Math.min(Math.max(e,0),1),p.trigger("sheet:stepprogress",e),s.emit("local::stepProgress sheetStepProgress",s,e)}}function j(){if(z=!1,!N)return;N=!1,p.transform("").transition(""),s.push&&h&&(O.transition(""),v||(O.transform(""),O.css("border-radius","")));const e=E<0?"to-bottom":"to-top",a=Math.abs(E);if(0===a||T===x)return;const r=(new Date).getTime()-C;if(!s.params.swipeToStep&&!v){if(e!==(k?"to-top":"to-bottom"))return;return void((r<300&&a>20||r>=300&&a>S/2)&&s.close())}const o=k?"to-bottom":"to-top",n=k?"to-top":"to-bottom",i=Math.abs(T),l=Math.abs($);if(r<300&&a>10&&v)e===o&&void 0!==H&&(H===t.breakpoints.length-1?s.setBreakpoint(1):(H=Math.min(V.length-1,H+1),s.setBreakpoint(t.breakpoints[H]))),e===n&&(0===H?s.close():(H=void 0===H?t.breakpoints.length-1:Math.max(0,H-1),s.setBreakpoint(t.breakpoints[H])));else if(r<300&&a>10)return e===o&&i<l&&(p.removeClass("modal-in-swipe-step"),p.trigger("sheet:stepprogress",1),s.emit("local::stepProgress sheetStepProgress",s,1),s.emit("local::_swipeStep",!1),p.trigger("sheet:stepopen"),s.emit("local::stepOpen sheetStepOpen",s),s.push&&h&&(s.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",g(h)),O.css("border-radius",""))),e===n&&i>l&&(s.params.swipeToClose?s.close():(p.addClass("modal-in-swipe-step"),p.trigger("sheet:stepprogress",0),s.emit("local::stepProgress sheetStepProgress",s,0),s.emit("local::_swipeStep",!0),p.trigger("sheet:stepclose"),s.emit("local::stepClose sheetStepClose",s),s.push&&h&&(s.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),O.css("border-radius","0px")))),void(e===n&&i<=l&&(p.addClass("modal-in-swipe-step"),p.trigger("sheet:stepprogress",0),s.emit("local::stepProgress sheetStepProgress",s,0),s.emit("local::_swipeStep",!0),p.trigger("sheet:stepclose"),s.emit("local::stepClose sheetStepClose",s),s.push&&h&&(s.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),O.css("border-radius","0px"))));if(r>=300&&v){const e=[S,...V,0],a=e.reduce(((e,t)=>Math.abs(t-T)<Math.abs(e-T)?t:e)),r=e.indexOf(a);0===a?s.setBreakpoint(1):0===r?s.close():(H=r-1,s.setBreakpoint(t.breakpoints[H]))}else if(r>=300){const e=!p.hasClass("modal-in-swipe-step");e?e&&(i>l+(S-l)/2?s.params.swipeToClose&&s.close():i>l/2&&(p.addClass("modal-in-swipe-step"),p.trigger("sheet:stepprogress",0),s.emit("local::stepProgress sheetStepProgress",s,0),s.emit("local::_swipeStep",!0),p.trigger("sheet:stepclose"),s.emit("local::stepClose sheetStepClose",s),s.push&&h&&(s.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),O.css("border-radius","0px")))):i<l/2?(p.removeClass("modal-in-swipe-step"),p.trigger("sheet:stepprogress",1),s.emit("local::stepProgress sheetStepProgress",s,1),s.emit("local::_swipeStep",!1),p.trigger("sheet:stepopen"),s.emit("local::stepOpen sheetStepOpen",s),s.push&&h&&(s.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",g(h)),O.css("border-radius",""))):i-l>(S-l)/2&&s.params.swipeToClose&&s.close()}}const Y=e=>{const{pushBreakpoint:a}=t;if(null!=a&&s.push&&h)if(e>=a)s.$htmlEl.addClass("with-modal-sheet-push").removeClass("with-modal-sheet-push-closing"),O.transition("").forEach((e=>{e.style.setProperty("transform",`translate3d(0,0,0) scale(${g(h)})`,"important")})),O.css("border-radius",1*I+"px");else{const r=[0,...t.breakpoints,1],o=r[r.indexOf(a)-1];if(e<=o)O.transition("").css("transform",""),O.css("border-radius",""),s.$htmlEl.removeClass("with-modal-sheet-push"),e===o&&s.$htmlEl.addClass("with-modal-sheet-push-closing");else{const t=(e-o)/(a-o);s.$htmlEl.addClass("with-modal-sheet-push").removeClass("with-modal-sheet-push-closing"),O.transition(0).forEach((e=>{e.style.setProperty("transform",`translate3d(0,0,0) scale(${1-(1-g(h))*t})`,"important")})),O.css("border-radius",I*t+"px")}}},W=e=>{const{backdrop:a,backdropBreakpoint:r}=t;if(r&&a&&d.length)if(e>=r)F||d.transition("").css({opacity:"",pointerEvents:""}),F=!0;else{const a=[0,...t.breakpoints,1],s=a[a.indexOf(r)-1];if(e<=s)F&&d.transition("").css({opacity:0,pointerEvents:"none"}),F=!1;else{const t=(e-s)/(r-s);d.transition(0).css({opacity:t,pointerEvents:"auto"})}}};s.calcBreakpoints=()=>{if(!v)return;const e=p[0].offsetHeight,t=p.hasClass("sheet-modal-top");V=[],s.params.breakpoints.forEach((a=>{V.push((e-e*a)*(t?-1:1))}))},s.setBreakpoint=e=>{if(!v)return s;if(1===e)s.opened||s.open(),p.removeClass("modal-in-breakpoint"),H=void 0,W(e),Y(e),p.trigger("sheet:breakpoint",e),s.emit("local::breakpoint sheetBreakpoint",s,e);else if(0===e)p.trigger("sheet:breakpoint",e),s.emit("local::breakpoint sheetBreakpoint",s,e),s.close();else{const a=t.breakpoints.indexOf(e);if(a<0)return s;s.opened||s.open(),W(e),Y(e),p.trigger("sheet:breakpoint",e),s.emit("local::breakpoint sheetBreakpoint",s,e),H=a,p[0].style.setProperty("--f7-sheet-breakpoint",`${V[a]}px`),p.addClass("modal-in-breakpoint")}return s};function X(){v?(s.calcBreakpoints(),void 0!==H&&s.setBreakpoint(t.breakpoints[H])):s.setSwipeStep(!0)}s.setSwipeStep=function(e){void 0===e&&(e=!0);const t=p.find(".sheet-modal-swipe-step").eq(0);t.length&&($=p.hasClass("sheet-modal-top")?-(t.offset().top-p.offset().top+t[0].offsetHeight):p[0].offsetHeight-(t.offset().top-p.offset().top+t[0].offsetHeight),p[0].style.setProperty("--f7-sheet-swipe-step",`${$}px`),e||(p.addClass("modal-in-swipe-step"),s.emit("local::_swipeStep",!0)))};const U=!!l.passiveListener&&{passive:!0};return(s.params.swipeToClose||s.params.swipeToStep||v)&&(p.on(e.touchEvents.start,_,U),e.on("touchmove",q),e.on("touchend:passive",j),s.once("sheetDestroy",(()=>{p.off(e.touchEvents.start,_,U),e.off("touchmove",q),e.off("touchend:passive",j)}))),s.on("open",(()=>{s.params.closeOnEscape&&A(i).on("keydown",f),p.prevAll(".popup.modal-in").addClass("popup-behind"),e.on("resize",X),s.params.scrollToEl&&function(){const e=A(s.params.scrollToEl).eq(0);if(0===e.length)return;if(u=e.parents(".page-content"),0===u.length)return;const t=parseInt(u.css("padding-top"),10),a=parseInt(u.css("padding-bottom"),10),r=u[0].offsetHeight-t-p.height(),o=u[0].scrollHeight-t-p.height(),n=u.scrollTop();let i;const l=e.offset().top-t+e[0].offsetHeight;if(l>r){const e=n+l-r;e+r>o&&(i=e+r-o+a,r===o&&(i=p.height()),u.css({"padding-bottom":`${i}px`})),u.scrollTop(e,300)}}(),s.push&&(h=parseInt(p.css("--f7-sheet-push-offset"),10),Number.isNaN(h)&&(h=0),h||(h="ios"===e.theme?44:48),s.$htmlEl[0].style.setProperty("--f7-sheet-push-offset",`${h}px`),p.addClass("sheet-modal-push"),v||s.$htmlEl.addClass("with-modal-sheet-push"),s.params.swipeToStep||v?(O=e.$el.children(".view, .views"),I="ios"===e.theme?10:16,O.css("border-radius","0px")):s.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",g(h))),v?(s.calcBreakpoints(),s.setBreakpoint(t.breakpoints[0])):s.params.swipeToStep&&s.setSwipeStep(!1)})),s.on("opened",(()=>{(s.params.closeByOutsideClick||s.params.closeByBackdropClick)&&e.on("click",m)})),s.on("close",(()=>{H=void 0,(s.params.swipeToStep||v)&&(p.removeClass("modal-in-swipe-step modal-in-breakpoint"),s.emit("local::_swipeStep",!1)),e.off("resize",X),s.params.closeOnEscape&&A(i).off("keydown",f),s.params.scrollToEl&&u&&u.length>0&&u.css({"padding-bottom":""}),(s.params.closeByOutsideClick||s.params.closeByBackdropClick)&&e.off("click",m),p.prevAll(".popup.modal-in").eq(0).removeClass("popup-behind"),s.push&&h&&(s.$htmlEl.removeClass("with-modal-sheet-push"),s.$htmlEl.addClass("with-modal-sheet-push-closing"),O&&(O.transform(""),O.css("border-radius","")))})),s.on("closed",(()=>{s.push&&h&&(s.$htmlEl.removeClass("with-modal-sheet-push-closing"),s.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),s.$htmlEl[0].style.removeProperty("--f7-sheet-push-offset"))})),s.stepOpen=function(){p.removeClass("modal-in-swipe-step"),s.emit("local::_swipeStep",!1),s.push&&(h||(h=parseInt(p.css("--f7-sheet-push-offset"),10),Number.isNaN(h)&&(h=0)),h&&s.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",g(h)))},s.stepClose=function(){p.addClass("modal-in-swipe-step"),s.emit("local::_swipeStep",!0),s.push&&s.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale")},s.stepToggle=function(){p.toggleClass("modal-in-swipe-step"),s.emit("local::_swipeStep",p.hasClass("modal-in-swipe-step"))},p[0].f7Modal=s,s}};var lr={name:"sheet",params:{sheet:{push:!1,backdrop:void 0,backdropEl:void 0,backdropUnique:!1,closeByBackdropClick:!0,closeByOutsideClick:!1,closeOnEscape:!1,swipeToClose:!1,swipeToStep:!1,breakpoints:[],backdropBreakpoint:0,pushBreakpoint:0,swipeHandler:null,containerEl:null}},static:{Sheet:ir},create(){const e=this;e.sheet=Fe({},it({app:e,constructor:ir,defaultSelector:".sheet-modal.modal-in"}),{stepOpen(t){const a=e.sheet.get(t);if(a&&a.stepOpen)return a.stepOpen()},stepClose(t){const a=e.sheet.get(t);if(a&&a.stepClose)return a.stepClose()},stepToggle(t){const a=e.sheet.get(t);if(a&&a.stepToggle)return a.stepToggle()},setBreakpoint(t,a){const r=e.sheet.get(t);if(r&&r.setBreakpoint)return r.setBreakpoint(a)}})},clicks:{".sheet-open":function(e,t){void 0===t&&(t={});const a=this;A(".sheet-modal.modal-in").length>0&&t.sheet&&A(t.sheet)[0]!==A(".sheet-modal.modal-in")[0]&&a.sheet.close(".sheet-modal.modal-in"),a.sheet.open(t.sheet,t.animate,e)},".sheet-close":function(e,t){void 0===t&&(t={});this.sheet.close(t.sheet,t.animate,e)}}};let cr=class extends Ua{constructor(e,t){const a=Fe({on:{}},e.params.toast,t);super(e,a);const r=this,s=o();r.app=e,r.params=a;const{closeButton:n,closeTimeout:i}=r.params;let l,c;if(r.params.el)l=A(r.params.el);else{const e=r.render();l=A(e)}return l&&l.length>0&&l[0].f7Modal?l[0].f7Modal:0===l.length?r.destroy():(Fe(r,{$el:l,el:l[0],type:"toast"}),l[0].f7Modal=r,n&&(l.find(".toast-button").on("click",(()=>{r.emit("local::closeButtonClick toastCloseButtonClick",r),r.close()})),r.on("beforeDestroy",(()=>{l.find(".toast-button").off("click")}))),r.on("open",(()=>{A(".toast.modal-in").each((t=>{const a=e.toast.get(t);t!==r.el&&a&&a.close()})),i&&(c=Le((()=>{r.close()}),i))})),r.on("close",(()=>{s.clearTimeout(c)})),r.params.destroyOnClose&&r.once("closed",(()=>{setTimeout((()=>{r.destroy()}),0)})),r)}render(){const e=this;if(e.params.render)return e.params.render.call(e,e);const{position:t,horizontalPosition:a,cssClass:r,icon:s,text:o,closeButton:n,closeButtonColor:i,closeButtonText:l}=e.params;return ct("div",{class:`toast toast-${t} ${"top"===t||"bottom"===t?`toast-horizontal-${a}`:""} ${r||""} ${s?"toast-with-icon":""}`},ct("div",{class:"toast-content"},s&&ct("div",{class:"toast-icon"},s),ct("div",{class:"toast-text"},o),n&&!s&&ct("a",{class:"toast-button button "+(i?`color-${i}`:"")},l)))}};var pr={name:"toast",static:{Toast:cr},create(){const e=this;e.toast=Fe({},it({app:e,constructor:cr,defaultSelector:".toast.modal-in"}),{show:t=>(Fe(t,{destroyOnClose:!0}),new cr(e,t).open())})},params:{toast:{icon:null,text:null,position:"bottom",horizontalPosition:"left",closeButton:!1,closeButtonColor:null,closeButtonText:"Ok",closeTimeout:null,cssClass:null,render:null,containerEl:null}}};const dr={init(e){const t={iosPreloaderContent:Me,mdPreloaderContent:Pe},a=A(e);0===a.length||a.children(".preloader-inner").length>0||a.children(".preloader-inner-line").length>0||a.append(t[`${this.theme}PreloaderContent`])},visible:!1,show(e){void 0===e&&(e="white");if(dr.visible)return;const t={iosPreloaderContent:Me,mdPreloaderContent:Pe}[`${this.theme}PreloaderContent`]||"";A("html").addClass("with-modal-preloader"),this.$el.append(`\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-${e}">${t}</div>\n      </div>\n    `),dr.visible=!0},showIn(e,t){void 0===t&&(t="white");const a={iosPreloaderContent:Me,mdPreloaderContent:Pe}[`${this.theme}PreloaderContent`]||"";A(e||"html").addClass("with-modal-preloader"),A(e||this.$el).append(`\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-${t}">${a}</div>\n      </div>\n    `)},hide(){dr.visible&&(A("html").removeClass("with-modal-preloader"),this.$el.find(".preloader-backdrop, .preloader-modal").remove(),dr.visible=!1)},hideIn(e){A(e||"html").removeClass("with-modal-preloader"),A(e||this.$el).find(".preloader-backdrop, .preloader-modal").remove()}};var ur={name:"preloader",create(){Ke(this,{preloader:dr})},on:{photoBrowserOpen(e){const t=this;e.$el.find(".preloader").each((e=>{t.preloader.init(e)}))},tabMounted(e){const t=this;A(e).find(".preloader").each((e=>{t.preloader.init(e)}))},pageInit(e){const t=this;e.$el.find(".preloader").each((e=>{t.preloader.init(e)}))}},vnode:{preloader:{insert(e){const t=e.elm;this.preloader.init(t)}}}};const hr={set(){const e=this;for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];let[s,o,n]=a;if("number"==typeof a[0]&&([o,n]=a,s=e.$el),null==o)return s;o||(o=0);const i=A(s||e.$el);if(0===i.length)return s;const l=Math.min(Math.max(o,0),100);let c;if(c=i.hasClass("progressbar")?i.eq(0):i.children(".progressbar"),0===c.length||c.hasClass("progressbar-infinite"))return c;let p=c.children("span");return 0===p.length&&(p=A("<span></span>"),c.append(p)),p.transition(void 0!==n?n:"").transform(`translate3d(${(-100+l)*(e.rtl?-1:1)}%,0,0)`),c[0]},show(){const e=this;for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];let[s,o,n]=a,i="determined";2===a.length?"string"!=typeof a[0]&&"object"!=typeof a[0]||"string"!=typeof a[1]?"number"==typeof a[0]&&"string"==typeof a[1]&&([o,n]=a,s=e.$el):([s,n,o]=a,i="infinite"):1===a.length?"number"==typeof a[0]?(s=e.$el,o=a[0]):"string"==typeof a[0]&&(i="infinite",s=e.$el,n=a[0]):0===a.length&&(i="infinite",s=e.$el);const l=A(s);if(0===l.length)return;let c;return l.hasClass("progressbar")||l.hasClass("progressbar-infinite")?c=l:(c=l.children(".progressbar:not(.progressbar-out), .progressbar-infinite:not(.progressbar-out)"),0===c.length&&(c=A(`\n          <span class="progressbar${"infinite"===i?"-infinite":""}${n?` color-${n}`:""} progressbar-in">\n            ${"infinite"===i?"":"<span></span>"}\n          </span>`),l.append(c))),void 0!==o&&e.progressbar.set(c,o),c[0]},hide(e,t){void 0===t&&(t=!0);const a=A(e||this.$el);if(0===a.length)return;let r;return r=a.hasClass("progressbar")||a.hasClass("progressbar-infinite")?a:a.children(".progressbar, .progressbar-infinite"),0===r.length||!r.hasClass("progressbar-in")||r.hasClass("progressbar-out")||r.removeClass("progressbar-in").addClass("progressbar-out").animationEnd((()=>{t&&r.remove()})),r}};var mr={name:"progressbar",create(){Ke(this,{progressbar:hr})},on:{tabMounted(e){const t=this;A(e).find(".progressbar").each((e=>{const a=A(e);t.progressbar.set(a,a.attr("data-progress"))}))},pageInit(e){const t=this;e.$el.find(".progressbar").each((e=>{const a=A(e);t.progressbar.set(a,a.attr("data-progress"))}))}},vnode:{progressbar:{insert(e){const t=e.elm;this.progressbar.set(t,t.getAttribute("data-progress"))},update(e){const t=e.elm;this.progressbar.set(t,t.getAttribute("data-progress"))}}}};const fr={init(){const e=this,t=r();let a,s,o,n,i,l,c,p,d,u,h,m,f,g,v,b,w,y,C,E,k;function $(t,r){s=!1,a=!0,k=!1,o="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,i=A(t.target).closest("li").eq(0),f=i.index(),c=i.parents(".sortable");const n=i.parents(".list-group");n.length&&n.parents(c).length&&(c=n),l=c.children("ul").children("li:not(.disallow-sorting):not(.no-sorting)"),e.panel&&(e.panel.allowOpen=!1),e.swipeout&&(e.swipeout.allow=!1),r&&(i.addClass("sorting"),c.addClass("sortable-sorting"),k=!0)}const x=!!tt().passiveListener&&{passive:!1,capture:!1};A(t).on(e.touchEvents.start,".list.sortable .sortable-handler",$,x),e.on("touchmove:active",(function(t){if(!a||!i)return;const r="touchmove"===t.type?t.targetTouches[0].pageY:t.pageY;if(!s){g=i.parents(".page"),v=i.parents(".page-content");const e=parseInt(v.css("padding-top"),10),t=parseInt(v.css("padding-bottom"),10);E=v[0].scrollTop,w=g.offset().top+e,b=g.height()-e-t,i.addClass("sorting"),c.addClass("sortable-sorting"),y=i[0].offsetTop,d=i[0].offsetTop,u=i.parent().height()-y-i.height(),p=i[0].offsetHeight,C=i.offset().top}s=!0,t.preventDefault(),t.f7PreventSwipePanel=!0,n=r-o;const f=v[0].scrollTop-E,k=Math.min(Math.max(n+f,-d),u);i.transform(`translate3d(0,${k}px,0)`);const $=44;let x,T=!0;n+f+$<-d&&(T=!1),n+f-$>u&&(T=!1),m=void 0,h=void 0,T&&(C+n+p+$>w+b&&(x=C+n+p+$-(w+b)),C+n<w+$&&(x=C+n-w-$),x&&(v[0].scrollTop+=x)),l.each((t=>{const a=A(t);if(a[0]===i[0])return;const r=a[0].offsetTop,s=a.height(),o=y+k;let n;const l=a[0].f7Translate;o>=r-s/2&&i.index()<a.index()?(n=-p,a.transform(`translate3d(0, ${n}px,0)`),h=a,m=void 0):o<=r+s/2&&i.index()>a.index()?(n=p,a[0].f7Translate=n,a.transform(`translate3d(0, ${n}px,0)`),h=void 0,m||(m=a)):(n=void 0,a.transform("translate3d(0, 0%,0)")),l!==n&&(a.trigger("sortable:move"),e.emit("sortableMove",a[0],c[0])),a[0].f7Translate=n}))})),e.on("touchend:passive",(function(){if(!a||!s)return a&&!s&&(e.panel&&(e.panel.allowOpen=!0),e.swipeout&&(e.swipeout.allow=!0),k&&(i.removeClass("sorting"),c.removeClass("sortable-sorting"))),a=!1,void(s=!1);let t;e.panel&&(e.panel.allowOpen=!0),e.swipeout&&(e.swipeout.allow=!0),l.transform(""),i.removeClass("sorting"),c.removeClass("sortable-sorting"),h?t=h.index():m&&(t=m.index());let r=c.dataset().sortableMoveElements;if(void 0===r&&(r=e.params.sortable.moveElements),r&&(h&&i.insertAfter(h),m&&i.insertBefore(m)),(h||m)&&c.hasClass("virtual-list")){f=i[0].f7VirtualListIndex,void 0===f&&(f=i.attr("data-virtual-list-index")),m?(t=m[0].f7VirtualListIndex,void 0===t&&(t=m.attr("data-virtual-list-index"))):(t=h[0].f7VirtualListIndex,void 0===t&&(t=h.attr("data-virtual-list-index"))),t=null!==t?parseInt(t,10):void 0;const e=c[0].f7VirtualList;f&&(f=parseInt(f,10)),t&&(t=parseInt(t,10)),e&&e.moveItem(f,t)}void 0===t||Number.isNaN(t)||t===f||(i.trigger("sortable:sort",{from:f,to:t}),e.emit("sortableSort",i[0],{from:f,to:t,el:i[0]},c[0])),m=void 0,h=void 0,a=!1,s=!1})),A(t).on("taphold",".sortable-tap-hold",((e,t)=>{$(t,!0)}))},enable(e){void 0===e&&(e=".list.sortable");const t=A(e);0!==t.length&&(t.addClass("sortable-enabled"),t.trigger("sortable:enable"),this.emit("sortableEnable",t[0]))},disable(e){void 0===e&&(e=".list.sortable");const t=A(e);0!==t.length&&(t.removeClass("sortable-enabled"),t.trigger("sortable:disable"),this.emit("sortableDisable",t[0]))},toggle(e){void 0===e&&(e=".list.sortable");const t=this,a=A(e);0!==a.length&&(a.hasClass("sortable-enabled")?t.sortable.disable(a):t.sortable.enable(a))}};var gr={name:"sortable",params:{sortable:{moveElements:!0}},create(){Ke(this,{sortable:fr})},on:{init(){this.params.sortable&&this.sortable.init()}},clicks:{".sortable-enable":function(e,t){void 0===t&&(t={});this.sortable.enable(t.sortable)},".sortable-disable":function(e,t){void 0===t&&(t={});this.sortable.disable(t.sortable)},".sortable-toggle":function(e,t){void 0===t&&(t={});this.sortable.toggle(t.sortable)}}};const vr={init(){const e=this,t=r(),a={};let s,o,n,i,l,c,p,d,u,h,m,f,g,v,b,w,y,C,E,k,$;const x=!!tt().passiveListener&&{passive:!0};e.on("touchstart",(t=>{if(vr.el){const a=A(t.target);A(vr.el).is(a[0])||a.parents(".swipeout").is(vr.el)||a.hasClass("modal-in")||(a.attr("class")||"").indexOf("-backdrop")>0||a.hasClass("actions-modal")||a.parents(".actions-modal.modal-in, .dialog.modal-in").length>0||e.swipeout.close(vr.el)}})),A(t).on(e.touchEvents.start,"li.swipeout",(function(t){e.swipeout.allow&&(o=!1,s=!0,n=void 0,a.x="touchstart"===t.type?t.targetTouches[0].pageX:t.pageX,a.y="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,i=(new Date).getTime(),c=A(this))}),x),e.on("touchmove:active",(function(t){if(!s)return;const r="touchmove"===t.type?t.targetTouches[0].pageX:t.pageX,i="touchmove"===t.type?t.targetTouches[0].pageY:t.pageY;if(void 0===n&&(n=!!(n||Math.abs(i-a.y)>Math.abs(r-a.x))),n)return void(s=!1);if(!o){if(A(".list.sortable-opened").length>0)return;p=c.find(".swipeout-content"),d=c.find(".swipeout-actions-right"),u=c.find(".swipeout-actions-left"),h=null,m=null,b=null,w=null,E=null,C=null,u.length>0&&(h=u.outerWidth(),b=u.children("a"),C=u.find(".swipeout-overswipe")),d.length>0&&(m=d.outerWidth(),w=d.children("a"),E=d.find(".swipeout-overswipe")),g=c.hasClass("swipeout-opened"),g&&(v=c.find(".swipeout-actions-left.swipeout-actions-opened").length>0?"left":"right"),c.removeClass("swipeout-transitioning"),e.params.swipeout.noFollow||(c.find(".swipeout-actions-opened").removeClass("swipeout-actions-opened"),c.removeClass("swipeout-opened"))}if(o=!0,t.cancelable&&t.preventDefault(),l=r-a.x,f=l,g&&("right"===v?f-=m:f+=h),f>0&&0===u.length||f<0&&0===d.length){if(!g)return s=!1,o=!1,p.transform(""),w&&w.length>0&&w.transform(""),void(b&&b.length>0&&b.transform(""));f=0}let x,T;if(f<0?y="to-left":f>0?y="to-right":y||(y="to-left"),t.f7PreventSwipePanel=!0,e.params.swipeout.noFollow)return g?("right"===v&&l>0&&e.swipeout.close(c),"left"===v&&l<0&&e.swipeout.close(c)):(l<0&&d.length>0&&e.swipeout.open(c,"right"),l>0&&u.length>0&&e.swipeout.open(c,"left")),s=!1,void(o=!1);if(k=!1,$=!1,d.length>0){let t=f;if(T=t/m,t<-m){const a=t/-m;t=-m-(-t-m)**.8,f=t,E.length>0&&a>e.params.swipeout.overswipeRatio&&($=!0)}"to-left"!==y&&(T=0,t=0),w.each((a=>{const r=A(a);void 0===a.f7SwipeoutButtonOffset&&(r[0].f7SwipeoutButtonOffset=a.offsetLeft),x=a.f7SwipeoutButtonOffset,E.length>0&&r.hasClass("swipeout-overswipe")&&"to-left"===y&&(r.css({left:($?-x:0)+"px"}),$?(r.hasClass("swipeout-overswipe-active")||(c.trigger("swipeout:overswipeenter"),e.emit("swipeoutOverswipeEnter",c[0])),r.addClass("swipeout-overswipe-active")):(r.hasClass("swipeout-overswipe-active")&&(c.trigger("swipeout:overswipeexit"),e.emit("swipeoutOverswipeExit",c[0])),r.removeClass("swipeout-overswipe-active"))),r.transform(`translate3d(${t-x*(1+Math.max(T,-1))}px,0,0)`)}))}if(u.length>0){let t=f;if(T=t/h,t>h){const a=t/m;t=h+(t-h)**.8,f=t,C.length>0&&a>e.params.swipeout.overswipeRatio&&(k=!0)}"to-right"!==y&&(t=0,T=0),b.each(((a,r)=>{const s=A(a);void 0===a.f7SwipeoutButtonOffset&&(s[0].f7SwipeoutButtonOffset=h-a.offsetLeft-a.offsetWidth),x=a.f7SwipeoutButtonOffset,C.length>0&&s.hasClass("swipeout-overswipe")&&"to-right"===y&&(s.css({left:`${k?x:0}px`}),k?(s.hasClass("swipeout-overswipe-active")||(c.trigger("swipeout:overswipeenter"),e.emit("swipeoutOverswipeEnter",c[0])),s.addClass("swipeout-overswipe-active")):(s.hasClass("swipeout-overswipe-active")&&(c.trigger("swipeout:overswipeexit"),e.emit("swipeoutOverswipeExit",c[0])),s.removeClass("swipeout-overswipe-active"))),b.length>1&&s.css("z-index",b.length-r),s.transform(`translate3d(${t+x*(1-Math.min(T,1))}px,0,0)`)}))}c.trigger("swipeout",T),e.emit("swipeout",c[0],T),p.transform(`translate3d(${f}px,0,0)`)})),e.on("touchend:passive",(function(){if(!s||!o)return s=!1,void(o=!1);s=!1,o=!1;const t=(new Date).getTime()-i,a="to-left"===y?d:u,r="to-left"===y?m:h;let n,v,C,E;if(n=t<300&&(l<-10&&"to-left"===y||l>10&&"to-right"===y)||t>=300&&Math.abs(f)>r/2?"open":"close",t<300&&(0===Math.abs(f)&&(n="close"),Math.abs(f)===r&&(n="open")),"open"===n){vr.el=c[0],c.trigger("swipeout:open"),e.emit("swipeoutOpen",c[0]),c.addClass("swipeout-opened swipeout-transitioning");const t="to-left"===y?-r:r;if(p.transform(`translate3d(${t}px,0,0)`),a.addClass("swipeout-actions-opened"),v="to-left"===y?w:b,v)for(C=0;C<v.length;C+=1)A(v[C]).transform(`translate3d(${t}px,0,0)`);$&&d.find(".swipeout-overswipe").trigger("click","f7Overswipe"),k&&u.find(".swipeout-overswipe").trigger("click","f7Overswipe")}else c.trigger("swipeout:close"),e.emit("swipeoutClose",c[0]),vr.el=void 0,c.addClass("swipeout-transitioning").removeClass("swipeout-opened"),p.transform(""),a.removeClass("swipeout-actions-opened");b&&b.length>0&&b!==v&&b.each((e=>{const t=A(e);E=e.f7SwipeoutButtonOffset,void 0===E&&(t[0].f7SwipeoutButtonOffset=h-e.offsetLeft-e.offsetWidth),t.transform(`translate3d(${E}px,0,0)`)})),w&&w.length>0&&w!==v&&w.each((e=>{const t=A(e);E=e.f7SwipeoutButtonOffset,void 0===E&&(t[0].f7SwipeoutButtonOffset=e.offsetLeft),t.transform(`translate3d(${-E}px,0,0)`)})),p.transitionEnd((()=>{g&&"open"===n||!g&&"close"===n||(c.trigger("open"===n?"swipeout:opened":"swipeout:closed"),e.emit("open"===n?"swipeoutOpened":"swipeoutClosed",c[0]),c.removeClass("swipeout-transitioning"),g&&"close"===n&&(d.length>0&&w.transform(""),u.length>0&&b.transform("")))}))}))},allow:!0,el:void 0,open(){const e=this;for(var t=arguments.length,a=new Array(t),r=0;r<t;r++)a[r]=arguments[r];let[s,o,n]=a;"function"==typeof a[1]&&([s,n,o]=a);const i=A(s).eq(0);if(0===i.length)return;if(!i.hasClass("swipeout")||i.hasClass("swipeout-opened"))return;o||(o=i.find(".swipeout-actions-right").length>0?"right":"left");const l=i.find(`.swipeout-actions-${o}`),c=i.find(".swipeout-content");if(0===l.length)return;i.trigger("swipeout:open").addClass("swipeout-opened").removeClass("swipeout-transitioning"),e.emit("swipeoutOpen",i[0]),l.addClass("swipeout-actions-opened");const p=l.children("a"),d=l.outerWidth(),u="right"===o?-d:d;p.length>1&&p.each(((e,t)=>{const a=A(e);"right"===o?a.transform(`translate3d(${-e.offsetLeft}px,0,0)`):a.css("z-index",p.length-t).transform(`translate3d(${d-e.offsetWidth-e.offsetLeft}px,0,0)`)})),i.addClass("swipeout-transitioning"),c.transitionEnd((()=>{i.trigger("swipeout:opened"),e.emit("swipeoutOpened",i[0]),n&&n.call(i[0])})),De((()=>{p.transform(`translate3d(${u}px,0,0)`),c.transform(`translate3d(${u}px,0,0)`)})),vr.el=i[0]},close(e,t){const a=this,r=A(e).eq(0);if(0===r.length)return;if(!r.hasClass("swipeout-opened"))return;const s=r.find(".swipeout-actions-opened").hasClass("swipeout-actions-right")?"right":"left",o=r.find(".swipeout-actions-opened").removeClass("swipeout-actions-opened"),n=o.children("a"),i=o.outerWidth();let l;function c(){a.swipeout.allow=!0,r.hasClass("swipeout-opened")||(r.removeClass("swipeout-transitioning"),n.transform(""),r.trigger("swipeout:closed"),a.emit("swipeoutClosed",r[0]),t&&t.call(r[0]),l&&clearTimeout(l))}a.swipeout.allow=!1,r.trigger("swipeout:close"),a.emit("swipeoutClose",r[0]),r.removeClass("swipeout-opened").addClass("swipeout-transitioning"),r.find(".swipeout-content").transform("").transitionEnd(c),l=setTimeout(c,500),n.each((e=>{const t=A(e);"right"===s?t.transform(`translate3d(${-e.offsetLeft}px,0,0)`):t.transform(`translate3d(${i-e.offsetWidth-e.offsetLeft}px,0,0)`),t.css({left:"0px"}).removeClass("swipeout-overswipe-active")})),vr.el&&vr.el===r[0]&&(vr.el=void 0)},delete(e,t){const a=this,r=A(e).eq(0);0!==r.length&&(vr.el=void 0,r.trigger("swipeout:delete"),a.emit("swipeoutDelete",r[0]),r.css({height:`${r.outerHeight()}px`}),r.transitionEnd((()=>{if(r.trigger("swipeout:deleted"),a.emit("swipeoutDeleted",r[0]),t&&t.call(r[0]),r.parents(".virtual-list").length>0){const e=r.parents(".virtual-list")[0].f7VirtualList,t=r[0].f7VirtualListIndex;e&&void 0!==t&&e.deleteItem(t)}else a.params.swipeout.removeElements?a.params.swipeout.removeElementsWithTimeout?setTimeout((()=>{r.remove()}),a.params.swipeout.removeElementsTimeout):r.remove():r.removeClass("swipeout-deleting swipeout-transitioning")})),De((()=>{r.addClass("swipeout-deleting swipeout-transitioning").css({height:"0px"}).find(".swipeout-content").transform("translate3d(-100%,0,0)")})))}};var br={name:"swipeout",params:{swipeout:{actionsNoFold:!1,noFollow:!1,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0,overswipeRatio:1.2}},create(){Ke(this,{swipeout:vr})},clicks:{".swipeout-open":function(e,t){void 0===t&&(t={});this.swipeout.open(t.swipeout,t.side)},".swipeout-close":function(e){const t=e.closest(".swipeout");0!==t.length&&this.swipeout.close(t)},".swipeout-delete":function(e,t){void 0===t&&(t={});const a=this,r=e.closest(".swipeout");if(0===r.length)return;const{confirm:s,confirmTitle:o}=t;t.confirm?a.dialog.confirm(s,o,(()=>{a.swipeout.delete(r)})):a.swipeout.delete(r)}},on:{init(){this.params.swipeout&&this.swipeout.init()}}};const wr={toggleClicked(e){let t=e.closest(".accordion-item").eq(0);t.length||(t=e.parents("li").eq(0));const a=e.parents(".accordion-item-content").eq(0);a.length&&a.parents(t).length||e.parents("li").length>1&&e.parents("li")[0]!==t[0]||this.accordion.toggle(t)},open(e){const t=this,a=A(e);let r=!1;function s(){r=!0}if(a.trigger("accordion:beforeopen",{prevent:s},s),t.emit("accordionBeforeOpen",a[0],s),r)return;const o=a.parents(".accordion-list").eq(0);let n=a.children(".accordion-item-content");if(n.removeAttr("aria-hidden"),0===n.length&&(n=a.find(".accordion-item-content")),0===n.length)return;const i=o.length>0&&a.parent().children(".accordion-item-opened");i.length>0&&t.accordion.close(i),n.transitionEnd((()=>{a.hasClass("accordion-item-opened")?(n.transition(0),n.css("height","auto"),De((()=>{n.transition(""),a.trigger("accordion:opened"),t.emit("accordionOpened",a[0])}))):(n.css("height",""),a.trigger("accordion:closed"),t.emit("accordionClosed",a[0]))})),n.css("height",`${n[0].scrollHeight}px`),a.trigger("accordion:open"),a.addClass("accordion-item-opened"),t.emit("accordionOpen",a[0])},close(e){const t=this,a=A(e);let r=!1;function s(){r=!0}if(a.trigger("accordion:beforeclose",{prevent:s},s),t.emit("accordionBeforeClose",a[0],s),r)return;let o=a.children(".accordion-item-content");0===o.length&&(o=a.find(".accordion-item-content")),a.removeClass("accordion-item-opened"),o.attr("aria-hidden",!0),o.transition(0),o.css("height",`${o[0].scrollHeight}px`),o.transitionEnd((()=>{a.hasClass("accordion-item-opened")?(o.transition(0),o.css("height","auto"),De((()=>{o.transition(""),a.trigger("accordion:opened"),t.emit("accordionOpened",a[0])}))):(o.css("height",""),a.trigger("accordion:closed"),t.emit("accordionClosed",a[0]))})),De((()=>{o.transition(""),o.css("height",""),a.trigger("accordion:close"),t.emit("accordionClose",a[0])}))},toggle(e){const t=A(e);0!==t.length&&(t.hasClass("accordion-item-opened")?this.accordion.close(e):this.accordion.open(e))}};var yr={name:"accordion",create(){Ke(this,{accordion:wr})},clicks:{".accordion-item .item-link, .accordion-item-toggle, .links-list.accordion-list > ul > li > a":function(e){wr.toggleClicked.call(this,e)}}};let Cr=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,s=rt(),o=r();let n;"md"===e.theme?n=48:"ios"===e.theme&&(n=44);const i={cols:1,height:n,cache:!0,dynamicHeightBufferSize:1,showFilteredItemsOnly:!1,renderExternal:void 0,setListHeight:!0,searchByItem:void 0,searchAll:void 0,ul:null,createUl:!0,scrollableParentEl:void 0,renderItem:e=>`\n          <li>\n            <div class="item-content">\n              <div class="item-inner">\n                <div class="item-title">${e}</div>\n              </div>\n            </div>\n          </li>\n        `.trim(),on:{}};if(a.useModulesParams(i),a.params=Fe(i,t),void 0!==a.params.height&&a.params.height||(a.params.height=n),a.$el=A(t.el),a.el=a.$el[0],0===a.$el.length)return;a.$el[0].f7VirtualList=a,a.items=a.params.items,a.params.showFilteredItemsOnly&&(a.filteredItems=[]),a.params.renderItem&&(a.renderItem=a.params.renderItem),a.$pageContentEl=a.$el.parents(".page-content"),a.pageContentEl=a.$pageContentEl[0],a.$scrollableParentEl=a.params.scrollableParentEl?A(a.params.scrollableParentEl).eq(0):a.$pageContentEl,!a.$scrollableParentEl.length&&a.$pageContentEl.length&&(a.$scrollableParentEl=a.$pageContentEl),a.scrollableParentEl=a.$scrollableParentEl[0],void 0!==a.params.updatableScroll?a.updatableScroll=a.params.updatableScroll:(a.updatableScroll=!0,s.ios&&s.osVersion.split(".")[0]<8&&(a.updatableScroll=!1));const l=a.params.ul;let c;a.$ul=l?A(a.params.ul):a.$el.children("ul"),0===a.$ul.length&&a.params.createUl&&(a.$el.append("<ul></ul>"),a.$ul=a.$el.children("ul")),a.ul=a.$ul[0],c=a.ul||a.params.createUl?a.$ul:a.$el,Fe(a,{$itemsWrapEl:c,itemsWrapEl:c[0],domCache:{},tempDomElement:o.createElement("ul"),lastRepaintY:null,fragment:o.createDocumentFragment(),pageHeight:void 0,rowsPerScreen:void 0,rowsBefore:void 0,rowsAfter:void 0,rowsToRender:void 0,maxBufferHeight:0,listHeight:void 0,dynamicHeight:"function"==typeof a.params.height,autoHeight:"auto"===a.params.height}),a.useModules();const p=a.handleScroll.bind(a),d=a.handleResize.bind(a);let u,h,m,f;return a.attachEvents=function(){u=a.$el.parents(".page").eq(0),h=a.$el.parents(".tab").filter((e=>0===A(e).parent(".tabs").parent(".tabs-animated-wrap, swiper-container.tabs").length)).eq(0),m=a.$el.parents(".panel").eq(0),f=a.$el.parents(".popup").eq(0),a.$scrollableParentEl.on("scroll",p),u.length&&u.on("page:reinit",d),h.length&&h.on("tab:show",d),m.length&&m.on("panel:open",d),f.length&&f.on("popup:open",d),e.on("resize",d)},a.detachEvents=function(){a.$scrollableParentEl.off("scroll",p),u.length&&u.off("page:reinit",d),h.length&&h.off("tab:show",d),m.length&&m.off("panel:open",d),f.length&&f.off("popup:open",d),e.off("resize",d)},a.init(),a}setListSize(e){const t=this,a=t.filteredItems||t.items;if(e||(t.pageHeight=t.$scrollableParentEl[0].offsetHeight),t.dynamicHeight){t.listHeight=0,t.heights=[];for(let e=0;e<a.length;e+=1){const r=t.params.height(a[e]);t.listHeight+=r,t.heights.push(r)}}else if(t.autoHeight){t.listHeight=0,t.heights||(t.heights=[]),t.heightsCalculated||(t.heightsCalculated=[]);const e={};t.$itemsWrapEl.find("[data-virtual-list-index]").forEach((t=>{e[parseInt(t.getAttribute("data-virtual-list-index"),10)]=t}));for(let r=0;r<a.length;r+=1){const s=t.items.indexOf(a[r]),o=e[s];o&&(t.heightsCalculated.includes(s)||(t.heights[s]=o.offsetHeight,t.heightsCalculated.push(s))),void 0===t.heights[r]&&(t.heights[s]=40),t.listHeight+=t.heights[s]}}else t.listHeight=Math.ceil(a.length/t.params.cols)*t.params.height,t.rowsPerScreen=Math.ceil(t.pageHeight/t.params.height),t.rowsBefore=t.params.rowsBefore||2*t.rowsPerScreen,t.rowsAfter=t.params.rowsAfter||t.rowsPerScreen,t.rowsToRender=t.rowsPerScreen+t.rowsBefore+t.rowsAfter,t.maxBufferHeight=t.rowsBefore/2*t.params.height;(t.updatableScroll||t.params.setListHeight)&&t.$itemsWrapEl.css({height:`${t.listHeight}px`})}render(e,t){const a=this;e&&(a.lastRepaintY=null);let r=-(a.$el[0].getBoundingClientRect().top-a.$scrollableParentEl[0].getBoundingClientRect().top);if(void 0!==t&&(r=t),!(null===a.lastRepaintY||Math.abs(r-a.lastRepaintY)>a.maxBufferHeight||!a.updatableScroll&&a.$scrollableParentEl[0].scrollTop+a.pageHeight>=a.$scrollableParentEl[0].scrollHeight))return;a.lastRepaintY=r;const s=a.filteredItems||a.items;let o,n,i,l=0,c=0;if(a.dynamicHeight||a.autoHeight){let e,t=0;a.maxBufferHeight=a.pageHeight;for(let s=0;s<a.heights.length;s+=1)e=a.heights[s],void 0===o&&(t+e>=r-2*a.pageHeight*a.params.dynamicHeightBufferSize?o=s:l+=e),void 0===n&&((t+e>=r+2*a.pageHeight*a.params.dynamicHeightBufferSize||s===a.heights.length-1)&&(n=s+1),c+=e),t+=e;n=Math.min(n,s.length)}else o=(parseInt(r/a.params.height,10)-a.rowsBefore)*a.params.cols,o<0&&(o=0),n=Math.min(o+a.rowsToRender*a.params.cols,s.length);const p=[];let d;for(a.reachEnd=!1,d=o;d<n;d+=1){let e;const t=a.items.indexOf(s[d]);d===o&&(a.currentFromIndex=t),d===n-1&&(a.currentToIndex=t),a.filteredItems?a.items[t]===a.filteredItems[a.filteredItems.length-1]&&(a.reachEnd=!0):t===a.items.length-1&&(a.reachEnd=!0),a.params.renderExternal?p.push(s[d]):a.domCache[t]?(e=a.domCache[t],e.f7VirtualListIndex=t):(a.renderItem?a.tempDomElement.innerHTML=a.renderItem(s[d],t).trim():a.tempDomElement.innerHTML=s[d].toString().trim(),e=a.tempDomElement.childNodes[0],a.params.cache&&(a.domCache[t]=e),e.f7VirtualListIndex=t),d===o&&(i=a.dynamicHeight||a.autoHeight?l:d*a.params.height/a.params.cols),a.params.renderExternal||(e.style.top=`${i}px`,a.emit("local::itemBeforeInsert vlItemBeforeInsert",a,e,s[d]),a.fragment.appendChild(e))}a.updatableScroll||(a.dynamicHeight||a.autoHeight?a.itemsWrapEl.style.height=`${c}px`:a.itemsWrapEl.style.height=d*a.params.height/a.params.cols+"px"),a.params.renderExternal?s&&0===s.length&&(a.reachEnd=!0):(a.emit("local::beforeClear vlBeforeClear",a,a.fragment),a.itemsWrapEl.innerHTML="",a.emit("local::itemsBeforeInsert vlItemsBeforeInsert",a,a.fragment),s&&0===s.length?(a.reachEnd=!0,a.params.emptyTemplate&&(a.itemsWrapEl.innerHTML=a.params.emptyTemplate)):a.itemsWrapEl.appendChild(a.fragment),a.emit("local::itemsAfterInsert vlItemsAfterInsert",a,a.fragment)),void 0!==t&&e&&a.$scrollableParentEl.scrollTop(t,0),a.params.renderExternal&&a.params.renderExternal(a,{fromIndex:o,toIndex:n,listHeight:a.listHeight,topPosition:i,items:p}),a.autoHeight&&requestAnimationFrame((()=>{a.setListSize(!0)}))}filterItems(e,t){void 0===t&&(t=!0);const a=this;a.filteredItems=[];for(let t=0;t<e.length;t+=1)a.filteredItems.push(a.items[e[t]]);t&&(a.$scrollableParentEl[0].scrollTop=0),a.update()}resetFilter(){const e=this;e.params.showFilteredItemsOnly?e.filteredItems=[]:(e.filteredItems=null,delete e.filteredItems),e.update()}scrollToItem(e){const t=this;if(e>t.items.length)return!1;let a=0;if(t.dynamicHeight||t.autoHeight)for(let r=0;r<e;r+=1)a+=t.heights[r];else a=e*t.params.height;const r=t.$el[0].offsetTop;return t.render(!0,r+a-parseInt(t.$scrollableParentEl.css("padding-top"),10)),!0}handleScroll(){this.render()}isVisible(){const e=this;return!!(e.el.offsetWidth||e.el.offsetHeight||e.el.getClientRects().length)}handleResize(){const e=this;e.isVisible()&&(e.heightsCalculated=[],e.setListSize(),e.render(!0))}appendItems(e){const t=this;for(let a=0;a<e.length;a+=1)t.items.push(e[a]);t.update()}appendItem(e){this.appendItems([e])}replaceAllItems(e){const t=this;t.items=e,delete t.filteredItems,t.domCache={},t.update()}replaceItem(e,t){const a=this;a.items[e]=t,a.params.cache&&delete a.domCache[e],a.update()}prependItems(e){const t=this;for(let a=e.length-1;a>=0;a-=1)t.items.unshift(e[a]);if(t.params.cache){const a={};Object.keys(t.domCache).forEach((r=>{a[parseInt(r,10)+e.length]=t.domCache[r]})),t.domCache=a}t.update()}prependItem(e){this.prependItems([e])}moveItem(e,t){const a=this,r=e;let s=t;if(r===s)return;const o=a.items.splice(r,1)[0];if(s>=a.items.length?(a.items.push(o),s=a.items.length-1):a.items.splice(s,0,o),a.params.cache){const e={};Object.keys(a.domCache).forEach((t=>{const o=parseInt(t,10),n=r<s?r:s,i=r<s?s:r,l=r<s?-1:1;(o<n||o>i)&&(e[o]=a.domCache[o]),o===n&&(e[i]=a.domCache[o]),o>n&&o<=i&&(e[o+l]=a.domCache[o])})),a.domCache=e}a.update()}insertItemBefore(e,t){const a=this;if(0!==e)if(e>=a.items.length)a.appendItem(t);else{if(a.items.splice(e,0,t),a.params.cache){const t={};Object.keys(a.domCache).forEach((r=>{const s=parseInt(r,10);s>=e&&(t[s+1]=a.domCache[s])})),a.domCache=t}a.update()}else a.prependItem(t)}deleteItems(e){const t=this;let a,r=0;for(let s=0;s<e.length;s+=1){let o=e[s];void 0!==a&&o>a&&(r=-s),o+=r,a=e[s];const n=t.items.splice(o,1)[0];if(t.filteredItems&&t.filteredItems.indexOf(n)>=0&&t.filteredItems.splice(t.filteredItems.indexOf(n),1),t.params.cache){const e={};Object.keys(t.domCache).forEach((a=>{const r=parseInt(a,10);r===o?delete t.domCache[o]:parseInt(a,10)>o?e[r-1]=t.domCache[a]:e[r]=t.domCache[a]})),t.domCache=e}}t.update()}deleteAllItems(){const e=this;e.items=[],delete e.filteredItems,e.params.cache&&(e.domCache={}),e.update()}deleteItem(e){this.deleteItems([e])}clearCache(){this.domCache={}}update(e){const t=this;e&&t.params.cache&&(t.domCache={}),t.heightsCalculated=[],t.setListSize(),t.render(!0)}init(){const e=this;e.attachEvents(),e.setListSize(),e.render()}destroy(){let e=this;e.detachEvents(),e.$el[0].f7VirtualList=null,delete e.$el[0].f7VirtualList,Ie(e),e=null}};var Er={name:"virtualList",static:{VirtualList:Cr},create(){this.virtualList=nt({defaultSelector:".virtual-list",constructor:Cr,app:this,domProp:"f7VirtualList"})}};let kr=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r={el:null,listEl:null,indexes:"auto",iosItemHeight:14,mdItemHeight:14,scrollList:!0,label:!1,renderItem:(e,t)=>`\n          <li>${e}</li>\n        `.trim(),renderSkipPlaceholder:()=>'<li class="list-index-skip-placeholder"></li>',on:{}};let s,o,n,i;if(a.useModulesParams(r),a.params=Fe(r,t),!a.params.el)return a;if(s=A(a.params.el),s[0].f7ListIndex)return s[0].f7ListIndex;if(i=s.find("ul"),0===i.length&&(i=A("<ul></ul>"),s.append(i)),a.params.listEl&&(o=A(a.params.listEl)),"auto"===a.params.indexes&&!o)return a;function l(){const e={index:a};a.calcSize(),e!==a.height&&a.render()}function c(e){const t=A(e.target).closest("li");if(!t.length)return;let r=t.index();if(a.skipRate>0){const e=r/(t.siblings("li").length-1);r=Math.round((a.indexes.length-1)*e)}const s=a.indexes[r];a.$el.trigger("listindex:click",{content:s,index:r}),a.emit("local::click listIndexClick",a,s,r),a.$el.trigger("listindex:select",{content:s,index:r}),a.emit("local::select listIndexSelect",a,s,r),a.$listEl&&a.params.scrollList&&a.scrollListToIndex(s,r)}o?n=o.parents(".page-content").eq(0):(n=s.siblings(".page-content").eq(0),0===n.length&&(n=s.parents(".page").eq(0).find(".page-content").eq(0))),s[0].f7ListIndex=a,Fe(a,{app:e,$el:s,el:s&&s[0],$ul:i,ul:i&&i[0],$listEl:o,listEl:o&&o[0],$pageContentEl:n,pageContentEl:n&&n[0],indexes:t.indexes,height:0,skipRate:0}),a.useModules();const p={};let d,u,h,m,f,g=null;function v(e){const t=i.children();t.length&&(h=t[0].getBoundingClientRect().top,m=t[t.length-1].getBoundingClientRect().top+t[0].offsetHeight,p.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,p.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,d=!0,u=!1,g=null)}function b(e){if(!d)return;!u&&a.params.label&&(f=A('<span class="list-index-label"></span>'),s.append(f)),u=!0;const t="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;e.preventDefault();let r=(t-h)/(m-h);r=Math.min(Math.max(r,0),1);const o=Math.round((a.indexes.length-1)*r),n=a.indexes[o],i=m-h,l=(a.height-i)/2+(1-r)*i;o!==g&&(a.params.label&&f.html(n).transform(`translateY(-${l}px)`),a.$listEl&&a.params.scrollList&&a.scrollListToIndex(n,o)),g=o,a.$el.trigger("listindex:select"),a.emit("local::select listIndexSelect",a,n,o)}function w(){d&&(d=!1,u=!1,a.params.label&&(f&&f.remove(),f=void 0))}const y=!!tt().passiveListener&&{passive:!0};return a.attachEvents=function(){s.parents(".tab").on("tab:show",l),s.parents(".page").on("page:reinit",l),s.parents(".panel").on("panel:open",l),s.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").on("modal:open",l),e.on("resize",l),s.on("click",c),s.on(e.touchEvents.start,v,y),e.on("touchmove:active",b),e.on("touchend:passive",w)},a.detachEvents=function(){s.parents(".tab").off("tab:show",l),s.parents(".page").off("page:reinit",l),s.parents(".panel").off("panel:open",l),s.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").off("modal:open",l),e.off("resize",l),s.off("click",c),s.off(e.touchEvents.start,v,y),e.off("touchmove:active",b),e.off("touchend:passive",w)},a.init(),a}scrollListToIndex(e,t){const a=this,{$listEl:r,$pageContentEl:s,app:o}=a;if(!r||!s||0===s.length)return a;let n;if(r.find(".list-group-title").each((t=>{if(n)return;const a=A(t);a.text()===e&&(n=a)})),!n||0===n.length)return a;const i=n.parent().offset().top;let l=parseInt(s.css("padding-top"),10);const c=s[0].scrollTop,p=n.offset().top;if(s.parents(".page-with-navbar-large").length){const e=o.navbar.getElByPage(s.parents(".page-with-navbar-large").eq(0)),t=A(e).find(".title-large");t.length&&(l-=t[0].offsetHeight||0)}return i<=l?s.scrollTop(i+c-l):s.scrollTop(p+c-l),a}renderSkipPlaceholder(){return this.params.renderSkipPlaceholder.call(this)}renderItem(e,t){return this.params.renderItem.call(this,e,t)}render(){const e=this,{$ul:t,indexes:a,skipRate:r}=e;let s;const o=a.map(((t,a)=>{if(a%r!=0&&r>0)return s=!0,"";let o=e.renderItem(t,a);return s&&(o=e.renderSkipPlaceholder()+o),s=!1,o})).join("");return t.html(o),e}calcSize(){const e=this,{app:t,params:a,el:r,indexes:s}=e,o=r.offsetHeight,n=a[`${t.theme}ItemHeight`],i=Math.floor(o/n),l=s.length;let c=0;return l>i&&(c=Math.ceil((2*l-1)/i)),e.height=o,e.skipRate=c,e}calcIndexes(){const e=this;return"auto"===e.params.indexes?(e.indexes=[],e.$listEl.find(".list-group-title").each((t=>{const a=A(t).text();e.indexes.indexOf(a)<0&&e.indexes.push(a)}))):e.indexes=e.params.indexes,e}update(){const e=this;return e.calcIndexes(),e.calcSize(),e.render(),e}init(){const e=this;e.calcIndexes(),e.calcSize(),e.render(),e.attachEvents()}destroy(){let e=this;e.$el.trigger("listindex:beforedestroy",e),e.emit("local::beforeDestroy listIndexBeforeDestroy"),e.detachEvents(),e.$el[0]&&(e.$el[0].f7ListIndex=null,delete e.$el[0].f7ListIndex),Ie(e),e=null}};var $r={name:"listIndex",static:{ListIndex:kr},create(){this.listIndex=nt({defaultSelector:".list-index",constructor:kr,app:this,domProp:"f7ListIndex"})},on:{tabMounted(e){const t=this;A(e).find(".list-index-init").each((e=>{const a=Fe(A(e).dataset(),{el:e});t.listIndex.create(a)}))},tabBeforeRemove(e){A(e).find(".list-index-init").each((e=>{e.f7ListIndex&&e.f7ListIndex.destroy()}))},pageInit(e){const t=this;e.$el.find(".list-index-init").each((e=>{const a=Fe(A(e).dataset(),{el:e});t.listIndex.create(a)}))},pageBeforeRemove(e){e.$el.find(".list-index-init").each((e=>{e.f7ListIndex&&e.f7ListIndex.destroy()}))}},vnode:{"list-index-init":{insert(e){const t=e.elm,a=Fe(A(t).dataset(),{el:t});this.listIndex.create(a)},destroy(e){const t=e.elm;t.f7ListIndex&&t.f7ListIndex.destroy()}}}};const xr={show(){const e=this;let t,a,r,s,o;for(var n=arguments.length,i=new Array(n),l=0;l<n;l++)i[l]=arguments[l];1===i.length&&i[0]&&i[0].constructor===Object?(t=i[0].tabEl,a=i[0].tabLinkEl,r=i[0].animate,s=i[0].tabRoute,o=i[0].animatedInit):([t,a,r,s]=i,"boolean"==typeof i[1]&&([t,r,a,s]=i,i.length>2&&a.constructor===Object&&([t,r,s,a]=i))),void 0===r&&(r=!0);const c=A(t);if(s&&c[0]&&(c[0].f7TabRoute=s),!o&&(0===c.length||c.hasClass("tab-active")))return{$newTabEl:c,newTabEl:c[0]};let p;a&&(p=A(a));const d=c.parent(".tabs");if(0===d.length)return{$newTabEl:c,newTabEl:c[0]};e.swipeout&&(e.swipeout.allowOpen=!0);const u=[];function h(){u.forEach((e=>{e()}))}let m,f=!1;if(d.parent().hasClass("tabs-animated-wrap")){d.parent()[r?"removeClass":"addClass"]("not-animated");const t=parseFloat(d.css("transition-duration").replace(",","."));r&&t&&(d.transitionEnd(h),f=!0);const a=100*(e.rtl?c.index():-c.index());d.transform(`translate3d(${a}%,0,0)`)}if("swiper-container"===d[0].nodeName.toLowerCase()&&e.swiper){m=d[0].swiper;const e=m.slides.indexOf(c[0]);m&&m.activeIndex!==e?(f=!0,m.once("slideChangeTransitionEnd",(()=>{h()})).slideTo(e,r?void 0:0)):m&&m.animating&&(f=!0,m.once("slideChangeTransitionEnd",(()=>{h()})))}const g=d.children(".tab-active");if(g.removeClass("tab-active"),!o&&(!m||m&&!m.animating||m&&s)&&(g.hasClass("view")&&g.children(".page").length&&g.children(".page").each((t=>{A(t).trigger("page:tabhide"),e.emit("pageTabHide",t)})),g.trigger("tab:hide"),e.emit("tabHide",g[0])),c.addClass("tab-active"),!o&&(!m||m&&!m.animating||m&&s)&&(c.hasClass("view")&&c.children(".page").length&&c.children(".page").each((t=>{A(t).trigger("page:tabshow"),e.emit("pageTabShow",t)})),c.trigger("tab:show"),e.emit("tabShow",c[0])),!p&&(p=A("string"==typeof t?`.tab-link[href="${t}"]`:`.tab-link[href="#${c.attr("id")}"]`),(!p||p&&0===p.length)&&A("[data-tab]").each((e=>{c.is(A(e).attr("data-tab"))&&(p=A(e))})),s&&(!p||p&&0===p.length)&&(p=A(`[data-route-tab-id="${s.route.tab.id}"]`),0===p.length&&(p=A(`.tab-link[href="${s.url}"]`))),p.length>1&&c.parents(".page").length&&(p=p.filter((e=>A(e).parents(".page")[0]===c.parents(".page")[0])),"ios"===e.theme&&0===p.length&&s))){const t=c.parents(".page"),a=A(e.navbar.getElByPage(t));p=a.find(`[data-route-tab-id="${s.route.tab.id}"]`),0===p.length&&(p=a.find(`.tab-link[href="${s.url}"]`))}if(p.length>0){let t;if(g&&g.length>0){const e=g.attr("id");e&&(t=A(`.tab-link[href="#${e}"]`),(!t||t&&0===t.length)&&(t=A(`.tab-link[data-route-tab-id="${e}"]`))),(!t||t&&0===t.length)&&A("[data-tab]").each((e=>{g.is(A(e).attr("data-tab"))&&(t=A(e))})),(!t||t&&0===t.length)&&(t=p.siblings(".tab-link-active"))}else s&&(t=p.siblings(".tab-link-active"));if(t&&t.length>1&&g&&g.parents(".page").length&&(t=t.filter((e=>A(e).parents(".page")[0]===g.parents(".page")[0]))),t&&t.length>0&&t.removeClass("tab-link-active"),p&&p.length>0){p.addClass("tab-link-active");const t=p.parents(".tabbar, .tabbar-icons");e.toolbar&&t.length>0&&(t.hasClass("tabbar-highlight")||"ios"!==e.theme)&&e.toolbar.setHighlight(t)}}return{$newTabEl:c,newTabEl:c[0],$oldTabEl:g,oldTabEl:g[0],onTabsChanged:function(e){u.push(e)},animated:f}}};var Tr={name:"tabs",create(){Fe(this,{tab:{show:xr.show.bind(this)}})},on:{"pageInit tabMounted":function(e){const t=A(e.el||e).find(".tabs-animated-wrap > .tabs > .tab-active")[0];if(!t)return;this.tab.show({tabEl:t,animatedInit:!0,animate:!1})}},clicks:{".tab-link":function(e,t){if(void 0===t&&(t={}),e.attr("href")&&0===e.attr("href").indexOf("#")||e.attr("data-tab")){this.tab.show({tabEl:t.tab||e.attr("href"),tabLinkEl:e,animate:t.animate})}}}};function Sr(e){const t=e.app,a=tt();if(e.resizableInitialized)return;Fe(e,{resizable:!0,resizableWidth:null,resizableInitialized:!0});const r=A("html"),{$el:s,$backdropEl:o,side:n,effect:i}=e;if(!s)return;let l,c;const p={};let d,u,h,m,f,g;const v="cover"!==i&&"floating"!==i;function b(e){if(!e)return null;if(e.indexOf("%")>=0||e.indexOf("vw")>=0)return parseInt(e,10)/100*t.width;const a=parseInt(e,10);return Number.isNaN(a)?null:a}function w(t){e.resizable&&s.hasClass("panel-resizable")&&(p.x="touchstart"===t.type?t.targetTouches[0].pageX:t.pageX,p.y="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,c=!1,l=!0,m=b(s.css("min-width")),f=b(s.css("max-width")),g=s.hasClass("panel-in-breakpoint"))}function y(a){if(!l)return;const i="touchmove"===a.type?a.targetTouches[0].pageX:a.pageX;c||(u=s[0].offsetWidth,s.transition(0),s.addClass("panel-resizing"),r.css("cursor","col-resize"),(v||g)&&(h=A(e.getViewEl()),e.$containerEl&&e.$containerEl.hasClass("page")&&h.add(e.$containerEl.children(".page-content, .tabs, .fab"))),v&&!g&&(o.transition(0),h.transition(0))),c=!0,a.preventDefault(),d=i-p.x;let b="left"===n?u+d:u-d;m&&!Number.isNaN(m)&&(b=Math.max(b,m)),f&&!Number.isNaN(f)&&(b=Math.min(b,f)),b=Math.min(Math.max(b,0),t.width),e.resizableWidth=b,s[0].style.width=`${b}px`,v&&!g?(h&&h.transform(`translate3d(${"left"===n?b:-b}px, 0, 0)`),o&&o.transform(`translate3d(${"left"===n?b:-b}px, 0, 0)`)):g&&h&&h.css(`margin-${n}`,`${b}px`),s.trigger("panel:resize",b),e.emit("local::resize panelResize",e,b)}function C(){if(A("html").css("cursor",""),!l||!c)return l=!1,void(c=!1);l=!1,c=!1,r[0].style.setProperty(`--f7-panel-${n}-width`,`${e.resizableWidth}px`),s[0].style.width="",v&&!g&&(h.transform(""),o.transform("")),s.removeClass("panel-resizing"),De((()=>{s.transition(""),v&&(o.transition(""),h&&h.transition(""))}))}function E(){e.opened&&e.resizableWidth&&(m=b(s.css("min-width")),f=b(s.css("max-width")),m&&!Number.isNaN(m)&&e.resizableWidth<m&&(e.resizableWidth=Math.max(e.resizableWidth,m)),f&&!Number.isNaN(f)&&e.resizableWidth>f&&(e.resizableWidth=Math.min(e.resizableWidth,f)),e.resizableWidth=Math.min(Math.max(e.resizableWidth,0),t.width),r[0].style.setProperty(`--f7-panel-${n}-width`,`${e.resizableWidth}px`))}0===e.$el.find(".panel-resize-handler").length&&e.$el.append('<div class="panel-resize-handler"></div>'),e.$resizeHandlerEl=e.$el.children(".panel-resize-handler"),s.addClass("panel-resizable");const k=!!a.passiveListener&&{passive:!0};e.$el.on(t.touchEvents.start,".panel-resize-handler",w,k),t.on("touchmove:active",y),t.on("touchend:passive",C),t.on("resize",E),e.on("beforeOpen",E),e.once("panelDestroy",(()=>{s.removeClass("panel-resizable"),e.$resizeHandlerEl.remove(),e.$el.off(t.touchEvents.start,".panel-resize-handler",w,k),t.off("touchmove:active",y),t.off("touchend:passive",C),t.off("resize",E),e.off("beforeOpen",E)}))}let Pr=class extends ot{constructor(e,t){void 0===t&&(t={});const a=Fe({on:{}},e.params.panel,t);super(a,[e]);const r=this;let s;if(r.params=a,r.$containerEl=r.params.containerEl?A(r.params.containerEl).eq(0):e.$el,r.containerEl=r.$containerEl[0],r.containerEl||(r.$containerEl=e.$el,r.containerEl=e.$el[0]),r.params.el?s=A(r.params.el).eq(0):r.params.content&&(s=A(r.params.content).filter((e=>1===e.nodeType)).eq(0)),0===s.length)return r;if(s[0].f7Panel)return s[0].f7Panel;s[0].f7Panel=r;let o,{side:n,effect:i,resizable:l}=r.params;return void 0===n&&(n=s.hasClass("panel-left")?"left":"right"),void 0===i&&(i=s.hasClass("panel-cover")?"cover":s.hasClass("panel-push")?"push":s.hasClass("panel-floating")?"floating":"reveal"),void 0===l&&(l=s.hasClass("panel-resizable")),r.params.backdrop&&r.params.backdropEl?o=A(r.params.backdropEl):r.params.backdrop&&(o=r.$containerEl.children(".panel-backdrop"),0===o.length&&(o=A('<div class="panel-backdrop"></div>'),r.$containerEl.prepend(o))),Fe(r,{app:e,side:n,effect:i,resizable:l,$el:s,el:s[0],opened:!1,$backdropEl:o,backdropEl:o&&o[0]}),r.useModules(),r.init(),r}getViewEl(){const e=this;let t;return t=e.$containerEl.children(".views").length>0?e.$containerEl.children(".views")[0]:e.$containerEl.children(".view")[0],t}setStateClasses(e){const t=this,{side:a,el:r,effect:s}=t,o=t.getViewEl(),n=o&&o.contains(r),i=!o||n?t.$containerEl:A("html");"open"===e&&i.addClass(`with-panel with-panel-${t.side}-${t.effect}`),"before-closing"===e&&i.addClass("with-panel-closing"),"closing"===e&&(i.addClass("with-panel-closing"),i.removeClass(`with-panel with-panel-${t.side}-${t.effect}`)),"after-closing"===e&&i.removeClass("with-panel-closing"),"closed"===e&&i.removeClass(`with-panel-${a}-${s}`)}enableVisibleBreakpoint(){const e=this;return e.visibleBreakpointDisabled=!1,e.setVisibleBreakpoint(),e}disableVisibleBreakpoint(){const e=this;return e.visibleBreakpointDisabled=!0,e.setVisibleBreakpoint(),e}toggleVisibleBreakpoint(){const e=this;return e.visibleBreakpointDisabled=!e.visibleBreakpointDisabled,e.setVisibleBreakpoint(),e}setVisibleBreakpoint(e){void 0===e&&(e=!0);const t=this,a=t.app;t.visibleBreakpointResizeHandler||(t.visibleBreakpointResizeHandler=function(){t.setVisibleBreakpoint()},a.on("resize",t.visibleBreakpointResizeHandler));const{side:r,$el:s,$containerEl:o,params:n,visibleBreakpointDisabled:i}=t,l=n.visibleBreakpoint,c=A(t.getViewEl()),p=s.hasClass("panel-in-breakpoint");o&&o.hasClass("page")&&c.add(o.children(".page-content, .tabs, .fab")),a.width>=l&&null!=l&&!i?p?c.css({[`margin-${r}`]:`${s.width()}px`}):(t.setStateClasses("closed"),s.addClass("panel-in-breakpoint").removeClass("panel-in panel-in-collapsed"),t.onOpen(!1),t.onOpened(),c.css({[`margin-${r}`]:`${s.width()}px`}),a.allowPanelOpen=!0,e&&(t.emit("local::breakpoint panelBreakpoint",t),t.$el.trigger("panel:breakpoint"))):p&&(s.removeClass("panel-in-breakpoint panel-in"),t.onClose(),t.onClosed(),c.css({[`margin-${r}`]:""}),e&&(t.emit("local::breakpoint panelBreakpoint",t),t.$el.trigger("panel:breakpoint")))}enableCollapsedBreakpoint(){const e=this;return e.collapsedBreakpointDisabled=!1,e.setCollapsedBreakpoint(),e}disableCollapsedBreakpoint(){const e=this;return e.collapsedBreakpointDisabled=!0,e.setCollapsedBreakpoint(),e}toggleCollapsedBreakpoint(){const e=this;return e.collapsedBreakpointDisabled=!e.collapsedBreakpointDisabled,e.setCollapsedBreakpoint(),e}setCollapsedBreakpoint(e){void 0===e&&(e=!0);const t=this,a=t.app;t.collapsedBreakpointResizeHandler||(t.collapsedBreakpointResizeHandler=function(){t.setCollapsedBreakpoint()},a.on("resize",t.collapsedBreakpointResizeHandler));const{$el:r,params:s,collapsedBreakpointDisabled:o}=t;if(r.hasClass("panel-in-breakpoint"))return;const n=s.collapsedBreakpoint,i=r.hasClass("panel-in-collapsed");a.width>=n&&null!=n&&!o?i||(t.setStateClasses("closed"),r.addClass("panel-in-collapsed").removeClass("panel-in"),t.collapsed=!0,a.allowPanelOpen=!0,e&&(t.emit("local::collapsedBreakpoint panelCollapsedBreakpoint",t),t.$el.trigger("panel:collapsedbreakpoint"))):i&&(r.removeClass("panel-in-collapsed panel-in"),t.collapsed=!1,e&&(t.emit("local::collapsedBreakpoint panelCollapsedBreakpoint",t),t.$el.trigger("panel:collapsedbreakpoint")))}enableResizable(){const e=this;return e.resizableInitialized?(e.resizable=!0,e.$el.addClass("panel-resizable")):Sr(e),e}disableResizable(){const e=this;return e.resizable=!1,e.$el.removeClass("panel-resizable"),e}enableSwipe(){const e=this;return e.swipeInitialized?e.swipeable=!0:function(e){const t=e.app;if(e.swipeInitialized)return;Fe(e,{swipeable:!0,swipeInitialized:!0});const a=e.params,{$el:r,$backdropEl:s,side:o,effect:n}=e;let i,l,c,p,d,u;const h={};let m,f,g,v,b,w,y,C=0;function E(r){if(!e.swipeable||c)return;if(!t.panel.allowOpen||!a.swipe&&!a.swipeOnlyClose||l)return;if(A(".modal-in:not(.toast):not(.notification), .photo-browser-in").length>0)return;i=t.panel.get("left"===o?"right":"left")||{};const s=i.opened&&i.$el&&!i.$el.hasClass("panel-in-breakpoint");if((e.opened||!s)&&(a.swipeOnlyClose||!s)&&(!r.target||"input"!==r.target.nodeName.toLowerCase()||"range"!==r.target.type)&&!(A(r.target).closest(".range-slider, swiper-container.tabs, .calendar-months, .no-swipe-panel, .card-opened").length>0)&&(h.x="touchstart"===r.type?r.targetTouches[0].pageX:r.pageX,h.y="touchstart"===r.type?r.targetTouches[0].pageY:r.pageY,!a.swipeOnlyClose||e.opened)){if(a.swipeActiveArea&&!e.opened){if("left"===o&&h.x>a.swipeActiveArea)return;if("right"===o&&h.x<t.width-a.swipeActiveArea)return}C=0,y=A(e.getViewEl()),p=!1,l=!0,d=void 0,u=!1,m=Ae(),w=void 0}}function k(i){if(!l||c||u)return;if(C+=1,C<2)return;if(i.f7PreventSwipePanel||t.preventSwipePanelBySwipeBack||t.preventSwipePanel)return void(l=!1);const m="touchmove"===i.type?i.targetTouches[0].pageX:i.pageX,E="touchmove"===i.type?i.targetTouches[0].pageY:i.pageY;if(void 0===d&&(d=!!(d||Math.abs(E-h.y)>Math.abs(m-h.x))),d)return void(l=!1);if(!w){if(w=m>h.x?"to-right":"to-left",a.swipeActiveArea>0&&!e.opened){if("left"===o&&h.x>a.swipeActiveArea)return void(l=!1);if("right"===o&&h.x<t.width-a.swipeActiveArea)return void(l=!1)}if(r.hasClass("panel-in-breakpoint"))return void(l=!1);if("left"===o&&"to-left"===w&&!r.hasClass("panel-in")||"right"===o&&"to-right"===w&&!r.hasClass("panel-in"))return void(l=!1)}let k=e.opened?0:-a.swipeThreshold;"right"===o&&(k=-k),p||(e.opened||(e.insertToRoot(),r.addClass("panel-in-swipe"),s&&s.css("visibility","visible"),r.trigger("panel:swipeopen"),e.emit("local::swipeOpen panelSwipeOpen",e)),b=r[0].offsetWidth,"reveal"===n&&r.hasClass("panel-in-collapsed")&&(b-=parseFloat(y.css(`margin-${o}`))),r.transition(0)),p=!0,i.cancelable&&i.preventDefault(),f=m-h.x+k;const x="floating"===n?8:0;"right"===o?"cover"===n||"push"===n||"floating"===n?(g=f+(e.opened?x:b),g<0-x&&(g=-x),g>b&&(g=b)):(g=f-(e.opened?b:0),g>0&&(g=0),g<-b&&(g=-b)):(g=f+(e.opened?b:x),g<0&&(g=0),g>b+x&&(g=b+x));const T=Math.abs(g/b);if("reveal"===n)a.swipeNoFollow||(y.transform(`translate3d(${g}px,0,0)`).transition(0),s&&s.transform(`translate3d(${g}px,0,0)`).transition(0)),r.trigger("panel:swipe",Math.abs(g/b)),e.emit("local::swipe panelSwipe",e,Math.abs(g/b));else{if("left"===o&&(g-=b),!a.swipeNoFollow&&(v=1-Math.abs(g/b),s&&(s.transition(0),s.css({opacity:v})),r.transform(`translate3d(${g}px,0,0)`).transition(0),"push"===n)){const e="left"===o?g+b:g-b;y.transform(`translate3d(${e}px,0,0)`).transition(0),s&&s.transform(`translate3d(${e}px,0,0)`).transition(0)}r.trigger("panel:swipe",Math.abs(g/b)),e.emit("local::swipe panelSwipe",e,Math.abs(g/b))}a.swipeNoFollow&&(e.opened&&0===T||!e.opened&&1===T)&&(u=!0,$(i))}function $(t){if(!l||!p)return l=!1,void(p=!1);const i="gesturestart"===t.type||c;l=!1,p=!1;const d=(new Date).getTime()-m;let u;const h="floating"===n?"left"===o?8:-8:0,v=(g===h||Math.abs(g)===b)&&!a.swipeNoFollow,w=a.swipeThreshold||0;u=i?"reset":e.opened?"cover"===n||"push"===n||"floating"===n?0===g?"reset":d<300&&Math.abs(g)>0?"swap":d>=300&&Math.abs(g)<b/2?"reset":"swap":g===-b?"reset":d<300&&Math.abs(g)>=0||d>=300&&Math.abs(g)<=b/2?"left"===o&&g===b?"reset":"swap":"reset":Math.abs(f)<w?"reset":"cover"===n||"push"===n||"floating"===n?g===0+h||d<300&&Math.abs(g)>0||d>=300&&Math.abs(g)<b/2?"swap":"reset":0===g?"reset":d<300&&Math.abs(g)>0||d>=300&&Math.abs(g)>=b/2?"swap":"reset","swap"===u&&(e.opened?e.close(!v):e.open(!v));let C=!0;if("reset"===u&&!e.opened)if(v)r.removeClass("panel-in-swipe");else{C=!1;const t="reveal"===n?y:r;e.setStateClasses("before-closing"),t.transitionEnd((()=>{r.hasClass("panel-in")||(r.removeClass("panel-in-swipe"),e.setStateClasses("after-closing"))}))}"reveal"!==n&&"push"!==n||De((()=>{y.transition(""),y.transform("")})),C&&r.removeClass("panel-in-swipe"),r.transition("").transform(""),s&&s.transform("").transition("").css({opacity:"",visibility:""})}function x(e){c=!0,$(e)}function T(){c=!1}t.on("touchstart:passive",E),t.on("touchmove:active",k),t.on("touchend:passive",$),t.on("gesturestart",x),t.on("gestureend",T),e.on("panelDestroy",(()=>{t.off("touchstart:passive",E),t.off("touchmove:active",k),t.off("touchend:passive",$),t.off("gesturestart",x),t.off("gestureend",T)}))}(e),e}disableSwipe(){return this.swipeable=!1,this}onOpen(e){void 0===e&&(e=!0);const t=this;t._openTransitionStarted=!1;const a=t.app;t.opened=!0,a.panel.allowOpen=!1,t.$el.trigger("panel:beforeopen"),t.emit("local::beforeOpen panelBeforeOpen",t),e&&t.setStateClasses("open"),t.$el.trigger("panel:open"),t.emit("local::open panelOpen",t)}onOpened(){const e=this;e.app.panel.allowOpen=!0,e.$el.trigger("panel:opened"),e.emit("local::opened panelOpened",e)}onClose(){const e=this,t=e.app;e.opened=!1,t.panel.allowOpen=!1,e.$el.trigger("panel:beforeclose"),e.emit("local::beforeClose panelBeforeClose",e),e.setStateClasses("closing"),e.$el.trigger("panel:close"),e.emit("local::close panelClose",e)}onClosed(){const e=this,t=e.app;if(t.panel.allowOpen=!0,e.setStateClasses("after-closing"),e.$el.removeClass("panel-out"),e.$backdropEl){const a=t.panel.get(".panel-in");(!a||a&&!a.$backdropEl)&&e.$backdropEl.removeClass("panel-backdrop-in")}e.$el.trigger("panel:closed"),e.emit("local::closed panelClosed",e)}toggle(e){void 0===e&&(e=!0);const t=this,a=t.params.visibleBreakpoint;return t.app.width>=a&&null!=a?t.toggleVisibleBreakpoint():(t.opened?t.close(e):t.open(e),t)}insertToRoot(){const e=this,t=r(),{$el:a,$backdropEl:s,$containerEl:o}=e,n=a.parent(),i=a.parents(t).length>0;if(!n.is(o)||a.prevAll(".views, .view").length){const t=o.children(".panel, .views, .view").eq(0),r=o.children(".panel-backdrop").eq(0);t.length?a.insertBefore(t):r?a.insertBefore(r):o.prepend(a),s&&s.length&&(!s.parent().is(o)&&0===s.nextAll(".panel").length||s.parent().is(o)&&0===s.nextAll(".panel").length)&&s.insertBefore(a),e.once("panelClosed",(()=>{i?n.append(a):a.remove()}))}}open(e){void 0===e&&(e=!0);const t=this,a=t.app;if(!a.panel.allowOpen)return!1;const{effect:r,$el:s,$backdropEl:o,opened:n,$containerEl:i}=t;if(!s||s.hasClass("panel-in"))return t;if(t.insertToRoot(),n||s.hasClass("panel-in-breakpoint")||s.hasClass("panel-in"))return!1;const l=a.panel.get(".panel-in");l&&l!==t&&l.close(e),s[e?"removeClass":"addClass"]("not-animated"),s.addClass("panel-in"),o&&(o.addClass("panel-backdrop-in"),o[e?"removeClass":"addClass"]("not-animated")),["cover","push","floating"].includes(t.effect)&&(t._clientLeft=s[0].clientLeft);const c=A(t.getViewEl());i&&i.hasClass("page")&&c.add(i.children(".page-content, .tabs"));const p="reveal"===r?c:s;return e?(o&&o.removeClass("not-animated"),p.transitionStart((()=>{t._openTransitionStarted=!0})),function e(){p.transitionEnd((a=>{A(a.target).is(p)?s.hasClass("panel-out")?t.onClosed():t.onOpened():e()}))}(),s.removeClass("panel-out not-animated").addClass("panel-in"),t.onOpen()):(o&&o.addClass("not-animated"),s.removeClass("panel-out").addClass("panel-in not-animated"),t.onOpen(),t.onOpened(),t._openTransitionStarted=!0),!0}close(e){void 0===e&&(e=!0);const t=this,{effect:a,$el:r,$backdropEl:s,opened:o,$containerEl:n}=t;if(!o||r.hasClass("panel-in-breakpoint")||!r.hasClass("panel-in"))return t;r[e?"removeClass":"addClass"]("not-animated"),s&&s[e?"removeClass":"addClass"]("not-animated");const i=A(t.getViewEl());n&&n.hasClass("page")&&i.add(n.children(".page-content, .tabs"));const l="reveal"===a?i:r;return t._openTransitionStarted||(e=!1),e?(l.transitionEnd((()=>{r.hasClass("panel-out")?t.onClosed():r.hasClass("panel-in")&&t.onOpened(),t.setStateClasses("after-closing")})),r.removeClass("panel-in").addClass("panel-out"),t.onClose()):(r.addClass("not-animated").removeClass("panel-in").addClass("panel-out"),t.onClose(),t.onClosed()),t}init(){const e=this;void 0!==e.params.visibleBreakpoint&&e.setVisibleBreakpoint(),void 0!==e.params.collapsedBreakpoint&&e.setCollapsedBreakpoint(),e.params.swipe&&e.enableSwipe(),e.resizable&&e.enableResizable()}destroy(){let e=this;const t=e.app,{$containerEl:a}=e;if(e.$el){if(e.emit("local::beforeDestroy panelBeforeDestroy",e),e.$el.trigger("panel:beforedestroy"),e.visibleBreakpointResizeHandler&&t.off("resize",e.visibleBreakpointResizeHandler),e.collapsedBreakpointResizeHandler&&t.off("resize",e.collapsedBreakpointResizeHandler),e.$el.hasClass("panel-in-breakpoint")||e.$el.hasClass("panel-in-collapsed")){const t=A(e.getViewEl());a&&a.hasClass("page")&&t.add(a.children(".page-content, .tabs")),e.$el.removeClass("panel-in-breakpoint panel-in-collapsed panel-in"),t.css({[`margin-${e.side}`]:""}),e.emit("local::breakpoint panelBreakpoint",e),e.$el.trigger("panel:breakpoint")}e.$el.trigger("panel:destroy"),e.emit("local::destroy panelDestroy",e),e.el&&(e.el.f7Panel=null,delete e.el.f7Panel),Ie(e),e=null}}};var Mr={name:"panel",params:{panel:{opened:void 0,side:void 0,effect:void 0,resizable:void 0,backdrop:!0,backdropEl:void 0,visibleBreakpoint:void 0,collapsedBreakpoint:void 0,swipe:!1,swipeNoFollow:!1,swipeOnlyClose:!1,swipeActiveArea:0,swipeThreshold:0,closeByBackdropClick:!0,containerEl:void 0}},static:{Panel:Pr},create(){const e=this;Fe(e,{panel:{allowOpen:!0,create:t=>new Pr(e,t),get(e){if(void 0===e&&(e=".panel"),e instanceof Pr)return e;"left"!==e&&"right"!==e||(e=`.panel-${e}`);const t=A(e);return 0===t.length||t.length>1?void 0:t[0].f7Panel},destroy(t){void 0===t&&(t=".panel");const a=e.panel.get(t);if(a&&a.destroy)return a.destroy()},open(t,a){void 0===t&&(t=".panel"),"left"!==t&&"right"!==t||(t=`.panel-${t}`);let r=e.panel.get(t);return r&&r.open?r.open(a):r?void 0:(r=e.panel.create({el:t}),r.open(a))},close(t,a){void 0===t&&(t=".panel-in"),"left"!==t&&"right"!==t||(t=`.panel-${t}`);let r=e.panel.get(t);return r&&r.open?r.close(a):r?void 0:(r=e.panel.create({el:t}),r.close(a))},toggle(t,a){void 0===t&&(t=".panel"),"left"!==t&&"right"!==t||(t=`.panel-${t}`);let r=e.panel.get(t);return r&&r.toggle?r.toggle(a):r?void 0:(r=e.panel.create({el:t}),r.toggle(a))}}})},on:{init(){const e=this;A(".panel-init").each((t=>{const a=Object.assign({el:t},A(t).dataset()||{});e.panel.create(a)}))},pageInit(e){const t=this;e.$el.find(".panel-init").each((e=>{const a=Object.assign({el:e},A(e).dataset()||{});t.panel.create(a)}))},pageBeforeRemove(e){const t=this;e.$el.find(".panel-init").each((e=>{const a=t.panel.get(e);a&&a.destroy&&a.destroy()}))}},vnode:{"panel-init":{insert(e){const t=e.elm,a=Object.assign({el:t},A(t).dataset()||{});this.panel.create(a)},destroy(e){const t=e.elm,a=this.panel.get(t);a&&a.destroy&&a.destroy()}}},clicks:{".panel-open":function(e,t){void 0===t&&(t={});this.panel.open(t.panel,t.animate)},".panel-close":function(e,t){void 0===t&&(t={});this.panel.close(t.panel,t.animate)},".panel-toggle":function(e,t){void 0===t&&(t={});this.panel.toggle(t.panel,t.animate)},".panel-backdrop":function(){const e=this,t=A(".panel-in:not(.panel-out)");if(!t.length)return;const a=t[0]&&t[0].f7Panel;t.trigger("panel:backdrop-click"),a&&a.emit("backdropClick",a),e.emit("panelBackdropClick",a||t[0]),a&&!1===a.params.closeByBackdropClick||e.params.panel.closeByBackdropClick&&e.panel.close()}}};const Or={open(e,t){void 0===e&&(e=".card-expandable"),void 0===t&&(t=!0);const a=this,s=rt(),o=r(),n=tt(),i=A(e).eq(0);if(!i||!i.length)return;if(i.hasClass("card-opened")||i.hasClass("card-opening")||i.hasClass("card-closing"))return;const l=i.parents(".page").eq(0);if(!l.length)return;if(l.find(".card-opened").length)return;let c;function p(){c=!0}if(i.trigger("card:beforeopen",{prevent:p}),a.emit("cardBeforeOpen",i[0],p),c)return;const d=Object.assign({animate:t},a.params.card,i.dataset()),u=i.parents(".page-content");let h,m,f;i.attr("data-backdrop-el")&&(h=A(i.attr("data-backdrop-el"))),!h&&d.backdrop&&(h=u.find(".card-backdrop"),h.length||(h=A('<div class="card-backdrop"></div>'),u.append(h))),d.hideNavbarOnOpen&&(m=l.children(".navbar"),m.length||l[0].f7Page&&(m=l[0].f7Page.$navbarEl)),d.hideToolbarOnOpen&&(f=l.children(".toolbar"),f.length||(f=l.parents(".view").children(".toolbar")),f.length||(f=l.parents(".views").children(".toolbar")));const g=i.css("transform");let v;g&&g.match(/[2-9]/)&&(v=!0);const b=i.children(".card-content"),w=A(o.createElement("div")).addClass("card-expandable-size");i.append(w);let y,C=i[0].offsetWidth,E=i[0].offsetHeight,k=l[0].offsetWidth,$=l[0].offsetHeight,x=w[0].offsetWidth||k,T=w[0].offsetHeight||$;m&&!d.hideStatusbarOnOpen&&T===$&&(y=parseInt(m.css("--f7-safe-area-top"),10),Number.isNaN(y)&&(y=0)),y&&(T-=y);let S,P,M=x/C,O=T/E,I=i.offset(),B=l.offset();if(y&&(B.top+=y/2),I.left-=B.left,v){const e=g.replace(/matrix\(|\)/g,"").split(",").map((e=>e.trim()));if(e&&e.length>1){const t=parseFloat(e[0]);S=I.left-C*(1-t)/2,P=I.top-B.top-E*(1-t)/2,a.rtl&&(S-=i[0].scrollLeft)}else S=i[0].offsetLeft,P=i[0].offsetTop-(u.length?u[0].scrollTop:0)}else S=I.left,P=I.top-B.top,a.rtl&&(S-=i[0].scrollLeft);S-=(k-x)/2,P-=($-T)/2;let L=x-C-S;a.rtl&&([S,L]=[L,S]);let D,R,H,z,N,V,F,_,q,j,Y,W,X=T-E-P,U=(L-S)/2,G=(X-P)/2;function K(){l.addClass("page-with-card-opened"),s.ios&&u.length&&(u.css("height",`${u[0].offsetHeight+1}px`),setTimeout((()=>{u.css("height","")}))),i.addClass("card-opened"),i.removeClass("card-opening"),i.trigger("card:opened"),a.emit("cardOpened",i[0],l[0])}function Q(){i.removeClass("card-transitioning"),C=i[0].offsetWidth,E=i[0].offsetHeight,k=l[0].offsetWidth,$=l[0].offsetHeight,x=w[0].offsetWidth||k,T=w[0].offsetHeight||$,y=0,m&&!d.hideStatusbarOnOpen&&T===$&&(y=parseInt(m.css("--f7-safe-area-top"),10),Number.isNaN(y)&&(y=0)),y&&(T-=y),M=x/C,O=T/E,i.transform("translate3d(0px, 0px, 0) scale(1)"),I=i.offset(),B=l.offset(),y&&(B.top+=y/2),I.left-=B.left,I.top-=B.top,S=I.left-(k-x)/2,a.rtl&&(S-=i[0].scrollLeft),P=I.top-($-T)/2,L=x-C-S,X=T-E-P,a.rtl&&([S,L]=[L,S]),U=(L-S)/2,G=(X-P)/2,i.transform(`translate3d(${a.rtl?-U:U}px, ${G}px, 0) scale(${M}, ${O})`),b.css({width:`${x}px`,height:`${T}px`}).transform(`translate3d(${a.rtl?S+U:-S-U}px, 0px, 0) scale(${1/M}, ${1/O})`)}function J(e){A(e.target).closest(i).length&&e.isTrusted&&i.hasClass("card-opened")&&(W=i.find(d.scrollableEl),D=W[0]&&W[0]!==b[0]&&!W[0].contains(e.target)?0:W.scrollTop(),R=!0,z=e.targetTouches[0].pageX,N=e.targetTouches[0].pageY,_=void 0,j=!1,Y=!1)}function Z(e){if(R&&e.isTrusted){if(V=e.targetTouches[0].pageX,F=e.targetTouches[0].pageY,void 0===_&&(_=!!(_||Math.abs(F-N)>Math.abs(V-z))),Y||j||(!_&&e.targetTouches[0].clientX<=50?Y=!0:j=!0),!Y&&!j||j&&0!==D)return R=!0,void(H=!0);H||i.removeClass("card-transitioning"),H=!0,q=j?Math.max((F-N)/150,0):Math.max((V-z)/(C/2),0),(q>0&&j||Y)&&(j&&s.ios&&W[0]===b[0]&&(W.css("-webkit-overflow-scrolling","auto"),W.scrollTop(0)),e.preventDefault()),q>1&&(q**=.3),q>(j?1.3:1.1)?(R=!1,H=!1,a.card.close(i)):i.transform(`translate3d(${a.rtl?-U:U}px, ${G}px, 0) scale(${M*(1-.2*q)}, ${O*(1-.2*q)})`)}}function ee(e){R&&H&&e.isTrusted&&(R=!1,H=!1,s.ios&&W.css("-webkit-overflow-scrolling",""),q>=.8?a.card.close(i):i.addClass("card-transitioning").transform(`translate3d(${a.rtl?-U:U}px, ${G}px, 0) scale(${M}, ${O})`))}d.hideNavbarOnOpen&&m&&m.length&&(m.closest(".navbar-hidden").length?i[0].f7KeepNavbarOnClose=!0:(delete i[0].f7KeepNavbarOnClose,a.navbar.hide(m,d.animate,d.hideStatusbarOnOpen,!0))),d.hideToolbarOnOpen&&f&&f.length&&(f.closest(".toolbar-hidden").length?i[0].f7KeepToolbarOnClose=!0:(delete i[0].f7KeepToolbarOnClose,a.toolbar.hide(f,d.animate))),h&&h.removeClass("card-backdrop-out").addClass("card-backdrop-in"),i.removeClass("card-transitioning"),d.animate&&i.addClass("card-opening"),i.trigger("card:open"),a.emit("cardOpen",i[0]),b.css({width:`${x}px`,height:`${T}px`}).transform(`translate3d(${a.rtl?S+U:-S-U}px, 0px, 0) scale(${1/M}, ${1/O})`),i.transform(`translate3d(${a.rtl?-U:U}px, ${G}px, 0) scale(${M}, ${O})`),d.animate?i.transitionEnd((()=>{K()})):K(),i[0].detachEventHandlers=function(){a.off("resize",Q),n.touch&&d.swipeToClose&&(a.off("touchstart:passive",J),a.off("touchmove:active",Z),a.off("touchend:passive",ee))},a.on("resize",Q),n.touch&&d.swipeToClose&&(a.on("touchstart:passive",J),a.on("touchmove:active",Z),a.on("touchend:passive",ee))},close(e,t){void 0===e&&(e=".card-expandable.card-opened"),void 0===t&&(t=!0);const a=this,r=rt(),s=A(e).eq(0);if(!s||!s.length)return;if(!s.hasClass("card-opened")||s.hasClass("card-opening")||s.hasClass("card-closing"))return;const o=s.children(".card-content"),n=s.parents(".page-content"),i=s.parents(".page").eq(0);if(!i.length)return;const l=Object.assign({animate:t},a.params.card,s.dataset()),c=s.find(l.scrollableEl);let p,d,u;s.attr("data-backdrop-el")&&(u=A(s.attr("data-backdrop-el"))),l.backdrop&&(u=s.parents(".page-content").find(".card-backdrop")),l.hideNavbarOnOpen&&(p=i.children(".navbar"),p.length||i[0].f7Page&&(p=i[0].f7Page.$navbarEl),p&&p.length&&!s[0].f7KeepNavbarOnClose&&a.navbar.show(p,l.animate,!0)),l.hideToolbarOnOpen&&(d=i.children(".toolbar"),d.length||(d=i.parents(".view").children(".toolbar")),d.length||(d=i.parents(".views").children(".toolbar")),d&&d.length&&!s[0].f7KeepToolbarOnClose&&a.toolbar.show(d,l.animate)),i.removeClass("page-with-card-opened"),r.ios&&n.length&&(n.css("height",`${n[0].offsetHeight+1}px`),setTimeout((()=>{n.css("height","")}))),u&&u.length&&u.removeClass("card-backdrop-in").addClass("card-backdrop-out"),s.removeClass("card-opened card-transitioning"),l.animate?s.addClass("card-closing"):s.addClass("card-no-transition"),s.transform(""),s.trigger("card:close"),a.emit("cardClose",s[0],i[0]);const h=s.hasClass("card-expandable-animate-width");function m(){h||o.css({width:"",height:""}),u&&u.length&&u.removeClass("card-backdrop-in card-backdrop-out"),s.removeClass("card-closing card-no-transition"),s.trigger("card:closed"),s.find(".card-expandable-size").remove(),a.emit("cardClosed",s[0],i[0])}h&&o.css({width:"",height:""}),o.transform("").scrollTop(0,t?300:0),c.length&&c[0]!==o[0]&&c.scrollTop(0,t?300:0),t?o.transitionEnd((()=>{m()})):m(),s[0].detachEventHandlers&&(s[0].detachEventHandlers(),delete s[0].detachEventHandlers)},toggle(e,t){void 0===e&&(e=".card-expandable");const a=this,r=A(e).eq(0);r.length&&(r.hasClass("card-opened")?a.card.close(r,t):a.card.open(r,t))}};var Ir={name:"card",params:{card:{hideNavbarOnOpen:!0,hideStatusbarOnOpen:!0,hideToolbarOnOpen:!0,scrollableEl:".card-content",swipeToClose:!0,closeByBackdropClick:!0,backdrop:!0}},create(){Ke(this,{card:Or})},on:{pageBeforeIn(e){const t=this;if(t.params.card.hideNavbarOnOpen&&e.navbarEl&&e.$el.find(".card-opened.card-expandable").length&&t.navbar.hide(e.navbarEl,!0,t.params.card.hideStatusbarOnOpen,!0),t.params.card.hideToolbarOnOpen&&e.$el.find(".card-opened.card-expandable").length){let a=e.$el.children(".toolbar");a.length||(a=e.$el.parents(".view").children(".toolbar")),a.length||(a=e.$el.parents(".views").children(".toolbar")),a&&a.length&&t.toolbar.hide(a)}}},clicks:{".card-close":function(e,t){this.card.close(t.card,t.animate)},".card-open":function(e,t){this.card.open(t.card,t.animate)},".card-expandable":function(e,t,a){e.hasClass("card-opened")||e.hasClass("card-opening")||e.hasClass("card-closing")||A(a.target).closest(".card-prevent-open, .card-close").length||this.card.open(e)},".card-backdrop-in":function(){let e=!1;this.params.card.closeByBackdropClick&&(e=!0);const t=A(".card-opened");t.length&&("true"===t.attr("data-close-by-backdrop-click")?e=!0:"false"===t.attr("data-close-by-backdrop-click")&&(e=!1),e&&this.card.close(t))}}};const Br={store(e,t){const a=o();let r=e;const s=A(e);s.length&&s.is("form")&&s.attr("id")&&(r=s.attr("id")),this.form.data[`form-${r}`]=t,a.localStorage[`f7form-${r}`]=JSON.stringify(t)},get(e){const t=this,a=o();let r=e;const s=A(e);return s.length&&s.is("form")&&s.attr("id")&&(r=s.attr("id")),a.localStorage[`f7form-${r}`]?JSON.parse(a.localStorage[`f7form-${r}`]):t.form.data[`form-${r}`]?t.form.data[`form-${r}`]:void 0},remove(e){const t=this,a=o();let r=e;const s=A(e);s.length&&s.is("form")&&s.attr("id")&&(r=s.attr("id")),t.form.data[`form-${r}`]&&(t.form.data[`form-${r}`]="",delete t.form.data[`form-${r}`]),a.localStorage[`f7form-${r}`]&&(a.localStorage[`f7form-${r}`]="",a.localStorage.removeItem(`f7form-${r}`))}},Lr={init(e){const t=this,a=A(e),r=a.attr("id");if(!r)return;const s=t.form.getFormData(r);s&&t.form.fillFromData(a,s),a.on("change submit",(function(){const e=t.form.convertToData(a);e&&(t.form.storeFormData(r,e),a.trigger("form:storedata",e),t.emit("formStoreData",a[0],e))}))},destroy(e){A(e).off("change submit")}};function Dr(e){const t=A(e).eq(0);if(0===t.length)return;const a={},r=["submit","image","button","file"],s=[];return t.find("input, select, textarea").each((e=>{const o=A(e);if(o.hasClass("ignore-store-data")||o.hasClass("no-store-data"))return;const n=o.attr("name"),i=o.attr("type"),l=e.nodeName.toLowerCase();if(!(r.indexOf(i)>=0)&&!(s.indexOf(n)>=0)&&n)if("select"===l&&o.prop("multiple"))s.push(n),a[n]=[],t.find(`select[name="${n}"] option`).each((e=>{e.selected&&a[n].push(e.value)}));else switch(i){case"checkbox":s.push(n),a[n]=[],t.find(`input[name="${n}"]`).each((e=>{e.checked&&a[n].push(e.value)}));break;case"radio":s.push(n),t.find(`input[name="${n}"]`).each((e=>{e.checked&&(a[n]=e.value)}));break;default:a[n]=o.val()}})),t.trigger("form:todata",a),this.emit("formToData",t[0],a),a}function Ar(e,t){const a=this,r=A(e).eq(0);if(!r.length)return;let s=t;const o=r.attr("id");if(!s&&o&&(s=a.form.getFormData(o)),!s)return;const n=["submit","image","button","file"],i=[];r.find("input, select, textarea").each((e=>{const t=A(e);if(t.hasClass("ignore-store-data")||t.hasClass("no-store-data"))return;const a=t.attr("name"),o=t.attr("type"),l=e.nodeName.toLowerCase();if(void 0!==s[a]&&null!==s[a]&&!(n.indexOf(o)>=0)&&!(i.indexOf(a)>=0)&&a){if("select"===l&&t.prop("multiple"))i.push(a),r.find(`select[name="${a}"] option`).each((e=>{const t=e;s[a].indexOf(e.value)>=0?t.selected=!0:t.selected=!1}));else switch(o){case"checkbox":i.push(a),r.find(`input[name="${a}"]`).each((e=>{const t=e;s[a].indexOf(e.value)>=0?t.checked=!0:t.checked=!1}));break;case"radio":i.push(a),r.find(`input[name="${a}"]`).each((e=>{const t=e;s[a]===e.value?t.checked=!0:t.checked=!1}));break;default:t.val(s[a])}"select"!==l&&"input"!==l&&"textarea"!==l||t.trigger("change","fromdata")}})),r.trigger("form:fromdata",s),a.emit("formFromData",r[0],s)}function Rr(){const e=this,t=o(),a=r();A(a).on("submit change","form.form-ajax-submit, form.form-ajax-submit-onchange",(function(a,r){const s=A(this);if("change"===a.type&&!s.hasClass("form-ajax-submit-onchange"))return;if("submit"===a.type&&a.preventDefault(),"change"===a.type&&"fromdata"===r)return;const o=(s.attr("method")||"GET").toUpperCase(),n=s.attr("enctype")||s.prop("enctype");let i,l=s.attr("action");l&&("POST"===o?"application/x-www-form-urlencoded"===n||"application/json"===n?(i=e.form.convertToData(s[0]),"application/json"===n&&(i=JSON.stringify(i))):i=new t.FormData(s[0]):(i=ze(e.form.convertToData(s[0])),l.includes("?")?l+=`&${i}`:l+=`?${i}`),s.trigger("formajax:beforesend",{data:i}),e.emit("formAjaxBeforeSend",s[0],i),fetch(l,{method:o,headers:{"Content-Type":n||"application/x-www-form-urlencoded"},..."POST"===o||"PUT"===o?{body:i}:{}}).then((t=>{s.trigger("formajax:complete",{data:i,response:t}),e.emit("formAjaxComplete",s[0],i,t),s.trigger("formajax:success",{data:i,response:t}),e.emit("formAjaxSuccess",s[0],i,t)})).catch((t=>{s.trigger("formajax:error",{data:i,error:t}),e.emit("formAjaxError",s[0],i,t)})))}))}var Hr={name:"form",create(){const e=this;Fe(e,{form:{data:{},storeFormData:Br.store.bind(e),getFormData:Br.get.bind(e),removeFormData:Br.remove.bind(e),convertToData:Dr.bind(e),fillFromData:Ar.bind(e),storage:{init:Lr.init.bind(e),destroy:Lr.destroy.bind(e)}}})},on:{init(){Rr.call(this)},tabBeforeRemove(e){const t=this;A(e).find(".form-store-data").each((e=>{t.form.storage.destroy(e)}))},tabMounted(e){const t=this;A(e).find(".form-store-data").each((e=>{t.form.storage.init(e)}))},pageBeforeRemove(e){const t=this;e.$el.find(".form-store-data").each((e=>{t.form.storage.destroy(e)}))},pageInit(e){const t=this;e.$el.find(".form-store-data").each((e=>{t.form.storage.init(e)}))}}};const zr={ignoreTypes:["checkbox","button","submit","range","radio","image"],createTextareaResizableShadow(){const e=r(),t=A(e.createElement("textarea"));t.addClass("textarea-resizable-shadow"),t.prop({disabled:!0,readonly:!0}),zr.textareaResizableShadow=t},textareaResizableShadow:void 0,resizeTextarea(e){const t=this,a=o(),r=A(e);zr.textareaResizableShadow||zr.createTextareaResizableShadow();const s=zr.textareaResizableShadow;if(!r.length)return;if(!r.hasClass("resizable"))return;0===zr.textareaResizableShadow.parents().length&&t.$el.append(s);const n=a.getComputedStyle(r[0]);"padding-top padding-bottom padding-left padding-right margin-left margin-right margin-top margin-bottom width font-size font-family font-style font-weight line-height font-variant text-transform letter-spacing border box-sizing display".split(" ").forEach((e=>{let t=n[e];"font-size line-height letter-spacing width".split(" ").indexOf(e)>=0&&(t=t.replace(",",".")),s.css(e,t)}));const i=r[0].clientHeight;s.val("");const l=s[0].scrollHeight;s.val(r.val()),s.css("height",0);const c=s[0].scrollHeight;i!==c&&(c>l?r.css("height",`${c}px`):c<i&&r.css("height",""),(c>l||c<i)&&(r.trigger("textarea:resize",{initialHeight:l,currentHeight:i,scrollHeight:c}),t.emit("textareaResize",{initialHeight:l,currentHeight:i,scrollHeight:c})))},validate(e){const t=A(e);if(!t.length)return!0;const a=t.parents(".item-input"),r=t.parents(".input");function s(){t[0].f7ValidateReadonly&&(t[0].readOnly=!0)}t[0].f7ValidateReadonly&&(t[0].readOnly=!1);const o=t[0].validity,n=t.dataset().errorMessage||t[0].validationMessage||"";if(!o)return s(),!0;if(!o.valid){let e=t.nextAll(".item-input-error-message, .input-error-message");return n&&(0===e.length&&(e=A(`<div class="${r.length?"input-error-message":"item-input-error-message"}"></div>`),e.insertAfter(t)),e.text(n)),e.length>0&&(a.addClass("item-input-with-error-message"),r.addClass("input-with-error-message")),a.addClass("item-input-invalid"),r.addClass("input-invalid"),t.addClass("input-invalid"),s(),!1}return a.removeClass("item-input-invalid item-input-with-error-message"),r.removeClass("input-invalid input-with-error-message"),t.removeClass("input-invalid"),s(),!0},validateInputs(e){const t=this;return A(e).find("input, textarea, select").map((e=>t.input.validate(e))).indexOf(!1)<0},focus(e){const t=A(e),a=t.attr("type");zr.ignoreTypes.indexOf(a)>=0||(t.parents(".item-input").addClass("item-input-focused"),t.parents(".input").addClass("input-focused"),t.addClass("input-focused"))},blur(e){const t=A(e);t.parents(".item-input").removeClass("item-input-focused"),t.parents(".input").removeClass("input-focused"),t.removeClass("input-focused")},checkEmptyState(e){const t=this;let a=A(e);if(a.is("input, select, textarea, .item-input [contenteditable]")||(a=a.find("input, select, textarea, .item-input [contenteditable]").eq(0)),!a.length)return;let r;r=a[0].hasAttribute("contenteditable")?a.find(".text-editor-placeholder").length?"":a.html():a.val();const s=a.parents(".item-input"),o=a.parents(".input");r&&"string"==typeof r&&""!==r.trim()||Array.isArray(r)&&r.length>0?(s.addClass("item-input-with-value"),o.addClass("input-with-value"),a.addClass("input-with-value"),a.trigger("input:notempty"),t.emit("inputNotEmpty",a[0])):(s.removeClass("item-input-with-value"),o.removeClass("input-with-value"),a.removeClass("input-with-value"),a.trigger("input:empty"),t.emit("inputEmpty",a[0]))},scrollIntoView(e,t,a,r){void 0===t&&(t=0);const s=A(e),o=s.parents(".page-content, .panel, .card-expandable .card-content").eq(0);if(!o.length)return!1;const n=o[0].offsetHeight,i=o[0].scrollTop,l=parseInt(o.css("padding-top"),10),c=parseInt(o.css("padding-bottom"),10),p=o.offset().top-i,d=s.offset().top-p,u=d+i-l,h=d+i-n+c+s[0].offsetHeight,m=u+(h-u)/2;return i>u?(o.scrollTop(a?m:u,t),!0):i<h?(o.scrollTop(a?m:h,t),!0):(r&&o.scrollTop(a?m:h,t),!1)},init(){const e=this,t=rt(),a=o(),s=r();zr.createTextareaResizableShadow(),A(s).on("click",".input-clear-button",(function(){const t=A(this).siblings("input, textarea").eq(0),a=t.val();t.val("").trigger("input change").focus().trigger("input:clear",a),e.emit("inputClear",a)})),A(s).on("mousedown",".input-clear-button",(function(e){e.preventDefault()})),A(s).on("change input","input, textarea, select, .item-input [contenteditable]",(function(){const t=A(this),a=t.attr("type"),r=t[0].nodeName.toLowerCase(),s=t[0].hasAttribute("contenteditable");zr.ignoreTypes.indexOf(a)>=0||(e.input.checkEmptyState(t),s||(null!==t.attr("data-validate-on-blur")||!t.dataset().validate&&null===t.attr("validate")||e.input.validate(t),"textarea"===r&&t.hasClass("resizable")&&e.input.resizeTextarea(t)))}),!0),A(s).on("focus","input, textarea, select, .item-input [contenteditable]",(function(){const r=this;e.params.input.scrollIntoViewOnFocus&&(t.android?A(a).once("resize",(()=>{s&&s.activeElement===r&&e.input.scrollIntoView(r,e.params.input.scrollIntoViewDuration,e.params.input.scrollIntoViewCentered,e.params.input.scrollIntoViewAlways)})):e.input.scrollIntoView(r,e.params.input.scrollIntoViewDuration,e.params.input.scrollIntoViewCentered,e.params.input.scrollIntoViewAlways)),e.input.focus(r)}),!0),A(s).on("blur","input, textarea, select, .item-input [contenteditable]",(function(){const t=A(this),a=t[0].nodeName.toLowerCase();e.input.blur(t),(t.dataset().validate||null!==t.attr("validate")||null!==t.attr("data-validate-on-blur"))&&e.input.validate(t),"textarea"===a&&t.hasClass("resizable")&&zr.textareaResizableShadow&&zr.textareaResizableShadow.remove()}),!0),A(s).on("invalid","input, textarea, select",(function(t){const a=A(this);null!==a.attr("data-validate-on-blur")||!a.dataset().validate&&null===a.attr("validate")||(t.preventDefault(),e.input.validate(a))}),!0)}};var Nr={name:"input",params:{input:{scrollIntoViewOnFocus:void 0,scrollIntoViewCentered:!1,scrollIntoViewDuration:0,scrollIntoViewAlways:!1}},create(){const e=this;void 0===e.params.input.scrollIntoViewOnFocus&&(e.params.input.scrollIntoViewOnFocus=rt().android),Ke(e,{input:zr})},on:{init(){this.input.init()},tabMounted(e){const t=this,a=A(e);a.find(".item-input, .input").each((e=>{A(e).find("input, select, textarea, [contenteditable]").each((e=>{const a=A(e);zr.ignoreTypes.indexOf(a.attr("type"))>=0||t.input.checkEmptyState(a)}))})),a.find("textarea.resizable").each((e=>{t.input.resizeTextarea(e)}))},pageInit(e){const t=this,a=e.$el;a.find(".item-input, .input").each((e=>{A(e).find("input, select, textarea, [contenteditable]").each((e=>{const a=A(e);zr.ignoreTypes.indexOf(a.attr("type"))>=0||t.input.checkEmptyState(a)}))})),a.find("textarea.resizable").each((e=>{t.input.resizeTextarea(e)}))},"panelBreakpoint panelCollapsedBreakpoint panelResize panelOpen panelSwipeOpen resize viewMasterDetailBreakpoint":function(e){const t=this;e&&e.$el?e.$el.find("textarea.resizable").each((e=>{t.input.resizeTextarea(e)})):A("textarea.resizable").each((e=>{t.input.resizeTextarea(e)}))}}};let Vr=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r=tt(),s={};a.useModulesParams(s),a.params=Fe(s,t);const o=a.params.el;if(!o)return a;const n=A(o);if(0===n.length)return a;if(n[0].f7Toggle)return n[0].f7Toggle;const i=n.children('input[type="checkbox"]');let l;Fe(a,{app:e,$el:n,el:n[0],$inputEl:i,inputEl:i[0],disabled:n.hasClass("disabled")||i.hasClass("disabled")||i.attr("disabled")||i[0].disabled}),Object.defineProperty(a,"checked",{enumerable:!0,configurable:!0,set(e){a&&void 0!==a.$inputEl&&a.checked!==e&&(i[0].checked=e,a.$inputEl.trigger("change"))},get:()=>i[0].checked}),n[0].f7Toggle=a;const c={};let p,d,u,h,m;function f(e){l||a.disabled||(c.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,c.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,d=0,l=!0,p=void 0,h=Ae(),m=a.checked,u=n[0].offsetWidth,Le((()=>{l&&n.addClass("toggle-active-state")})))}function g(t){if(!l||a.disabled)return;const r="touchmove"===t.type?t.targetTouches[0].pageX:t.pageX,s="touchmove"===t.type?t.targetTouches[0].pageY:t.pageY,o=e.rtl?-1:1;if(void 0===p&&(p=!!(p||Math.abs(s-c.y)>Math.abs(r-c.x))),p)return void(l=!1);let n;t.preventDefault(),d=r-c.x,d*o<0&&Math.abs(d)>u/3&&m&&(n=!0),d*o>0&&Math.abs(d)>u/3&&!m&&(n=!0),n&&(c.x=r,a.checked=!m,m=!m)}function v(){if(!l||a.disabled)return p&&n.removeClass("toggle-active-state"),void(l=!1);const t=e.rtl?-1:1;let r;l=!1,n.removeClass("toggle-active-state"),Ae()-h<300&&(d*t<0&&m&&(r=!0),d*t>0&&!m&&(r=!0),r&&(a.checked=!m))}function b(){a.$el.trigger("toggle:change"),a.emit("local::change toggleChange",a)}a.attachEvents=function(){const t=!!r.passiveListener&&{passive:!0};n.on(e.touchEvents.start,f,t),e.on("touchmove",g),e.on("touchend:passive",v),a.$inputEl.on("change",b)},a.detachEvents=function(){const t=!!r.passiveListener&&{passive:!0};n.off(e.touchEvents.start,f,t),e.off("touchmove",g),e.off("touchend:passive",v),a.$inputEl.off("change",b)},a.useModules(),a.init()}toggle(){this.checked=!this.checked}init(){this.attachEvents()}destroy(){let e=this;e.$el.trigger("toggle:beforedestroy"),e.emit("local::beforeDestroy toggleBeforeDestroy",e),delete e.$el[0].f7Toggle,e.detachEvents(),Ie(e),e=null}};var Fr={name:"toggle",create(){this.toggle=nt({defaultSelector:".toggle",constructor:Vr,app:this,domProp:"f7Toggle"})},static:{Toggle:Vr},on:{tabMounted(e){const t=this;A(e).find(".toggle-init").each((e=>t.toggle.create({el:e})))},tabBeforeRemove(e){A(e).find(".toggle-init").each((e=>{e.f7Toggle&&e.f7Toggle.destroy()}))},pageInit(e){const t=this;e.$el.find(".toggle-init").each((e=>t.toggle.create({el:e})))},pageBeforeRemove(e){e.$el.find(".toggle-init").each((e=>{e.f7Toggle&&e.f7Toggle.destroy()}))}},vnode:{"toggle-init":{insert(e){const t=e.elm;this.toggle.create({el:t})},destroy(e){const t=e.elm;t.f7Toggle&&t.f7Toggle.destroy()}}}};let _r=class extends ot{constructor(e,t){super(t,[e]);const a=this,r=tt(),s={el:null,inputEl:null,dual:!1,step:1,label:!1,min:0,max:100,value:0,draggableBar:!0,vertical:!1,verticalReversed:!1,formatLabel:null,scale:!1,scaleSteps:5,scaleSubSteps:0,formatScaleLabel:null,limitKnobPosition:"ios"===e.theme};a.useModulesParams(s),a.params=Fe(s,t);const o=a.params.el;if(!o)return a;const n=A(o);if(0===n.length)return a;if(n[0].f7Range)return n[0].f7Range;const i=n.dataset();let l;"step min max value scaleSteps scaleSubSteps".split(" ").forEach((e=>{void 0===t[e]&&void 0!==i[e]&&(a.params[e]=parseFloat(i[e]))})),"dual label vertical verticalReversed scale".split(" ").forEach((e=>{void 0===t[e]&&void 0!==i[e]&&(a.params[e]=i[e])})),a.params.value||(void 0!==i.value&&(a.params.value=i.value),void 0!==i.valueLeft&&void 0!==i.valueRight&&(a.params.value=[parseFloat(i.valueLeft),parseFloat(i.valueRight)])),a.params.dual||(a.params.inputEl?l=A(a.params.inputEl):n.find('input[type="range"]').length&&(l=n.find('input[type="range"]').eq(0)));const{dual:c,step:p,label:d,min:u,max:h,value:m,vertical:f,verticalReversed:g,scale:v,scaleSteps:b,scaleSubSteps:w,limitKnobPosition:y}=a.params;Fe(a,{app:e,$el:n,el:n[0],$inputEl:l,inputEl:l?l[0]:void 0,dual:c,step:p,label:d,min:u,max:h,value:m,previousValue:m,vertical:f,verticalReversed:g,scale:v,scaleSteps:b,scaleSubSteps:w,limitKnobPosition:y}),l&&("step min max".split(" ").forEach((e=>{!t[e]&&l.attr(e)&&(a.params[e]=parseFloat(l.attr(e)),a[e]=parseFloat(l.attr(e)))})),void 0!==l.val()&&(a.params.value=parseFloat(l.val()),a.value=parseFloat(l.val()))),a.dual&&n.addClass("range-slider-dual"),a.label&&n.addClass("range-slider-label"),a.vertical?(n.addClass("range-slider-vertical"),a.verticalReversed&&n.addClass("range-slider-vertical-reversed")):n.addClass("range-slider-horizontal");const C=A('<div class="range-bar"></div>'),E=A('<div class="range-bar-active"></div>');C.append(E);const k=`\n      <div class="range-knob-wrap">\n        <div class="range-knob"></div>\n        ${a.label?'<div class="range-knob-label"></div>':""}\n      </div>\n    `,$=[A(k)];a.dual&&$.push(A(k)),n.append(C),$.forEach((e=>{n.append(e)}));const x=[];let T,S;a.label&&(x.push($[0].find(".range-knob-label")),a.dual&&x.push($[1].find(".range-knob-label"))),a.scale&&a.scaleSteps>=1&&(T=A(`\n        <div class="range-scale">\n          ${a.renderScale()}\n        </div>\n      `),n.append(T)),Fe(a,{knobs:$,labels:x,$barEl:C,$barActiveEl:E,$scaleEl:T}),n[0].f7Range=a;const P={};let M,O,I,B,L,D,R,H,z,N,V;function F(){R=!0}function _(e){if(S)return;if(!a.params.draggableBar&&0===A(e.target).closest(".range-knob").length)return;let t;R=!1,P.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,P.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,"touchstart"===e.type&&(H=e.targetTouches[0].identifier),S=!0,M=void 0,O=n.offset(),I=O.left,B=O.top,a.vertical?(t=(P.y-B)/a.rangeHeight,a.verticalReversed||(t=1-t)):t=a.app.rtl?(I+a.rangeWidth-P.x)/a.rangeWidth:(P.x-I)/a.rangeWidth;let r=t*(a.max-a.min)+a.min;a.dual?Math.abs(a.value[0]-r)<Math.abs(a.value[1]-r)?(D=0,L=a.knobs[0],r=[r,a.value[1]]):(D=1,L=a.knobs[1],r=[a.value[0],r]):(L=a.knobs[0],r=t*(a.max-a.min)+a.min),Le((()=>{S&&L.addClass("range-knob-active-state")}),70),a.on("change",F),a.setValue(r,!0)}function q(e){if(!S)return;let t,r,s;if("touchmove"===e.type)for(let a=0;a<e.targetTouches.length;a+=1)e.targetTouches[a].identifier===H&&(t=e.targetTouches[a].pageX,r=e.targetTouches[a].pageY);else t=e.pageX,r=e.pageY;if(void 0===t&&void 0===r)return;if(void 0!==M||a.vertical||(M=!!(M||Math.abs(r-P.y)>Math.abs(t-P.x))),M)return void(S=!1);e.preventDefault(),a.vertical?(s=(r-B)/a.rangeHeight,a.verticalReversed||(s=1-s)):s=a.app.rtl?(I+a.rangeWidth-t)/a.rangeWidth:(t-I)/a.rangeWidth;let o=s*(a.max-a.min)+a.min;if(a.dual){let e,t;0===D?(e=o,t=a.value[1],e>t&&(t=e)):(e=a.value[0],t=o,t<e&&(e=t)),o=[e,t]}a.setValue(o,!0)}function j(e){if("touchend"===e.type){let t;for(let a=0;a<e.changedTouches.length;a+=1)e.changedTouches[a].identifier===H&&(t=!0);if(!t)return}if(!S)return M&&L.removeClass("range-knob-active-state"),void(S=!1);a.off("change",F),S=!1,L.removeClass("range-knob-active-state"),R&&a.$inputEl&&!a.dual&&a.$inputEl.trigger("change"),R=!1,void 0!==a.previousValue&&(a.dual&&(a.previousValue[0]!==a.value[0]||a.previousValue[1]!==a.value[1])||!a.dual&&a.previousValue!==a.value)&&(a.$el.trigger("range:changed",a.value),a.emit("local::changed rangeChanged",a,a.value))}function Y(){a.calcSize(),a.layout()}return a.attachEvents=function(){const t=!!r.passiveListener&&{passive:!0};a.$el.on(e.touchEvents.start,_,t),e.on("touchmove",q),e.on("touchend:passive",j),e.on("tabShow",Y),e.on("resize",Y),z=a.$el.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast"),z.on("modal:open",Y),N=a.$el.parents(".panel"),N.on("panel:open panel:resize",Y),V=a.$el.parents(".page").eq(0),V.on("page:reinit",Y)},a.detachEvents=function(){const t=!!r.passiveListener&&{passive:!0};a.$el.off(e.touchEvents.start,_,t),e.off("touchmove",q),e.off("touchend:passive",j),e.off("tabShow",Y),e.off("resize",Y),z&&z.off("modal:open",Y),N&&N.off("panel:open panel:resize",Y),V&&V.off("page:reinit",Y),z=null,N=null,V=null},a.useModules(),a.init(),a}calcSize(){const e=this;if(e.vertical){const t=e.$el.outerHeight();if(0===t)return;e.rangeHeight=t,e.knobHeight=e.knobs[0].outerHeight()}else{const t=e.$el.outerWidth();if(0===t)return;e.rangeWidth=t,e.knobWidth=e.knobs[0].outerWidth()}}layout(){const e=this,{app:t,knobWidth:a,knobHeight:r,rangeWidth:s,rangeHeight:o,min:n,max:i,knobs:l,$barActiveEl:c,value:p,label:d,labels:u,vertical:h,verticalReversed:m,limitKnobPosition:f}=e,g=h?r:a,v=h?o:s,b=h?m?"top":"bottom":t.rtl?"right":"left";if(e.dual){const t=[(p[0]-n)/(i-n),(p[1]-n)/(i-n)];c.css({[b]:100*t[0]+"%",[h?"height":"width"]:100*(t[1]-t[0])+"%"}),l.forEach(((a,r)=>{let s=v*t[r];if(f){const e=v*t[r]-g/2;e<0&&(s=g/2),e+g>v&&(s=v-g/2)}a.css(b,`${s}px`),d&&u[r].text(e.formatLabel(p[r],u[r][0]))}))}else{const t=(p-n)/(i-n);c.css(h?"height":"width",100*t+"%");let a=v*t;if(f){const e=v*t-g/2;e<0&&(a=g/2),e+g>v&&(a=v-g/2)}l[0].css(b,`${a}px`),d&&u[0].text(e.formatLabel(p,u[0][0]))}e.dual&&p.indexOf(n)>=0||!e.dual&&p===n?e.$el.addClass("range-slider-min"):e.$el.removeClass("range-slider-min"),e.dual&&p.indexOf(i)>=0||!e.dual&&p===i?e.$el.addClass("range-slider-max"):e.$el.removeClass("range-slider-max")}setValue(e,t){const a=this,{step:r,min:s,max:o}=a;let n,i;if(a.dual){i=[a.value[0],a.value[1]];let t=e;if(Array.isArray(t)||(t=[e,e]),e[0]>e[1]&&(t=[t[0],t[0]]),t=t.map((e=>Math.max(Math.min(Math.round(e/r)*r,o),s))),t[0]===a.value[0]&&t[1]===a.value[1])return a;t.forEach(((e,t)=>{a.value[t]=e})),n=i[0]!==t[0]||i[1]!==t[1],a.layout()}else{i=a.value;const t=Math.max(Math.min(Math.round(e/r)*r,o),s);a.value=t,a.layout(),n=i!==t}return n&&(a.previousValue=i),n?(a.$el.trigger("range:change",a.value),a.$inputEl&&!a.dual&&(a.$inputEl.val(a.value),t?a.$inputEl.trigger("input"):a.$inputEl.trigger("input change")),t||(a.$el.trigger("range:changed",a.value),a.emit("local::changed rangeChanged",a,a.value)),a.emit("local::change rangeChange",a,a.value),a):a}getValue(){return this.value}formatLabel(e,t){const a=this;return a.params.formatLabel?a.params.formatLabel.call(a,e,t):e}formatScaleLabel(e){const t=this;return t.params.formatScaleLabel?t.params.formatScaleLabel.call(t,e):e}renderScale(){const e=this,{app:t,verticalReversed:a,vertical:r}=e,s=r?a?"top":"bottom":t.rtl?"right":"left";let o="";return Array.from({length:e.scaleSteps+1}).forEach(((t,a)=>{const r=(e.max-e.min)/e.scaleSteps,n=e.min+r*a,i=(n-e.min)/(e.max-e.min);o+=`<div class="range-scale-step" style="${s}: ${100*i}%">${e.formatScaleLabel(n)}</div>`,e.scaleSubSteps&&e.scaleSubSteps>1&&a<e.scaleSteps&&Array.from({length:e.scaleSubSteps-1}).forEach(((t,a)=>{const i=r/e.scaleSubSteps,l=(n+i*(a+1)-e.min)/(e.max-e.min);o+=`<div class="range-scale-step range-scale-substep" style="${s}: ${100*l}%"></div>`}))})),o}updateScale(){const e=this;if(!e.scale||e.scaleSteps<1)return e.$scaleEl&&e.$scaleEl.remove(),void delete e.$scaleEl;e.$scaleEl||(e.$scaleEl=A('<div class="range-scale"></div>'),e.$el.append(e.$scaleEl)),e.$scaleEl.html(e.renderScale())}init(){const e=this;return e.calcSize(),e.layout(),e.attachEvents(),e}destroy(){let e=this;e.$el.trigger("range:beforedestroy"),e.emit("local::beforeDestroy rangeBeforeDestroy",e),delete e.$el[0].f7Range,e.detachEvents(),Ie(e),e=null}};var qr={name:"range",create(){const e=this;e.range=Fe(nt({defaultSelector:".range-slider",constructor:_r,app:e,domProp:"f7Range"}),{getValue(t){void 0===t&&(t=".range-slider");const a=e.range.get(t);if(a)return a.getValue()},setValue(t,a){void 0===t&&(t=".range-slider");const r=e.range.get(t);if(r)return r.setValue(a)}})},static:{Range:_r},on:{tabMounted(e){const t=this;A(e).find(".range-slider-init").each((e=>new _r(t,{el:e})))},tabBeforeRemove(e){A(e).find(".range-slider-init").each((e=>{e.f7Range&&e.f7Range.destroy()}))},pageInit(e){const t=this;e.$el.find(".range-slider-init").each((e=>new _r(t,{el:e})))},pageBeforeRemove(e){e.$el.find(".range-slider-init").each((e=>{e.f7Range&&e.f7Range.destroy()}))}},vnode:{"range-slider-init":{insert(e){const t=e.elm;this.range.create({el:t})},destroy(e){const t=e.elm;t.f7Range&&t.f7Range.destroy()}}}};let jr=class extends ot{constructor(e,t){super(t,[e]);const a=this,r={el:null,inputEl:null,valueEl:null,value:0,formatValue:null,step:1,min:0,max:100,watchInput:!0,autorepeat:!1,autorepeatDynamic:!1,wraps:!1,manualInputMode:!1,decimalPoint:4,buttonsEndInputMode:!0};a.useModulesParams(r),a.params=Fe(r,t),a.params.value<a.params.min&&(a.params.value=a.params.min),a.params.value>a.params.max&&(a.params.value=a.params.max);const s=a.params.el;if(!s)return a;const o=A(s);if(0===o.length)return a;if(o[0].f7Stepper)return o[0].f7Stepper;let n,i;if(a.params.inputEl?n=A(a.params.inputEl):o.find(".stepper-input-wrap").find("input, textarea").length&&(n=o.find(".stepper-input-wrap").find("input, textarea").eq(0)),n&&n.length){"step min max".split(" ").forEach((e=>{!t[e]&&n.attr(e)&&(a.params[e]=parseFloat(n.attr(e)))}));const e=parseInt(a.params.decimalPoint,10);Number.isNaN(e)?a.params.decimalPoint=0:a.params.decimalPoint=e;const r=parseFloat(n.val());void 0!==t.value||Number.isNaN(r)||!r&&0!==r||(a.params.value=r)}a.params.valueEl?i=A(a.params.valueEl):o.find(".stepper-value").length&&(i=o.find(".stepper-value").eq(0));const l=o.find(".stepper-button-plus"),c=o.find(".stepper-button-minus"),{step:p,min:d,max:u,value:h,decimalPoint:m}=a.params;Fe(a,{app:e,$el:o,el:o[0],$buttonPlusEl:l,buttonPlusEl:l[0],$buttonMinusEl:c,buttonMinusEl:c[0],$inputEl:n,inputEl:n?n[0]:void 0,$valueEl:i,valueEl:i?i[0]:void 0,step:p,min:d,max:u,value:h,decimalPoint:m,typeModeChanged:!1}),o[0].f7Stepper=a;const f={};let g,v,b,w,y,C=null,E=!1,k=!1;function $(e,t,a,r,s,o){clearTimeout(y),y=setTimeout((()=>{1===e&&(b=!0,E=!0),clearInterval(w),o(),w=setInterval((()=>{o()}),s),e<t&&$(e+1,t,a,r,s/2,o)}),1===e?a:r)}function x(e){if(g)return;if(k)return;if(A(e.target).closest(l).length?C="increment":A(e.target).closest(c).length&&(C="decrement"),!C)return;f.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,f.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,g=!0,v=void 0;$(1,a.params.autorepeatDynamic?4:1,500,1e3,300,(()=>{a[C]()}))}function T(e){if(!g)return;if(k)return;const t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;void 0!==v||E||(v=!!(v||Math.abs(a-f.y)>Math.abs(t-f.x)));const r=((t-f.x)**2+(a-f.y)**2)**.5;(v||r>20)&&(g=!1,clearTimeout(y),clearInterval(w))}function S(){clearTimeout(y),clearInterval(w),C=null,E=!1,g=!1}function P(){k?a.params.buttonsEndInputMode&&(k=!1,a.endTypeMode(!0)):b?b=!1:a.decrement(!0)}function M(){k?a.params.buttonsEndInputMode&&(k=!1,a.endTypeMode(!0)):b?b=!1:a.increment(!0)}function O(e){!e.target.readOnly&&a.params.manualInputMode&&(k=!0,"number"==typeof e.target.selectionStart&&(e.target.selectionStart=e.target.value.length,e.target.selectionEnd=e.target.value.length))}function I(e){13!==e.keyCode&&13!==e.which||(e.preventDefault(),k=!1,a.endTypeMode())}function B(){k=!1,a.endTypeMode(!0)}function L(e){k?a.typeValue(e.target.value):e.detail&&e.detail.sentByF7Stepper||a.setValue(e.target.value,!0)}return a.attachEvents=function(){c.on("click",P),l.on("click",M),a.params.watchInput&&n&&n.length&&(n.on("input",L),n.on("click",O),n.on("blur",B),n.on("keyup",I)),a.params.autorepeat&&(e.on("touchstart:passive",x),e.on("touchmove:active",T),e.on("touchend:passive",S))},a.detachEvents=function(){c.off("click",P),l.off("click",M),a.params.watchInput&&n&&n.length&&(n.off("input",L),n.off("click",O),n.off("blur",B),n.off("keyup",I))},a.useModules(),a.init(),a}minus(){return this.decrement()}plus(){return this.increment()}decrement(){const e=this;return e.setValue(e.value-e.step,!1,!0)}increment(){const e=this;return e.setValue(e.value+e.step,!1,!0)}setValue(e,t,a){const r=this,{step:s,min:o,max:n}=r,i=r.value;let l=Math.round(e/s)*s;r.params.wraps&&a?(l>n&&(l=o),l<o&&(l=n)):l=Math.max(Math.min(l,n),o),Number.isNaN(l)&&(l=i),r.value=l;if(!(i!==l)&&!t)return r;r.$el.trigger("stepper:change",r.value);const c=r.formatValue(r.value);return r.$inputEl&&r.$inputEl.length&&(r.$inputEl.val(c),r.$inputEl.trigger("input change",{sentByF7Stepper:!0})),r.$valueEl&&r.$valueEl.length&&r.$valueEl.html(c),r.emit("local::change stepperChange",r,r.value),r}endTypeMode(e){const t=this,{min:a,max:r}=t;let s=parseFloat(t.value);if(Number.isNaN(s)&&(s=0),s=Math.max(Math.min(s,r),a),t.value=s,!t.typeModeChanged)return t.$inputEl&&t.$inputEl.length&&!e&&t.$inputEl.blur(),t;t.typeModeChanged=!1,t.$el.trigger("stepper:change",t.value);const o=t.formatValue(t.value);return t.$inputEl&&t.$inputEl.length&&(t.$inputEl.val(o),t.$inputEl.trigger("input change",{sentByF7Stepper:!0}),e||t.$inputEl.blur()),t.$valueEl&&t.$valueEl.length&&t.$valueEl.html(o),t.emit("local::change stepperChange",t,t.value),t}typeValue(e){const t=this;t.typeModeChanged=!0;let a=String(e);if(1===a.length&&"-"===a)return t;if(a.lastIndexOf(".")+1!==a.length&&a.lastIndexOf(",")+1!==a.length){let e=parseFloat(a.replace(",","."));if(0===e)return t.value=a.replace(",","."),t.$inputEl.val(t.value),t;if(Number.isNaN(e))return t.value=0,t.$inputEl.val(t.value),t;const r=10**t.params.decimalPoint;return e=Math.round(e*r).toFixed(t.params.decimalPoint+1)/r,t.value=parseFloat(String(e).replace(",",".")),t.$inputEl.val(t.value),t}return a.lastIndexOf(".")!==a.indexOf(".")||a.lastIndexOf(",")!==a.indexOf(",")?(a=a.slice(0,-1),t.value=a,t.$inputEl.val(t.value),t):(t.value=a,t.$inputEl.val(a),t)}getValue(){return this.value}formatValue(e){const t=this;return t.params.formatValue?t.params.formatValue.call(t,e):e}init(){const e=this;if(e.attachEvents(),e.$valueEl&&e.$valueEl.length){const t=e.formatValue(e.value);e.$valueEl.html(t)}return e}destroy(){let e=this;e.$el.trigger("stepper:beforedestroy"),e.emit("local::beforeDestroy stepperBeforeDestroy",e),delete e.$el[0].f7Stepper,e.detachEvents(),Ie(e),e=null}};var Yr={name:"stepper",create(){const e=this;e.stepper=Fe(nt({defaultSelector:".stepper",constructor:jr,app:e,domProp:"f7Stepper"}),{getValue(t){void 0===t&&(t=".stepper");const a=e.stepper.get(t);if(a)return a.getValue()},setValue(t,a){void 0===t&&(t=".stepper");const r=e.stepper.get(t);if(r)return r.setValue(a)}})},static:{Stepper:jr},on:{tabMounted(e){const t=this;A(e).find(".stepper-init").each((e=>{const a=A(e).dataset();t.stepper.create(Fe({el:e},a||{}))}))},tabBeforeRemove(e){A(e).find(".stepper-init").each((e=>{e.f7Stepper&&e.f7Stepper.destroy()}))},pageInit(e){const t=this;e.$el.find(".stepper-init").each((e=>{const a=A(e).dataset();t.stepper.create(Fe({el:e},a||{}))}))},pageBeforeRemove(e){e.$el.find(".stepper-init").each((e=>{e.f7Stepper&&e.f7Stepper.destroy()}))}},vnode:{"stepper-init":{insert(e){const t=e.elm,a=A(t).dataset();this.stepper.create(Fe({el:t},a||{}))},destroy(e){const t=e.elm;t.f7Stepper&&t.f7Stepper.destroy()}}}};const Wr=[{base:"A",letters:"AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"},{base:"AA",letters:"Ꜳ"},{base:"AE",letters:"ÆǼǢ"},{base:"AO",letters:"Ꜵ"},{base:"AU",letters:"Ꜷ"},{base:"AV",letters:"ꜸꜺ"},{base:"AY",letters:"Ꜽ"},{base:"B",letters:"BⒷＢḂḄḆɃƂƁ"},{base:"C",letters:"CⒸＣĆĈĊČÇḈƇȻꜾ"},{base:"D",letters:"DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"},{base:"DZ",letters:"ǱǄ"},{base:"Dz",letters:"ǲǅ"},{base:"E",letters:"EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"},{base:"F",letters:"FⒻＦḞƑꝻ"},{base:"G",letters:"GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"},{base:"H",letters:"HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"},{base:"I",letters:"IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"},{base:"J",letters:"JⒿＪĴɈ"},{base:"K",letters:"KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"},{base:"L",letters:"LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"},{base:"LJ",letters:"Ǉ"},{base:"Lj",letters:"ǈ"},{base:"M",letters:"MⓂＭḾṀṂⱮƜ"},{base:"N",letters:"NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"},{base:"NJ",letters:"Ǌ"},{base:"Nj",letters:"ǋ"},{base:"O",letters:"OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"},{base:"OI",letters:"Ƣ"},{base:"OO",letters:"Ꝏ"},{base:"OU",letters:"Ȣ"},{base:"OE",letters:"Œ"},{base:"oe",letters:"œ"},{base:"P",letters:"PⓅＰṔṖƤⱣꝐꝒꝔ"},{base:"Q",letters:"QⓆＱꝖꝘɊ"},{base:"R",letters:"RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"},{base:"S",letters:"SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"},{base:"T",letters:"TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"},{base:"TZ",letters:"Ꜩ"},{base:"U",letters:"UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"},{base:"V",letters:"VⓋＶṼṾƲꝞɅ"},{base:"VY",letters:"Ꝡ"},{base:"W",letters:"WⓌＷẀẂŴẆẄẈⱲ"},{base:"X",letters:"XⓍＸẊẌ"},{base:"Y",letters:"YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"},{base:"Z",letters:"ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"},{base:"a",letters:"aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"},{base:"aa",letters:"ꜳ"},{base:"ae",letters:"æǽǣ"},{base:"ao",letters:"ꜵ"},{base:"au",letters:"ꜷ"},{base:"av",letters:"ꜹꜻ"},{base:"ay",letters:"ꜽ"},{base:"b",letters:"bⓑｂḃḅḇƀƃɓ"},{base:"c",letters:"cⓒｃćĉċčçḉƈȼꜿↄ"},{base:"d",letters:"dⓓｄḋďḍḑḓḏđƌɖɗꝺ"},{base:"dz",letters:"ǳǆ"},{base:"e",letters:"eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"},{base:"f",letters:"fⓕｆḟƒꝼ"},{base:"g",letters:"gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"},{base:"h",letters:"hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"},{base:"hv",letters:"ƕ"},{base:"i",letters:"iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"},{base:"j",letters:"jⓙｊĵǰɉ"},{base:"k",letters:"kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"},{base:"l",letters:"lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"},{base:"lj",letters:"ǉ"},{base:"m",letters:"mⓜｍḿṁṃɱɯ"},{base:"n",letters:"nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"},{base:"nj",letters:"ǌ"},{base:"o",letters:"oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"},{base:"oi",letters:"ƣ"},{base:"ou",letters:"ȣ"},{base:"oo",letters:"ꝏ"},{base:"p",letters:"pⓟｐṕṗƥᵽꝑꝓꝕ"},{base:"q",letters:"qⓠｑɋꝗꝙ"},{base:"r",letters:"rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"},{base:"s",letters:"sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"},{base:"t",letters:"tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"},{base:"tz",letters:"ꜩ"},{base:"u",letters:"uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"},{base:"v",letters:"vⓥｖṽṿʋꝟʌ"},{base:"vy",letters:"ꝡ"},{base:"w",letters:"wⓦｗẁẃŵẇẅẘẉⱳ"},{base:"x",letters:"xⓧｘẋẍ"},{base:"y",letters:"yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"},{base:"z",letters:"zⓩｚźẑżžẓẕƶȥɀⱬꝣ"}],Xr={};for(let e=0;e<Wr.length;e+=1){const t=Wr[e].letters;for(let a=0;a<t.length;a+=1)Xr[t[a]]=Wr[e].base}function Ur(e){return e.replace(/[^\u0000-\u007E]/g,(e=>Xr[e]||e))}let Gr=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r=Fe({on:{}},e.params.smartSelect);a.useModulesParams(r),a.params=Fe({},r,t),a.app=e;const s=A(a.params.el).eq(0);if(0===s.length)return a;if(s[0].f7SmartSelect)return s[0].f7SmartSelect;const o=s.find("select").eq(0);if(0===o.length)return a;let n;a.params.setValueText&&(n=A(a.params.valueEl),0===n.length&&(n=s.find(".item-after")),0===n.length&&(n=A('<div class="item-after"></div>'),n.insertAfter(s.find(".item-title"))));let i=t.url;i||(s.attr("href")&&"#"!==s.attr("href")?i=s.attr("href"):o.attr("name")&&(i=`${o.attr("name").toLowerCase()}-select/`)),i||(i=a.params.url);const l=o[0].multiple,c=l?"checkbox":"radio",p=Se();function d(){a.open()}function u(){const e=a.$selectEl.val();a.$el.trigger("smartselect:change",e),a.emit("local::change smartSelectChange",a,e),a.vl&&a.vl.clearCache(),a.setValueText()}function h(){let e,t;const r=this,s=r.value;let o,n=[];if("checkbox"===r.type){for(let i=0;i<a.selectEl.options.length;i+=1)e=a.selectEl.options[i],e.value===s&&(e.selected=r.checked),e.selected&&(o=e.dataset?e.dataset.displayAs:A(e).data("display-value-as"),t=o&&void 0!==o?o:e.textContent,n.push(t.trim()));a.maxLength&&a.checkMaxLength()}else e=a.$selectEl.find(`option[value="${s}"]`)[0],e||(e=a.$selectEl.find("option").filter((e=>e.value===s))[0]),o=e.dataset?e.dataset.displayAs:A(e).data("display-as"),t=o&&void 0!==o?o:e.textContent,n=[t],a.selectEl.value=s;a.$selectEl.trigger("change"),a.params.setValueText&&a.formatValueTextContent(n),a.params.closeOnSelect&&"radio"===a.inputType&&a.close()}return Fe(a,{$el:s,el:s[0],$selectEl:o,selectEl:o[0],$valueEl:n,valueEl:n&&n[0],url:i,multiple:l,inputType:c,id:p,inputName:`${c}-${p}`,selectName:o.attr("name"),maxLength:o.attr("maxlength")||t.maxLength}),s[0].f7SmartSelect=a,a.attachEvents=function(){s.on("click",d),s.on("change","select",u)},a.detachEvents=function(){s.off("click",d),s.off("change","select",u)},a.attachInputsEvents=function(){a.$containerEl.on("change",'input[type="checkbox"], input[type="radio"]',h)},a.detachInputsEvents=function(){a.$containerEl.off("change",'input[type="checkbox"], input[type="radio"]',h)},a.useModules(),a.init(),a}setValue(e){const t=this;let a,r,s,o=e,n=[];if(t.multiple){Array.isArray(o)||(o=[o]);for(let e=0;e<t.selectEl.options.length;e+=1)a=t.selectEl.options[e],o.indexOf(a.value)>=0?a.selected=!0:a.selected=!1,a.selected&&(r=a.dataset?a.dataset.displayAs:A(a).data("display-value-as"),s=r&&void 0!==r?r:a.textContent,n.push(s.trim()))}else a=t.$selectEl.find(`option[value="${o}"]`)[0],a&&(r=a.dataset?a.dataset.displayAs:A(a).data("display-as"),s=r&&void 0!==r?r:a.textContent,n=[s]),t.selectEl.value=o;return t.params.setValueText&&t.formatValueTextContent(n),t.$selectEl.trigger("change"),t}unsetValue(){const e=this;e.params.setValueText&&e.formatValueTextContent([]),e.$selectEl.find("option").each((e=>{e.selected=!1,e.checked=!1})),e.$selectEl[0].value=null,e.$containerEl&&e.$containerEl.find(`input[name="${e.inputName}"][type="checkbox"], input[name="${e.inputName}"][type="radio"]`).prop("checked",!1),e.$selectEl.trigger("change")}getValue(){return this.$selectEl.val()}get view(){const{params:e,$el:t}=this;let a;if(e.view&&(a=e.view),a||(a=t.parents(".view").length&&t.parents(".view")[0].f7View),!a&&"page"===e.openIn)throw Error("Smart Select requires initialized View");return a}checkMaxLength(){const e=this,t=e.$containerEl;e.selectEl.selectedOptions.length>=e.maxLength?t.find('input[type="checkbox"]').each((e=>{e.checked?A(e).parents("li").removeClass("disabled"):A(e).parents("li").addClass("disabled")})):t.find(".disabled").removeClass("disabled")}formatValueTextContent(e){const t=this,a=t.formatValueText(e);a.includes("<")&&a.includes(">")?t.$valueEl.html(a):t.$valueEl.text(a)}formatValueText(e){const t=this;let a;return a=t.params.formatValueText?t.params.formatValueText.call(t,e,t):e.join(", "),a}setValueText(e){const t=this;let a=[];void 0!==e?a=Array.isArray(e)?e:[e]:t.$selectEl.find("option").each((e=>{const t=A(e);if(e.selected){const r=e.dataset?e.dataset.displayAs:t.data("display-value-as");r&&void 0!==r?a.push(r):a.push(e.textContent.trim())}})),t.params.setValueText&&t.formatValueTextContent(a)}getItemsData(){const e=this,t=e.app.theme,a=[];let r;return e.$selectEl.find("option").each((s=>{const o=A(s),n=o.dataset(),i=n.optionImage||e.params.optionImage,l=n.optionIcon||e.params.optionIcon,c="ios"===t&&(n.optionIconIos||e.params.optionIconIos),p="md"===t&&(n.optionIconMd||e.params.optionIconMd),d=n.inputIconPosition||e.params.inputIconPosition||"",u=i||l||c||p,h=n.optionColor;let m=n.optionClass||"";o[0].disabled&&(m+=" disabled");const f=o.parent("optgroup")[0],g=f&&f.label;let v=!1;f&&f!==r&&(v=!0,r=f,a.push({groupLabel:g,isLabel:v})),a.push({value:o[0].value,text:o[0].textContent.trim(),selected:o[0].selected,groupEl:f,groupLabel:g,image:i,icon:l,iconIos:c,iconMd:p,inputIconPosition:d,color:h,className:m,disabled:o[0].disabled,id:e.id,hasMedia:u,checkbox:"checkbox"===e.inputType,radio:"radio"===e.inputType,inputName:e.inputName,inputType:e.inputType})})),e.items=a,a}renderSearchbar(){const e=this;return e.params.renderSearchbar?e.params.renderSearchbar.call(e):ct("form",{class:"searchbar"},ct("div",{class:"searchbar-inner"},ct("div",{class:"searchbar-input-wrap"},ct("input",{type:"search",spellcheck:e.params.searchbarSpellcheck||"false",placeholder:e.params.searchbarPlaceholder}),ct("i",{class:"searchbar-icon"}),ct("span",{class:"input-clear-button"})),e.params.searchbarDisableButton&&ct("span",{class:"searchbar-disable-button"},e.params.searchbarDisableText)))}renderItem(e,t){const a=this;if(a.params.renderItem)return a.params.renderItem.call(a,e,t);let r;if(e.isLabel)r=`<li class="list-group-title">${e.groupLabel}</li>`;else{let t,o=e.selected;if(a.params.virtualList){const r=a.getValue();o=a.multiple?r.indexOf(e.value)>=0:r===e.value,a.multiple&&(t=a.multiple&&!o&&r.length===parseInt(a.maxLength,10))}const{icon:n,iconIos:i,iconMd:l}=e,c=n||i||l,p=(void 0===(s=n||i||l||"")&&(s=""),s.indexOf(":")>=0?s.split(":")[1]:""),d=function(e){if(void 0===e&&(e=""),e.indexOf(":")>=0){let t=e.split(":")[0];return"f7"===t&&(t="f7-icons"),"material"===t&&(t="material-icons"),t}return e}(n||i||l||"");r=ct("li",{class:`${e.className||""}${t?" disabled":""}`},ct("label",{class:`item-${e.inputType} ${e.inputIconPosition?`item-${e.inputType}-icon-${e.inputIconPosition}`:""} item-content`},ct("input",{type:e.inputType,name:e.inputName,value:e.value,_checked:o}),ct("i",{class:`icon icon-${e.inputType}`}),e.hasMedia&&ct("div",{class:"item-media"},c&&ct("i",{class:`icon ${d}`},p),e.image&&ct("img",{src:e.image})),ct("div",{class:"item-inner"},ct("div",{class:"item-title"+(e.color?` text-color-${e.color}`:"")},e.text))))}var s;return r}renderItems(){const e=this;if(e.params.renderItems)return e.params.renderItems.call(e,e.items);const t=`\n      ${e.items.map(((t,a)=>`${e.renderItem(t,a)}`)).join("")}\n    `;return t}renderPage(){const e=this;if(e.params.renderPage)return e.params.renderPage.call(e,e.items);let t=e.params.pageTitle;if(void 0===t){const a=e.$el.find(".item-title");t=a.length?a.text().trim():""}const a=e.params.cssClass;return ct("div",{class:`page smart-select-page ${a}`,"data-name":"smart-select-page","data-select-name":e.selectName},ct("div",{class:"navbar "+(e.params.navbarColorTheme?`color-${e.params.navbarColorTheme}`:"")},ct("div",{class:"navbar-bg"}),ct("div",{class:"navbar-inner sliding "+(e.params.navbarColorTheme?`color-${e.params.navbarColorTheme}`:"")},ct("div",{class:"left"},ct("a",{class:"link back"},ct("i",{class:"icon icon-back"}),ct("span",{class:"if-not-md"},e.params.pageBackLinkText))),t&&ct("div",{class:"title"},t),e.params.searchbar&&ct("div",{class:"subnavbar"},e.renderSearchbar()))),e.params.searchbar&&ct("div",{class:"searchbar-backdrop"}),ct("div",{class:"page-content"},ct("div",{class:`list list-outline-ios list-strong-ios list-dividers-ios smart-select-list-${e.id} ${e.params.virtualList?" virtual-list":""} ${e.params.formColorTheme?`color-${e.params.formColorTheme}`:""}`},ct("ul",null,!e.params.virtualList&&e.renderItems(e.items)))))}renderPopup(){const e=this;if(e.params.renderPopup)return e.params.renderPopup.call(e,e.items);let t=e.params.pageTitle;if(void 0===t){const a=e.$el.find(".item-title");t=a.length?a.text().trim():""}const a=e.params.cssClass||"";return ct("div",{class:`popup smart-select-popup ${a} ${e.params.popupTabletFullscreen?"popup-tablet-fullscreen":""}`,"data-select-name":e.selectName},ct("div",{class:"view"},ct("div",{class:"page smart-select-page "+(e.params.searchbar?"page-with-subnavbar":""),"data-name":"smart-select-page"},ct("div",{class:"navbar "+(e.params.navbarColorTheme?`color-${e.params.navbarColorTheme}`:"")},ct("div",{class:"navbar-bg"}),ct("div",{class:"navbar-inner sliding"},t&&ct("div",{class:"title"},t),ct("div",{class:"right"},ct("a",{class:"link popup-close","data-popup":`.smart-select-popup[data-select-name='${e.selectName}']`},e.params.popupCloseLinkText)),e.params.searchbar&&ct("div",{class:"subnavbar"},e.renderSearchbar()))),e.params.searchbar&&ct("div",{class:"searchbar-backdrop"}),ct("div",{class:"page-content"},ct("div",{class:`list list-outline-ios list-strong-ios list-dividers-ios smart-select-list-${e.id} ${e.params.virtualList?" virtual-list":""} ${e.params.formColorTheme?`color-${e.params.formColorTheme}`:""}`},ct("ul",null,!e.params.virtualList&&e.renderItems(e.items)))))))}renderSheet(){const e=this;if(e.params.renderSheet)return e.params.renderSheet.call(e,e.items);const t=e.params.cssClass;return ct("div",{class:`sheet-modal smart-select-sheet ${t}`,"data-select-name":e.selectName},ct("div",{class:"toolbar toolbar-top "+(e.params.toolbarColorTheme?`color-${e.params.toolbarColorTheme}`:"")},ct("div",{class:"toolbar-inner"},ct("div",{class:"left"}),ct("div",{class:"right"},ct("a",{class:"link sheet-close"},e.params.sheetCloseLinkText)))),ct("div",{class:"sheet-modal-inner"},ct("div",{class:"page-content"},ct("div",{class:`list list-strong-ios list-dividers-ios smart-select-list-${e.id} ${e.params.virtualList?" virtual-list":""} ${e.params.formColorTheme?`color-${e.params.formColorTheme}`:""}`},ct("ul",null,!e.params.virtualList&&e.renderItems(e.items))))))}renderPopover(){const e=this;if(e.params.renderPopover)return e.params.renderPopover.call(e,e.items);const t=e.params.cssClass;return ct("div",{class:`popover smart-select-popover ${t}`,"data-select-name":e.selectName},ct("div",{class:"popover-inner"},ct("div",{class:`list list-strong-ios list-dividers-ios smart-select-list-${e.id} ${e.params.virtualList?" virtual-list":""} ${e.params.formColorTheme?`color-${e.params.formColorTheme}`:""}`},ct("ul",null,!e.params.virtualList&&e.renderItems(e.items)))))}scrollToSelectedItem(){const e=this,{params:t,$containerEl:a}=e;if(!e.opened)return e;if(t.virtualList){let t;e.vl.items.forEach(((e,a)=>{void 0===t&&e.selected&&(t=a)})),void 0!==t&&e.vl.scrollToItem(t)}else{const t=a.find("input:checked").parents("li");if(!t.length)return e;const r=a.find(".page-content, .popover-inner");if(!r.length)return e;r.scrollTop(t.offset().top-r.offset().top-parseInt(r.css("padding-top"),10))}return e}onOpen(e,t){const a=this,r=a.app,s=A(t);if(a.$containerEl=s,a.openedIn=e,a.opened=!0,a.params.virtualList&&(a.vl=r.virtualList.create({el:s.find(".virtual-list"),items:a.items,renderItem:a.renderItem.bind(a),height:a.params.virtualListHeight,searchByItem:(e,t)=>!!(t.text&&Ur(t.text).toLowerCase().indexOf(e.trim().toLowerCase())>=0)})),a.params.scrollToSelectedItem&&a.scrollToSelectedItem(),a.params.searchbar){let t=s.find(".searchbar");if("page"===e&&"ios"===r.theme&&(t=A(r.navbar.getElByPage(s)).find(".searchbar")),a.params.appendSearchbarNotFound&&("page"===e||"popup"===e)){let e=null;e="string"==typeof a.params.appendSearchbarNotFound?A(`<div class="block searchbar-not-found">${a.params.appendSearchbarNotFound}</div>`):"boolean"==typeof a.params.appendSearchbarNotFound?A('<div class="block searchbar-not-found">Nothing found</div>'):a.params.appendSearchbarNotFound,e&&s.find(".page-content").append(e[0])}const o=Fe({el:t,backdropEl:s.find(".searchbar-backdrop"),searchContainer:`.smart-select-list-${a.id}`,searchIn:".item-title"},"object"==typeof a.params.searchbar?a.params.searchbar:{});a.searchbar=r.searchbar.create(o)}a.maxLength&&a.checkMaxLength(),a.params.closeOnSelect&&a.$containerEl.find(`input[type="radio"][name="${a.inputName}"]:checked`).parents("label").once("click",(()=>{a.close()})),a.attachInputsEvents(),a.$el.trigger("smartselect:open"),a.emit("local::open smartSelectOpen",a)}onOpened(){const e=this;e.$el.trigger("smartselect:opened"),e.emit("local::opened smartSelectOpened",e)}onClose(){const e=this;e.destroyed||(e.vl&&e.vl.destroy&&(e.vl.destroy(),e.vl=null,delete e.vl),e.searchbar&&e.searchbar.destroy&&(e.searchbar.destroy(),e.searchbar=null,delete e.searchbar),e.detachInputsEvents(),e.$el.trigger("smartselect:close"),e.emit("local::close smartSelectClose",e))}onClosed(){const e=this;e.destroyed||(e.opened=!1,e.$containerEl=null,delete e.$containerEl,e.$el.trigger("smartselect:closed"),e.emit("local::closed smartSelectClosed",e))}openPage(){const e=this;if(e.opened)return e;e.getItemsData();const t=e.renderPage(e.items);return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn(t,a){e.onOpen("page",a.el)},pageAfterIn(t,a){e.onOpened("page",a.el)},pageBeforeOut(t,a){e.onClose("page",a.el)},pageAfterOut(t,a){e.onClosed("page",a.el)}}}}),e}openPopup(){const e=this;if(e.opened)return e;e.getItemsData();const t={content:e.renderPopup(e.items),push:e.params.popupPush,swipeToClose:e.params.popupSwipeToClose,closeByBackdropClick:e.params.closeByBackdropClick,on:{popupOpen(t){e.onOpen("popup",t.el)},popupOpened(t){e.onOpened("popup",t.el)},popupClose(t){e.onClose("popup",t.el)},popupClosed(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e}openSheet(){const e=this;if(e.opened)return e;e.getItemsData();const t={content:e.renderSheet(e.items),backdrop:e.params.sheetBackdrop,scrollToEl:e.$el,closeByOutsideClick:!0,push:e.params.sheetPush,swipeToClose:e.params.sheetSwipeToClose,closeByBackdropClick:e.params.closeByBackdropClick,on:{sheetOpen(t){e.onOpen("sheet",t.el)},sheetOpened(t){e.onOpened("sheet",t.el)},sheetClose(t){e.onClose("sheet",t.el)},sheetClosed(t){e.onClosed("sheet",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,sheet:t}}):e.modal=e.app.sheet.create(t).open(),e}openPopover(){const e=this;if(e.opened)return e;e.getItemsData();const t={content:e.renderPopover(e.items),targetEl:e.$el,closeByBackdropClick:e.params.closeByBackdropClick,on:{popoverOpen(t){e.onOpen("popover",t.el)},popoverOpened(t){e.onOpened("popover",t.el)},popoverClose(t){e.onClose("popover",t.el)},popoverClosed(t){e.onClosed("popover",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popover:t}}):e.modal=e.app.popover.create(t).open(),e}open(e){const t=this;if(t.opened)return t;let a=!1;function r(){a=!0}if(t.$el&&t.$el.trigger("smartselect:beforeopen",{prevent:r}),t.emit("local::beforeOpen smartSelectBeforeOpen",t,r),a)return t;return t[`open${(e||t.params.openIn).split("").map(((e,t)=>0===t?e.toUpperCase():e)).join("")}`](),t}close(){const e=this;return e.opened?(e.params.routableModals&&e.view||"page"===e.openedIn?e.view.router.back():(e.modal.once("modalClosed",(()=>{Le((()=>{e.destroyed||(e.modal.destroy(),delete e.modal)}))})),e.modal.close()),e):e}init(){this.attachEvents(),this.setValueText()}destroy(){const e=this;e.emit("local::beforeDestroy smartSelectBeforeDestroy",e),e.$el.trigger("smartselect:beforedestroy"),e.detachEvents(),delete e.$el[0].f7SmartSelect,Ie(e),e.destroyed=!0}};var Kr={name:"smartSelect",params:{smartSelect:{el:void 0,valueEl:void 0,setValueText:!0,formatValueText:null,openIn:"page",popupPush:!1,popupSwipeToClose:void 0,sheetPush:!1,sheetSwipeToClose:void 0,sheetBackdrop:!1,pageTitle:void 0,pageBackLinkText:"Back",popupCloseLinkText:"Close",popupTabletFullscreen:!1,closeByBackdropClick:!0,sheetCloseLinkText:"Done",searchbar:!1,searchbarPlaceholder:"Search",searchbarDisableText:"Cancel",searchbarDisableButton:!0,searchbarSpellcheck:!1,closeOnSelect:!1,virtualList:!1,virtualListHeight:void 0,scrollToSelectedItem:!1,formColorTheme:void 0,navbarColorTheme:void 0,routableModals:!1,url:"select/",inputIconPosition:"start",cssClass:"",renderPage:void 0,renderPopup:void 0,renderSheet:void 0,renderPopover:void 0,renderItems:void 0,renderItem:void 0,renderSearchbar:void 0}},static:{SmartSelect:Gr},create(){const e=this;e.smartSelect=Fe(nt({defaultSelector:".smart-select",constructor:Gr,app:e,domProp:"f7SmartSelect"}),{open(t){const a=e.smartSelect.get(t);if(a&&a.open)return a.open()},close(t){const a=e.smartSelect.get(t);if(a&&a.close)return a.close()}})},on:{tabMounted(e){const t=this;A(e).find(".smart-select-init").each((e=>{t.smartSelect.create(Fe({el:e},A(e).dataset()))}))},tabBeforeRemove(e){A(e).find(".smart-select-init").each((e=>{e.f7SmartSelect&&e.f7SmartSelect.destroy&&e.f7SmartSelect.destroy()}))},pageInit(e){const t=this;e.$el.find(".smart-select-init").each((e=>{t.smartSelect.create(Fe({el:e},A(e).dataset()))}))},pageBeforeRemove(e){e.$el.find(".smart-select-init").each((e=>{e.f7SmartSelect&&e.f7SmartSelect.destroy&&e.f7SmartSelect.destroy()}))}},clicks:{".smart-select":function(e,t){const a=this;if(!e[0].f7SmartSelect){a.smartSelect.create(Fe({el:e},t)).open()}}},vnode:{"smart-select-init":{insert(e){const t=e.elm;this.smartSelect.create(Fe({el:t},A(t).dataset()))},destroy(e){const t=e.elm;t.f7SmartSelect&&t.f7SmartSelect.destroy&&t.f7SmartSelect.destroy()}}}};let Qr=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this;let r,s;if(a.params=Fe({},e.params.calendar,t),a.params.containerEl&&(r=A(a.params.containerEl),0===r.length))return a;a.params.inputEl&&(s=A(a.params.inputEl));const o="horizontal"===a.params.direction;let n=1;o&&(n=e.rtl?-1:1),Fe(a,{app:e,$containerEl:r,containerEl:r&&r[0],inline:r&&r.length>0,$inputEl:s,inputEl:s&&s[0],initialized:!1,opened:!1,url:a.params.url,isHorizontal:o,inverter:n,animating:!1,allowTouchMove:!0,hasTimePicker:a.params.timePicker&&!a.params.rangePicker&&!a.params.multiple}),a.dayFormatter=e=>new Intl.DateTimeFormat(a.params.locale,{day:"numeric"}).format(e).replace(/日/,""),a.monthFormatter=e=>new Intl.DateTimeFormat(a.params.locale,{month:"long"}).format(e),a.yearFormatter=e=>new Intl.DateTimeFormat(a.params.locale,{year:"numeric"}).format(e),a.timeSelectorFormatter=e=>new Intl.DateTimeFormat(a.params.locale,a.params.timePickerFormat).format(e);const i=a.timeSelectorFormatter(new Date).toLowerCase();a.is12HoursFormat=i.indexOf("pm")>=0||i.indexOf("am")>=0;let{monthNames:l,monthNamesShort:c,dayNames:p,dayNamesShort:d}=a.params;const{monthNamesIntl:u,monthNamesShortIntl:h,dayNamesIntl:m,dayNamesShortIntl:f}=a.getIntlNames();function g(){a.open()}function v(e){e.preventDefault()}function b(){a.setValue([]),a.opened&&a.update()}function w(e){const t=A(e.target);!a.destroyed&&a.params&&(a.isPopover()||a.opened&&!a.closing&&(t.closest('[class*="backdrop"]').length||a.monthPickerPopover||a.yearPickerPopover||a.timePickerPopover||(s&&s.length>0?t[0]!==s[0]&&0===t.closest(".sheet-modal, .calendar-modal").length&&a.close():0===A(e.target).closest(".sheet-modal, .calendar-modal").length&&a.close())))}return"auto"===l&&(l=u),"auto"===c&&(c=h),"auto"===p&&(p=m),"auto"===d&&(d=f),Fe(a,{monthNames:l,monthNamesShort:c,dayNames:p,dayNamesShort:d}),Fe(a,{attachInputEvents(){a.$inputEl.on("click",g),a.$inputEl.on("input:clear",b),a.params.inputReadOnly&&(a.$inputEl.on("focus mousedown",v),a.$inputEl[0]&&(a.$inputEl[0].f7ValidateReadonly=!0))},detachInputEvents(){a.$inputEl.off("click",g),a.$inputEl.off("input:clear",b),a.params.inputReadOnly&&(a.$inputEl.off("focus mousedown",v),a.$inputEl[0]&&delete a.$inputEl[0].f7ValidateReadonly)},attachHtmlEvents(){e.on("click",w)},detachHtmlEvents(){e.off("click",w)}}),a.attachCalendarEvents=function(){let t,r,s,o,n,i,l,c,p,d,u,h,m,f,g=!0;const{$el:v,$wrapperEl:b}=a;function w(e){r||t||!e.isTrusted||(t=!0,s="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,n=s,o="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,i=o,l=(new Date).getTime(),h=0,g=!0,f=void 0,p=a.monthsTranslate)}function y(e){if(!t||!e.isTrusted)return;const{isHorizontal:l}=a;n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,i="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,void 0===f&&(f=!!(f||Math.abs(i-o)>Math.abs(n-s))),l&&f||!a.allowTouchMove?t=!1:(e.preventDefault(),a.animating?t=!1:(g=!1,r||(r=!0,d=b[0].offsetWidth,u=b[0].offsetHeight,b.transition(0)),m=l?n-s:i-o,h=m/(l?d:u),p=100*(a.monthsTranslate*a.inverter+h),b.transform(`translate3d(${l?p:0}%, ${l?0:p}%, 0)`)))}function C(s){if(!t||!r||!s.isTrusted)return t=!1,void(r=!1);t=!1,r=!1,c=(new Date).getTime(),c-l<300?Math.abs(m)<10?a.resetMonth():m>=10?e.rtl?a.nextMonth():a.prevMonth():e.rtl?a.prevMonth():a.nextMonth():h<=-.5?e.rtl?a.prevMonth():a.nextMonth():h>=.5?e.rtl?a.nextMonth():a.prevMonth():a.resetMonth(),setTimeout((()=>{g=!0}),100)}function E(e){if(!g)return;let t=A(e.target).parents(".calendar-day");if(0===t.length&&A(e.target).hasClass("calendar-day")&&(t=A(e.target)),0===t.length)return;if(t.hasClass("calendar-day-disabled"))return;a.params.rangePicker||(t.hasClass("calendar-day-next")&&a.nextMonth(),t.hasClass("calendar-day-prev")&&a.prevMonth());const r=parseInt(t.attr("data-year"),10),s=parseInt(t.attr("data-month"),10),o=parseInt(t.attr("data-day"),10);if(a.emit("local::dayClick calendarDayClick",a,t[0],r,s,o),!t.hasClass("calendar-day-selected")||a.params.multiple||a.params.rangePicker){const e=new Date(r,s,o,0,0,0);a.hasTimePicker&&(a.value&&a.value[0]?e.setHours(a.value[0].getHours(),a.value[0].getMinutes()):e.setHours((new Date).getHours(),(new Date).getMinutes())),a.addValue(e)}a.params.closeOnSelect&&(a.params.rangePicker&&2===a.value.length||!a.params.rangePicker)&&a.close()}function k(){a.nextMonth()}function $(){a.prevMonth()}function x(){a.nextYear()}function T(){a.prevYear()}function S(){a.openMonthPicker()}function P(){a.openYearPicker()}function M(){a.openTimePicker()}const O=!("touchstart"!==e.touchEvents.start||!tt().passiveListener)&&{passive:!0,capture:!1};v.find(".calendar-prev-month-button").on("click",$),v.find(".calendar-next-month-button").on("click",k),v.find(".calendar-prev-year-button").on("click",T),v.find(".calendar-next-year-button").on("click",x),a.params.monthPicker&&v.find(".current-month-value").on("click",S),a.params.yearPicker&&v.find(".current-year-value").on("click",P),a.hasTimePicker&&v.find(".calendar-time-selector a").on("click",M),b.on("click",E),a.params.touchMove&&(b.on(e.touchEvents.start,w,O),e.on("touchmove:active",y),e.on("touchend:passive",C)),a.detachCalendarEvents=function(){v.find(".calendar-prev-month-button").off("click",$),v.find(".calendar-next-month-button").off("click",k),v.find(".calendar-prev-year-button").off("click",T),v.find(".calendar-next-year-button").off("click",x),a.params.monthPicker&&v.find(".current-month-value").off("click",S),a.params.yearPicker&&v.find(".current-year-value").off("click",P),a.hasTimePicker&&v.find(".calendar-time-selector a").off("click",M),b.off("click",E),a.params.touchMove&&(b.off(e.touchEvents.start,w,O),e.off("touchmove:active",y),e.off("touchend:passive",C))}},a.init(),a}get view(){const{$inputEl:e,app:t,params:a}=this;let r;return a.view?r=a.view:e&&(r=e.parents(".view").length&&e.parents(".view")[0].f7View),r||(r=t.views.main),r}getIntlNames(){const e=this,t=e.params.locale,a=[],r=[],s=[],o=[],n=new Intl.DateTimeFormat(t,{month:"long"}),i=new Intl.DateTimeFormat(t,{month:"short"}),l=new Intl.DateTimeFormat(t,{weekday:"long"}),c=new Intl.DateTimeFormat(t,{weekday:"short"});let p,d,u;for(let t=0;t<24;t+=1){const s=(new Date).setMonth(t,1),o=e.yearFormatter(s);p&&o!==p&&(d&&(u=!0),d=!0,p=o),p||(p=o),d&&p===o&&!u&&(a.push(n.format(s)),r.push(i.format(s)))}const h=(new Date).getDay();for(let e=0;e<7;e+=1){const t=(new Date).getTime()+24*(e-h)*60*60*1e3;s.push(l.format(t)),o.push(c.format(t))}return{monthNamesIntl:a,monthNamesShortIntl:r,dayNamesIntl:s,dayNamesShortIntl:o}}normalizeDate(e){const t=new Date(e);return this.hasTimePicker?new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes()):new Date(t.getFullYear(),t.getMonth(),t.getDate())}normalizeValues(e){const t=this;let a=[];return e&&Array.isArray(e)&&(a=e.map((e=>t.normalizeDate(e)))),a}initInput(){const e=this;e.$inputEl&&e.params.inputReadOnly&&e.$inputEl.prop("readOnly",!0)}isPopover(){const e=this,{app:t,modal:a,params:r}=e,s=rt();if("sheet"===r.openIn)return!1;if(a&&"popover"!==a.type)return!1;if(!e.inline&&e.inputEl){if("popover"===r.openIn)return!0;if(s.ios)return!!s.ipad;if(t.width>=768)return!0}return!1}formatDate(e){const t=this,a=new Date(e),r=a.getFullYear(),s=a.getMonth(),o=s+1,n=a.getDate(),i=a.getDay(),{monthNames:l,monthNamesShort:c,dayNames:p,dayNamesShort:d}=t,{dateFormat:u,locale:h}=t.params;function m(e){return e<10?`0${e}`:e}if("string"==typeof u){const e={yyyy:r,yy:String(r).substring(2),mm:m(o),m:o,MM:l[s],M:c[s],dd:m(n),d:n,DD:p[i],D:d[i]};if(t.params.timePicker){const t=a.getHours(),r=a.getMinutes(),s=a.getSeconds();let o=t;t>12&&(o=t-12),0===t&&(o=12);const n=t>=12&&0!==t?"pm":"am";Object.assign(e,{HH:m(t),H:t,hh:m(o),h:o,ss:m(s),s:s,":mm":m(r),":m":r,a:n,A:n.toUpperCase()})}const h=new RegExp(Object.keys(e).map((e=>`(${e})`)).join("|"),"g");return u.replace(h,(t=>t in e?e[t]:t))}if("function"==typeof u)return u(a);return new Intl.DateTimeFormat(h,u).format(a)}formatValue(){const e=this,{value:t}=e;return e.params.formatValue?e.params.formatValue.call(e,t):t.map((t=>e.formatDate(t))).join(e.params.rangePicker?" - ":", ")}addValue(e){const t=this,{multiple:a,rangePicker:r,rangePickerMinDays:s,rangePickerMaxDays:o}=t.params;if(a){let a;t.value||(t.value=[]);for(let r=0;r<t.value.length;r+=1)new Date(e).getTime()===new Date(t.value[r]).getTime()&&(a=r);void 0===a?t.value.push(e):t.value.splice(a,1),t.updateValue()}else r?(t.value||(t.value=[]),2!==t.value.length&&0!==t.value.length||(t.value=[]),0===t.value.length||Math.abs(t.value[0].getTime()-e.getTime())>=60*(s-1)*60*24*1e3&&(0===o||Math.abs(t.value[0].getTime()-e.getTime())<=60*(o-1)*60*24*1e3)?t.value.push(e):t.value=[],t.value.sort(((e,t)=>e-t)),t.updateValue()):(t.value=[e],t.updateValue())}setValue(e){const t=this,a=t.value;if(Array.isArray(a)&&Array.isArray(e)&&a.length===e.length){let t=!0;if(a.forEach(((a,r)=>{a!==e[r]&&(t=!1)})),t)return}t.value=e,t.updateValue()}getValue(){return this.value}updateValue(e){const t=this,{$el:a,$wrapperEl:r,$inputEl:s,value:o,params:n}=t;let i;if(a&&a.length>0){let e;if(r.find(".calendar-day-selected").removeClass("calendar-day-selected calendar-day-selected-range calendar-day-selected-left calendar-day-selected-right"),n.rangePicker&&2===o.length){const t=new Date(o[0]).getTime(),a=new Date(o[1]).getTime();for(i=t;i<=a;i+=864e5){e=new Date(i);let s="calendar-day-selected";t!==a&&(i!==t&&i!==a&&(s+=" calendar-day-selected-range"),i===t&&(s+=" calendar-day-selected-left"),i===a&&(s+=" calendar-day-selected-right")),r.find(`.calendar-day[data-date="${e.getFullYear()}-${e.getMonth()}-${e.getDate()}"]`).addClass(s)}e=new Date(t),r.find(`.calendar-day[data-date="${e.getFullYear()}-${e.getMonth()}-${e.getDate()}"]`).removeClass("calendar-day-selected-range").addClass("calendar-day-selected calendar-day-selected-left"),e=new Date(a),r.find(`.calendar-day[data-date="${e.getFullYear()}-${e.getMonth()}-${e.getDate()}"]`).removeClass("calendar-day-selected-range").addClass("calendar-day-selected calendar-day-selected-right")}else for(i=0;i<t.value.length;i+=1)e=new Date(o[i]),r.find(`.calendar-day[data-date="${e.getFullYear()}-${e.getMonth()}-${e.getDate()}"]`).addClass("calendar-day-selected")}if(e||t.emit("local::change calendarChange",t,o),a&&a.length>0&&t.hasTimePicker&&a.find(".calendar-time-selector a").text(o&&o.length?t.timeSelectorFormatter(o[0]):t.params.timePickerPlaceholder),s&&s.length||n.header){const r=t.formatValue(o);n.header&&a&&a.length&&a.find(".calendar-selected-date").text(r),s&&s.length&&!e&&(s.val(r),s.trigger("change"))}}updateCurrentMonthYear(e){const t=this,{$months:a,$el:r,monthNames:s}=t;let o,n;void 0===e?(t.currentMonth=parseInt(a.eq(1).attr("data-month"),10),t.currentYear=parseInt(a.eq(1).attr("data-year"),10),o=a.eq(1).attr("data-locale-month"),n=a.eq(1).attr("data-locale-year")):(t.currentMonth=parseInt(a.eq("next"===e?a.length-1:0).attr("data-month"),10),t.currentYear=parseInt(a.eq("next"===e?a.length-1:0).attr("data-year"),10),o=a.eq("next"===e?a.length-1:0).attr("data-locale-month"),n=a.eq("next"===e?a.length-1:0).attr("data-locale-year")),r.find(".current-month-value").text(s[o]),r.find(".current-year-value").text(n)}update(){const e=this,{currentYear:t,currentMonth:a,$wrapperEl:r}=e,s=new Date(t,a),o=e.renderMonth(s,"prev"),n=e.renderMonth(s),i=e.renderMonth(s,"next");r.transition(0).html(`${o}${n}${i}`).transform("translate3d(0,0,0)"),e.$months=r.find(".calendar-month"),e.monthsTranslate=0,e.setMonthsTranslate(),e.$months.each((t=>{e.emit("local::monthAdd calendarMonthAdd",t)}))}onMonthChangeStart(e){const t=this,{$months:a,currentYear:r,currentMonth:s}=t;t.updateCurrentMonthYear(e),a.removeClass("calendar-month-current calendar-month-prev calendar-month-next");const o="next"===e?a.length-1:0;a.eq(o).addClass("calendar-month-current"),a.eq("next"===e?o-1:o+1).addClass("next"===e?"calendar-month-prev":"calendar-month-next"),t.emit("local::monthYearChangeStart calendarMonthYearChangeStart",t,r,s)}onMonthChangeEnd(e,t){const a=this,{currentYear:r,currentMonth:s,$wrapperEl:o,monthsTranslate:n}=a;let i,l,c;a.animating=!1,o.find(".calendar-month:not(.calendar-month-prev):not(.calendar-month-current):not(.calendar-month-next)").remove(),void 0===e&&(e="next",t=!0),t?(o.find(".calendar-month-next, .calendar-month-prev").remove(),l=a.renderMonth(new Date(r,s),"prev"),i=a.renderMonth(new Date(r,s),"next")):c=a.renderMonth(new Date(r,s),e),("next"===e||t)&&o.append(c||i),("prev"===e||t)&&o.prepend(c||l);const p=o.find(".calendar-month");a.$months=p,a.setMonthsTranslate(n),a.emit("local::monthAdd calendarMonthAdd",a,"next"===e?p.eq(p.length-1)[0]:p.eq(0)[0]),a.emit("local::monthYearChangeEnd calendarMonthYearChangeEnd",a,r,s)}setMonthsTranslate(e){const t=this,{$months:a,isHorizontal:r,inverter:s}=t;e=e||t.monthsTranslate||0,void 0===t.monthsTranslate&&(t.monthsTranslate=e),a.removeClass("calendar-month-current calendar-month-prev calendar-month-next");const o=100*-(e+1)*s,n=100*-e*s,i=100*-(e-1)*s;a.eq(0).transform(`translate3d(${r?o:0}%, ${r?0:o}%, 0)`).addClass("calendar-month-prev"),a.eq(1).transform(`translate3d(${r?n:0}%, ${r?0:n}%, 0)`).addClass("calendar-month-current"),a.eq(2).transform(`translate3d(${r?i:0}%, ${r?0:i}%, 0)`).addClass("calendar-month-next")}nextMonth(e){const t=this,{params:a,$wrapperEl:r,inverter:s,isHorizontal:o}=t;void 0!==e&&"object"!=typeof e||(e="",a.animate||(e=0));const n=parseInt(t.$months.eq(t.$months.length-1).attr("data-month"),10),i=parseInt(t.$months.eq(t.$months.length-1).attr("data-year"),10),l=new Date(i,n).getTime(),c=!t.animating;if(a.maxDate&&l>new Date(a.maxDate).getTime())return void t.resetMonth();if(t.monthsTranslate-=1,n===t.currentMonth){const e=100*-t.monthsTranslate*s,a=A(t.renderMonth(l,"next")).transform(`translate3d(${o?e:0}%, ${o?0:e}%, 0)`).addClass("calendar-month-next");r.append(a[0]),t.$months=r.find(".calendar-month"),t.emit("local::monthAdd calendarMonthAdd",t.$months.eq(t.$months.length-1)[0])}t.animating=!0,t.onMonthChangeStart("next");const p=100*t.monthsTranslate*s;r.transition(e).transform(`translate3d(${o?p:0}%, ${o?0:p}%, 0)`),c&&r.transitionEnd((()=>{t.onMonthChangeEnd("next")})),a.animate||t.onMonthChangeEnd("next")}prevMonth(e){const t=this,{params:a,$wrapperEl:r,inverter:s,isHorizontal:o}=t;void 0!==e&&"object"!=typeof e||(e="",a.animate||(e=0));const n=parseInt(t.$months.eq(0).attr("data-month"),10),i=parseInt(t.$months.eq(0).attr("data-year"),10),l=new Date(i,n+1,-1).getTime(),c=!t.animating;if(a.minDate){let e=new Date(a.minDate);if(e=new Date(e.getFullYear(),e.getMonth(),1),l<e.getTime())return void t.resetMonth()}if(t.monthsTranslate+=1,n===t.currentMonth){const e=100*-t.monthsTranslate*s,a=A(t.renderMonth(l,"prev")).transform(`translate3d(${o?e:0}%, ${o?0:e}%, 0)`).addClass("calendar-month-prev");r.prepend(a[0]),t.$months=r.find(".calendar-month"),t.emit("local::monthAdd calendarMonthAdd",t.$months.eq(0)[0])}t.animating=!0,t.onMonthChangeStart("prev");const p=100*t.monthsTranslate*s;r.transition(e).transform(`translate3d(${o?p:0}%, ${o?0:p}%, 0)`),c&&r.transitionEnd((()=>{t.onMonthChangeEnd("prev")})),a.animate||t.onMonthChangeEnd("prev")}resetMonth(e){void 0===e&&(e="");const{$wrapperEl:t,inverter:a,isHorizontal:r,monthsTranslate:s}=this,o=100*s*a;t.transition(e).transform(`translate3d(${r?o:0}%, ${r?0:o}%, 0)`)}setYearMonth(e,t,a){const r=this,{params:s,isHorizontal:o,$wrapperEl:n,inverter:i}=r;let l;if(void 0===e&&(e=r.currentYear),void 0===t&&(t=r.currentMonth),void 0!==a&&"object"!=typeof a||(a="",s.animate||(a=0)),l=e<r.currentYear?new Date(e,t+1,-1).getTime():new Date(e,t).getTime(),s.maxDate&&l>new Date(s.maxDate).getTime())return!1;if(s.minDate){let e=new Date(s.minDate);if(e=new Date(e.getFullYear(),e.getMonth(),1),l<e.getTime())return!1}const c=new Date(r.currentYear,r.currentMonth).getTime(),p=l>c?"next":"prev",d=r.renderMonth(new Date(e,t));r.monthsTranslate=r.monthsTranslate||0;const u=r.monthsTranslate;let h;const m=!r.animating&&0!==a;l>c?(r.monthsTranslate-=1,r.animating||r.$months.eq(r.$months.length-1).remove(),n.append(d),r.$months=n.find(".calendar-month"),h=100*-(u-1)*i,r.$months.eq(r.$months.length-1).transform(`translate3d(${o?h:0}%, ${o?0:h}%, 0)`).addClass("calendar-month-next")):(r.monthsTranslate+=1,r.animating||r.$months.eq(0).remove(),n.prepend(d),r.$months=n.find(".calendar-month"),h=100*-(u+1)*i,r.$months.eq(0).transform(`translate3d(${o?h:0}%, ${o?0:h}%, 0)`).addClass("calendar-month-prev")),r.emit("local::monthAdd calendarMonthAdd","next"===p?r.$months.eq(r.$months.length-1)[0]:r.$months.eq(0)[0]),r.animating=!0,r.onMonthChangeStart(p);const f=100*r.monthsTranslate*i;n.transition(a).transform(`translate3d(${o?f:0}%, ${o?0:f}%, 0)`),m&&n.transitionEnd((()=>{r.onMonthChangeEnd(p,!0)})),s.animate&&0!==a||r.onMonthChangeEnd(p,!0)}nextYear(){this.setYearMonth(this.currentYear+1)}prevYear(){this.setYearMonth(this.currentYear-1)}dateInRange(e,t){let a,r=!1;if(!t)return!1;if(Array.isArray(t))for(a=0;a<t.length;a+=1)t[a].from||t[a].to?t[a].from&&t[a].to?e<=new Date(t[a].to).getTime()&&e>=new Date(t[a].from).getTime()&&(r=!0):t[a].from?e>=new Date(t[a].from).getTime()&&(r=!0):t[a].to&&e<=new Date(t[a].to).getTime()&&(r=!0):t[a].date?e===new Date(t[a].date).getTime()&&(r=!0):e===new Date(t[a]).getTime()&&(r=!0);else t.from||t.to?t.from&&t.to?e<=new Date(t.to).getTime()&&e>=new Date(t.from).getTime()&&(r=!0):t.from?e>=new Date(t.from).getTime()&&(r=!0):t.to&&e<=new Date(t.to).getTime()&&(r=!0):t.date?r=e===new Date(t.date).getTime():"function"==typeof t&&(r=t(new Date(e)));return r}daysInMonth(e){const t=new Date(e);return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()}renderMonths(e){const t=this;return t.params.renderMonths?t.params.renderMonths.call(t,e):ct("div",{class:"calendar-months-wrapper"},t.renderMonth(e,"prev"),t.renderMonth(e),t.renderMonth(e,"next"))}renderMonth(e,t){const a=this,{params:r,value:s}=a;if(r.renderMonth)return r.renderMonth.call(a,e,t);let o=new Date(e),n=o.getFullYear(),i=o.getMonth(),l=a.monthNames.indexOf(a.monthFormatter(o));l<0&&(l=i);let c=a.yearFormatter(o);"next"===t&&(o=11===i?new Date(n+1,0):new Date(n,i+1,1)),"prev"===t&&(o=0===i?new Date(n-1,11):new Date(n,i-1,1)),"next"!==t&&"prev"!==t||(i=o.getMonth(),n=o.getFullYear(),l=a.monthNames.indexOf(a.monthFormatter(o)),l<0&&(l=i),c=a.yearFormatter(o));const p=[],d=(new Date).setHours(0,0,0,0),u=r.minDate?new Date(r.minDate).getTime():null,h=r.maxDate?new Date(r.maxDate).getTime():null,m=a.daysInMonth(new Date(o.getFullYear(),o.getMonth()).getTime()-864e6),f=a.daysInMonth(o),g=6===r.firstDay?0:1;let v,b,w="",y=r.firstDay-1+0,C=new Date(o.getFullYear(),o.getMonth()).getDay();if(0===C&&(C=7),s&&s.length)for(let e=0;e<s.length;e+=1)p.push(new Date(s[e]).setHours(0,0,0,0));for(let e=1;e<=6;e+=1){let t="";for(let s=1;s<=7;s+=1){let o;y+=1;let l=y-C,c="";1===e&&1===s&&l>g&&1!==r.firstDay&&(y-=7,l=y-C);const w=s-1+r.firstDay>6?s-1-7+r.firstDay:s-1+r.firstDay;l<0?(l=m+l+1,c+=" calendar-day-prev",o=new Date(i-1<0?n-1:n,i-1<0?11:i-1,l).getTime()):(l+=1,l>f?(l-=f,c+=" calendar-day-next",o=new Date(i+1>11?n+1:n,i+1>11?0:i+1,l).getTime()):o=new Date(n,i,l).getTime()),o===d&&(c+=" calendar-day-today"),r.rangePicker&&2===p.length?(o>=p[0]&&o<=p[1]&&(c+=" calendar-day-selected"),p[0]!==p[1]&&(o>p[0]&&o<p[1]&&(c+=" calendar-day-selected-range"),o===p[0]&&(c+=" calendar-day-selected-left"),o===p[1]&&(c+=" calendar-day-selected-right"))):p.indexOf(o)>=0&&(c+=" calendar-day-selected"),r.weekendDays.indexOf(w)>=0&&(c+=" calendar-day-weekend");let E="";if(b=!1,r.events&&a.dateInRange(o,r.events)&&(b=!0),b&&(c+=" calendar-day-has-events",E='\n            <span class="calendar-day-events">\n              <span class="calendar-day-event"></span>\n            </span>\n          ',Array.isArray(r.events))){const e=[];r.events.forEach((t=>{const r=t.color||"";e.indexOf(r)<0&&a.dateInRange(o,t)&&e.push(r)})),E=`\n              <span class="calendar-day-events">\n                ${e.map((e=>`\n                  <span class="calendar-day-event" style="${e?`background-color: ${e}`:""}"></span>\n                `.trim())).join("")}\n              </span>\n            `}if(r.rangesClasses)for(let e=0;e<r.rangesClasses.length;e+=1)a.dateInRange(o,r.rangesClasses[e].range)&&(c+=` ${r.rangesClasses[e].cssClass}`);v=!1,(u&&o<u||h&&o>h)&&(v=!0),r.disabled&&a.dateInRange(o,r.disabled)&&(v=!0),v&&(c+=" calendar-day-disabled"),o=new Date(o);const k=o.getFullYear(),$=o.getMonth();t+=`\n          <div data-year="${k}" data-month="${$}" data-day="${l}" class="calendar-day${c}" data-date="${k}-${$}-${l}">\n            <span class="calendar-day-number">${a.dayFormatter(o)}${E}</span>\n          </div>`.trim()}w+=`<div class="calendar-row">${t}</div>`}return w=`<div class="calendar-month" data-year="${n}" data-month="${i}" data-locale-year="${c}" data-locale-month="${l}">${w}</div>`,w}renderWeekHeader(){const e=this;if(e.params.renderWeekHeader)return e.params.renderWeekHeader.call(e);const{params:t}=e;let a="";for(let r=0;r<7;r+=1){const s=r+t.firstDay>6?r-7+t.firstDay:r+t.firstDay;a+=`<div class="calendar-week-day">${e.dayNamesShort[s]}</div>`}return ct("div",{class:"calendar-week-header"},a)}renderMonthSelector(){const e=this;return e.params.renderMonthSelector?e.params.renderMonthSelector.call(e):ct("div",{class:"calendar-month-selector"},ct("a",{class:"link icon-only calendar-prev-month-button"},ct("i",{class:"icon icon-prev"})),e.params.monthPicker?ct("a",{class:"current-month-value link"}):ct("span",{class:"current-month-value"}),ct("a",{class:"link icon-only calendar-next-month-button"},ct("i",{class:"icon icon-next"})))}renderYearSelector(){const e=this;return e.params.renderYearSelector?e.params.renderYearSelector.call(e):ct("div",{class:"calendar-year-selector"},ct("a",{class:"link icon-only calendar-prev-year-button"},ct("i",{class:"icon icon-prev"})),e.params.yearPicker?ct("a",{class:"current-year-value link"}):ct("span",{class:"current-year-value"}),ct("a",{class:"link icon-only calendar-next-year-button"},ct("i",{class:"icon icon-next"})))}renderTimeSelector(){const e=this,t=e.value&&e.value[0];let a;return t&&(a=e.timeSelectorFormatter(t)),ct("div",{class:"calendar-time-selector"},ct("span",null,e.params.timePickerLabel),ct("a",{class:"link"},a||e.params.timePickerPlaceholder))}renderHeader(){const e=this;return e.params.renderHeader?e.params.renderHeader.call(e):ct("div",{class:"calendar-header"},ct("div",{class:"calendar-selected-date"},e.params.headerPlaceholder))}renderFooter(){const e=this,t=e.app;return e.params.renderFooter?e.params.renderFooter.call(e):ct("div",{class:"calendar-footer"},ct("a",{class:("md"===t.theme?"button button-round":"link")+" calendar-close sheet-close popover-close"},e.params.toolbarCloseText))}renderToolbar(){const e=this;return e.params.renderToolbar?e.params.renderToolbar.call(e,e):ct("div",{class:"toolbar toolbar-top"},ct("div",{class:"toolbar-inner"},e.params.monthSelector?e.renderMonthSelector():"",e.params.yearSelector?e.renderYearSelector():""))}renderInline(){const e=this,{cssClass:t,toolbar:a,header:r,footer:s,rangePicker:o,weekHeader:n}=e.params,{value:i,hasTimePicker:l}=e,c=i&&i.length?i[0]:(new Date).setHours(0,0,0);return ct("div",{class:`calendar calendar-inline ${o?"calendar-range":""} ${t||""}`},r&&e.renderHeader(),a&&e.renderToolbar(),n&&e.renderWeekHeader(),ct("div",{class:"calendar-months"},e.renderMonths(c)),l&&e.renderTimeSelector(),s&&e.renderFooter())}renderCustomModal(){const e=this,{cssClass:t,toolbar:a,header:r,footer:s,rangePicker:o,weekHeader:n}=e.params,{value:i,hasTimePicker:l}=e,c=i&&i.length?i[0]:(new Date).setHours(0,0,0);return ct("div",{class:`calendar calendar-modal ${o?"calendar-range":""} ${t||""}`},r&&e.renderHeader(),a&&e.renderToolbar(),n&&e.renderWeekHeader(),ct("div",{class:"calendar-months"},e.renderMonths(c)),l&&e.renderTimeSelector(),s&&e.renderFooter())}renderSheet(){const e=this,{cssClass:t,toolbar:a,header:r,footer:s,rangePicker:o,weekHeader:n}=e.params,{value:i,hasTimePicker:l}=e,c=i&&i.length?i[0]:(new Date).setHours(0,0,0);return ct("div",{class:`sheet-modal calendar calendar-sheet ${o?"calendar-range":""} ${t||""}`},r&&e.renderHeader(),a&&e.renderToolbar(),n&&e.renderWeekHeader(),ct("div",{class:"sheet-modal-inner calendar-months"},e.renderMonths(c)),l&&e.renderTimeSelector(),s&&e.renderFooter())}renderPopover(){const e=this,{cssClass:t,toolbar:a,header:r,footer:s,rangePicker:o,weekHeader:n}=e.params,{value:i,hasTimePicker:l}=e,c=i&&i.length?i[0]:(new Date).setHours(0,0,0);return ct("div",{class:"popover calendar-popover"},ct("div",{class:"popover-inner"},ct("div",{class:`calendar ${o?"calendar-range":""} ${t||""}`},r&&e.renderHeader(),a&&e.renderToolbar(),n&&e.renderWeekHeader(),ct("div",{class:"calendar-months"},e.renderMonths(c)),l&&e.renderTimeSelector(),s&&e.renderFooter())))}render(){const e=this,{params:t}=e;if(t.render)return t.render.call(e);if(!e.inline){let a=t.openIn;return"auto"===a&&(a=e.isPopover()?"popover":"sheet"),"popover"===a?e.renderPopover():"sheet"===a?e.renderSheet():e.renderCustomModal()}return e.renderInline()}openMonthPicker(){const e=this,{$el:t,app:a}=e;if(!t||!t.length)return;t.append('<div class="popover calendar-popover calendar-month-picker-popover"><div class="popover-inner"><div class="calendar-month-picker"></div></div></div>'),e.monthPickerPopover=a.popover.create({el:t.find(".calendar-month-picker-popover"),targetEl:t.find(".calendar-month-selector"),backdrop:!0,backdropUnique:!0,on:{close(){e.closeMonthPicker()},closed(){e.monthPickerPopover.$el&&e.monthPickerPopover.$el.remove(),e.monthPickerPopover.destroy(),e.monthPickerInstance&&(e.monthPickerInstance.close(),e.monthPickerInstance.destroy()),delete e.monthPickerInstance,delete e.monthPickerPopover}}}),e.monthPickerPopover.open();const r=parseInt(e.$el.find(".calendar-month-current").attr("data-locale-month"),10),s=[],o=[];e.monthNames.forEach(((e,t)=>{s.push(t),o.push(e)})),e.monthPickerInstance=a.picker.create({containerEl:e.monthPickerPopover.$el.find(".calendar-month-picker"),value:[r],toolbar:e.params.monthPickerToolbar,rotateEffect:!1,toolbarCloseText:e.params.monthPickerCloseText,cols:[{values:s,displayValues:o}]})}closeMonthPicker(){const e=this;e.monthPickerPopover&&e.monthPickerPopover.opened&&e.monthPickerPopover.close();const t=e.monthPickerInstance.value[0]-(parseInt(e.$el.find(".calendar-month-current").attr("data-locale-month"),10)-e.currentMonth);e.setYearMonth(e.currentYear,t,0)}openYearPicker(){const e=this,{$el:t,app:a}=e;if(!t||!t.length)return;t.append('<div class="popover calendar-popover calendar-year-picker-popover"><div class="popover-inner"><div class="calendar-year-picker"></div></div></div>'),e.yearPickerPopover=a.popover.create({el:t.find(".calendar-year-picker-popover"),targetEl:t.find(".calendar-year-selector"),backdrop:!0,backdropUnique:!0,on:{close(){e.closeYearPicker()},closed(){e.yearPickerPopover.$el&&e.yearPickerPopover.$el.remove(),e.yearPickerPopover.destroy(),e.yearPickerInstance&&(e.yearPickerInstance.close(),e.yearPickerInstance.destroy()),delete e.yearPickerInstance,delete e.yearPickerPopover}}}),e.yearPickerPopover.open();const r=e.currentYear;let s=e.params.yearPickerMin||(new Date).getFullYear()-100;e.params.minDate&&(s=Math.max(s,new Date(e.params.minDate).getFullYear()));let o=e.params.yearPickerMax||(new Date).getFullYear()+100;e.params.maxDate&&(o=Math.min(o,new Date(e.params.maxDate).getFullYear()));const n=[];for(let e=s;e<=o;e+=1)n.push(e);e.yearPickerInstance=a.picker.create({containerEl:e.yearPickerPopover.$el.find(".calendar-year-picker"),value:[r],toolbar:e.params.yearPickerToolbar,rotateEffect:!1,toolbarCloseText:e.params.yearPickerCloseText,cols:[{values:n}]})}closeYearPicker(){const e=this;e.yearPickerPopover&&e.yearPickerPopover.opened&&e.yearPickerPopover.close(),e.setYearMonth(e.yearPickerInstance.value[0],void 0,0)}openTimePicker(){const e=this,{$el:t,app:a,is12HoursFormat:r}=e;if(!t||!t.length)return;t.append('<div class="popover calendar-popover calendar-time-picker-popover"><div class="popover-inner"><div class="calendar-time-picker"></div></div></div>');const s=[],o=[],n=r?12:23;for(let e=r?1:0;e<=n;e+=1)s.push(e);for(let e=0;e<=59;e+=1)o.push(e);let i;i=e.value&&e.value.length?[e.value[0].getHours(),e.value[0].getMinutes()]:[(new Date).getHours(),(new Date).getMinutes()],r&&(i.push(i[0]<12?"AM":"PM"),i[0]>12&&(i[0]-=12),0===i[0]&&(i[0]=12)),e.timePickerPopover=a.popover.create({el:t.find(".calendar-time-picker-popover"),targetEl:t.find(".calendar-time-selector .link"),backdrop:!0,backdropUnique:!0,on:{close(){e.closeTimePicker()},closed(){e.timePickerPopover.$el&&e.timePickerPopover.$el.remove(),e.timePickerPopover.destroy(),e.timePickerInstance&&(e.timePickerInstance.close(),e.timePickerInstance.destroy()),delete e.timePickerInstance,delete e.timePickerPopover}}}),e.timePickerPopover.open(),e.timePickerInstance=a.picker.create({containerEl:e.timePickerPopover.$el.find(".calendar-time-picker"),value:i,toolbar:e.params.timePickerToolbar,rotateEffect:!1,toolbarCloseText:e.params.timePickerCloseText,cols:[{values:s},{divider:!0,content:":"},{values:o,displayValues:o.map((e=>e<10?`0${e}`:e))},...r?[{values:["AM","PM"]}]:[]]})}closeTimePicker(){const e=this,{is12HoursFormat:t}=e;if(e.timePickerInstance){const a=e.timePickerInstance.value;let r=parseInt(a[0],10);const s=parseInt(a[1],10),o=e.timePickerInstance.value[2];t&&("AM"===o&&12===r?r=0:"PM"===o&&12!==r&&(r+=12));let n=e.value&&e.value.length&&e.value[0];n?(n=new Date(n),n.setHours(r,s)):(n=new Date,n.setHours(r,s,0,0)),e.setValue([n]),e.timePickerPopover&&e.timePickerPopover.opened&&e.timePickerPopover.close()}}onOpen(){const e=this,{initialized:t,$el:a,app:r,$inputEl:s,inline:o,value:n,params:i}=e;e.closing=!1,e.opened=!0,e.opening=!0,e.attachCalendarEvents();const l=!n&&i.value;t?n&&e.setValue(n,0):n?e.setValue(n,0):i.value&&e.setValue(e.normalizeValues(i.value),0),e.updateCurrentMonthYear(),e.monthsTranslate=0,e.setMonthsTranslate(),l?e.updateValue():i.header&&n&&e.updateValue(!0),!o&&s&&s.length&&"md"===r.theme&&s.trigger("focus"),e.initialized=!0,e.$months.each((t=>{e.emit("local::monthAdd calendarMonthAdd",t)})),a&&a.trigger("calendar:open"),s&&s.trigger("calendar:open"),e.emit("local::open calendarOpen",e)}onOpened(){const e=this;e.opening=!1,e.$el&&e.$el.trigger("calendar:opened"),e.$inputEl&&e.$inputEl.trigger("calendar:opened"),e.emit("local::opened calendarOpened",e)}onClose(){const e=this,t=e.app;if(e.opening=!1,e.closing=!0,e.$inputEl)if("md"===t.theme)e.$inputEl.trigger("blur");else{const a=e.$inputEl.attr("validate"),r=e.$inputEl.attr("required");a&&r&&t.input.validate(e.$inputEl)}e.detachCalendarEvents&&e.detachCalendarEvents(),e.$el&&e.$el.trigger("calendar:close"),e.$inputEl&&e.$inputEl.trigger("calendar:close"),e.emit("local::close calendarClose",e)}onClosed(){const e=this;e.opened=!1,e.closing=!1,e.inline||Le((()=>{e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal})),e.timePickerInstance&&(e.timePickerInstance.destroy&&e.timePickerInstance.destroy(),delete e.timePickerInstance),e.$el&&e.$el.trigger("calendar:closed"),e.$inputEl&&e.$inputEl.trigger("calendar:closed"),e.emit("local::closed calendarClosed",e)}open(){const e=this,{app:t,opened:a,inline:r,$inputEl:s,params:o}=e;if(a)return;if(r)return e.$el=A(e.render()),e.$el[0].f7Calendar=e,e.$wrapperEl=e.$el.find(".calendar-months-wrapper"),e.$months=e.$wrapperEl.find(".calendar-month"),e.$containerEl.append(e.$el),e.onOpen(),void e.onOpened();let n=o.openIn;"auto"===n&&(n=e.isPopover()?"popover":"sheet");const i=e.render(),l={targetEl:s,scrollToEl:o.scrollToInput?s:void 0,content:i,backdrop:!0===o.backdrop||("popover"===n||"customModal"===n)&&!1!==t.params.popover.backdrop&&!1!==o.backdrop,closeByBackdropClick:o.closeByBackdropClick,on:{open(){const t=this;e.modal=t,e.$el="popover"===n?t.$el.find(".calendar"):t.$el,e.$wrapperEl=e.$el.find(".calendar-months-wrapper"),e.$months=e.$wrapperEl.find(".calendar-month"),e.$el[0].f7Calendar=e,"customModal"===n&&A(e.$el).find(".calendar-close").once("click",(()=>{e.close()})),e.onOpen()},opened(){e.onOpened()},close(){e.onClose()},closed(){e.onClosed()}}};"sheet"===n&&(l.push=o.sheetPush,l.swipeToClose=o.sheetSwipeToClose),o.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,[n]:l}}):(e.modal=t[n].create(l),e.modal.open())}close(){const e=this,{opened:t,inline:a}=e;if(t)return a?(e.onClose(),void e.onClosed()):void(e.params.routableModals&&e.view?e.view.router.back():e.modal.close())}init(){const e=this;if(e.initInput(),e.inline)return e.open(),void e.emit("local::init calendarInit",e);!e.initialized&&e.params.value&&e.setValue(e.normalizeValues(e.params.value)),e.$inputEl&&e.attachInputEvents(),e.params.closeByOutsideClick&&e.attachHtmlEvents(),e.emit("local::init calendarInit",e)}destroy(){const e=this;if(e.destroyed)return;const{$el:t}=e;e.emit("local::beforeDestroy calendarBeforeDestroy",e),t&&t.trigger("calendar:beforedestroy"),e.close(),e.$inputEl&&e.detachInputEvents(),e.params.closeByOutsideClick&&e.detachHtmlEvents(),e.timePickerInstance&&(e.timePickerInstance.destroy&&e.timePickerInstance.destroy(),delete e.timePickerInstance),t&&t.length&&delete e.$el[0].f7Calendar,Ie(e),e.destroyed=!0}};var Jr={name:"calendar",static:{Calendar:Qr},create(){const e=this;e.calendar=nt({defaultSelector:".calendar",constructor:Qr,app:e,domProp:"f7Calendar"}),e.calendar.close=function(e){void 0===e&&(e=".calendar");const t=A(e);if(0===t.length)return;const a=t[0].f7Calendar;!a||a&&!a.opened||a.close()}},params:{calendar:{dateFormat:void 0,monthNames:"auto",monthNamesShort:"auto",dayNames:"auto",dayNamesShort:"auto",locale:void 0,firstDay:1,weekendDays:[0,6],multiple:!1,rangePicker:!1,rangePickerMinDays:1,rangePickerMaxDays:0,direction:"horizontal",minDate:null,maxDate:null,disabled:null,events:null,rangesClasses:null,touchMove:!0,animate:!0,closeOnSelect:!1,monthSelector:!0,monthPicker:!0,monthPickerToolbar:!0,monthPickerCloseText:"Done",yearSelector:!0,yearPicker:!0,yearPickerToolbar:!0,yearPickerMin:void 0,yearPickerMax:void 0,yearPickerCloseText:"Done",timePicker:!1,timePickerToolbar:!0,timePickerLabel:"Time",timePickerFormat:{hour:"numeric",minute:"numeric"},timePickerPlaceholder:"Select time",timePickerCloseText:"Done",weekHeader:!0,value:null,containerEl:null,openIn:"auto",sheetPush:!1,sheetSwipeToClose:void 0,formatValue:null,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,header:!1,headerPlaceholder:"Select date",toolbar:!0,toolbarCloseText:"Done",footer:!1,cssClass:null,routableModals:!1,view:null,url:"date/",backdrop:null,closeByBackdropClick:!0,renderWeekHeader:null,renderMonths:null,renderMonth:null,renderMonthSelector:null,renderYearSelector:null,renderHeader:null,renderFooter:null,renderToolbar:null,renderInline:null,renderPopover:null,renderSheet:null,render:null}}};function Zr(e,t){const a=this,r=A(e),s=r.index(),o=a.cols[s];if(o.divider)return;let n,i;function l(){o.updateItems()}function c(){const e=A(this).attr("data-picker-value");o.setValue(e)}o.$el=r,o.el=r[0],o.$itemsEl=o.$el.find(".picker-items"),o.items=o.$itemsEl.find(".picker-item"),o.replaceValues=function(e,t){o.detachEvents(),o.values=e,o.displayValues=t,o.$itemsEl.html(a.renderColumn(o,!0)),o.items=o.$itemsEl.find(".picker-item"),o.calcSize(),o.setValue(o.values[0],!0),o.attachEvents()},o.calcSize=function(){i=o.$el[0].offsetHeight,n=o.items[0].offsetHeight;const e=o.el.style.getPropertyValue("--f7-picker-scroll-padding");o.el.style.setProperty("--f7-picker-scroll-padding",(i-n)/2+"px"),e||(o.$itemsEl[0].scrollTop=0)},o.setValue=function(e,t){const a=o.$itemsEl.find(`.picker-item[data-picker-value="${e}"]`).index();if(void 0===a||-1===a)return;const r=a*n;o.$itemsEl[0].scrollTop=r,o.updateItems(a,r,t)},o.updateItems=function(e,t,r){void 0===t&&(t=o.$itemsEl[0].scrollTop),void 0===e&&(e=Math.round(t/n)),e<0&&(e=0),e>=o.items.length&&(e=o.items.length-1);const s=o.activeIndex;o.activeIndex=e,o.$itemsEl.find(".picker-item-selected").removeClass("picker-item-selected");const l=o.items.eq(e);l.addClass("picker-item-selected").children().transform(""),a.params.rotateEffect&&o.items.each((e=>{const a=A(e),r=(e.offsetTop-(i-n)/2-t)/n,s=Math.ceil(o.height/n/2)+1;let l=-24*r;l>180&&(l=180),l<-180&&(l=-180),Math.abs(r)>s?a.addClass("picker-item-far"):a.removeClass("picker-item-far"),a.children("span").transform(`translate3d(0, ${-r*n}px, -100px) rotateX(${l}deg)`)})),(r||void 0===r)&&(o.value=l.attr("data-picker-value"),o.displayValue=o.displayValues?o.displayValues[e]:o.value,s!==e&&(o.onChange&&o.onChange(a,o.value,o.displayValue),a.updateValue()))},o.attachEvents=function(){o.$itemsEl.on("scroll",l),o.items.on("click",c)},o.detachEvents=function(){o.items.off("click",c)},o.init=function(){o.calcSize(),0===s&&o.$el.addClass("picker-column-first"),s===a.cols.length-1&&o.$el.addClass("picker-column-last"),a.params.freeMode&&o.$el.addClass("picker-column-free-mode"),t&&o.updateItems(0),o.attachEvents()},o.destroy=function(){o.detachEvents()},o.init()}let es=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r=rt(),s=o();let n,i;if(a.params=Fe({},e.params.picker,t),a.params.containerEl&&(n=A(a.params.containerEl),0===n.length))return a;a.params.inputEl&&(i=A(a.params.inputEl));let l=a.params.scrollToInput?i:void 0;if(a.params.scrollToEl){const e=A(a.params.scrollToEl);e.length>0&&(l=e)}function c(){a.resizeCols()}function p(){a.open()}function d(e){e.preventDefault()}Fe(a,{app:e,$containerEl:n,containerEl:n&&n[0],inline:n&&n.length>0,needsOriginFix:r.ios||s.navigator.userAgent.toLowerCase().indexOf("safari")>=0&&s.navigator.userAgent.toLowerCase().indexOf("chrome")<0&&!r.android,cols:[],$inputEl:i,inputEl:i&&i[0],$scrollToEl:l,initialized:!1,opened:!1,url:a.params.url});let u=null;function h(e){u=e.target}function m(e){if(a.destroyed||!a.params)return;const t=A(e.target);a.isPopover()||a.opened&&!a.closing&&(t.closest('[class*="backdrop"]').length||(i&&i.length>0?u===e.target&&t[0]!==i[0]&&0===t.closest(".sheet-modal").length&&a.close():0===A(e.target).closest(".sheet-modal").length&&a.close()))}return Fe(a,{attachResizeEvent(){e.on("resize",c)},detachResizeEvent(){e.off("resize",c)},attachInputEvents(){a.$inputEl.on("click",p),a.params.inputReadOnly&&(a.$inputEl.on("focus mousedown",d),a.$inputEl[0]&&(a.$inputEl[0].f7ValidateReadonly=!0))},detachInputEvents(){a.$inputEl.off("click",p),a.params.inputReadOnly&&(a.$inputEl.off("focus mousedown",d),a.$inputEl[0]&&delete a.$inputEl[0].f7ValidateReadonly)},attachHtmlEvents(){e.on("click",m),e.on("touchstart",h)},detachHtmlEvents(){e.off("click",m),e.off("touchstart",h)}}),a.init(),a}get view(){const{app:e,params:t,$inputEl:a}=this;let r;return t.view?r=t.view:a&&(r=a.parents(".view").length&&a.parents(".view")[0].f7View),r||(r=e.views.main),r}initInput(){const e=this;e.$inputEl&&e.params.inputReadOnly&&e.$inputEl.prop("readOnly",!0)}resizeCols(){const e=this;if(e.opened)for(let t=0;t<e.cols.length;t+=1)e.cols[t].divider||(e.cols[t].calcSize(),e.cols[t].setValue(e.cols[t].value,!1))}isPopover(){const e=this,{app:t,modal:a,params:r}=e,s=rt();if("sheet"===r.openIn)return!1;if(a&&"popover"!==a.type)return!1;if(!e.inline&&e.inputEl){if("popover"===r.openIn)return!0;if(s.ios)return!!s.ipad;if(t.width>=768)return!0}return!1}formatValue(){const e=this,{value:t,displayValue:a}=e;return e.params.formatValue?e.params.formatValue.call(e,t,a):t.join(" ")}setValue(e){const t=this;let a=0;if(0===t.cols.length)return t.value=e,void t.updateValue(e);for(let r=0;r<t.cols.length;r+=1)t.cols[r]&&!t.cols[r].divider&&(t.cols[r].setValue(e[a]),a+=1)}getValue(){return this.value}updateValue(e){const t=this,a=e||[],r=[];let s;if(0===t.cols.length){const e=t.params.cols.filter((e=>!e.divider));for(let t=0;t<e.length;t+=1)s=e[t],void 0!==s.displayValues&&void 0!==s.values&&-1!==s.values.indexOf(a[t])?r.push(s.displayValues[s.values.indexOf(a[t])]):r.push(a[t])}else for(let e=0;e<t.cols.length;e+=1)t.cols[e].divider||(a.push(t.cols[e].value),r.push(t.cols[e].displayValue));a.indexOf(void 0)>=0||(t.value=a,t.displayValue=r,t.emit("local::change pickerChange",t,t.value,t.displayValue),t.inputEl&&(t.$inputEl.val(t.formatValue()),t.$inputEl.trigger("change")))}initColumn(e,t){Zr.call(this,e,t)}destroyColumn(e){const t=this,a=A(e).index();t.cols[a]&&t.cols[a].destroy&&t.cols[a].destroy()}renderToolbar(){const e=this;return e.params.renderToolbar?e.params.renderToolbar.call(e,e):ct("div",{class:"toolbar toolbar-top"},ct("div",{class:"toolbar-inner"},ct("div",{class:"left"}),ct("div",{class:"right"},ct("a",{class:"link sheet-close popover-close"},e.params.toolbarCloseText))))}renderColumn(e,t){const a=`picker-column ${e.textAlign?`picker-column-${e.textAlign}`:""} ${e.cssClass||""}`;let r,s;return e.divider?r=`\n        <div class="${a} picker-column-divider">${e.content}</div>\n      `:(s=e.values.map(((t,a)=>`\n        <div class="picker-item" data-picker-value="${t}">\n          <span>${e.displayValues?e.displayValues[a]:t}</span>\n        </div>\n      `)).join(""),r=`\n        <div class="${a}">\n          <div class="picker-items">${s}</div>\n        </div>\n      `),t?s.trim():r.trim()}renderInline(){const e=this,{rotateEffect:t,cssClass:a,toolbar:r}=e.params;return ct("div",{class:`picker picker-inline ${t?"picker-3d":""} ${a||""}`},r&&e.renderToolbar(),ct("div",{class:"picker-columns"},e.cols.map((t=>e.renderColumn(t))),ct("div",{class:"picker-center-highlight"})))}renderSheet(){const e=this,{rotateEffect:t,cssClass:a,toolbar:r}=e.params;return ct("div",{class:`sheet-modal picker picker-sheet ${t?"picker-3d":""} ${a||""}`},r&&e.renderToolbar(),ct("div",{class:"sheet-modal-inner picker-columns"},e.cols.map((t=>e.renderColumn(t))),ct("div",{class:"picker-center-highlight"})))}renderPopover(){const e=this,{rotateEffect:t,cssClass:a,toolbar:r}=e.params;return ct("div",{class:"popover picker-popover"},ct("div",{class:"popover-inner"},ct("div",{class:`picker ${t?"picker-3d":""} ${a||""}`},r&&e.renderToolbar(),ct("div",{class:"picker-columns"},e.cols.map((t=>e.renderColumn(t))),ct("div",{class:"picker-center-highlight"})))))}render(){const e=this;return e.params.render?e.params.render.call(e):e.inline?e.renderInline():e.isPopover()?e.renderPopover():e.renderSheet()}onOpen(){const e=this,{initialized:t,$el:a,app:r,$inputEl:s,inline:o,value:n,params:i}=e;e.opened=!0,e.closing=!1,e.opening=!0,e.attachResizeEvent(),a.find(".picker-column").each((a=>{let r=!0;(!t&&i.value||t&&n)&&(r=!1),e.initColumn(a,r)})),t?n&&e.setValue(n):n?e.setValue(n):i.value&&e.setValue(i.value),!o&&s&&s.length&&"md"===r.theme&&s.trigger("focus"),e.initialized=!0,a&&a.trigger("picker:open"),s&&s.trigger("picker:open"),e.emit("local::open pickerOpen",e)}onOpened(){const e=this;e.opening=!1,e.$el&&e.$el.trigger("picker:opened"),e.$inputEl&&e.$inputEl.trigger("picker:opened"),e.emit("local::opened pickerOpened",e)}onClose(){const e=this,t=e.app;if(e.opening=!1,e.closing=!0,e.detachResizeEvent(),e.cols.forEach((e=>{e.destroy&&e.destroy()})),e.$inputEl)if("md"===t.theme)e.$inputEl.trigger("blur");else{const a=e.$inputEl.attr("validate"),r=e.$inputEl.attr("required");a&&r&&t.input.validate(e.$inputEl)}e.$el&&e.$el.trigger("picker:close"),e.$inputEl&&e.$inputEl.trigger("picker:close"),e.emit("local::close pickerClose",e)}onClosed(){const e=this;e.opened=!1,e.closing=!1,e.inline||Le((()=>{e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal})),e.$el&&e.$el.trigger("picker:closed"),e.$inputEl&&e.$inputEl.trigger("picker:closed"),e.emit("local::closed pickerClosed",e)}open(){const e=this,{app:t,opened:a,inline:r,$inputEl:s,$scrollToEl:o,params:n}=e;if(a)return;if(0===e.cols.length&&n.cols.length&&n.cols.forEach((t=>{e.cols.push(t)})),r)return e.$el=A(e.render()),e.$el[0].f7Picker=e,e.$containerEl.append(e.$el),e.onOpen(),void e.onOpened();const i=e.isPopover(),l=i?"popover":"sheet",c={targetEl:s,scrollToEl:o,content:e.render(),backdrop:void 0!==n.backdrop?n.backdrop:i,on:{open(){const t=this;e.modal=t,e.$el=i?t.$el.find(".picker"):t.$el,e.$el[0].f7Picker=e,e.onOpen()},opened(){e.onOpened()},close(){e.onClose()},closed(){e.onClosed()}}};"sheet"===l&&(c.push=n.sheetPush,c.swipeToClose=n.sheetSwipeToClose),n.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,[l]:c}}):(e.modal=t[l].create(c),e.modal.open())}close(){const e=this,{opened:t,inline:a}=e;if(t)return a?(e.onClose(),void e.onClosed()):void(e.params.routableModals&&e.view?e.view.router.back():e.modal.close())}init(){const e=this;if(e.initInput(),e.inline)return e.open(),void e.emit("local::init pickerInit",e);!e.initialized&&e.params.value&&e.setValue(e.params.value),e.$inputEl&&e.attachInputEvents(),e.params.closeByOutsideClick&&e.attachHtmlEvents(),e.emit("local::init pickerInit",e)}destroy(){const e=this;if(e.destroyed)return;const{$el:t}=e;e.emit("local::beforeDestroy pickerBeforeDestroy",e),t&&t.trigger("picker:beforedestroy"),e.close(),e.$inputEl&&e.detachInputEvents(),e.params.closeByOutsideClick&&e.detachHtmlEvents(),t&&t.length&&delete e.$el[0].f7Picker,Ie(e),e.destroyed=!0}};var ts={name:"picker",static:{Picker:es},create(){const e=this;e.picker=nt({defaultSelector:".picker",constructor:es,app:e,domProp:"f7Picker"}),e.picker.close=function(e){void 0===e&&(e=".picker");const t=A(e);if(0===t.length)return;const a=t[0].f7Picker;!a||a&&!a.opened||a.close()}},params:{picker:{rotateEffect:!1,freeMode:!1,cols:[],containerEl:null,openIn:"auto",sheetPush:!1,sheetSwipeToClose:void 0,backdrop:void 0,formatValue:null,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,scrollToEl:void 0,toolbar:!0,toolbarCloseText:"Done",cssClass:null,routableModals:!1,view:null,url:"select/",renderToolbar:null,render:null}}};const as={handle(e,t){const a=this,r=A(e),s=r[0].scrollTop,o=r[0].scrollHeight,n=r[0].offsetHeight;let i=r[0].getAttribute("data-infinite-distance");const l=r.find(".virtual-list");let c;const p=r.hasClass("infinite-scroll-top");if(i||(i=50),"string"==typeof i&&i.indexOf("%")>=0&&(i=parseInt(i,10)/100*n),i>n&&(i=n),p)s<i&&(r.trigger("infinite",t),a.emit("infinite",r[0],t));else if(s+n>=o-i){if(l.length>0&&(c=l.eq(-1)[0].f7VirtualList,c&&!c.reachEnd&&!c.params.updatableScroll))return;r.trigger("infinite",t),a.emit("infinite",r[0],t)}},create(e){const t=A(e),a=this;function r(e){a.infiniteScroll.handle(this,e)}t.each((e=>{e.f7InfiniteScrollHandler=r,e.addEventListener("scroll",e.f7InfiniteScrollHandler)}))},destroy(e){A(e).each((e=>{e.removeEventListener("scroll",e.f7InfiniteScrollHandler),delete e.f7InfiniteScrollHandler}))}};var rs={name:"infiniteScroll",create(){Ke(this,{infiniteScroll:as})},on:{tabMounted(e){const t=this,a=A(e),r=a.find(".infinite-scroll-content");a.is(".infinite-scroll-content")&&r.add(a),r.each((e=>{t.infiniteScroll.create(e)}))},tabBeforeRemove(e){const t=A(e),a=this,r=t.find(".infinite-scroll-content");t.is(".infinite-scroll-content")&&r.add(t),r.each((e=>{a.infiniteScroll.destroy(e)}))},pageInit(e){const t=this;e.$el.find(".infinite-scroll-content").each((e=>{t.infiniteScroll.create(e)}))},pageBeforeRemove(e){const t=this;e.$el.find(".infinite-scroll-content").each((e=>{t.infiniteScroll.destroy(e)}))}}};let ss=class extends ot{constructor(e,t){super({},[e]);const a=this,r=rt(),s=tt(),o=A(t),n=o.find(".ptr-preloader");a.$el=o,a.el=o[0],a.app=e,a.bottom=a.$el.hasClass("ptr-bottom"),a.useModulesParams({});const i="md"===e.theme,l="ios"===e.theme;let c,p,d;a.done=function(){const e=i?n:o,t=r=>{A(r.target).closest(n).length||(o.removeClass("ptr-transitioning ptr-pull-up ptr-pull-down ptr-closing"),o.trigger("ptr:done"),a.emit("local::done ptrDone",o[0]),e.off("transitionend",t))};return e.on("transitionend",t),o.removeClass("ptr-refreshing").addClass("ptr-transitioning ptr-closing"),a},a.refresh=function(){return o.hasClass("ptr-refreshing")||(o.addClass("ptr-transitioning ptr-refreshing"),o.trigger("ptr:refresh",a.done),a.emit("local::refresh ptrRefresh",o[0],a.done)),a},a.mousewheel="true"===o.attr("data-ptr-mousewheel");const u={};let h,m,f,g,v,b,w,y,C,E,k,$=!1,x=!1,T=!1,S=0,P=!1;const M=o.parents(".page");if((M.find(".navbar").length>0||M.parents(".view").children(".navbars").length>0)&&(P=!0),M.hasClass("no-navbar")&&(P=!1),!a.bottom){const t=e.navbar.getElByPage(M[0]);if(t){const e=A(t),a=e.hasClass("navbar-large-transparent")||e.hasClass("navbar-large")&&e.hasClass("navbar-transparent"),r=e.hasClass("navbar-transparent")&&!e.hasClass("navbar-large");a?o.addClass("ptr-with-navbar-large-transparent"):r&&o.addClass("ptr-with-navbar-transparent")}}function O(e){void 0===e&&(e=0);const t=n.find(".preloader-inner-line"),a=1/t.length;t.forEach(((t,r)=>{const s=(e-r*a)/a;t.style.opacity=.27*Math.max(Math.min(s,1),0)}))}function I(){n.find(".preloader-inner-line").css("opacity","")}function B(e){if(e.isTrusted){if(p){if("android"!==r.os)return;if("targetTouches"in e&&e.targetTouches.length>1)return}o.hasClass("ptr-refreshing")||A(e.target).closest(".sortable-handler, .ptr-ignore, .card-expandable.card-opened").length||(d=!1,y=!1,p=!0,h=void 0,v=void 0,"touchstart"===e.type&&(c=e.targetTouches[0].identifier),u.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,u.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY)}}function L(e){if(!p||!e.isTrusted)return;let s,P,M;if("touchmove"===e.type){if(c&&e.touches)for(let t=0;t<e.touches.length;t+=1)e.touches[t].identifier===c&&(M=e.touches[t]);M||(M=e.targetTouches[0]),s=M.pageX,P=M.pageY}else s=e.pageX,P=e.pageY;if(!s||!P)return;if(void 0===h&&(h=!!(h||Math.abs(P-u.y)>Math.abs(s-u.x))),!h)return void(p=!1);if(g=o[0].scrollTop,!d){let s;if(o.removeClass("ptr-transitioning"),l&&O(0),C=o[0].scrollHeight,E=o[0].offsetHeight,a.bottom&&(k=C-E),g>C)return void(p=!1);const n=A(e.target).closest(".ptr-watch-scroll");if(n.length&&n.each((e=>{e!==t&&e.scrollHeight>e.offsetHeight&&"auto"===A(e).css("overflow")&&(!a.bottom&&e.scrollTop>0||a.bottom&&e.scrollTop<e.scrollHeight-e.offsetHeight)&&(s=!0)})),s)return void(p=!1);w&&(b=o.attr("data-ptr-distance"),b.indexOf("%")>=0&&(b=C*parseInt(b,10)/100)),S=o.hasClass("ptr-refreshing")?b:0,x=!(C!==E&&"ios"===r.os&&!i),T=!1}d=!0,m=P-u.y,void 0===v&&(a.bottom?g!==k:0!==g)&&(v=!0);if(a.bottom?m<0&&g>=k||g>k:m>0&&g<=0||g<0){let t;"ios"===r.os&&parseInt(r.osVersion.split(".")[0],10)>7&&(a.bottom||0!==g||v||(x=!0),a.bottom&&g===k&&!v&&(x=!0)),x||!a.bottom||i||(o.css("-webkit-overflow-scrolling","auto"),o.scrollTop(k),T=!0),x||T?(e.cancelable&&e.preventDefault(),f=(a.bottom?-1*Math.abs(m)**.85:m**.85)+S,i?n.transform(`translate3d(0,${f}px,0)`).find(".ptr-arrow").transform(`rotate(${Math.abs(m)/66*180+100}deg)`):(a.bottom||l?o.children().transform(`translate3d(0,${f}px,0)`):o.transform(`translate3d(0,${f}px,0)`),l&&n.transform("translate3d(0,0px,0)"))):l&&!a.bottom&&n.transform(`translate3d(0,${g}px,0)`),l&&!$&&(t=x||T?Math.abs(m)**.85/b:Math.abs(m)/(2*b),O(t)),(x||T)&&Math.abs(m)**.85>b||!x&&Math.abs(m)>=2*b?($=!0,o.addClass("ptr-pull-up").removeClass("ptr-pull-down"),I()):($=!1,o.removeClass("ptr-pull-up").addClass("ptr-pull-down")),y||(o.trigger("ptr:pullstart"),a.emit("local::pullStart ptrPullStart",o[0]),y=!0),o.trigger("ptr:pullmove",{event:e,scrollTop:g,translate:f,touchesDiff:m}),a.emit("local::pullMove ptrPullMove",o[0],{event:e,scrollTop:g,translate:f,touchesDiff:m})}else y=!1,o.removeClass("ptr-pull-up ptr-pull-down"),$=!1}function D(e){if(e.isTrusted){if("touchend"===e.type&&e.changedTouches&&e.changedTouches.length>0&&c&&e.changedTouches[0].identifier!==c)return p=!1,h=!1,d=!1,void(c=null);if(!p||!d)return p=!1,void(d=!1);f&&(o.addClass("ptr-transitioning"),f=0),i?n.transform("").find(".ptr-arrow").transform(""):(n.transform(""),a.bottom||l?o.children().transform(""):o.transform("")),x||!a.bottom||i||o.css("-webkit-overflow-scrolling",""),$?(o.addClass("ptr-refreshing"),o.trigger("ptr:refresh",a.done),a.emit("local::refresh ptrRefresh",o[0],a.done)):o.removeClass("ptr-pull-down"),p=!1,d=!1,y&&(o.trigger("ptr:pullend"),a.emit("local::pullEnd ptrPullEnd",o[0]))}}let R,H;P||a.bottom||o.addClass("ptr-no-navbar"),o.attr("data-ptr-distance")?w=!0:i?b=66:l&&(b=44);let z=!0,N=0;function V(){z=!0,H=!1,N=0,f&&(o.addClass("ptr-transitioning"),f=0),i?n.transform("").find(".ptr-arrow").transform(""):(n.transform(""),a.bottom?o.children().transform(""):o.transform("")),$?(o.addClass("ptr-refreshing"),o.trigger("ptr:refresh",a.done),a.emit("local::refresh ptrRefresh",o[0],a.done)):o.removeClass("ptr-pull-down"),y&&(o.trigger("ptr:pullend"),a.emit("local::pullEnd ptrPullEnd",o[0]))}function F(e){if(!z)return;const{deltaX:r,deltaY:s}=e;if(Math.abs(r)>Math.abs(s))return;if(o.hasClass("ptr-refreshing"))return;if(A(e.target).closest(".sortable-handler, .ptr-ignore, .card-expandable.card-opened").length)return;if(clearTimeout(R),g=o[0].scrollTop,!H){let r;if(o.removeClass("ptr-transitioning"),l&&O(0),C=o[0].scrollHeight,E=o[0].offsetHeight,a.bottom&&(k=C-E),g>C)return void(z=!1);const s=A(e.target).closest(".ptr-watch-scroll");if(s.length&&s.each((e=>{e!==t&&e.scrollHeight>e.offsetHeight&&"auto"===A(e).css("overflow")&&(!a.bottom&&e.scrollTop>0||a.bottom&&e.scrollTop<e.scrollHeight-e.offsetHeight)&&(r=!0)})),r)return void(z=!1);w&&(b=o.attr("data-ptr-distance"),b.indexOf("%")>=0&&(b=C*parseInt(b,10)/100))}d=!0,N-=s,m=N,void 0===v&&(a.bottom?g!==k:0!==g)&&(v=!0);if(a.bottom?m<0&&g>=k||g>k:m>0&&g<=0||g<0){let t;e.cancelable&&e.preventDefault(),f=m,Math.abs(f)>b&&(f=b+(Math.abs(f)-b)**.7,a.bottom&&(f=-f)),i?n.transform(`translate3d(0,${f}px,0)`).find(".ptr-arrow").transform(`rotate(${Math.abs(m)/66*180+100}deg)`):a.bottom?o.children().transform(`translate3d(0,${f}px,0)`):(o.transform(`translate3d(0,${f}px,0)`),l&&n.transform(`translate3d(0,${-f}px,0)`)),l&&!$&&(t=Math.abs(f)/b,O(t)),Math.abs(f)>b?($=!0,o.addClass("ptr-pull-up").removeClass("ptr-pull-down"),I()):($=!1,o.removeClass("ptr-pull-up").addClass("ptr-pull-down")),y||(o.trigger("ptr:pullstart"),a.emit("local::pullStart ptrPullStart",o[0]),y=!0),o.trigger("ptr:pullmove",{event:e,scrollTop:g,translate:f,touchesDiff:m}),a.emit("local::pullMove ptrPullMove",o[0],{event:e,scrollTop:g,translate:f,touchesDiff:m})}else y=!1,o.removeClass("ptr-pull-up ptr-pull-down"),$=!1;R=setTimeout(V,300)}return M.length&&o.length?(o[0].f7PullToRefresh=a,a.attachEvents=function(){const t=!!s.passiveListener&&{passive:!0};o.on(e.touchEvents.start,B,t),e.on("touchmove:active",L),e.on("touchend:passive",D),a.mousewheel&&!a.bottom&&o.on("wheel",F)},a.detachEvents=function(){const t=!!s.passiveListener&&{passive:!0};o.off(e.touchEvents.start,B,t),e.off("touchmove:active",L),e.off("touchend:passive",D),a.mousewheel&&!a.bottom&&o.off("wheel",F)},a.useModules(),a.init(),a):a}init(){this.attachEvents()}destroy(){let e=this;e.emit("local::beforeDestroy ptrBeforeDestroy",e),e.$el.trigger("ptr:beforedestroy"),delete e.el.f7PullToRefresh,e.detachEvents(),Ie(e),e=null}};var os={name:"pullToRefresh",create(){const e=this;e.ptr=Fe(nt({defaultSelector:".ptr-content",constructor:ss,app:e,domProp:"f7PullToRefresh"}),{done(t){const a=e.ptr.get(t);if(a)return a.done()},refresh(t){const a=e.ptr.get(t);if(a)return a.refresh()}})},static:{PullToRefresh:ss},on:{tabMounted(e){const t=this,a=A(e),r=a.find(".ptr-content");a.is(".ptr-content")&&r.add(a),r.each((e=>{t.ptr.create(e)}))},tabBeforeRemove(e){const t=A(e),a=this,r=t.find(".ptr-content");t.is(".ptr-content")&&r.add(t),r.each((e=>{a.ptr.destroy(e)}))},pageInit(e){const t=this;e.$el.find(".ptr-content").each((e=>{t.ptr.create(e)}))},pageBeforeRemove(e){const t=this;e.$el.find(".ptr-content").each((e=>{t.ptr.destroy(e)}))}}};let ns=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r={};a.useModulesParams(r),a.params=Fe(r,t);const s=A(a.params.el);if(0!==s.length){if(a.$el=s,a.el=s[0],a.$el[0].f7DataTable){const e=a.$el[0].f7DataTable;return a.destroy(),e}return a.$el[0].f7DataTable=a,Fe(a,{collapsible:s.hasClass("data-table-collapsible"),$headerEl:s.find(".data-table-header"),$headerSelectedEl:s.find(".data-table-header-selected")}),a.attachEvents=function(){a.$el.on("change",'.checkbox-cell input[type="checkbox"]',o),a.$el.find("thead .sortable-cell").on("click",n)},a.detachEvents=function(){a.$el.off("change",'.checkbox-cell input[type="checkbox"]',o),a.$el.find("thead .sortable-cell").off("click",n)},a.useModules(),a.init(),a}function o(e){if(e.detail&&e.detail.sentByF7DataTable)return;const t=A(this),r=t[0].checked,o=t.parents("td,th").index();if(t.parents("thead").length>0)0===o&&s.find("tbody tr")[r?"addClass":"removeClass"]("data-table-row-selected"),s.find(`tbody tr td:nth-child(${o+1}) input`).prop("checked",r).trigger("change",{sentByF7DataTable:!0}),t.prop("indeterminate",!1);else{0===o&&t.parents("tr")[r?"addClass":"removeClass"]("data-table-row-selected");const e=s.find(`tbody .checkbox-cell:nth-child(${o+1}) input[type="checkbox"]:checked`).length,a=s.find("tbody tr").length,n=s.find(`thead .checkbox-cell:nth-child(${o+1}) input[type="checkbox"]`);r?e===a&&n.prop("checked",!0).trigger("change",{sentByF7DataTable:!0}):n.prop("checked",!1),n.prop("indeterminate",e>0&&e<a)}a.checkSelectedHeader()}function n(){const e=A(this),t=e.hasClass("sortable-cell-active"),r=e.hasClass("sortable-desc")?"desc":"asc";let o;t?(o="desc"===r?"asc":"desc",e.removeClass("sortable-desc sortable-asc").addClass(`sortable-${o}`)):(s.find("thead .sortable-cell-active").removeClass("sortable-cell-active"),e.addClass("sortable-cell-active"),o=r),e.trigger("datatable:sort",o),a.emit("local::sort dataTableSort",a,o)}}setCollapsibleLabels(){const e=this;e.collapsible&&e.$el.find("tbody td:not(.checkbox-cell)").each((t=>{const a=A(t),r=a.index(),s=a.attr("data-collapsible-title");s||""===s||a.attr("data-collapsible-title",e.$el.find("thead th").eq(r).text())}))}checkSelectedHeader(){const e=this;if(e.$headerEl.length>0&&e.$headerSelectedEl.length>0){const t=e.$el.find("tbody .checkbox-cell input:checked").length;e.$el[t>0?"addClass":"removeClass"]("data-table-has-checked"),e.$headerSelectedEl.find(".data-table-selected-count").text(t)}}init(){const e=this;e.attachEvents(),e.setCollapsibleLabels(),e.checkSelectedHeader()}destroy(){let e=this;e.$el.trigger("datatable:beforedestroy"),e.emit("local::beforeDestroy dataTableBeforeDestroy",e),e.detachEvents(),e.$el[0]&&(e.$el[0].f7DataTable=null,delete e.$el[0].f7DataTable),Ie(e),e=null}};var is={name:"dataTable",static:{DataTable:ns},create(){this.dataTable=nt({defaultSelector:".data-table",constructor:ns,app:this,domProp:"f7DataTable"})},on:{tabBeforeRemove(e){const t=this;A(e).find(".data-table-init").each((e=>{t.dataTable.destroy(e)}))},tabMounted(e){const t=this;A(e).find(".data-table-init").each((e=>{t.dataTable.create({el:e})}))},pageBeforeRemove(e){const t=this;e.$el.find(".data-table-init").each((e=>{t.dataTable.destroy(e)}))},pageInit(e){const t=this;e.$el.find(".data-table-init").each((e=>{t.dataTable.create({el:e})}))}},vnode:{"data-table-init":{insert(e){const t=e.elm;this.dataTable.create({el:t})},destroy(e){const t=e.elm;this.dataTable.destroy(t)}}}};const ls={morphOpen(e,t){const a=this,r=A(e),s=A(t);if(0===s.length)return;s.transition(0).addClass("fab-morph-target-visible");const o={width:s[0].offsetWidth,height:s[0].offsetHeight,offset:s.offset(),borderRadius:s.css("border-radius"),zIndex:s.css("z-index")},n={width:r[0].offsetWidth,height:r[0].offsetHeight,offset:r.offset(),translateX:He(r[0],"x"),translateY:He(r[0],"y")};r[0].f7FabMorphData={$targetEl:s,target:o,fab:n};const i=n.offset.left+n.width/2-(o.offset.left+o.width/2)-n.translateX,l=n.offset.top+n.height/2-(o.offset.top+o.height/2)-n.translateY,c=o.width/n.width,p=o.height/n.height;let d=Math.ceil(parseInt(o.borderRadius,10)/Math.max(c,p));d>0&&(d+=2),r[0].f7FabMorphResizeHandler=function(){r.transition(0).transform(""),s.transition(0),o.width=s[0].offsetWidth,o.height=s[0].offsetHeight,o.offset=s.offset(),n.offset=r.offset();const e=n.offset.left+n.width/2-(o.offset.left+o.width/2)-n.translateX,t=n.offset.top+n.height/2-(o.offset.top+o.height/2)-n.translateY,a=o.width/n.width,i=o.height/n.height;r.transform(`translate3d(${-e}px, ${-t}px, 0) scale(${a}, ${i})`)},s.css("opacity",0).transform(`scale(${1/c}, ${1/p})`),r.addClass("fab-opened").css("z-index",o.zIndex-1).transform(`translate3d(${-i}px, ${-l}px, 0)`),r.transitionEnd((()=>{s.transition(""),De((()=>{s.css("opacity",1).transform("scale(1,1)"),r.transform(`translate3d(${-i}px, ${-l}px, 0) scale(${c}, ${p})`).css("border-radius",`${d}px`).css("box-shadow","none").css("opacity","0")})),a.on("resize",r[0].f7FabMorphResizeHandler),s.parents(".page-content").length>0&&s.parents(".page-content").on("scroll",r[0].f7FabMorphResizeHandler)}))},morphClose(e){const t=A(e),a=t[0].f7FabMorphData;if(!a)return;const{$targetEl:r,target:s,fab:o}=a;if(0===r.length)return;const n=o.offset.left+o.width/2-(s.offset.left+s.width/2)-o.translateX,i=o.offset.top+o.height/2-(s.offset.top+s.height/2)-o.translateY,l=s.width/o.width,c=s.height/o.height;this.off("resize",t[0].f7FabMorphResizeHandler),r.parents(".page-content").length>0&&r.parents(".page-content").off("scroll",t[0].f7FabMorphResizeHandler),r.css("opacity",0).transform(`scale(${1/l}, ${1/c})`),t.transition("").css("box-shadow","").css("border-radius","").css("opacity","1").transform(`translate3d(${-n}px, ${-i}px, 0)`),t.transitionEnd((()=>{t.css("z-index","").removeClass("fab-opened").transform(""),De((()=>{t.transitionEnd((()=>{r.removeClass("fab-morph-target-visible").css("opacity","").transform("").transition("")}))}))}))},open(e,t){const a=this,r=A(e).eq(0),s=r.find(".fab-buttons");if(r.length&&!r.hasClass("fab-opened")&&(s.length||r.hasClass("fab-morph"))){if(a.fab.openedEl){if(a.fab.openedEl===r[0])return;a.fab.close(a.fab.openedEl)}a.fab.openedEl=r[0],r.hasClass("fab-morph")?a.fab.morphOpen(r,t||r.attr("data-morph-to")):r.addClass("fab-opened"),r.siblings(".fab-backdrop").addClass("backdrop-in"),r.trigger("fab:open")}},close(e){void 0===e&&(e=".fab-opened");const t=this,a=A(e).eq(0),r=a.find(".fab-buttons");a.length&&a.hasClass("fab-opened")&&(r.length||a.hasClass("fab-morph"))&&(t.fab.openedEl=null,a.hasClass("fab-morph")?t.fab.morphClose(a):a.removeClass("fab-opened"),a.siblings(".fab-backdrop").removeClass("backdrop-in"),a.trigger("fab:close"))},toggle(e){A(e).hasClass("fab-opened")?this.fab.close(e):this.fab.open(e)}};var cs={name:"fab",create(){Ke(this,{fab:{openedEl:null,...ls}})},clicks:{".fab > a":function(e){this.fab.toggle(e.parents(".fab"))},".fab-open":function(e,t){void 0===t&&(t={});this.fab.open(t.fab)},".fab-close":function(e,t){void 0===t&&(t={});this.fab.close(t.fab)},".fab-backdrop":function(){this.fab.close()}}};let ps=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r={el:void 0,inputEl:void 0,inputEvents:"change input compositionend",disableButton:!0,disableButtonEl:void 0,backdropEl:void 0,searchContainer:void 0,searchItem:"li",searchIn:void 0,searchGroup:".list-group",searchGroupTitle:".list-group-title",ignore:".searchbar-ignore",foundEl:".searchbar-found",notFoundEl:".searchbar-not-found",hideOnEnableEl:".searchbar-hide-on-enable",hideOnSearchEl:".searchbar-hide-on-search",backdrop:!0,removeDiacritics:!0,customSearch:!1,hideGroupTitles:!0,hideGroups:!0,disableOnBackdropClick:!0,expandable:!1,inline:!1};a.useModulesParams(r),a.params=Fe(r,t);const s=A(a.params.el);if(0===s.length)return a;if(s[0].f7Searchbar)return s[0].f7Searchbar;let o;s[0].f7Searchbar=a;const n=s.parents(".navbar");if(s.parents(".page").length>0)o=s.parents(".page");else if(n.length>0&&(o=A(e.navbar.getPageByEl(n[0])),!o.length)){const e=s.parents(".view").find(".page-current");e[0]&&e[0].f7Page&&e[0].f7Page.navbarEl===n[0]&&(o=e)}let i,l,c,p;t.foundEl?i=A(t.foundEl):"string"==typeof a.params.foundEl&&o&&(i=o.find(a.params.foundEl)),t.notFoundEl?l=A(t.notFoundEl):"string"==typeof a.params.notFoundEl&&o&&(l=o.find(a.params.notFoundEl)),t.hideOnEnableEl?c=A(t.hideOnEnableEl):"string"==typeof a.params.hideOnEnableEl&&o&&(c=o.find(a.params.hideOnEnableEl)),t.hideOnSearchEl?p=A(t.hideOnSearchEl):"string"==typeof a.params.hideOnSearchEl&&o&&(p=o.find(a.params.hideOnSearchEl));const d=a.params.expandable||s.hasClass("searchbar-expandable"),u=a.params.inline||s.hasClass("searchbar-inline");let h,m,f,g;function v(e){e.preventDefault()}function b(e){a.enable(e),a.$el.addClass("searchbar-focused")}function w(){a.$el.removeClass("searchbar-focused")}function y(){const e=a.$inputEl.val().trim();(a.$searchContainer&&a.$searchContainer.length>0&&(a.params.searchIn||a.isVirtualList||a.params.searchIn===a.params.searchItem)||a.params.customSearch)&&a.search(e,!0)}function C(e,t){a.$el.trigger("searchbar:clear",t),a.emit("local::clear searchbarClear",a,t)}function E(e){a.disable(e)}function k(){!a||a&&!a.$el||a.enabled&&(a.$el.removeClass("searchbar-enabled"),a.expandable&&a.$el.parents(".navbar").removeClass("with-searchbar-expandable-enabled with-searchbar-expandable-enabled-no-transition"))}function $(){!a||a&&!a.$el||a.enabled&&(a.$el.addClass("searchbar-enabled"),a.expandable&&a.$el.parents(".navbar").addClass("with-searchbar-expandable-enabled-no-transition"))}return void 0===a.params.backdrop&&(a.params.backdrop=!u),a.params.backdrop&&(h=a.params.backdropEl?A(a.params.backdropEl):o&&o.length>0?o.find(".searchbar-backdrop"):s.siblings(".searchbar-backdrop"),0===h.length&&(h=A('<div class="searchbar-backdrop"></div>'),o&&o.length?s.parents(o).length>0&&n&&0===s.parents(n).length?h.insertBefore(s):h.insertBefore(o.find(".page-content").eq(0)):h.insertBefore(s))),a.params.searchContainer&&(m=A(a.params.searchContainer)),f=a.params.inputEl?A(a.params.inputEl):s.find('input[type="search"]').eq(0),a.params.disableButton&&(g=a.params.disableButtonEl?A(a.params.disableButtonEl):s.find(".searchbar-disable-button")),Fe(a,{app:e,view:e.views.get(s.parents(".view")),$el:s,el:s[0],$backdropEl:h,backdropEl:h&&h[0],$searchContainer:m,searchContainer:m&&m[0],$inputEl:f,inputEl:f[0],$disableButtonEl:g,disableButtonEl:g&&g[0],disableButtonHasMargin:!1,$pageEl:o,pageEl:o&&o[0],$navbarEl:n,navbarEl:n&&n[0],$foundEl:i,foundEl:i&&i[0],$notFoundEl:l,notFoundEl:l&&l[0],$hideOnEnableEl:c,hideOnEnableEl:c&&c[0],$hideOnSearchEl:p,hideOnSearchEl:p&&p[0],previousQuery:"",query:"",isVirtualList:m&&m.hasClass("virtual-list"),virtualList:void 0,enabled:!1,expandable:d,inline:u}),a.attachEvents=function(){s.on("submit",v),a.params.disableButton&&a.$disableButtonEl.on("click",E),a.params.disableOnBackdropClick&&a.$backdropEl&&a.$backdropEl.on("click",E),a.expandable&&"ios"===e.theme&&a.view&&n.length&&a.$pageEl&&(a.$pageEl.on("page:beforeout",k),a.$pageEl.on("page:beforein",$)),a.$inputEl.on("focus",b),a.$inputEl.on("blur",w),a.$inputEl.on(a.params.inputEvents,y),a.$inputEl.on("input:clear",C)},a.detachEvents=function(){s.off("submit",v),a.params.disableButton&&a.$disableButtonEl.off("click",E),a.params.disableOnBackdropClick&&a.$backdropEl&&a.$backdropEl.off("click",E),a.expandable&&"ios"===e.theme&&a.view&&n.length&&a.$pageEl&&(a.$pageEl.off("page:beforeout",k),a.$pageEl.off("page:beforein",$)),a.$inputEl.off("focus",b),a.$inputEl.off("blur",w),a.$inputEl.off(a.params.inputEvents,y),a.$inputEl.off("input:clear",C)},a.useModules(),a.init(),a}clear(e){const t=this;if(!t.query&&e&&A(e.target).hasClass("searchbar-clear"))return t.disable(),t;const a=t.value;return t.$inputEl.val("").trigger("change").focus(),t.$el.trigger("searchbar:clear",a),t.emit("local::clear searchbarClear",t,a),t}setDisableButtonMargin(){const e=this;if(e.expandable)return;const t=e.app;e.$disableButtonEl.transition(0).show(),e.$disableButtonEl.css("margin-"+(t.rtl?"left":"right"),-e.disableButtonEl.offsetWidth+"px"),e._clientLeft=e.$disableButtonEl[0].clientLeft,e.$disableButtonEl.transition(""),e.disableButtonHasMargin=!0}enable(e){const t=this;if(t.enabled)return t;const a=t.app,s=r(),o=rt();function n(){if(t.$backdropEl&&(t.$searchContainer&&t.$searchContainer.length||t.params.customSearch)&&!t.$el.hasClass("searchbar-enabled")&&!t.query&&t.backdropShow(),t.$el.addClass("searchbar-enabled"),(!t.$disableButtonEl||t.$disableButtonEl&&0===t.$disableButtonEl.length)&&t.$el.addClass("searchbar-enabled-no-disable-button"),!t.expandable&&t.$disableButtonEl&&t.$disableButtonEl.length>0&&"md"!==a.theme&&(t.disableButtonHasMargin||t.setDisableButtonMargin(),t.$disableButtonEl.css("margin-"+(a.rtl?"left":"right"),"0px")),t.expandable){const e=t.$el.parents(".navbar");if(e.hasClass("navbar-large")&&t.$pageEl){const a=t.$pageEl.find(".page-content"),r=e.find(".title-large");a.addClass("with-searchbar-expandable-enabled"),e.hasClass("navbar-large")&&e.hasClass("navbar-large-collapsed")&&r.length&&a.length&&(a.transition(0),a[0].scrollTop-=r[0].offsetHeight,setTimeout((()=>{a.transition("")}),200))}"md"===a.theme&&e.length?e.addClass("with-searchbar-expandable-enabled"):(e.addClass("with-searchbar-expandable-enabled"),e.hasClass("navbar-large")&&e.addClass("navbar-large-collapsed"))}t.$hideOnEnableEl&&t.$hideOnEnableEl.addClass("hidden-by-searchbar"),t.$el.trigger("searchbar:enable"),t.emit("local::enable searchbarEnable",t)}t.enabled=!0;let i=!1;!0===e&&s.activeElement!==t.inputEl&&(i=!0);return o.ios&&"ios"===a.theme?t.expandable?(i&&t.$inputEl.focus(),n()):(i&&t.$inputEl.focus(),!e||"focus"!==e.type&&!0!==e?n():Le((()=>{n()}),400)):(i&&t.$inputEl.focus(),"md"===a.theme&&t.expandable&&t.$el.parents(".page, .view, .navbar-inner, .navbar").scrollLeft(a.rtl?100:0),n()),t}disable(){const e=this;if(!e.enabled)return e;const t=e.app;if(e.$inputEl.val("").trigger("change"),e.$el.removeClass("searchbar-enabled searchbar-focused searchbar-enabled-no-disable-button"),e.expandable){const a=e.$el.parents(".navbar"),r=e.$pageEl&&e.$pageEl.find(".page-content");if(a.hasClass("navbar-large")&&r.length){const t=a.find(".title-large");if(e.$el.transitionEnd((()=>{r.removeClass("with-searchbar-expandable-closing")})),a.hasClass("navbar-large")&&a.hasClass("navbar-large-collapsed")&&t.length){const e=r[0].scrollTop,a=t[0].offsetHeight;e>a&&(r.transition(0),r[0].scrollTop=e+a,setTimeout((()=>{r.transition("")}),200))}r.removeClass("with-searchbar-expandable-enabled").addClass("with-searchbar-expandable-closing")}"md"===t.theme&&a.length?(a.removeClass("with-searchbar-expandable-enabled with-searchbar-expandable-enabled-no-transition").addClass("with-searchbar-expandable-closing"),e.$el.transitionEnd((()=>{a.removeClass("with-searchbar-expandable-closing")}))):(a.removeClass("with-searchbar-expandable-enabled with-searchbar-expandable-enabled-no-transition").addClass("with-searchbar-expandable-closing"),e.$el.transitionEnd((()=>{a.removeClass("with-searchbar-expandable-closing")})),e.$pageEl&&e.$pageEl.find(".page-content").trigger("scroll"))}return!e.expandable&&e.$disableButtonEl&&e.$disableButtonEl.length>0&&"md"!==t.theme&&e.$disableButtonEl.css("margin-"+(t.rtl?"left":"right"),-e.disableButtonEl.offsetWidth+"px"),e.$backdropEl&&(e.$searchContainer&&e.$searchContainer.length||e.params.customSearch)&&e.backdropHide(),e.enabled=!1,e.$inputEl.blur(),e.$hideOnEnableEl&&e.$hideOnEnableEl.removeClass("hidden-by-searchbar"),e.$el.trigger("searchbar:disable"),e.emit("local::disable searchbarDisable",e),e}toggle(){const e=this;return e.enabled?e.disable():e.enable(!0),e}backdropShow(){const e=this;return e.$backdropEl&&e.$backdropEl.addClass("searchbar-backdrop-in"),e}backdropHide(){const e=this;return e.$backdropEl&&e.$backdropEl.removeClass("searchbar-backdrop-in"),e}search(e,t){const a=this;if(a.previousQuery=a.query||"",e===a.previousQuery)return a;t||(a.enabled||a.enable(),a.$inputEl.val(e),a.$inputEl.trigger("input")),a.query=e,a.value=e;const{$searchContainer:r,$el:s,$foundEl:o,$notFoundEl:n,$hideOnSearchEl:i,isVirtualList:l}=a;if(e.length>0&&i?i.addClass("hidden-by-searchbar"):i&&i.removeClass("hidden-by-searchbar"),(r&&r.length&&s.hasClass("searchbar-enabled")||a.params.customSearch&&s.hasClass("searchbar-enabled"))&&(0===e.length?a.backdropShow():a.backdropHide()),a.params.customSearch)return s.trigger("searchbar:search",{query:e,previousQuery:a.previousQuery}),a.emit("local::search searchbarSearch",a,e,a.previousQuery),a;let c,p=[];if(l){if(a.virtualList=r[0].f7VirtualList,""===e.trim())return a.virtualList.resetFilter(),n&&n.hide(),o&&o.show(),s.trigger("searchbar:search",{query:e,previousQuery:a.previousQuery}),a.emit("local::search searchbarSearch",a,e,a.previousQuery),a;if(c=a.params.removeDiacritics?Ur(e):e,a.virtualList.params.searchAll)p=a.virtualList.params.searchAll(c,a.virtualList.items)||[];else if(a.virtualList.params.searchByItem)for(let e=0;e<a.virtualList.items.length;e+=1)a.virtualList.params.searchByItem(c,a.virtualList.items[e],e)&&p.push(e)}else{let t;t=a.params.removeDiacritics?Ur(e.trim().toLowerCase()).split(" "):e.trim().toLowerCase().split(" "),r.find(a.params.searchItem).removeClass("hidden-by-searchbar").each((e=>{const r=A(e);let s=[],o=a.params.searchIn?r.find(a.params.searchIn):r;a.params.searchIn===a.params.searchItem&&(o=r),o.each((e=>{let t=A(e).text().trim().toLowerCase();a.params.removeDiacritics&&(t=Ur(t)),s.push(t)})),s=s.join(" ");let n=0;for(let e=0;e<t.length;e+=1)s.indexOf(t[e])>=0&&(n+=1);n===t.length||a.params.ignore&&r.is(a.params.ignore)?p.push(r[0]):r.addClass("hidden-by-searchbar")})),a.params.hideGroupTitles&&r.find(a.params.searchGroupTitle).each((e=>{const t=A(e),r=t.nextAll(a.params.searchItem);let s=!0;for(let e=0;e<r.length;e+=1){const t=r.eq(e);if(t.is(a.params.searchGroupTitle))break;t.hasClass("hidden-by-searchbar")||(s=!1)}const o=a.params.ignore&&t.is(a.params.ignore);s&&!o?t.addClass("hidden-by-searchbar"):t.removeClass("hidden-by-searchbar")})),a.params.hideGroups&&r.find(a.params.searchGroup).each((e=>{const t=A(e),r=a.params.ignore&&t.is(a.params.ignore);0!==t.find(a.params.searchItem).filter((e=>!A(e).hasClass("hidden-by-searchbar"))).length||r?t.removeClass("hidden-by-searchbar"):t.addClass("hidden-by-searchbar")}))}return 0===p.length?(n&&n.show(),o&&o.hide()):(n&&n.hide(),o&&o.show()),l&&a.virtualList&&a.virtualList.filterItems(p),s.trigger("searchbar:search",{query:e,previousQuery:a.previousQuery,foundItems:p}),a.emit("local::search searchbarSearch",a,e,a.previousQuery,p),a}init(){const e=this;e.expandable&&e.$el&&e.$el.addClass("searchbar-expandable"),e.inline&&e.$el&&e.$el.addClass("searchbar-inline"),e.attachEvents()}destroy(){const e=this;e.emit("local::beforeDestroy searchbarBeforeDestroy",e),e.$el.trigger("searchbar:beforedestroy"),e.detachEvents(),e.$el[0]&&(e.$el[0].f7Searchbar=null,delete e.$el[0].f7Searchbar),Ie(e)}};var ds={name:"searchbar",static:{Searchbar:ps},create(){this.searchbar=nt({defaultSelector:".searchbar",constructor:ps,app:this,domProp:"f7Searchbar",addMethods:"clear enable disable toggle search".split(" ")})},on:{tabMounted(e){const t=this;A(e).find(".searchbar-init").each((e=>{const a=A(e);t.searchbar.create(Fe(a.dataset(),{el:e}))}))},tabBeforeRemove(e){A(e).find(".searchbar-init").each((e=>{e.f7Searchbar&&e.f7Searchbar.destroy&&e.f7Searchbar.destroy()}))},pageInit(e){const t=this;e.$el.find(".searchbar-init").each((e=>{const a=A(e);t.searchbar.create(Fe(a.dataset(),{el:e}))})),"ios"===t.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".searchbar-init").each((e=>{const a=A(e);t.searchbar.create(Fe(a.dataset(),{el:e}))}))},pageBeforeRemove(e){e.$el.find(".searchbar-init").each((e=>{e.f7Searchbar&&e.f7Searchbar.destroy&&e.f7Searchbar.destroy()})),"ios"===this.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".searchbar-init").each((e=>{e.f7Searchbar&&e.f7Searchbar.destroy&&e.f7Searchbar.destroy()}))}},clicks:{".searchbar-clear":function(e,t){void 0===t&&(t={});const a=this.searchbar.get(t.searchbar);a&&a.clear()},".searchbar-enable":function(e,t){void 0===t&&(t={});const a=this.searchbar.get(t.searchbar);a&&a.enable(!0)},".searchbar-disable":function(e,t){void 0===t&&(t={});const a=this.searchbar.get(t.searchbar);a&&a.disable()},".searchbar-toggle":function(e,t){void 0===t&&(t={});const a=this.searchbar.get(t.searchbar);a&&a.toggle()}},vnode:{"searchbar-init":{insert(e){const t=e.elm,a=A(t);this.searchbar.create(Fe(a.dataset(),{el:t}))},destroy(e){const t=e.elm;t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()}}}};function us(e){var t,a;function r(t,a){try{var o=e[t](a),n=o.value,i=n instanceof hs;Promise.resolve(i?n.v:n).then((function(a){if(i){var l="return"===t?"return":"next";if(!n.k||a.done)return r(l,a);a=e[l](a).value}s(o.done?"return":"normal",a)}),(function(e){r("throw",e)}))}catch(e){s("throw",e)}}function s(e,s){switch(e){case"return":t.resolve({value:s,done:!0});break;case"throw":t.reject(s);break;default:t.resolve({value:s,done:!1})}(t=t.next)?r(t.key,t.arg):a=null}this._invoke=function(e,s){return new Promise((function(o,n){var i={key:e,arg:s,resolve:o,reject:n,next:null};a?a=a.next=i:(t=a=i,r(e,s))}))},"function"!=typeof e.return&&(this.return=void 0)}function hs(e,t){this.v=e,this.k=t}function ms(){return ms=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var a=arguments[t];for(var r in a)Object.prototype.hasOwnProperty.call(a,r)&&(e[r]=a[r])}return e},ms.apply(this,arguments)}us.prototype["function"==typeof Symbol&&Symbol.asyncIterator||"@@asyncIterator"]=function(){return this},us.prototype.next=function(e){return this._invoke("next",e)},us.prototype.throw=function(e){return this._invoke("throw",e)},us.prototype.return=function(e){return this._invoke("return",e)};let fs=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r={autoLayout:!0,messages:[],newMessagesFirst:!1,scrollMessages:!0,scrollMessagesOnEdge:!0,firstMessageRule:void 0,lastMessageRule:void 0,tailMessageRule:void 0,sameNameMessageRule:void 0,sameHeaderMessageRule:void 0,sameFooterMessageRule:void 0,sameAvatarMessageRule:void 0,customClassMessageRule:void 0,renderMessage:void 0};a.useModulesParams(r),a.params=Fe(r,t);const s=A(t.el).eq(0);if(0===s.length)return a;if(s[0].f7Messages)return s[0].f7Messages;s[0].f7Messages=a;const o=s.closest(".page-content").eq(0);return Fe(a,{messages:a.params.messages,$el:s,el:s[0],$pageContentEl:o,pageContentEl:o[0]}),a.useModules(),a.init(),a}getMessageData(e){const t=A(e),a={name:t.find(".message-name").html(),header:t.find(".message-header").html(),textHeader:t.find(".message-text-header").html(),textFooter:t.find(".message-text-footer").html(),footer:t.find(".message-footer").html(),isTitle:t.hasClass("messages-title"),type:t.hasClass("message-sent")?"sent":"received",text:t.find(".message-text").html(),image:t.find(".message-image").html(),imageSrc:t.find(".message-image img").attr("src"),typing:t.hasClass("message-typing")};a.isTitle&&(a.text=t.html()),a.text&&a.textHeader&&(a.text=a.text.replace(`<div class="message-text-header">${a.textHeader}</div>`,"")),a.text&&a.textFooter&&(a.text=a.text.replace(`<div class="message-text-footer">${a.textFooter}</div>`,""));let r=t.find(".message-avatar").css("background-image");return"none"!==r&&""!==r||(r=void 0),r=r&&"string"==typeof r?r.replace("url(","").replace(")","").replace(/"/g,"").replace(/'/g,""):void 0,a.avatar=r,a}getMessagesData(){const e=this,t=[];return e.$el.find(".message, .messages-title").each((a=>{t.push(e.getMessageData(a))})),t}renderMessage(e){const t=this,a=Fe({type:"sent",attrs:{}},e);return t.params.renderMessage?t.params.renderMessage.call(t,a):a.isTitle?`<div class="messages-title">${a.text}</div>`:ct("div",ms({class:`message message-${a.type} ${a.isTyping?"message-typing":""} ${a.cssClass||""}`},a.attrs),a.avatar&&ct("div",{class:"message-avatar",style:`background-image:url(${a.avatar})`}),ct("div",{class:"message-content"},a.name&&ct("div",{class:"message-name"},a.name),a.header&&ct("div",{class:"message-header"},a.header),ct("div",{class:"message-bubble"},a.textHeader&&ct("div",{class:"message-text-header"},a.textHeader),a.image&&ct("div",{class:"message-image"},a.image),a.imageSrc&&!a.image&&ct("div",{class:"message-image"},ct("img",{src:a.imageSrc})),(a.text||a.isTyping)&&ct("div",{class:"message-text"},a.text||"",a.isTyping&&ct("div",{class:"message-typing-indicator"},ct("div",null),ct("div",null),ct("div",null))),a.textFooter&&ct("div",{class:"message-text-footer"},a.textFooter)),a.footer&&ct("div",{class:"message-footer"},a.footer)))}renderMessages(e,t){void 0===e&&(e=this.messages),void 0===t&&(t=this.params.newMessagesFirst?"prepend":"append");const a=this,r=e.map((e=>a.renderMessage(e))).join("");a.$el[t](r)}isFirstMessage(){return!!this.params.firstMessageRule&&this.params.firstMessageRule(...arguments)}isLastMessage(){return!!this.params.lastMessageRule&&this.params.lastMessageRule(...arguments)}isTailMessage(){return!!this.params.tailMessageRule&&this.params.tailMessageRule(...arguments)}isSameNameMessage(){return!!this.params.sameNameMessageRule&&this.params.sameNameMessageRule(...arguments)}isSameHeaderMessage(){return!!this.params.sameHeaderMessageRule&&this.params.sameHeaderMessageRule(...arguments)}isSameFooterMessage(){return!!this.params.sameFooterMessageRule&&this.params.sameFooterMessageRule(...arguments)}isSameAvatarMessage(){return!!this.params.sameAvatarMessageRule&&this.params.sameAvatarMessageRule(...arguments)}isCustomClassMessage(){if(this.params.customClassMessageRule)return this.params.customClassMessageRule(...arguments)}layout(){const e=this;e.$el.find(".message, .messages-title").each(((t,a)=>{const r=A(t);e.messages||(e.messages=e.getMessagesData());const s=[],o=e.messages[a],n=e.messages[a-1],i=e.messages[a+1];e.isFirstMessage(o,n,i)&&s.push("message-first"),e.isLastMessage(o,n,i)&&s.push("message-last"),e.isTailMessage(o,n,i)&&s.push("message-tail"),e.isSameNameMessage(o,n,i)&&s.push("message-same-name"),e.isSameHeaderMessage(o,n,i)&&s.push("message-same-header"),e.isSameFooterMessage(o,n,i)&&s.push("message-same-footer"),e.isSameAvatarMessage(o,n,i)&&s.push("message-same-avatar");let l=e.isCustomClassMessage(o,n,i);l&&l.length&&("string"==typeof l&&(l=l.split(" ")),l.forEach((e=>{s.push(e)}))),r.removeClass("message-first message-last message-tail message-same-name message-same-header message-same-footer message-same-avatar"),s.forEach((e=>{r.addClass(e)}))}))}clear(){this.messages=[],this.$el.html("")}removeMessage(e,t){void 0===t&&(t=!0);const a=this;let r,s;return"number"==typeof e?(r=e,s=a.$el.find(".message, .messages-title").eq(r)):a.messages&&a.messages.indexOf(e)>=0?(r=a.messages.indexOf(e),s=a.$el.children().eq(r)):(s=A(e),r=s.index()),0===s.length||(s.remove(),a.messages.splice(r,1),a.params.autoLayout&&t&&a.layout()),a}removeMessages(e,t){void 0===t&&(t=!0);const a=this;if(Array.isArray(e)){const t=[];e.forEach((e=>{t.push(a.$el.find(".message, .messages-title").eq(e))})),t.forEach((e=>{a.removeMessage(e,!1)}))}else A(e).each((e=>{a.removeMessage(e,!1)}));return a.params.autoLayout&&t&&a.layout(),a}addMessage(){const e=this;let t,a,r;for(var s=arguments.length,o=new Array(s),n=0;n<s;n++)o[n]=arguments[n];return"boolean"==typeof o[1]?[t,a,r]=o:[t,r,a]=o,void 0===a&&(a=!0),void 0===r&&(r=e.params.newMessagesFirst?"prepend":"append"),e.addMessages([t],a,r)}setScrollData(){const e=this,t=e.pageContentEl.scrollHeight,a=e.pageContentEl.offsetHeight,r=e.pageContentEl.scrollTop;return e.scrollData={scrollHeightBefore:t,heightBefore:a,scrollBefore:r},{scrollHeightBefore:t,heightBefore:a,scrollBefore:r}}addMessages(){const e=this;let t,a,r;for(var s=arguments.length,o=new Array(s),n=0;n<s;n++)o[n]=arguments[n];"boolean"==typeof o[1]?[t,a,r]=o:[t,r,a]=o,void 0===a&&(a=!0),void 0===r&&(r=e.params.newMessagesFirst?"prepend":"append");const{scrollHeightBefore:i,scrollBefore:l}=e.setScrollData();let c="";const p=e.messages.filter((e=>e.isTyping))[0];t.forEach((t=>{p?"append"===r?e.messages.splice(e.messages.indexOf(p),0,t):e.messages.splice(e.messages.indexOf(p)+1,0,t):e.messages["append"===r?"push":"unshift"](t),c+=e.renderMessage(t)}));const d=A(c);return a&&("append"!==r||e.params.newMessagesFirst||d.addClass("message-appear-from-bottom"),"prepend"===r&&e.params.newMessagesFirst&&d.addClass("message-appear-from-top")),p?"append"===r?d.insertBefore(e.$el.find(".message-typing")):d.insertAfter(e.$el.find(".message-typing")):e.$el[r](d),e.params.autoLayout&&e.layout(),"prepend"!==r||p||(e.pageContentEl.scrollTop=l+(e.pageContentEl.scrollHeight-i)),e.params.scrollMessages&&("append"===r&&!e.params.newMessagesFirst||"prepend"===r&&e.params.newMessagesFirst&&!p)&&e.scrollWithEdgeCheck(a),e}showTyping(e){void 0===e&&(e={});const t=this,a=t.messages.filter((e=>e.isTyping))[0];return a&&t.removeMessage(t.messages.indexOf(a)),t.addMessage(Fe({type:"received",isTyping:!0},e)),t}hideTyping(){const e=this;let t,a;if(e.messages.forEach(((e,a)=>{e.isTyping&&(t=a)})),void 0!==t&&e.$el.find(".message").eq(t).hasClass("message-typing")&&(a=!0,e.removeMessage(t)),!a){const t=e.$el.find(".message-typing");t.length&&e.removeMessage(t)}return e}scrollWithEdgeCheck(e){const t=this,{scrollBefore:a,scrollHeightBefore:r,heightBefore:s}=t.scrollData;if(t.params.scrollMessagesOnEdge){let o=!1;t.params.newMessagesFirst&&0===a&&(o=!0),!t.params.newMessagesFirst&&a-(r-s)>=-10&&(o=!0),o&&t.scroll(e?void 0:0)}else t.scroll(e?void 0:0)}scroll(e,t){void 0===e&&(e=300);const a=this,r=a.pageContentEl.scrollTop;let s;if(void 0!==t)s=t;else if(s=a.params.newMessagesFirst?0:a.pageContentEl.scrollHeight-a.pageContentEl.offsetHeight,s===r)return a;return a.$pageContentEl.scrollTop(s,e),a}init(){const e=this;e.messages&&0!==e.messages.length||(e.messages=e.getMessagesData()),e.params.messages&&e.params.messages.length&&e.renderMessages(),e.params.autoLayout&&e.layout(),e.params.scrollMessages&&e.scroll(0)}destroy(){const e=this;e.emit("local::beforeDestroy messagesBeforeDestroy",e),e.$el.trigger("messages:beforedestroy"),e.$el[0]&&(e.$el[0].f7Messages=null,delete e.$el[0].f7Messages),Ie(e)}};var gs={name:"messages",static:{Messages:fs},create(){this.messages=nt({defaultSelector:".messages",constructor:fs,app:this,domProp:"f7Messages",addMethods:"renderMessages layout scroll clear removeMessage removeMessages addMessage addMessages".split(" ")})},on:{tabBeforeRemove(e){const t=this;A(e).find(".messages-init").each((e=>{t.messages.destroy(e)}))},tabMounted(e){const t=this;A(e).find(".messages-init").each((e=>{t.messages.create({el:e})}))},pageBeforeRemove(e){const t=this;e.$el.find(".messages-init").each((e=>{t.messages.destroy(e)}))},pageInit(e){const t=this;e.$el.find(".messages-init").each((e=>{t.messages.create({el:e})}))}},vnode:{"messages-init":{insert(e){const t=e.elm;this.messages.create({el:t})},destroy(e){const t=e.elm;this.messages.destroy(t)}}}};let vs=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r={top:!1,topOffset:0,bottomOffset:0,attachments:[],renderAttachments:void 0,renderAttachment:void 0,maxHeight:null,resizePage:!0};a.useModulesParams(r),a.params=Fe(r,t);const s=A(a.params.el);if(0===s.length)return a;if(s[0].f7Messagebar)return s[0].f7Messagebar;s[0].f7Messagebar=a;const o=s.parents(".page").eq(0),n=o.find(".page-content").eq(0),i=s.find(".messagebar-area");let l;l=a.params.textareaEl?A(a.params.textareaEl):s.find("textarea");const c=s.find(".messagebar-attachments"),p=s.find(".messagebar-sheet");function d(){a.params.resizePage&&a.resizePage()}function u(e){e.preventDefault()}function h(e){const t=A(this).index();A(e.target).closest(".messagebar-attachment-delete").length?(A(this).trigger("messagebar:attachmentdelete",t),a.emit("local::attachmentDelete messagebarAttachmentDelete",a,this,t)):(A(this).trigger("messagebar:attachmentclick",t),a.emit("local::attachmentClick messagebarAttachmentClick",a,this,t))}function m(){a.checkEmptyState(),a.$el.trigger("messagebar:change"),a.emit("local::change messagebarChange",a)}function f(){a.sheetHide(),a.$el.addClass("messagebar-focused"),a.$el.trigger("messagebar:focus"),a.emit("local::focus messagebarFocus",a)}function g(){a.$el.removeClass("messagebar-focused"),a.$el.trigger("messagebar:blur"),a.emit("local::blur messagebarBlur",a)}return a.params.top&&s.addClass("messagebar-top"),Fe(a,{$el:s,el:s[0],$areaEl:i,areaEl:i[0],$textareaEl:l,textareaEl:l[0],$attachmentsEl:c,attachmentsEl:c[0],attachmentsVisible:c.hasClass("messagebar-attachments-visible"),$sheetEl:p,sheetEl:p[0],sheetVisible:p.hasClass("messagebar-sheet-visible"),$pageEl:o,pageEl:o[0],$pageContentEl:n,pageContentEl:n,top:s.hasClass("messagebar-top")||a.params.top,attachments:[]}),a.attachEvents=function(){s.on("textarea:resize",d),s.on("submit",u),s.on("click",".messagebar-attachment",h),l.on("change input",m),l.on("focus",f),l.on("blur",g),e.on("resize",d)},a.detachEvents=function(){s.off("textarea:resize",d),s.off("submit",u),s.off("click",".messagebar-attachment",h),l.off("change input",m),l.off("focus",f),l.off("blur",g),e.off("resize",d)},a.useModules(),a.init(),a}focus(){return this.$textareaEl.focus(),this}blur(){return this.$textareaEl.blur(),this}clear(){return this.$textareaEl.val("").trigger("change"),this}getValue(){return this.$textareaEl.val().trim()}setValue(e){return this.$textareaEl.val(e).trigger("change"),this}setPlaceholder(e){return this.$textareaEl.attr("placeholder",e),this}resizePage(){const e=this,{params:t,$el:a,top:r,$pageEl:s,$pageContentEl:o,$areaEl:n,$textareaEl:i,$sheetEl:l,$attachmentsEl:c}=e,p=a[0].offsetHeight;let d=t.maxHeight;if(r);else{const r=parseInt(o.css("padding-bottom"),10),u=p+t.bottomOffset;if(u!==r&&o.length){const t=parseInt(o.css("padding-top"),10),r=o[0].scrollHeight,p=o[0].offsetHeight,h=o[0].scrollTop===r-p;d||(d=s[0].offsetHeight-t-l.outerHeight()-c.outerHeight()-parseInt(n.css("margin-top"),10)-parseInt(n.css("margin-bottom"),10)),i.css("max-height",`${d}px`),o.css("padding-bottom",`${u}px`),h&&o.scrollTop(o[0].scrollHeight-p),a.trigger("messagebar:resizepage"),e.emit("local::resizePage messagebarResizePage",e)}}}checkEmptyState(){const{$el:e,$textareaEl:t}=this,a=t.val().trim();a&&a.length?e.addClass("messagebar-with-value"):e.removeClass("messagebar-with-value")}attachmentsCreate(e){void 0===e&&(e="");const t=this,a=A(`<div class="messagebar-attachments">${e}</div>`);return a.insertBefore(t.$textareaEl),Fe(t,{$attachmentsEl:a,attachmentsEl:a[0]}),t}attachmentsShow(e){void 0===e&&(e="");const t=this;return t.$attachmentsEl=t.$el.find(".messagebar-attachments"),0===t.$attachmentsEl.length&&t.attachmentsCreate(e),t.$el.addClass("messagebar-attachments-visible"),t.attachmentsVisible=!0,t.params.resizePage&&t.resizePage(),t}attachmentsHide(){const e=this;return e.$el.removeClass("messagebar-attachments-visible"),e.attachmentsVisible=!1,e.params.resizePage&&e.resizePage(),e}attachmentsToggle(){const e=this;return e.attachmentsVisible?e.attachmentsHide():e.attachmentsShow(),e}renderAttachment(e){const t=this;return t.params.renderAttachment?t.params.renderAttachment.call(t,e):`\n      <div class="messagebar-attachment">\n        <img src="${e}">\n        <span class="messagebar-attachment-delete"></span>\n      </div>\n    `}renderAttachments(){const e=this;let t;t=e.params.renderAttachments?e.params.renderAttachments.call(e,e.attachments):`${e.attachments.map((t=>e.renderAttachment(t))).join("")}`,0===e.$attachmentsEl.length?e.attachmentsCreate(t):e.$attachmentsEl.html(t)}sheetCreate(e){void 0===e&&(e="");const t=this,a=A(`<div class="messagebar-sheet">${e}</div>`);return t.$el.append(a),Fe(t,{$sheetEl:a,sheetEl:a[0]}),t}sheetShow(e){void 0===e&&(e="");const t=this;return t.$sheetEl=t.$el.find(".messagebar-sheet"),0===t.$sheetEl.length&&t.sheetCreate(e),t.$el.addClass("messagebar-sheet-visible"),t.sheetVisible=!0,t.params.resizePage&&t.resizePage(),t}sheetHide(){const e=this;return e.$el.removeClass("messagebar-sheet-visible"),e.sheetVisible=!1,e.params.resizePage&&e.resizePage(),e}sheetToggle(){const e=this;return e.sheetVisible?e.sheetHide():e.sheetShow(),e}init(){const e=this;return e.attachEvents(),e.checkEmptyState(),e}destroy(){const e=this;e.emit("local::beforeDestroy messagebarBeforeDestroy",e),e.$el.trigger("messagebar:beforedestroy"),e.detachEvents(),e.$el[0]&&(e.$el[0].f7Messagebar=null,delete e.$el[0].f7Messagebar),Ie(e)}};var bs={name:"messagebar",static:{Messagebar:vs},create(){this.messagebar=nt({defaultSelector:".messagebar",constructor:vs,app:this,domProp:"f7Messagebar",addMethods:"clear getValue setValue setPlaceholder resizePage focus blur attachmentsCreate attachmentsShow attachmentsHide attachmentsToggle renderAttachments sheetCreate sheetShow sheetHide sheetToggle".split(" ")})},on:{tabBeforeRemove(e){const t=this;A(e).find(".messagebar-init").each((e=>{t.messagebar.destroy(e)}))},tabMounted(e){const t=this;A(e).find(".messagebar-init").each((e=>{t.messagebar.create(Fe({el:e},A(e).dataset()))}))},pageBeforeRemove(e){const t=this;e.$el.find(".messagebar-init").each((e=>{t.messagebar.destroy(e)}))},pageInit(e){const t=this;e.$el.find(".messagebar-init").each((e=>{t.messagebar.create(Fe({el:e},A(e).dataset()))}))}},vnode:{"messagebar-init":{insert(e){const t=e.elm;this.messagebar.create(Fe({el:t},A(t).dataset()))},destroy(e){const t=e.elm;this.messagebar.destroy(t)}}}};function ws(e){return null!==e&&"object"==typeof e&&"constructor"in e&&e.constructor===Object}function ys(e,t){void 0===e&&(e={}),void 0===t&&(t={}),Object.keys(t).forEach((a=>{void 0===e[a]?e[a]=t[a]:ws(t[a])&&ws(e[a])&&Object.keys(t[a]).length>0&&ys(e[a],t[a])}))}const Cs={body:{},addEventListener(){},removeEventListener(){},activeElement:{blur(){},nodeName:""},querySelector:()=>null,querySelectorAll:()=>[],getElementById:()=>null,createEvent:()=>({initEvent(){}}),createElement:()=>({children:[],childNodes:[],style:{},setAttribute(){},getElementsByTagName:()=>[]}),createElementNS:()=>({}),importNode:()=>null,location:{hash:"",host:"",hostname:"",href:"",origin:"",pathname:"",protocol:"",search:""}};function Es(){const e="undefined"!=typeof document?document:{};return ys(e,Cs),e}const ks={document:Cs,navigator:{userAgent:""},location:{hash:"",host:"",hostname:"",href:"",origin:"",pathname:"",protocol:"",search:""},history:{replaceState(){},pushState(){},go(){},back(){}},CustomEvent:function(){return this},addEventListener(){},removeEventListener(){},getComputedStyle:()=>({getPropertyValue:()=>""}),Image(){},Date(){},screen:{},setTimeout(){},clearTimeout(){},matchMedia:()=>({}),requestAnimationFrame:e=>"undefined"==typeof setTimeout?(e(),null):setTimeout(e,0),cancelAnimationFrame(e){"undefined"!=typeof setTimeout&&clearTimeout(e)}};function $s(){const e="undefined"!=typeof window?window:{};return ys(e,ks),e}function xs(e,t){return void 0===t&&(t=0),setTimeout(e,t)}function Ts(){return Date.now()}function Ss(e,t){void 0===t&&(t="x");const a=$s();let r,s,o;const n=function(e){const t=$s();let a;return t.getComputedStyle&&(a=t.getComputedStyle(e,null)),!a&&e.currentStyle&&(a=e.currentStyle),a||(a=e.style),a}(e);return a.WebKitCSSMatrix?(s=n.transform||n.webkitTransform,s.split(",").length>6&&(s=s.split(", ").map((e=>e.replace(",","."))).join(", ")),o=new a.WebKitCSSMatrix("none"===s?"":s)):(o=n.MozTransform||n.OTransform||n.MsTransform||n.msTransform||n.transform||n.getPropertyValue("transform").replace("translate(","matrix(1, 0, 0, 1,"),r=o.toString().split(",")),"x"===t&&(s=a.WebKitCSSMatrix?o.m41:16===r.length?parseFloat(r[12]):parseFloat(r[4])),"y"===t&&(s=a.WebKitCSSMatrix?o.m42:16===r.length?parseFloat(r[13]):parseFloat(r[5])),s||0}function Ps(e){return"object"==typeof e&&null!==e&&e.constructor&&"Object"===Object.prototype.toString.call(e).slice(8,-1)}function Ms(){const e=Object(arguments.length<=0?void 0:arguments[0]),t=["__proto__","constructor","prototype"];for(let r=1;r<arguments.length;r+=1){const s=r<0||arguments.length<=r?void 0:arguments[r];if(null!=s&&(a=s,!("undefined"!=typeof window&&void 0!==window.HTMLElement?a instanceof HTMLElement:a&&(1===a.nodeType||11===a.nodeType)))){const a=Object.keys(Object(s)).filter((e=>t.indexOf(e)<0));for(let t=0,r=a.length;t<r;t+=1){const r=a[t],o=Object.getOwnPropertyDescriptor(s,r);void 0!==o&&o.enumerable&&(Ps(e[r])&&Ps(s[r])?s[r].__swiper__?e[r]=s[r]:Ms(e[r],s[r]):!Ps(e[r])&&Ps(s[r])?(e[r]={},s[r].__swiper__?e[r]=s[r]:Ms(e[r],s[r])):e[r]=s[r])}}}var a;return e}function Os(e,t,a){e.style.setProperty(t,a)}function Is(e){let{swiper:t,targetPosition:a,side:r}=e;const s=$s(),o=-t.translate;let n,i=null;const l=t.params.speed;t.wrapperEl.style.scrollSnapType="none",s.cancelAnimationFrame(t.cssModeFrameID);const c=a>o?"next":"prev",p=(e,t)=>"next"===c&&e>=t||"prev"===c&&e<=t,d=()=>{n=(new Date).getTime(),null===i&&(i=n);const e=Math.max(Math.min((n-i)/l,1),0),c=.5-Math.cos(e*Math.PI)/2;let u=o+c*(a-o);if(p(u,a)&&(u=a),t.wrapperEl.scrollTo({[r]:u}),p(u,a))return t.wrapperEl.style.overflow="hidden",t.wrapperEl.style.scrollSnapType="",setTimeout((()=>{t.wrapperEl.style.overflow="",t.wrapperEl.scrollTo({[r]:u})})),void s.cancelAnimationFrame(t.cssModeFrameID);t.cssModeFrameID=s.requestAnimationFrame(d)};d()}function Bs(e){return e.querySelector(".swiper-slide-transform")||e.shadowRoot&&e.shadowRoot.querySelector(".swiper-slide-transform")||e}function Ls(e,t){return void 0===t&&(t=""),[...e.children].filter((e=>e.matches(t)))}function Ds(e,t){void 0===t&&(t=[]);const a=document.createElement(e);return a.classList.add(...Array.isArray(t)?t:[t]),a}function As(e){const t=$s(),a=Es(),r=e.getBoundingClientRect(),s=a.body,o=e.clientTop||s.clientTop||0,n=e.clientLeft||s.clientLeft||0,i=e===t?t.scrollY:e.scrollTop,l=e===t?t.scrollX:e.scrollLeft;return{top:r.top+i-o,left:r.left+l-n}}function Rs(e,t){return $s().getComputedStyle(e,null).getPropertyValue(t)}function Hs(e){let t,a=e;if(a){for(t=0;null!==(a=a.previousSibling);)1===a.nodeType&&(t+=1);return t}}function zs(e,t){const a=[];let r=e.parentElement;for(;r;)t?r.matches(t)&&a.push(r):a.push(r),r=r.parentElement;return a}function Ns(e,t){t&&e.addEventListener("transitionend",(function a(r){r.target===e&&(t.call(e,r),e.removeEventListener("transitionend",a))}))}function Vs(e,t,a){const r=$s();return a?e["width"===t?"offsetWidth":"offsetHeight"]+parseFloat(r.getComputedStyle(e,null).getPropertyValue("width"===t?"margin-right":"margin-top"))+parseFloat(r.getComputedStyle(e,null).getPropertyValue("width"===t?"margin-left":"margin-bottom")):e.offsetWidth}let Fs,_s,qs;function js(){return Fs||(Fs=function(){const e=$s(),t=Es();return{smoothScroll:t.documentElement&&t.documentElement.style&&"scrollBehavior"in t.documentElement.style,touch:!!("ontouchstart"in e||e.DocumentTouch&&t instanceof e.DocumentTouch)}}()),Fs}function Ys(e){return void 0===e&&(e={}),_s||(_s=function(e){let{userAgent:t}=void 0===e?{}:e;const a=js(),r=$s(),s=r.navigator.platform,o=t||r.navigator.userAgent,n={ios:!1,android:!1},i=r.screen.width,l=r.screen.height,c=o.match(/(Android);?[\s\/]+([\d.]+)?/);let p=o.match(/(iPad).*OS\s([\d_]+)/);const d=o.match(/(iPod)(.*OS\s([\d_]+))?/),u=!p&&o.match(/(iPhone\sOS|iOS)\s([\d_]+)/),h="Win32"===s;let m="MacIntel"===s;return!p&&m&&a.touch&&["1024x1366","1366x1024","834x1194","1194x834","834x1112","1112x834","768x1024","1024x768","820x1180","1180x820","810x1080","1080x810"].indexOf(`${i}x${l}`)>=0&&(p=o.match(/(Version)\/([\d.]+)/),p||(p=[0,1,"13_0_0"]),m=!1),c&&!h&&(n.os="android",n.android=!0),(p||u||d)&&(n.os="ios",n.ios=!0),n}(e)),_s}function Ws(){return qs||(qs=function(){const e=$s();let t=!1;function a(){const t=e.navigator.userAgent.toLowerCase();return t.indexOf("safari")>=0&&t.indexOf("chrome")<0&&t.indexOf("android")<0}if(a()){const a=String(e.navigator.userAgent);if(a.includes("Version/")){const[e,r]=a.split("Version/")[1].split(" ")[0].split(".").map((e=>Number(e)));t=e<16||16===e&&r<2}}return{isSafari:t||a(),needPerspectiveFix:t,isWebView:/(iPhone|iPod|iPad).*AppleWebKit(?!.*Safari)/i.test(e.navigator.userAgent)}}()),qs}var Xs={on(e,t,a){const r=this;if(!r.eventsListeners||r.destroyed)return r;if("function"!=typeof t)return r;const s=a?"unshift":"push";return e.split(" ").forEach((e=>{r.eventsListeners[e]||(r.eventsListeners[e]=[]),r.eventsListeners[e][s](t)})),r},once(e,t,a){const r=this;if(!r.eventsListeners||r.destroyed)return r;if("function"!=typeof t)return r;function s(){r.off(e,s),s.__emitterProxy&&delete s.__emitterProxy;for(var a=arguments.length,o=new Array(a),n=0;n<a;n++)o[n]=arguments[n];t.apply(r,o)}return s.__emitterProxy=t,r.on(e,s,a)},onAny(e,t){const a=this;if(!a.eventsListeners||a.destroyed)return a;if("function"!=typeof e)return a;const r=t?"unshift":"push";return a.eventsAnyListeners.indexOf(e)<0&&a.eventsAnyListeners[r](e),a},offAny(e){const t=this;if(!t.eventsListeners||t.destroyed)return t;if(!t.eventsAnyListeners)return t;const a=t.eventsAnyListeners.indexOf(e);return a>=0&&t.eventsAnyListeners.splice(a,1),t},off(e,t){const a=this;return!a.eventsListeners||a.destroyed?a:a.eventsListeners?(e.split(" ").forEach((e=>{void 0===t?a.eventsListeners[e]=[]:a.eventsListeners[e]&&a.eventsListeners[e].forEach(((r,s)=>{(r===t||r.__emitterProxy&&r.__emitterProxy===t)&&a.eventsListeners[e].splice(s,1)}))})),a):a},emit(){const e=this;if(!e.eventsListeners||e.destroyed)return e;if(!e.eventsListeners)return e;let t,a,r;for(var s=arguments.length,o=new Array(s),n=0;n<s;n++)o[n]=arguments[n];"string"==typeof o[0]||Array.isArray(o[0])?(t=o[0],a=o.slice(1,o.length),r=e):(t=o[0].events,a=o[0].data,r=o[0].context||e),a.unshift(r);return(Array.isArray(t)?t:t.split(" ")).forEach((t=>{e.eventsAnyListeners&&e.eventsAnyListeners.length&&e.eventsAnyListeners.forEach((e=>{e.apply(r,[t,...a])})),e.eventsListeners&&e.eventsListeners[t]&&e.eventsListeners[t].forEach((e=>{e.apply(r,a)}))})),e}};const Us=(e,t)=>{if(!e||e.destroyed||!e.params)return;const a=t.closest(e.isElement?"swiper-slide":`.${e.params.slideClass}`);if(a){let t=a.querySelector(`.${e.params.lazyPreloaderClass}`);!t&&e.isElement&&(t=a.shadowRoot.querySelector(`.${e.params.lazyPreloaderClass}`)),t&&t.remove()}},Gs=(e,t)=>{if(!e.slides[t])return;const a=e.slides[t].querySelector('[loading="lazy"]');a&&a.removeAttribute("loading")},Ks=e=>{if(!e||e.destroyed||!e.params)return;let t=e.params.lazyPreloadPrevNext;const a=e.slides.length;if(!a||!t||t<0)return;t=Math.min(t,a);const r="auto"===e.params.slidesPerView?e.slidesPerViewDynamic():Math.ceil(e.params.slidesPerView),s=e.activeIndex;if(e.params.grid&&e.params.grid.rows>1){const a=s,o=[a-t];return o.push(...Array.from({length:t}).map(((e,t)=>a+r+t))),void e.slides.forEach(((t,a)=>{o.includes(t.column)&&Gs(e,a)}))}const o=s+r-1;if(e.params.rewind||e.params.loop)for(let r=s-t;r<=o+t;r+=1){const t=(r%a+a)%a;(t<s||t>o)&&Gs(e,t)}else for(let r=Math.max(s-t,0);r<=Math.min(o+t,a-1);r+=1)r!==s&&(r>o||r<s)&&Gs(e,r)};var Qs={updateSize:function(){const e=this;let t,a;const r=e.el;t=void 0!==e.params.width&&null!==e.params.width?e.params.width:r.clientWidth,a=void 0!==e.params.height&&null!==e.params.height?e.params.height:r.clientHeight,0===t&&e.isHorizontal()||0===a&&e.isVertical()||(t=t-parseInt(Rs(r,"padding-left")||0,10)-parseInt(Rs(r,"padding-right")||0,10),a=a-parseInt(Rs(r,"padding-top")||0,10)-parseInt(Rs(r,"padding-bottom")||0,10),Number.isNaN(t)&&(t=0),Number.isNaN(a)&&(a=0),Object.assign(e,{width:t,height:a,size:e.isHorizontal()?t:a}))},updateSlides:function(){const e=this;function t(t){return e.isHorizontal()?t:{width:"height","margin-top":"margin-left","margin-bottom ":"margin-right","margin-left":"margin-top","margin-right":"margin-bottom","padding-left":"padding-top","padding-right":"padding-bottom",marginRight:"marginBottom"}[t]}function a(e,a){return parseFloat(e.getPropertyValue(t(a))||0)}const r=e.params,{wrapperEl:s,slidesEl:o,size:n,rtlTranslate:i,wrongRTL:l}=e,c=e.virtual&&r.virtual.enabled,p=c?e.virtual.slides.length:e.slides.length,d=Ls(o,`.${e.params.slideClass}, swiper-slide`),u=c?e.virtual.slides.length:d.length;let h=[];const m=[],f=[];let g=r.slidesOffsetBefore;"function"==typeof g&&(g=r.slidesOffsetBefore.call(e));let v=r.slidesOffsetAfter;"function"==typeof v&&(v=r.slidesOffsetAfter.call(e));const b=e.snapGrid.length,w=e.slidesGrid.length;let y=r.spaceBetween,C=-g,E=0,k=0;if(void 0===n)return;"string"==typeof y&&y.indexOf("%")>=0?y=parseFloat(y.replace("%",""))/100*n:"string"==typeof y&&(y=parseFloat(y)),e.virtualSize=-y,d.forEach((e=>{i?e.style.marginLeft="":e.style.marginRight="",e.style.marginBottom="",e.style.marginTop=""})),r.centeredSlides&&r.cssMode&&(Os(s,"--swiper-centered-offset-before",""),Os(s,"--swiper-centered-offset-after",""));const $=r.grid&&r.grid.rows>1&&e.grid;let x;$&&e.grid.initSlides(u);const T="auto"===r.slidesPerView&&r.breakpoints&&Object.keys(r.breakpoints).filter((e=>void 0!==r.breakpoints[e].slidesPerView)).length>0;for(let s=0;s<u;s+=1){let o;if(x=0,d[s]&&(o=d[s]),$&&e.grid.updateSlide(s,o,u,t),!d[s]||"none"!==Rs(o,"display")){if("auto"===r.slidesPerView){T&&(d[s].style[t("width")]="");const n=getComputedStyle(o),i=o.style.transform,l=o.style.webkitTransform;if(i&&(o.style.transform="none"),l&&(o.style.webkitTransform="none"),r.roundLengths)x=e.isHorizontal()?Vs(o,"width",!0):Vs(o,"height",!0);else{const e=a(n,"width"),t=a(n,"padding-left"),r=a(n,"padding-right"),s=a(n,"margin-left"),i=a(n,"margin-right"),l=n.getPropertyValue("box-sizing");if(l&&"border-box"===l)x=e+s+i;else{const{clientWidth:a,offsetWidth:n}=o;x=e+t+r+s+i+(n-a)}}i&&(o.style.transform=i),l&&(o.style.webkitTransform=l),r.roundLengths&&(x=Math.floor(x))}else x=(n-(r.slidesPerView-1)*y)/r.slidesPerView,r.roundLengths&&(x=Math.floor(x)),d[s]&&(d[s].style[t("width")]=`${x}px`);d[s]&&(d[s].swiperSlideSize=x),f.push(x),r.centeredSlides?(C=C+x/2+E/2+y,0===E&&0!==s&&(C=C-n/2-y),0===s&&(C=C-n/2-y),Math.abs(C)<.001&&(C=0),r.roundLengths&&(C=Math.floor(C)),k%r.slidesPerGroup==0&&h.push(C),m.push(C)):(r.roundLengths&&(C=Math.floor(C)),(k-Math.min(e.params.slidesPerGroupSkip,k))%e.params.slidesPerGroup==0&&h.push(C),m.push(C),C=C+x+y),e.virtualSize+=x+y,E=x,k+=1}}if(e.virtualSize=Math.max(e.virtualSize,n)+v,i&&l&&("slide"===r.effect||"coverflow"===r.effect)&&(s.style.width=`${e.virtualSize+y}px`),r.setWrapperSize&&(s.style[t("width")]=`${e.virtualSize+y}px`),$&&e.grid.updateWrapperSize(x,h,t),!r.centeredSlides){const t=[];for(let a=0;a<h.length;a+=1){let s=h[a];r.roundLengths&&(s=Math.floor(s)),h[a]<=e.virtualSize-n&&t.push(s)}h=t,Math.floor(e.virtualSize-n)-Math.floor(h[h.length-1])>1&&h.push(e.virtualSize-n)}if(c&&r.loop){const t=f[0]+y;if(r.slidesPerGroup>1){const a=Math.ceil((e.virtual.slidesBefore+e.virtual.slidesAfter)/r.slidesPerGroup),s=t*r.slidesPerGroup;for(let e=0;e<a;e+=1)h.push(h[h.length-1]+s)}for(let a=0;a<e.virtual.slidesBefore+e.virtual.slidesAfter;a+=1)1===r.slidesPerGroup&&h.push(h[h.length-1]+t),m.push(m[m.length-1]+t),e.virtualSize+=t}if(0===h.length&&(h=[0]),0!==y){const a=e.isHorizontal()&&i?"marginLeft":t("marginRight");d.filter(((e,t)=>!(r.cssMode&&!r.loop)||t!==d.length-1)).forEach((e=>{e.style[a]=`${y}px`}))}if(r.centeredSlides&&r.centeredSlidesBounds){let e=0;f.forEach((t=>{e+=t+(y||0)})),e-=y;const t=e-n;h=h.map((e=>e<=0?-g:e>t?t+v:e))}if(r.centerInsufficientSlides){let e=0;if(f.forEach((t=>{e+=t+(y||0)})),e-=y,e<n){const t=(n-e)/2;h.forEach(((e,a)=>{h[a]=e-t})),m.forEach(((e,a)=>{m[a]=e+t}))}}if(Object.assign(e,{slides:d,snapGrid:h,slidesGrid:m,slidesSizesGrid:f}),r.centeredSlides&&r.cssMode&&!r.centeredSlidesBounds){Os(s,"--swiper-centered-offset-before",-h[0]+"px"),Os(s,"--swiper-centered-offset-after",e.size/2-f[f.length-1]/2+"px");const t=-e.snapGrid[0],a=-e.slidesGrid[0];e.snapGrid=e.snapGrid.map((e=>e+t)),e.slidesGrid=e.slidesGrid.map((e=>e+a))}if(u!==p&&e.emit("slidesLengthChange"),h.length!==b&&(e.params.watchOverflow&&e.checkOverflow(),e.emit("snapGridLengthChange")),m.length!==w&&e.emit("slidesGridLengthChange"),r.watchSlidesProgress&&e.updateSlidesOffset(),!(c||r.cssMode||"slide"!==r.effect&&"fade"!==r.effect)){const t=`${r.containerModifierClass}backface-hidden`,a=e.el.classList.contains(t);u<=r.maxBackfaceHiddenSlides?a||e.el.classList.add(t):a&&e.el.classList.remove(t)}},updateAutoHeight:function(e){const t=this,a=[],r=t.virtual&&t.params.virtual.enabled;let s,o=0;"number"==typeof e?t.setTransition(e):!0===e&&t.setTransition(t.params.speed);const n=e=>r?t.slides[t.getSlideIndexByData(e)]:t.slides[e];if("auto"!==t.params.slidesPerView&&t.params.slidesPerView>1)if(t.params.centeredSlides)(t.visibleSlides||[]).forEach((e=>{a.push(e)}));else for(s=0;s<Math.ceil(t.params.slidesPerView);s+=1){const e=t.activeIndex+s;if(e>t.slides.length&&!r)break;a.push(n(e))}else a.push(n(t.activeIndex));for(s=0;s<a.length;s+=1)if(void 0!==a[s]){const e=a[s].offsetHeight;o=e>o?e:o}(o||0===o)&&(t.wrapperEl.style.height=`${o}px`)},updateSlidesOffset:function(){const e=this,t=e.slides,a=e.isElement?e.isHorizontal()?e.wrapperEl.offsetLeft:e.wrapperEl.offsetTop:0;for(let r=0;r<t.length;r+=1)t[r].swiperSlideOffset=(e.isHorizontal()?t[r].offsetLeft:t[r].offsetTop)-a-e.cssOverflowAdjustment()},updateSlidesProgress:function(e){void 0===e&&(e=this&&this.translate||0);const t=this,a=t.params,{slides:r,rtlTranslate:s,snapGrid:o}=t;if(0===r.length)return;void 0===r[0].swiperSlideOffset&&t.updateSlidesOffset();let n=-e;s&&(n=e),r.forEach((e=>{e.classList.remove(a.slideVisibleClass)})),t.visibleSlidesIndexes=[],t.visibleSlides=[];let i=a.spaceBetween;"string"==typeof i&&i.indexOf("%")>=0?i=parseFloat(i.replace("%",""))/100*t.size:"string"==typeof i&&(i=parseFloat(i));for(let e=0;e<r.length;e+=1){const l=r[e];let c=l.swiperSlideOffset;a.cssMode&&a.centeredSlides&&(c-=r[0].swiperSlideOffset);const p=(n+(a.centeredSlides?t.minTranslate():0)-c)/(l.swiperSlideSize+i),d=(n-o[0]+(a.centeredSlides?t.minTranslate():0)-c)/(l.swiperSlideSize+i),u=-(n-c),h=u+t.slidesSizesGrid[e];(u>=0&&u<t.size-1||h>1&&h<=t.size||u<=0&&h>=t.size)&&(t.visibleSlides.push(l),t.visibleSlidesIndexes.push(e),r[e].classList.add(a.slideVisibleClass)),l.progress=s?-p:p,l.originalProgress=s?-d:d}},updateProgress:function(e){const t=this;if(void 0===e){const a=t.rtlTranslate?-1:1;e=t&&t.translate&&t.translate*a||0}const a=t.params,r=t.maxTranslate()-t.minTranslate();let{progress:s,isBeginning:o,isEnd:n,progressLoop:i}=t;const l=o,c=n;if(0===r)s=0,o=!0,n=!0;else{s=(e-t.minTranslate())/r;const a=Math.abs(e-t.minTranslate())<1,i=Math.abs(e-t.maxTranslate())<1;o=a||s<=0,n=i||s>=1,a&&(s=0),i&&(s=1)}if(a.loop){const a=t.getSlideIndexByData(0),r=t.getSlideIndexByData(t.slides.length-1),s=t.slidesGrid[a],o=t.slidesGrid[r],n=t.slidesGrid[t.slidesGrid.length-1],l=Math.abs(e);i=l>=s?(l-s)/n:(l+n-o)/n,i>1&&(i-=1)}Object.assign(t,{progress:s,progressLoop:i,isBeginning:o,isEnd:n}),(a.watchSlidesProgress||a.centeredSlides&&a.autoHeight)&&t.updateSlidesProgress(e),o&&!l&&t.emit("reachBeginning toEdge"),n&&!c&&t.emit("reachEnd toEdge"),(l&&!o||c&&!n)&&t.emit("fromEdge"),t.emit("progress",s)},updateSlidesClasses:function(){const e=this,{slides:t,params:a,slidesEl:r,activeIndex:s}=e,o=e.virtual&&a.virtual.enabled,n=e=>Ls(r,`.${a.slideClass}${e}, swiper-slide${e}`)[0];let i;if(t.forEach((e=>{e.classList.remove(a.slideActiveClass,a.slideNextClass,a.slidePrevClass)})),o)if(a.loop){let t=s-e.virtual.slidesBefore;t<0&&(t=e.virtual.slides.length+t),t>=e.virtual.slides.length&&(t-=e.virtual.slides.length),i=n(`[data-swiper-slide-index="${t}"]`)}else i=n(`[data-swiper-slide-index="${s}"]`);else i=t[s];if(i){i.classList.add(a.slideActiveClass);let e=function(e,t){const a=[];for(;e.nextElementSibling;){const r=e.nextElementSibling;t?r.matches(t)&&a.push(r):a.push(r),e=r}return a}(i,`.${a.slideClass}, swiper-slide`)[0];a.loop&&!e&&(e=t[0]),e&&e.classList.add(a.slideNextClass);let r=function(e,t){const a=[];for(;e.previousElementSibling;){const r=e.previousElementSibling;t?r.matches(t)&&a.push(r):a.push(r),e=r}return a}(i,`.${a.slideClass}, swiper-slide`)[0];a.loop&&0===!r&&(r=t[t.length-1]),r&&r.classList.add(a.slidePrevClass)}e.emitSlidesClasses()},updateActiveIndex:function(e){const t=this,a=t.rtlTranslate?t.translate:-t.translate,{snapGrid:r,params:s,activeIndex:o,realIndex:n,snapIndex:i}=t;let l,c=e;const p=e=>{let a=e-t.virtual.slidesBefore;return a<0&&(a=t.virtual.slides.length+a),a>=t.virtual.slides.length&&(a-=t.virtual.slides.length),a};if(void 0===c&&(c=function(e){const{slidesGrid:t,params:a}=e,r=e.rtlTranslate?e.translate:-e.translate;let s;for(let e=0;e<t.length;e+=1)void 0!==t[e+1]?r>=t[e]&&r<t[e+1]-(t[e+1]-t[e])/2?s=e:r>=t[e]&&r<t[e+1]&&(s=e+1):r>=t[e]&&(s=e);return a.normalizeSlideIndex&&(s<0||void 0===s)&&(s=0),s}(t)),r.indexOf(a)>=0)l=r.indexOf(a);else{const e=Math.min(s.slidesPerGroupSkip,c);l=e+Math.floor((c-e)/s.slidesPerGroup)}if(l>=r.length&&(l=r.length-1),c===o)return l!==i&&(t.snapIndex=l,t.emit("snapIndexChange")),void(t.params.loop&&t.virtual&&t.params.virtual.enabled&&(t.realIndex=p(c)));let d;d=t.virtual&&s.virtual.enabled&&s.loop?p(c):t.slides[c]?parseInt(t.slides[c].getAttribute("data-swiper-slide-index")||c,10):c,Object.assign(t,{previousSnapIndex:i,snapIndex:l,previousRealIndex:n,realIndex:d,previousIndex:o,activeIndex:c}),t.initialized&&Ks(t),t.emit("activeIndexChange"),t.emit("snapIndexChange"),n!==d&&t.emit("realIndexChange"),(t.initialized||t.params.runCallbacksOnInit)&&t.emit("slideChange")},updateClickedSlide:function(e){const t=this,a=t.params,r=e.closest(`.${a.slideClass}, swiper-slide`);let s,o=!1;if(r)for(let e=0;e<t.slides.length;e+=1)if(t.slides[e]===r){o=!0,s=e;break}if(!r||!o)return t.clickedSlide=void 0,void(t.clickedIndex=void 0);t.clickedSlide=r,t.virtual&&t.params.virtual.enabled?t.clickedIndex=parseInt(r.getAttribute("data-swiper-slide-index"),10):t.clickedIndex=s,a.slideToClickedSlide&&void 0!==t.clickedIndex&&t.clickedIndex!==t.activeIndex&&t.slideToClickedSlide()}};var Js={getTranslate:function(e){void 0===e&&(e=this.isHorizontal()?"x":"y");const{params:t,rtlTranslate:a,translate:r,wrapperEl:s}=this;if(t.virtualTranslate)return a?-r:r;if(t.cssMode)return r;let o=Ss(s,e);return o+=this.cssOverflowAdjustment(),a&&(o=-o),o||0},setTranslate:function(e,t){const a=this,{rtlTranslate:r,params:s,wrapperEl:o,progress:n}=a;let i,l=0,c=0;a.isHorizontal()?l=r?-e:e:c=e,s.roundLengths&&(l=Math.floor(l),c=Math.floor(c)),a.previousTranslate=a.translate,a.translate=a.isHorizontal()?l:c,s.cssMode?o[a.isHorizontal()?"scrollLeft":"scrollTop"]=a.isHorizontal()?-l:-c:s.virtualTranslate||(a.isHorizontal()?l-=a.cssOverflowAdjustment():c-=a.cssOverflowAdjustment(),o.style.transform=`translate3d(${l}px, ${c}px, 0px)`);const p=a.maxTranslate()-a.minTranslate();i=0===p?0:(e-a.minTranslate())/p,i!==n&&a.updateProgress(e),a.emit("setTranslate",a.translate,t)},minTranslate:function(){return-this.snapGrid[0]},maxTranslate:function(){return-this.snapGrid[this.snapGrid.length-1]},translateTo:function(e,t,a,r,s){void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0),void 0===r&&(r=!0);const o=this,{params:n,wrapperEl:i}=o;if(o.animating&&n.preventInteractionOnTransition)return!1;const l=o.minTranslate(),c=o.maxTranslate();let p;if(p=r&&e>l?l:r&&e<c?c:e,o.updateProgress(p),n.cssMode){const e=o.isHorizontal();if(0===t)i[e?"scrollLeft":"scrollTop"]=-p;else{if(!o.support.smoothScroll)return Is({swiper:o,targetPosition:-p,side:e?"left":"top"}),!0;i.scrollTo({[e?"left":"top"]:-p,behavior:"smooth"})}return!0}return 0===t?(o.setTransition(0),o.setTranslate(p),a&&(o.emit("beforeTransitionStart",t,s),o.emit("transitionEnd"))):(o.setTransition(t),o.setTranslate(p),a&&(o.emit("beforeTransitionStart",t,s),o.emit("transitionStart")),o.animating||(o.animating=!0,o.onTranslateToWrapperTransitionEnd||(o.onTranslateToWrapperTransitionEnd=function(e){o&&!o.destroyed&&e.target===this&&(o.wrapperEl.removeEventListener("transitionend",o.onTranslateToWrapperTransitionEnd),o.onTranslateToWrapperTransitionEnd=null,delete o.onTranslateToWrapperTransitionEnd,a&&o.emit("transitionEnd"))}),o.wrapperEl.addEventListener("transitionend",o.onTranslateToWrapperTransitionEnd))),!0}};function Zs(e){let{swiper:t,runCallbacks:a,direction:r,step:s}=e;const{activeIndex:o,previousIndex:n}=t;let i=r;if(i||(i=o>n?"next":o<n?"prev":"reset"),t.emit(`transition${s}`),a&&o!==n){if("reset"===i)return void t.emit(`slideResetTransition${s}`);t.emit(`slideChangeTransition${s}`),"next"===i?t.emit(`slideNextTransition${s}`):t.emit(`slidePrevTransition${s}`)}}var eo={slideTo:function(e,t,a,r,s){void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0),"string"==typeof e&&(e=parseInt(e,10));const o=this;let n=e;n<0&&(n=0);const{params:i,snapGrid:l,slidesGrid:c,previousIndex:p,activeIndex:d,rtlTranslate:u,wrapperEl:h,enabled:m}=o;if(o.animating&&i.preventInteractionOnTransition||!m&&!r&&!s)return!1;const f=Math.min(o.params.slidesPerGroupSkip,n);let g=f+Math.floor((n-f)/o.params.slidesPerGroup);g>=l.length&&(g=l.length-1);const v=-l[g];if(i.normalizeSlideIndex)for(let e=0;e<c.length;e+=1){const t=-Math.floor(100*v),a=Math.floor(100*c[e]),r=Math.floor(100*c[e+1]);void 0!==c[e+1]?t>=a&&t<r-(r-a)/2?n=e:t>=a&&t<r&&(n=e+1):t>=a&&(n=e)}if(o.initialized&&n!==d){if(!o.allowSlideNext&&(u?v>o.translate&&v>o.minTranslate():v<o.translate&&v<o.minTranslate()))return!1;if(!o.allowSlidePrev&&v>o.translate&&v>o.maxTranslate()&&(d||0)!==n)return!1}let b;if(n!==(p||0)&&a&&o.emit("beforeSlideChangeStart"),o.updateProgress(v),b=n>d?"next":n<d?"prev":"reset",u&&-v===o.translate||!u&&v===o.translate)return o.updateActiveIndex(n),i.autoHeight&&o.updateAutoHeight(),o.updateSlidesClasses(),"slide"!==i.effect&&o.setTranslate(v),"reset"!==b&&(o.transitionStart(a,b),o.transitionEnd(a,b)),!1;if(i.cssMode){const e=o.isHorizontal(),a=u?v:-v;if(0===t){const t=o.virtual&&o.params.virtual.enabled;t&&(o.wrapperEl.style.scrollSnapType="none",o._immediateVirtual=!0),t&&!o._cssModeVirtualInitialSet&&o.params.initialSlide>0?(o._cssModeVirtualInitialSet=!0,requestAnimationFrame((()=>{h[e?"scrollLeft":"scrollTop"]=a}))):h[e?"scrollLeft":"scrollTop"]=a,t&&requestAnimationFrame((()=>{o.wrapperEl.style.scrollSnapType="",o._immediateVirtual=!1}))}else{if(!o.support.smoothScroll)return Is({swiper:o,targetPosition:a,side:e?"left":"top"}),!0;h.scrollTo({[e?"left":"top"]:a,behavior:"smooth"})}return!0}return o.setTransition(t),o.setTranslate(v),o.updateActiveIndex(n),o.updateSlidesClasses(),o.emit("beforeTransitionStart",t,r),o.transitionStart(a,b),0===t?o.transitionEnd(a,b):o.animating||(o.animating=!0,o.onSlideToWrapperTransitionEnd||(o.onSlideToWrapperTransitionEnd=function(e){o&&!o.destroyed&&e.target===this&&(o.wrapperEl.removeEventListener("transitionend",o.onSlideToWrapperTransitionEnd),o.onSlideToWrapperTransitionEnd=null,delete o.onSlideToWrapperTransitionEnd,o.transitionEnd(a,b))}),o.wrapperEl.addEventListener("transitionend",o.onSlideToWrapperTransitionEnd)),!0},slideToLoop:function(e,t,a,r){if(void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0),"string"==typeof e){e=parseInt(e,10)}const s=this;let o=e;return s.params.loop&&(s.virtual&&s.params.virtual.enabled?o+=s.virtual.slidesBefore:o=s.getSlideIndexByData(o)),s.slideTo(o,t,a,r)},slideNext:function(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);const r=this,{enabled:s,params:o,animating:n}=r;if(!s)return r;let i=o.slidesPerGroup;"auto"===o.slidesPerView&&1===o.slidesPerGroup&&o.slidesPerGroupAuto&&(i=Math.max(r.slidesPerViewDynamic("current",!0),1));const l=r.activeIndex<o.slidesPerGroupSkip?1:i,c=r.virtual&&o.virtual.enabled;if(o.loop){if(n&&!c&&o.loopPreventsSliding)return!1;r.loopFix({direction:"next"}),r._clientLeft=r.wrapperEl.clientLeft}return o.rewind&&r.isEnd?r.slideTo(0,e,t,a):r.slideTo(r.activeIndex+l,e,t,a)},slidePrev:function(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);const r=this,{params:s,snapGrid:o,slidesGrid:n,rtlTranslate:i,enabled:l,animating:c}=r;if(!l)return r;const p=r.virtual&&s.virtual.enabled;if(s.loop){if(c&&!p&&s.loopPreventsSliding)return!1;r.loopFix({direction:"prev"}),r._clientLeft=r.wrapperEl.clientLeft}function d(e){return e<0?-Math.floor(Math.abs(e)):Math.floor(e)}const u=d(i?r.translate:-r.translate),h=o.map((e=>d(e)));let m=o[h.indexOf(u)-1];if(void 0===m&&s.cssMode){let e;o.forEach(((t,a)=>{u>=t&&(e=a)})),void 0!==e&&(m=o[e>0?e-1:e])}let f=0;if(void 0!==m&&(f=n.indexOf(m),f<0&&(f=r.activeIndex-1),"auto"===s.slidesPerView&&1===s.slidesPerGroup&&s.slidesPerGroupAuto&&(f=f-r.slidesPerViewDynamic("previous",!0)+1,f=Math.max(f,0))),s.rewind&&r.isBeginning){const s=r.params.virtual&&r.params.virtual.enabled&&r.virtual?r.virtual.slides.length-1:r.slides.length-1;return r.slideTo(s,e,t,a)}return r.slideTo(f,e,t,a)},slideReset:function(e,t,a){return void 0===e&&(e=this.params.speed),void 0===t&&(t=!0),this.slideTo(this.activeIndex,e,t,a)},slideToClosest:function(e,t,a,r){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0),void 0===r&&(r=.5);const s=this;let o=s.activeIndex;const n=Math.min(s.params.slidesPerGroupSkip,o),i=n+Math.floor((o-n)/s.params.slidesPerGroup),l=s.rtlTranslate?s.translate:-s.translate;if(l>=s.snapGrid[i]){const e=s.snapGrid[i];l-e>(s.snapGrid[i+1]-e)*r&&(o+=s.params.slidesPerGroup)}else{const e=s.snapGrid[i-1];l-e<=(s.snapGrid[i]-e)*r&&(o-=s.params.slidesPerGroup)}return o=Math.max(o,0),o=Math.min(o,s.slidesGrid.length-1),s.slideTo(o,e,t,a)},slideToClickedSlide:function(){const e=this,{params:t,slidesEl:a}=e,r="auto"===t.slidesPerView?e.slidesPerViewDynamic():t.slidesPerView;let s,o=e.clickedIndex;const n=e.isElement?"swiper-slide":`.${t.slideClass}`;if(t.loop){if(e.animating)return;s=parseInt(e.clickedSlide.getAttribute("data-swiper-slide-index"),10),t.centeredSlides?o<e.loopedSlides-r/2||o>e.slides.length-e.loopedSlides+r/2?(e.loopFix(),o=e.getSlideIndex(Ls(a,`${n}[data-swiper-slide-index="${s}"]`)[0]),xs((()=>{e.slideTo(o)}))):e.slideTo(o):o>e.slides.length-r?(e.loopFix(),o=e.getSlideIndex(Ls(a,`${n}[data-swiper-slide-index="${s}"]`)[0]),xs((()=>{e.slideTo(o)}))):e.slideTo(o)}else e.slideTo(o)}};var to={loopCreate:function(e){const t=this,{params:a,slidesEl:r}=t;if(!a.loop||t.virtual&&t.params.virtual.enabled)return;Ls(r,`.${a.slideClass}, swiper-slide`).forEach(((e,t)=>{e.setAttribute("data-swiper-slide-index",t)})),t.loopFix({slideRealIndex:e,direction:a.centeredSlides?void 0:"next"})},loopFix:function(e){let{slideRealIndex:t,slideTo:a=!0,direction:r,setTranslate:s,activeSlideIndex:o,byController:n,byMousewheel:i}=void 0===e?{}:e;const l=this;if(!l.params.loop)return;l.emit("beforeLoopFix");const{slides:c,allowSlidePrev:p,allowSlideNext:d,slidesEl:u,params:h}=l;if(l.allowSlidePrev=!0,l.allowSlideNext=!0,l.virtual&&h.virtual.enabled)return a&&(h.centeredSlides||0!==l.snapIndex?h.centeredSlides&&l.snapIndex<h.slidesPerView?l.slideTo(l.virtual.slides.length+l.snapIndex,0,!1,!0):l.snapIndex===l.snapGrid.length-1&&l.slideTo(l.virtual.slidesBefore,0,!1,!0):l.slideTo(l.virtual.slides.length,0,!1,!0)),l.allowSlidePrev=p,l.allowSlideNext=d,void l.emit("loopFix");const m="auto"===h.slidesPerView?l.slidesPerViewDynamic():Math.ceil(parseFloat(h.slidesPerView,10));let f=h.loopedSlides||m;f%h.slidesPerGroup!=0&&(f+=h.slidesPerGroup-f%h.slidesPerGroup),l.loopedSlides=f;const g=[],v=[];let b=l.activeIndex;void 0===o?o=l.getSlideIndex(l.slides.filter((e=>e.classList.contains(h.slideActiveClass)))[0]):b=o;const w="next"===r||!r,y="prev"===r||!r;let C=0,E=0;if(o<f){C=Math.max(f-o,h.slidesPerGroup);for(let e=0;e<f-o;e+=1){const t=e-Math.floor(e/c.length)*c.length;g.push(c.length-t-1)}}else if(o>l.slides.length-2*f){E=Math.max(o-(l.slides.length-2*f),h.slidesPerGroup);for(let e=0;e<E;e+=1){const t=e-Math.floor(e/c.length)*c.length;v.push(t)}}if(y&&g.forEach((e=>{l.slides[e].swiperLoopMoveDOM=!0,u.prepend(l.slides[e]),l.slides[e].swiperLoopMoveDOM=!1})),w&&v.forEach((e=>{l.slides[e].swiperLoopMoveDOM=!0,u.append(l.slides[e]),l.slides[e].swiperLoopMoveDOM=!1})),l.recalcSlides(),"auto"===h.slidesPerView&&l.updateSlides(),h.watchSlidesProgress&&l.updateSlidesOffset(),a)if(g.length>0&&y)if(void 0===t){const e=l.slidesGrid[b],t=l.slidesGrid[b+C]-e;i?l.setTranslate(l.translate-t):(l.slideTo(b+C,0,!1,!0),s&&(l.touches[l.isHorizontal()?"startX":"startY"]+=t,l.touchEventsData.currentTranslate=l.translate))}else s&&(l.slideToLoop(t,0,!1,!0),l.touchEventsData.currentTranslate=l.translate);else if(v.length>0&&w)if(void 0===t){const e=l.slidesGrid[b],t=l.slidesGrid[b-E]-e;i?l.setTranslate(l.translate-t):(l.slideTo(b-E,0,!1,!0),s&&(l.touches[l.isHorizontal()?"startX":"startY"]+=t,l.touchEventsData.currentTranslate=l.translate))}else l.slideToLoop(t,0,!1,!0);if(l.allowSlidePrev=p,l.allowSlideNext=d,l.controller&&l.controller.control&&!n){const e={slideRealIndex:t,direction:r,setTranslate:s,activeSlideIndex:o,byController:!0};Array.isArray(l.controller.control)?l.controller.control.forEach((t=>{!t.destroyed&&t.params.loop&&t.loopFix({...e,slideTo:t.params.slidesPerView===h.slidesPerView&&a})})):l.controller.control instanceof l.constructor&&l.controller.control.params.loop&&l.controller.control.loopFix({...e,slideTo:l.controller.control.params.slidesPerView===h.slidesPerView&&a})}l.emit("loopFix")},loopDestroy:function(){const e=this,{params:t,slidesEl:a}=e;if(!t.loop||e.virtual&&e.params.virtual.enabled)return;e.recalcSlides();const r=[];e.slides.forEach((e=>{const t=void 0===e.swiperSlideIndex?1*e.getAttribute("data-swiper-slide-index"):e.swiperSlideIndex;r[t]=e})),e.slides.forEach((e=>{e.removeAttribute("data-swiper-slide-index")})),r.forEach((e=>{a.append(e)})),e.recalcSlides(),e.slideTo(e.realIndex,0)}};function ao(e){const t=this,a=Es(),r=$s(),s=t.touchEventsData;s.evCache.push(e);const{params:o,touches:n,enabled:i}=t;if(!i)return;if(!o.simulateTouch&&"mouse"===e.pointerType)return;if(t.animating&&o.preventInteractionOnTransition)return;!t.animating&&o.cssMode&&o.loop&&t.loopFix();let l=e;l.originalEvent&&(l=l.originalEvent);let c=l.target;if("wrapper"===o.touchEventsTarget&&!t.wrapperEl.contains(c))return;if("which"in l&&3===l.which)return;if("button"in l&&l.button>0)return;if(s.isTouched&&s.isMoved)return;const p=!!o.noSwipingClass&&""!==o.noSwipingClass,d=e.composedPath?e.composedPath():e.path;p&&l.target&&l.target.shadowRoot&&d&&(c=d[0]);const u=o.noSwipingSelector?o.noSwipingSelector:`.${o.noSwipingClass}`,h=!(!l.target||!l.target.shadowRoot);if(o.noSwiping&&(h?function(e,t){return void 0===t&&(t=this),function t(a){if(!a||a===Es()||a===$s())return null;a.assignedSlot&&(a=a.assignedSlot);const r=a.closest(e);return r||a.getRootNode?r||t(a.getRootNode().host):null}(t)}(u,c):c.closest(u)))return void(t.allowClick=!0);if(o.swipeHandler&&!c.closest(o.swipeHandler))return;n.currentX=l.pageX,n.currentY=l.pageY;const m=n.currentX,f=n.currentY,g=o.edgeSwipeDetection||o.iOSEdgeSwipeDetection,v=o.edgeSwipeThreshold||o.iOSEdgeSwipeThreshold;if(g&&(m<=v||m>=r.innerWidth-v)){if("prevent"!==g)return;e.preventDefault()}Object.assign(s,{isTouched:!0,isMoved:!1,allowTouchCallbacks:!0,isScrolling:void 0,startMoving:void 0}),n.startX=m,n.startY=f,s.touchStartTime=Ts(),t.allowClick=!0,t.updateSize(),t.swipeDirection=void 0,o.threshold>0&&(s.allowThresholdMove=!1);let b=!0;c.matches(s.focusableElements)&&(b=!1,"SELECT"===c.nodeName&&(s.isTouched=!1)),a.activeElement&&a.activeElement.matches(s.focusableElements)&&a.activeElement!==c&&a.activeElement.blur();const w=b&&t.allowTouchMove&&o.touchStartPreventDefault;!o.touchStartForcePreventDefault&&!w||c.isContentEditable||l.preventDefault(),o.freeMode&&o.freeMode.enabled&&t.freeMode&&t.animating&&!o.cssMode&&t.freeMode.onTouchStart(),t.emit("touchStart",l)}function ro(e){const t=Es(),a=this,r=a.touchEventsData,{params:s,touches:o,rtlTranslate:n,enabled:i}=a;if(!i)return;if(!s.simulateTouch&&"mouse"===e.pointerType)return;let l=e;if(l.originalEvent&&(l=l.originalEvent),!r.isTouched)return void(r.startMoving&&r.isScrolling&&a.emit("touchMoveOpposite",l));const c=r.evCache.findIndex((e=>e.pointerId===l.pointerId));c>=0&&(r.evCache[c]=l);const p=r.evCache.length>1?r.evCache[0]:l,d=p.pageX,u=p.pageY;if(l.preventedByNestedSwiper)return o.startX=d,void(o.startY=u);if(!a.allowTouchMove)return l.target.matches(r.focusableElements)||(a.allowClick=!1),void(r.isTouched&&(Object.assign(o,{startX:d,startY:u,prevX:a.touches.currentX,prevY:a.touches.currentY,currentX:d,currentY:u}),r.touchStartTime=Ts()));if(s.touchReleaseOnEdges&&!s.loop)if(a.isVertical()){if(u<o.startY&&a.translate<=a.maxTranslate()||u>o.startY&&a.translate>=a.minTranslate())return r.isTouched=!1,void(r.isMoved=!1)}else if(d<o.startX&&a.translate<=a.maxTranslate()||d>o.startX&&a.translate>=a.minTranslate())return;if(t.activeElement&&l.target===t.activeElement&&l.target.matches(r.focusableElements))return r.isMoved=!0,void(a.allowClick=!1);if(r.allowTouchCallbacks&&a.emit("touchMove",l),l.targetTouches&&l.targetTouches.length>1)return;o.currentX=d,o.currentY=u;const h=o.currentX-o.startX,m=o.currentY-o.startY;if(a.params.threshold&&Math.sqrt(h**2+m**2)<a.params.threshold)return;if(void 0===r.isScrolling){let e;a.isHorizontal()&&o.currentY===o.startY||a.isVertical()&&o.currentX===o.startX?r.isScrolling=!1:h*h+m*m>=25&&(e=180*Math.atan2(Math.abs(m),Math.abs(h))/Math.PI,r.isScrolling=a.isHorizontal()?e>s.touchAngle:90-e>s.touchAngle)}if(r.isScrolling&&a.emit("touchMoveOpposite",l),void 0===r.startMoving&&(o.currentX===o.startX&&o.currentY===o.startY||(r.startMoving=!0)),r.isScrolling||a.zoom&&a.params.zoom&&a.params.zoom.enabled&&r.evCache.length>1)return void(r.isTouched=!1);if(!r.startMoving)return;a.allowClick=!1,!s.cssMode&&l.cancelable&&l.preventDefault(),s.touchMoveStopPropagation&&!s.nested&&l.stopPropagation();let f=a.isHorizontal()?h:m,g=a.isHorizontal()?o.currentX-o.previousX:o.currentY-o.previousY;s.oneWayMovement&&(f=Math.abs(f)*(n?1:-1),g=Math.abs(g)*(n?1:-1)),o.diff=f,f*=s.touchRatio,n&&(f=-f,g=-g);const v=a.touchesDirection;a.swipeDirection=f>0?"prev":"next",a.touchesDirection=g>0?"prev":"next";const b=a.params.loop&&!s.cssMode;if(!r.isMoved){if(b&&a.loopFix({direction:a.swipeDirection}),r.startTranslate=a.getTranslate(),a.setTransition(0),a.animating){const e=new window.CustomEvent("transitionend",{bubbles:!0,cancelable:!0});a.wrapperEl.dispatchEvent(e)}r.allowMomentumBounce=!1,!s.grabCursor||!0!==a.allowSlideNext&&!0!==a.allowSlidePrev||a.setGrabCursor(!0),a.emit("sliderFirstMove",l)}let w;r.isMoved&&v!==a.touchesDirection&&b&&Math.abs(f)>=1&&(a.loopFix({direction:a.swipeDirection,setTranslate:!0}),w=!0),a.emit("sliderMove",l),r.isMoved=!0,r.currentTranslate=f+r.startTranslate;let y=!0,C=s.resistanceRatio;if(s.touchReleaseOnEdges&&(C=0),f>0?(b&&!w&&r.currentTranslate>(s.centeredSlides?a.minTranslate()-a.size/2:a.minTranslate())&&a.loopFix({direction:"prev",setTranslate:!0,activeSlideIndex:0}),r.currentTranslate>a.minTranslate()&&(y=!1,s.resistance&&(r.currentTranslate=a.minTranslate()-1+(-a.minTranslate()+r.startTranslate+f)**C))):f<0&&(b&&!w&&r.currentTranslate<(s.centeredSlides?a.maxTranslate()+a.size/2:a.maxTranslate())&&a.loopFix({direction:"next",setTranslate:!0,activeSlideIndex:a.slides.length-("auto"===s.slidesPerView?a.slidesPerViewDynamic():Math.ceil(parseFloat(s.slidesPerView,10)))}),r.currentTranslate<a.maxTranslate()&&(y=!1,s.resistance&&(r.currentTranslate=a.maxTranslate()+1-(a.maxTranslate()-r.startTranslate-f)**C))),y&&(l.preventedByNestedSwiper=!0),!a.allowSlideNext&&"next"===a.swipeDirection&&r.currentTranslate<r.startTranslate&&(r.currentTranslate=r.startTranslate),!a.allowSlidePrev&&"prev"===a.swipeDirection&&r.currentTranslate>r.startTranslate&&(r.currentTranslate=r.startTranslate),a.allowSlidePrev||a.allowSlideNext||(r.currentTranslate=r.startTranslate),s.threshold>0){if(!(Math.abs(f)>s.threshold||r.allowThresholdMove))return void(r.currentTranslate=r.startTranslate);if(!r.allowThresholdMove)return r.allowThresholdMove=!0,o.startX=o.currentX,o.startY=o.currentY,r.currentTranslate=r.startTranslate,void(o.diff=a.isHorizontal()?o.currentX-o.startX:o.currentY-o.startY)}s.followFinger&&!s.cssMode&&((s.freeMode&&s.freeMode.enabled&&a.freeMode||s.watchSlidesProgress)&&(a.updateActiveIndex(),a.updateSlidesClasses()),s.freeMode&&s.freeMode.enabled&&a.freeMode&&a.freeMode.onTouchMove(),a.updateProgress(r.currentTranslate),a.setTranslate(r.currentTranslate))}function so(e){const t=this,a=t.touchEventsData,r=a.evCache.findIndex((t=>t.pointerId===e.pointerId));if(r>=0&&a.evCache.splice(r,1),["pointercancel","pointerout","pointerleave","contextmenu"].includes(e.type)){if(!(["pointercancel","contextmenu"].includes(e.type)&&(t.browser.isSafari||t.browser.isWebView)))return}const{params:s,touches:o,rtlTranslate:n,slidesGrid:i,enabled:l}=t;if(!l)return;if(!s.simulateTouch&&"mouse"===e.pointerType)return;let c=e;if(c.originalEvent&&(c=c.originalEvent),a.allowTouchCallbacks&&t.emit("touchEnd",c),a.allowTouchCallbacks=!1,!a.isTouched)return a.isMoved&&s.grabCursor&&t.setGrabCursor(!1),a.isMoved=!1,void(a.startMoving=!1);s.grabCursor&&a.isMoved&&a.isTouched&&(!0===t.allowSlideNext||!0===t.allowSlidePrev)&&t.setGrabCursor(!1);const p=Ts(),d=p-a.touchStartTime;if(t.allowClick){const e=c.path||c.composedPath&&c.composedPath();t.updateClickedSlide(e&&e[0]||c.target),t.emit("tap click",c),d<300&&p-a.lastClickTime<300&&t.emit("doubleTap doubleClick",c)}if(a.lastClickTime=Ts(),xs((()=>{t.destroyed||(t.allowClick=!0)})),!a.isTouched||!a.isMoved||!t.swipeDirection||0===o.diff||a.currentTranslate===a.startTranslate)return a.isTouched=!1,a.isMoved=!1,void(a.startMoving=!1);let u;if(a.isTouched=!1,a.isMoved=!1,a.startMoving=!1,u=s.followFinger?n?t.translate:-t.translate:-a.currentTranslate,s.cssMode)return;if(s.freeMode&&s.freeMode.enabled)return void t.freeMode.onTouchEnd({currentPos:u});let h=0,m=t.slidesSizesGrid[0];for(let e=0;e<i.length;e+=e<s.slidesPerGroupSkip?1:s.slidesPerGroup){const t=e<s.slidesPerGroupSkip-1?1:s.slidesPerGroup;void 0!==i[e+t]?u>=i[e]&&u<i[e+t]&&(h=e,m=i[e+t]-i[e]):u>=i[e]&&(h=e,m=i[i.length-1]-i[i.length-2])}let f=null,g=null;s.rewind&&(t.isBeginning?g=s.virtual&&s.virtual.enabled&&t.virtual?t.virtual.slides.length-1:t.slides.length-1:t.isEnd&&(f=0));const v=(u-i[h])/m,b=h<s.slidesPerGroupSkip-1?1:s.slidesPerGroup;if(d>s.longSwipesMs){if(!s.longSwipes)return void t.slideTo(t.activeIndex);"next"===t.swipeDirection&&(v>=s.longSwipesRatio?t.slideTo(s.rewind&&t.isEnd?f:h+b):t.slideTo(h)),"prev"===t.swipeDirection&&(v>1-s.longSwipesRatio?t.slideTo(h+b):null!==g&&v<0&&Math.abs(v)>s.longSwipesRatio?t.slideTo(g):t.slideTo(h))}else{if(!s.shortSwipes)return void t.slideTo(t.activeIndex);t.navigation&&(c.target===t.navigation.nextEl||c.target===t.navigation.prevEl)?c.target===t.navigation.nextEl?t.slideTo(h+b):t.slideTo(h):("next"===t.swipeDirection&&t.slideTo(null!==f?f:h+b),"prev"===t.swipeDirection&&t.slideTo(null!==g?g:h))}}function oo(){const e=this,{params:t,el:a}=e;if(a&&0===a.offsetWidth)return;t.breakpoints&&e.setBreakpoint();const{allowSlideNext:r,allowSlidePrev:s,snapGrid:o}=e,n=e.virtual&&e.params.virtual.enabled;e.allowSlideNext=!0,e.allowSlidePrev=!0,e.updateSize(),e.updateSlides(),e.updateSlidesClasses();const i=n&&t.loop;!("auto"===t.slidesPerView||t.slidesPerView>1)||!e.isEnd||e.isBeginning||e.params.centeredSlides||i?e.params.loop&&!n?e.slideToLoop(e.realIndex,0,!1,!0):e.slideTo(e.activeIndex,0,!1,!0):e.slideTo(e.slides.length-1,0,!1,!0),e.autoplay&&e.autoplay.running&&e.autoplay.paused&&(clearTimeout(e.autoplay.resizeTimeout),e.autoplay.resizeTimeout=setTimeout((()=>{e.autoplay&&e.autoplay.running&&e.autoplay.paused&&e.autoplay.resume()}),500)),e.allowSlidePrev=s,e.allowSlideNext=r,e.params.watchOverflow&&o!==e.snapGrid&&e.checkOverflow()}function no(e){const t=this;t.enabled&&(t.allowClick||(t.params.preventClicks&&e.preventDefault(),t.params.preventClicksPropagation&&t.animating&&(e.stopPropagation(),e.stopImmediatePropagation())))}function io(){const e=this,{wrapperEl:t,rtlTranslate:a,enabled:r}=e;if(!r)return;let s;e.previousTranslate=e.translate,e.isHorizontal()?e.translate=-t.scrollLeft:e.translate=-t.scrollTop,0===e.translate&&(e.translate=0),e.updateActiveIndex(),e.updateSlidesClasses();const o=e.maxTranslate()-e.minTranslate();s=0===o?0:(e.translate-e.minTranslate())/o,s!==e.progress&&e.updateProgress(a?-e.translate:e.translate),e.emit("setTranslate",e.translate,!1)}function lo(e){const t=this;Us(t,e.target),t.params.cssMode||"auto"!==t.params.slidesPerView&&!t.params.autoHeight||t.update()}let co=!1;function po(){}const uo=(e,t)=>{const a=Es(),{params:r,el:s,wrapperEl:o,device:n}=e,i=!!r.nested,l="on"===t?"addEventListener":"removeEventListener",c=t;s[l]("pointerdown",e.onTouchStart,{passive:!1}),a[l]("pointermove",e.onTouchMove,{passive:!1,capture:i}),a[l]("pointerup",e.onTouchEnd,{passive:!0}),a[l]("pointercancel",e.onTouchEnd,{passive:!0}),a[l]("pointerout",e.onTouchEnd,{passive:!0}),a[l]("pointerleave",e.onTouchEnd,{passive:!0}),a[l]("contextmenu",e.onTouchEnd,{passive:!0}),(r.preventClicks||r.preventClicksPropagation)&&s[l]("click",e.onClick,!0),r.cssMode&&o[l]("scroll",e.onScroll),r.updateOnWindowResize?e[c](n.ios||n.android?"resize orientationchange observerUpdate":"resize observerUpdate",oo,!0):e[c]("observerUpdate",oo,!0),s[l]("load",e.onLoad,{capture:!0})};const ho=(e,t)=>e.grid&&t.grid&&t.grid.rows>1;var mo={setBreakpoint:function(){const e=this,{realIndex:t,initialized:a,params:r,el:s}=e,o=r.breakpoints;if(!o||o&&0===Object.keys(o).length)return;const n=e.getBreakpoint(o,e.params.breakpointsBase,e.el);if(!n||e.currentBreakpoint===n)return;const i=(n in o?o[n]:void 0)||e.originalParams,l=ho(e,r),c=ho(e,i),p=r.enabled;l&&!c?(s.classList.remove(`${r.containerModifierClass}grid`,`${r.containerModifierClass}grid-column`),e.emitContainerClasses()):!l&&c&&(s.classList.add(`${r.containerModifierClass}grid`),(i.grid.fill&&"column"===i.grid.fill||!i.grid.fill&&"column"===r.grid.fill)&&s.classList.add(`${r.containerModifierClass}grid-column`),e.emitContainerClasses()),["navigation","pagination","scrollbar"].forEach((t=>{if(void 0===i[t])return;const a=r[t]&&r[t].enabled,s=i[t]&&i[t].enabled;a&&!s&&e[t].disable(),!a&&s&&e[t].enable()}));const d=i.direction&&i.direction!==r.direction,u=r.loop&&(i.slidesPerView!==r.slidesPerView||d);d&&a&&e.changeDirection(),Ms(e.params,i);const h=e.params.enabled;Object.assign(e,{allowTouchMove:e.params.allowTouchMove,allowSlideNext:e.params.allowSlideNext,allowSlidePrev:e.params.allowSlidePrev}),p&&!h?e.disable():!p&&h&&e.enable(),e.currentBreakpoint=n,e.emit("_beforeBreakpoint",i),u&&a&&(e.loopDestroy(),e.loopCreate(t),e.updateSlides()),e.emit("breakpoint",i)},getBreakpoint:function(e,t,a){if(void 0===t&&(t="window"),!e||"container"===t&&!a)return;let r=!1;const s=$s(),o="window"===t?s.innerHeight:a.clientHeight,n=Object.keys(e).map((e=>{if("string"==typeof e&&0===e.indexOf("@")){const t=parseFloat(e.substr(1));return{value:o*t,point:e}}return{value:e,point:e}}));n.sort(((e,t)=>parseInt(e.value,10)-parseInt(t.value,10)));for(let e=0;e<n.length;e+=1){const{point:o,value:i}=n[e];"window"===t?s.matchMedia(`(min-width: ${i}px)`).matches&&(r=o):i<=a.clientWidth&&(r=o)}return r||"max"}};var fo={init:!0,direction:"horizontal",oneWayMovement:!1,touchEventsTarget:"wrapper",initialSlide:0,speed:300,cssMode:!1,updateOnWindowResize:!0,resizeObserver:!0,nested:!1,createElements:!1,enabled:!0,focusableElements:"input, select, option, textarea, button, video, label",width:null,height:null,preventInteractionOnTransition:!1,userAgent:null,url:null,edgeSwipeDetection:!1,edgeSwipeThreshold:20,autoHeight:!1,setWrapperSize:!1,virtualTranslate:!1,effect:"slide",breakpoints:void 0,breakpointsBase:"window",spaceBetween:0,slidesPerView:1,slidesPerGroup:1,slidesPerGroupSkip:0,slidesPerGroupAuto:!1,centeredSlides:!1,centeredSlidesBounds:!1,slidesOffsetBefore:0,slidesOffsetAfter:0,normalizeSlideIndex:!0,centerInsufficientSlides:!1,watchOverflow:!0,roundLengths:!1,touchRatio:1,touchAngle:45,simulateTouch:!0,shortSwipes:!0,longSwipes:!0,longSwipesRatio:.5,longSwipesMs:300,followFinger:!0,allowTouchMove:!0,threshold:5,touchMoveStopPropagation:!1,touchStartPreventDefault:!0,touchStartForcePreventDefault:!1,touchReleaseOnEdges:!1,uniqueNavElements:!0,resistance:!0,resistanceRatio:.85,watchSlidesProgress:!1,grabCursor:!1,preventClicks:!0,preventClicksPropagation:!0,slideToClickedSlide:!1,loop:!1,loopedSlides:null,loopPreventsSliding:!0,rewind:!1,allowSlidePrev:!0,allowSlideNext:!0,swipeHandler:null,noSwiping:!0,noSwipingClass:"swiper-no-swiping",noSwipingSelector:null,passiveListeners:!0,maxBackfaceHiddenSlides:10,containerModifierClass:"swiper-",slideClass:"swiper-slide",slideActiveClass:"swiper-slide-active",slideVisibleClass:"swiper-slide-visible",slideNextClass:"swiper-slide-next",slidePrevClass:"swiper-slide-prev",wrapperClass:"swiper-wrapper",lazyPreloaderClass:"swiper-lazy-preloader",lazyPreloadPrevNext:0,runCallbacksOnInit:!0,_emitClasses:!1};function go(e,t){return function(a){void 0===a&&(a={});const r=Object.keys(a)[0],s=a[r];"object"==typeof s&&null!==s?(["navigation","pagination","scrollbar"].indexOf(r)>=0&&!0===e[r]&&(e[r]={auto:!0}),r in e&&"enabled"in s?(!0===e[r]&&(e[r]={enabled:!0}),"object"!=typeof e[r]||"enabled"in e[r]||(e[r].enabled=!0),e[r]||(e[r]={enabled:!1}),Ms(t,a)):Ms(t,a)):Ms(t,a)}}const vo={eventsEmitter:Xs,update:Qs,translate:Js,transition:{setTransition:function(e,t){const a=this;a.params.cssMode||(a.wrapperEl.style.transitionDuration=`${e}ms`,a.wrapperEl.style.transitionDelay=0===e?"0ms":""),a.emit("setTransition",e,t)},transitionStart:function(e,t){void 0===e&&(e=!0);const a=this,{params:r}=a;r.cssMode||(r.autoHeight&&a.updateAutoHeight(),Zs({swiper:a,runCallbacks:e,direction:t,step:"Start"}))},transitionEnd:function(e,t){void 0===e&&(e=!0);const a=this,{params:r}=a;a.animating=!1,r.cssMode||(a.setTransition(0),Zs({swiper:a,runCallbacks:e,direction:t,step:"End"}))}},slide:eo,loop:to,grabCursor:{setGrabCursor:function(e){const t=this;if(!t.params.simulateTouch||t.params.watchOverflow&&t.isLocked||t.params.cssMode)return;const a="container"===t.params.touchEventsTarget?t.el:t.wrapperEl;t.isElement&&(t.__preventObserver__=!0),a.style.cursor="move",a.style.cursor=e?"grabbing":"grab",t.isElement&&requestAnimationFrame((()=>{t.__preventObserver__=!1}))},unsetGrabCursor:function(){const e=this;e.params.watchOverflow&&e.isLocked||e.params.cssMode||(e.isElement&&(e.__preventObserver__=!0),e["container"===e.params.touchEventsTarget?"el":"wrapperEl"].style.cursor="",e.isElement&&requestAnimationFrame((()=>{e.__preventObserver__=!1})))}},events:{attachEvents:function(){const e=this,t=Es(),{params:a}=e;e.onTouchStart=ao.bind(e),e.onTouchMove=ro.bind(e),e.onTouchEnd=so.bind(e),a.cssMode&&(e.onScroll=io.bind(e)),e.onClick=no.bind(e),e.onLoad=lo.bind(e),co||(t.addEventListener("touchstart",po),co=!0),uo(e,"on")},detachEvents:function(){uo(this,"off")}},breakpoints:mo,checkOverflow:{checkOverflow:function(){const e=this,{isLocked:t,params:a}=e,{slidesOffsetBefore:r}=a;if(r){const t=e.slides.length-1,a=e.slidesGrid[t]+e.slidesSizesGrid[t]+2*r;e.isLocked=e.size>a}else e.isLocked=1===e.snapGrid.length;!0===a.allowSlideNext&&(e.allowSlideNext=!e.isLocked),!0===a.allowSlidePrev&&(e.allowSlidePrev=!e.isLocked),t&&t!==e.isLocked&&(e.isEnd=!1),t!==e.isLocked&&e.emit(e.isLocked?"lock":"unlock")}},classes:{addClasses:function(){const e=this,{classNames:t,params:a,rtl:r,el:s,device:o}=e,n=function(e,t){const a=[];return e.forEach((e=>{"object"==typeof e?Object.keys(e).forEach((r=>{e[r]&&a.push(t+r)})):"string"==typeof e&&a.push(t+e)})),a}(["initialized",a.direction,{"free-mode":e.params.freeMode&&a.freeMode.enabled},{autoheight:a.autoHeight},{rtl:r},{grid:a.grid&&a.grid.rows>1},{"grid-column":a.grid&&a.grid.rows>1&&"column"===a.grid.fill},{android:o.android},{ios:o.ios},{"css-mode":a.cssMode},{centered:a.cssMode&&a.centeredSlides},{"watch-progress":a.watchSlidesProgress}],a.containerModifierClass);t.push(...n),s.classList.add(...t),e.emitContainerClasses()},removeClasses:function(){const{el:e,classNames:t}=this;e.classList.remove(...t),this.emitContainerClasses()}}},bo={};let wo=class e{constructor(){let t,a;for(var r=arguments.length,s=new Array(r),o=0;o<r;o++)s[o]=arguments[o];1===s.length&&s[0].constructor&&"Object"===Object.prototype.toString.call(s[0]).slice(8,-1)?a=s[0]:[t,a]=s,a||(a={}),a=Ms({},a),t&&!a.el&&(a.el=t);const n=Es();if(a.el&&"string"==typeof a.el&&n.querySelectorAll(a.el).length>1){const t=[];return n.querySelectorAll(a.el).forEach((r=>{const s=Ms({},a,{el:r});t.push(new e(s))})),t}const i=this;i.__swiper__=!0,i.support=js(),i.device=Ys({userAgent:a.userAgent}),i.browser=Ws(),i.eventsListeners={},i.eventsAnyListeners=[],i.modules=[...i.__modules__],a.modules&&Array.isArray(a.modules)&&i.modules.push(...a.modules);const l={};i.modules.forEach((e=>{e({params:a,swiper:i,extendParams:go(a,l),on:i.on.bind(i),once:i.once.bind(i),off:i.off.bind(i),emit:i.emit.bind(i)})}));const c=Ms({},fo,l);return i.params=Ms({},c,bo,a),i.originalParams=Ms({},i.params),i.passedParams=Ms({},a),i.params&&i.params.on&&Object.keys(i.params.on).forEach((e=>{i.on(e,i.params.on[e])})),i.params&&i.params.onAny&&i.onAny(i.params.onAny),Object.assign(i,{enabled:i.params.enabled,el:t,classNames:[],slides:[],slidesGrid:[],snapGrid:[],slidesSizesGrid:[],isHorizontal:()=>"horizontal"===i.params.direction,isVertical:()=>"vertical"===i.params.direction,activeIndex:0,realIndex:0,isBeginning:!0,isEnd:!1,translate:0,previousTranslate:0,progress:0,velocity:0,animating:!1,cssOverflowAdjustment(){return Math.trunc(this.translate/2**23)*2**23},allowSlideNext:i.params.allowSlideNext,allowSlidePrev:i.params.allowSlidePrev,touchEventsData:{isTouched:void 0,isMoved:void 0,allowTouchCallbacks:void 0,touchStartTime:void 0,isScrolling:void 0,currentTranslate:void 0,startTranslate:void 0,allowThresholdMove:void 0,focusableElements:i.params.focusableElements,lastClickTime:0,clickTimeout:void 0,velocities:[],allowMomentumBounce:void 0,startMoving:void 0,evCache:[]},allowClick:!0,allowTouchMove:i.params.allowTouchMove,touches:{startX:0,startY:0,currentX:0,currentY:0,diff:0},imagesToLoad:[],imagesLoaded:0}),i.emit("_swiper"),i.params.init&&i.init(),i}getSlideIndex(e){const{slidesEl:t,params:a}=this,r=Hs(Ls(t,`.${a.slideClass}, swiper-slide`)[0]);return Hs(e)-r}getSlideIndexByData(e){return this.getSlideIndex(this.slides.filter((t=>1*t.getAttribute("data-swiper-slide-index")===e))[0])}recalcSlides(){const{slidesEl:e,params:t}=this;this.slides=Ls(e,`.${t.slideClass}, swiper-slide`)}enable(){const e=this;e.enabled||(e.enabled=!0,e.params.grabCursor&&e.setGrabCursor(),e.emit("enable"))}disable(){const e=this;e.enabled&&(e.enabled=!1,e.params.grabCursor&&e.unsetGrabCursor(),e.emit("disable"))}setProgress(e,t){const a=this;e=Math.min(Math.max(e,0),1);const r=a.minTranslate(),s=(a.maxTranslate()-r)*e+r;a.translateTo(s,void 0===t?0:t),a.updateActiveIndex(),a.updateSlidesClasses()}emitContainerClasses(){const e=this;if(!e.params._emitClasses||!e.el)return;const t=e.el.className.split(" ").filter((t=>0===t.indexOf("swiper")||0===t.indexOf(e.params.containerModifierClass)));e.emit("_containerClasses",t.join(" "))}getSlideClasses(e){const t=this;return t.destroyed?"":e.className.split(" ").filter((e=>0===e.indexOf("swiper-slide")||0===e.indexOf(t.params.slideClass))).join(" ")}emitSlidesClasses(){const e=this;if(!e.params._emitClasses||!e.el)return;const t=[];e.slides.forEach((a=>{const r=e.getSlideClasses(a);t.push({slideEl:a,classNames:r}),e.emit("_slideClass",a,r)})),e.emit("_slideClasses",t)}slidesPerViewDynamic(e,t){void 0===e&&(e="current"),void 0===t&&(t=!1);const{params:a,slides:r,slidesGrid:s,slidesSizesGrid:o,size:n,activeIndex:i}=this;let l=1;if(a.centeredSlides){let e,t=r[i]?r[i].swiperSlideSize:0;for(let a=i+1;a<r.length;a+=1)r[a]&&!e&&(t+=r[a].swiperSlideSize,l+=1,t>n&&(e=!0));for(let a=i-1;a>=0;a-=1)r[a]&&!e&&(t+=r[a].swiperSlideSize,l+=1,t>n&&(e=!0))}else if("current"===e)for(let e=i+1;e<r.length;e+=1){(t?s[e]+o[e]-s[i]<n:s[e]-s[i]<n)&&(l+=1)}else for(let e=i-1;e>=0;e-=1){s[i]-s[e]<n&&(l+=1)}return l}update(){const e=this;if(!e||e.destroyed)return;const{snapGrid:t,params:a}=e;function r(){const t=e.rtlTranslate?-1*e.translate:e.translate,a=Math.min(Math.max(t,e.maxTranslate()),e.minTranslate());e.setTranslate(a),e.updateActiveIndex(),e.updateSlidesClasses()}let s;if(a.breakpoints&&e.setBreakpoint(),[...e.el.querySelectorAll('[loading="lazy"]')].forEach((t=>{t.complete&&Us(e,t)})),e.updateSize(),e.updateSlides(),e.updateProgress(),e.updateSlidesClasses(),a.freeMode&&a.freeMode.enabled&&!a.cssMode)r(),a.autoHeight&&e.updateAutoHeight();else{if(("auto"===a.slidesPerView||a.slidesPerView>1)&&e.isEnd&&!a.centeredSlides){const t=e.virtual&&a.virtual.enabled?e.virtual.slides:e.slides;s=e.slideTo(t.length-1,0,!1,!0)}else s=e.slideTo(e.activeIndex,0,!1,!0);s||r()}a.watchOverflow&&t!==e.snapGrid&&e.checkOverflow(),e.emit("update")}changeDirection(e,t){void 0===t&&(t=!0);const a=this,r=a.params.direction;return e||(e="horizontal"===r?"vertical":"horizontal"),e===r||"horizontal"!==e&&"vertical"!==e||(a.el.classList.remove(`${a.params.containerModifierClass}${r}`),a.el.classList.add(`${a.params.containerModifierClass}${e}`),a.emitContainerClasses(),a.params.direction=e,a.slides.forEach((t=>{"vertical"===e?t.style.width="":t.style.height=""})),a.emit("changeDirection"),t&&a.update()),a}changeLanguageDirection(e){const t=this;t.rtl&&"rtl"===e||!t.rtl&&"ltr"===e||(t.rtl="rtl"===e,t.rtlTranslate="horizontal"===t.params.direction&&t.rtl,t.rtl?(t.el.classList.add(`${t.params.containerModifierClass}rtl`),t.el.dir="rtl"):(t.el.classList.remove(`${t.params.containerModifierClass}rtl`),t.el.dir="ltr"),t.update())}mount(e){const t=this;if(t.mounted)return!0;let a=e||t.params.el;if("string"==typeof a&&(a=document.querySelector(a)),!a)return!1;a.swiper=t,a.parentNode&&a.parentNode.host&&"SWIPER-CONTAINER"===a.parentNode.host.nodeName&&(t.isElement=!0);const r=()=>`.${(t.params.wrapperClass||"").trim().split(" ").join(".")}`;let s=(()=>{if(a&&a.shadowRoot&&a.shadowRoot.querySelector){return a.shadowRoot.querySelector(r())}return Ls(a,r())[0]})();return!s&&t.params.createElements&&(s=Ds("div",t.params.wrapperClass),a.append(s),Ls(a,`.${t.params.slideClass}`).forEach((e=>{s.append(e)}))),Object.assign(t,{el:a,wrapperEl:s,slidesEl:t.isElement&&!a.parentNode.host.slideSlots?a.parentNode.host:s,hostEl:t.isElement?a.parentNode.host:a,mounted:!0,rtl:"rtl"===a.dir.toLowerCase()||"rtl"===Rs(a,"direction"),rtlTranslate:"horizontal"===t.params.direction&&("rtl"===a.dir.toLowerCase()||"rtl"===Rs(a,"direction")),wrongRTL:"-webkit-box"===Rs(s,"display")}),!0}init(e){const t=this;if(t.initialized)return t;if(!1===t.mount(e))return t;t.emit("beforeInit"),t.params.breakpoints&&t.setBreakpoint(),t.addClasses(),t.updateSize(),t.updateSlides(),t.params.watchOverflow&&t.checkOverflow(),t.params.grabCursor&&t.enabled&&t.setGrabCursor(),t.params.loop&&t.virtual&&t.params.virtual.enabled?t.slideTo(t.params.initialSlide+t.virtual.slidesBefore,0,t.params.runCallbacksOnInit,!1,!0):t.slideTo(t.params.initialSlide,0,t.params.runCallbacksOnInit,!1,!0),t.params.loop&&t.loopCreate(),t.attachEvents();const a=[...t.el.querySelectorAll('[loading="lazy"]')];return t.isElement&&a.push(...t.hostEl.querySelectorAll('[loading="lazy"]')),a.forEach((e=>{e.complete?Us(t,e):e.addEventListener("load",(e=>{Us(t,e.target)}))})),Ks(t),t.initialized=!0,Ks(t),t.emit("init"),t.emit("afterInit"),t}destroy(e,t){void 0===e&&(e=!0),void 0===t&&(t=!0);const a=this,{params:r,el:s,wrapperEl:o,slides:n}=a;return void 0===a.params||a.destroyed||(a.emit("beforeDestroy"),a.initialized=!1,a.detachEvents(),r.loop&&a.loopDestroy(),t&&(a.removeClasses(),s.removeAttribute("style"),o.removeAttribute("style"),n&&n.length&&n.forEach((e=>{e.classList.remove(r.slideVisibleClass,r.slideActiveClass,r.slideNextClass,r.slidePrevClass),e.removeAttribute("style"),e.removeAttribute("data-swiper-slide-index")}))),a.emit("destroy"),Object.keys(a.eventsListeners).forEach((e=>{a.off(e)})),!1!==e&&(a.el.swiper=null,function(e){const t=e;Object.keys(t).forEach((e=>{try{t[e]=null}catch(e){}try{delete t[e]}catch(e){}}))}(a)),a.destroyed=!0),null}static extendDefaults(e){Ms(bo,e)}static get extendedDefaults(){return bo}static get defaults(){return fo}static installModule(t){e.prototype.__modules__||(e.prototype.__modules__=[]);const a=e.prototype.__modules__;"function"==typeof t&&a.indexOf(t)<0&&a.push(t)}static use(t){return Array.isArray(t)?(t.forEach((t=>e.installModule(t))),e):(e.installModule(t),e)}};function yo(e,t,a,r){return e.params.createElements&&Object.keys(r).forEach((s=>{if(!a[s]&&!0===a.auto){let o=Ls(e.el,`.${r[s]}`)[0];o||(o=Ds("div",r[s]),o.className=r[s],e.el.append(o)),a[s]=o,t[s]=o}})),a}function Co(e){return void 0===e&&(e=""),`.${e.trim().replace(/([\.:!+\/])/g,"\\$1").replace(/ /g,".")}`}function Eo(e){const t=this,{params:a,slidesEl:r}=t;a.loop&&t.loopDestroy();const s=e=>{if("string"==typeof e){const t=document.createElement("div");t.innerHTML=e,r.append(t.children[0]),t.innerHTML=""}else r.append(e)};if("object"==typeof e&&"length"in e)for(let t=0;t<e.length;t+=1)e[t]&&s(e[t]);else s(e);t.recalcSlides(),a.loop&&t.loopCreate(),a.observer&&!t.isElement||t.update()}function ko(e){const t=this,{params:a,activeIndex:r,slidesEl:s}=t;a.loop&&t.loopDestroy();let o=r+1;const n=e=>{if("string"==typeof e){const t=document.createElement("div");t.innerHTML=e,s.prepend(t.children[0]),t.innerHTML=""}else s.prepend(e)};if("object"==typeof e&&"length"in e){for(let t=0;t<e.length;t+=1)e[t]&&n(e[t]);o=r+e.length}else n(e);t.recalcSlides(),a.loop&&t.loopCreate(),a.observer&&!t.isElement||t.update(),t.slideTo(o,0,!1)}function $o(e,t){const a=this,{params:r,activeIndex:s,slidesEl:o}=a;let n=s;r.loop&&(n-=a.loopedSlides,a.loopDestroy(),a.recalcSlides());const i=a.slides.length;if(e<=0)return void a.prependSlide(t);if(e>=i)return void a.appendSlide(t);let l=n>e?n+1:n;const c=[];for(let t=i-1;t>=e;t-=1){const e=a.slides[t];e.remove(),c.unshift(e)}if("object"==typeof t&&"length"in t){for(let e=0;e<t.length;e+=1)t[e]&&o.append(t[e]);l=n>e?n+t.length:n}else o.append(t);for(let e=0;e<c.length;e+=1)o.append(c[e]);a.recalcSlides(),r.loop&&a.loopCreate(),r.observer&&!a.isElement||a.update(),r.loop?a.slideTo(l+a.loopedSlides,0,!1):a.slideTo(l,0,!1)}function xo(e){const t=this,{params:a,activeIndex:r}=t;let s=r;a.loop&&(s-=t.loopedSlides,t.loopDestroy());let o,n=s;if("object"==typeof e&&"length"in e){for(let a=0;a<e.length;a+=1)o=e[a],t.slides[o]&&t.slides[o].remove(),o<n&&(n-=1);n=Math.max(n,0)}else o=e,t.slides[o]&&t.slides[o].remove(),o<n&&(n-=1),n=Math.max(n,0);t.recalcSlides(),a.loop&&t.loopCreate(),a.observer&&!t.isElement||t.update(),a.loop?t.slideTo(n+t.loopedSlides,0,!1):t.slideTo(n,0,!1)}function To(){const e=this,t=[];for(let a=0;a<e.slides.length;a+=1)t.push(a);e.removeSlide(t)}function So(e){const{effect:t,swiper:a,on:r,setTranslate:s,setTransition:o,overwriteParams:n,perspective:i,recreateShadows:l,getEffectParams:c}=e;let p;r("beforeInit",(()=>{if(a.params.effect!==t)return;a.classNames.push(`${a.params.containerModifierClass}${t}`),i&&i()&&a.classNames.push(`${a.params.containerModifierClass}3d`);const e=n?n():{};Object.assign(a.params,e),Object.assign(a.originalParams,e)})),r("setTranslate",(()=>{a.params.effect===t&&s()})),r("setTransition",((e,r)=>{a.params.effect===t&&o(r)})),r("transitionEnd",(()=>{if(a.params.effect===t&&l){if(!c||!c().slideShadows)return;a.slides.forEach((e=>{e.querySelectorAll(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").forEach((e=>e.remove()))})),l()}})),r("virtualUpdate",(()=>{a.params.effect===t&&(a.slides.length||(p=!0),requestAnimationFrame((()=>{p&&a.slides&&a.slides.length&&(s(),p=!1)})))}))}function Po(e,t){const a=Bs(t);return a!==t&&(a.style.backfaceVisibility="hidden",a.style["-webkit-backface-visibility"]="hidden"),a}function Mo(e){let{swiper:t,duration:a,transformElements:r,allSlides:s}=e;const{activeIndex:o}=t;if(t.params.virtualTranslate&&0!==a){let e,a=!1;e=s?r:r.filter((e=>{const a=e.classList.contains("swiper-slide-transform")?(e=>{if(!e.parentElement)return t.slides.filter((t=>t.shadowRoot&&t.shadowRoot===e.parentNode))[0];return e.parentElement})(e):e;return t.getSlideIndex(a)===o})),e.forEach((e=>{Ns(e,(()=>{if(a)return;if(!t||t.destroyed)return;a=!0,t.animating=!1;const e=new window.CustomEvent("transitionend",{bubbles:!0,cancelable:!0});t.wrapperEl.dispatchEvent(e)}))}))}}function Oo(e,t,a){const r=`swiper-slide-shadow${a?`-${a}`:""}${e?` swiper-slide-shadow-${e}`:""}`,s=Bs(t);let o=s.querySelector(`.${r.split(" ").join(".")}`);return o||(o=Ds("div",r.split(" ")),s.append(o)),o}Object.keys(vo).forEach((e=>{Object.keys(vo[e]).forEach((t=>{wo.prototype[t]=vo[e][t]}))})),wo.use([function(e){let{swiper:t,on:a,emit:r}=e;const s=$s();let o=null,n=null;const i=()=>{t&&!t.destroyed&&t.initialized&&(r("beforeResize"),r("resize"))},l=()=>{t&&!t.destroyed&&t.initialized&&r("orientationchange")};a("init",(()=>{t.params.resizeObserver&&void 0!==s.ResizeObserver?t&&!t.destroyed&&t.initialized&&(o=new ResizeObserver((e=>{n=s.requestAnimationFrame((()=>{const{width:a,height:r}=t;let s=a,o=r;e.forEach((e=>{let{contentBoxSize:a,contentRect:r,target:n}=e;n&&n!==t.el||(s=r?r.width:(a[0]||a).inlineSize,o=r?r.height:(a[0]||a).blockSize)})),s===a&&o===r||i()}))})),o.observe(t.el)):(s.addEventListener("resize",i),s.addEventListener("orientationchange",l))})),a("destroy",(()=>{n&&s.cancelAnimationFrame(n),o&&o.unobserve&&t.el&&(o.unobserve(t.el),o=null),s.removeEventListener("resize",i),s.removeEventListener("orientationchange",l)}))},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;const o=[],n=$s(),i=function(e,a){void 0===a&&(a={});const r=new(n.MutationObserver||n.WebkitMutationObserver)((e=>{if(t.__preventObserver__)return;if(1===e.length)return void s("observerUpdate",e[0]);const a=function(){s("observerUpdate",e[0])};n.requestAnimationFrame?n.requestAnimationFrame(a):n.setTimeout(a,0)}));r.observe(e,{attributes:void 0===a.attributes||a.attributes,childList:void 0===a.childList||a.childList,characterData:void 0===a.characterData||a.characterData}),o.push(r)};a({observer:!1,observeParents:!1,observeSlideChildren:!1}),r("init",(()=>{if(t.params.observer){if(t.params.observeParents){const e=zs(t.hostEl);for(let t=0;t<e.length;t+=1)i(e[t])}i(t.hostEl,{childList:t.params.observeSlideChildren}),i(t.wrapperEl,{attributes:!1})}})),r("destroy",(()=>{o.forEach((e=>{e.disconnect()})),o.splice(0,o.length)}))}]);const Io=[function(e){let t,{swiper:a,extendParams:r,on:s,emit:o}=e;r({virtual:{enabled:!1,slides:[],cache:!0,renderSlide:null,renderExternal:null,renderExternalUpdate:!0,addSlidesBefore:0,addSlidesAfter:0}});const n=Es();a.virtual={cache:{},from:void 0,to:void 0,slides:[],offset:0,slidesGrid:[]};const i=n.createElement("div");function l(e,t){const r=a.params.virtual;if(r.cache&&a.virtual.cache[t])return a.virtual.cache[t];let s;return r.renderSlide?(s=r.renderSlide.call(a,e,t),"string"==typeof s&&(i.innerHTML=s,s=i.children[0])):s=a.isElement?Ds("swiper-slide"):Ds("div",a.params.slideClass),s.setAttribute("data-swiper-slide-index",t),r.renderSlide||(s.innerHTML=e),r.cache&&(a.virtual.cache[t]=s),s}function c(e){const{slidesPerView:t,slidesPerGroup:r,centeredSlides:s,loop:n}=a.params,{addSlidesBefore:i,addSlidesAfter:c}=a.params.virtual,{from:p,to:d,slides:u,slidesGrid:h,offset:m}=a.virtual;a.params.cssMode||a.updateActiveIndex();const f=a.activeIndex||0;let g,v,b;g=a.rtlTranslate?"right":a.isHorizontal()?"left":"top",s?(v=Math.floor(t/2)+r+c,b=Math.floor(t/2)+r+i):(v=t+(r-1)+c,b=(n?t:r)+i);let w=f-b,y=f+v;n||(w=Math.max(w,0),y=Math.min(y,u.length-1));let C=(a.slidesGrid[w]||0)-(a.slidesGrid[0]||0);function E(){a.updateSlides(),a.updateProgress(),a.updateSlidesClasses(),o("virtualUpdate")}if(n&&f>=b?(w-=b,s||(C+=a.slidesGrid[0])):n&&f<b&&(w=-b,s&&(C+=a.slidesGrid[0])),Object.assign(a.virtual,{from:w,to:y,offset:C,slidesGrid:a.slidesGrid,slidesBefore:b,slidesAfter:v}),p===w&&d===y&&!e)return a.slidesGrid!==h&&C!==m&&a.slides.forEach((e=>{e.style[g]=C-Math.abs(a.cssOverflowAdjustment())+"px"})),a.updateProgress(),void o("virtualUpdate");if(a.params.virtual.renderExternal)return a.params.virtual.renderExternal.call(a,{offset:C,from:w,to:y,slides:function(){const e=[];for(let t=w;t<=y;t+=1)e.push(u[t]);return e}()}),void(a.params.virtual.renderExternalUpdate?E():o("virtualUpdate"));const k=[],$=[],x=e=>{let t=e;return e<0?t=u.length+e:t>=u.length&&(t-=u.length),t};if(e)a.slidesEl.querySelectorAll(`.${a.params.slideClass}, swiper-slide`).forEach((e=>{e.remove()}));else for(let e=p;e<=d;e+=1)if(e<w||e>y){const t=x(e);a.slidesEl.querySelectorAll(`.${a.params.slideClass}[data-swiper-slide-index="${t}"], swiper-slide[data-swiper-slide-index="${t}"]`).forEach((e=>{e.remove()}))}const T=n?-u.length:0,S=n?2*u.length:u.length;for(let t=T;t<S;t+=1)if(t>=w&&t<=y){const a=x(t);void 0===d||e?$.push(a):(t>d&&$.push(a),t<p&&k.push(a))}if($.forEach((e=>{a.slidesEl.append(l(u[e],e))})),n)for(let e=k.length-1;e>=0;e-=1){const t=k[e];a.slidesEl.prepend(l(u[t],t))}else k.sort(((e,t)=>t-e)),k.forEach((e=>{a.slidesEl.prepend(l(u[e],e))}));Ls(a.slidesEl,".swiper-slide, swiper-slide").forEach((e=>{e.style[g]=C-Math.abs(a.cssOverflowAdjustment())+"px"})),E()}s("beforeInit",(()=>{if(!a.params.virtual.enabled)return;let e;if(void 0===a.passedParams.virtual.slides){const t=[...a.slidesEl.children].filter((e=>e.matches(`.${a.params.slideClass}, swiper-slide`)));t&&t.length&&(a.virtual.slides=[...t],e=!0,t.forEach(((e,t)=>{e.setAttribute("data-swiper-slide-index",t),a.virtual.cache[t]=e,e.remove()})))}e||(a.virtual.slides=a.params.virtual.slides),a.classNames.push(`${a.params.containerModifierClass}virtual`),a.params.watchSlidesProgress=!0,a.originalParams.watchSlidesProgress=!0,a.params.initialSlide||c()})),s("setTranslate",(()=>{a.params.virtual.enabled&&(a.params.cssMode&&!a._immediateVirtual?(clearTimeout(t),t=setTimeout((()=>{c()}),100)):c())})),s("init update resize",(()=>{a.params.virtual.enabled&&a.params.cssMode&&Os(a.wrapperEl,"--swiper-virtual-size",`${a.virtualSize}px`)})),Object.assign(a.virtual,{appendSlide:function(e){if("object"==typeof e&&"length"in e)for(let t=0;t<e.length;t+=1)e[t]&&a.virtual.slides.push(e[t]);else a.virtual.slides.push(e);c(!0)},prependSlide:function(e){const t=a.activeIndex;let r=t+1,s=1;if(Array.isArray(e)){for(let t=0;t<e.length;t+=1)e[t]&&a.virtual.slides.unshift(e[t]);r=t+e.length,s=e.length}else a.virtual.slides.unshift(e);if(a.params.virtual.cache){const e=a.virtual.cache,t={};Object.keys(e).forEach((a=>{const r=e[a],o=r.getAttribute("data-swiper-slide-index");o&&r.setAttribute("data-swiper-slide-index",parseInt(o,10)+s),t[parseInt(a,10)+s]=r})),a.virtual.cache=t}c(!0),a.slideTo(r,0)},removeSlide:function(e){if(null==e)return;let t=a.activeIndex;if(Array.isArray(e))for(let r=e.length-1;r>=0;r-=1)a.virtual.slides.splice(e[r],1),a.params.virtual.cache&&delete a.virtual.cache[e[r]],e[r]<t&&(t-=1),t=Math.max(t,0);else a.virtual.slides.splice(e,1),a.params.virtual.cache&&delete a.virtual.cache[e],e<t&&(t-=1),t=Math.max(t,0);c(!0),a.slideTo(t,0)},removeAllSlides:function(){a.virtual.slides=[],a.params.virtual.cache&&(a.virtual.cache={}),c(!0),a.slideTo(0,0)},update:c})},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;const o=Es(),n=$s();function i(e){if(!t.enabled)return;const{rtlTranslate:a}=t;let r=e;r.originalEvent&&(r=r.originalEvent);const i=r.keyCode||r.charCode,l=t.params.keyboard.pageUpDown,c=l&&33===i,p=l&&34===i,d=37===i,u=39===i,h=38===i,m=40===i;if(!t.allowSlideNext&&(t.isHorizontal()&&u||t.isVertical()&&m||p))return!1;if(!t.allowSlidePrev&&(t.isHorizontal()&&d||t.isVertical()&&h||c))return!1;if(!(r.shiftKey||r.altKey||r.ctrlKey||r.metaKey||o.activeElement&&o.activeElement.nodeName&&("input"===o.activeElement.nodeName.toLowerCase()||"textarea"===o.activeElement.nodeName.toLowerCase()))){if(t.params.keyboard.onlyInViewport&&(c||p||d||u||h||m)){let e=!1;if(zs(t.el,`.${t.params.slideClass}, swiper-slide`).length>0&&0===zs(t.el,`.${t.params.slideActiveClass}`).length)return;const r=t.el,s=r.clientWidth,o=r.clientHeight,i=n.innerWidth,l=n.innerHeight,c=As(r);a&&(c.left-=r.scrollLeft);const p=[[c.left,c.top],[c.left+s,c.top],[c.left,c.top+o],[c.left+s,c.top+o]];for(let t=0;t<p.length;t+=1){const a=p[t];if(a[0]>=0&&a[0]<=i&&a[1]>=0&&a[1]<=l){if(0===a[0]&&0===a[1])continue;e=!0}}if(!e)return}t.isHorizontal()?((c||p||d||u)&&(r.preventDefault?r.preventDefault():r.returnValue=!1),((p||u)&&!a||(c||d)&&a)&&t.slideNext(),((c||d)&&!a||(p||u)&&a)&&t.slidePrev()):((c||p||h||m)&&(r.preventDefault?r.preventDefault():r.returnValue=!1),(p||m)&&t.slideNext(),(c||h)&&t.slidePrev()),s("keyPress",i)}}function l(){t.keyboard.enabled||(o.addEventListener("keydown",i),t.keyboard.enabled=!0)}function c(){t.keyboard.enabled&&(o.removeEventListener("keydown",i),t.keyboard.enabled=!1)}t.keyboard={enabled:!1},a({keyboard:{enabled:!1,onlyInViewport:!0,pageUpDown:!0}}),r("init",(()=>{t.params.keyboard.enabled&&l()})),r("destroy",(()=>{t.keyboard.enabled&&c()})),Object.assign(t.keyboard,{enable:l,disable:c})},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;const o=$s();let n;a({mousewheel:{enabled:!1,releaseOnEdges:!1,invert:!1,forceToAxis:!1,sensitivity:1,eventsTarget:"container",thresholdDelta:null,thresholdTime:null,noMousewheelClass:"swiper-no-mousewheel"}}),t.mousewheel={enabled:!1};let i,l=Ts();const c=[];function p(){t.enabled&&(t.mouseEntered=!0)}function d(){t.enabled&&(t.mouseEntered=!1)}function u(e){return!(t.params.mousewheel.thresholdDelta&&e.delta<t.params.mousewheel.thresholdDelta)&&(!(t.params.mousewheel.thresholdTime&&Ts()-l<t.params.mousewheel.thresholdTime)&&(e.delta>=6&&Ts()-l<60||(e.direction<0?t.isEnd&&!t.params.loop||t.animating||(t.slideNext(),s("scroll",e.raw)):t.isBeginning&&!t.params.loop||t.animating||(t.slidePrev(),s("scroll",e.raw)),l=(new o.Date).getTime(),!1)))}function h(e){let a=e,r=!0;if(!t.enabled)return;if(e.target.closest(`.${t.params.mousewheel.noMousewheelClass}`))return;const o=t.params.mousewheel;t.params.cssMode&&a.preventDefault();let l=t.el;"container"!==t.params.mousewheel.eventsTarget&&(l=document.querySelector(t.params.mousewheel.eventsTarget));const p=l&&l.contains(a.target);if(!t.mouseEntered&&!p&&!o.releaseOnEdges)return!0;a.originalEvent&&(a=a.originalEvent);let d=0;const h=t.rtlTranslate?-1:1,m=function(e){let t=0,a=0,r=0,s=0;return"detail"in e&&(a=e.detail),"wheelDelta"in e&&(a=-e.wheelDelta/120),"wheelDeltaY"in e&&(a=-e.wheelDeltaY/120),"wheelDeltaX"in e&&(t=-e.wheelDeltaX/120),"axis"in e&&e.axis===e.HORIZONTAL_AXIS&&(t=a,a=0),r=10*t,s=10*a,"deltaY"in e&&(s=e.deltaY),"deltaX"in e&&(r=e.deltaX),e.shiftKey&&!r&&(r=s,s=0),(r||s)&&e.deltaMode&&(1===e.deltaMode?(r*=40,s*=40):(r*=800,s*=800)),r&&!t&&(t=r<1?-1:1),s&&!a&&(a=s<1?-1:1),{spinX:t,spinY:a,pixelX:r,pixelY:s}}(a);if(o.forceToAxis)if(t.isHorizontal()){if(!(Math.abs(m.pixelX)>Math.abs(m.pixelY)))return!0;d=-m.pixelX*h}else{if(!(Math.abs(m.pixelY)>Math.abs(m.pixelX)))return!0;d=-m.pixelY}else d=Math.abs(m.pixelX)>Math.abs(m.pixelY)?-m.pixelX*h:-m.pixelY;if(0===d)return!0;o.invert&&(d=-d);let f=t.getTranslate()+d*o.sensitivity;if(f>=t.minTranslate()&&(f=t.minTranslate()),f<=t.maxTranslate()&&(f=t.maxTranslate()),r=!!t.params.loop||!(f===t.minTranslate()||f===t.maxTranslate()),r&&t.params.nested&&a.stopPropagation(),t.params.freeMode&&t.params.freeMode.enabled){const e={time:Ts(),delta:Math.abs(d),direction:Math.sign(d)},r=i&&e.time<i.time+500&&e.delta<=i.delta&&e.direction===i.direction;if(!r){i=void 0;let l=t.getTranslate()+d*o.sensitivity;const p=t.isBeginning,u=t.isEnd;if(l>=t.minTranslate()&&(l=t.minTranslate()),l<=t.maxTranslate()&&(l=t.maxTranslate()),t.setTransition(0),t.setTranslate(l),t.updateProgress(),t.updateActiveIndex(),t.updateSlidesClasses(),(!p&&t.isBeginning||!u&&t.isEnd)&&t.updateSlidesClasses(),t.params.loop&&t.loopFix({direction:e.direction<0?"next":"prev",byMousewheel:!0}),t.params.freeMode.sticky){clearTimeout(n),n=void 0,c.length>=15&&c.shift();const a=c.length?c[c.length-1]:void 0,r=c[0];if(c.push(e),a&&(e.delta>a.delta||e.direction!==a.direction))c.splice(0);else if(c.length>=15&&e.time-r.time<500&&r.delta-e.delta>=1&&e.delta<=6){const a=d>0?.8:.2;i=e,c.splice(0),n=xs((()=>{t.slideToClosest(t.params.speed,!0,void 0,a)}),0)}n||(n=xs((()=>{i=e,c.splice(0),t.slideToClosest(t.params.speed,!0,void 0,.5)}),500))}if(r||s("scroll",a),t.params.autoplay&&t.params.autoplayDisableOnInteraction&&t.autoplay.stop(),o.releaseOnEdges&&(l===t.minTranslate()||l===t.maxTranslate()))return!0}}else{const a={time:Ts(),delta:Math.abs(d),direction:Math.sign(d),raw:e};c.length>=2&&c.shift();const r=c.length?c[c.length-1]:void 0;if(c.push(a),r?(a.direction!==r.direction||a.delta>r.delta||a.time>r.time+150)&&u(a):u(a),function(e){const a=t.params.mousewheel;if(e.direction<0){if(t.isEnd&&!t.params.loop&&a.releaseOnEdges)return!0}else if(t.isBeginning&&!t.params.loop&&a.releaseOnEdges)return!0;return!1}(a))return!0}return a.preventDefault?a.preventDefault():a.returnValue=!1,!1}function m(e){let a=t.el;"container"!==t.params.mousewheel.eventsTarget&&(a=document.querySelector(t.params.mousewheel.eventsTarget)),a[e]("mouseenter",p),a[e]("mouseleave",d),a[e]("wheel",h)}function f(){return t.params.cssMode?(t.wrapperEl.removeEventListener("wheel",h),!0):!t.mousewheel.enabled&&(m("addEventListener"),t.mousewheel.enabled=!0,!0)}function g(){return t.params.cssMode?(t.wrapperEl.addEventListener(event,h),!0):!!t.mousewheel.enabled&&(m("removeEventListener"),t.mousewheel.enabled=!1,!0)}r("init",(()=>{!t.params.mousewheel.enabled&&t.params.cssMode&&g(),t.params.mousewheel.enabled&&f()})),r("destroy",(()=>{t.params.cssMode&&f(),t.mousewheel.enabled&&g()})),Object.assign(t.mousewheel,{enable:f,disable:g})},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;a({navigation:{nextEl:null,prevEl:null,hideOnClick:!1,disabledClass:"swiper-button-disabled",hiddenClass:"swiper-button-hidden",lockClass:"swiper-button-lock",navigationDisabledClass:"swiper-navigation-disabled"}}),t.navigation={nextEl:null,prevEl:null};const o=e=>(Array.isArray(e)?e:[e]).filter((e=>!!e));function n(e){let a;return e&&"string"==typeof e&&t.isElement&&(a=t.el.querySelector(e),a)?a:(e&&("string"==typeof e&&(a=[...document.querySelectorAll(e)]),t.params.uniqueNavElements&&"string"==typeof e&&a.length>1&&1===t.el.querySelectorAll(e).length&&(a=t.el.querySelector(e))),e&&!a?e:a)}function i(e,a){const r=t.params.navigation;(e=o(e)).forEach((e=>{e&&(e.classList[a?"add":"remove"](...r.disabledClass.split(" ")),"BUTTON"===e.tagName&&(e.disabled=a),t.params.watchOverflow&&t.enabled&&e.classList[t.isLocked?"add":"remove"](r.lockClass))}))}function l(){const{nextEl:e,prevEl:a}=t.navigation;if(t.params.loop)return i(a,!1),void i(e,!1);i(a,t.isBeginning&&!t.params.rewind),i(e,t.isEnd&&!t.params.rewind)}function c(e){e.preventDefault(),(!t.isBeginning||t.params.loop||t.params.rewind)&&(t.slidePrev(),s("navigationPrev"))}function p(e){e.preventDefault(),(!t.isEnd||t.params.loop||t.params.rewind)&&(t.slideNext(),s("navigationNext"))}function d(){const e=t.params.navigation;if(t.params.navigation=yo(t,t.originalParams.navigation,t.params.navigation,{nextEl:"swiper-button-next",prevEl:"swiper-button-prev"}),!e.nextEl&&!e.prevEl)return;let a=n(e.nextEl),r=n(e.prevEl);Object.assign(t.navigation,{nextEl:a,prevEl:r}),a=o(a),r=o(r);const s=(a,r)=>{a&&a.addEventListener("click","next"===r?p:c),!t.enabled&&a&&a.classList.add(...e.lockClass.split(" "))};a.forEach((e=>s(e,"next"))),r.forEach((e=>s(e,"prev")))}function u(){let{nextEl:e,prevEl:a}=t.navigation;e=o(e),a=o(a);const r=(e,a)=>{e.removeEventListener("click","next"===a?p:c),e.classList.remove(...t.params.navigation.disabledClass.split(" "))};e.forEach((e=>r(e,"next"))),a.forEach((e=>r(e,"prev")))}r("init",(()=>{!1===t.params.navigation.enabled?h():(d(),l())})),r("toEdge fromEdge lock unlock",(()=>{l()})),r("destroy",(()=>{u()})),r("enable disable",(()=>{let{nextEl:e,prevEl:a}=t.navigation;e=o(e),a=o(a),[...e,...a].filter((e=>!!e)).forEach((e=>e.classList[t.enabled?"remove":"add"](t.params.navigation.lockClass)))})),r("click",((e,a)=>{let{nextEl:r,prevEl:n}=t.navigation;r=o(r),n=o(n);const i=a.target;if(t.params.navigation.hideOnClick&&!n.includes(i)&&!r.includes(i)){if(t.pagination&&t.params.pagination&&t.params.pagination.clickable&&(t.pagination.el===i||t.pagination.el.contains(i)))return;let e;r.length?e=r[0].classList.contains(t.params.navigation.hiddenClass):n.length&&(e=n[0].classList.contains(t.params.navigation.hiddenClass)),s(!0===e?"navigationShow":"navigationHide"),[...r,...n].filter((e=>!!e)).forEach((e=>e.classList.toggle(t.params.navigation.hiddenClass)))}}));const h=()=>{t.el.classList.add(...t.params.navigation.navigationDisabledClass.split(" ")),u()};Object.assign(t.navigation,{enable:()=>{t.el.classList.remove(...t.params.navigation.navigationDisabledClass.split(" ")),d(),l()},disable:h,update:l,init:d,destroy:u})},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;const o="swiper-pagination";let n;a({pagination:{el:null,bulletElement:"span",clickable:!1,hideOnClick:!1,renderBullet:null,renderProgressbar:null,renderFraction:null,renderCustom:null,progressbarOpposite:!1,type:"bullets",dynamicBullets:!1,dynamicMainBullets:1,formatFractionCurrent:e=>e,formatFractionTotal:e=>e,bulletClass:`${o}-bullet`,bulletActiveClass:`${o}-bullet-active`,modifierClass:`${o}-`,currentClass:`${o}-current`,totalClass:`${o}-total`,hiddenClass:`${o}-hidden`,progressbarFillClass:`${o}-progressbar-fill`,progressbarOppositeClass:`${o}-progressbar-opposite`,clickableClass:`${o}-clickable`,lockClass:`${o}-lock`,horizontalClass:`${o}-horizontal`,verticalClass:`${o}-vertical`,paginationDisabledClass:`${o}-disabled`}}),t.pagination={el:null,bullets:[]};let i=0;const l=e=>(Array.isArray(e)?e:[e]).filter((e=>!!e));function c(){return!t.params.pagination.el||!t.pagination.el||Array.isArray(t.pagination.el)&&0===t.pagination.el.length}function p(e,a){const{bulletActiveClass:r}=t.params.pagination;e&&(e=e[("prev"===a?"previous":"next")+"ElementSibling"])&&(e.classList.add(`${r}-${a}`),(e=e[("prev"===a?"previous":"next")+"ElementSibling"])&&e.classList.add(`${r}-${a}-${a}`))}function d(e){const a=e.target.closest(Co(t.params.pagination.bulletClass));if(!a)return;e.preventDefault();const r=Hs(a)*t.params.slidesPerGroup;if(t.params.loop){if(t.realIndex===r)return;const e=t.realIndex,a=t.getSlideIndexByData(r),s=t.getSlideIndexByData(t.realIndex);if(a>t.slides.length-t.loopedSlides){const r=t.activeIndex;t.loopFix({direction:a>s?"next":"prev",activeSlideIndex:a,slideTo:!1});r===t.activeIndex&&t.slideToLoop(e,0,!1,!0)}t.slideToLoop(r)}else t.slideTo(r)}function u(){const e=t.rtl,a=t.params.pagination;if(c())return;let r,o,d=t.pagination.el;d=l(d);const u=t.virtual&&t.params.virtual.enabled?t.virtual.slides.length:t.slides.length,h=t.params.loop?Math.ceil(u/t.params.slidesPerGroup):t.snapGrid.length;if(t.params.loop?(o=t.previousRealIndex||0,r=t.params.slidesPerGroup>1?Math.floor(t.realIndex/t.params.slidesPerGroup):t.realIndex):void 0!==t.snapIndex?(r=t.snapIndex,o=t.previousSnapIndex):(o=t.previousIndex||0,r=t.activeIndex||0),"bullets"===a.type&&t.pagination.bullets&&t.pagination.bullets.length>0){const s=t.pagination.bullets;let l,c,u;if(a.dynamicBullets&&(n=Vs(s[0],t.isHorizontal()?"width":"height",!0),d.forEach((e=>{e.style[t.isHorizontal()?"width":"height"]=n*(a.dynamicMainBullets+4)+"px"})),a.dynamicMainBullets>1&&void 0!==o&&(i+=r-(o||0),i>a.dynamicMainBullets-1?i=a.dynamicMainBullets-1:i<0&&(i=0)),l=Math.max(r-i,0),c=l+(Math.min(s.length,a.dynamicMainBullets)-1),u=(c+l)/2),s.forEach((e=>{const t=[...["","-next","-next-next","-prev","-prev-prev","-main"].map((e=>`${a.bulletActiveClass}${e}`))].map((e=>"string"==typeof e&&e.includes(" ")?e.split(" "):e)).flat();e.classList.remove(...t)})),d.length>1)s.forEach((e=>{const s=Hs(e);s===r?e.classList.add(...a.bulletActiveClass.split(" ")):t.isElement&&e.setAttribute("part","bullet"),a.dynamicBullets&&(s>=l&&s<=c&&e.classList.add(...`${a.bulletActiveClass}-main`.split(" ")),s===l&&p(e,"prev"),s===c&&p(e,"next"))}));else{const e=s[r];if(e&&e.classList.add(...a.bulletActiveClass.split(" ")),t.isElement&&s.forEach(((e,t)=>{e.setAttribute("part",t===r?"bullet-active":"bullet")})),a.dynamicBullets){const e=s[l],t=s[c];for(let e=l;e<=c;e+=1)s[e]&&s[e].classList.add(...`${a.bulletActiveClass}-main`.split(" "));p(e,"prev"),p(t,"next")}}if(a.dynamicBullets){const r=Math.min(s.length,a.dynamicMainBullets+4),o=(n*r-n)/2-u*n,i=e?"right":"left";s.forEach((e=>{e.style[t.isHorizontal()?i:"top"]=`${o}px`}))}}d.forEach(((e,o)=>{if("fraction"===a.type&&(e.querySelectorAll(Co(a.currentClass)).forEach((e=>{e.textContent=a.formatFractionCurrent(r+1)})),e.querySelectorAll(Co(a.totalClass)).forEach((e=>{e.textContent=a.formatFractionTotal(h)}))),"progressbar"===a.type){let s;s=a.progressbarOpposite?t.isHorizontal()?"vertical":"horizontal":t.isHorizontal()?"horizontal":"vertical";const o=(r+1)/h;let n=1,i=1;"horizontal"===s?n=o:i=o,e.querySelectorAll(Co(a.progressbarFillClass)).forEach((e=>{e.style.transform=`translate3d(0,0,0) scaleX(${n}) scaleY(${i})`,e.style.transitionDuration=`${t.params.speed}ms`}))}"custom"===a.type&&a.renderCustom?(e.innerHTML=a.renderCustom(t,r+1,h),0===o&&s("paginationRender",e)):(0===o&&s("paginationRender",e),s("paginationUpdate",e)),t.params.watchOverflow&&t.enabled&&e.classList[t.isLocked?"add":"remove"](a.lockClass)}))}function h(){const e=t.params.pagination;if(c())return;const a=t.virtual&&t.params.virtual.enabled?t.virtual.slides.length:t.slides.length;let r=t.pagination.el;r=l(r);let o="";if("bullets"===e.type){let r=t.params.loop?Math.ceil(a/t.params.slidesPerGroup):t.snapGrid.length;t.params.freeMode&&t.params.freeMode.enabled&&r>a&&(r=a);for(let a=0;a<r;a+=1)e.renderBullet?o+=e.renderBullet.call(t,a,e.bulletClass):o+=`<${e.bulletElement} ${t.isElement?'part="bullet"':""} class="${e.bulletClass}"></${e.bulletElement}>`}"fraction"===e.type&&(o=e.renderFraction?e.renderFraction.call(t,e.currentClass,e.totalClass):`<span class="${e.currentClass}"></span> / <span class="${e.totalClass}"></span>`),"progressbar"===e.type&&(o=e.renderProgressbar?e.renderProgressbar.call(t,e.progressbarFillClass):`<span class="${e.progressbarFillClass}"></span>`),t.pagination.bullets=[],r.forEach((a=>{"custom"!==e.type&&(a.innerHTML=o||""),"bullets"===e.type&&t.pagination.bullets.push(...a.querySelectorAll(Co(e.bulletClass)))})),"custom"!==e.type&&s("paginationRender",r[0])}function m(){t.params.pagination=yo(t,t.originalParams.pagination,t.params.pagination,{el:"swiper-pagination"});const e=t.params.pagination;if(!e.el)return;let a;"string"==typeof e.el&&t.isElement&&(a=t.el.querySelector(e.el)),a||"string"!=typeof e.el||(a=[...document.querySelectorAll(e.el)]),a||(a=e.el),a&&0!==a.length&&(t.params.uniqueNavElements&&"string"==typeof e.el&&Array.isArray(a)&&a.length>1&&(a=[...t.el.querySelectorAll(e.el)],a.length>1&&(a=a.filter((e=>zs(e,".swiper")[0]===t.el))[0])),Array.isArray(a)&&1===a.length&&(a=a[0]),Object.assign(t.pagination,{el:a}),a=l(a),a.forEach((a=>{"bullets"===e.type&&e.clickable&&a.classList.add(...(e.clickableClass||"").split(" ")),a.classList.add(e.modifierClass+e.type),a.classList.add(t.isHorizontal()?e.horizontalClass:e.verticalClass),"bullets"===e.type&&e.dynamicBullets&&(a.classList.add(`${e.modifierClass}${e.type}-dynamic`),i=0,e.dynamicMainBullets<1&&(e.dynamicMainBullets=1)),"progressbar"===e.type&&e.progressbarOpposite&&a.classList.add(e.progressbarOppositeClass),e.clickable&&a.addEventListener("click",d),t.enabled||a.classList.add(e.lockClass)})))}function f(){const e=t.params.pagination;if(c())return;let a=t.pagination.el;a&&(a=l(a),a.forEach((a=>{a.classList.remove(e.hiddenClass),a.classList.remove(e.modifierClass+e.type),a.classList.remove(t.isHorizontal()?e.horizontalClass:e.verticalClass),e.clickable&&(a.classList.remove(...(e.clickableClass||"").split(" ")),a.removeEventListener("click",d))}))),t.pagination.bullets&&t.pagination.bullets.forEach((t=>t.classList.remove(...e.bulletActiveClass.split(" "))))}r("changeDirection",(()=>{if(!t.pagination||!t.pagination.el)return;const e=t.params.pagination;let{el:a}=t.pagination;a=l(a),a.forEach((a=>{a.classList.remove(e.horizontalClass,e.verticalClass),a.classList.add(t.isHorizontal()?e.horizontalClass:e.verticalClass)}))})),r("init",(()=>{!1===t.params.pagination.enabled?g():(m(),h(),u())})),r("activeIndexChange",(()=>{void 0===t.snapIndex&&u()})),r("snapIndexChange",(()=>{u()})),r("snapGridLengthChange",(()=>{h(),u()})),r("destroy",(()=>{f()})),r("enable disable",(()=>{let{el:e}=t.pagination;e&&(e=l(e),e.forEach((e=>e.classList[t.enabled?"remove":"add"](t.params.pagination.lockClass))))})),r("lock unlock",(()=>{u()})),r("click",((e,a)=>{const r=a.target,o=l(t.pagination.el);if(t.params.pagination.el&&t.params.pagination.hideOnClick&&o&&o.length>0&&!r.classList.contains(t.params.pagination.bulletClass)){if(t.navigation&&(t.navigation.nextEl&&r===t.navigation.nextEl||t.navigation.prevEl&&r===t.navigation.prevEl))return;const e=o[0].classList.contains(t.params.pagination.hiddenClass);s(!0===e?"paginationShow":"paginationHide"),o.forEach((e=>e.classList.toggle(t.params.pagination.hiddenClass)))}}));const g=()=>{t.el.classList.add(t.params.pagination.paginationDisabledClass);let{el:e}=t.pagination;e&&(e=l(e),e.forEach((e=>e.classList.add(t.params.pagination.paginationDisabledClass)))),f()};Object.assign(t.pagination,{enable:()=>{t.el.classList.remove(t.params.pagination.paginationDisabledClass);let{el:e}=t.pagination;e&&(e=l(e),e.forEach((e=>e.classList.remove(t.params.pagination.paginationDisabledClass)))),m(),h(),u()},disable:g,render:h,update:u,init:m,destroy:f})},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;const o=Es();let n,i,l,c,p=!1,d=null,u=null;function h(){if(!t.params.scrollbar.el||!t.scrollbar.el)return;const{scrollbar:e,rtlTranslate:a}=t,{dragEl:r,el:s}=e,o=t.params.scrollbar,n=t.params.loop?t.progressLoop:t.progress;let c=i,p=(l-i)*n;a?(p=-p,p>0?(c=i-p,p=0):-p+i>l&&(c=l+p)):p<0?(c=i+p,p=0):p+i>l&&(c=l-p),t.isHorizontal()?(r.style.transform=`translate3d(${p}px, 0, 0)`,r.style.width=`${c}px`):(r.style.transform=`translate3d(0px, ${p}px, 0)`,r.style.height=`${c}px`),o.hide&&(clearTimeout(d),s.style.opacity=1,d=setTimeout((()=>{s.style.opacity=0,s.style.transitionDuration="400ms"}),1e3))}function m(){if(!t.params.scrollbar.el||!t.scrollbar.el)return;const{scrollbar:e}=t,{dragEl:a,el:r}=e;a.style.width="",a.style.height="",l=t.isHorizontal()?r.offsetWidth:r.offsetHeight,c=t.size/(t.virtualSize+t.params.slidesOffsetBefore-(t.params.centeredSlides?t.snapGrid[0]:0)),i="auto"===t.params.scrollbar.dragSize?l*c:parseInt(t.params.scrollbar.dragSize,10),t.isHorizontal()?a.style.width=`${i}px`:a.style.height=`${i}px`,r.style.display=c>=1?"none":"",t.params.scrollbar.hide&&(r.style.opacity=0),t.params.watchOverflow&&t.enabled&&e.el.classList[t.isLocked?"add":"remove"](t.params.scrollbar.lockClass)}function f(e){return t.isHorizontal()?e.clientX:e.clientY}function g(e){const{scrollbar:a,rtlTranslate:r}=t,{el:s}=a;let o;o=(f(e)-As(s)[t.isHorizontal()?"left":"top"]-(null!==n?n:i/2))/(l-i),o=Math.max(Math.min(o,1),0),r&&(o=1-o);const c=t.minTranslate()+(t.maxTranslate()-t.minTranslate())*o;t.updateProgress(c),t.setTranslate(c),t.updateActiveIndex(),t.updateSlidesClasses()}function v(e){const a=t.params.scrollbar,{scrollbar:r,wrapperEl:o}=t,{el:i,dragEl:l}=r;p=!0,n=e.target===l?f(e)-e.target.getBoundingClientRect()[t.isHorizontal()?"left":"top"]:null,e.preventDefault(),e.stopPropagation(),o.style.transitionDuration="100ms",l.style.transitionDuration="100ms",g(e),clearTimeout(u),i.style.transitionDuration="0ms",a.hide&&(i.style.opacity=1),t.params.cssMode&&(t.wrapperEl.style["scroll-snap-type"]="none"),s("scrollbarDragStart",e)}function b(e){const{scrollbar:a,wrapperEl:r}=t,{el:o,dragEl:n}=a;p&&(e.preventDefault?e.preventDefault():e.returnValue=!1,g(e),r.style.transitionDuration="0ms",o.style.transitionDuration="0ms",n.style.transitionDuration="0ms",s("scrollbarDragMove",e))}function w(e){const a=t.params.scrollbar,{scrollbar:r,wrapperEl:o}=t,{el:n}=r;p&&(p=!1,t.params.cssMode&&(t.wrapperEl.style["scroll-snap-type"]="",o.style.transitionDuration=""),a.hide&&(clearTimeout(u),u=xs((()=>{n.style.opacity=0,n.style.transitionDuration="400ms"}),1e3)),s("scrollbarDragEnd",e),a.snapOnRelease&&t.slideToClosest())}function y(e){const{scrollbar:a,params:r}=t,s=a.el;if(!s)return;const n=s,i=!!r.passiveListeners&&{passive:!1,capture:!1},l=!!r.passiveListeners&&{passive:!0,capture:!1};if(!n)return;const c="on"===e?"addEventListener":"removeEventListener";n[c]("pointerdown",v,i),o[c]("pointermove",b,i),o[c]("pointerup",w,l)}function C(){const{scrollbar:e,el:a}=t;t.params.scrollbar=yo(t,t.originalParams.scrollbar,t.params.scrollbar,{el:"swiper-scrollbar"});const r=t.params.scrollbar;if(!r.el)return;let s,n;"string"==typeof r.el&&t.isElement&&(s=t.el.querySelector(r.el)),s||"string"!=typeof r.el?s||(s=r.el):s=o.querySelectorAll(r.el),t.params.uniqueNavElements&&"string"==typeof r.el&&s.length>1&&1===a.querySelectorAll(r.el).length&&(s=a.querySelector(r.el)),s.length>0&&(s=s[0]),s.classList.add(t.isHorizontal()?r.horizontalClass:r.verticalClass),s&&(n=s.querySelector(`.${t.params.scrollbar.dragClass}`),n||(n=Ds("div",t.params.scrollbar.dragClass),s.append(n))),Object.assign(e,{el:s,dragEl:n}),r.draggable&&t.params.scrollbar.el&&t.scrollbar.el&&y("on"),s&&s.classList[t.enabled?"remove":"add"](t.params.scrollbar.lockClass)}function E(){const e=t.params.scrollbar,a=t.scrollbar.el;a&&a.classList.remove(t.isHorizontal()?e.horizontalClass:e.verticalClass),t.params.scrollbar.el&&t.scrollbar.el&&y("off")}a({scrollbar:{el:null,dragSize:"auto",hide:!1,draggable:!1,snapOnRelease:!0,lockClass:"swiper-scrollbar-lock",dragClass:"swiper-scrollbar-drag",scrollbarDisabledClass:"swiper-scrollbar-disabled",horizontalClass:"swiper-scrollbar-horizontal",verticalClass:"swiper-scrollbar-vertical"}}),t.scrollbar={el:null,dragEl:null},r("init",(()=>{!1===t.params.scrollbar.enabled?k():(C(),m(),h())})),r("update resize observerUpdate lock unlock",(()=>{m()})),r("setTranslate",(()=>{h()})),r("setTransition",((e,a)=>{!function(e){t.params.scrollbar.el&&t.scrollbar.el&&(t.scrollbar.dragEl.style.transitionDuration=`${e}ms`)}(a)})),r("enable disable",(()=>{const{el:e}=t.scrollbar;e&&e.classList[t.enabled?"remove":"add"](t.params.scrollbar.lockClass)})),r("destroy",(()=>{E()}));const k=()=>{t.el.classList.add(t.params.scrollbar.scrollbarDisabledClass),t.scrollbar.el&&t.scrollbar.el.classList.add(t.params.scrollbar.scrollbarDisabledClass),E()};Object.assign(t.scrollbar,{enable:()=>{t.el.classList.remove(t.params.scrollbar.scrollbarDisabledClass),t.scrollbar.el&&t.scrollbar.el.classList.remove(t.params.scrollbar.scrollbarDisabledClass),C(),m(),h()},disable:k,updateSize:m,setTranslate:h,init:C,destroy:E})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({parallax:{enabled:!1}});const s="[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y], [data-swiper-parallax-opacity], [data-swiper-parallax-scale]",o=(e,a)=>{const{rtl:r}=t,s=r?-1:1,o=e.getAttribute("data-swiper-parallax")||"0";let n=e.getAttribute("data-swiper-parallax-x"),i=e.getAttribute("data-swiper-parallax-y");const l=e.getAttribute("data-swiper-parallax-scale"),c=e.getAttribute("data-swiper-parallax-opacity"),p=e.getAttribute("data-swiper-parallax-rotate");if(n||i?(n=n||"0",i=i||"0"):t.isHorizontal()?(n=o,i="0"):(i=o,n="0"),n=n.indexOf("%")>=0?parseInt(n,10)*a*s+"%":n*a*s+"px",i=i.indexOf("%")>=0?parseInt(i,10)*a+"%":i*a+"px",null!=c){const t=c-(c-1)*(1-Math.abs(a));e.style.opacity=t}let d=`translate3d(${n}, ${i}, 0px)`;if(null!=l){d+=` scale(${l-(l-1)*(1-Math.abs(a))})`}if(p&&null!=p){d+=` rotate(${p*a*-1}deg)`}e.style.transform=d},n=()=>{const{el:e,slides:a,progress:r,snapGrid:n,isElement:i}=t,l=Ls(e,s);t.isElement&&l.push(...Ls(t.hostEl,s)),l.forEach((e=>{o(e,r)})),a.forEach(((e,a)=>{let i=e.progress;t.params.slidesPerGroup>1&&"auto"!==t.params.slidesPerView&&(i+=Math.ceil(a/2)-r*(n.length-1)),i=Math.min(Math.max(i,-1),1),e.querySelectorAll(`${s}, [data-swiper-parallax-rotate]`).forEach((e=>{o(e,i)}))}))};r("beforeInit",(()=>{t.params.parallax.enabled&&(t.params.watchSlidesProgress=!0,t.originalParams.watchSlidesProgress=!0)})),r("init",(()=>{t.params.parallax.enabled&&n()})),r("setTranslate",(()=>{t.params.parallax.enabled&&n()})),r("setTransition",((e,a)=>{t.params.parallax.enabled&&function(e){void 0===e&&(e=t.params.speed);const{el:a,hostEl:r}=t,o=[...a.querySelectorAll(s)];t.isElement&&o.push(...r.querySelectorAll(s)),o.forEach((t=>{let a=parseInt(t.getAttribute("data-swiper-parallax-duration"),10)||e;0===e&&(a=0),t.style.transitionDuration=`${a}ms`}))}(a)}))},function(e){let{swiper:t,extendParams:a,on:r,emit:s}=e;const o=$s();a({zoom:{enabled:!1,maxRatio:3,minRatio:1,toggle:!0,containerClass:"swiper-zoom-container",zoomedSlideClass:"swiper-slide-zoomed"}}),t.zoom={enabled:!1};let n,i,l=1,c=!1;const p=[],d={originX:0,originY:0,slideEl:void 0,slideWidth:void 0,slideHeight:void 0,imageEl:void 0,imageWrapEl:void 0,maxRatio:3},u={isTouched:void 0,isMoved:void 0,currentX:void 0,currentY:void 0,minX:void 0,minY:void 0,maxX:void 0,maxY:void 0,width:void 0,height:void 0,startX:void 0,startY:void 0,touchesStart:{},touchesCurrent:{}},h={x:void 0,y:void 0,prevPositionX:void 0,prevPositionY:void 0,prevTime:void 0};let m=1;function f(){if(p.length<2)return 1;const e=p[0].pageX,t=p[0].pageY,a=p[1].pageX,r=p[1].pageY;return Math.sqrt((a-e)**2+(r-t)**2)}function g(e){const a=t.isElement?"swiper-slide":`.${t.params.slideClass}`;return!!e.target.matches(a)||t.slides.filter((t=>t.contains(e.target))).length>0}function v(e){if("mouse"===e.pointerType&&p.splice(0,p.length),!g(e))return;const a=t.params.zoom;if(n=!1,i=!1,p.push(e),!(p.length<2)){if(n=!0,d.scaleStart=f(),!d.slideEl){d.slideEl=e.target.closest(`.${t.params.slideClass}, swiper-slide`),d.slideEl||(d.slideEl=t.slides[t.activeIndex]);let r=d.slideEl.querySelector(`.${a.containerClass}`);if(r&&(r=r.querySelectorAll("picture, img, svg, canvas, .swiper-zoom-target")[0]),d.imageEl=r,d.imageWrapEl=r?zs(d.imageEl,`.${a.containerClass}`)[0]:void 0,!d.imageWrapEl)return void(d.imageEl=void 0);d.maxRatio=d.imageWrapEl.getAttribute("data-swiper-zoom")||a.maxRatio}if(d.imageEl){const[e,t]=function(){if(p.length<2)return{x:null,y:null};const e=d.imageEl.getBoundingClientRect();return[(p[0].pageX+(p[1].pageX-p[0].pageX)/2-e.x)/l,(p[0].pageY+(p[1].pageY-p[0].pageY)/2-e.y)/l]}();d.originX=e,d.originY=t,d.imageEl.style.transitionDuration="0ms"}c=!0}}function b(e){if(!g(e))return;const a=t.params.zoom,r=t.zoom,s=p.findIndex((t=>t.pointerId===e.pointerId));s>=0&&(p[s]=e),p.length<2||(i=!0,d.scaleMove=f(),d.imageEl&&(r.scale=d.scaleMove/d.scaleStart*l,r.scale>d.maxRatio&&(r.scale=d.maxRatio-1+(r.scale-d.maxRatio+1)**.5),r.scale<a.minRatio&&(r.scale=a.minRatio+1-(a.minRatio-r.scale+1)**.5),d.imageEl.style.transform=`translate3d(0,0,0) scale(${r.scale})`))}function w(e){if(!g(e))return;if("mouse"===e.pointerType&&"pointerout"===e.type)return;const a=t.params.zoom,r=t.zoom,s=p.findIndex((t=>t.pointerId===e.pointerId));s>=0&&p.splice(s,1),n&&i&&(n=!1,i=!1,d.imageEl&&(r.scale=Math.max(Math.min(r.scale,d.maxRatio),a.minRatio),d.imageEl.style.transitionDuration=`${t.params.speed}ms`,d.imageEl.style.transform=`translate3d(0,0,0) scale(${r.scale})`,l=r.scale,c=!1,r.scale>1&&d.slideEl?d.slideEl.classList.add(`${a.zoomedSlideClass}`):r.scale<=1&&d.slideEl&&d.slideEl.classList.remove(`${a.zoomedSlideClass}`),1===r.scale&&(d.originX=0,d.originY=0,d.slideEl=void 0)))}function y(e){if(!g(e)||!function(e){const a=`.${t.params.zoom.containerClass}`;return!!e.target.matches(a)||[...t.hostEl.querySelectorAll(a)].filter((t=>t.contains(e.target))).length>0}(e))return;const a=t.zoom;if(!d.imageEl)return;if(!u.isTouched||!d.slideEl)return;u.isMoved||(u.width=d.imageEl.offsetWidth,u.height=d.imageEl.offsetHeight,u.startX=Ss(d.imageWrapEl,"x")||0,u.startY=Ss(d.imageWrapEl,"y")||0,d.slideWidth=d.slideEl.offsetWidth,d.slideHeight=d.slideEl.offsetHeight,d.imageWrapEl.style.transitionDuration="0ms");const r=u.width*a.scale,s=u.height*a.scale;if(r<d.slideWidth&&s<d.slideHeight)return;u.minX=Math.min(d.slideWidth/2-r/2,0),u.maxX=-u.minX,u.minY=Math.min(d.slideHeight/2-s/2,0),u.maxY=-u.minY,u.touchesCurrent.x=p.length>0?p[0].pageX:e.pageX,u.touchesCurrent.y=p.length>0?p[0].pageY:e.pageY;if(Math.max(Math.abs(u.touchesCurrent.x-u.touchesStart.x),Math.abs(u.touchesCurrent.y-u.touchesStart.y))>5&&(t.allowClick=!1),!u.isMoved&&!c){if(t.isHorizontal()&&(Math.floor(u.minX)===Math.floor(u.startX)&&u.touchesCurrent.x<u.touchesStart.x||Math.floor(u.maxX)===Math.floor(u.startX)&&u.touchesCurrent.x>u.touchesStart.x))return void(u.isTouched=!1);if(!t.isHorizontal()&&(Math.floor(u.minY)===Math.floor(u.startY)&&u.touchesCurrent.y<u.touchesStart.y||Math.floor(u.maxY)===Math.floor(u.startY)&&u.touchesCurrent.y>u.touchesStart.y))return void(u.isTouched=!1)}e.cancelable&&e.preventDefault(),e.stopPropagation(),u.isMoved=!0;const o=(a.scale-l)/(d.maxRatio-t.params.zoom.minRatio),{originX:n,originY:i}=d;u.currentX=u.touchesCurrent.x-u.touchesStart.x+u.startX+o*(u.width-2*n),u.currentY=u.touchesCurrent.y-u.touchesStart.y+u.startY+o*(u.height-2*i),u.currentX<u.minX&&(u.currentX=u.minX+1-(u.minX-u.currentX+1)**.8),u.currentX>u.maxX&&(u.currentX=u.maxX-1+(u.currentX-u.maxX+1)**.8),u.currentY<u.minY&&(u.currentY=u.minY+1-(u.minY-u.currentY+1)**.8),u.currentY>u.maxY&&(u.currentY=u.maxY-1+(u.currentY-u.maxY+1)**.8),h.prevPositionX||(h.prevPositionX=u.touchesCurrent.x),h.prevPositionY||(h.prevPositionY=u.touchesCurrent.y),h.prevTime||(h.prevTime=Date.now()),h.x=(u.touchesCurrent.x-h.prevPositionX)/(Date.now()-h.prevTime)/2,h.y=(u.touchesCurrent.y-h.prevPositionY)/(Date.now()-h.prevTime)/2,Math.abs(u.touchesCurrent.x-h.prevPositionX)<2&&(h.x=0),Math.abs(u.touchesCurrent.y-h.prevPositionY)<2&&(h.y=0),h.prevPositionX=u.touchesCurrent.x,h.prevPositionY=u.touchesCurrent.y,h.prevTime=Date.now(),d.imageWrapEl.style.transform=`translate3d(${u.currentX}px, ${u.currentY}px,0)`}function C(){const e=t.zoom;d.slideEl&&t.activeIndex!==t.slides.indexOf(d.slideEl)&&(d.imageEl&&(d.imageEl.style.transform="translate3d(0,0,0) scale(1)"),d.imageWrapEl&&(d.imageWrapEl.style.transform="translate3d(0,0,0)"),d.slideEl.classList.remove(`${t.params.zoom.zoomedSlideClass}`),e.scale=1,l=1,d.slideEl=void 0,d.imageEl=void 0,d.imageWrapEl=void 0,d.originX=0,d.originY=0)}function E(e){const a=t.zoom,r=t.params.zoom;if(!d.slideEl){e&&e.target&&(d.slideEl=e.target.closest(`.${t.params.slideClass}, swiper-slide`)),d.slideEl||(t.params.virtual&&t.params.virtual.enabled&&t.virtual?d.slideEl=Ls(t.slidesEl,`.${t.params.slideActiveClass}`)[0]:d.slideEl=t.slides[t.activeIndex]);let a=d.slideEl.querySelector(`.${r.containerClass}`);a&&(a=a.querySelectorAll("picture, img, svg, canvas, .swiper-zoom-target")[0]),d.imageEl=a,d.imageWrapEl=a?zs(d.imageEl,`.${r.containerClass}`)[0]:void 0}if(!d.imageEl||!d.imageWrapEl)return;let s,n,i,c,p,h,m,f,g,v,b,w,y,C,E,k,$,x;t.params.cssMode&&(t.wrapperEl.style.overflow="hidden",t.wrapperEl.style.touchAction="none"),d.slideEl.classList.add(`${r.zoomedSlideClass}`),void 0===u.touchesStart.x&&e?(s=e.pageX,n=e.pageY):(s=u.touchesStart.x,n=u.touchesStart.y);const T="number"==typeof e?e:null;1===l&&T&&(s=void 0,n=void 0),a.scale=T||d.imageWrapEl.getAttribute("data-swiper-zoom")||r.maxRatio,l=T||d.imageWrapEl.getAttribute("data-swiper-zoom")||r.maxRatio,!e||1===l&&T?(m=0,f=0):($=d.slideEl.offsetWidth,x=d.slideEl.offsetHeight,i=As(d.slideEl).left+o.scrollX,c=As(d.slideEl).top+o.scrollY,p=i+$/2-s,h=c+x/2-n,g=d.imageEl.offsetWidth,v=d.imageEl.offsetHeight,b=g*a.scale,w=v*a.scale,y=Math.min($/2-b/2,0),C=Math.min(x/2-w/2,0),E=-y,k=-C,m=p*a.scale,f=h*a.scale,m<y&&(m=y),m>E&&(m=E),f<C&&(f=C),f>k&&(f=k)),T&&1===a.scale&&(d.originX=0,d.originY=0),d.imageWrapEl.style.transitionDuration="300ms",d.imageWrapEl.style.transform=`translate3d(${m}px, ${f}px,0)`,d.imageEl.style.transitionDuration="300ms",d.imageEl.style.transform=`translate3d(0,0,0) scale(${a.scale})`}function k(){const e=t.zoom,a=t.params.zoom;if(!d.slideEl){t.params.virtual&&t.params.virtual.enabled&&t.virtual?d.slideEl=Ls(t.slidesEl,`.${t.params.slideActiveClass}`)[0]:d.slideEl=t.slides[t.activeIndex];let e=d.slideEl.querySelector(`.${a.containerClass}`);e&&(e=e.querySelectorAll("picture, img, svg, canvas, .swiper-zoom-target")[0]),d.imageEl=e,d.imageWrapEl=e?zs(d.imageEl,`.${a.containerClass}`)[0]:void 0}d.imageEl&&d.imageWrapEl&&(t.params.cssMode&&(t.wrapperEl.style.overflow="",t.wrapperEl.style.touchAction=""),e.scale=1,l=1,d.imageWrapEl.style.transitionDuration="300ms",d.imageWrapEl.style.transform="translate3d(0,0,0)",d.imageEl.style.transitionDuration="300ms",d.imageEl.style.transform="translate3d(0,0,0) scale(1)",d.slideEl.classList.remove(`${a.zoomedSlideClass}`),d.slideEl=void 0,d.originX=0,d.originY=0)}function $(e){const a=t.zoom;a.scale&&1!==a.scale?k():E(e)}function x(){return{passiveListener:!!t.params.passiveListeners&&{passive:!0,capture:!1},activeListenerWithCapture:!t.params.passiveListeners||{passive:!1,capture:!0}}}function T(){const e=t.zoom;if(e.enabled)return;e.enabled=!0;const{passiveListener:a,activeListenerWithCapture:r}=x();t.wrapperEl.addEventListener("pointerdown",v,a),t.wrapperEl.addEventListener("pointermove",b,r),["pointerup","pointercancel","pointerout"].forEach((e=>{t.wrapperEl.addEventListener(e,w,a)})),t.wrapperEl.addEventListener("pointermove",y,r)}function S(){const e=t.zoom;if(!e.enabled)return;e.enabled=!1;const{passiveListener:a,activeListenerWithCapture:r}=x();t.wrapperEl.removeEventListener("pointerdown",v,a),t.wrapperEl.removeEventListener("pointermove",b,r),["pointerup","pointercancel","pointerout"].forEach((e=>{t.wrapperEl.removeEventListener(e,w,a)})),t.wrapperEl.removeEventListener("pointermove",y,r)}Object.defineProperty(t.zoom,"scale",{get:()=>m,set(e){if(m!==e){const t=d.imageEl,a=d.slideEl;s("zoomChange",e,t,a)}m=e}}),r("init",(()=>{t.params.zoom.enabled&&T()})),r("destroy",(()=>{S()})),r("touchStart",((e,a)=>{t.zoom.enabled&&function(e){const a=t.device;if(!d.imageEl)return;if(u.isTouched)return;a.android&&e.cancelable&&e.preventDefault(),u.isTouched=!0;const r=p.length>0?p[0]:e;u.touchesStart.x=r.pageX,u.touchesStart.y=r.pageY}(a)})),r("touchEnd",((e,a)=>{t.zoom.enabled&&function(){const e=t.zoom;if(!d.imageEl)return;if(!u.isTouched||!u.isMoved)return u.isTouched=!1,void(u.isMoved=!1);u.isTouched=!1,u.isMoved=!1;let a=300,r=300;const s=h.x*a,o=u.currentX+s,n=h.y*r,i=u.currentY+n;0!==h.x&&(a=Math.abs((o-u.currentX)/h.x)),0!==h.y&&(r=Math.abs((i-u.currentY)/h.y));const l=Math.max(a,r);u.currentX=o,u.currentY=i;const c=u.width*e.scale,p=u.height*e.scale;u.minX=Math.min(d.slideWidth/2-c/2,0),u.maxX=-u.minX,u.minY=Math.min(d.slideHeight/2-p/2,0),u.maxY=-u.minY,u.currentX=Math.max(Math.min(u.currentX,u.maxX),u.minX),u.currentY=Math.max(Math.min(u.currentY,u.maxY),u.minY),d.imageWrapEl.style.transitionDuration=`${l}ms`,d.imageWrapEl.style.transform=`translate3d(${u.currentX}px, ${u.currentY}px,0)`}()})),r("doubleTap",((e,a)=>{!t.animating&&t.params.zoom.enabled&&t.zoom.enabled&&t.params.zoom.toggle&&$(a)})),r("transitionEnd",(()=>{t.zoom.enabled&&t.params.zoom.enabled&&C()})),r("slideChange",(()=>{t.zoom.enabled&&t.params.zoom.enabled&&t.params.cssMode&&C()})),Object.assign(t.zoom,{enable:T,disable:S,in:E,out:k,toggle:$})},function(e){let{swiper:t,extendParams:a,on:r}=e;function s(e,t){const a=function(){let e,t,a;return(r,s)=>{for(t=-1,e=r.length;e-t>1;)a=e+t>>1,r[a]<=s?t=a:e=a;return e}}();let r,s;return this.x=e,this.y=t,this.lastIndex=e.length-1,this.interpolate=function(e){return e?(s=a(this.x,e),r=s-1,(e-this.x[r])*(this.y[s]-this.y[r])/(this.x[s]-this.x[r])+this.y[r]):0},this}function o(){t.controller.control&&t.controller.spline&&(t.controller.spline=void 0,delete t.controller.spline)}a({controller:{control:void 0,inverse:!1,by:"slide"}}),t.controller={control:void 0},r("beforeInit",(()=>{if("undefined"!=typeof window&&("string"==typeof t.params.controller.control||t.params.controller.control instanceof HTMLElement)){const e=document.querySelector(t.params.controller.control);if(e&&e.swiper)t.controller.control=e.swiper;else if(e){const a=r=>{t.controller.control=r.detail[0],t.update(),e.removeEventListener("init",a)};e.addEventListener("init",a)}}else t.controller.control=t.params.controller.control})),r("update",(()=>{o()})),r("resize",(()=>{o()})),r("observerUpdate",(()=>{o()})),r("setTranslate",((e,a,r)=>{t.controller.control&&!t.controller.control.destroyed&&t.controller.setTranslate(a,r)})),r("setTransition",((e,a,r)=>{t.controller.control&&!t.controller.control.destroyed&&t.controller.setTransition(a,r)})),Object.assign(t.controller,{setTranslate:function(e,a){const r=t.controller.control;let o,n;const i=t.constructor;function l(e){if(e.destroyed)return;const a=t.rtlTranslate?-t.translate:t.translate;"slide"===t.params.controller.by&&(!function(e){t.controller.spline=t.params.loop?new s(t.slidesGrid,e.slidesGrid):new s(t.snapGrid,e.snapGrid)}(e),n=-t.controller.spline.interpolate(-a)),n&&"container"!==t.params.controller.by||(o=(e.maxTranslate()-e.minTranslate())/(t.maxTranslate()-t.minTranslate()),!Number.isNaN(o)&&Number.isFinite(o)||(o=1),n=(a-t.minTranslate())*o+e.minTranslate()),t.params.controller.inverse&&(n=e.maxTranslate()-n),e.updateProgress(n),e.setTranslate(n,t),e.updateActiveIndex(),e.updateSlidesClasses()}if(Array.isArray(r))for(let e=0;e<r.length;e+=1)r[e]!==a&&r[e]instanceof i&&l(r[e]);else r instanceof i&&a!==r&&l(r)},setTransition:function(e,a){const r=t.constructor,s=t.controller.control;let o;function n(a){a.destroyed||(a.setTransition(e,t),0!==e&&(a.transitionStart(),a.params.autoHeight&&xs((()=>{a.updateAutoHeight()})),Ns(a.wrapperEl,(()=>{s&&a.transitionEnd()}))))}if(Array.isArray(s))for(o=0;o<s.length;o+=1)s[o]!==a&&s[o]instanceof r&&n(s[o]);else s instanceof r&&a!==s&&n(s)}})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({a11y:{enabled:!0,notificationClass:"swiper-notification",prevSlideMessage:"Previous slide",nextSlideMessage:"Next slide",firstSlideMessage:"This is the first slide",lastSlideMessage:"This is the last slide",paginationBulletMessage:"Go to slide {{index}}",slideLabelMessage:"{{index}} / {{slidesLength}}",containerMessage:null,containerRoleDescriptionMessage:null,itemRoleDescriptionMessage:null,slideRole:"group",id:null}}),t.a11y={clicked:!1};let s=null;function o(e){const t=s;0!==t.length&&(t.innerHTML="",t.innerHTML=e)}const n=e=>(Array.isArray(e)?e:[e]).filter((e=>!!e));function i(e){(e=n(e)).forEach((e=>{e.setAttribute("tabIndex","0")}))}function l(e){(e=n(e)).forEach((e=>{e.setAttribute("tabIndex","-1")}))}function c(e,t){(e=n(e)).forEach((e=>{e.setAttribute("role",t)}))}function p(e,t){(e=n(e)).forEach((e=>{e.setAttribute("aria-roledescription",t)}))}function d(e,t){(e=n(e)).forEach((e=>{e.setAttribute("aria-label",t)}))}function u(e){(e=n(e)).forEach((e=>{e.setAttribute("aria-disabled",!0)}))}function h(e){(e=n(e)).forEach((e=>{e.setAttribute("aria-disabled",!1)}))}function m(e){if(13!==e.keyCode&&32!==e.keyCode)return;const a=t.params.a11y,r=e.target;t.pagination&&t.pagination.el&&(r===t.pagination.el||t.pagination.el.contains(e.target))&&!e.target.matches(Co(t.params.pagination.bulletClass))||(t.navigation&&t.navigation.nextEl&&r===t.navigation.nextEl&&(t.isEnd&&!t.params.loop||t.slideNext(),t.isEnd?o(a.lastSlideMessage):o(a.nextSlideMessage)),t.navigation&&t.navigation.prevEl&&r===t.navigation.prevEl&&(t.isBeginning&&!t.params.loop||t.slidePrev(),t.isBeginning?o(a.firstSlideMessage):o(a.prevSlideMessage)),t.pagination&&r.matches(Co(t.params.pagination.bulletClass))&&r.click())}function f(){return t.pagination&&t.pagination.bullets&&t.pagination.bullets.length}function g(){return f()&&t.params.pagination.clickable}const v=(e,t,a)=>{i(e),"BUTTON"!==e.tagName&&(c(e,"button"),e.addEventListener("keydown",m)),d(e,a),function(e,t){(e=n(e)).forEach((e=>{e.setAttribute("aria-controls",t)}))}(e,t)},b=()=>{t.a11y.clicked=!0},w=()=>{requestAnimationFrame((()=>{requestAnimationFrame((()=>{t.destroyed||(t.a11y.clicked=!1)}))}))},y=e=>{if(t.a11y.clicked)return;const a=e.target.closest(`.${t.params.slideClass}, swiper-slide`);if(!a||!t.slides.includes(a))return;const r=t.slides.indexOf(a)===t.activeIndex,s=t.params.watchSlidesProgress&&t.visibleSlides&&t.visibleSlides.includes(a);r||s||e.sourceCapabilities&&e.sourceCapabilities.firesTouchEvents||(t.isHorizontal()?t.el.scrollLeft=0:t.el.scrollTop=0,t.slideTo(t.slides.indexOf(a),0))},C=()=>{const e=t.params.a11y;e.itemRoleDescriptionMessage&&p(t.slides,e.itemRoleDescriptionMessage),e.slideRole&&c(t.slides,e.slideRole);const a=t.slides.length;e.slideLabelMessage&&t.slides.forEach(((r,s)=>{const o=t.params.loop?parseInt(r.getAttribute("data-swiper-slide-index"),10):s;d(r,e.slideLabelMessage.replace(/\{\{index\}\}/,o+1).replace(/\{\{slidesLength\}\}/,a))}))},E=()=>{const e=t.params.a11y;t.el.append(s);const a=t.el;e.containerRoleDescriptionMessage&&p(a,e.containerRoleDescriptionMessage),e.containerMessage&&d(a,e.containerMessage);const r=t.wrapperEl,o=e.id||r.getAttribute("id")||`swiper-wrapper-${i=16,void 0===i&&(i=16),"x".repeat(i).replace(/x/g,(()=>Math.round(16*Math.random()).toString(16)))}`;var i;const l=t.params.autoplay&&t.params.autoplay.enabled?"off":"polite";!function(e,t){(e=n(e)).forEach((e=>{e.setAttribute("id",t)}))}(r,o),function(e,t){(e=n(e)).forEach((e=>{e.setAttribute("aria-live",t)}))}(r,l),C();let{nextEl:c,prevEl:u}=t.navigation?t.navigation:{};if(c=n(c),u=n(u),c&&c.forEach((t=>v(t,o,e.nextSlideMessage))),u&&u.forEach((t=>v(t,o,e.prevSlideMessage))),g()){(Array.isArray(t.pagination.el)?t.pagination.el:[t.pagination.el]).forEach((e=>{e.addEventListener("keydown",m)}))}t.el.addEventListener("focus",y,!0),t.el.addEventListener("pointerdown",b,!0),t.el.addEventListener("pointerup",w,!0)};r("beforeInit",(()=>{s=Ds("span",t.params.a11y.notificationClass),s.setAttribute("aria-live","assertive"),s.setAttribute("aria-atomic","true")})),r("afterInit",(()=>{t.params.a11y.enabled&&E()})),r("slidesLengthChange snapGridLengthChange slidesGridLengthChange",(()=>{t.params.a11y.enabled&&C()})),r("fromEdge toEdge afterInit lock unlock",(()=>{t.params.a11y.enabled&&function(){if(t.params.loop||t.params.rewind||!t.navigation)return;const{nextEl:e,prevEl:a}=t.navigation;a&&(t.isBeginning?(u(a),l(a)):(h(a),i(a))),e&&(t.isEnd?(u(e),l(e)):(h(e),i(e)))}()})),r("paginationUpdate",(()=>{t.params.a11y.enabled&&function(){const e=t.params.a11y;f()&&t.pagination.bullets.forEach((a=>{t.params.pagination.clickable&&(i(a),t.params.pagination.renderBullet||(c(a,"button"),d(a,e.paginationBulletMessage.replace(/\{\{index\}\}/,Hs(a)+1)))),a.matches(Co(t.params.pagination.bulletActiveClass))?a.setAttribute("aria-current","true"):a.removeAttribute("aria-current")}))}()})),r("destroy",(()=>{t.params.a11y.enabled&&function(){s&&s.remove();let{nextEl:e,prevEl:a}=t.navigation?t.navigation:{};e=n(e),a=n(a),e&&e.forEach((e=>e.removeEventListener("keydown",m))),a&&a.forEach((e=>e.removeEventListener("keydown",m))),g()&&(Array.isArray(t.pagination.el)?t.pagination.el:[t.pagination.el]).forEach((e=>{e.removeEventListener("keydown",m)}));t.el.removeEventListener("focus",y,!0),t.el.removeEventListener("pointerdown",b,!0),t.el.removeEventListener("pointerup",w,!0)}()}))},function(e){let{swiper:t,extendParams:a,on:r}=e;a({history:{enabled:!1,root:"",replaceState:!1,key:"slides",keepQuery:!1}});let s=!1,o={};const n=e=>e.toString().replace(/\s+/g,"-").replace(/[^\w-]+/g,"").replace(/--+/g,"-").replace(/^-+/,"").replace(/-+$/,""),i=e=>{const t=$s();let a;a=e?new URL(e):t.location;const r=a.pathname.slice(1).split("/").filter((e=>""!==e)),s=r.length;return{key:r[s-2],value:r[s-1]}},l=(e,a)=>{const r=$s();if(!s||!t.params.history.enabled)return;let o;o=t.params.url?new URL(t.params.url):r.location;const i=t.slides[a];let l=n(i.getAttribute("data-history"));if(t.params.history.root.length>0){let a=t.params.history.root;"/"===a[a.length-1]&&(a=a.slice(0,a.length-1)),l=`${a}/${e?`${e}/`:""}${l}`}else o.pathname.includes(e)||(l=`${e?`${e}/`:""}${l}`);t.params.history.keepQuery&&(l+=o.search);const c=r.history.state;c&&c.value===l||(t.params.history.replaceState?r.history.replaceState({value:l},null,l):r.history.pushState({value:l},null,l))},c=(e,a,r)=>{if(a)for(let s=0,o=t.slides.length;s<o;s+=1){const o=t.slides[s];if(n(o.getAttribute("data-history"))===a){const a=t.getSlideIndex(o);t.slideTo(a,e,r)}}else t.slideTo(0,e,r)},p=()=>{o=i(t.params.url),c(t.params.speed,o.value,!1)};r("init",(()=>{t.params.history.enabled&&(()=>{const e=$s();if(t.params.history){if(!e.history||!e.history.pushState)return t.params.history.enabled=!1,void(t.params.hashNavigation.enabled=!0);s=!0,o=i(t.params.url),o.key||o.value?(c(0,o.value,t.params.runCallbacksOnInit),t.params.history.replaceState||e.addEventListener("popstate",p)):t.params.history.replaceState||e.addEventListener("popstate",p)}})()})),r("destroy",(()=>{t.params.history.enabled&&(()=>{const e=$s();t.params.history.replaceState||e.removeEventListener("popstate",p)})()})),r("transitionEnd _freeModeNoMomentumRelease",(()=>{s&&l(t.params.history.key,t.activeIndex)})),r("slideChange",(()=>{s&&t.params.cssMode&&l(t.params.history.key,t.activeIndex)}))},function(e){let{swiper:t,extendParams:a,emit:r,on:s}=e,o=!1;const n=Es(),i=$s();a({hashNavigation:{enabled:!1,replaceState:!1,watchState:!1,getSlideIndex(e,a){if(t.virtual&&t.params.virtual.enabled){const e=t.slides.filter((e=>e.getAttribute("data-hash")===a))[0];if(!e)return 0;return parseInt(e.getAttribute("data-swiper-slide-index"),10)}return t.getSlideIndex(Ls(t.slidesEl,`.${t.params.slideClass}[data-hash="${a}"], swiper-slide[data-hash="${a}"]`)[0])}}});const l=()=>{r("hashChange");const e=n.location.hash.replace("#",""),a=t.virtual&&t.params.virtual.enabled?t.slidesEl.querySelector(`[data-swiper-slide-index="${t.activeIndex}"]`):t.slides[t.activeIndex];if(e!==(a?a.getAttribute("data-hash"):"")){const a=t.params.hashNavigation.getSlideIndex(t,e);if(void 0===a||Number.isNaN(a))return;t.slideTo(a)}},c=()=>{if(!o||!t.params.hashNavigation.enabled)return;const e=t.virtual&&t.params.virtual.enabled?t.slidesEl.querySelector(`[data-swiper-slide-index="${t.activeIndex}"]`):t.slides[t.activeIndex],a=e?e.getAttribute("data-hash")||e.getAttribute("data-history"):"";t.params.hashNavigation.replaceState&&i.history&&i.history.replaceState?(i.history.replaceState(null,null,`#${a}`||""),r("hashSet")):(n.location.hash=a||"",r("hashSet"))};s("init",(()=>{t.params.hashNavigation.enabled&&(()=>{if(!t.params.hashNavigation.enabled||t.params.history&&t.params.history.enabled)return;o=!0;const e=n.location.hash.replace("#","");if(e){const a=0,r=t.params.hashNavigation.getSlideIndex(t,e);t.slideTo(r||0,a,t.params.runCallbacksOnInit,!0)}t.params.hashNavigation.watchState&&i.addEventListener("hashchange",l)})()})),s("destroy",(()=>{t.params.hashNavigation.enabled&&t.params.hashNavigation.watchState&&i.removeEventListener("hashchange",l)})),s("transitionEnd _freeModeNoMomentumRelease",(()=>{o&&c()})),s("slideChange",(()=>{o&&t.params.cssMode&&c()}))},function(e){let t,a,{swiper:r,extendParams:s,on:o,emit:n,params:i}=e;r.autoplay={running:!1,paused:!1,timeLeft:0},s({autoplay:{enabled:!1,delay:3e3,waitForTransition:!0,disableOnInteraction:!0,stopOnLastSlide:!1,reverseDirection:!1,pauseOnMouseEnter:!1}});let l,c,p,d,u,h,m,f=i&&i.autoplay?i.autoplay.delay:3e3,g=i&&i.autoplay?i.autoplay.delay:3e3,v=(new Date).getTime;function b(e){r&&!r.destroyed&&r.wrapperEl&&e.target===r.wrapperEl&&(r.wrapperEl.removeEventListener("transitionend",b),$())}const w=()=>{if(r.destroyed||!r.autoplay.running)return;r.autoplay.paused?c=!0:c&&(g=l,c=!1);const e=r.autoplay.paused?l:v+g-(new Date).getTime();r.autoplay.timeLeft=e,n("autoplayTimeLeft",e,e/f),a=requestAnimationFrame((()=>{w()}))},y=e=>{if(r.destroyed||!r.autoplay.running)return;cancelAnimationFrame(a),w();let s=void 0===e?r.params.autoplay.delay:e;f=r.params.autoplay.delay,g=r.params.autoplay.delay;const o=(()=>{let e;if(e=r.virtual&&r.params.virtual.enabled?r.slides.filter((e=>e.classList.contains("swiper-slide-active")))[0]:r.slides[r.activeIndex],!e)return;return parseInt(e.getAttribute("data-swiper-autoplay"),10)})();!Number.isNaN(o)&&o>0&&void 0===e&&(s=o,f=o,g=o),l=s;const i=r.params.speed,c=()=>{r&&!r.destroyed&&(r.params.autoplay.reverseDirection?!r.isBeginning||r.params.loop||r.params.rewind?(r.slidePrev(i,!0,!0),n("autoplay")):r.params.autoplay.stopOnLastSlide||(r.slideTo(r.slides.length-1,i,!0,!0),n("autoplay")):!r.isEnd||r.params.loop||r.params.rewind?(r.slideNext(i,!0,!0),n("autoplay")):r.params.autoplay.stopOnLastSlide||(r.slideTo(0,i,!0,!0),n("autoplay")),r.params.cssMode&&(v=(new Date).getTime(),requestAnimationFrame((()=>{y()}))))};return s>0?(clearTimeout(t),t=setTimeout((()=>{c()}),s)):requestAnimationFrame((()=>{c()})),s},C=()=>{r.autoplay.running=!0,y(),n("autoplayStart")},E=()=>{r.autoplay.running=!1,clearTimeout(t),cancelAnimationFrame(a),n("autoplayStop")},k=(e,a)=>{if(r.destroyed||!r.autoplay.running)return;clearTimeout(t),e||(m=!0);const s=()=>{n("autoplayPause"),r.params.autoplay.waitForTransition?r.wrapperEl.addEventListener("transitionend",b):$()};if(r.autoplay.paused=!0,a)return h&&(l=r.params.autoplay.delay),h=!1,void s();const o=l||r.params.autoplay.delay;l=o-((new Date).getTime()-v),r.isEnd&&l<0&&!r.params.loop||(l<0&&(l=0),s())},$=()=>{r.isEnd&&l<0&&!r.params.loop||r.destroyed||!r.autoplay.running||(v=(new Date).getTime(),m?(m=!1,y(l)):y(),r.autoplay.paused=!1,n("autoplayResume"))},x=()=>{if(r.destroyed||!r.autoplay.running)return;const e=Es();"hidden"===e.visibilityState&&(m=!0,k(!0)),"visible"===e.visibilityState&&$()},T=e=>{"mouse"===e.pointerType&&(m=!0,r.animating||r.autoplay.paused||k(!0))},S=e=>{"mouse"===e.pointerType&&r.autoplay.paused&&$()};o("init",(()=>{r.params.autoplay.enabled&&(r.params.autoplay.pauseOnMouseEnter&&(r.el.addEventListener("pointerenter",T),r.el.addEventListener("pointerleave",S)),Es().addEventListener("visibilitychange",x),v=(new Date).getTime(),C())})),o("destroy",(()=>{r.el.removeEventListener("pointerenter",T),r.el.removeEventListener("pointerleave",S),Es().removeEventListener("visibilitychange",x),r.autoplay.running&&E()})),o("beforeTransitionStart",((e,t,a)=>{!r.destroyed&&r.autoplay.running&&(a||!r.params.autoplay.disableOnInteraction?k(!0,!0):E())})),o("sliderFirstMove",(()=>{!r.destroyed&&r.autoplay.running&&(r.params.autoplay.disableOnInteraction?E():(p=!0,d=!1,m=!1,u=setTimeout((()=>{m=!0,d=!0,k(!0)}),200)))})),o("touchEnd",(()=>{if(!r.destroyed&&r.autoplay.running&&p){if(clearTimeout(u),clearTimeout(t),r.params.autoplay.disableOnInteraction)return d=!1,void(p=!1);d&&r.params.cssMode&&$(),d=!1,p=!1}})),o("slideChange",(()=>{!r.destroyed&&r.autoplay.running&&(h=!0)})),Object.assign(r.autoplay,{start:C,stop:E,pause:k,resume:$})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({thumbs:{swiper:null,multipleActiveThumbs:!0,autoScrollOffset:0,slideThumbActiveClass:"swiper-slide-thumb-active",thumbsContainerClass:"swiper-thumbs"}});let s=!1,o=!1;function n(){const e=t.thumbs.swiper;if(!e||e.destroyed)return;const a=e.clickedIndex,r=e.clickedSlide;if(r&&r.classList.contains(t.params.thumbs.slideThumbActiveClass))return;if(null==a)return;let s;s=e.params.loop?parseInt(e.clickedSlide.getAttribute("data-swiper-slide-index"),10):a,t.params.loop?t.slideToLoop(s):t.slideTo(s)}function i(){const{thumbs:e}=t.params;if(s)return!1;s=!0;const a=t.constructor;if(e.swiper instanceof a)t.thumbs.swiper=e.swiper,Object.assign(t.thumbs.swiper.originalParams,{watchSlidesProgress:!0,slideToClickedSlide:!1}),Object.assign(t.thumbs.swiper.params,{watchSlidesProgress:!0,slideToClickedSlide:!1}),t.thumbs.swiper.update();else if(Ps(e.swiper)){const r=Object.assign({},e.swiper);Object.assign(r,{watchSlidesProgress:!0,slideToClickedSlide:!1}),t.thumbs.swiper=new a(r),o=!0}return t.thumbs.swiper.el.classList.add(t.params.thumbs.thumbsContainerClass),t.thumbs.swiper.on("tap",n),!0}function l(e){const a=t.thumbs.swiper;if(!a||a.destroyed)return;const r="auto"===a.params.slidesPerView?a.slidesPerViewDynamic():a.params.slidesPerView;let s=1;const o=t.params.thumbs.slideThumbActiveClass;if(t.params.slidesPerView>1&&!t.params.centeredSlides&&(s=t.params.slidesPerView),t.params.thumbs.multipleActiveThumbs||(s=1),s=Math.floor(s),a.slides.forEach((e=>e.classList.remove(o))),a.params.loop||a.params.virtual&&a.params.virtual.enabled)for(let e=0;e<s;e+=1)Ls(a.slidesEl,`[data-swiper-slide-index="${t.realIndex+e}"]`).forEach((e=>{e.classList.add(o)}));else for(let e=0;e<s;e+=1)a.slides[t.realIndex+e]&&a.slides[t.realIndex+e].classList.add(o);const n=t.params.thumbs.autoScrollOffset,i=n&&!a.params.loop;if(t.realIndex!==a.realIndex||i){const s=a.activeIndex;let o,l;if(a.params.loop){const e=a.slides.filter((e=>e.getAttribute("data-swiper-slide-index")===`${t.realIndex}`))[0];o=a.slides.indexOf(e),l=t.activeIndex>t.previousIndex?"next":"prev"}else o=t.realIndex,l=o>t.previousIndex?"next":"prev";i&&(o+="next"===l?n:-1*n),a.visibleSlidesIndexes&&a.visibleSlidesIndexes.indexOf(o)<0&&(a.params.centeredSlides?o=o>s?o-Math.floor(r/2)+1:o+Math.floor(r/2)-1:o>s&&a.params.slidesPerGroup,a.slideTo(o,e?0:void 0))}}t.thumbs={swiper:null},r("beforeInit",(()=>{const{thumbs:e}=t.params;if(e&&e.swiper)if("string"==typeof e.swiper||e.swiper instanceof HTMLElement){const a=Es(),r=()=>{const r="string"==typeof e.swiper?a.querySelector(e.swiper):e.swiper;if(r&&r.swiper)e.swiper=r.swiper,i(),l(!0);else if(r){const a=s=>{e.swiper=s.detail[0],r.removeEventListener("init",a),i(),l(!0),e.swiper.update(),t.update()};r.addEventListener("init",a)}return r},s=()=>{if(t.destroyed)return;r()||requestAnimationFrame(s)};requestAnimationFrame(s)}else i(),l(!0)})),r("slideChange update resize observerUpdate",(()=>{l()})),r("setTransition",((e,a)=>{const r=t.thumbs.swiper;r&&!r.destroyed&&r.setTransition(a)})),r("beforeDestroy",(()=>{const e=t.thumbs.swiper;e&&!e.destroyed&&o&&e.destroy()})),Object.assign(t.thumbs,{init:i,update:l})},function(e){let{swiper:t,extendParams:a,emit:r,once:s}=e;a({freeMode:{enabled:!1,momentum:!0,momentumRatio:1,momentumBounce:!0,momentumBounceRatio:1,momentumVelocityRatio:1,sticky:!1,minimumVelocity:.02}}),Object.assign(t,{freeMode:{onTouchStart:function(){if(t.params.cssMode)return;const e=t.getTranslate();t.setTranslate(e),t.setTransition(0),t.touchEventsData.velocities.length=0,t.freeMode.onTouchEnd({currentPos:t.rtl?t.translate:-t.translate})},onTouchMove:function(){if(t.params.cssMode)return;const{touchEventsData:e,touches:a}=t;0===e.velocities.length&&e.velocities.push({position:a[t.isHorizontal()?"startX":"startY"],time:e.touchStartTime}),e.velocities.push({position:a[t.isHorizontal()?"currentX":"currentY"],time:Ts()})},onTouchEnd:function(e){let{currentPos:a}=e;if(t.params.cssMode)return;const{params:o,wrapperEl:n,rtlTranslate:i,snapGrid:l,touchEventsData:c}=t,p=Ts()-c.touchStartTime;if(a<-t.minTranslate())t.slideTo(t.activeIndex);else if(a>-t.maxTranslate())t.slides.length<l.length?t.slideTo(l.length-1):t.slideTo(t.slides.length-1);else{if(o.freeMode.momentum){if(c.velocities.length>1){const e=c.velocities.pop(),a=c.velocities.pop(),r=e.position-a.position,s=e.time-a.time;t.velocity=r/s,t.velocity/=2,Math.abs(t.velocity)<o.freeMode.minimumVelocity&&(t.velocity=0),(s>150||Ts()-e.time>300)&&(t.velocity=0)}else t.velocity=0;t.velocity*=o.freeMode.momentumVelocityRatio,c.velocities.length=0;let e=1e3*o.freeMode.momentumRatio;const a=t.velocity*e;let p=t.translate+a;i&&(p=-p);let d,u=!1;const h=20*Math.abs(t.velocity)*o.freeMode.momentumBounceRatio;let m;if(p<t.maxTranslate())o.freeMode.momentumBounce?(p+t.maxTranslate()<-h&&(p=t.maxTranslate()-h),d=t.maxTranslate(),u=!0,c.allowMomentumBounce=!0):p=t.maxTranslate(),o.loop&&o.centeredSlides&&(m=!0);else if(p>t.minTranslate())o.freeMode.momentumBounce?(p-t.minTranslate()>h&&(p=t.minTranslate()+h),d=t.minTranslate(),u=!0,c.allowMomentumBounce=!0):p=t.minTranslate(),o.loop&&o.centeredSlides&&(m=!0);else if(o.freeMode.sticky){let e;for(let t=0;t<l.length;t+=1)if(l[t]>-p){e=t;break}p=Math.abs(l[e]-p)<Math.abs(l[e-1]-p)||"next"===t.swipeDirection?l[e]:l[e-1],p=-p}if(m&&s("transitionEnd",(()=>{t.loopFix()})),0!==t.velocity){if(e=i?Math.abs((-p-t.translate)/t.velocity):Math.abs((p-t.translate)/t.velocity),o.freeMode.sticky){const a=Math.abs((i?-p:p)-t.translate),r=t.slidesSizesGrid[t.activeIndex];e=a<r?o.speed:a<2*r?1.5*o.speed:2.5*o.speed}}else if(o.freeMode.sticky)return void t.slideToClosest();o.freeMode.momentumBounce&&u?(t.updateProgress(d),t.setTransition(e),t.setTranslate(p),t.transitionStart(!0,t.swipeDirection),t.animating=!0,Ns(n,(()=>{t&&!t.destroyed&&c.allowMomentumBounce&&(r("momentumBounce"),t.setTransition(o.speed),setTimeout((()=>{t.setTranslate(d),Ns(n,(()=>{t&&!t.destroyed&&t.transitionEnd()}))}),0))}))):t.velocity?(r("_freeModeNoMomentumRelease"),t.updateProgress(p),t.setTransition(e),t.setTranslate(p),t.transitionStart(!0,t.swipeDirection),t.animating||(t.animating=!0,Ns(n,(()=>{t&&!t.destroyed&&t.transitionEnd()})))):t.updateProgress(p),t.updateActiveIndex(),t.updateSlidesClasses()}else{if(o.freeMode.sticky)return void t.slideToClosest();o.freeMode&&r("_freeModeNoMomentumRelease")}(!o.freeMode.momentum||p>=o.longSwipesMs)&&(t.updateProgress(),t.updateActiveIndex(),t.updateSlidesClasses())}}}})},function(e){let t,a,r,{swiper:s,extendParams:o}=e;o({grid:{rows:1,fill:"column"}});const n=()=>{let e=s.params.spaceBetween;return"string"==typeof e&&e.indexOf("%")>=0?e=parseFloat(e.replace("%",""))/100*s.size:"string"==typeof e&&(e=parseFloat(e)),e};s.grid={initSlides:e=>{const{slidesPerView:o}=s.params,{rows:n,fill:i}=s.params.grid;r=Math.floor(e/n),t=Math.floor(e/n)===e/n?e:Math.ceil(e/n)*n,"auto"!==o&&"row"===i&&(t=Math.max(t,o*n)),a=t/n},updateSlide:(e,o,i,l)=>{const{slidesPerGroup:c}=s.params,p=n(),{rows:d,fill:u}=s.params.grid;let h,m,f;if("row"===u&&c>1){const a=Math.floor(e/(c*d)),r=e-d*c*a,s=0===a?c:Math.min(Math.ceil((i-a*d*c)/d),c);f=Math.floor(r/s),m=r-f*s+a*c,h=m+f*t/d,o.style.order=h}else"column"===u?(m=Math.floor(e/d),f=e-m*d,(m>r||m===r&&f===d-1)&&(f+=1,f>=d&&(f=0,m+=1))):(f=Math.floor(e/a),m=e-f*a);o.row=f,o.column=m,o.style[l("margin-top")]=0!==f?p&&`${p}px`:""},updateWrapperSize:(e,a,r)=>{const{centeredSlides:o,roundLengths:i}=s.params,l=n(),{rows:c}=s.params.grid;if(s.virtualSize=(e+l)*t,s.virtualSize=Math.ceil(s.virtualSize/c)-l,s.wrapperEl.style[r("width")]=`${s.virtualSize+l}px`,o){const e=[];for(let t=0;t<a.length;t+=1){let r=a[t];i&&(r=Math.floor(r)),a[t]<s.virtualSize+a[0]&&e.push(r)}a.splice(0,a.length),a.push(...e)}}}},function(e){let{swiper:t}=e;Object.assign(t,{appendSlide:Eo.bind(t),prependSlide:ko.bind(t),addSlide:$o.bind(t),removeSlide:xo.bind(t),removeAllSlides:To.bind(t)})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({fadeEffect:{crossFade:!1}}),So({effect:"fade",swiper:t,on:r,setTranslate:()=>{const{slides:e}=t;t.params.fadeEffect;for(let a=0;a<e.length;a+=1){const e=t.slides[a];let r=-e.swiperSlideOffset;t.params.virtualTranslate||(r-=t.translate);let s=0;t.isHorizontal()||(s=r,r=0);const o=t.params.fadeEffect.crossFade?Math.max(1-Math.abs(e.progress),0):1+Math.min(Math.max(e.progress,-1),0),n=Po(0,e);n.style.opacity=o,n.style.transform=`translate3d(${r}px, ${s}px, 0px)`}},setTransition:e=>{const a=t.slides.map((e=>Bs(e)));a.forEach((t=>{t.style.transitionDuration=`${e}ms`})),Mo({swiper:t,duration:e,transformElements:a,allSlides:!0})},overwriteParams:()=>({slidesPerView:1,slidesPerGroup:1,watchSlidesProgress:!0,spaceBetween:0,virtualTranslate:!t.params.cssMode})})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({cubeEffect:{slideShadows:!0,shadow:!0,shadowOffset:20,shadowScale:.94}});const s=(e,t,a)=>{let r=a?e.querySelector(".swiper-slide-shadow-left"):e.querySelector(".swiper-slide-shadow-top"),s=a?e.querySelector(".swiper-slide-shadow-right"):e.querySelector(".swiper-slide-shadow-bottom");r||(r=Ds("div",("swiper-slide-shadow-cube swiper-slide-shadow-"+(a?"left":"top")).split(" ")),e.append(r)),s||(s=Ds("div",("swiper-slide-shadow-cube swiper-slide-shadow-"+(a?"right":"bottom")).split(" ")),e.append(s)),r&&(r.style.opacity=Math.max(-t,0)),s&&(s.style.opacity=Math.max(t,0))};So({effect:"cube",swiper:t,on:r,setTranslate:()=>{const{el:e,wrapperEl:a,slides:r,width:o,height:n,rtlTranslate:i,size:l,browser:c}=t,p=t.params.cubeEffect,d=t.isHorizontal(),u=t.virtual&&t.params.virtual.enabled;let h,m=0;p.shadow&&(d?(h=t.wrapperEl.querySelector(".swiper-cube-shadow"),h||(h=Ds("div","swiper-cube-shadow"),t.wrapperEl.append(h)),h.style.height=`${o}px`):(h=e.querySelector(".swiper-cube-shadow"),h||(h=Ds("div","swiper-cube-shadow"),e.append(h))));for(let e=0;e<r.length;e+=1){const t=r[e];let a=e;u&&(a=parseInt(t.getAttribute("data-swiper-slide-index"),10));let o=90*a,n=Math.floor(o/360);i&&(o=-o,n=Math.floor(-o/360));const c=Math.max(Math.min(t.progress,1),-1);let h=0,f=0,g=0;a%4==0?(h=4*-n*l,g=0):(a-1)%4==0?(h=0,g=4*-n*l):(a-2)%4==0?(h=l+4*n*l,g=l):(a-3)%4==0&&(h=-l,g=3*l+4*l*n),i&&(h=-h),d||(f=h,h=0);const v=`rotateX(${d?0:-o}deg) rotateY(${d?o:0}deg) translate3d(${h}px, ${f}px, ${g}px)`;c<=1&&c>-1&&(m=90*a+90*c,i&&(m=90*-a-90*c)),t.style.transform=v,p.slideShadows&&s(t,c,d)}if(a.style.transformOrigin=`50% 50% -${l/2}px`,a.style["-webkit-transform-origin"]=`50% 50% -${l/2}px`,p.shadow)if(d)h.style.transform=`translate3d(0px, ${o/2+p.shadowOffset}px, ${-o/2}px) rotateX(90deg) rotateZ(0deg) scale(${p.shadowScale})`;else{const e=Math.abs(m)-90*Math.floor(Math.abs(m)/90),t=1.5-(Math.sin(2*e*Math.PI/360)/2+Math.cos(2*e*Math.PI/360)/2),a=p.shadowScale,r=p.shadowScale/t,s=p.shadowOffset;h.style.transform=`scale3d(${a}, 1, ${r}) translate3d(0px, ${n/2+s}px, ${-n/2/r}px) rotateX(-90deg)`}const f=(c.isSafari||c.isWebView)&&c.needPerspectiveFix?-l/2:0;a.style.transform=`translate3d(0px,0,${f}px) rotateX(${t.isHorizontal()?0:m}deg) rotateY(${t.isHorizontal()?-m:0}deg)`,a.style.setProperty("--swiper-cube-translate-z",`${f}px`)},setTransition:e=>{const{el:a,slides:r}=t;if(r.forEach((t=>{t.style.transitionDuration=`${e}ms`,t.querySelectorAll(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").forEach((t=>{t.style.transitionDuration=`${e}ms`}))})),t.params.cubeEffect.shadow&&!t.isHorizontal()){const t=a.querySelector(".swiper-cube-shadow");t&&(t.style.transitionDuration=`${e}ms`)}},recreateShadows:()=>{const e=t.isHorizontal();t.slides.forEach((t=>{const a=Math.max(Math.min(t.progress,1),-1);s(t,a,e)}))},getEffectParams:()=>t.params.cubeEffect,perspective:()=>!0,overwriteParams:()=>({slidesPerView:1,slidesPerGroup:1,watchSlidesProgress:!0,resistanceRatio:0,spaceBetween:0,centeredSlides:!1,virtualTranslate:!0})})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({flipEffect:{slideShadows:!0,limitRotation:!0}});const s=(e,a)=>{let r=t.isHorizontal()?e.querySelector(".swiper-slide-shadow-left"):e.querySelector(".swiper-slide-shadow-top"),s=t.isHorizontal()?e.querySelector(".swiper-slide-shadow-right"):e.querySelector(".swiper-slide-shadow-bottom");r||(r=Oo("flip",e,t.isHorizontal()?"left":"top")),s||(s=Oo("flip",e,t.isHorizontal()?"right":"bottom")),r&&(r.style.opacity=Math.max(-a,0)),s&&(s.style.opacity=Math.max(a,0))};So({effect:"flip",swiper:t,on:r,setTranslate:()=>{const{slides:e,rtlTranslate:a}=t,r=t.params.flipEffect;for(let o=0;o<e.length;o+=1){const n=e[o];let i=n.progress;t.params.flipEffect.limitRotation&&(i=Math.max(Math.min(n.progress,1),-1));const l=n.swiperSlideOffset;let c=-180*i,p=0,d=t.params.cssMode?-l-t.translate:-l,u=0;t.isHorizontal()?a&&(c=-c):(u=d,d=0,p=-c,c=0),n.style.zIndex=-Math.abs(Math.round(i))+e.length,r.slideShadows&&s(n,i);const h=`translate3d(${d}px, ${u}px, 0px) rotateX(${p}deg) rotateY(${c}deg)`;Po(0,n).style.transform=h}},setTransition:e=>{const a=t.slides.map((e=>Bs(e)));a.forEach((t=>{t.style.transitionDuration=`${e}ms`,t.querySelectorAll(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").forEach((t=>{t.style.transitionDuration=`${e}ms`}))})),Mo({swiper:t,duration:e,transformElements:a})},recreateShadows:()=>{t.params.flipEffect,t.slides.forEach((e=>{let a=e.progress;t.params.flipEffect.limitRotation&&(a=Math.max(Math.min(e.progress,1),-1)),s(e,a)}))},getEffectParams:()=>t.params.flipEffect,perspective:()=>!0,overwriteParams:()=>({slidesPerView:1,slidesPerGroup:1,watchSlidesProgress:!0,spaceBetween:0,virtualTranslate:!t.params.cssMode})})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({coverflowEffect:{rotate:50,stretch:0,depth:100,scale:1,modifier:1,slideShadows:!0}}),So({effect:"coverflow",swiper:t,on:r,setTranslate:()=>{const{width:e,height:a,slides:r,slidesSizesGrid:s}=t,o=t.params.coverflowEffect,n=t.isHorizontal(),i=t.translate,l=n?e/2-i:a/2-i,c=n?o.rotate:-o.rotate,p=o.depth;for(let e=0,t=r.length;e<t;e+=1){const t=r[e],a=s[e],i=(l-t.swiperSlideOffset-a/2)/a,d="function"==typeof o.modifier?o.modifier(i):i*o.modifier;let u=n?c*d:0,h=n?0:c*d,m=-p*Math.abs(d),f=o.stretch;"string"==typeof f&&-1!==f.indexOf("%")&&(f=parseFloat(o.stretch)/100*a);let g=n?0:f*d,v=n?f*d:0,b=1-(1-o.scale)*Math.abs(d);Math.abs(v)<.001&&(v=0),Math.abs(g)<.001&&(g=0),Math.abs(m)<.001&&(m=0),Math.abs(u)<.001&&(u=0),Math.abs(h)<.001&&(h=0),Math.abs(b)<.001&&(b=0);const w=`translate3d(${v}px,${g}px,${m}px)  rotateX(${h}deg) rotateY(${u}deg) scale(${b})`;if(Po(0,t).style.transform=w,t.style.zIndex=1-Math.abs(Math.round(d)),o.slideShadows){let e=n?t.querySelector(".swiper-slide-shadow-left"):t.querySelector(".swiper-slide-shadow-top"),a=n?t.querySelector(".swiper-slide-shadow-right"):t.querySelector(".swiper-slide-shadow-bottom");e||(e=Oo("coverflow",t,n?"left":"top")),a||(a=Oo("coverflow",t,n?"right":"bottom")),e&&(e.style.opacity=d>0?d:0),a&&(a.style.opacity=-d>0?-d:0)}}},setTransition:e=>{t.slides.map((e=>Bs(e))).forEach((t=>{t.style.transitionDuration=`${e}ms`,t.querySelectorAll(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").forEach((t=>{t.style.transitionDuration=`${e}ms`}))}))},perspective:()=>!0,overwriteParams:()=>({watchSlidesProgress:!0})})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({creativeEffect:{limitProgress:1,shadowPerProgress:!1,progressMultiplier:1,perspective:!0,prev:{translate:[0,0,0],rotate:[0,0,0],opacity:1,scale:1},next:{translate:[0,0,0],rotate:[0,0,0],opacity:1,scale:1}}});const s=e=>"string"==typeof e?e:`${e}px`;So({effect:"creative",swiper:t,on:r,setTranslate:()=>{const{slides:e,wrapperEl:a,slidesSizesGrid:r}=t,o=t.params.creativeEffect,{progressMultiplier:n}=o,i=t.params.centeredSlides;if(i){const e=r[0]/2-t.params.slidesOffsetBefore||0;a.style.transform=`translateX(calc(50% - ${e}px))`}for(let a=0;a<e.length;a+=1){const r=e[a],l=r.progress,c=Math.min(Math.max(r.progress,-o.limitProgress),o.limitProgress);let p=c;i||(p=Math.min(Math.max(r.originalProgress,-o.limitProgress),o.limitProgress));const d=r.swiperSlideOffset,u=[t.params.cssMode?-d-t.translate:-d,0,0],h=[0,0,0];let m=!1;t.isHorizontal()||(u[1]=u[0],u[0]=0);let f={translate:[0,0,0],rotate:[0,0,0],scale:1,opacity:1};c<0?(f=o.next,m=!0):c>0&&(f=o.prev,m=!0),u.forEach(((e,t)=>{u[t]=`calc(${e}px + (${s(f.translate[t])} * ${Math.abs(c*n)}))`})),h.forEach(((e,t)=>{h[t]=f.rotate[t]*Math.abs(c*n)})),r.style.zIndex=-Math.abs(Math.round(l))+e.length;const g=u.join(", "),v=`rotateX(${h[0]}deg) rotateY(${h[1]}deg) rotateZ(${h[2]}deg)`,b=p<0?`scale(${1+(1-f.scale)*p*n})`:`scale(${1-(1-f.scale)*p*n})`,w=p<0?1+(1-f.opacity)*p*n:1-(1-f.opacity)*p*n,y=`translate3d(${g}) ${v} ${b}`;if(m&&f.shadow||!m){let e=r.querySelector(".swiper-slide-shadow");if(!e&&f.shadow&&(e=Oo("creative",r)),e){const t=o.shadowPerProgress?c*(1/o.limitProgress):c;e.style.opacity=Math.min(Math.max(Math.abs(t),0),1)}}const C=Po(0,r);C.style.transform=y,C.style.opacity=w,f.origin&&(C.style.transformOrigin=f.origin)}},setTransition:e=>{const a=t.slides.map((e=>Bs(e)));a.forEach((t=>{t.style.transitionDuration=`${e}ms`,t.querySelectorAll(".swiper-slide-shadow").forEach((t=>{t.style.transitionDuration=`${e}ms`}))})),Mo({swiper:t,duration:e,transformElements:a,allSlides:!0})},perspective:()=>t.params.creativeEffect.perspective,overwriteParams:()=>({watchSlidesProgress:!0,virtualTranslate:!t.params.cssMode})})},function(e){let{swiper:t,extendParams:a,on:r}=e;a({cardsEffect:{slideShadows:!0,rotate:!0,perSlideRotate:2,perSlideOffset:8}}),So({effect:"cards",swiper:t,on:r,setTranslate:()=>{const{slides:e,activeIndex:a,rtlTranslate:r}=t,s=t.params.cardsEffect,{startTranslate:o,isTouched:n}=t.touchEventsData,i=r?-t.translate:t.translate;for(let l=0;l<e.length;l+=1){const c=e[l],p=c.progress,d=Math.min(Math.max(p,-4),4);let u=c.swiperSlideOffset;t.params.centeredSlides&&!t.params.cssMode&&(t.wrapperEl.style.transform=`translateX(${t.minTranslate()}px)`),t.params.centeredSlides&&t.params.cssMode&&(u-=e[0].swiperSlideOffset);let h=t.params.cssMode?-u-t.translate:-u,m=0;const f=-100*Math.abs(d);let g=1,v=-s.perSlideRotate*d,b=s.perSlideOffset-.75*Math.abs(d);const w=t.virtual&&t.params.virtual.enabled?t.virtual.from+l:l,y=(w===a||w===a-1)&&d>0&&d<1&&(n||t.params.cssMode)&&i<o,C=(w===a||w===a+1)&&d<0&&d>-1&&(n||t.params.cssMode)&&i>o;if(y||C){const e=(1-Math.abs((Math.abs(d)-.5)/.5))**.5;v+=-28*d*e,g+=-.5*e,b+=96*e,m=-25*e*Math.abs(d)+"%"}if(h=d<0?`calc(${h}px ${r?"-":"+"} (${b*Math.abs(d)}%))`:d>0?`calc(${h}px ${r?"-":"+"} (-${b*Math.abs(d)}%))`:`${h}px`,!t.isHorizontal()){const e=m;m=h,h=e}const E=d<0?""+(1+(1-g)*d):""+(1-(1-g)*d),k=`\n        translate3d(${h}, ${m}, ${f}px)\n        rotateZ(${s.rotate?r?-v:v:0}deg)\n        scale(${E})\n      `;if(s.slideShadows){let e=c.querySelector(".swiper-slide-shadow");e||(e=Oo("cards",c)),e&&(e.style.opacity=Math.min(Math.max((Math.abs(d)-.5)/.5,0),1))}c.style.zIndex=-Math.abs(Math.round(p))+e.length;Po(0,c).style.transform=k}},setTransition:e=>{const a=t.slides.map((e=>Bs(e)));a.forEach((t=>{t.style.transitionDuration=`${e}ms`,t.querySelectorAll(".swiper-slide-shadow").forEach((t=>{t.style.transitionDuration=`${e}ms`}))})),Mo({swiper:t,duration:e,transformElements:a})},perspective:()=>!0,overwriteParams:()=>({watchSlidesProgress:!0,virtualTranslate:!t.params.cssMode})})}];wo.use(Io);const Bo=["eventsPrefix","injectStyles","injectStylesUrls","modules","init","_direction","oneWayMovement","touchEventsTarget","initialSlide","_speed","cssMode","updateOnWindowResize","resizeObserver","nested","focusableElements","_enabled","_width","_height","preventInteractionOnTransition","userAgent","url","_edgeSwipeDetection","_edgeSwipeThreshold","_freeMode","_autoHeight","setWrapperSize","virtualTranslate","_effect","breakpoints","_spaceBetween","_slidesPerView","maxBackfaceHiddenSlides","_grid","_slidesPerGroup","_slidesPerGroupSkip","_slidesPerGroupAuto","_centeredSlides","_centeredSlidesBounds","_slidesOffsetBefore","_slidesOffsetAfter","normalizeSlideIndex","_centerInsufficientSlides","_watchOverflow","roundLengths","touchRatio","touchAngle","simulateTouch","_shortSwipes","_longSwipes","longSwipesRatio","longSwipesMs","_followFinger","allowTouchMove","_threshold","touchMoveStopPropagation","touchStartPreventDefault","touchStartForcePreventDefault","touchReleaseOnEdges","uniqueNavElements","_resistance","_resistanceRatio","_watchSlidesProgress","_grabCursor","preventClicks","preventClicksPropagation","_slideToClickedSlide","_loop","loopedSlides","loopPreventsSliding","_rewind","_allowSlidePrev","_allowSlideNext","_swipeHandler","_noSwiping","noSwipingClass","noSwipingSelector","passiveListeners","containerModifierClass","slideClass","slideActiveClass","slideVisibleClass","slideNextClass","slidePrevClass","wrapperClass","lazyPreloaderClass","lazyPreloadPrevNext","runCallbacksOnInit","observer","observeParents","observeSlideChildren","a11y","_autoplay","_controller","coverflowEffect","cubeEffect","fadeEffect","flipEffect","creativeEffect","cardsEffect","hashNavigation","history","keyboard","mousewheel","_navigation","_pagination","parallax","_scrollbar","_thumbs","virtual","zoom","control"];function Lo(e){return"object"==typeof e&&null!==e&&e.constructor&&"Object"===Object.prototype.toString.call(e).slice(8,-1)}function Do(e,t){const a=["__proto__","constructor","prototype"];Object.keys(t).filter((e=>a.indexOf(e)<0)).forEach((a=>{void 0===e[a]?e[a]=t[a]:Lo(t[a])&&Lo(e[a])&&Object.keys(t[a]).length>0?t[a].__swiper__?e[a]=t[a]:Do(e[a],t[a]):e[a]=t[a]}))}function Ao(e){return void 0===e&&(e=""),e.replace(/-[a-z]/g,(e=>e.toUpperCase().replace("-","")))}const Ro=e=>{if(parseFloat(e)===Number(e))return Number(e);if("true"===e)return!0;if(""===e)return!0;if("false"===e)return!1;if("null"===e)return null;if("undefined"!==e){if("string"==typeof e&&e.includes("{")&&e.includes("}")&&e.includes('"')){let t;try{t=JSON.parse(e)}catch(a){t=e}return t}return e}},Ho=["a11y","autoplay","controller","cards-effect","coverflow-effect","creative-effect","cube-effect","fade-effect","flip-effect","free-mode","grid","hash-navigation","history","keyboard","mousewheel","navigation","pagination","parallax","scrollbar","thumbs","virtual","zoom"];function zo(e,t,a){const r={},s={};Do(r,fo);const o=[...Bo,"on"],n=o.map((e=>e.replace(/_/,"")));o.forEach((t=>{t=t.replace("_",""),void 0!==e[t]&&(s[t]=e[t])}));const i=[...e.attributes];return"string"==typeof t&&void 0!==a&&i.push({name:t,value:a}),i.forEach((e=>{const t=Ho.filter((t=>0===e.name.indexOf(`${t}-`)))[0];if(t){const a=Ao(t),r=Ao(e.name.split(`${t}-`)[1]);void 0===s[a]&&(s[a]={}),!0===s[a]&&(s[a]={enabled:!0}),s[a][r]=Ro(e.value)}else{const t=Ao(e.name);if(!n.includes(t))return;const a=Ro(e.value);s[t]&&Ho.includes(e.name)?(s[t].constructor!==Object&&(s[t]={}),s[t].enabled=a):s[t]=a}})),Do(r,s),r.navigation?r.navigation={prevEl:".swiper-button-prev",nextEl:".swiper-button-next",...!0!==r.navigation?r.navigation:{}}:!1===r.navigation&&delete r.navigation,r.scrollbar?r.scrollbar={el:".swiper-scrollbar",...!0!==r.scrollbar?r.scrollbar:{}}:!1===r.scrollbar&&delete r.scrollbar,r.pagination?r.pagination={el:".swiper-pagination",...!0!==r.pagination?r.pagination:{}}:!1===r.pagination&&delete r.pagination,{params:r,passedParams:s}}const No=":host{--swiper-theme-color:#007aff}:host{position:relative;display:block;margin-left:auto;margin-right:auto;z-index:1}.swiper{width:100%;height:100%;margin-left:auto;margin-right:auto;position:relative;overflow:hidden;overflow:clip;list-style:none;padding:0;z-index:1;display:block}.swiper-vertical>.swiper-wrapper{flex-direction:column}.swiper-wrapper{position:relative;width:100%;height:100%;z-index:1;display:flex;transition-property:transform;transition-timing-function:var(--swiper-wrapper-transition-timing-function,initial);box-sizing:content-box}.swiper-android ::slotted(swiper-slide),.swiper-ios ::slotted(swiper-slide),.swiper-wrapper{transform:translate3d(0px,0,0)}.swiper-horizontal{touch-action:pan-y}.swiper-vertical{touch-action:pan-x}::slotted(swiper-slide){flex-shrink:0;width:100%;height:100%;position:relative;transition-property:transform;display:block}::slotted(.swiper-slide-invisible-blank){visibility:hidden}.swiper-autoheight,.swiper-autoheight ::slotted(swiper-slide){height:auto}.swiper-autoheight .swiper-wrapper{align-items:flex-start;transition-property:transform,height}.swiper-backface-hidden ::slotted(swiper-slide){transform:translateZ(0);-webkit-backface-visibility:hidden;backface-visibility:hidden}.swiper-3d.swiper-css-mode .swiper-wrapper{perspective:1200px}.swiper-3d .swiper-wrapper{transform-style:preserve-3d}.swiper-3d{perspective:1200px}.swiper-3d .swiper-cube-shadow,.swiper-3d ::slotted(swiper-slide){transform-style:preserve-3d}.swiper-css-mode>.swiper-wrapper{overflow:auto;scrollbar-width:none;-ms-overflow-style:none}.swiper-css-mode>.swiper-wrapper::-webkit-scrollbar{display:none}.swiper-css-mode ::slotted(swiper-slide){scroll-snap-align:start start}.swiper-css-mode.swiper-horizontal>.swiper-wrapper{scroll-snap-type:x mandatory}.swiper-css-mode.swiper-vertical>.swiper-wrapper{scroll-snap-type:y mandatory}.swiper-css-mode.swiper-free-mode>.swiper-wrapper{scroll-snap-type:none}.swiper-css-mode.swiper-free-mode ::slotted(swiper-slide){scroll-snap-align:none}.swiper-css-mode.swiper-centered>.swiper-wrapper::before{content:'';flex-shrink:0;order:9999}.swiper-css-mode.swiper-centered ::slotted(swiper-slide){scroll-snap-align:center center;scroll-snap-stop:always}.swiper-css-mode.swiper-centered.swiper-horizontal ::slotted(swiper-slide):first-child{margin-inline-start:var(--swiper-centered-offset-before)}.swiper-css-mode.swiper-centered.swiper-horizontal>.swiper-wrapper::before{height:100%;min-height:1px;width:var(--swiper-centered-offset-after)}.swiper-css-mode.swiper-centered.swiper-vertical ::slotted(swiper-slide):first-child{margin-block-start:var(--swiper-centered-offset-before)}.swiper-css-mode.swiper-centered.swiper-vertical>.swiper-wrapper::before{width:100%;min-width:1px;height:var(--swiper-centered-offset-after)}.swiper-virtual ::slotted(swiper-slide){-webkit-backface-visibility:hidden;transform:translateZ(0)}.swiper-virtual.swiper-css-mode .swiper-wrapper::after{content:'';position:absolute;left:0;top:0;pointer-events:none}.swiper-virtual.swiper-css-mode.swiper-horizontal .swiper-wrapper::after{height:1px;width:var(--swiper-virtual-size)}.swiper-virtual.swiper-css-mode.swiper-vertical .swiper-wrapper::after{width:1px;height:var(--swiper-virtual-size)}:host{--swiper-navigation-size:44px}.swiper-button-next,.swiper-button-prev{position:absolute;top:var(--swiper-navigation-top-offset,50%);width:calc(var(--swiper-navigation-size)/ 44 * 27);height:var(--swiper-navigation-size);margin-top:calc(0px - (var(--swiper-navigation-size)/ 2));z-index:10;cursor:pointer;display:flex;align-items:center;justify-content:center;color:var(--swiper-navigation-color,var(--swiper-theme-color))}.swiper-button-next.swiper-button-disabled,.swiper-button-prev.swiper-button-disabled{opacity:.35;cursor:auto;pointer-events:none}.swiper-button-next.swiper-button-hidden,.swiper-button-prev.swiper-button-hidden{opacity:0;cursor:auto;pointer-events:none}.swiper-navigation-disabled .swiper-button-next,.swiper-navigation-disabled .swiper-button-prev{display:none!important}.swiper-button-next svg,.swiper-button-prev svg{width:100%;height:100%;object-fit:contain;transform-origin:center}.swiper-rtl .swiper-button-next svg,.swiper-rtl .swiper-button-prev svg{transform:rotate(180deg)}.swiper-button-prev,.swiper-rtl .swiper-button-next{left:var(--swiper-navigation-sides-offset,10px);right:auto}.swiper-button-next,.swiper-rtl .swiper-button-prev{right:var(--swiper-navigation-sides-offset,10px);left:auto}.swiper-button-lock{display:none}.swiper-pagination{position:absolute;text-align:center;transition:.3s opacity;transform:translate3d(0,0,0);z-index:10}.swiper-pagination.swiper-pagination-hidden{opacity:0}.swiper-pagination-disabled>.swiper-pagination,.swiper-pagination.swiper-pagination-disabled{display:none!important}.swiper-horizontal>.swiper-pagination-bullets,.swiper-pagination-bullets.swiper-pagination-horizontal,.swiper-pagination-custom,.swiper-pagination-fraction{bottom:var(--swiper-pagination-bottom,8px);top:var(--swiper-pagination-top,auto);left:0;width:100%}.swiper-pagination-bullets-dynamic{overflow:hidden;font-size:0}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet{transform:scale(.33);position:relative}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active{transform:scale(1)}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-main{transform:scale(1)}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-prev{transform:scale(.66)}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-prev-prev{transform:scale(.33)}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-next{transform:scale(.66)}.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-next-next{transform:scale(.33)}.swiper-pagination-bullet{width:var(--swiper-pagination-bullet-width,var(--swiper-pagination-bullet-size,8px));height:var(--swiper-pagination-bullet-height,var(--swiper-pagination-bullet-size,8px));display:inline-block;border-radius:var(--swiper-pagination-bullet-border-radius,50%);background:var(--swiper-pagination-bullet-inactive-color,#000);opacity:var(--swiper-pagination-bullet-inactive-opacity, .2)}button.swiper-pagination-bullet{border:none;margin:0;padding:0;box-shadow:none;-webkit-appearance:none;appearance:none}.swiper-pagination-clickable .swiper-pagination-bullet{cursor:pointer}.swiper-pagination-bullet:only-child{display:none!important}.swiper-pagination-bullet-active{opacity:var(--swiper-pagination-bullet-opacity, 1);background:var(--swiper-pagination-color,var(--swiper-theme-color))}.swiper-pagination-vertical.swiper-pagination-bullets,.swiper-vertical>.swiper-pagination-bullets{right:var(--swiper-pagination-right,8px);left:var(--swiper-pagination-left,auto);top:50%;transform:translate3d(0px,-50%,0)}.swiper-pagination-vertical.swiper-pagination-bullets .swiper-pagination-bullet,.swiper-vertical>.swiper-pagination-bullets .swiper-pagination-bullet{margin:var(--swiper-pagination-bullet-vertical-gap,6px) 0;display:block}.swiper-pagination-vertical.swiper-pagination-bullets.swiper-pagination-bullets-dynamic,.swiper-vertical>.swiper-pagination-bullets.swiper-pagination-bullets-dynamic{top:50%;transform:translateY(-50%);width:8px}.swiper-pagination-vertical.swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet,.swiper-vertical>.swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet{display:inline-block;transition:.2s transform,.2s top}.swiper-horizontal>.swiper-pagination-bullets .swiper-pagination-bullet,.swiper-pagination-horizontal.swiper-pagination-bullets .swiper-pagination-bullet{margin:0 var(--swiper-pagination-bullet-horizontal-gap,4px)}.swiper-horizontal>.swiper-pagination-bullets.swiper-pagination-bullets-dynamic,.swiper-pagination-horizontal.swiper-pagination-bullets.swiper-pagination-bullets-dynamic{left:50%;transform:translateX(-50%);white-space:nowrap}.swiper-horizontal>.swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet,.swiper-pagination-horizontal.swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet{transition:.2s transform,.2s left}.swiper-horizontal.swiper-rtl>.swiper-pagination-bullets-dynamic .swiper-pagination-bullet{transition:.2s transform,.2s right}.swiper-pagination-fraction{color:var(--swiper-pagination-fraction-color,inherit)}.swiper-pagination-progressbar{background:var(--swiper-pagination-progressbar-bg-color,rgba(0,0,0,.25));position:absolute}.swiper-pagination-progressbar .swiper-pagination-progressbar-fill{background:var(--swiper-pagination-color,var(--swiper-theme-color));position:absolute;left:0;top:0;width:100%;height:100%;transform:scale(0);transform-origin:left top}.swiper-rtl .swiper-pagination-progressbar .swiper-pagination-progressbar-fill{transform-origin:right top}.swiper-horizontal>.swiper-pagination-progressbar,.swiper-pagination-progressbar.swiper-pagination-horizontal,.swiper-pagination-progressbar.swiper-pagination-vertical.swiper-pagination-progressbar-opposite,.swiper-vertical>.swiper-pagination-progressbar.swiper-pagination-progressbar-opposite{width:100%;height:var(--swiper-pagination-progressbar-size,4px);left:0;top:0}.swiper-horizontal>.swiper-pagination-progressbar.swiper-pagination-progressbar-opposite,.swiper-pagination-progressbar.swiper-pagination-horizontal.swiper-pagination-progressbar-opposite,.swiper-pagination-progressbar.swiper-pagination-vertical,.swiper-vertical>.swiper-pagination-progressbar{width:var(--swiper-pagination-progressbar-size,4px);height:100%;left:0;top:0}.swiper-pagination-lock{display:none}.swiper-scrollbar{border-radius:var(--swiper-scrollbar-border-radius,10px);position:relative;-ms-touch-action:none;background:var(--swiper-scrollbar-bg-color,rgba(0,0,0,.1))}.swiper-scrollbar-disabled>.swiper-scrollbar,.swiper-scrollbar.swiper-scrollbar-disabled{display:none!important}.swiper-horizontal>.swiper-scrollbar,.swiper-scrollbar.swiper-scrollbar-horizontal{position:absolute;left:var(--swiper-scrollbar-sides-offset,1%);bottom:var(--swiper-scrollbar-bottom,4px);top:var(--swiper-scrollbar-top,auto);z-index:50;height:var(--swiper-scrollbar-size,4px);width:calc(100% - 2 * var(--swiper-scrollbar-sides-offset,1%))}.swiper-scrollbar.swiper-scrollbar-vertical,.swiper-vertical>.swiper-scrollbar{position:absolute;left:var(--swiper-scrollbar-left,auto);right:var(--swiper-scrollbar-right,4px);top:var(--swiper-scrollbar-sides-offset,1%);z-index:50;width:var(--swiper-scrollbar-size,4px);height:calc(100% - 2 * var(--swiper-scrollbar-sides-offset,1%))}.swiper-scrollbar-drag{height:100%;width:100%;position:relative;background:var(--swiper-scrollbar-drag-bg-color,rgba(0,0,0,.5));border-radius:var(--swiper-scrollbar-border-radius,10px);left:0;top:0}.swiper-scrollbar-cursor-drag{cursor:move}.swiper-scrollbar-lock{display:none}::slotted(.swiper-slide-zoomed){cursor:move;touch-action:none}.swiper .swiper-notification{position:absolute;left:0;top:0;pointer-events:none;opacity:0;z-index:-1000}.swiper-free-mode>.swiper-wrapper{transition-timing-function:ease-out;margin:0 auto}.swiper-grid>.swiper-wrapper{flex-wrap:wrap}.swiper-grid-column>.swiper-wrapper{flex-wrap:wrap;flex-direction:column}.swiper-fade.swiper-free-mode ::slotted(swiper-slide){transition-timing-function:ease-out}.swiper-fade ::slotted(swiper-slide){pointer-events:none;transition-property:opacity}.swiper-fade ::slotted(swiper-slide) ::slotted(swiper-slide){pointer-events:none}.swiper-fade ::slotted(.swiper-slide-active){pointer-events:auto}.swiper-fade ::slotted(.swiper-slide-active) ::slotted(.swiper-slide-active){pointer-events:auto}.swiper-cube{overflow:visible}.swiper-cube ::slotted(swiper-slide){pointer-events:none;-webkit-backface-visibility:hidden;backface-visibility:hidden;z-index:1;visibility:hidden;transform-origin:0 0;width:100%;height:100%}.swiper-cube ::slotted(swiper-slide) ::slotted(swiper-slide){pointer-events:none}.swiper-cube.swiper-rtl ::slotted(swiper-slide){transform-origin:100% 0}.swiper-cube ::slotted(.swiper-slide-active),.swiper-cube ::slotted(.swiper-slide-active) ::slotted(.swiper-slide-active){pointer-events:auto}.swiper-cube ::slotted(.swiper-slide-active),.swiper-cube ::slotted(.swiper-slide-next),.swiper-cube ::slotted(.swiper-slide-prev){pointer-events:auto;visibility:visible}.swiper-cube .swiper-cube-shadow{position:absolute;left:0;bottom:0px;width:100%;height:100%;opacity:.6;z-index:0}.swiper-cube .swiper-cube-shadow:before{content:'';background:#000;position:absolute;left:0;top:0;bottom:0;right:0;filter:blur(50px)}.swiper-cube ::slotted(.swiper-slide-next)+::slotted(swiper-slide){pointer-events:auto;visibility:visible}.swiper-flip{overflow:visible}.swiper-flip ::slotted(swiper-slide){pointer-events:none;-webkit-backface-visibility:hidden;backface-visibility:hidden;z-index:1}.swiper-flip ::slotted(swiper-slide) ::slotted(swiper-slide){pointer-events:none}.swiper-flip ::slotted(.swiper-slide-active),.swiper-flip ::slotted(.swiper-slide-active) ::slotted(.swiper-slide-active){pointer-events:auto}.swiper-creative ::slotted(swiper-slide){-webkit-backface-visibility:hidden;backface-visibility:hidden;overflow:hidden;transition-property:transform,opacity,height}.swiper-cards{overflow:visible}.swiper-cards ::slotted(swiper-slide){transform-origin:center bottom;-webkit-backface-visibility:hidden;backface-visibility:hidden;overflow:hidden}";const Vo="undefined"==typeof window||"undefined"==typeof HTMLElement?class{}:HTMLElement,Fo='<svg width="11" height="20" viewBox="0 0 11 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0.38296 20.0762C0.111788 19.805 0.111788 19.3654 0.38296 19.0942L9.19758 10.2796L0.38296 1.46497C0.111788 1.19379 0.111788 0.754138 0.38296 0.482966C0.654131 0.211794 1.09379 0.211794 1.36496 0.482966L10.4341 9.55214C10.8359 9.9539 10.8359 10.6053 10.4341 11.007L1.36496 20.0762C1.09379 20.3474 0.654131 20.3474 0.38296 20.0762Z" fill="currentColor"/></svg>\n    ',_o=(e,t)=>{if("undefined"!=typeof CSSStyleSheet&&e.adoptedStyleSheets){const a=new CSSStyleSheet;a.replaceSync(t),e.adoptedStyleSheets=[a]}else{const a=document.createElement("style");a.rel="stylesheet",a.textContent=t,e.appendChild(a)}};class qo extends Vo{constructor(){super(),this.attachShadow({mode:"open"})}static get nextButtonSvg(){return Fo}static get prevButtonSvg(){return Fo.replace("/></svg>",' transform-origin="center" transform="rotate(180)"/></svg>')}cssStyles(){return[No,...this.injectStyles&&Array.isArray(this.injectStyles)?this.injectStyles:[]].join("\n")}cssLinks(){return this.injectStylesUrls||[]}calcSlideSlots(){const e=this.slideSlots||0,t=[...this.querySelectorAll("[slot^=slide-]")].map((e=>parseInt(e.getAttribute("slot").split("slide-")[1],10)));if(this.slideSlots=t.length?Math.max(...t)+1:0,this.rendered)if(this.slideSlots>e)for(let t=e;t<this.slideSlots;t+=1){const e=document.createElement("swiper-slide");e.setAttribute("part",`slide slide-${t+1}`);const a=document.createElement("slot");a.setAttribute("name",`slide-${t+1}`),e.appendChild(a),this.shadowRoot.querySelector(".swiper-wrapper").appendChild(e)}else if(this.slideSlots<e){const e=this.swiper.slides;for(let t=e.length-1;t>=0;t-=1)t>this.slideSlots&&e[t].remove()}}render(){if(this.rendered)return;this.calcSlideSlots();let e=this.cssStyles();this.slideSlots>0&&(e=e.replace(/::slotted\(([a-z-0-9.]*)\)/g,"$1")),e.length&&_o(this.shadowRoot,e),this.cssLinks().forEach((e=>{if(this.shadowRoot.querySelector(`link[href="${e}"]`))return;const t=document.createElement("link");t.rel="stylesheet",t.href=e,this.shadowRoot.appendChild(t)}));const t=document.createElement("div");var a;t.classList.add("swiper"),t.part="container",t.innerHTML=`\n      <slot name="container-start"></slot>\n      <div class="swiper-wrapper" part="wrapper">\n        <slot></slot>\n        ${Array.from({length:this.slideSlots}).map(((e,t)=>`\n        <swiper-slide part="slide slide-${t}">\n          <slot name="slide-${t}"></slot>\n        </swiper-slide>\n        `)).join("")}\n      </div>\n      <slot name="container-end"></slot>\n      ${a=this.passedParams,void 0===a&&(a={}),a.navigation&&void 0===a.navigation.nextEl&&void 0===a.navigation.prevEl?`\n        <div part="button-prev" class="swiper-button-prev">${this.constructor.prevButtonSvg}</div>\n        <div part="button-next" class="swiper-button-next">${this.constructor.nextButtonSvg}</div>\n      `:""}\n      ${function(e){return void 0===e&&(e={}),e.pagination&&void 0===e.pagination.el}(this.passedParams)?'\n        <div part="pagination" class="swiper-pagination"></div>\n      ':""}\n      ${function(e){return void 0===e&&(e={}),e.scrollbar&&void 0===e.scrollbar.el}(this.passedParams)?'\n        <div part="scrollbar" class="swiper-scrollbar"></div>\n      ':""}\n    `,this.shadowRoot.appendChild(t),this.rendered=!0}initialize(){var e=this;if(this.initialized)return;this.initialized=!0;const{params:t,passedParams:a}=zo(this);this.swiperParams=t,this.passedParams=a,delete this.swiperParams.init,this.render(),this.swiper=new wo(this.shadowRoot.querySelector(".swiper"),{...t.virtual?{}:{observer:!0,observeSlideChildren:this.slideSlots>0},...t,touchEventsTarget:"container",onAny:function(a){"observerUpdate"===a&&e.calcSlideSlots();const r=t.eventsPrefix?`${t.eventsPrefix}${a.toLowerCase()}`:a.toLowerCase();for(var s=arguments.length,o=new Array(s>1?s-1:0),n=1;n<s;n++)o[n-1]=arguments[n];const i=new CustomEvent(r,{detail:o,bubbles:!0,cancelable:!0});e.dispatchEvent(i)}})}connectedCallback(){this.initialized&&this.nested&&this.closest("swiper-slide")&&this.closest("swiper-slide").swiperLoopMoveDOM||!1!==this.init&&"false"!==this.getAttribute("init")&&this.initialize()}disconnectedCallback(){this.nested&&this.closest("swiper-slide")&&this.closest("swiper-slide").swiperLoopMoveDOM||(this.swiper&&this.swiper.destroy&&this.swiper.destroy(),this.initialized=!1)}updateSwiperOnPropChange(e,t){const{params:a,passedParams:r}=zo(this,e,t);this.passedParams=r,this.swiperParams=a,function(e){let{swiper:t,slides:a,passedParams:r,changedParams:s,nextEl:o,prevEl:n,scrollbarEl:i,paginationEl:l}=e;const c=s.filter((e=>"children"!==e&&"direction"!==e&&"wrapperClass"!==e)),{params:p,pagination:d,navigation:u,scrollbar:h,virtual:m,thumbs:f}=t;let g,v,b,w,y,C,E,k;s.includes("thumbs")&&r.thumbs&&r.thumbs.swiper&&p.thumbs&&!p.thumbs.swiper&&(g=!0),s.includes("controller")&&r.controller&&r.controller.control&&p.controller&&!p.controller.control&&(v=!0),s.includes("pagination")&&r.pagination&&(r.pagination.el||l)&&(p.pagination||!1===p.pagination)&&d&&!d.el&&(b=!0),s.includes("scrollbar")&&r.scrollbar&&(r.scrollbar.el||i)&&(p.scrollbar||!1===p.scrollbar)&&h&&!h.el&&(w=!0),s.includes("navigation")&&r.navigation&&(r.navigation.prevEl||n)&&(r.navigation.nextEl||o)&&(p.navigation||!1===p.navigation)&&u&&!u.prevEl&&!u.nextEl&&(y=!0);const $=e=>{t[e]&&(t[e].destroy(),"navigation"===e?(t.isElement&&(t[e].prevEl.remove(),t[e].nextEl.remove()),p[e].prevEl=void 0,p[e].nextEl=void 0,t[e].prevEl=void 0,t[e].nextEl=void 0):(t.isElement&&t[e].el.remove(),p[e].el=void 0,t[e].el=void 0))};s.includes("loop")&&t.isElement&&(p.loop&&!r.loop?C=!0:!p.loop&&r.loop?E=!0:k=!0),c.forEach((e=>{if(Lo(p[e])&&Lo(r[e]))Do(p[e],r[e]),"navigation"!==e&&"pagination"!==e&&"scrollbar"!==e||!("enabled"in r[e])||r[e].enabled||$(e);else{const t=r[e];!0!==t&&!1!==t||"navigation"!==e&&"pagination"!==e&&"scrollbar"!==e?p[e]=r[e]:!1===t&&$(e)}})),c.includes("controller")&&!v&&t.controller&&t.controller.control&&p.controller&&p.controller.control&&(t.controller.control=p.controller.control),s.includes("children")&&a&&m&&p.virtual.enabled&&(m.slides=a,m.update(!0)),s.includes("children")&&a&&p.loop&&(k=!0),g&&f.init()&&f.update(!0);v&&(t.controller.control=p.controller.control),b&&(!t.isElement||l&&"string"!=typeof l||(l=document.createElement("div"),l.classList.add("swiper-pagination"),l.part.add("pagination"),t.el.appendChild(l)),l&&(p.pagination.el=l),d.init(),d.render(),d.update()),w&&(!t.isElement||i&&"string"!=typeof i||(i=document.createElement("div"),i.classList.add("swiper-scrollbar"),i.part.add("scrollbar"),t.el.appendChild(i)),i&&(p.scrollbar.el=i),h.init(),h.updateSize(),h.setTranslate()),y&&(t.isElement&&(o&&"string"!=typeof o||(o=document.createElement("div"),o.classList.add("swiper-button-next"),o.innerHTML=t.hostEl.constructor.nextButtonSvg,o.part.add("button-next"),t.el.appendChild(o)),n&&"string"!=typeof n||(n=document.createElement("div"),n.classList.add("swiper-button-prev"),n.innerHTML=t.hostEl.constructor.prevButtonSvg,n.part.add("button-prev"),t.el.appendChild(n))),o&&(p.navigation.nextEl=o),n&&(p.navigation.prevEl=n),u.init(),u.update()),s.includes("allowSlideNext")&&(t.allowSlideNext=r.allowSlideNext),s.includes("allowSlidePrev")&&(t.allowSlidePrev=r.allowSlidePrev),s.includes("direction")&&t.changeDirection(r.direction,!1),(C||k)&&t.loopDestroy(),(E||k)&&t.loopCreate(),t.update()}({swiper:this.swiper,passedParams:this.passedParams,changedParams:[Ao(e)],..."navigation"===e&&r[e]?{prevEl:".swiper-button-prev",nextEl:".swiper-button-next"}:{},..."pagination"===e&&r[e]?{paginationEl:".swiper-pagination"}:{},..."scrollbar"===e&&r[e]?{scrollbarEl:".swiper-scrollbar"}:{}})}attributeChangedCallback(e,t,a){this.initialized&&("true"===t&&null===a&&(a=!1),this.updateSwiperOnPropChange(e,a))}static get observedAttributes(){return Bo.filter((e=>e.includes("_"))).map((e=>e.replace(/[A-Z]/g,(e=>`-${e}`)).replace("_","").toLowerCase()))}}Bo.forEach((e=>{"init"!==e&&(e=e.replace("_",""),Object.defineProperty(qo.prototype,e,{configurable:!0,get(){return(this.passedParams||{})[e]},set(t){this.passedParams||(this.passedParams={}),this.passedParams[e]=t,this.initialized&&this.updateSwiperOnPropChange(e)}}))}));class jo extends Vo{constructor(){super(),this.attachShadow({mode:"open"})}render(){const e=this.lazy||""===this.getAttribute("lazy")||"true"===this.getAttribute("lazy");if(_o(this.shadowRoot,"::slotted(.swiper-slide-shadow),::slotted(.swiper-slide-shadow-bottom),::slotted(.swiper-slide-shadow-left),::slotted(.swiper-slide-shadow-right),::slotted(.swiper-slide-shadow-top){position:absolute;left:0;top:0;width:100%;height:100%;pointer-events:none;z-index:10}::slotted(.swiper-slide-shadow){background:rgba(0,0,0,.15)}::slotted(.swiper-slide-shadow-left){background-image:linear-gradient(to left,rgba(0,0,0,.5),rgba(0,0,0,0))}::slotted(.swiper-slide-shadow-right){background-image:linear-gradient(to right,rgba(0,0,0,.5),rgba(0,0,0,0))}::slotted(.swiper-slide-shadow-top){background-image:linear-gradient(to top,rgba(0,0,0,.5),rgba(0,0,0,0))}::slotted(.swiper-slide-shadow-bottom){background-image:linear-gradient(to bottom,rgba(0,0,0,.5),rgba(0,0,0,0))}.swiper-lazy-preloader{animation:swiper-preloader-spin 1s infinite linear;width:42px;height:42px;position:absolute;left:50%;top:50%;margin-left:-21px;margin-top:-21px;z-index:10;transform-origin:50%;box-sizing:border-box;border:4px solid var(--swiper-preloader-color,var(--swiper-theme-color));border-radius:50%;border-top-color:transparent}@keyframes swiper-preloader-spin{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-bottom),::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-left),::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-right),::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-top){z-index:0;-webkit-backface-visibility:hidden;backface-visibility:hidden}::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-bottom),::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-left),::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-right),::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-top){z-index:0;-webkit-backface-visibility:hidden;backface-visibility:hidden}::slotted(.swiper-zoom-container){width:100%;height:100%;display:flex;justify-content:center;align-items:center;text-align:center}::slotted(.swiper-zoom-container)>canvas,::slotted(.swiper-zoom-container)>img,::slotted(.swiper-zoom-container)>svg{max-width:100%;max-height:100%;object-fit:contain}"),this.shadowRoot.appendChild(document.createElement("slot")),e){const e=document.createElement("div");e.classList.add("swiper-lazy-preloader"),e.part.add("preloader"),this.shadowRoot.appendChild(e)}}initialize(){this.render()}connectedCallback(){this.initialize()}}function Yo(e){const t=this,a=A(e);if(0===a.length)return;const r=a[0].swiper&&a[0].swiper.isElement;if(a[0].swiper&&!a[0].swiper.isElement)return;let s,o,n,i={};a.hasClass("tabs")&&(s=a.children("swiper-slide").indexOf(a.children(".tab-active")[0]),o=!0,n=a.find(".tabs-routable").length>0),a.attr("data-swiper")?i=JSON.parse(a.attr("data-swiper")):a[0].f7SwiperParams?i=a[0].f7SwiperParams:(i=a.dataset(),Object.keys(i).forEach((e=>{const t=i[e];if("string"==typeof t&&0===t.indexOf("{")&&t.indexOf("}")>0)try{i[e]=JSON.parse(t)}catch(e){}}))),void 0===i.initialSlide&&void 0!==s&&(i.initialSlide=s);const l=r?a[0].swiper:t.swiper.create(a[0],i);function c(){l.update()}r&&l.slideTo(s,0);const p=a.parents(".tab").filter((e=>0===A(e).parent(".tabs").parent(".tabs-animated-wrap, swiper-container.tabs").length)).eq(0);a.parents(".popup, .login-screen, .sheet-modal, .popover").on("modal:open",c),a.parents(".panel").on("panel:open",c),p&&p.length&&p.on("tab:show",c),l.on("beforeDestroy",(()=>{a.parents(".popup, .login-screen, .sheet-modal, .popover").off("modal:open",c),a.parents(".panel").off("panel:open",c),p&&p.length&&p.off("tab:show",c)})),o&&l.on("slideChange",(()=>{if(n){let e=t.views.get(a.parents(".view"));e||(e=t.views.main);const r=e.router,s=r.findTabRouteUrl(A(l.slides).eq(l.activeIndex)[0]);s&&setTimeout((()=>{r.navigate(s)}),0)}else t.tab.show({tabEl:A(l.slides).eq(l.activeIndex)})}))}"undefined"!=typeof window&&(window.SwiperElementRegisterParams=e=>{Bo.push(...e)}),"undefined"!=typeof window&&(window.customElements.get("swiper-container")||window.customElements.define("swiper-container",qo),window.customElements.get("swiper-slide")||window.customElements.define("swiper-slide",jo)),window.Swiper||(window.Swiper=wo);var Wo={name:"swiper",static:{Swiper:wo},create(){this.swiper=nt({defaultSelector:".swiper",constructor:wo,domProp:"swiper"})},on:{pageMounted(e){const t=this;e.$el.find("swiper-container.tabs").each((e=>{Yo.call(t,e)}))},pageInit(e){const t=this;e.$el.find("swiper-container.tabs").each((e=>{Yo.call(t,e)}))},pageReinit(e){const t=this;e.$el.find("swiper-container.tabs").each((e=>{const a=t.swiper.get(e);a&&a.update&&a.update()}))},tabMounted(e){const t=this;A(e).find("swiper-container.tabs").each((e=>{Yo.call(t,e)}))},tabShow(e){const t=this;A(e).find("swiper-container.tabs").each((e=>{const a=t.swiper.get(e);a&&a.update&&a.update()}))},tabBeforeRemove(e){const t=this;A(e).find("swiper-container.tabs").each((e=>{t.swiper.destroy(e)}))}}};let Xo=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this;a.app=e;const r=Fe({on:{}},e.params.photoBrowser);a.useModulesParams(r),a.params=Fe(r,t),Fe(a,{exposed:!1,opened:!1,activeIndex:a.params.swiper.initialSlide,url:a.params.url,swipeToClose:{allow:!0,isTouched:!1,diff:void 0,start:void 0,current:void 0,started:!1,activeSlide:void 0,timeStart:void 0}}),a.useModules(),a.init()}get view(){const{params:e,app:t}=this;return e.view||t.views.main}onSlideChange(e){const t=this;t.activeIndex=e.activeIndex;let a=e.activeIndex+1,r=t.params.virtualSlides?t.params.photos.length:e.slides.length;e.params.loop&&(r-=2,a-=e.loopedSlides,a<1&&(a=r+a),a>r&&(a-=r));const s=t.params.virtualSlides?A(e.wrapperEl).find(`.swiper-slide[data-swiper-slide-index="${e.activeIndex}"]`):A(e.slides).eq(e.activeIndex),o=t.params.virtualSlides?A(e.wrapperEl).find(`.swiper-slide[data-swiper-slide-index="${e.previousIndex}"]`):A(e.slides).eq(e.previousIndex);let n,i=t.$el.find(".photo-browser-current"),l=t.$el.find(".photo-browser-total");if("page"===t.params.type&&t.params.navbar&&0===i.length&&"ios"===t.app.theme&&(n=t.app.navbar.getElByPage(t.$el),n&&(i=A(n).find(".photo-browser-current"),l=A(n).find(".photo-browser-total"))),i.length&&l.length&&(i.text(a),l.text(r),n||(n=i.parents(".navbar")[0]),n&&t.app.navbar.size(n)),t.captions.length>0){const a=e.params.loop?s.attr("data-swiper-slide-index"):t.activeIndex;t.$captionsContainerEl.find(".photo-browser-caption-active").removeClass("photo-browser-caption-active"),t.$captionsContainerEl.find(`[data-caption-index="${a}"]`).addClass("photo-browser-caption-active")}const c=o.find("video");c.length>0&&"pause"in c[0]&&c[0].pause()}onTouchStart(){const e=this.swipeToClose;e.allow&&(e.isTouched=!0)}onTouchMove(e){const t=this,a=t.swipeToClose;a.isTouched&&(a.started||(a.started=!0,a.start="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,t.params.virtualSlides?a.activeSlide=A(t.swiper.wrapperEl).children(".swiper-slide-active"):a.activeSlide=A(t.swiper.slides).eq(t.swiper.activeIndex),a.timeStart=Ae()),e.preventDefault(),a.current="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,a.diff=a.start-a.current,t.$el.transition(0).transform(`translate3d(0,${-a.diff}px,0)`))}onTouchEnd(){const e=this,t=e.swipeToClose;if(t.isTouched=!1,!t.started)return void(t.started=!1);t.started=!1,t.allow=!1;const a=Math.abs(t.diff),r=(new Date).getTime()-t.timeStart;r<300&&a>20||r>=300&&a>100?Le((()=>{e.$el&&(t.diff<0?e.$el.addClass("swipe-close-to-bottom"):e.$el.addClass("swipe-close-to-top")),e.emit("local::swipeToClose",e),e.$el.transform("").transition(""),e.close(),t.allow=!0})):(0!==a?e.$el.addClass("photo-browser-transitioning").transitionEnd((()=>{t.allow=!0,e.$el.removeClass("photo-browser-transitioning")})):t.allow=!0,Le((()=>{e.$el.transform("").transition("")})))}renderNavbar(){const e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e);const t=e.params.iconsColor,a="ios"===e.app.theme&&e.params.pageBackLinkText?e.params.pageBackLinkText:"",r=void 0===e.params.navbarShowCount?e.params.photos.length>1:e.params.navbarShowCount,s="page"!==e.params.type;return ct("div",{class:"navbar navbar-photo-browser "+("dark"===e.params.theme?"navbar-photo-browser-dark":"")},ct("div",{class:"navbar-bg"}),ct("div",{class:"navbar-inner navbar-inner-centered-title sliding"},!s&&ct("div",{class:"left"},ct("a",{class:`link ${a?"":"icon-only"} back`},ct("i",{class:"icon icon-back "+(t?`color-${t}`:"")}),a&&ct("span",null,a))),r&&ct("div",{class:"title"},ct("span",{class:"photo-browser-current"}),ct("span",{class:"photo-browser-of"},e.params.navbarOfText),ct("span",{class:"photo-browser-total"})),s&&(e.params.popupCloseLinkText||e.params.popupCloseLinkIcon)&&ct("div",{class:"right"},ct("a",{class:"link popup-close","data-popup":".photo-browser-popup"},e.params.popupCloseLinkIcon&&"ios"===e.app.theme&&ct("i",null,ct("svg",{xmlns:"http://www.w3.org/2000/svg",width:"56",height:"56",viewBox:"0 0 56 56"},ct("path",{fill:"currentColor",d:"M 10.0234 43.0234 C 9.2266 43.8203 9.2031 45.1797 10.0234 45.9766 C 10.8438 46.7734 12.1797 46.7734 13.0000 45.9766 L 28.0000 30.9766 L 43.0000 45.9766 C 43.7969 46.7734 45.1563 46.7969 45.9766 45.9766 C 46.7734 45.1562 46.7734 43.8203 45.9766 43.0234 L 30.9531 28.0000 L 45.9766 13.0000 C 46.7734 12.2031 46.7969 10.8437 45.9766 10.0469 C 45.1328 9.2266 43.7969 9.2266 43.0000 10.0469 L 28.0000 25.0469 L 13.0000 10.0469 C 12.1797 9.2266 10.8203 9.2031 10.0234 10.0469 C 9.2266 10.8672 9.2266 12.2031 10.0234 13.0000 L 25.0234 28.0000 Z"}))),e.params.popupCloseLinkIcon&&"md"===e.app.theme&&ct("i",null,ct("svg",{xmlns:"http://www.w3.org/2000/svg",height:"24px",viewBox:"0 0 24 24",width:"24px",fill:"currentColor"},ct("path",{d:"M0 0h24v24H0V0z",fill:"none"}),ct("path",{d:"M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"}))),e.params.popupCloseLinkText&&ct("span",null,e.params.popupCloseLinkText)))))}renderToolbar(){const e=this;if(e.params.renderToolbar)return e.params.renderToolbar.call(e);const t=e.params.iconsColor;return ct("div",{class:"toolbar toolbar-bottom tabbar"},ct("div",{class:"toolbar-inner"},ct("a",{class:"link photo-browser-prev"},ct("i",{class:"icon icon-back "+(t?`color-${t}`:"")})),ct("a",{class:"link photo-browser-next"},ct("i",{class:"icon icon-forward "+(t?`color-${t}`:"")}))))}renderThumbs(){const e=this;return ct("div",{class:"toolbar toolbar-bottom photo-browser-thumbs"},ct("div",{class:"swiper"},ct("div",{class:"swiper-wrapper"},e.params.thumbs.map(((t,a)=>e.renderThumb(t,a))))))}renderCaption(e,t){const a=this;return a.params.renderCaption?a.params.renderCaption.call(a,e,t):ct("div",{class:"photo-browser-caption","data-caption-index":t},e)}renderObject(e,t){const a=this;return a.params.renderObject?a.params.renderObject.call(a,e,t):ct("div",{class:"photo-browser-slide photo-browser-object-slide swiper-slide","data-swiper-slide-index":t},e.html?e.html:e)}renderLazyPhoto(e,t){const a=this;return a.params.renderLazyPhoto?a.params.renderLazyPhoto.call(a,e,t):ct("div",{class:"photo-browser-slide photo-browser-slide-lazy swiper-slide","data-swiper-slide-index":t},ct("div",{class:"swiper-lazy-preloader"}),ct("span",{class:"swiper-zoom-container"},ct("img",{loading:"lazy",src:e.url?e.url:e})))}renderPhoto(e,t){const a=this;return a.params.renderPhoto?a.params.renderPhoto.call(a,e,t):ct("div",{class:"photo-browser-slide swiper-slide","data-swiper-slide-index":t},ct("span",{class:"swiper-zoom-container"},ct("img",{src:e.url?e.url:e})))}renderThumb(e,t){const a=this,r="string"==typeof e?e:e.url;return a.params.renderThumb?a.params.renderThumb.call(a,e,t):ct("div",{class:"photo-browser-thumbs-slide swiper-slide","data-swiper-slide-index":t},r&&ct("img",{src:r,loading:"lazy"}))}render(){const e=this;return e.params.render?e.params.render.call(e,e.params):ct("div",{class:`photo-browser photo-browser-${e.params.theme}`},ct("div",{class:"view"},ct("div",{class:`page photo-browser-page photo-browser-page-${e.params.theme} no-toolbar ${e.params.navbar?"":"no-navbar"}`,"data-name":"photo-browser-page"},e.params.navbar&&e.renderNavbar(),e.params.toolbar&&e.renderToolbar(),e.params.thumbs&&e.params.thumbs.length&&e.renderThumbs(),ct("div",{class:`photo-browser-captions photo-browser-captions-${e.params.captionsTheme||e.params.theme}`},e.params.photos.map(((t,a)=>t.caption?e.renderCaption(t.caption,a):""))),ct("div",{class:"photo-browser-swiper-container swiper"},ct("div",{class:"photo-browser-swiper-wrapper swiper-wrapper"},!e.params.virtualSlides&&e.params.photos.map(((t,a)=>t.html||("string"==typeof t||t instanceof String)&&t.indexOf("<")>=0&&t.indexOf(">")>=0?e.renderObject(t,a):!0===e.params.lazy?e.renderLazyPhoto(t,a):e.renderPhoto(t,a))))))))}renderStandalone(){const e=this;if(e.params.renderStandalone)return e.params.renderStandalone.call(e);return`<div class="popup photo-browser-popup photo-browser-standalone popup-tablet-fullscreen">${e.render()}</div>`}renderPage(){const e=this;if(e.params.renderPage)return e.params.renderPage.call(e);return e.render()}renderPopup(){const e=this;if(e.params.renderPopup)return e.params.renderPopup.call(e);return`<div class="popup photo-browser-popup">${e.render()}</div>`}onOpen(e,t){const a=this,r=a.app,s=A(t);s[0].f7PhotoBrowser=a,a.$el=s,a.el=s[0],a.openedIn=e,a.opened=!0,a.$swiperContainerEl=a.$el.find(".photo-browser-swiper-container"),a.$swiperWrapperEl=a.$el.find(".photo-browser-swiper-wrapper"),a.slides=a.$el.find(".photo-browser-slide"),a.$captionsContainerEl=a.$el.find(".photo-browser-captions"),a.captions=a.$el.find(".photo-browser-caption");const n=a.params.thumbs&&a.params.thumbs.length>0;let i,l,c;const p=a.activeIndex,d=Fe({},a.params.swiper,{initialSlide:p,on:{click(e){clearTimeout(i),a.params.exposition&&(i=setTimeout((()=>{a.expositionToggle()}),350)),a.emit("local::tap",e),a.emit("local::click",e)},doubleClick(e){clearTimeout(i),a.emit("local::doubleTap",e),a.emit("local::doubleClick",e)},slideChange(){n&&a.thumbsSwiper&&!c&&(l=!0,a.thumbsSwiper.slideTo(a.swiper.activeIndex),setTimeout((()=>{l=!1}))),a.onSlideChange(this);for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];a.emit("local::slideChange",...t)},transitionStart(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];a.emit("local::transitionStart",...t)},transitionEnd(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];a.emit("local::transitionEnd",...t)},slideChangeTransitionStart(){a.onSlideChange(this);for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];a.emit("local::slideChangeTransitionStart",...t)},slideChangeTransitionEnd(){for(var e=arguments.length,t=new Array(e),r=0;r<e;r++)t[r]=arguments[r];a.emit("local::slideChangeTransitionEnd",...t)}}});a.params.swipeToClose&&"page"!==a.params.type&&Fe(d.on,{touchStart(e,t){a.onTouchStart(t),a.emit("local::touchStart",t)},touchMoveOpposite(e,t){a.onTouchMove(t),a.emit("local::touchMoveOpposite",t)},touchEnd(e,t){a.onTouchEnd(t),a.emit("local::touchEnd",t)}}),a.params.virtualSlides&&Fe(d,{virtual:{slides:a.params.photos,renderSlide:(e,t)=>e.html||("string"==typeof e||e instanceof String)&&e.indexOf("<")>=0&&e.indexOf(">")>=0?a.renderObject(e,t):!0===a.params.lazy?a.renderLazyPhoto(e,t):a.renderPhoto(e,t)}});const u=o();if(a.swiper=r.swiper?r.swiper.create(a.$swiperContainerEl[0],d):new u.Swiper(a.$swiperContainerEl[0],d),(0===a.activeIndex||a.params.virtualSlides)&&a.onSlideChange(a.swiper),n){const e={el:a.$el.find(".photo-browser-thumbs .swiper")[0],slidesPerView:"auto",centeredSlides:!0,spaceBetween:4,watchSlidesProgress:!0,initialSlide:p,on:{touchMove(){c=!0},touchEnd(){c=!1},slideChange(e){l||a.swiper.slideTo(e.activeIndex,0)},click(e){if(!e.clickedSlide)return;const t=parseInt(A(e.clickedSlide).attr("data-swiper-slide-index"),10);e.slideTo(t,0)}}};a.thumbsSwiper=r.swiper?r.swiper.create(e):new u.Swiper(e)}a.$el&&a.$el.trigger("photobrowser:open"),a.emit("local::open photoBrowserOpen",a)}onOpened(){const e=this;e.$el&&"standalone"===e.params.type&&e.$el.css("animation","none"),e.$el&&e.$el.trigger("photobrowser:opened"),e.emit("local::opened photoBrowserOpened",e)}onClose(){const e=this;e.destroyed||(e.swiper&&e.swiper.destroy&&(e.swiper.destroy(!0,!1),e.swiper=null,delete e.swiper),e.thumbsSwiper&&e.thumbsSwiper.destroy&&(e.thumbsSwiper.destroy(!0,!1),e.thumbsSwiper=null,delete e.thumbsSwiper),e.$el&&e.$el.trigger("photobrowser:close"),e.emit("local::close photoBrowserClose",e))}onClosed(){const e=this;e.destroyed||(e.opened=!1,e.$el=null,e.el=null,delete e.$el,delete e.el,e.$el&&e.$el.trigger("photobrowser:closed"),e.emit("local::closed photoBrowserClosed",e))}openPage(){const e=this;if(e.opened)return e;const t=e.renderPage();return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn(t,a){e.view.$el.addClass(`with-photo-browser-page with-photo-browser-page-${e.params.theme}`),e.onOpen("page",a.el)},pageAfterIn(t,a){e.onOpened("page",a.el)},pageBeforeOut(t,a){e.view.$el.removeClass(`with-photo-browser-page with-photo-browser-page-exposed with-photo-browser-page-${e.params.theme}`),e.onClose("page",a.el)},pageAfterOut(t,a){e.onClosed("page",a.el)}}}}),e}openStandalone(){const e=this;if(e.opened)return e;const t={backdrop:!1,content:e.renderStandalone(),on:{popupOpen(t){e.onOpen("popup",t.el)},popupOpened(t){e.onOpened("popup",t.el)},popupClose(t){e.onClose("popup",t.el)},popupClosed(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e}openPopup(){const e=this;if(e.opened)return e;const t={content:e.renderPopup(),push:e.params.popupPush,closeByBackdropClick:e.params.closeByBackdropClick,on:{popupOpen(t){e.onOpen("popup",t.el)},popupOpened(t){e.onOpened("popup",t.el)},popupClose(t){e.onClose("popup",t.el)},popupClosed(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e}expositionEnable(){const e=this;return"page"===e.params.type&&e.view.$el.addClass("with-photo-browser-page-exposed"),e.$el&&e.$el.addClass("photo-browser-exposed"),e.params.expositionHideCaptions&&e.$captionsContainerEl.addClass("photo-browser-captions-exposed"),e.exposed=!0,e}expositionDisable(){const e=this;return"page"===e.params.type&&e.view.$el.removeClass("with-photo-browser-page-exposed"),e.$el&&e.$el.removeClass("photo-browser-exposed"),e.params.expositionHideCaptions&&e.$captionsContainerEl.removeClass("photo-browser-captions-exposed"),e.exposed=!1,e}expositionToggle(){const e=this;return"page"===e.params.type&&e.view.$el.toggleClass("with-photo-browser-page-exposed"),e.$el&&e.$el.toggleClass("photo-browser-exposed"),e.params.expositionHideCaptions&&e.$captionsContainerEl.toggleClass("photo-browser-captions-exposed"),e.exposed=!e.exposed,e}open(e){const t=this,a=t.params.type;return t.opened?(t.swiper&&void 0!==e&&t.swiper.slideTo(parseInt(e,10)),t):(void 0!==e&&(t.activeIndex=e),"standalone"===a&&t.openStandalone(),"page"===a&&t.openPage(),"popup"===a&&t.openPopup(),t)}close(){const e=this;return e.opened?(e.params.routableModals&&e.view||"page"===e.openedIn?e.view.router.back():(e.modal.once("modalClosed",(()=>{Le((()=>{e.destroyed||(e.modal.destroy(),delete e.modal)}))})),e.modal.close()),e):e}init(){}destroy(){let e=this;e.emit("local::beforeDestroy photoBrowserBeforeDestroy",e),e.$el&&(e.$el.trigger("photobrowser:beforedestroy"),e.$el[0].f7PhotoBrowser=null,delete e.$el[0].f7PhotoBrowser),Ie(e),e.destroyed=!0,e=null}};var Uo={name:"photoBrowser",params:{photoBrowser:{photos:[],thumbs:[],exposition:!0,expositionHideCaptions:!1,type:"standalone",navbar:!0,toolbar:!0,theme:"light",captionsTheme:void 0,iconsColor:void 0,popupPush:!1,swipeToClose:!0,pageBackLinkText:"Back",popupCloseLinkText:void 0,popupCloseLinkIcon:!0,navbarOfText:"of",navbarShowCount:void 0,view:void 0,url:"photos/",routableModals:!1,virtualSlides:!0,lazy:!0,closeByBackdropClick:!0,renderNavbar:void 0,renderToolbar:void 0,renderCaption:void 0,renderObject:void 0,renderLazyPhoto:void 0,renderPhoto:void 0,renderThumb:void 0,renderPage:void 0,renderPopup:void 0,renderStandalone:void 0,swiper:{cssMode:!1,initialSlide:0,spaceBetween:20,speed:300,loop:!1,keyboard:{enabled:!0},navigation:{nextEl:".photo-browser-next",prevEl:".photo-browser-prev"},zoom:{enabled:!0,maxRatio:3,minRatio:1}}}},create(){this.photoBrowser=nt({defaultSelector:".photo-browser-popup, .photo-browser-page",constructor:Xo,app:this,domProp:"f7PhotoBrowser"})},static:{PhotoBrowser:Xo}};let Go=class extends Ua{constructor(e,t){const a=Fe({on:{}},e.params.notification,t);super(e,a);const r=this;r.app=e,r.params=a;const{icon:s,title:o,titleRightText:n,subtitle:i,text:l,closeButton:c,closeTimeout:p,cssClass:d,closeOnClick:u}=r.params;let h,m,f,g,v,b,w;if(r.params.el)h=A(r.params.el);else{const e=r.render({icon:s,title:o,titleRightText:n,subtitle:i,text:l,closeButton:c,cssClass:d});h=A(e)}if(h&&h.length>0&&h[0].f7Modal)return h[0].f7Modal;if(0===h.length)return r.destroy();Fe(r,{$el:h,el:h[0],type:"notification"}),h[0].f7Modal=r,c&&h.find(".notification-close-button").on("click",(()=>{r.close()})),h.on("click",(e=>{c&&A(e.target).closest(".notification-close-button").length||(r.emit("local::click notificationClick",r),u&&r.close())})),r.on("beforeDestroy",(()=>{h.off("click")}));const y={};function C(e){m||(m=!0,f=!1,g=void 0,b=Ae(),y.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,y.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY)}function E(e){if(!m)return;const t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===g&&(g=!!(g||Math.abs(a-y.y)<Math.abs(t-y.x))),g)return void(m=!1);e.preventDefault(),f||(r.$el.removeClass("notification-transitioning"),r.$el.transition(0),w=r.$el[0].offsetHeight/2),f=!0,v=a-y.y;let s=v;v>0&&(s=v**.8),r.$el.transform(`translate3d(0, ${s}px, 0)`)}function k(){if(!m||!f)return m=!1,void(f=!1);if(m=!1,f=!1,0===v)return;const e=Ae()-b;r.$el.transition(""),r.$el.addClass("notification-transitioning"),r.$el.transform(""),(v<-10&&e<300||-v>=w/1)&&r.close()}let $;function x(){$=Le((()=>{m&&f?x():r.close()}),p)}return r.on("open",(()=>{r.params.swipeToClose&&(r.$el.on(e.touchEvents.start,C,{passive:!0}),e.on("touchmove:active",E),e.on("touchend:passive",k)),A(".notification.modal-in").each((t=>{const a=e.notification.get(t);t!==r.el&&a&&a.close()})),p&&x()})),r.on("close beforeDestroy",(()=>{r.params.swipeToClose&&(r.$el.off(e.touchEvents.start,C,{passive:!0}),e.off("touchmove:active",E),e.off("touchend:passive",k)),clearTimeout($)})),r}render(){const e=this;if(e.params.render)return e.params.render.call(e,e);const{icon:t,title:a,titleRightText:r,subtitle:s,text:o,closeButton:n,cssClass:i}=e.params;return ct("div",{class:`notification ${t?"notification-with-icon":""} ${i||""}`},ct("div",{class:"notification-header"},t&&ct("div",{class:"notification-icon"},t),a&&ct("div",{class:"notification-title"},a),r&&ct("div",{class:"notification-title-right-text"},r),n&&ct("span",{class:"notification-close-button"})),ct("div",{class:"notification-content"},s&&ct("div",{class:"notification-subtitle"},s),o&&ct("div",{class:"notification-text"},o)))}};var Ko={name:"notification",static:{Notification:Go},create(){this.notification=Fe({},it({app:this,constructor:Go,defaultSelector:".notification.modal-in"}))},params:{notification:{icon:null,title:null,titleRightText:null,subtitle:null,text:null,closeButton:!1,closeTimeout:null,closeOnClick:!1,swipeToClose:!0,cssClass:null,render:null,containerEl:null}}};let Qo=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this;a.app=e;const r=rt(),s=Fe({on:{}},e.params.autocomplete);let o,n;a.useModulesParams(s),a.params=Fe(s,t),a.params.openerEl&&(o=A(a.params.openerEl),o.length&&(o[0].f7Autocomplete=a)),a.params.inputEl&&(n=A(a.params.inputEl),n.length&&(n[0].f7Autocomplete=a));const i=Se();let l=t.url;!l&&o&&o.length&&(o.attr("href")?l=o.attr("href"):o.find("a").length>0&&(l=o.find("a").attr("href"))),l&&"#"!==l&&""!==l||(l=a.params.url);const c=a.params.multiple?"checkbox":"radio";Fe(a,{$openerEl:o,openerEl:o&&o[0],$inputEl:n,inputEl:n&&n[0],id:i,url:l,value:a.params.value||[],inputType:c,inputName:`${c}-${i}`,$modalEl:void 0,$dropdownEl:void 0});let p="";function d(){let e=a.$inputEl.val().trim();a.params.source&&a.params.source.call(a,e,(t=>{let r="";const s=a.params.limit?Math.min(a.params.limit,t.length):t.length;let o,i,l;a.items=t,a.params.highlightMatches&&(e=e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),o=new RegExp(`(${e})`,"i"));for(let e=0;e<s;e+=1){const s="object"==typeof t[e]?t[e][a.params.valueProperty]:t[e],n="object"==typeof t[e]?t[e][a.params.textProperty]:t[e];0===e&&(i=s,l=a.items[e]),r+=a.renderItem({value:s,text:a.params.highlightMatches?n.replace(o,"<b>$1</b>"):n},e)}if(""===r&&""===e&&a.params.dropdownPlaceholderText&&(r+=a.renderItem({placeholder:!0,text:a.params.dropdownPlaceholderText})),a.$dropdownEl.find("ul").html(r),a.params.typeahead){if(!i||!l)return;if(0!==i.toLowerCase().indexOf(e.toLowerCase()))return;if(p.toLowerCase()===e.toLowerCase())return void(a.value=[]);if(0===p.toLowerCase().indexOf(e.toLowerCase()))return p=e,void(a.value=[]);n.val(i),n[0].setSelectionRange(e.length,i.length);const t="object"==typeof a.value[0]?a.value[0][a.params.valueProperty]:a.value[0];t&&i.toLowerCase()===t.toLowerCase()||(a.value=[l],a.emit("local::change autocompleteChange",[l]))}p=e}))}function u(){const e=this,t=e.value;let r,s,o;if(A(e).parents(".autocomplete-values").length>0){if("checkbox"===a.inputType&&!e.checked){for(let e=0;e<a.value.length;e+=1)o="string"==typeof a.value[e]?a.value[e]:a.value[e][a.params.valueProperty],o!==t&&1*o!=1*t||a.value.splice(e,1);a.updateValues(),a.emit("local::change autocompleteChange",a.value)}}else{for(let e=0;e<a.items.length;e+=1)s="object"==typeof a.items[e]?a.items[e][a.params.valueProperty]:a.items[e],s!==t&&1*s!=1*t||(r=a.items[e]);if("radio"===a.inputType)a.value=[r];else if(e.checked)a.value.push(r);else for(let e=0;e<a.value.length;e+=1)o="object"==typeof a.value[e]?a.value[e][a.params.valueProperty]:a.value[e],o!==t&&1*o!=1*t||a.value.splice(e,1);a.updateValues(),("radio"===a.inputType&&e.checked||"checkbox"===a.inputType)&&a.emit("local::change autocompleteChange",a.value)}}function h(e){const t=A(e.target);t.is(a.$inputEl[0])||a.$dropdownEl&&t.closest(a.$dropdownEl[0]).length||a.close()}function m(){a.open()}function f(){a.open()}function g(){a.$dropdownEl.find("label.active-state").length>0||setTimeout((()=>{a.close()}),0)}function v(){a.positionDropdown()}function b(e){if(!a.opened)return;if(27===e.keyCode)return e.preventDefault(),void a.$inputEl.blur();if(13===e.keyCode){const t=a.$dropdownEl.find(".autocomplete-dropdown-selected label");return t.length?(e.preventDefault(),t.trigger("click"),void a.$inputEl.blur()):void(a.params.typeahead&&(e.preventDefault(),a.$inputEl.blur()))}if(40!==e.keyCode&&38!==e.keyCode)return;e.preventDefault();const t=a.$dropdownEl.find(".autocomplete-dropdown-selected");let r;t.length?(r=t[40===e.keyCode?"next":"prev"]("li"),r.length||(r=a.$dropdownEl.find("li").eq(40===e.keyCode?0:a.$dropdownEl.find("li").length-1))):r=a.$dropdownEl.find("li").eq(40===e.keyCode?0:a.$dropdownEl.find("li").length-1),r.hasClass("autocomplete-dropdown-placeholder")||(t.removeClass("autocomplete-dropdown-selected"),r.addClass("autocomplete-dropdown-selected"))}function w(){const e=A(this);let t;for(let r=0;r<a.items.length;r+=1){const s="object"==typeof a.items[r]?a.items[r][a.params.valueProperty]:a.items[r],o=e.attr("data-value");s!==o&&1*s!=1*o||(t=a.items[r])}a.params.updateInputValueOnSelect&&(a.$inputEl.val("object"==typeof t?t[a.params.valueProperty]:t),a.$inputEl.trigger("input change")),a.value=[t],a.emit("local::change autocompleteChange",[t]),a.close()}return a.attachEvents=function(){"dropdown"!==a.params.openIn&&a.$openerEl&&a.$openerEl.on("click",m),"dropdown"===a.params.openIn&&a.$inputEl&&(a.$inputEl.on("focus",f),a.$inputEl.on(a.params.inputEvents,d),r.android?A("html").on("click",h):a.$inputEl.on("blur",g),a.$inputEl.on("keydown",b))},a.detachEvents=function(){"dropdown"!==a.params.openIn&&a.$openerEl&&a.$openerEl.off("click",m),"dropdown"===a.params.openIn&&a.$inputEl&&(a.$inputEl.off("focus",f),a.$inputEl.off(a.params.inputEvents,d),r.android?A("html").off("click",h):a.$inputEl.off("blur",g),a.$inputEl.off("keydown",b))},a.attachDropdownEvents=function(){a.$dropdownEl.on("click","label",w),e.on("resize",v)},a.detachDropdownEvents=function(){a.$dropdownEl.off("click","label",w),e.off("resize",v)},a.attachPageEvents=function(){a.$el.on("change",'input[type="radio"], input[type="checkbox"]',u),a.params.closeOnSelect&&!a.params.multiple&&a.$el.once("click",".list label",(()=>{Le((()=>{a.close()}))}))},a.detachPageEvents=function(){a.$el.off("change",'input[type="radio"], input[type="checkbox"]',u)},a.useModules(),a.init(),a}get view(){const e=this,{$openerEl:t,$inputEl:a,app:r}=e;let s;if(e.params.view)s=e.params.view;else if(t||a){const e=t||a;s=e.closest(".view").length&&e.closest(".view")[0].f7View}return s||(s=r.views.main),s}positionDropdown(){const{$inputEl:e,app:t,$dropdownEl:a}=this,r=e.parents(".page-content");if(0===r.length)return;const s=e.offset(),o=e[0].offsetWidth,n=e[0].offsetHeight,i=e.parents(".list");let l;i.parents().each((e=>{if(l)return;const t=A(e);t.parent(r).length&&(l=t)}));const c=i.offset(),p=parseInt(r.css("padding-bottom"),10),d=i.length>0?c.left-r.offset().left:0,u=s.left-(i.length>0?c.left:0)-(t.rtl,0),h=s.top-(r.offset().top-r[0].scrollTop),m=r[0].scrollHeight-p-(h+r[0].scrollTop)-e[0].offsetHeight,f=t.rtl?"padding-right":"padding-left";let g;i.length&&(g=(t.rtl?i[0].offsetWidth-u-o:u)-("md"===t.theme?16:15)),a.css({left:`${i.length>0?d:u}px`,top:`${h+r[0].scrollTop+n}px`,width:`${i.length>0?i[0].offsetWidth:o}px`}),a.children(".autocomplete-dropdown-inner").css({maxHeight:`${m}px`,[f]:i.length>0?`${g}px`:""})}focus(){this.$el.find("input[type=search]").focus()}source(e){const t=this;if(!t.params.source)return;const{$el:a}=t;t.params.source.call(t,e,(r=>{let s="";const o=t.params.limit?Math.min(t.params.limit,r.length):r.length;t.items=r;for(let e=0;e<o;e+=1){let a=!1;const o="object"==typeof r[e]?r[e][t.params.valueProperty]:r[e];for(let e=0;e<t.value.length;e+=1){const r="object"==typeof t.value[e]?t.value[e][t.params.valueProperty]:t.value[e];r!==o&&1*r!=1*o||(a=!0)}s+=t.renderItem({value:o,text:"object"==typeof r[e]?r[e][t.params.textProperty]:r[e],inputType:t.inputType,id:t.id,inputName:t.inputName,selected:a},e)}a.find(".autocomplete-found ul").html(s),0===r.length?0!==e.length?(a.find(".autocomplete-not-found").show(),a.find(".autocomplete-found, .autocomplete-values").hide()):(a.find(".autocomplete-values").show(),a.find(".autocomplete-found, .autocomplete-not-found").hide()):(a.find(".autocomplete-found").show(),a.find(".autocomplete-not-found, .autocomplete-values").hide())}))}updateValues(){const e=this;let t="";for(let a=0;a<e.value.length;a+=1)t+=e.renderItem({value:"object"==typeof e.value[a]?e.value[a][e.params.valueProperty]:e.value[a],text:"object"==typeof e.value[a]?e.value[a][e.params.textProperty]:e.value[a],inputType:e.inputType,id:e.id,inputName:`${e.inputName}-checked}`,selected:!0},a);e.$el.find(".autocomplete-values ul").html(t)}preloaderHide(){const e=this;"dropdown"===e.params.openIn&&e.$dropdownEl?e.$dropdownEl.find(".autocomplete-preloader").removeClass("autocomplete-preloader-visible"):A(".autocomplete-preloader").removeClass("autocomplete-preloader-visible")}preloaderShow(){const e=this;"dropdown"===e.params.openIn&&e.$dropdownEl?e.$dropdownEl.find(".autocomplete-preloader").addClass("autocomplete-preloader-visible"):A(".autocomplete-preloader").addClass("autocomplete-preloader-visible")}renderPreloader(){const e=this,t={iosPreloaderContent:Me,mdPreloaderContent:Pe};return ct("div",{class:"autocomplete-preloader preloader "+(e.params.preloaderColor?`color-${e.params.preloaderColor}`:"")},t[`${e.app.theme}PreloaderContent`]||"")}renderSearchbar(){const e=this;return e.params.renderSearchbar?e.params.renderSearchbar.call(e):ct("form",{class:"searchbar"},ct("div",{class:"searchbar-inner"},ct("div",{class:"searchbar-input-wrap"},ct("input",{type:"search",spellcheck:e.params.searchbarSpellcheck||"false",placeholder:e.params.searchbarPlaceholder}),ct("i",{class:"searchbar-icon"}),ct("span",{class:"input-clear-button"})),e.params.searchbarDisableButton&&ct("span",{class:"searchbar-disable-button"},e.params.searchbarDisableText)))}renderItem(e,t){const a=this;if(a.params.renderItem)return a.params.renderItem.call(a,e,t);const r=e.value&&"string"==typeof e.value?e.value.replace(/"/g,"&quot;"):e.value;return"dropdown"!==a.params.openIn?ct("li",null,ct("label",{class:`item-${e.inputType} item-content`},ct("input",{type:e.inputType,name:e.inputName,value:r,_checked:e.selected}),ct("i",{class:`icon icon-${e.inputType}`}),ct("div",{class:"item-inner"},ct("div",{class:"item-title"},e.text)))):e.placeholder?ct("li",{class:"autocomplete-dropdown-placeholder"},ct("label",{class:"item-content"},ct("div",{class:"item-inner"},ct("div",{class:"item-title"},e.text)))):ct("li",null,ct("label",{class:"item-radio item-content","data-value":r},ct("div",{class:"item-inner"},ct("div",{class:"item-title"},e.text))))}renderNavbar(){const e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e);let t=e.params.pageTitle;void 0===t&&e.$openerEl&&e.$openerEl.length&&(t=e.$openerEl.find(".item-title").text().trim());const a="popup"===e.params.openIn,r=a?e.params.preloader&&ct("div",{class:"left"},e.renderPreloader()):ct("div",{class:"left sliding"},ct("a",{class:"link back"},ct("i",{class:"icon icon-back"}),ct("span",{class:"if-not-md"},e.params.pageBackLinkText))),s=a?ct("div",{class:"right"},ct("a",{class:"link popup-close","data-popup":".autocomplete-popup"},e.params.popupCloseLinkText)):e.params.preloader&&ct("div",{class:"right"},e.renderPreloader());return ct("div",{class:"navbar "+(e.params.navbarColorTheme?`color-${e.params.navbarColorTheme}`:"")},ct("div",{class:"navbar-bg"}),ct("div",{class:"navbar-inner "+(e.params.navbarColorTheme?`color-${e.params.navbarColorTheme}`:"")},r,t&&ct("div",{class:"title sliding"},t),s,ct("div",{class:"subnavbar sliding"},e.renderSearchbar())))}renderDropdown(){const e=this;return e.params.renderDropdown?e.params.renderDropdown.call(e,e.items):ct("div",{class:"autocomplete-dropdown"},ct("div",{class:"autocomplete-dropdown-inner"},ct("div",{class:"list no-safe-areas"},ct("ul",null))),e.params.preloader&&e.renderPreloader())}renderPage(e){const t=this;return t.params.renderPage?t.params.renderPage.call(t,t.items):ct("div",{class:"page page-with-subnavbar autocomplete-page","data-name":"autocomplete-page"},t.renderNavbar(e),ct("div",{class:"searchbar-backdrop"}),ct("div",{class:"page-content"},ct("div",{class:`list autocomplete-list autocomplete-found autocomplete-list-${t.id} ${t.params.formColorTheme?`color-${t.params.formColorTheme}`:""}`},ct("ul",null)),ct("div",{class:"list autocomplete-not-found"},ct("ul",null,ct("li",{class:"item-content"},ct("div",{class:"item-inner"},ct("div",{class:"item-title"},t.params.notFoundText))))),ct("div",{class:"list autocomplete-values"},ct("ul",null))))}renderPopup(){const e=this;return e.params.renderPopup?e.params.renderPopup.call(e,e.items):ct("div",{class:"popup autocomplete-popup"},ct("div",{class:"view"},e.renderPage(!0),";"))}onOpen(e,t){const a=this,r=a.app,s=A(t);if(a.$el=s,a.el=s[0],a.openedIn=e,a.opened=!0,"dropdown"===a.params.openIn)a.attachDropdownEvents(),a.$dropdownEl.addClass("autocomplete-dropdown-in"),a.$inputEl.trigger("input");else{let e=s.find(".searchbar");"page"===a.params.openIn&&"ios"===r.theme&&0===e.length&&(e=A(r.navbar.getElByPage(s)).find(".searchbar")),a.searchbar=r.searchbar.create({el:e,backdropEl:s.find(".searchbar-backdrop"),customSearch:!0,on:{search(e,t){0===t.length&&a.searchbar.enabled?a.searchbar.backdropShow():a.searchbar.backdropHide(),a.source(t)}}}),a.attachPageEvents(),a.updateValues(),a.params.requestSourceOnOpen&&a.source("")}a.emit("local::open autocompleteOpen",a)}autoFocus(){const e=this;return e.searchbar&&e.searchbar.$inputEl&&e.searchbar.$inputEl.focus(),e}onOpened(){const e=this;"dropdown"!==e.params.openIn&&e.params.autoFocus&&e.autoFocus(),e.emit("local::opened autocompleteOpened",e)}onClose(){const e=this;e.destroyed||(e.searchbar&&e.searchbar.destroy&&(e.searchbar.destroy(),e.searchbar=null,delete e.searchbar),"dropdown"===e.params.openIn?(e.detachDropdownEvents(),e.$dropdownEl.removeClass("autocomplete-dropdown-in").remove()):e.detachPageEvents(),e.emit("local::close autocompleteClose",e))}onClosed(){const e=this;e.destroyed||(e.opened=!1,e.$el=null,e.el=null,delete e.$el,delete e.el,e.emit("local::closed autocompleteClosed",e))}openPage(){const e=this;if(e.opened)return e;const t=e.renderPage();return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn(t,a){e.onOpen("page",a.el)},pageAfterIn(t,a){e.onOpened("page",a.el)},pageBeforeOut(t,a){e.onClose("page",a.el)},pageAfterOut(t,a){e.onClosed("page",a.el)}},options:{animate:e.params.animate}}}),e}openPopup(){const e=this;if(e.opened)return e;const t={content:e.renderPopup(),animate:e.params.animate,push:e.params.popupPush,swipeToClose:e.params.popupSwipeToClose,on:{popupOpen(t){e.onOpen("popup",t.el)},popupOpened(t){e.onOpened("popup",t.el)},popupClose(t){e.onClose("popup",t.el)},popupClosed(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(e.params.animate),e}openDropdown(){const e=this;e.$dropdownEl||(e.$dropdownEl=A(e.renderDropdown()));const t=e.$inputEl.parents(".page-content");e.params.dropdownContainerEl?A(e.params.dropdownContainerEl).append(e.$dropdownEl):0===t.length?e.$dropdownEl.insertAfter(e.$inputEl):(e.positionDropdown(),t.append(e.$dropdownEl)),e.onOpen("dropdown",e.$dropdownEl),e.onOpened("dropdown",e.$dropdownEl)}open(){const e=this;if(e.opened)return e;return e[`open${e.params.openIn.split("").map(((e,t)=>0===t?e.toUpperCase():e)).join("")}`](),e}close(){const e=this;return e.opened?("dropdown"===e.params.openIn?(e.onClose(),e.onClosed()):e.params.routableModals&&e.view||"page"===e.openedIn?e.view.router.back({animate:e.params.animate}):(e.modal.once("modalClosed",(()=>{Le((()=>{e.destroyed||(e.modal.destroy(),delete e.modal)}))})),e.modal.close()),e):e}init(){this.attachEvents()}destroy(){const e=this;e.emit("local::beforeDestroy autocompleteBeforeDestroy",e),e.detachEvents(),e.$inputEl&&e.$inputEl[0]&&delete e.$inputEl[0].f7Autocomplete,e.$openerEl&&e.$openerEl[0]&&delete e.$openerEl[0].f7Autocomplete,Ie(e),e.destroyed=!0}};var Jo={name:"autocomplete",params:{autocomplete:{openerEl:void 0,inputEl:void 0,view:void 0,dropdownContainerEl:void 0,dropdownPlaceholderText:void 0,typeahead:!1,highlightMatches:!0,updateInputValueOnSelect:!0,inputEvents:"input",value:void 0,multiple:!1,source:void 0,limit:void 0,valueProperty:"id",textProperty:"text",openIn:"page",pageBackLinkText:"Back",popupCloseLinkText:"Close",pageTitle:void 0,searchbarPlaceholder:"Search...",searchbarDisableText:"Cancel",searchbarDisableButton:!0,searchbarSpellcheck:!1,popupPush:!1,popupSwipeToClose:void 0,animate:!0,autoFocus:!1,closeOnSelect:!1,notFoundText:"Nothing found",requestSourceOnOpen:!1,preloaderColor:void 0,preloader:!1,formColorTheme:void 0,navbarColorTheme:void 0,routableModals:!1,url:"select/",renderDropdown:void 0,renderPage:void 0,renderPopup:void 0,renderItem:void 0,renderSearchbar:void 0,renderNavbar:void 0}},static:{Autocomplete:Qo},create(){const e=this;e.autocomplete=Fe(nt({defaultSelector:void 0,constructor:Qo,app:e,domProp:"f7Autocomplete"}),{open(t){const a=e.autocomplete.get(t);if(a&&a.open)return a.open()},close(t){const a=e.autocomplete.get(t);if(a&&a.close)return a.close()}})}};let Zo=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,s=tt(),o=Fe({},e.params.tooltip),n=r();a.useModulesParams(o),a.params=Fe(o,t),void 0===t.offset&&s.touch&&"hover"===a.params.trigger&&(a.params.offset=10);const{targetEl:i,containerEl:l}=a.params;if(!i&&!a.params.delegated)return a;const c=A(i);if(0===c.length&&!a.params.delegated)return a;if(c[0]&&c[0].f7Tooltip&&!a.params.delegated)return c[0].f7Tooltip;let p=A(l||e.$el).eq(0);0===p.length&&(p=e.$el);const d=A(a.render()).eq(0);Fe(a,{app:e,$targetEl:c,targetEl:c&&c[0],$containerEl:p,containerEl:p&&p[0],$el:d,el:d&&d[0],text:a.params.text||"",visible:!1,opened:!1}),c[0]&&(c[0].f7Tooltip=a);const u={};let h;function m(){a.opened?a.hide():a.show(this)}function f(e){a.opened&&(A(e.target).closest(c).length||A(e.target).closest(a.$el).length)||a.hide()}function g(e){h||(h=!0,u.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,u.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,a.show(this))}function v(e){if(!h)return;const t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,r="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;((t-u.x)**2+(r-u.y)**2)**.5>50&&(h=!1,a.hide())}function b(){h&&(h=!1,a.hide())}function w(){a.show(this)}function y(){a.hide()}function C(){d.hasClass("tooltip-in")||d.removeClass("tooltip-out").remove()}return a.attachEvents=function(){if(d.on("transitionend",C),"click"===a.params.trigger)return a.params.delegated?A(n).on("click",a.params.targetEl,m):a.$targetEl.on("click",m),void A("html").on("click",f);if("manual"!==a.params.trigger)if(s.touch){const t=!!s.passiveListener&&{passive:!0};a.params.delegated?A(n).on(e.touchEvents.start,a.params.targetEl,g,t):a.$targetEl.on(e.touchEvents.start,g,t),e.on("touchmove",v),e.on("touchend:passive",b)}else a.params.delegated?(A(n).on(s.pointerEvents?"pointerenter":"mouseenter",a.params.targetEl,w,!0),A(n).on(s.pointerEvents?"pointerleave":"mouseleave",a.params.targetEl,y,!0)):(a.$targetEl.on(s.pointerEvents?"pointerenter":"mouseenter",w),a.$targetEl.on(s.pointerEvents?"pointerleave":"mouseleave",y))},a.detachEvents=function(){if(d.off("transitionend",C),"click"===a.params.trigger)return a.params.delegated?A(n).on("click",a.params.targetEl,m):a.$targetEl.off("click",m),void A("html").off("click",f);if("manual"!==a.params.trigger)if(s.touch){const t=!!s.passiveListener&&{passive:!0};a.params.delegated?A(n).off(e.touchEvents.start,a.params.targetEl,g,t):a.$targetEl.off(e.touchEvents.start,g,t),e.off("touchmove",v),e.off("touchend:passive",b)}else a.params.delegated?(A(n).off(s.pointerEvents?"pointerenter":"mouseenter",a.params.targetEl,w,!0),A(n).off(s.pointerEvents?"pointerleave":"mouseleave",a.params.targetEl,y,!0)):(a.$targetEl.off(s.pointerEvents?"pointerenter":"mouseenter",w),a.$targetEl.off(s.pointerEvents?"pointerleave":"mouseleave",y))},a.useModules(),a.init(),a}setTargetEl(e){const t=this;return t.detachEvents(),t.$targetEl=A(e),t.targetEl=t.$targetEl[0],t.attachEvents(),t}position(e){const t=this,{$el:a,app:r,$containerEl:s}=t,o=!!t.params.containerEl,n=t.params.offset||0;a.css({left:"",top:""});const i=A(e||t.targetEl),[l,c]=[a.width(),a.height()];let p,d,u,h;a.css({left:"",top:""});const m=o&&s.length?s[0].getBoundingClientRect():r;if(i&&i.length>0){if(p=i.outerWidth(),d=i.outerHeight(),void 0===p&&void 0===d){const e=i[0].getBoundingClientRect();p=e.width,d=e.height}const e=i.offset();u=e.left-m.left,h=e.top-m.top;const t=i.parents(".page");t.length>0&&(h-=t[0].scrollTop)}let[f,g]=[0,0,0],v="top";c+n<h?g=h-c-n:c<m.height-h-d?(v="bottom",g=h+d+n):(v="middle",g=d/2+h-c/2,g<=0?g=8:g+c>=m.height&&(g=m.height-c-8)),"top"===v||"bottom"===v?(f=p/2+u-l/2,f<8&&(f=8),f+l>m.width&&(f=m.width-l-8),f<0&&(f=0)):"middle"===v&&(f=u-l,(f<8||f+l>m.width)&&(f<8&&(f=u+p),f+l>m.width&&(f=m.width-l-8))),a.css({top:`${g}px`,left:`${f}px`})}show(e){const t=this,{$el:a,$targetEl:r,$containerEl:s}=t;s[0]&&a[0]&&!s[0].contains(a[0])&&s.append(a),t.position(e);const o=A(e);return t.visible=!0,t.opened=!0,r.trigger("tooltip:show"),a.trigger("tooltip:show"),o.length&&o[0]!==r[0]&&o.trigger("tooltip:show"),t.emit("local::show tooltipShow",t),a.removeClass("tooltip-out").addClass("tooltip-in"),t}hide(){const e=this,{$el:t,$targetEl:a}=e;return e.visible=!1,e.opened=!1,a.trigger("tooltip:hide"),t.trigger("tooltip:hide"),e.emit("local::hide tooltipHide",e),t.addClass("tooltip-out").removeClass("tooltip-in"),e}render(){const e=this;if(e.params.render)return e.params.render.call(e,e);const{cssClass:t,text:a}=e.params;return`\n      <div class="tooltip ${t||""}">\n        <div class="tooltip-content">${a||""}</div>\n      </div>\n    `.trim()}setText(e){const t=this;return void 0===e||(t.params.text=e,t.text=e,t.$el&&t.$el.children(".tooltip-content").html(e),t.opened&&t.position()),t}init(){this.attachEvents()}destroy(){const e=this;e.$targetEl&&!e.destroyed&&(e.$targetEl.trigger("tooltip:beforedestroy"),e.emit("local::beforeDestroy tooltipBeforeDestroy",e),e.$el.remove(),e.$targetEl[0]&&delete e.$targetEl[0].f7Tooltip,e.detachEvents(),Ie(e),e.destroyed=!0)}};var en={name:"tooltip",static:{Tooltip:Zo},create(){const e=this;e.tooltip=nt({defaultSelector:".tooltip",constructor:Zo,app:e,domProp:"f7Tooltip"}),e.tooltip.show=function(e){const t=A(e);if(0===t.length)return;const a=t[0].f7Tooltip;return a?(a.show(t[0]),a):void 0},e.tooltip.hide=function(e){const t=A(e);if(0===t.length)return;const a=t[0].f7Tooltip;return a?(a.hide(),a):void 0},e.tooltip.setText=function(e,t){const a=A(e);if(0===a.length)return;const r=a[0].f7Tooltip;return r?(r.setText(t),r):void 0}},params:{tooltip:{targetEl:null,delegated:!1,text:null,cssClass:null,render:null,offset:0,trigger:"hover",containerEl:void 0}},on:{tabMounted(e){const t=this;A(e).find(".tooltip-init").each((e=>{const a=A(e).attr("data-tooltip");a&&t.tooltip.create({targetEl:e,text:a})}))},tabBeforeRemove(e){A(e).find(".tooltip-init").each((e=>{e.f7Tooltip&&e.f7Tooltip.destroy()}))},pageInit(e){const t=this;e.$el.find(".tooltip-init").each((e=>{const a=A(e).attr("data-tooltip");a&&t.tooltip.create({targetEl:e,text:a})})),"ios"===t.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".tooltip-init").each((e=>{const a=A(e).attr("data-tooltip");a&&t.tooltip.create({targetEl:e,text:a})}))},pageBeforeRemove(e){e.$el.find(".tooltip-init").each((e=>{e.f7Tooltip&&e.f7Tooltip.destroy()})),"ios"===this.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".tooltip-init").each((e=>{e.f7Tooltip&&e.f7Tooltip.destroy()}))}},vnode:{"tooltip-init":{insert(e){const t=e.elm,a=A(t).attr("data-tooltip");a&&this.tooltip.create({targetEl:t,text:a})},update(e){const t=e.elm;t.f7Tooltip&&e&&e.data&&e.data.attrs&&e.data.attrs["data-tooltip"]&&t.f7Tooltip.setText(e.data.attrs["data-tooltip"])},destroy(e){const t=e.elm;t.f7Tooltip&&t.f7Tooltip.destroy()}}}};let tn=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r=Fe({},e.params.gauge);a.useModulesParams(r),a.params=Fe(r,t);const{el:s}=a.params;if(!s)return a;const o=A(s);return 0===o.length?a:o[0].f7Gauge?o[0].f7Gauge:(Fe(a,{app:e,$el:o,el:o&&o[0]}),o[0].f7Gauge=a,a.useModules(),a.init(),a)}calcRadius(){const{size:e,borderWidth:t}=this.params;return e/2-t/2}calcBorderLength(){const e=this.calcRadius();return 2*Math.PI*e}render(){const e=this;if(e.params.render)return e.params.render.call(e,e);const{type:t,value:a,size:r,bgColor:s,borderBgColor:o,borderColor:n,borderWidth:i,valueText:l,valueTextColor:c,valueFontSize:p,valueFontWeight:d,labelText:u,labelTextColor:h,labelFontSize:m,labelFontWeight:f}=e.params,g="semicircle"===t,v=e.calcRadius(),b=e.calcBorderLength(),w=Math.max(Math.min(a,1),0);return ct("svg",{class:"gauge-svg",width:`${r}px`,height:`${g?r/2:r}px`,viewBox:`0 0 ${r} ${g?r/2:r}`},g&&ct("path",{class:"gauge-back-semi",d:`M${r-i/2},${r/2} a1,1 0 0,0 -${r-i},0`,stroke:o,"stroke-width":i,fill:s||"none"}),g&&ct("path",{class:"gauge-front-semi",d:`M${r-i/2},${r/2} a1,1 0 0,0 -${r-i},0`,stroke:n,"stroke-width":i,"stroke-dasharray":b/2,"stroke-dashoffset":b/2*(1+w),fill:o?"none":s||"none"}),!g&&o&&ct("circle",{class:"gauge-back-circle",stroke:o,"stroke-width":i,fill:s||"none",cx:r/2,cy:r/2,r:v}),!g&&ct("circle",{class:"gauge-front-circle",transform:`rotate(-90 ${r/2} ${r/2})`,stroke:n,"stroke-width":i,"stroke-dasharray":b,"stroke-dashoffset":b*(1-w),fill:o?"none":s||"none",cx:r/2,cy:r/2,r:v}),l&&ct("text",{class:"gauge-value-text",x:"50%",y:g?"100%":"50%","font-weight":d,"font-size":p,fill:c,dy:g?u?-m-15:-5:0,"text-anchor":"middle","dominant-baseline":!g&&"middle"},l),u&&ct("text",{class:"gauge-label-text",x:"50%",y:g?"100%":"50%","font-weight":f,"font-size":m,fill:h,dy:g?-5:l?p/2+10:0,"text-anchor":"middle","dominant-baseline":!g&&"middle"},u))}update(e){void 0===e&&(e={});const t=this,a=r(),{params:s,$svgEl:o}=t;if(Object.keys(e).forEach((t=>{void 0!==e[t]&&(s[t]=e[t])})),0===o.length)return t;const{value:n,size:i,bgColor:l,borderBgColor:c,borderColor:p,borderWidth:d,valueText:u,valueTextColor:h,valueFontSize:m,valueFontWeight:f,labelText:g,labelTextColor:v,labelFontSize:b,labelFontWeight:w}=s,y=t.calcBorderLength(),C=Math.max(Math.min(n,1),0),E=t.calcRadius(),k="semicircle"===s.type,$={width:`${i}px`,height:`${k?i/2:i}px`,viewBox:`0 0 ${i} ${k?i/2:i}`};if(Object.keys($).forEach((e=>{o.attr(e,$[e])})),k){const e={d:`M${i-d/2},${i/2} a1,1 0 0,0 -${i-d},0`,stroke:c,"stroke-width":d,fill:l||"none"},t={d:`M${i-d/2},${i/2} a1,1 0 0,0 -${i-d},0`,stroke:p,"stroke-width":d,"stroke-dasharray":y/2,"stroke-dashoffset":y/2*(1+C),fill:c?"none":l||"none"};Object.keys(e).forEach((t=>{o.find(".gauge-back-semi").attr(t,e[t])})),Object.keys(t).forEach((e=>{o.find(".gauge-front-semi").attr(e,t[e])}))}else{const e={stroke:c,"stroke-width":d,fill:l||"none",cx:i/2,cy:i/2,r:E},t={transform:`rotate(-90 ${i/2} ${i/2})`,stroke:p,"stroke-width":d,"stroke-dasharray":y,"stroke-dashoffset":y*(1-C),fill:c?"none":l||"none",cx:i/2,cy:i/2,r:E};Object.keys(e).forEach((t=>{o.find(".gauge-back-circle").attr(t,e[t])})),Object.keys(t).forEach((e=>{o.find(".gauge-front-circle").attr(e,t[e])}))}if(u){if(!o.find(".gauge-value-text").length){const e=a.createElementNS("http://www.w3.org/2000/svg","text");e.classList.add("gauge-value-text"),o.append(e)}const e={x:"50%",y:k?"100%":"50%","font-weight":f,"font-size":m,fill:h,dy:k?g?-b-15:-5:0,"text-anchor":"middle","dominant-baseline":!k&&"middle"};Object.keys(e).forEach((t=>{o.find(".gauge-value-text").attr(t,e[t])})),o.find(".gauge-value-text").text(u)}else o.find(".gauge-value-text").remove();if(g){if(!o.find(".gauge-label-text").length){const e=a.createElementNS("http://www.w3.org/2000/svg","text");e.classList.add("gauge-label-text"),o.append(e)}const e={x:"50%",y:k?"100%":"50%","font-weight":w,"font-size":b,fill:v,dy:k?-5:u?m/2+10:0,"text-anchor":"middle","dominant-baseline":!k&&"middle"};Object.keys(e).forEach((t=>{o.find(".gauge-label-text").attr(t,e[t])})),o.find(".gauge-label-text").text(g)}else o.find(".gauge-label-text").remove();return t}init(){const e=this,t=A(e.render()).eq(0);return t.f7Gauge=e,Fe(e,{$svgEl:t,svgEl:t&&t[0]}),e.$el.append(t),e}destroy(){const e=this;e.$el&&!e.destroyed&&(e.$el.trigger("gauge:beforedestroy"),e.emit("local::beforeDestroy gaugeBeforeDestroy",e),e.$svgEl.remove(),delete e.$el[0].f7Gauge,Ie(e),e.destroyed=!0)}};var an={name:"gauge",static:{Gauge:tn},create(){const e=this;e.gauge=nt({defaultSelector:".gauge",constructor:tn,app:e,domProp:"f7Gauge"}),e.gauge.update=function(t,a){if(0===A(t).length)return;const r=e.gauge.get(t);return r?(r.update(a),r):void 0}},params:{gauge:{el:null,type:"circle",value:0,size:200,bgColor:"transparent",borderBgColor:"#eeeeee",borderColor:"#000000",borderWidth:10,valueText:null,valueTextColor:"#000000",valueFontSize:31,valueFontWeight:500,labelText:null,labelTextColor:"#888888",labelFontSize:14,labelFontWeight:400}},on:{tabMounted(e){const t=this;A(e).find(".gauge-init").each((e=>{t.gauge.create(Fe({el:e},A(e).dataset()||{}))}))},tabBeforeRemove(e){A(e).find(".gauge-init").each((e=>{e.f7Gauge&&e.f7Gauge.destroy()}))},pageInit(e){const t=this;e.$el.find(".gauge-init").each((e=>{t.gauge.create(Fe({el:e},A(e).dataset()||{}))}))},pageBeforeRemove(e){e.$el.find(".gauge-init").each((e=>{e.f7Gauge&&e.f7Gauge.destroy()}))}},vnode:{"gauge-init":{insert(e){const t=e.elm;this.gauge.create(Fe({el:t},A(t).dataset()||{}))},destroy(e){const t=e.elm;t.f7Gauge&&t.f7Gauge.destroy()}}}},rn={render(e){const{sliderLabel:t,sliderValue:a,sliderValueEditable:r,alphaLabelText:s}=e.params;return ct("div",{class:"color-picker-module color-picker-module-alpha-slider"},ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},s),ct("div",{class:"range-slider color-picker-slider color-picker-slider-alpha"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"0.01",min:"0",max:"1",class:"color-picker-value-alpha"}):ct("span",{class:"color-picker-value-alpha"}))))},init(e){function t(t){const a=e.value.alpha;let r=parseFloat(t.target.value);Number.isNaN(r)?t.target.value=a:(r=Math.max(0,Math.min(1,r)),e.setValue({alpha:r}))}e.alphaRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-alpha"),min:0,max:1,step:.01,value:1,on:{change(t,a){const r=Math.floor(100*a)/100;e.setValue({alpha:r})}}}),e.$el.on("change",".color-picker-module-alpha-slider input",t),e.destroyAlphaSliderEvents=function(){e.$el.off("change",".color-picker-module-alpha-slider input",t)}},update(e){const{value:t}=e,{sliderValue:a,sliderValueEditable:r}=e.params,{alpha:s}=t;e.alphaRangeSlider.value=s,e.alphaRangeSlider.layout(),a&&r?e.$el.find("input.color-picker-value-alpha").val(s):e.$el.find("span.color-picker-value-alpha").text(s)},destroy(e){e.alphaRangeSlider&&e.alphaRangeSlider.destroy&&e.alphaRangeSlider.destroy(),delete e.alphaRangeSlider,e.destroyAlphaSliderEvents&&e.destroyAlphaSliderEvents(),delete e.destroyAlphaSliderEvents}},sn={render:()=>ct("div",{class:"color-picker-module color-picker-module-current-color"},ct("div",{class:"color-picker-current-color"})),update(e){e.$el.find(".color-picker-module-current-color .color-picker-current-color").css("background-color",e.value.hex)}},on={render(e){const{hexLabel:t,hexLabelText:a,hexValueEditable:r}=e.params;return ct("div",{class:"color-picker-module color-picker-module-hex"},ct("div",{class:"color-picker-hex-wrap"},t&&ct("div",{class:"color-picker-hex-label"},a),ct("div",{class:"color-picker-hex-value"},r?ct("input",{type:"text",class:"color-picker-value-hex"}):ct("span",{class:"color-picker-value-hex"}))))},init(e){function t(t){const a=e.value.hex;let r=t.target.value.replace(/#/g,"");if(Number.isNaN(r)||!r||3!==r.length&&6!==r.length)return void(t.target.value=a);const s=parseInt(r,16);s>parseInt("ffffff",16)&&(r="fff"),s<0&&(r="000"),e.setValue({hex:r})}e.$el.on("change",".color-picker-module-hex input",t),e.destroyHexEvents=function(){e.$el.off("change",".color-picker-module-hex input",t)}},update(e){const{value:t}=e,{hexValueEditable:a}=e.params,{hex:r}=t;a?e.$el.find("input.color-picker-value-hex").val(r):e.$el.find("span.color-picker-value-hex").text(r)},destroy(e){e.destroyHexEvents&&e.destroyHexEvents(),delete e.destroyHexEvents}},nn={render(e){const{sliderLabel:t,sliderValue:a,sliderValueEditable:r,hueLabelText:s,saturationLabelText:o,brightnessLabelText:n}=e.params;return ct("div",{class:"color-picker-module color-picker-module-hsb-sliders"},ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},s),ct("div",{class:"range-slider color-picker-slider color-picker-slider-hue"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"0.1",min:"0",max:"360",class:"color-picker-value-hue","data-color-index":"0"}):ct("span",{class:"color-picker-value-hue"}))),ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},o),ct("div",{class:"range-slider color-picker-slider color-picker-slider-saturation"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"0.1",min:"0",max:"100",class:"color-picker-value-saturation","data-color-index":"1"}):ct("span",{class:"color-picker-value-saturation"}))),ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},n),ct("div",{class:"range-slider color-picker-slider color-picker-slider-brightness"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"0.1",min:"0",max:"100",class:"color-picker-value-brightness","data-color-index":"2"}):ct("span",{class:"color-picker-value-brightness"}))))},init(e){function t(t){const a=[...e.value.hsb],r=parseInt(A(t.target).attr("data-color-index"),10);let s=parseFloat(t.target.value);Number.isNaN(s)?t.target.value=a[r]:(s=0===r?Math.max(0,Math.min(360,s)):Math.max(0,Math.min(100,s))/100,a[r]=s,e.setValue({hsb:a}))}e.hueRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-hue"),min:0,max:360,step:.1,value:0,on:{change(t,a){e.setValue({hue:a})}}}),e.saturationRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-saturation"),min:0,max:1,step:.001,value:0,on:{change(t,a){const r=Math.floor(1e3*a)/1e3;e.setValue({hsb:[e.value.hsb[0],r,e.value.hsb[2]]})}}}),e.brightnessRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-brightness"),min:0,max:1,step:.001,value:0,on:{change(t,a){const r=Math.floor(1e3*a)/1e3;e.setValue({hsb:[e.value.hsb[0],e.value.hsb[1],r]})}}}),e.$el.on("change",".color-picker-module-hsb-sliders input",t),e.destroyHsbSlidersEvents=function(){e.$el.off("change",".color-picker-module-hsb-sliders input",t)}},update(e){const{app:t,value:a}=e,{sliderValue:r,sliderValueEditable:s}=e.params,{hsb:o,hue:n}=a;e.hueRangeSlider.value=n,e.saturationRangeSlider.value=o[1],e.brightnessRangeSlider.value=o[2],e.hueRangeSlider.layout(),e.saturationRangeSlider.layout(),e.brightnessRangeSlider.layout();const i=We(o[0],o[1],1),l=We(o[0],0,1),c=We(o[0],1,1),p=o[2];e.hueRangeSlider.$el[0].style.setProperty("--f7-range-knob-color",`hsl(${n}, 100%, 50%)`),e.saturationRangeSlider.$el[0].style.setProperty("--f7-range-knob-color",`hsl(${i[0]}, ${100*i[1]}%, ${100*i[2]}%)`),e.brightnessRangeSlider.$el[0].style.setProperty("--f7-range-knob-color",`rgb(${255*p}, ${255*p}, ${255*p})`),e.saturationRangeSlider.$el.find(".range-bar").css("background-image",`linear-gradient(${t.rtl?"to left":"to right"}, hsl(${l[0]}, ${100*l[1]}%, ${100*l[2]}%), hsl(${c[0]}, ${100*c[1]}%, ${100*c[2]}%))`),r&&s?(e.$el.find("input.color-picker-value-hue").val(`${n}`),e.$el.find("input.color-picker-value-saturation").val(""+1e3*o[1]/10),e.$el.find("input.color-picker-value-brightness").val(""+1e3*o[2]/10)):r&&(e.$el.find("span.color-picker-value-hue").text(`${n}`),e.$el.find("span.color-picker-value-saturation").text(""+1e3*o[1]/10),e.$el.find("span.color-picker-value-brightness").text(""+1e3*o[2]/10))},destroy(e){e.hueRangeSlider&&e.hueRangeSlider.destroy&&e.hueRangeSlider.destroy(),e.saturationRangeSlider&&e.saturationRangeSlider.destroy&&e.saturationRangeSlider.destroy(),e.brightnessRangeSlider&&e.brightnessRangeSlider.destroy&&e.brightnessRangeSlider.destroy(),delete e.hueRangeSlider,delete e.saturationRangeSlider,delete e.brightnessRangeSlider,e.destroyHsbSlidersEvents&&e.destroyHsbSlidersEvents(),delete e.destroyHsbSlidersEvents}},ln={render(e){const{sliderLabel:t,sliderValue:a,sliderValueEditable:r,hueLabelText:s}=e.params;return ct("div",{class:"color-picker-module color-picker-module-hue-slider"},ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},s),ct("div",{class:"range-slider color-picker-slider color-picker-slider-hue"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"0.1",min:"0",max:"360",class:"color-picker-value-hue"}):ct("span",{class:"color-picker-value-hue"}))))},init(e){e.hueRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-hue"),min:0,max:360,step:.1,value:0,on:{change(t,a){e.setValue({hue:a})}}})},update(e){const{value:t}=e,{sliderValue:a,sliderValueEditable:r}=e.params,{hue:s}=t;e.hueRangeSlider.value=s,e.hueRangeSlider.layout(),e.hueRangeSlider.$el[0].style.setProperty("--f7-range-knob-color",`hsl(${s}, 100%, 50%)`),a&&r?e.$el.find("input.color-picker-value-hue").val(`${s}`):a&&e.$el.find("span.color-picker-value-hue").text(`${s}`)},destroy(e){e.hueRangeSlider&&e.hueRangeSlider.destroy&&e.hueRangeSlider.destroy(),delete e.hueRangeSlider}},cn={render(e){const{sliderLabel:t,sliderValue:a,sliderValueEditable:r,brightnessLabelText:s}=e.params;return ct("div",{class:"color-picker-module color-picker-module-brightness-slider"},ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},s),ct("div",{class:"range-slider color-picker-slider color-picker-slider-brightness"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"0.1",min:"0",max:"100",class:"color-picker-value-brightness"}):ct("span",{class:"color-picker-value-brightness"}))))},init(e){e.brightnessRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-brightness"),min:0,max:1,step:.001,value:0,on:{change(t,a){const r=Math.floor(1e3*a)/1e3;e.setValue({hsb:[e.value.hsb[0],e.value.hsb[1],r]})}}})},update(e){const{value:t,app:a}=e,{sliderValue:r,sliderValueEditable:s}=e.params,{hsb:o}=t;e.brightnessRangeSlider.value=o[2],e.brightnessRangeSlider.layout();const n=We(o[0],o[1],o[2]),i=We(o[0],o[1],0),l=We(o[0],o[1],1);e.brightnessRangeSlider.$el[0].style.setProperty("--f7-range-knob-color",`hsl(${n[0]}, ${100*n[1]}%, ${100*n[2]}%)`),e.brightnessRangeSlider.$el.find(".range-bar").css("background-image",`linear-gradient(${a.rtl?"to left":"to right"}, hsl(${i[0]}, ${100*i[1]}%, ${100*i[2]}%), hsl(${l[0]}, ${100*l[1]}%, ${100*l[2]}%))`),r&&s?e.$el.find("input.color-picker-value-brightness").val(""+1e3*o[2]/10):r&&e.$el.find("span.color-picker-value-brightness").text(""+1e3*o[2]/10)},destroy(e){e.brightnessRangeSlider&&e.brightnessRangeSlider.destroy&&e.brightnessRangeSlider.destroy(),delete e.brightnessRangeSlider}},pn={render:e=>ct("div",{class:"color-picker-module color-picker-module-palette"},ct("div",{class:"color-picker-palette"},e.params.palette.map((e=>{if(Array.isArray(e)){let t='<div class="color-picker-palette-row">';return t+=e.map((e=>`\n                <div class="color-picker-palette-value" data-palette-color="${e}" style="background-color: ${e}"></div>\n              `)).join(""),t+="</div>",t}return ct("div",{class:"color-picker-palette-value","data-palette-color":e,style:`background-color: ${e}`})})))),init(e){function t(t){const a=A(t.target).attr("data-palette-color");e.setValue({hex:a})}e.$el.on("click",".color-picker-module-palette .color-picker-palette-value",t),e.destroyPaletteEvents=function(){e.$el.off("click",".color-picker-module-hex input",t)}},destroy(e){e.destroyPaletteEvents&&e.destroyPaletteEvents(),delete e.destroyPaletteEvents}},dn={render:()=>ct("div",{class:"color-picker-module color-picker-module-initial-current-colors"},ct("div",{class:"color-picker-initial-current-colors"},ct("div",{class:"color-picker-initial-color"}),ct("div",{class:"color-picker-current-color"}))),init(e){function t(){if(e.initialValue){const{hex:t,alpha:a}=e.initialValue;e.setValue({hex:t,alpha:a})}}e.$el.on("click",".color-picker-initial-color",t),e.destroyInitialCurrentEvents=function(){e.$el.off("click",".color-picker-initial-color",t)}},update(e){e.$el.find(".color-picker-module-initial-current-colors .color-picker-initial-color").css("background-color",e.initialValue.hex),e.$el.find(".color-picker-module-initial-current-colors .color-picker-current-color").css("background-color",e.value.hex)},destroy(e){e.destroyInitialCurrentEvents&&e.destroyInitialCurrentEvents(),delete e.destroyInitialCurrentEvents}},un={render(e){const{barLabel:t,barValue:a,barValueEditable:r,redLabelText:s,greenLabelText:o,blueLabelText:n}=e.params;return ct("div",{class:"color-picker-module color-picker-module-rgb-bars"},ct("div",{class:"color-picker-bar-wrap"},t&&ct("div",{class:"color-picker-bar-label"},s),ct("div",{class:"range-slider color-picker-bar color-picker-bar-red"}),a&&ct("div",{class:"color-picker-bar-value"},r?ct("input",{type:"number",step:"1",min:"0",max:"255",class:"color-picker-value-bar-red","data-color-index":"0"}):ct("span",{class:"color-picker-value-bar-red"}))),ct("div",{class:"color-picker-bar-wrap"},t&&ct("div",{class:"color-picker-bar-label"},o),ct("div",{class:"range-slider color-picker-bar color-picker-bar-green"}),a&&ct("div",{class:"color-picker-bar-value"},r?ct("input",{type:"number",step:"1",min:"0",max:"255",class:"color-picker-value-bar-green","data-color-index":"1"}):ct("span",{class:"color-picker-value-bar-green"}))),ct("div",{class:"color-picker-bar-wrap"},t&&ct("div",{class:"color-picker-bar-label"},n),ct("div",{class:"range-slider color-picker-bar color-picker-bar-blue"}),a&&ct("div",{class:"color-picker-bar-value"},r?ct("input",{type:"number",step:"1",min:"0",max:"255",class:"color-picker-value-bar-blue","data-color-index":"2"}):ct("span",{class:"color-picker-value-bar-blue"}))))},init(e){function t(t){const a=[...e.value.rgb],r=parseInt(A(t.target).attr("data-color-index"),10);let s=parseInt(t.target.value,10);Number.isNaN(s)?t.target.value=a[r]:(s=Math.max(0,Math.min(255,s)),a[r]=s,e.setValue({rgb:a}))}e.redBar=e.app.range.create({el:e.$el.find(".color-picker-bar-red"),min:0,max:255,step:1,value:0,vertical:!0,on:{change(t,a){e.setValue({rgb:[a,e.value.rgb[1],e.value.rgb[2]]})}}}),e.greenBar=e.app.range.create({el:e.$el.find(".color-picker-bar-green"),min:0,max:255,step:1,value:0,vertical:!0,on:{change(t,a){e.setValue({rgb:[e.value.rgb[0],a,e.value.rgb[2]]})}}}),e.blueBar=e.app.range.create({el:e.$el.find(".color-picker-bar-blue"),min:0,max:255,step:1,value:0,vertical:!0,on:{change(t,a){e.setValue({rgb:[e.value.rgb[0],e.value.rgb[1],a]})}}}),e.$el.on("change",".color-picker-module-rgb-bars input",t),e.destroyRgbBarsEvents=function(){e.$el.off("change",".color-picker-module-rgb-bars input",t)}},update(e){const{value:t,redBar:a,greenBar:r,blueBar:s}=e,{barValue:o,barValueEditable:n}=e.params,{rgb:i}=t;a.value=i[0],r.value=i[1],s.value=i[2],a.layout(),r.layout(),s.layout(),a.$el.find(".range-bar").css("background-image",`linear-gradient(to top, rgb(0, ${i[1]}, ${i[2]}), rgb(255, ${i[1]}, ${i[2]}))`),r.$el.find(".range-bar").css("background-image",`linear-gradient(to top, rgb(${i[0]}, 0, ${i[2]}), rgb(${i[0]}, 255, ${i[2]}))`),s.$el.find(".range-bar").css("background-image",`linear-gradient(to top, rgb(${i[0]}, ${i[1]}, 0), rgb(${i[0]}, ${i[1]}, 255))`),o&&n?(e.$el.find("input.color-picker-value-bar-red").val(i[0]),e.$el.find("input.color-picker-value-bar-green").val(i[1]),e.$el.find("input.color-picker-value-bar-blue").val(i[2])):o&&(e.$el.find("span.color-picker-value-bar-red").text(i[0]),e.$el.find("span.color-picker-value-bar-green").text(i[1]),e.$el.find("span.color-picker-value-bar-blue").text(i[2]))},destroy(e){e.redBar&&e.redBar.destroy&&e.redBar.destroy(),e.greenBar&&e.greenBar.destroy&&e.greenBar.destroy(),e.blueBar&&e.blueBar.destroy&&e.blueBar.destroy(),delete e.redBar,delete e.greenBar,delete e.blueBar,e.destroyRgbBarsEvents&&e.destroyRgbBarsEvents(),delete e.destroyRgbBarsEvents}},hn={render(e){const{sliderLabel:t,sliderValue:a,sliderValueEditable:r,redLabelText:s,greenLabelText:o,blueLabelText:n}=e.params;return ct("div",{class:"color-picker-module color-picker-module-rgb-sliders"},ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},s),ct("div",{class:"range-slider color-picker-slider color-picker-slider-red"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"1",min:"0",max:"255",class:"color-picker-value-red","data-color-index":"0"}):ct("span",{class:"color-picker-value-red"}))),ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},o),ct("div",{class:"range-slider color-picker-slider color-picker-slider-green"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"1",min:"0",max:"255",class:"color-picker-value-green","data-color-index":"1"}):ct("span",{class:"color-picker-value-green"}))),ct("div",{class:"color-picker-slider-wrap"},t&&ct("div",{class:"color-picker-slider-label"},n),ct("div",{class:"range-slider color-picker-slider color-picker-slider-blue"}),a&&ct("div",{class:"color-picker-slider-value"},r?ct("input",{type:"number",step:"1",min:"0",max:"255",class:"color-picker-value-blue","data-color-index":"2"}):ct("span",{class:"color-picker-value-blue"}))))},init(e){function t(t){const a=[...e.value.rgb],r=parseInt(A(t.target).attr("data-color-index"),10);let s=parseInt(t.target.value,10);Number.isNaN(s)?t.target.value=a[r]:(s=Math.max(0,Math.min(255,s)),a[r]=s,e.setValue({rgb:a}))}e.redRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-red"),min:0,max:255,step:1,value:0,on:{change(t,a){e.setValue({rgb:[a,e.value.rgb[1],e.value.rgb[2]]})}}}),e.greenRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-green"),min:0,max:255,step:1,value:0,on:{change(t,a){e.setValue({rgb:[e.value.rgb[0],a,e.value.rgb[2]]})}}}),e.blueRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-blue"),min:0,max:255,step:1,value:0,on:{change(t,a){e.setValue({rgb:[e.value.rgb[0],e.value.rgb[1],a]})}}}),e.$el.on("change",".color-picker-module-rgb-sliders input",t),e.destroyRgbSlidersEvents=function(){e.$el.off("change",".color-picker-module-rgb-sliders input",t)}},update(e){const{app:t,value:a,redRangeSlider:r,greenRangeSlider:s,blueRangeSlider:o}=e,{sliderValue:n,sliderValueEditable:i}=e.params,{rgb:l}=a;r.value=l[0],s.value=l[1],o.value=l[2],r.layout(),s.layout(),o.layout(),r.$el[0].style.setProperty("--f7-range-knob-color",`rgb(${l[0]}, ${l[1]}, ${l[2]})`),s.$el[0].style.setProperty("--f7-range-knob-color",`rgb(${l[0]}, ${l[1]}, ${l[2]})`),o.$el[0].style.setProperty("--f7-range-knob-color",`rgb(${l[0]}, ${l[1]}, ${l[2]})`);const c=t.rtl?"to left":"to right";r.$el.find(".range-bar").css("background-image",`linear-gradient(${c}, rgb(0, ${l[1]}, ${l[2]}), rgb(255, ${l[1]}, ${l[2]}))`),s.$el.find(".range-bar").css("background-image",`linear-gradient(${c}, rgb(${l[0]}, 0, ${l[2]}), rgb(${l[0]}, 255, ${l[2]}))`),o.$el.find(".range-bar").css("background-image",`linear-gradient(${c}, rgb(${l[0]}, ${l[1]}, 0), rgb(${l[0]}, ${l[1]}, 255))`),n&&i?(e.$el.find("input.color-picker-value-red").val(l[0]),e.$el.find("input.color-picker-value-green").val(l[1]),e.$el.find("input.color-picker-value-blue").val(l[2])):n&&(e.$el.find("span.color-picker-value-red").text(l[0]),e.$el.find("span.color-picker-value-green").text(l[1]),e.$el.find("span.color-picker-value-blue").text(l[2]))},destroy(e){e.redRangeSlider&&e.redRangeSlider.destroy&&e.redRangeSlider.destroy(),e.greenRangeSlider&&e.greenRangeSlider.destroy&&e.greenRangeSlider.destroy(),e.blueRangeSlider&&e.blueRangeSlider.destroy&&e.blueRangeSlider.destroy(),delete e.redRangeSlider,delete e.greenRangeSlider,delete e.blueRangeSlider,e.destroyRgbSlidersEvents&&e.destroyRgbSlidersEvents(),delete e.destroyRgbSlidersEvents}},mn={render:()=>ct("div",{class:"color-picker-module color-picker-module-sb-spectrum"},ct("div",{class:"color-picker-sb-spectrum",style:"background-color: hsl(0, 100%, 50%)"},ct("div",{class:"color-picker-sb-spectrum-handle"}))),init(e){const{app:t}=e;let a,r,s,o,n,i,l,c;const{$el:p}=e;function d(t,a){let r=(t-i.left)/i.width,s=(a-i.top)/i.height;r=Math.max(0,Math.min(1,r)),s=1-Math.max(0,Math.min(1,s)),e.setValue({hsb:[e.value.hue,r,s]})}function u(e){if(a)return;r="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,o=r,s="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,n=s;const t=A(e.target);c=t.closest(".color-picker-sb-spectrum-handle").length>0,c||(l=t.closest(".color-picker-sb-spectrum").length>0),l&&(i=p.find(".color-picker-sb-spectrum")[0].getBoundingClientRect(),d(r,s)),(c||l)&&p.find(".color-picker-sb-spectrum-handle").addClass("color-picker-sb-spectrum-handle-pressed")}function h(e){(l||c)&&(o="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,n="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,e.preventDefault(),a||(a=!0,c&&(i=p.find(".color-picker-sb-spectrum")[0].getBoundingClientRect())),(l||c)&&d(o,n))}function m(){a=!1,(l||c)&&p.find(".color-picker-sb-spectrum-handle").removeClass("color-picker-sb-spectrum-handle-pressed"),l=!1,c=!1}function f(){e.modules["sb-spectrum"].update(e)}const g=!("touchstart"!==t.touchEvents.start||!tt().passiveListener)&&{passive:!0,capture:!1};e.$el.on(t.touchEvents.start,u,g),t.on("touchmove:active",h),t.on("touchend:passive",m),t.on("resize",f),e.destroySpectrumEvents=function(){e.$el.off(t.touchEvents.start,u,g),t.off("touchmove:active",h),t.off("touchend:passive",m),t.off("resize",f)}},update(e){const{value:t}=e,{hsl:a,hsb:r}=t,s=e.$el.find(".color-picker-sb-spectrum")[0].offsetWidth,o=e.$el.find(".color-picker-sb-spectrum")[0].offsetHeight;e.$el.find(".color-picker-sb-spectrum").css("background-color",`hsl(${a[0]}, 100%, 50%)`),e.$el.find(".color-picker-sb-spectrum-handle").css("background-color",`hsl(${a[0]}, ${100*a[1]}%, ${100*a[2]}%)`).transform(`translate(${s*r[1]}px, ${o*(1-r[2])}px)`)},destroy(e){e.destroySpectrumEvents&&e.destroySpectrumEvents(),delete e.destroySpectrumEvents}},fn={render:()=>ct("div",{class:"color-picker-module color-picker-module-hs-spectrum"},ct("div",{class:"color-picker-hs-spectrum"},ct("div",{class:"color-picker-hs-spectrum-handle"}))),init(e){const{app:t}=e;let a,r,s,o,n,i,l,c;const{$el:p}=e;function d(t,a){let r=(t-i.left)/i.width*360,s=(a-i.top)/i.height;r=Math.max(0,Math.min(360,r)),s=1-Math.max(0,Math.min(1,s)),e.setValue({hsb:[r,s,e.value.hsb[2]]})}function u(e){if(a)return;r="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,o=r,s="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,n=s;const t=A(e.target);c=t.closest(".color-picker-hs-spectrum-handle").length>0,c||(l=t.closest(".color-picker-hs-spectrum").length>0),l&&(i=p.find(".color-picker-hs-spectrum")[0].getBoundingClientRect(),d(r,s)),(c||l)&&p.find(".color-picker-hs-spectrum-handle").addClass("color-picker-hs-spectrum-handle-pressed")}function h(e){(l||c)&&(o="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,n="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,e.preventDefault(),a||(a=!0,c&&(i=p.find(".color-picker-hs-spectrum")[0].getBoundingClientRect())),(l||c)&&d(o,n))}function m(){a=!1,(l||c)&&p.find(".color-picker-hs-spectrum-handle").removeClass("color-picker-hs-spectrum-handle-pressed"),l=!1,c=!1}function f(){e.modules["hs-spectrum"].update(e)}const g=!("touchstart"!==t.touchEvents.start||!tt().passiveListener)&&{passive:!0,capture:!1};e.$el.on(t.touchEvents.start,u,g),t.on("touchmove:active",h),t.on("touchend:passive",m),t.on("resize",f),e.destroySpectrumEvents=function(){e.$el.off(t.touchEvents.start,u,g),t.off("touchmove:active",h),t.off("touchend:passive",m),t.off("resize",f)}},update(e){const{value:t}=e,{hsb:a}=t,r=e.$el.find(".color-picker-hs-spectrum")[0].offsetWidth,s=e.$el.find(".color-picker-hs-spectrum")[0].offsetHeight,o=We(a[0],a[1],1);e.$el.find(".color-picker-hs-spectrum-handle").css("background-color",`hsl(${o[0]}, ${100*o[1]}%, ${100*o[2]}%)`).transform(`translate(${r*(a[0]/360)}px, ${s*(1-a[1])}px)`)},destroy(e){e.destroySpectrumEvents&&e.destroySpectrumEvents(),delete e.destroySpectrumEvents}};var gn={render:()=>ct("div",{class:"color-picker-module color-picker-module-wheel"},ct("div",{class:"color-picker-wheel"},ct("svg",{viewBox:"0 0 300 300",width:"300",height:"300"},function(){let e="";for(let t=256;t>0;t-=1){const a=t*Math.PI/128,r=1.40625*t;e+=`<circle cx="${150-125*Math.sin(a)}" cy="${150-125*Math.cos(a)}" r="25" fill="hsl(${r}, 100%, 50%)"></circle>`}return e}()),ct("div",{class:"color-picker-wheel-handle"}),ct("div",{class:"color-picker-sb-spectrum",style:"background-color: hsl(0, 100%, 50%)"},ct("div",{class:"color-picker-sb-spectrum-handle"})))),init(e){const{app:t}=e;let a,r,s,o,n,i,l,c,p,d,u;const{$el:h}=e;function m(t,a){const r=i.left+i.width/2,s=i.top+i.height/2;let o=180*Math.atan2(a-s,t-r)/Math.PI+90;o<0&&(o+=360),o=360-o,e.setValue({hue:o})}function f(t,a){let r=(t-p.left)/p.width,s=(a-p.top)/p.height;r=Math.max(0,Math.min(1,r)),s=1-Math.max(0,Math.min(1,s)),e.setValue({hsb:[e.value.hue,r,s]})}function g(e){if(a)return;r="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,o=r,s="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,n=s;const t=A(e.target);c=t.closest(".color-picker-wheel-handle").length>0,l=t.closest("circle").length>0,u=t.closest(".color-picker-sb-spectrum-handle").length>0,u||(d=t.closest(".color-picker-sb-spectrum").length>0),l&&(i=h.find(".color-picker-wheel")[0].getBoundingClientRect(),m(r,s)),d&&(p=h.find(".color-picker-sb-spectrum")[0].getBoundingClientRect(),f(r,s)),(u||d)&&h.find(".color-picker-sb-spectrum-handle").addClass("color-picker-sb-spectrum-handle-pressed")}function v(e){(l||c||d||u)&&(o="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,n="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,e.preventDefault(),a||(a=!0,c&&(i=h.find(".color-picker-wheel")[0].getBoundingClientRect()),u&&(p=h.find(".color-picker-sb-spectrum")[0].getBoundingClientRect())),(l||c)&&m(o,n),(d||u)&&f(o,n))}function b(){a=!1,(d||u)&&h.find(".color-picker-sb-spectrum-handle").removeClass("color-picker-sb-spectrum-handle-pressed"),l=!1,c=!1,d=!1,u=!1}function w(){e.modules.wheel.update(e)}const y=!("touchstart"!==t.touchEvents.start||!tt().passiveListener)&&{passive:!0,capture:!1};e.$el.on(t.touchEvents.start,g,y),t.on("touchmove:active",v),t.on("touchend:passive",b),t.on("resize",w),e.destroyWheelEvents=function(){e.$el.off(t.touchEvents.start,g,y),t.off("touchmove:active",v),t.off("touchend:passive",b),t.off("resize",w)}},update(e){const{value:t}=e,{hsl:a,hsb:r}=t,s=e.$el.find(".color-picker-sb-spectrum")[0].offsetWidth,o=e.$el.find(".color-picker-sb-spectrum")[0].offsetHeight,n=e.$el.find(".color-picker-wheel")[0].offsetWidth,i=n/2,l=t.hue*Math.PI/180,c=n/6/2,p=i-Math.sin(l)*(i-c)-c,d=i-Math.cos(l)*(i-c)-c;e.$el.find(".color-picker-wheel-handle").css("background-color",`hsl(${a[0]}, 100%, 50%)`).transform(`translate(${p}px, ${d}px)`),e.$el.find(".color-picker-sb-spectrum").css("background-color",`hsl(${a[0]}, 100%, 50%)`),e.$el.find(".color-picker-sb-spectrum-handle").css("background-color",`hsl(${a[0]}, ${100*a[1]}%, ${100*a[2]}%)`).transform(`translate(${s*r[1]}px, ${o*(1-r[2])}px)`)},destroy(e){e.destroyWheelEvents&&e.destroyWheelEvents(),delete e.destroyWheelEvents}};let vn=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this;let r,s,o;if(a.params=Fe({},e.params.colorPicker,t),a.params.containerEl&&(r=A(a.params.containerEl),0===r.length))return a;function n(){a.open()}function i(e){e.preventDefault()}function l(){a.open()}function c(e){if(a.destroyed||!a.params)return;if("page"===a.params.openIn)return;const t=A(e.target);a.opened&&!a.closing&&(t.closest('[class*="backdrop"]').length||t.closest(".color-picker-popup, .color-picker-popover").length||(s&&s.length>0?t[0]!==s[0]&&0===t.closest(".sheet-modal").length&&a.close():0===A(e.target).closest(".sheet-modal").length&&a.close()))}return a.params.inputEl&&(s=A(a.params.inputEl)),a.params.targetEl&&(o=A(a.params.targetEl)),Fe(a,{app:e,$containerEl:r,containerEl:r&&r[0],inline:r&&r.length>0,$inputEl:s,inputEl:s&&s[0],$targetEl:o,targetEl:o&&o[0],initialized:!1,opened:!1,url:a.params.url,modules:{"alpha-slider":rn,"current-color":sn,hex:on,"hsb-sliders":nn,"hue-slider":ln,"brightness-slider":cn,palette:pn,"initial-current-colors":dn,"rgb-bars":un,"rgb-sliders":hn,"sb-spectrum":mn,"hs-spectrum":fn,wheel:gn}}),Fe(a,{attachInputEvents(){a.$inputEl.on("click",n),a.params.inputReadOnly&&(a.$inputEl.on("focus mousedown",i),a.$inputEl[0]&&(a.$inputEl[0].f7ValidateReadonly=!0))},detachInputEvents(){a.$inputEl.off("click",n),a.params.inputReadOnly&&(a.$inputEl.off("focus mousedown",i),a.$inputEl[0]&&delete a.$inputEl[0].f7ValidateReadonly)},attachTargetEvents(){a.$targetEl.on("click",l)},detachTargetEvents(){a.$targetEl.off("click",l)},attachHtmlEvents(){e.on("click",c)},detachHtmlEvents(){e.off("click",c)}}),a.init(),a}get view(){const{$inputEl:e,$targetEl:t,app:a,params:r}=this;let s;return r.view?s=r.view:(e&&(s=e.parents(".view").length&&e.parents(".view")[0].f7View),!s&&t&&(s=t.parents(".view").length&&t.parents(".view")[0].f7View)),s||(s=a.views.main),s}attachEvents(){const e=this;e.centerModules=e.centerModules.bind(e),e.params.centerModules&&e.app.on("resize",e.centerModules)}detachEvents(){const e=this;e.params.centerModules&&e.app.off("resize",e.centerModules)}centerModules(){const e=this;if(!e.opened||!e.$el||e.inline)return;const t=e.$el.find(".page-content");if(!t.length)return;const{scrollHeight:a,offsetHeight:r}=t[0];a<=r?t.addClass("justify-content-center"):t.removeClass("justify-content-center")}initInput(){const e=this;e.$inputEl&&e.params.inputReadOnly&&e.$inputEl.prop("readOnly",!0)}getModalType(){const{app:e,modal:t,params:a}=this,{openIn:r,openInPhone:s}=a,o=rt();return t&&t.type?t.type:"auto"!==r?r:this.inline?null:o.ios?o.ipad?"popover":s:e.width>=768?"popover":s}formatValue(){const e=this,{value:t}=e;return e.params.formatValue?e.params.formatValue.call(e,t):t.hex}normalizeHsValues(e){return[Math.floor(10*e[0])/10,Math.floor(1e3*e[1])/1e3,Math.floor(1e3*e[2])/1e3]}setValue(e,t){void 0===e&&(e={}),void 0===t&&(t=!0);const a=this;if(void 0===e)return;let{hex:r,rgb:s,hsl:o,hsb:n,alpha:i=1,hue:l,rgba:c,hsla:p}=a.value||{};const d=a.value||!a.value&&!a.params.value;let u;if(Object.keys(e).forEach((t=>{if(!a.value||void 0===a.value[t])return void(u=!0);const r=e[t];Array.isArray(r)?r.forEach(((e,r)=>{e!==a.value[t][r]&&(u=!0)})):r!==a.value[t]&&(u=!0)})),u){if(e.rgb||e.rgba){const[t,d,u,h=i]=e.rgb||e.rgba;s=[t,d,u],r=qe(...s),o=je(...s),n=Xe(...o),o=a.normalizeHsValues(o),n=a.normalizeHsValues(n),l=n[0],i=h,c=[s[0],s[1],s[2],h],p=[o[0],o[1],o[2],h]}if(e.hsl||e.hsla){const[t,d,u,h=i]=e.hsl||e.hsla;o=[t,d,u],s=Ye(...o),r=qe(...s),n=Xe(...o),o=a.normalizeHsValues(o),n=a.normalizeHsValues(n),l=n[0],i=h,c=[s[0],s[1],s[2],h],p=[o[0],o[1],o[2],h]}if(e.hsb){const[t,d,u,h=i]=e.hsb;n=[t,d,u],o=We(...n),s=Ye(...o),r=qe(...s),o=a.normalizeHsValues(o),n=a.normalizeHsValues(n),l=n[0],i=h,c=[s[0],s[1],s[2],h],p=[o[0],o[1],o[2],h]}if(e.hex&&(s=_e(e.hex),r=qe(...s),o=je(...s),n=Xe(...o),o=a.normalizeHsValues(o),n=a.normalizeHsValues(n),l=n[0],c=[s[0],s[1],s[2],i],p=[o[0],o[1],o[2],i]),void 0!==e.alpha&&(i=e.alpha,void 0!==s&&(c=[s[0],s[1],s[2],i]),void 0!==o&&(p=[o[0],o[1],o[2],i])),void 0!==e.hue){const[t,d,u]=o;o=[e.hue,d,u],n=Xe(...o),s=Ye(...o),r=qe(...s),o=a.normalizeHsValues(o),n=a.normalizeHsValues(n),l=n[0],c=[s[0],s[1],s[2],i],p=[o[0],o[1],o[2],i]}a.value={hex:r,alpha:i,hue:l,rgb:s,hsl:o,hsb:n,rgba:c,hsla:p},a.initialValue||(a.initialValue=Fe({},a.value)),a.updateValue(d),a.opened&&t&&a.updateModules()}}getValue(){return this.value}updateValue(e){void 0===e&&(e=!0);const t=this,{$inputEl:a,value:r,$targetEl:s}=t;if(s&&t.params.targetElSetBackgroundColor){const{rgba:e}=r;s.css("background-color",`rgba(${e.join(", ")})`)}if(e&&t.emit("local::change colorPickerChange",t,r),a&&a.length){const s=t.formatValue(r);a&&a.length&&(a.val(s),e&&a.trigger("change"))}}updateModules(){const e=this,{modules:t}=e;e.params.modules.forEach((a=>{"string"==typeof a&&t[a]&&t[a].update?t[a].update(e):a&&a.update&&a.update(e)}))}update(){this.updateModules()}renderPicker(){const e=this,{params:t,modules:a}=e;let r="";return t.modules.forEach((t=>{"string"==typeof t&&a[t]&&a[t].render?r+=a[t].render(e):t&&t.render&&(r+=t.render(e))})),r}renderNavbar(){const e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e,e);const{openIn:t,navbarTitleText:a,navbarBackLinkText:r,navbarCloseText:s}=e.params;return ct("div",{class:"navbar"},ct("div",{class:"navbar-bg"}),ct("div",{class:"navbar-inner sliding"},"page"===t&&ct("div",{class:"left"},ct("a",{class:"link back"},ct("i",{class:"icon icon-back"}),ct("span",{class:"if-not-md"},r))),ct("div",{class:"title"},a),"page"!==t&&ct("div",{class:"right"},ct("a",{class:"link popup-close","data-popup":".color-picker-popup"},s))))}renderToolbar(){const e=this;return e.params.renderToolbar?e.params.renderToolbar.call(e,e):ct("div",{class:"toolbar toolbar-top"},ct("div",{class:"toolbar-inner"},ct("div",{class:"left"}),ct("div",{class:"right"},ct("a",{class:"link sheet-close popover-close","data-sheet":".color-picker-sheet-modal","data-popover":".color-picker-popover"},e.params.toolbarCloseText))))}renderInline(){const{cssClass:e,groupedModules:t}=this.params;return ct("div",{class:`color-picker color-picker-inline ${t?"color-picker-grouped-modules":""} ${e||""}`},this.renderPicker())}renderSheet(){const e=this,{cssClass:t,toolbarSheet:a,groupedModules:r}=e.params;return ct("div",{class:`sheet-modal color-picker color-picker-sheet-modal ${r?"color-picker-grouped-modules":""} ${t||""}`},a&&e.renderToolbar(),ct("div",{class:"sheet-modal-inner"},ct("div",{class:"page-content"},e.renderPicker())))}renderPopover(){const e=this,{cssClass:t,toolbarPopover:a,groupedModules:r}=e.params;return ct("div",{class:`popover color-picker-popover ${t||""}`},ct("div",{class:"popover-inner"},ct("div",{class:"color-picker "+(r?"color-picker-grouped-modules":"")},a&&e.renderToolbar(),ct("div",{class:"page-content"},e.renderPicker()))))}renderPopup(){const e=this,{cssClass:t,navbarPopup:a,groupedModules:r}=e.params;return ct("div",{class:`popup color-picker-popup ${t||""}`},ct("div",{class:"page"},a&&e.renderNavbar(),ct("div",{class:"color-picker "+(r?"color-picker-grouped-modules":"")},ct("div",{class:"page-content"},e.renderPicker()))))}renderPage(){const e=this,{cssClass:t,groupedModules:a}=e.params;return ct("div",{class:`page color-picker-page ${t||""}`,"data-name":"color-picker-page"},e.renderNavbar(),ct("div",{class:"color-picker "+(a?"color-picker-grouped-modules":"")},ct("div",{class:"page-content"},e.renderPicker())))}render(){const e=this,{params:t}=e;if(t.render)return t.render.call(e);if(e.inline)return e.renderInline();if("page"===t.openIn)return e.renderPage();const a=e.getModalType();return"popover"===a?e.renderPopover():"sheet"===a?e.renderSheet():"popup"===a?e.renderPopup():void 0}onOpen(){const e=this,{initialized:t,$el:a,app:r,$inputEl:s,inline:o,value:n,params:i,modules:l}=e;e.closing=!1,e.opened=!0,e.opening=!0,e.attachEvents(),i.modules.forEach((t=>{"string"==typeof t&&l[t]&&l[t].init?l[t].init(e):t&&t.init&&t.init(e)}));const c=!n&&i.value;t?n&&(e.initialValue=Fe({},n),e.setValue(n,!1)):n?e.setValue(n):i.value?e.setValue(i.value,!1):i.value||e.setValue({hex:"#ff0000"},!1),c&&e.updateValue(),e.updateModules(),i.centerModules&&e.centerModules(),!o&&s&&s.length&&"md"===r.theme&&s.trigger("focus"),e.initialized=!0,a&&a.trigger("colorpicker:open"),s&&s.trigger("colorpicker:open"),e.emit("local::open colorPickerOpen",e)}onOpened(){const e=this;e.opening=!1,e.$el&&e.$el.trigger("colorpicker:opened"),e.$inputEl&&e.$inputEl.trigger("colorpicker:opened"),e.emit("local::opened colorPickerOpened",e)}onClose(){const e=this,{app:t,params:a,modules:r}=e;if(e.opening=!1,e.closing=!0,e.detachEvents(),e.$inputEl)if("md"===t.theme)e.$inputEl.trigger("blur");else{const a=e.$inputEl.attr("validate"),r=e.$inputEl.attr("required");a&&r&&t.input.validate(e.$inputEl)}a.modules.forEach((t=>{"string"==typeof t&&r[t]&&r[t].destroy?r[t].destroy(e):t&&t.destroy&&t.destroy(e)})),e.$el&&e.$el.trigger("colorpicker:close"),e.$inputEl&&e.$inputEl.trigger("colorpicker:close"),e.emit("local::close colorPickerClose",e)}onClosed(){const e=this;e.opened=!1,e.closing=!1,e.inline||Le((()=>{e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal})),e.$el&&e.$el.trigger("colorpicker:closed"),e.$inputEl&&e.$inputEl.trigger("colorpicker:closed"),e.emit("local::closed colorPickerClosed",e)}open(){const e=this,{app:t,opened:a,inline:r,$inputEl:s,$targetEl:o,params:n}=e;if(a)return;if(r)return e.$el=A(e.render()),e.$el[0].f7ColorPicker=e,e.$containerEl.append(e.$el),e.onOpen(),void e.onOpened();const i=e.render();if("page"===n.openIn)e.view.router.navigate({url:e.url,route:{content:i,path:e.url,on:{pageBeforeIn(t,a){e.$el=a.$el.find(".color-picker"),e.$el[0].f7ColorPicker=e,e.onOpen()},pageAfterIn(){e.onOpened()},pageBeforeOut(){e.onClose()},pageAfterOut(){e.onClosed(),e.$el&&e.$el[0]&&(e.$el[0].f7ColorPicker=null,delete e.$el[0].f7ColorPicker)}}}});else{const a=e.getModalType();let r=n.backdrop;null==r&&("popover"===a&&!1!==t.params.popover.backdrop&&(r=!0),"popup"===a&&(r=!0));const l={targetEl:o||s,scrollToEl:n.scrollToInput?o||s:void 0,content:i,backdrop:r,closeByBackdropClick:n.closeByBackdropClick,on:{open(){const t=this;e.modal=t,e.$el="popover"===a||"popup"===a?t.$el.find(".color-picker"):t.$el,e.$el[0].f7ColorPicker=e,e.onOpen()},opened(){e.onOpened()},close(){e.onClose()},closed(){e.onClosed(),e.$el&&e.$el[0]&&(e.$el[0].f7ColorPicker=null,delete e.$el[0].f7ColorPicker)}}};"popup"===a&&(l.push=n.popupPush,l.swipeToClose=n.popupSwipeToClose),"sheet"===a&&(l.push=n.sheetPush,l.swipeToClose=n.sheetSwipeToClose),n.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,[a]:l}}):(e.modal=t[a].create(l),e.modal.open())}}close(){const e=this,{opened:t,inline:a}=e;if(t)return a?(e.onClose(),void e.onClosed()):void(e.params.routableModals&&e.view||"page"===e.params.openIn?e.view.router.back():e.modal.close())}init(){const e=this;if(e.initInput(),e.inline)return e.open(),void e.emit("local::init colorPickerInit",e);!e.initialized&&e.params.value&&e.setValue(e.params.value),e.$inputEl&&e.attachInputEvents(),e.$targetEl&&e.attachTargetEvents(),e.params.closeByOutsideClick&&e.attachHtmlEvents(),e.emit("local::init colorPickerInit",e)}destroy(){const e=this;if(e.destroyed)return;const{$el:t}=e;e.emit("local::beforeDestroy colorPickerBeforeDestroy",e),t&&t.trigger("colorpicker:beforedestroy"),e.close(),e.detachEvents(),e.$inputEl&&e.detachInputEvents(),e.$targetEl&&e.detachTargetEvents(),e.params.closeByOutsideClick&&e.detachHtmlEvents(),t&&t.length&&delete e.$el[0].f7ColorPicker,Ie(e),e.destroyed=!0}};var bn={name:"colorPicker",static:{ColorPicker:vn},create(){const e=this;e.colorPicker=nt({defaultSelector:".color-picker",constructor:vn,app:e,domProp:"f7ColorPicker"}),e.colorPicker.close=function(e){void 0===e&&(e=".color-picker");const t=A(e);if(0===t.length)return;const a=t[0].f7ColorPicker;!a||a&&!a.opened||a.close()}},params:{colorPicker:{value:null,modules:["wheel"],palette:[["#FFEBEE","#FFCDD2","#EF9A9A","#E57373","#EF5350","#F44336","#E53935","#D32F2F","#C62828","#B71C1C"],["#F3E5F5","#E1BEE7","#CE93D8","#BA68C8","#AB47BC","#9C27B0","#8E24AA","#7B1FA2","#6A1B9A","#4A148C"],["#E8EAF6","#C5CAE9","#9FA8DA","#7986CB","#5C6BC0","#3F51B5","#3949AB","#303F9F","#283593","#1A237E"],["#E1F5FE","#B3E5FC","#81D4FA","#4FC3F7","#29B6F6","#03A9F4","#039BE5","#0288D1","#0277BD","#01579B"],["#E0F2F1","#B2DFDB","#80CBC4","#4DB6AC","#26A69A","#009688","#00897B","#00796B","#00695C","#004D40"],["#F1F8E9","#DCEDC8","#C5E1A5","#AED581","#9CCC65","#8BC34A","#7CB342","#689F38","#558B2F","#33691E"],["#FFFDE7","#FFF9C4","#FFF59D","#FFF176","#FFEE58","#FFEB3B","#FDD835","#FBC02D","#F9A825","#F57F17"],["#FFF3E0","#FFE0B2","#FFCC80","#FFB74D","#FFA726","#FF9800","#FB8C00","#F57C00","#EF6C00","#E65100"]],groupedModules:!1,centerModules:!0,sliderLabel:!1,sliderValue:!1,sliderValueEdiable:!1,barLabel:!1,barValue:!1,barValueEdiable:!1,hexLabel:!1,hexValueEditable:!1,redLabelText:"R",greenLabelText:"G",blueLabelText:"B",hueLabelText:"H",saturationLabelText:"S",brightnessLabelText:"B",hexLabelText:"HEX",alphaLabelText:"A",containerEl:null,openIn:"popover",openInPhone:"popup",popupPush:!1,popupSwipeToClose:void 0,sheetPush:!1,sheetSwipeToClose:void 0,formatValue:null,targetEl:null,targetElSetBackgroundColor:!1,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,toolbarSheet:!0,toolbarPopover:!1,toolbarCloseText:"Done",navbarPopup:!0,navbarCloseText:"Done",navbarTitleText:"Color",navbarBackLinkText:"Back",cssClass:null,routableModals:!1,view:null,url:"color/",backdrop:null,closeByBackdropClick:!0,renderToolbar:null,renderNavbar:null,renderInline:null,renderPopover:null,renderSheet:null,renderPopup:null,render:null}}};const wn={open(e){const t=this,a=A(e).eq(0);if(a.length&&(a.addClass("treeview-item-opened"),a.trigger("treeview:open"),t.emit("treeviewOpen",a[0]),a.hasClass("treeview-load-children")&&!a[0].f7TreeviewChildrenLoaded)){const e={iosPreloaderContent:Me,mdPreloaderContent:Pe};a.trigger("treeview:loadchildren",r),t.emit("treeviewLoadChildren",a[0],r),a.find(".treeview-toggle").addClass("treeview-toggle-hidden"),a.find(".treeview-item-root").prepend(`<div class="preloader treeview-preloader">${e[`${t.theme}PreloaderContent`]}</div>`)}function r(e){e?(a.removeClass("treeview-item-opened"),a.trigger("treeview:close"),t.emit("treeviewClose",a[0])):a[0].f7TreeviewChildrenLoaded=!0,a.find(".treeview-toggle").removeClass("treeview-toggle-hidden"),a.find(".treeview-preloader").remove()}},close(e){const t=A(e).eq(0);t.length&&(t.removeClass("treeview-item-opened"),t.trigger("treeview:close"),this.emit("treeviewClose",t[0]))},toggle(e){const t=A(e).eq(0);if(!t.length)return;const a=t.hasClass("treeview-item-opened");this.treeview[a?"close":"open"](t)}};var yn={name:"treeview",create(){Ke(this,{treeview:wn})},clicks:{".treeview-toggle":function(e,t,a){if(e.parents(".treeview-item-toggle").length)return;const r=e.parents(".treeview-item").eq(0);r.length&&(a.preventF7Router=!0,this.treeview.toggle(r[0]))},".treeview-item-toggle":function(e,t,a){const r=e.closest(".treeview-item").eq(0);r.length&&(a.preventF7Router=!0,this.treeview.toggle(r[0]))}}};const Cn={bold:["bold","format_bold","bold"],italic:["italic","format_italic","italic"],underline:["underline","format_underlined","underline"],strikeThrough:["strikethrough","strikethrough_s","strikeThrough"],orderedList:["list_number","format_list_numbered","insertOrderedList"],unorderedList:["list_bullet","format_list_bulleted","insertUnorderedList"],link:["link","link","createLink"],image:["photo","image","insertImage"],paragraph:["paragraph",'<i class="icon">¶</i>',"formatBlock.P"],h1:['<i class="icon">H<sub>1</sub></i>','<i class="icon">H<sub>1</sub></i>',"formatBlock.H1"],h2:['<i class="icon">H<sub>2</sub></i>','<i class="icon">H<sub>2</sub></i>',"formatBlock.H2"],h3:['<i class="icon">H<sub>3</sub></i>','<i class="icon">H<sub>3</sub></i>',"formatBlock.H3"],alignLeft:["text_alignleft","format_align_left","justifyLeft"],alignCenter:["text_aligncenter","format_align_center","justifyCenter"],alignRight:["text_alignright","format_align_right","justifyRight"],alignJustify:["text_justify","format_align_justify","justifyFull"],subscript:["textformat_subscript",'<i class="icon">A<sub>1</sub></i>',"subscript"],superscript:["textformat_superscript",'<i class="icon">A<sup>1</sup></i>',"superscript"],indent:["increase_indent","format_indent_increase","indent"],outdent:["decrease_indent","format_indent_decrease","outdent"]};let En=class extends ot{constructor(e,t){super(t,[e]);const a=this,s=r(),o=rt(),n=Fe({},e.params.textEditor);a.useModulesParams(n),a.params=Fe(n,t);const i=a.params.el;if(!i)return a;const l=A(i);if(0===l.length)return a;if(l[0].f7TextEditor)return l[0].f7TextEditor;let c=l.children(".text-editor-content");if(c.length||(l.append('<div class="text-editor-content" contenteditable></div>'),c=l.children(".text-editor-content")),Fe(a,{app:e,$el:l,el:l[0],$contentEl:c,contentEl:c[0]}),"value"in t&&(a.value=a.params.value),"keyboard-toolbar"===a.params.mode&&(o.cordova||o.capacitor||o.android||(a.params.mode="popover")),"string"==typeof a.params.buttons)try{a.params.buttons=JSON.parse(a.params.buttons)}catch(e){throw new Error('Framework7: TextEditor: wrong "buttons" parameter format')}return l[0].f7TextEditor=a,a.onButtonClick=a.onButtonClick.bind(a),a.onFocus=a.onFocus.bind(a),a.onBlur=a.onBlur.bind(a),a.onInput=a.onInput.bind(a),a.onPaste=a.onPaste.bind(a),a.onSelectionChange=a.onSelectionChange.bind(a),a.closeKeyboardToolbar=a.closeKeyboardToolbar.bind(a),a.attachEvents=function(){"toolbar"===a.params.mode&&a.$el.find(".text-editor-toolbar").on("click","button",a.onButtonClick),"keyboard-toolbar"===a.params.mode&&(a.$keyboardToolbarEl.on("click","button",a.onButtonClick),a.$el.parents(".page").on("page:beforeout",a.closeKeyboardToolbar)),"popover"===a.params.mode&&a.popover&&a.popover.$el.on("click","button",a.onButtonClick),a.$contentEl.on("paste",a.onPaste),a.$contentEl.on("focus",a.onFocus),a.$contentEl.on("blur",a.onBlur),a.$contentEl.on("input",a.onInput,!0),A(s).on("selectionchange",a.onSelectionChange)},a.detachEvents=function(){"toolbar"===a.params.mode&&a.$el.find(".text-editor-toolbar").off("click","button",a.onButtonClick),"keyboard-toolbar"===a.params.mode&&(a.$keyboardToolbarEl.off("click","button",a.onButtonClick),a.$el.parents(".page").off("page:beforeout",a.closeKeyboardToolbar)),"popover"===a.params.mode&&a.popover&&a.popover.$el.off("click","button",a.onButtonClick),a.$contentEl.off("paste",a.onPaste),a.$contentEl.off("focus",a.onFocus),a.$contentEl.off("blur",a.onBlur),a.$contentEl.off("input",a.onInput,!0),A(s).off("selectionchange",a.onSelectionChange)},a.useModules(),a.init(),a}setValue(e){const t=this;return t.value===e||(t.value=e,t.$contentEl.html(e),t.$el.trigger("texteditor:change",t.value),t.emit("local::change textEditorChange",t,t.value)),t}getValue(){return this.value}clearValue(){const e=this;return e.setValue(""),e.params.placeholder&&!e.$contentEl.html()&&e.insertPlaceholder(),e}createLink(){const e=this,t=o(),a=r(),s=t.getSelection(),n=[];let i;if(s&&s.anchorNode&&A(s.anchorNode).parents(e.$el).length){let e=s.anchorNode;for(;e;)n.push(e),e.nextSibling&&e!==s.focusNode||(e=null),e&&(e=e.nextSibling);const t=[],a=A(n);for(let e=0;e<a.length;e+=1){const r=a[e].children;if(r)for(let e=0;e<r.length;e+=1)A(r[e]).is("a")&&t.push(r[e])}i=a.closest("a").add(A(t))}if(i&&i.length)return i.each((e=>{const r=t.getSelection(),s=a.createRange();s.selectNodeContents(e),r.removeAllRanges(),r.addRange(s),a.execCommand("unlink",!1),r.removeAllRanges()})),e;const l=e.getSelectionRange();if(!l)return e;return e.app.dialog.prompt("",e.params.linkUrlText,(t=>{t&&t.trim().length&&(e.setSelectionRange(l),a.execCommand("createLink",!1,t.trim()),e.$el.trigger("texteditor:insertlink",{url:t.trim()}),e.emit("local:insertLink textEditorInsertLink",e,t.trim()))})).$el.find("input").focus(),e}insertImage(){const e=this,t=r(),a=e.getSelectionRange();if(!a)return e;return e.app.dialog.prompt("",e.params.imageUrlText,(r=>{r&&r.trim().length&&(e.setSelectionRange(a),t.execCommand("insertImage",!1,r.trim()),e.$el.trigger("texteditor:insertimage",{url:r.trim()}),e.emit("local:insertImage textEditorInsertImage",e,r.trim()))})).$el.find("input").focus(),e}removePlaceholder(){this.$contentEl.find(".text-editor-placeholder").remove()}insertPlaceholder(){this.$contentEl.append(`<div class="text-editor-placeholder">${this.params.placeholder}</div>`)}onSelectionChange(){const e=this,t=o(),a=r();if("toolbar"===e.params.mode)return;const s=t.getSelection(),n=A(s.anchorNode).parents(e.contentEl).length||s.anchorNode===e.contentEl;if("keyboard-toolbar"!==e.params.mode){if("popover"===e.params.mode){const r=A(s.anchorNode).parents(e.popover.el).length||s.anchorNode===e.popover.el;if(!n&&!r)return void e.closePopover();if(!s.isCollapsed&&s.rangeCount){const r=s.getRangeAt(0).getBoundingClientRect(),o=e.app.$el[0]||a.body;e.openPopover(r.x+(t.scrollX||0)-o.offsetLeft,r.y+(t.scrollY||0)-o.offsetTop,r.width,r.height)}else s.isCollapsed&&e.closePopover()}}else n?e.openKeyboardToolbar():e.closeKeyboardToolbar()}onPaste(e){const t=r();if(this.params.clearFormattingOnPaste&&e.clipboardData&&e.clipboardData.getData){const a=e.clipboardData.getData("text/plain");e.preventDefault(),t.execCommand("insertText",!1,a)}}onInput(){const e=this,t=e.$contentEl.html();e.value=t,e.$el.trigger("texteditor:input"),e.emit("local:input textEditorInput",e,e.value),e.$el.trigger("texteditor:change",e.value),e.emit("local::change textEditorChange",e,e.value)}onFocus(){const e=this;e.removePlaceholder(),e.$contentEl.focus(),e.$el.trigger("texteditor:focus"),e.emit("local::focus textEditorFocus",e)}onBlur(){const e=this,t=o(),a=r();if(e.params.placeholder&&""===e.$contentEl.html()&&e.insertPlaceholder(),"popover"===e.params.mode){const r=t.getSelection(),s=A(r.anchorNode).parents(e.contentEl).length||r.anchorNode===e.contentEl;a.activeElement&&e.popover&&A(a.activeElement).closest(e.popover.$el).length||s||e.closePopover()}if("keyboard-toolbar"===e.params.mode){const a=t.getSelection();A(a.anchorNode).parents(e.contentEl).length||a.anchorNode===e.contentEl||e.closeKeyboardToolbar()}e.$el.trigger("texteditor:blur"),e.emit("local::blur textEditorBlur",e)}onButtonClick(e){const t=this,a=o(),s=r(),n=a.getSelection();if(!(A(n.anchorNode).parents(t.contentEl).length||n.anchorNode===t.contentEl))return;const i=A(e.target).closest("button");i.parents("form").length&&e.preventDefault();const l=i.attr("data-button"),c=t.params.customButtons&&t.params.customButtons[l];if(!l||!Cn[l]&&!c)return;if(i.trigger("texteditor:buttonclick",l),t.emit("local::buttonClick textEditorButtonClick",t,l),c)return void(c.onClick&&c.onClick(t,i[0]));const p=Cn[l][2];if("createLink"!==p)if("insertImage"!==p)if(0!==p.indexOf("formatBlock"))s.execCommand(p,!1);else{const e=p.split(".")[1],t=A(n.anchorNode);t.parents(e.toLowerCase()).length||t.is(e)?s.execCommand("formatBlock",!1,"div"):s.execCommand("formatBlock",!1,e)}else t.insertImage();else t.createLink()}getSelectionRange(){const e=o(),t=r();if(e.getSelection){const t=e.getSelection();if(t.getRangeAt&&t.rangeCount)return t.getRangeAt(0)}else if(t.selection&&t.selection.createRange)return t.selection.createRange();return null}setSelectionRange(e){const t=o(),a=r();if(e)if(t.getSelection){const a=t.getSelection();a.removeAllRanges(),a.addRange(e)}else a.selection&&e.select&&e.select()}renderButtons(){const e=this;let t="";function a(t){const a="md"===e.app.theme?"material-icons":"f7-icons";if(e.params.customButtons&&e.params.customButtons[t]){return`<button type="button" class="text-editor-button" data-button="${t}">${e.params.customButtons[t].content||""}</button>`}if(!Cn[t])return"";const r=Cn[t]["md"===e.app.theme?1:0];return`<button type="button" class="text-editor-button" data-button="${t}">${r.indexOf("<")>=0?r:`<i class="${a}">${r}</i>`}</button>`.trim()}return e.params.buttons.forEach(((r,s)=>{Array.isArray(r)?(r.forEach((e=>{t+=a(e)})),s<e.params.buttons.length-1&&e.params.dividers&&(t+='<div class="text-editor-button-divider"></div>')):t+=a(r)})),t}createToolbar(){this.$el.prepend(`<div class="text-editor-toolbar">${this.renderButtons()}</div>`)}createKeyboardToolbar(){this.$keyboardToolbarEl=A(`<div class="toolbar toolbar-bottom text-editor-keyboard-toolbar"><div class="toolbar-inner">${this.renderButtons()}</div></div>`)}createPopover(){const e=this;e.popover=e.app.popover.create({content:`\n        <div class="popover dark text-editor-popover">\n          <div class="popover-inner">${e.renderButtons()}</div>\n        </div>\n      `,closeByOutsideClick:!1,backdrop:!1})}openKeyboardToolbar(){const e=this;e.$keyboardToolbarEl.parent(e.app.$el).length||(e.$el.trigger("texteditor:keyboardopen"),e.emit("local::keyboardOpen textEditorKeyboardOpen",e),e.app.$el.append(e.$keyboardToolbarEl))}closeKeyboardToolbar(){const e=this;e.$keyboardToolbarEl.remove(),e.$el.trigger("texteditor:keyboardclose"),e.emit("local::keyboardClose textEditorKeyboardClose",e)}openPopover(e,t,a,r){const s=this;s.popover&&(Object.assign(s.popover.params,{targetX:e,targetY:t,targetWidth:a,targetHeight:r}),clearTimeout(s.popoverTimeout),s.popoverTimeout=setTimeout((()=>{s.popover&&(s.popover.opened?s.popover.resize():(s.$el.trigger("texteditor:popoveropen"),s.emit("local::popoverOpen textEditorPopoverOpen",s),s.popover.open()))}),400))}closePopover(){const e=this;clearTimeout(e.popoverTimeout),e.popover&&e.popover.opened&&(e.popoverTimeout=setTimeout((()=>{e.popover&&(e.$el.trigger("texteditor:popoverclose"),e.emit("local::popoverClose textEditorPopoverClose",e),e.popover.close())}),400))}init(){const e=this;return e.value?e.$contentEl.html(e.value):e.value=e.$contentEl.html(),e.params.placeholder&&""===e.value&&e.insertPlaceholder(),"toolbar"===e.params.mode?e.createToolbar():"popover"===e.params.mode?e.createPopover():"keyboard-toolbar"===e.params.mode&&e.createKeyboardToolbar(),e.attachEvents(),e.$el.trigger("texteditor:init"),e.emit("local::init textEditorInit",e),e}destroy(){let e=this;e.$el.trigger("texteditor:beforedestroy"),e.emit("local::beforeDestroy textEditorBeforeDestroy",e),e.detachEvents(),"keyboard-toolbar"===e.params.mode&&e.$keyboardToolbarEl&&e.$keyboardToolbarEl.remove(),e.popover&&(e.popover.close(!1),e.popover.destroy()),delete e.$el[0].f7TextEditor,Ie(e),e=null}};var kn={name:"textEditor",params:{textEditor:{el:null,mode:"toolbar",value:void 0,customButtons:null,buttons:[["bold","italic","underline","strikeThrough"],["orderedList","unorderedList"],["link","image"],["paragraph","h1","h2","h3"],["alignLeft","alignCenter","alignRight","alignJustify"],["subscript","superscript"],["indent","outdent"]],dividers:!0,imageUrlText:"Insert image URL",linkUrlText:"Insert link URL",placeholder:null,clearFormattingOnPaste:!0}},create(){this.textEditor=Fe(nt({defaultSelector:".text-editor",constructor:En,app:this,domProp:"f7TextEditor"}))},static:{TextEditor:En},on:{tabMounted(e){const t=this;A(e).find(".text-editor-init").each((e=>{const a=A(e).dataset();t.textEditor.create(Fe({el:e},a||{}))}))},tabBeforeRemove(e){A(e).find(".text-editor-init").each((e=>{e.f7TextEditor&&e.f7TextEditor.destroy()}))},pageInit(e){const t=this;e.$el.find(".text-editor-init").each((e=>{const a=A(e).dataset();t.textEditor.create(Fe({el:e},a||{}))}))},pageBeforeRemove(e){e.$el.find(".text-editor-init").each((e=>{e.f7TextEditor&&e.f7TextEditor.destroy()}))}},vnode:{"text-editor-init":{insert(e){const t=e.elm,a=A(t).dataset();this.textEditor.create(Fe({el:t},a||{}))},destroy(e){const t=e.elm;t.f7TextEditor&&t.f7TextEditor.destroy()}}}};let $n=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r=Fe({},e.params.pieChart);a.useModulesParams(r),a.params=Fe(r,t);const{el:s}=a.params;if(!s)return a;const o=A(s);return 0===o.length?a:o[0].f7PieChart?o[0].f7PieChart:(Fe(a,{app:e,$el:o,el:o&&o[0],currentIndex:null,f7Tooltip:null}),o[0].f7PieChart=a,a.useModules(),a.showTooltip=a.showTooltip.bind(this),a.hideTooltip=a.hideTooltip.bind(this),a.init(),a)}getSummValue(){const{datasets:e}=this.params;let t=0;return e.map((e=>e.value||0)).forEach((e=>{t+=e})),t}getPaths(){const{datasets:e,size:t}=this.params,a=[];let r=0;function s(e){return[Math.cos(2*Math.PI*e)*(t/3),Math.sin(2*Math.PI*e)*(t/3)]}return e.forEach((e=>{let{value:o,label:n,color:i}=e;const l=o/this.getSummValue(),[c,p]=s(r);r+=l;const[d,u]=s(r),h=[`M ${c} ${p}`,`A ${t/3} ${t/3} 0 ${l>.5?1:0} 1 ${d} ${u}`,"L 0 0"].join(" ");a.push({points:h,label:n,color:i})})),a}formatTooltipText(){const{datasets:e}=this.params,{currentIndex:t}=this;if(null===t)return"";const{value:a,label:r,color:s}=e[t],o=a/this.getSummValue()*100,n=e=>parseInt(e,10)===e?e:Math.round(100*e)/100;if(this.params.formatTooltip)return this.params.formatTooltip.call(this,{index:t,value:a,label:r,color:s,percentage:o});return`\n      <div class="pie-chart-tooltip-label">\n        <span class="pie-chart-tooltip-color" style="background-color: ${s};"></span> ${`${r?`${r}: `:""}${n(a)} (${n(o)}%)`}\n      </div>\n    `}setTooltip(){const e=this,{currentIndex:t,el:a,app:r,params:s}=e,{tooltip:o}=s;if((null!==t||e.f7Tooltip)&&o&&a)return null===t||e.f7Tooltip?void(e.f7Tooltip&&(null!==t?(e.f7Tooltip.setText(e.formatTooltipText()),e.f7Tooltip.setTargetEl(a.querySelector(`path[data-index="${t}"]`)),e.f7Tooltip.show()):e.f7Tooltip.hide())):(e.f7Tooltip=r.tooltip.create({trigger:"manual",containerEl:a,targetEl:a.querySelector(`path[data-index="${t}"]`),text:e.formatTooltipText(),cssClass:"pie-chart-tooltip"}),void e.f7Tooltip.show())}render(){const e=this.params.size,t=this.getPaths();return ct("svg",{xmlns:"http://www.w3.org/2000/svg",width:e,viewBox:`-${e/3} -${e/3} ${2*e/3} ${2*e/3}`,style:"transform: rotate(-90deg)"},t.map(((e,t)=>ct("path",{d:e.points,fill:e.color,"data-index":t}))))}update(e){void 0===e&&(e={});const t=this,{params:a}=t;if(Object.keys(e).forEach((t=>{void 0!==e[t]&&(a[t]=e[t])})),0===t.$svgEl.length)return t;t.$svgEl.remove(),delete t.$svgEl.f7PieChart;const r=A(t.render()).eq(0);return r.f7PieChart=t,Fe(t,{$svgEl:r,svgEl:r&&r[0]}),t.$el.append(r),t}setCurrentIndex(e){const t=this;if(e===t.currentIndex)return;const{datasets:a}=t.params;t.currentIndex=e,t.$el.trigger("piechart:select",{index:e,dataset:a[e]}),t.emit("local::select pieChartSelect",t,e,a[e])}showTooltip(e){const t=parseInt(e.target.getAttribute("data-index"),10);this.setCurrentIndex(t),this.$svgEl.find("path").removeClass("pie-chart-hidden").forEach(((e,t)=>{t!==this.currentIndex&&A(e).addClass("pie-chart-hidden")})),this.setTooltip()}hideTooltip(){this.setCurrentIndex(null),this.$svgEl.find("path").removeClass("pie-chart-hidden"),this.setTooltip()}init(){const e=this,t=A(e.render()).eq(0);return t.f7PieChart=e,Fe(e,{$svgEl:t,svgEl:t&&t[0]}),e.$el.append(t),e.$el.on("click mouseenter","path",e.showTooltip,!0),e.$el.on("mouseleave","path",e.hideTooltip,!0),e}destroy(){const e=this;e.$el&&!e.destroyed&&(e.$el.trigger("piechart:beforedestroy"),e.emit("local::beforeDestroy pieChartBeforeDestroy",e),e.$el.off("click mouseenter","path",e.showTooltip,!0),e.$el.off("mouseleave","path",e.hideTooltip,!0),e.$svgEl.remove(),e.f7Tooltip&&e.f7Tooltip.destroy&&e.f7Tooltip.destroy(),delete e.$el[0].f7PieChart,Ie(e),e.destroyed=!0)}};var xn={name:"pieChart",params:{pieChart:{el:null,datasets:[],size:320,tooltip:!1,formatTooltip:null}},create(){const e=this;e.pieChart=nt({defaultSelector:".pie-chart",constructor:$n,app:e,domProp:"f7PieChart"}),e.pieChart.update=function(t,a){if(0===A(t).length)return;const r=e.pieChart.get(t);return r?(r.update(a),r):void 0}}};let Tn=class extends ot{constructor(e,t){void 0===t&&(t={}),super(t,[e]);const a=this,r=Fe({},e.params.areaChart);a.useModulesParams(r),a.params=Fe(r,t);const{el:s}=a.params;if(!s)return a;const o=A(s);return 0===o.length?a:o[0].f7AreaChart?o[0].f7AreaChart:(Fe(a,{app:e,$el:o,el:o&&o[0],currentIndex:null,hiddenDatasets:[],f7Tooltip:null,linesOffsets:null}),o[0].f7AreaChart=a,a.useModules(),a.onMouseEnter=a.onMouseEnter.bind(a),a.onMouseMove=a.onMouseMove.bind(a),a.onMouseLeave=a.onMouseLeave.bind(a),a.onLegendClick=a.onLegendClick.bind(a),a.init(),a)}getVisibleLabels(){const{maxAxisLabels:e,axisLabels:t}=this.params;if(!e||t.length<=e)return t;const a=Math.ceil(t.length/e),r=t.filter(((e,t)=>t%a==0));return r}getSummValues(){const{datasets:e}=this.params,{hiddenDatasets:t}=this,a=[];return e.filter(((e,a)=>!t.includes(a))).forEach((e=>{let{values:t}=e;t.forEach(((e,t)=>{a[t]||(a[t]=0),a[t]+=e}))})),a}getChartData(){const{datasets:e,lineChart:t,width:a,height:r}=this.params,{hiddenDatasets:s}=this,o=[];if(!e.length)return o;const n=e[0].values.map((()=>0));let i=0;return t?e.filter(((e,t)=>!s.includes(t))).forEach((e=>{let{values:t}=e;const a=Math.max(...t);a>i&&(i=a)})):i=Math.max(...this.getSummValues()),e.filter(((e,t)=>!s.includes(t))).forEach((e=>{let{label:s,values:l,color:c}=e;const p=l.map(((e,s)=>{n[s]+=e;const o=t?e:n[s],c=s/(l.length-1)*a,p=r-o/i*r;return t?`${0===s?"M":"L"}${c},${p}`:`${c} ${p}`}));t||p.push(`${a} ${r} 0 ${r}`),o.push({label:s,points:p.join(" "),color:c})})),o.reverse()}getVerticalLines(){const{datasets:e,width:t}=this.params,a=[];if(!e.length)return a;const r=e[0].values;return r.forEach(((e,s)=>{const o=s/(r.length-1)*t;a.push(o)})),a}toggleDataset(e){const{hiddenDatasets:t,params:{toggleDatasets:a}}=this;a&&(t.includes(e)?t.splice(t.indexOf(e),1):t.push(e),this.$legendEl&&(this.$legendEl.find(".area-chart-legend-item").removeClass("area-chart-legend-item-hidden"),t.forEach((e=>{this.$legendEl.find(`.area-chart-legend-item[data-index="${e}"]`).addClass("area-chart-legend-item-hidden")}))),this.update({},!0))}formatAxisLabel(e){const{formatAxisLabel:t}=this.params;return t?t.call(this,e):e}formatLegendLabel(e){const{formatLegendLabel:t}=this.params;return t?t.call(this,e):e}calcLinesOffsets(){const e=this.svgEl.querySelectorAll("line");this.linesOffsets=[];for(let t=0;t<e.length;t+=1)this.linesOffsets.push(e[t].getBoundingClientRect().left)}formatTooltip(){const e=this,{currentIndex:t,hiddenDatasets:a,params:{datasets:r,axisLabels:s,formatTooltip:o,formatTooltipTotal:n,formatTooltipAxisLabel:i,formatTooltipDataset:l}}=e;if(null===t)return"";let c=0;const p=r.filter(((e,t)=>!a.includes(t))).map((e=>({color:e.color,label:e.label,value:e.values[t]})));if(p.forEach((e=>{c+=e.value})),o)return o({index:t,total:c,datasets:p});let d=i?i.call(e,s[t]):this.formatAxisLabel(s[t]);d||(d="");const u=n?n.call(e,c):c,h=p.length>0?`\n      <ul class="area-chart-tooltip-list">\n        ${p.map((t=>{let{label:a,color:r,value:s}=t;return`\n              <li><span style="background-color: ${r};"></span>${l?l.call(e,a,s,r):`${a?`${a}: `:""}${s}`}</li>\n            `})).join("")}\n      </ul>`:"";return`\n      <div class="area-chart-tooltip-label">${d}</div>\n      <div class="area-chart-tooltip-total">${u}</div>\n      ${h}\n    `}setTooltip(){const e=this,{app:t,el:a,svgEl:r,hiddenDatasets:s,currentIndex:o,params:{tooltip:n,datasets:i}}=e;if(!n)return;const l=i.filter(((e,t)=>!s.includes(t))).length>0;if(l)return null===o||e.f7Tooltip?void(e.f7Tooltip&&e.f7Tooltip.hide&&e.f7Tooltip.show&&(null!==o?(e.f7Tooltip.setText(e.formatTooltip()),e.f7Tooltip.setTargetEl(r.querySelector(`line[data-index="${o}"]`)),e.f7Tooltip.show()):e.f7Tooltip.hide())):(e.f7Tooltip=t.tooltip.create({trigger:"manual",containerEl:a,targetEl:r.querySelector(`line[data-index="${o}"]`),text:e.formatTooltip(),cssClass:"area-chart-tooltip"}),void(e.f7Tooltip&&e.f7Tooltip.show&&e.f7Tooltip.show()));e.f7Tooltip&&e.f7Tooltip.hide&&e.f7Tooltip.hide()}setCurrentIndex(e){e!==this.currentIndex&&(this.currentIndex=e,this.$el.trigger("areachart:select",{index:e}),this.emit("local::select areaChartSelect",this,e),this.$svgEl.find("line").removeClass("area-chart-current-line"),this.$svgEl.find(`line[data-index="${e}"]`).addClass("area-chart-current-line"),this.setTooltip())}onLegendClick(e){const t=parseInt(A(e.target).closest(".area-chart-legend-item").attr("data-index"),10);this.toggleDataset(t)}onMouseEnter(){this.calcLinesOffsets()}onMouseMove(e){const t=this;t.linesOffsets||t.calcLinesOffsets();let a=e.pageX;void 0===a&&(a=0);const r=t.linesOffsets.map((e=>Math.abs(a-e))),s=Math.min(...r),o=r.indexOf(s);t.setCurrentIndex(o)}onMouseLeave(){this.setCurrentIndex(null)}attachEvents(){const{svgEl:e,$el:t}=this;e&&(e.addEventListener("mouseenter",this.onMouseEnter),e.addEventListener("mousemove",this.onMouseMove),e.addEventListener("mouseleave",this.onMouseLeave),t.on("click",".area-chart-legend-item",this.onLegendClick))}detachEvents(){const{svgEl:e,$el:t}=this;e&&(e.removeEventListener("mouseenter",this.onMouseEnter),e.removeEventListener("mousemove",this.onMouseMove),e.removeEventListener("mouseleave",this.onMouseLeave),t.off("click",".area-chart-legend-item",this.onLegendClick))}render(){const e=this,{lineChart:t,toggleDatasets:a,width:r,height:s,axis:o,axisLabels:n,legend:i,datasets:l}=e.params,c=e.getChartData(),p=e.getVerticalLines(),d=e.getVisibleLabels(),u=a?"button":"span";return ct("div",null,ct("svg",{xmlns:"http://www.w3.org/2000/svg",width:r,height:s,viewBox:`0 0 ${r} ${s}`,preserveAspectRatio:"none"},c.map((e=>t?ct("path",{stroke:e.color,"fill-rule":"evenodd",d:e.points}):ct("polygon",{fill:e.color,"fill-rule":"evenodd",points:e.points}))),p.map(((e,t)=>ct("line",{"data-index":t,fill:"#000",x1:e,y1:0,x2:e,y2:s})))),o&&ct("div",{class:"area-chart-axis"},n.map((t=>ct("span",null,d.includes(t)&&ct("span",null,e.formatAxisLabel(t)))))),i&&ct("div",{class:"area-chart-legend"},l.map(((t,r)=>ct(u,{"data-index":r,class:"area-chart-legend-item "+(a?"area-chart-legend-button":""),_type:a?"button":void 0},ct("span",{style:`background-color: ${t.color}`}),e.formatLegendLabel(t.label))))))}update(e,t){void 0===e&&(e={}),void 0===t&&(t=!1);const a=this,{params:r}=a;if(Object.keys(e).forEach((t=>{void 0!==e[t]&&(r[t]=e[t])})),0===a.$svgEl.length)return a;a.detachEvents(),a.$svgEl.remove(),t||(a.$axisEl.remove(),a.$legendEl.remove());const s=A(a.render()),o=s.find("svg");if(Fe(a,{svgEl:o&&o[0],$svgEl:o}),!t){const e=s.find(".area-chart-axis"),t=s.find(".area-chart-legend");Fe(a,{$axisEl:e,$legendEl:t}),a.$el.append(e),a.$el.append(t)}return a.$el.prepend(o),a.attachEvents(),a}init(){const e=this,t=A(e.render()),a=t.find("svg"),r=t.find(".area-chart-axis"),s=t.find(".area-chart-legend");return Fe(e,{svgEl:a&&a[0],$svgEl:a,$axisEl:r,$legendEl:s}),e.$el.append(a),e.$el.append(r),e.$el.append(s),e.attachEvents(),e}destroy(){const e=this;e.$el&&!e.destroyed&&(e.$el.trigger("piechart:beforedestroy"),e.emit("local::beforeDestroy areaChartBeforeDestroy",e),e.detachEvents(),e.$svgEl.remove(),e.$axisEl.remove(),e.$legendEl.remove(),e.f7Tooltip&&e.f7Tooltip.destroy&&e.f7Tooltip.destroy(),delete e.$el[0].f7AreaChart,Ie(e),e.destroyed=!0)}};var Sn={name:"areaChart",params:{areaChart:{el:null,lineChart:!1,datasets:[],axis:!1,axisLabels:[],tooltip:!1,legend:!1,toggleDatasets:!1,width:640,height:320,maxAxisLabels:8,formatAxisLabel:null,formatLegendLabel:null,formatTooltip:null,formatTooltipAxisLabel:null,formatTooltipTotal:null,formatTooltipDataset:null}},create(){const e=this;e.areaChart=nt({defaultSelector:".area-chart",constructor:Tn,app:e,domProp:"f7AreaChart"}),e.areaChart.update=function(t,a){if(0===A(t).length)return;const r=e.areaChart.get(t);return r?(r.update(a),r):void 0}}};const Pn={};var Mn={name:"breadrumbs",create(){Ke(this,{breadrumbs:Pn})}};return"undefined"!=typeof window&&(window.Dom7||(window.Dom7=A)),Lt.use([zt]),pt.use([dt,ut,ht,mt,ft,Ht,Dt,Oa,Ma,Ba,Da,Ha,za,Va,_a,qa,Ya,Ka,Ja,er,ar,sr,nr,lr,pr,ur,mr,gr,br,yr,{name:"contactsList"},Er,$r,{name:"timeline"},Tr,Mr,Ir,{name:"chip"},Hr,Nr,{name:"checkbox"},{name:"radio"},Fr,qr,Yr,Kr,{name:"grid"},Jr,ts,rs,os,is,cs,ds,gs,bs,Wo,Uo,Ko,Jo,en,an,{name:"skeleton"},bn,yn,kn,xn,Sn,Mn,{name:"typography"}]),pt}));
//# sourceMappingURL=framework7-bundle.min.js.map