export declare const helpText = "Usage:\n$ workbox <command> [options]\n\nCommands:\n  wizard [--injectManifest]\n    Runs the configuration wizard, which will generate a\n    config file based on answers to questions.\n    By default the configuration will be tailored to the\n    generateSW use case.\n    If --injectManifest is provided, the wizard will ask\n    questions needed for the injectManifest use case.\n\n  generateSW [<path/to/config.js>] [--watch]\n    Creates a new service worker file based on the options\n    in the config file (defaults to workbox-config.js).\n    If --watch is provided, the CLI will stay running, and will\n    rebuild the service worker each time a file in the precache\n    manifest changes.\n    See https://bit.ly/wb-generateSW\n\n  injectManifest [<path/to/config.js>] [--watch]\n    Takes an existing service worker file and creates a\n    copy of it with a precache manifest \"injected\" into\n    it. The precache manifest is generated based on the\n    options in the config file (defaults to workbox-config.js).\n    If --watch is provided, the CLI will stay running, and will\n    rebuild the service worker each time a file in the precache\n    manifest changes.\n    See https://bit.ly/wb-injectManifest\n\n  copyLibraries <path/to/parent/dir>\n    Makes a local copy of all of the Workbox libraries inside\n    a version directory at the location specified. This is intended\n    for developers using injectManifest who prefer using local,\n    rather than CDN hosted, libraries.\n\nConfig file:\n  In 'generateSW' or 'injectManifest' mode, the config file should be a\n  JavaScript file, in CommonJS module format.\n  By default, a config file named workbox-config.js in the current\n  directory is assumed, but this can be overridden.\n\nExamples:\n  $ workbox wizard\n  $ workbox wizard --injectManifest\n  $ workbox generateSW --watch\n  $ workbox injectManifest configs/workbox-dev-config.js\n  $ workbox copyLibraries build/\n";
