import $ from 'dom7';
import Framework7 from './framework7-custom.js';

// Import F7 Styles
import '../css/framework7-custom.less';

// Import Icons and App Custom Styles
import '../css/icons.css';
import '../css/app.css';


// Import Routes
import routes from './routes.js';
// Import Store
//import store from './store.js';

// Import main app component
import App from '../app.f7';

var app = new Framework7({
  name: 'فرا پرداز', // App name
  theme: 'auto', // Automatic theme detection
  colors: {
    primary: '#00715c',
    secondary: '#72c540',
  },

  el: '#app', // App root element
  component: App, // App main component
  // App store
  //store: store,
  // App routes
  routes: routes,

  endpoint: 'https://site.farapardazapp.ir/',

  view: {
    browserHistory: true,
    browserHistoryOnLoad: true,
    browserHistoryStoreHistory: false
  },

  // Register service worker (only on production build)
  serviceWorker: process.env.NODE_ENV === 'production' ? {
    path: '/pay/service-worker.js',
  } : {},
});

app.on('connection', function (isOnline) {
  if (isOnline) {
    app.toast.close();
    app.toast.create({
      position: 'top',
      closeTimeout: 4000,
      closeButton: true,
      render: function () {
        return `
        <div class="toast toast-top toast-horizontal-left success toast-with-icon">
          <div class="toast-content">
            <div class="toast-icon">
              <i class="icon material-icons-outline">bigtop_updates</i>
            </div>
            <div class="toast-text">اتصال به اینترنت برقرار شد</div>
            <a class="toast-button button color-white">باشه</a>
          </div>
        </div>
        `;
      }
    }).open();

  } else {
    app.toast.close();
    app.toast.create({
      position: 'top',
      closeTimeout: 0,
      closeButton: true,
      render: function () {
        return `
        <div class="toast toast-top toast-horizontal-left error toast-with-icon">
          <div class="toast-content">
            <div class="toast-icon">
              <i class="icon material-icons-outline">signal_disconnected</i>
            </div>
            <div class="toast-text">به نظر میاد اتصال به اینترنت قطع شده باشه!</div>
            <a class="toast-button button color-white">باشه</a>
          </div>
        </div>
        `;
      }
    }).open();
  }
});