

var Helper = {

  appInstance: null,

  NotificationClient: function (message, type, time) {
    let icon;
    if (type == "error") {
      icon = "error";
    } else if (type == "success") {
      icon = "done_all";
    }

    if (!time) {
      time = 4000;
    }

    this.appInstance.toast.close();
    this.appInstance.toast.create({
      position: 'top',
      closeTimeout: time,
      closeButton: true,
      render: function () {
        return `
        <div class="toast toast-top toast-horizontal-left ${type} toast-with-icon">
          <div class="toast-content">
            <div class="toast-icon">
              <i class="icon material-icons-outline">${icon}</i>
            </div>
            <div class="toast-text">${message}</div>
            <a class="toast-button button color-white">باشه</a>
          </div>
        </div>
        `;
      }
    }).open();
  },

  numberValidate: function (e) {
    let theEvent = e || window.event;

    let key;
    let isPaste = 0;
    if (theEvent.type === 'paste') {
      key = theEvent.originalEvent.clipboardData.getData('text/plain');
      isPaste = 1;
    } else {
      key = theEvent.keyCode || theEvent.which;
      key = String.fromCharCode(key);
    }

    if (this.commonPermitted(e)) return;

    let regex = /^[0-9۰-۹]+$/;
    if (!regex.test(key)) {
      theEvent.returnValue = false;
      if (theEvent.preventDefault) {
        theEvent.preventDefault();
      }

      if (isPaste) {
        let notifyText = "یک یا چند کارکتر غیر مجاز درون متن کپی شده می باشد و اجازه چسباندن وجود ندارد!";
        this.NotificationClient(notifyText, "danger");

        return false;
      }
    }

    return true;
  },

  commonPermitted: function (e) {
    let arr = [
      8, // backspace
      9, // tab
      16, // shift
      17, // ctrl
      35, // end
      36, // home
      37, // left
      39, // right
      // you may want to permit enter/return here too
    ];
    if (arr.indexOf(e.keyCode) != -1)
      return true;
    if (e.ctrlKey && ['a', 'c', 'v', 'x'].indexOf(String.fromCharCode(e.keyCode).toLowerCase()))
      return true;
    return;
  },

  intFormat: function (number) {
    let regex = /(\d)((\d{3},?)+)$/;
    number = number.split(',').join('');

    while (regex.test(number)) {
      number = number.replace(regex, '$1,$2');
    }
    return number;
  },

  numFormat: function (number) {
    let pointReg = /([\d,\.]*)\.(\d*)$/, f;
    if (pointReg.test(number)) {
      f = RegExp.$2;
      return this.intFormat(RegExp.$1) + '.' + f;
    }
    return this.intFormat(number);
  },

  addCommas: function (nStr) {
    nStr += '';
    let x = nStr.split('.');
    let x1 = x[0];
    let x2 = x.length > 1 ? '.' + x[1] : '';
    let rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
      x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
  },

  removeCommas: function (str) {
    while (str.search(",") >= 0) {
      str = (str + "").replace(',', '');
    }
    return str;
  },

  cleanString: function (str) {
    str = str.trim();
    str = str.replaceAll('۰', '0');
    str = str.replaceAll('۱', '1');
    str = str.replaceAll('۲', '2');
    str = str.replaceAll('۳', '3');
    str = str.replaceAll('۴', '4');
    str = str.replaceAll('۵', '5');
    str = str.replaceAll('۶', '6');
    str = str.replaceAll('۷', '7');
    str = str.replaceAll('۸', '8');
    str = str.replaceAll('۹', '9');
    str = str.replaceAll('ي', 'ی');
    str = str.replaceAll('ك', 'ک');
    str = str.replaceAll('ة', 'ه');

    return str;
  },

  NationalCodeValidation: function (input) {
    if (
      !/^[0-9۰-۹]+$/.test(input) ||
      !/^\d{10}$/.test(input) ||
      input == '0000000000' ||
      input == '1111111111' ||
      input == '2222222222' ||
      input == '3333333333' ||
      input == '4444444444' ||
      input == '5555555555' ||
      input == '6666666666' ||
      input == '7777777777' ||
      input == '8888888888' ||
      input == '9999999999') {
      return false;
    }

    var check = parseInt(input[9]);
    var sum = 0;
    var i;
    for (i = 0; i < 9; ++i) {
      sum += parseInt(input[i]) * (10 - i);
    }
    sum %= 11;
    return (sum < 2 && check == sum) || (sum >= 2 && check + sum == 11);
  },

  mobileValidation: function (mobileValue) {
    let Result = { 'result': 0, 'message': '' };

    if (mobileValue.length != 11) {
      Result.message = "تعداد ارقام شماره موبایل صحیح نیست لطفا با صفر ابتدای شماره وارد کنید";
      return Result;
    }

    if ((mobileValue.charAt(0) + mobileValue.charAt(1)) != "09") {
      Result.message = "شماره موبایل باید با 09 شروع شود";
      return Result;
    }

    Result.result = 1;
    return Result;
  },

  EmailValidation: function (emailVal) {
    var pattern = /^[\w.-]+@[a-zA-Z0-9۰-۹_]+?\.[a-zA-Z]{2,7}$/;
    return emailVal.match(pattern);
  }
}

export default Helper;