
import HomePage from '../pages/home.f7.jsx';
import AboutPage from '../pages/about.f7.jsx';
import Conditions from '../pages/conditions.f7.jsx';
import SuccessPayment from '../pages/success-payment.f7.jsx';
import FaildPayment from '../pages/faild-payment.f7.jsx';
import NotFoundPage from '../pages/404.f7.jsx';

import Helper from "../js/helper.js";

var routes = [
  {
    path: '/',
    component: HomePage,
  },
  {
    path: '/paymentfinish/:success/:invoiceNumber/:merchantCode',
    async: function ({ app, to, resolve }) {
      Helper.appInstance = app;

      // loading
      app.dialog.progress("لطفا کمی صبر کنید");

      // data from request
      var Success = to.params.success;
      var invoiceNumber = to.params.invoiceNumber;
      var merchantCode = to.params.merchantCode;

      if (Success == "1") {
        let requestUrl = app.params.endpoint + "remote/invoice.php?in=" + invoiceNumber;
        fetch(requestUrl).then((result) => result.json())
          .then(function (jsonResult) {
            if (!jsonResult.success) {
              resolve({
                content: `
                <div class="page" data-name="faild-payment">
                  <div class="page-content faild-payment">
                    <div class="block block-strong inset">
                      <p class="headtext text-align-center">${jsonResult.message}</p>
                      <div class="block">
                      <a href="/" class="button button-large button-fill">بازگشت</a>
                      </div>
                    </div>
                  </div>
                </div>
                `,
              });

              // hide loading
              app.dialog.close();
              return false;
            }

            jsonResult.data.fares_amount = Helper.addCommas(jsonResult.data.fares_amount);
            jsonResult.data.total_amount = Helper.addCommas(jsonResult.data.total_amount);
            resolve({ component: SuccessPayment, },
              {
                props: {
                  invoice: jsonResult,
                }
              }
            );
          }).catch((error) => {
            Helper.NotificationClient("متاسفانه خطایی رخ داده است؛ مجددا امتحان کنید.", "error");

            //console.log(error);
            // hide loading
            app.dialog.close();

            resolve({
              content: `
              <div class="page" data-name="faild-payment">
                <div class="page-content">
                  <div class="block block-strong inset">
                    <p class="headtext text-align-center">مشکلی در فراخوانی پرداخت شما بوجود آمده است</p>
                    <div class="block">
                    <a href="/" class="button button-large button-fill">بازگشت</a>
                    </div>
                  </div>
                </div>
              </div>
              `,
            });

            return false;
          });
      } else if (Success == "0") {
        resolve({ component: FaildPayment, },
          {
            props: {
              merchantCode: merchantCode,
            }
          }
        );
      }
    }
  },

  {
    path: '/about/',
    component: AboutPage,
  },

  {
    path: '/conditions/',
    component: Conditions,
  },
  {
    path: '(.*)',
    component: NotFoundPage,
  },
];

export default routes;