export default (props, { $f7router, $f7 }) => {
  const merchantCode = props.merchantCode;

  const cancelPayment = () => {
    $f7router.navigate('/#!/',{});
  };

  const retry = () => {
    $f7router.navigate('/#!/',
      {
        props: {
          merchantCode: merchantCode
        }
      }
    );
  };

  setTimeout(() => {
    // hide dialog
    $f7.dialog.close();
  }, 1000);

  return () => (
    <div class="page" data-name="faild-payment">

      <div class="page-content faild-payment">
        <div class="block block-strong inset no-padding-horizontal no-margin top-icon-header">
          <div class="block text-align-center grid grid-col-1">
            <div><img class="result-image" src="./images/cancel.png" /></div>
          </div>
        </div>
        <div class="block block-strong inset result-text white-bg">
          <p class="headtext text-align-center">پرداخت شما تایید نشد</p>
          <p>پرداخت شما لغو شده است اما نگران نباشید در صورت کسر وجه از حساب بانکی شما طی 72 ساعت آینده مبلغ کسر شده به
            حساب شما عودت داده خواهد شد؛ در صورت عدم عودت وجه به حساب تان می توانید این موضوع را با تیم پشتیبانی در میان
            بگذارید.</p>

          <div class="block">
            <div class="grid grid-cols-2 grid-gap">
              <span>
                <button class="button button-large" onclick={cancelPayment}>
                  انصراف از پرداخت
                </button>
              </span>
              <span>
                <button class="button button-large button-fill" onclick={retry}>
                  تلاش مجدد
                </button>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div >
  );
};