import Helper from "../js/helper.js";

export default (props, { $, $update, $f7, $f7route, $onMounted, $onBeforeUnmount }) => {
  let popupPush;
  Helper.appInstance = $f7;

  // Pay checkout Event
  const payCheckout = () => {
    // get mobile value
    let mobileValue = $("input#mobile").val();

    // remove white space
    mobileValue = Helper.cleanString(mobileValue);
    mobileValue = mobileValue.replace(/[\s]+/g, '');

    if (!mobileValue) {
      Helper.NotificationClient("لطفا شماره موبایل خود را وارد کنید", "error");
      return false;
    } else {
      // validate mobile format
      let mobileValidation = Helper.mobileValidation(mobileValue);
      if (mobileValidation.result != 1) {
        Helper.NotificationClient(mobileValidation.message, "error");
        return false;
      }

      // return cleaned string to input value
      $("input#mobile").val(mobileValue);
    }

    // get merchant code
    let merchant_code = $("input#merchant_code").val();

    // remove white space
    merchant_code = Helper.cleanString(merchant_code);
    merchant_code = merchant_code.replace(/[\s]+/g, '');

    if (!merchant_code) {
      Helper.NotificationClient("لطفا کد(شناسه) پذیرنده را وارد کنید", "error");
      return false;
    } else {
      // return cleaned string to input value
      $("input#merchant_code").val(merchant_code);
    }

    // get amount
    let amount = $("input#amount").val();

    // remove white space
    amount = Helper.cleanString(amount);
    amount = amount.replace(/[\s]+/g, '');

    if (!amount) {
      Helper.NotificationClient("لطفا مبلغ را مشخص کنید", "error");
      return false;
    } else {
      // return cleaned string to input value
      $("input#amount").val(amount);
    }

    // destroy toast if any exists
    $f7.toast.close();

    // loading
    $f7.dialog.progress("لطفا کمی صبر کنید");

    let requestUrl = $f7.params.endpoint + "remote/merchant.php?mid=" + merchant_code + "&a=" + amount + "&m=" + mobileValue;
    fetch(requestUrl).then((result) => result.json())
      .then(function (jsonResult) {
        if (!jsonResult.success) {
          Helper.NotificationClient("به نظر میاد کد پذیرنده اشتباه وارد شده! کد پذیرنده را مجددا بررسی کنید", "error");

          // hide loading
          $f7.dialog.close();
          return false;
        }

        let response = jsonResult.data;

        // image
        let imageSrc = response.image;
        if (!imageSrc) {
          imageSrc = "images/default-user.jpg";
        }

        let amountString = Helper.addCommas(response.amount);

        popupPush = $f7.popup.create({
          content: `
          <div class="popup popup-swipe-handler">
            <div class="page">
              <div class="swipe-handler white-bg"></div>
              <div class="page-content white-bg">
                <div class="block-title block-title-large heading"></div>
                <div class="block block-strong-ios block-outline-ios no-padding-left no-padding-right no-padding-top merchant-wrapper">
                  <div class="popup-swipe-header">
                    <div class="merchant-image">
                      <div class="merchant-image-wrapper" style="background-image: url(${imageSrc})"></div>
                    </div>
                  </div>
                  <div class="merchant-name block">
                    <span>${response.name}</span>
                    <span class="field1">.${response.field_1}</span>
                  </div>
                </div>
                <div class="cart-info block">
                  <ul class="leader">
                    <li>
                      <span>تاریخ پرداخت</span>
                      <span class="ltr">${response.date}</span>
                    </li>
                    <li>
                      <span>موبایل شما</span>
                      <span class="ltr">${mobileValue}</span>
                    </li>
                    <li>
                      <span>کد پذیرنده</span>
                      <span class="ltr">${merchant_code}</span>
                    </li>
                    <li>
                      <span>شیوه پرداخت</span>
                      <span class="ltr">پرداخت آنلاین بانکی</span>
                    </li>
                  </ul>

                  <div class="block no-padding amount-wrapper">
                    <div class="amountBox chip grid grid-cols-2">
                      <div class="grid grid-cols-1 amountBoxLabel">
                        <div class="amountLabel">مبلغ پرداختی</div>
                        <div class="wage-tax-label">با احتساب کارمزد + مالیات</div>
                      </div>
                      <div class="amountValue text-align-left">${amountString} تومان</div>
                    </div>
                  </div>

                  <hr class="line-break">

                  <div class="block confirmCheckbox no-padding">
                    <label class="item-checkbox item-checkbox-icon-start item-content display-flex">
                      <input type="checkbox" name="confirm" id="confirm" value="1" />
                      <i class="icon icon-checkbox"></i>
                      <div class="item-inner align-content-center">
                        <div class="item-title">
                          قوانین و مقررات را مطالعه کرده و میپذیرم
                        </div>
                      </div>
                    </label>
                    <a class="chip rules popup-open" href="#" data-popup=".rules-conditions">
                      <span class="chip-label">مطالعه قوانین</span>
                    </a>
                  </div>

                  <div class="block">
                    <button class="button button-large button-tonal paymentTokenBtn">
                      <div class="display-block title">پرداخت آنلاین</div>
                      <div class="display-block subtitle">مبلغ و اطلاعات پذیرنده تایید است</div>
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        `,
          swipeToClose: "to-bottom",
          swipeHandler: ".swipe-handler",
          on: {
            opened: function () {
              $('.paymentTokenBtn').click(function () {
                paymentToken();
              });
            }
          }
        }).open();

        // hide loading
        $f7.dialog.close();

        // Update state to rerender
        $update();
      }).catch((error) => {
        Helper.NotificationClient("متاسفانه خطایی رخ داده است؛ مجددا امتحان کنید.", "error");

        //console.log(error);
        // hide loading
        $f7.dialog.close();
        return false;
      });
  };

  // Refresh Page Event
  const paymentToken = () => {
    let confirm = $('#confirm').is(":checked");
    if (!confirm) {
      Helper.NotificationClient("پرداخت ملزم به پذیرش قوانین می باشد", "error");
      return false;
    }

    // get data
    let mobileValue = $("input#mobile").val();
    let merchant_code = $("input#merchant_code").val();
    let amount = $("input#amount").val();

    // loading
    $f7.dialog.progress("لطفا کمی صبر کنید");

    let requestUrl = $f7.params.endpoint + "remote/token.php?mid=" + merchant_code + "&a=" + amount + "&m=" + mobileValue;
    fetch(requestUrl).then((result) => result.json())
      .then(function (jsonResult) {
        if (!jsonResult.success) {
          Helper.NotificationClient(jsonResult.message, "error");

          // hide loading
          $f7.dialog.close();
          return false;
        }

        let gatewayStartPay = jsonResult.data;
        gatewayStartPay = gatewayStartPay.trim();
        if (!gatewayStartPay) {
          Helper.NotificationClient('آدرس پرداخت صحیح نمی باشد', "error");
          // hide loading
          $f7.dialog.close();
          return false;
        }

        window.location.href = gatewayStartPay;
      }).catch((error) => {
        Helper.NotificationClient("متاسفانه خطایی رخ داده است؛ مجددا امتحان کنید.", "error");

        //console.log(error);
        // hide loading
        $f7.dialog.close();
        return false;
      });
  };

  // Refresh Page Event
  const refreshPage = (e, done) => {
    // Update state to rerender
    $update();

    // When loading done, we need to reset it
    done();

    window.location.reload();
  };

  $onMounted(() => {
    $("input#mobile").on("keypress", function (e) {
      Helper.numberValidate(e);
    }).on("paste", function (e) {
      Helper.numberValidate(e);
    });

    $("input#merchant_code").on("keypress", function (e) {
      Helper.numberValidate(e);
    }).on("paste", function (e) {
      Helper.numberValidate(e);
    });

    let merchantCodeVal = '';
    let merchantCode = '';

    merchantCode = props.merchantCode;
    if (merchantCode) {
      merchantCodeVal = merchantCode.trim();
    } else {
      merchantCode = $f7route.query.mc;
      if (merchantCode) {
        merchantCodeVal = merchantCode.trim();
      }
    }

    if (merchantCodeVal) {
      $("input#merchant_code").val(merchantCodeVal);
    }

    // get params
    let settingUrl = $f7.params.endpoint + "remote/setting.php";
    fetch(settingUrl).then((result) => result.json())
      .then(function (jsonResult) {
        if (!jsonResult.success) {
          return false;
        }

        let response = jsonResult.data;
        if (response.banner) {
          if (response.banner_link) {
            $('.ads_link').attr("href", response.banner_link);
            $('.ads_link').attr("target", '_blank');
            $('.ads_link').addClass("external");
          } else {
            $('.ads_link').removeAttr("target");
            $('.ads_link').removeClass("external");
          }

          $('.ads_image').attr("src", response.banner);
          $('.banner-ads').show();
        }
      }).catch((error) => {
        //console.log(error);
        return false;
      });
  });

  $onBeforeUnmount(() => {
    if (popupPush) popupPush.destroy();
  });

  return () => (
    <div class="page" data-name="home">

      {/* Top Navbar */}
      <div class="navbar">
        <div class="navbar-bg white-bg"></div>
        <div class="navbar-inner">
          <div class="left">
            <img class="logo" src="./icons/192x192.png" />
          </div>
          <div class="right">
            <a href="#" class="link icon-only panel-open" data-panel="right">
              <i class="icon material-icons-outline">menu</i>
            </a>
          </div>
        </div>
      </div>
      {/* Top Navbar */}

      {/* Main page content */}
      <div class="page-content ptr-content" onPtrRefresh={refreshPage}>
        {/* Default pull to refresh preloader */}
        <div class="ptr-preloader">
          <div class="preloader"></div>
          <div class="ptr-arrow"></div>
        </div>
        {/* Default pull to refresh preloader */}

        {/* Card */}
        <div class="card white-bg">
          <div class="card-header">پرداخت آنلاین</div>
          <div class="card-content card-content-padding list">
            <ul class="payFormUl">
              <li class="item-content item-input item-input-outline">
                <div class="item-inner">
                  <div class="item-title item-label">شماره موبایل شما</div>
                  <div class="item-input-wrap">
                    <input class="white-bg ltr" maxlength="11" type="tel" id="mobile" placeholder="09.." />
                    <span class="input-clear-button"></span>
                  </div>
                  <div class="item-input-info">با صفر ابتدای شماره وارد کنید</div>
                </div>
              </li>
              <li class="item-content item-input item-input-outline">
                <div class="item-inner">
                  <div class="item-title item-label">کد پذیرنده</div>
                  <div class="item-input-wrap">
                    <input class="white-bg ltr" type="tel" id="merchant_code" placeholder="****" />
                    <span class="input-clear-button"></span>
                  </div>
                  <div class="item-input-info">کد شناسایی پذیرنده را وارد کنید</div>
                </div>
              </li>
              <li class="item-content no-padding">
                <div class="display-block text-align-center stepper-wrapper">
                  <div class="stepper stepper-fill stepper-init" data-wraps="true" data-autorepeat="true"
                    data-autorepeat-dynamic="true" data-decimal-point="0" data-manual-input-mode="true">
                    <div class="stepper-button-minus"></div>
                    <div class="stepper-input-wrap">
                      <input type="tel" id="amount" value="5000" min="2000" max="40000" step="1000" />
                      <span class="currency">تومان</span>
                    </div>
                    <div class="stepper-button-plus"></div>
                  </div>
                </div>
              </li>
            </ul>
          </div>
          <div class="card-footer no-padding-top">
            <button class="button button-large button-tonal nextStep" onclick={payCheckout}>
              <span>مرحله بعد</span>
              <img class="svgNext" src="images/arrow_left_alt.svg" />
            </button>
          </div>
        </div>
        {/* Card */}

        <div class="card banner-ads" style="display: none;">
          <div class="card-content">
            <a href="javascript:void(0);" class="ads_link">
              <img src="" class="ads_image" title="Advertisement" />
            </a>
          </div>
        </div>
      </div>
      {/* Main page content */}
    </div>
  );
};