export default (props, { $f7router, $f7 }) => {
  const invoice = props.invoice.data;

  const finishBack = () => {
    $f7router.navigate('/#!/', {});
  };

  setTimeout(() => {
    // hide dialog
    $f7.dialog.close();
  }, 1000);

  return () => (
    <div class="page" data-name="success-payment">

      <div class="page-content success-payment">
        <div class="block block-strong inset no-padding-horizontal no-margin top-icon-header">
          <div class="block text-align-center grid grid-col-1">
            <div><img class="result-image" src="./images/checked.png" /></div>
          </div>
        </div>
        <div class="block block-strong inset result-text white-bg">
          <p class="headtext text-align-center">پرداخت موفق</p>
          <p>پرداخت شما به مبلغ {invoice.total_amount} تومان به شماره فاکتور {invoice.invoice_number} با موفقیت انجام شد</p>

          <div class="invoice-info block">
            <ul class="leader">
              <li>
                <span>پذیرنده</span>
                <span class="">{invoice.name} <span class="muted small">.{invoice.field_1}</span></span>
              </li>
              <li>
                <span>شماره فاکتور</span>
                <span class=""><b>{invoice.invoice_number}</b></span>
              </li>
              <li>
                <span>تاریخ پرداخت</span>
                <span class="ltr">{invoice.created_on}</span>
              </li>
            </ul>
          </div>

          <div class="block">
            <div class="grid grid-cols-1 grid-gap">
              <span>
                <button class="button button-large button-fill" onclick={finishBack}>
                  بازگشت به صفحه اصلی
                </button>
              </span>
            </div>
          </div>
        </div>
      </div>
    </div >
  );
};